/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/user.h>

struct messaging::User::Private
{
    std::string display_name;
    messaging::VariantMap properties;
};

messaging::User::User(std::string id, std::string display_name, messaging::VariantMap properties)
        : Recipient{id}, impl{new Private{display_name, properties}}
{
}

messaging::RecipientType messaging::User::type() const
{
    return RecipientType::user;
}

std::string messaging::User::display_name() const
{
    return impl->display_name;
}

messaging::VariantMap messaging::User::properties() const
{
    return impl->properties;
}

