/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/tp/adapter.h>
#include <messaging/qt/tp/protocol.h>

#include <messaging/qt/runtime.h>

namespace
{
QString s2q(const std::string& in)
{
    return QString::fromStdString(in);
}

Tp::BaseProtocolPtr make_protocol(const std::shared_ptr<messaging::Connector>& connector,
                                  const std::shared_ptr<messaging::qt::Runtime>& runtime,
                                  const QString& cm_name,
                                  const QString& p_name)
{
    return Tp::BaseProtocolPtr{new messaging::qt::tp::Protocol(connector, runtime, cm_name, p_name)};
}

Tp::BaseConnectionManagerPtr make_cm(const QDBusConnection& conn, const QString& name)
{
    return Tp::BaseConnectionManager::create(conn, name);
}
}

messaging::qt::tp::Adapter::Adapter(const std::shared_ptr<messaging::qt::Runtime>& runtime,
                                    const std::shared_ptr<messaging::Connector>& connector,
                                    const std::string& connection_manager_name,
                                    const std::string& protocol_name)
    : ti{tp::Initializer::Configuration{}}
    , runtime{runtime}
    , connector{connector}
    , protocol{make_protocol(connector, runtime, s2q(connection_manager_name), s2q(protocol_name))}
    , connection_manager{make_cm(runtime->dbus_connection(), s2q(connection_manager_name))}
{
    connection_manager->addProtocol(protocol);
    if (not connection_manager->registerObject())
        throw std::runtime_error{"Could not register connection manager on the bus."};
}
