/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/parameter.h>

#include <messaging/dictionary.h>
#include <messaging/variant.h>

bool messaging::Parameter::can_extract_from(const messaging::Dictionary<std::string, messaging::Variant>& dict) const
{
    return dict.has_value_for_key(name);
}

const messaging::Variant& messaging::Parameter::extract_from(
    const messaging::Dictionary<std::string, messaging::Variant>& dict) const
{
    return dict.value_for_key(name);
}

messaging::Parameter::Flags messaging::operator|(messaging::Parameter::Flags lhs, messaging::Parameter::Flags rhs)
{
    typedef typename std::underlying_type<messaging::Parameter::Flags>::type Numeric;
    return static_cast<messaging::Parameter::Flags>(static_cast<Numeric>(lhs) | static_cast<Numeric>(rhs));
}

messaging::Parameter::Flags messaging::operator&(messaging::Parameter::Flags lhs, messaging::Parameter::Flags rhs)
{
    typedef typename std::underlying_type<messaging::Parameter::Flags>::type Numeric;
    return static_cast<messaging::Parameter::Flags>(static_cast<Numeric>(lhs) | static_cast<Numeric>(rhs));
}
