#include <messaging/member.h>

struct messaging::Member::Private
{
    messaging::PendingStatus pending_status;
    messaging::Flags<messaging::Role> roles;
};

messaging::Member::Member(std::string id,
                          PendingStatus pending_list,
                          Flags<Role> roles,
                          std::string display_name,
                          VariantMap properties)
        : User{id, display_name, properties}, impl{new Private{pending_list, roles}}
{
}

messaging::PendingStatus messaging::Member::pending_status() const
{
    return impl->pending_status;
}

messaging::Flags<messaging::Role> messaging::Member::roles() const
{
    return impl->roles;
}

