/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/connector_factory_initializer.h>

#include <messaging/associative_connector_factory.h>

#include <messaging/plugin_connector.h>

std::shared_ptr<messaging::ConnectorFactory> messaging::ConnectorFactoryInitializer::initialize() const
{
    auto result = std::make_shared<messaging::AssociativeConnectorFactory>();

    result->add_generator_for_name(messaging::PluginConnector::Descriptor::name,
                                   messaging::PluginConnector::Descriptor::generator());

    return result;
}
