/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/chat.h>

#include <messaging/interface.h>

#include <set>

struct messaging::Chat::Private
{
    std::shared_ptr<messaging::Chat::Observer> observer;
};

messaging::Chat::Chat(const std::shared_ptr<messaging::Chat::Observer>& observer)
        : impl{new Private{observer}}
{
}

void messaging::Chat::announce_message_delivery_report(const std::string& id, DeliveryStatus status)
{
    impl->observer->on_message_delivery_report(id, status);
}

void messaging::Chat::announce_message_received(const messaging::Message& msg)
{
    impl->observer->on_message_received(msg);
}

void messaging::Chat::announce_message_id_changed(const std::string &old_id, const std::string &new_id)
{
    impl->observer->on_message_id_changed(old_id, new_id);
}

void messaging::Chat::announce_file_receiving(const std::string& id, uint transfer_size, uint total_size)
{
    impl->observer->on_file_receiving(id, transfer_size, total_size);
}

void messaging::Chat::announce_file_received(const std::string& id, uint transfer_size, uint total_size)
{
    impl->observer->on_file_received(id, transfer_size, total_size);
}

void messaging::Chat::announce_file_sending(const std::string& id, uint transfer_size, uint total_size)
{
    impl->observer->on_file_sending(id, transfer_size, total_size);
}

void messaging::Chat::announce_participant_starts_typing(const std::shared_ptr<User> &user)
{
    impl->observer->on_participant_starts_typing(user);
}

void messaging::Chat::announce_participant_ends_typing(const std::shared_ptr<User> &user)
{
    impl->observer->on_participant_ends_typing(user);
}
