/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_UTILS_H
#define MESSAGING_UTILS_H

#include <messaging/visibility.h>
#include <memory>
#include <QSet>
#include <QStringList>
#include <messaging/members.h>

namespace messaging
{

#define DEFINE_PTRS(classname)               \
    typedef std::shared_ptr<classname>       SPtr;  \
    typedef std::shared_ptr<classname const> SCPtr; \
    typedef std::unique_ptr<classname>       UPtr;  \
    typedef std::unique_ptr<classname const> UCPtr

QStringList MESSAGING_FW_PUBLIC ids_to_add(const QSet<QString> &original_ids_list, const Members& users);
QStringList MESSAGING_FW_PUBLIC ids_to_remove(const QSet<QString> &original_ids_list, const Members& users);

}

#endif // MESSAGING_UTILS_H
