/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_API_RECIPIENT_H
#define MESSAGING_API_RECIPIENT_H

#include <memory>
#include <messaging/visibility.h>

namespace messaging
{

enum RecipientType
{
    user,       ///< the peer is a user
    group,      ///< the peer is a group
    broadcast   ///< the peer is a broadcast group
};

class MESSAGING_FW_PUBLIC Recipient
{
public:
    virtual std::string id() const;
    virtual RecipientType type() const = 0;

    typedef std::shared_ptr<Recipient> shared_ptr;
protected:
    Recipient(const std::string &id);
    /// @cond
    struct Private;
    std::shared_ptr<Private> impl;
    /// @endcond
};

}

#endif  // MESSAGING_API_RECIPIENT_H
