/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_MESSAGE_H_
#define MESSAGING_QT_TP_MESSAGE_H_

namespace messaging
{
namespace qt
{
namespace tp
{
/// @brief message bundles all constants helpful in interacting with telepathy messages.
namespace message
{
/// @brief Index enumerates well-known indices into a telepathy message.
enum Index
{
    header = 0,  ///< The header of the message is expected here.
    body = 1     ///< The body of the message starts at this index.
};
/// @brief keys bundles all well-known keys defined for a body part.
namespace keys
{
/// @brief content_type refers to the mimetype of the actual content contained in the message.
static constexpr const char* content_type{"content-type"};
/// @brief content refers to the actual content contained in the message.
static constexpr const char* content{"content"};
/// @brief identifier refers to the identifier of this message part.
static constexpr const char* identifier{"identifier"};
/// @brief needs_retrieval is used to check if a file needs to be retrieved.
static constexpr const char* needs_retrieval{"needs-retrieval"};
/// @brief size is the length of the file that needs to be retrieved.
static constexpr const char* size{"size"};
/// @brief filename is the file path of the file that will be retrieved.
static constexpr const char* filename{"filename"};
}
}
}
}
}

#endif  // MESSAGING_QT_TP_MESSAGE_H_
