/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_TYPES_H
#define MESSAGING_QT_TP_INTERFACES_TYPES_H

#include <messaging/visibility.h>

#include <QMap>
#include <TelepathyQt/Types>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

class BaseChannelDestroyableInterface;
class BaseChannelRolesInterface;
class BaseChannelSubjectInterface;

typedef Tp::SharedPtr<BaseChannelDestroyableInterface> BaseChannelDestroyableInterfacePtr;
typedef Tp::SharedPtr<BaseChannelRolesInterface> BaseChannelRolesInterfacePtr;
typedef Tp::SharedPtr<BaseChannelSubjectInterface> BaseChannelSubjectInterfacePtr;

/**
 * \struct HandleRolesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 *
 * A map from channel-specific handles to their owners.
 */
struct MESSAGING_FW_PUBLIC HandleRolesMap : public QMap<uint, uint>
{
    inline HandleRolesMap() : QMap<uint, uint>() {}
    inline HandleRolesMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline HandleRolesMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

}
}
}
}

Q_DECLARE_METATYPE(messaging::qt::tp::interfaces::HandleRolesMap)

#endif // MESSAGING_QT_TP_INTERFACES_TYPES_H

