/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_CONSTANTS_H
#define MESSAGING_QT_TP_INTERFACES_CONSTANTS_H

#include <TelepathyQt/Types>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Roles" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_ROLES (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Roles"))

/**
 * \ingroup flagtypeconsts
 */
enum ChannelRole
{
    /**
     * The Member role represents regular users with limited permissions.
     */
    ChannelRoleMember = 1,

    /**
     * The Admin role represents privileged users with all permissions
     */
    ChannelRoleAdmin = 2,

    _ChannelRolePadding = 0xffffffffU
};

/**
 * \typedef QFlags<ChannelRole> ChannelRoles
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ChannelRole values.
 */
typedef QFlags<ChannelRole> ChannelRoles;
Q_DECLARE_OPERATORS_FOR_FLAGS(ChannelRoles)

}
}
}
}

Q_DECLARE_METATYPE(messaging::qt::tp::interfaces::ChannelRoles)
#endif // MESSAGING_QT_TP_INTERFACES_CONSTANTS_H

