/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_CHANNEL_INTERFACE_ROLES_ADAPTOR_H
#define MESSAGING_QT_TP_INTERFACES_CHANNEL_INTERFACE_ROLES_ADAPTOR_H

#include <TelepathyQt/Types>
#include <TelepathyQt/AbstractAdaptor>

#include <messaging/visibility.h>
#include <messaging/qt/tp/interfaces/types.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

/**
 * \class ChannelInterfaceRolesAdaptor
 * \headerfile TelepathyQt/_gen/svc-channel.h <TelepathyQt/_gen/svc-channel.h>
 * \ingroup servicechannel
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Roles".
 */
class MESSAGING_FW_LOCAL ChannelInterfaceRolesAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Channel.Interface.Roles")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Channel.Interface.Roles\">\n"
"    <property access=\"read\" type=\"a{uu}\" name=\"Roles\">\n"
"      <annotation value=\"HandleRolesMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"b\" name=\"CanUpdateRoles\"/>\n"
"    <method name=\"UpdateRoles\">\n"
"      <arg direction=\"in\" type=\"a{uu}\" name=\"contactroles\">\n"
"        <annotation value=\"HandleRolesMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"RolesChanged\">\n"
"      <arg type=\"a{uu}\" name=\"added\">\n"
"        <annotation value=\"HandleRolesMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"a{uu}\" name=\"removed\">\n"
"        <annotation value=\"HandleRolesMap\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(HandleRolesMap Roles READ Roles)
    Q_PROPERTY(bool CanUpdateRoles READ CanUpdateRoles)
public:
    ChannelInterfaceRolesAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ChannelInterfaceRolesAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > UpdateRolesContextPtr;

public: //PROPERTIES
    HandleRolesMap Roles() const;
    bool CanUpdateRoles() const;

public Q_SLOTS: // METHODS
    void UpdateRoles(const HandleRolesMap& contactRoles, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    void RolesChanged(const HandleRolesMap& added, const HandleRolesMap& removed);
};

}
}
}
}
#endif // MESSAGING_QT_TP_INTERFACES_CHANNEL_INTERFACE_ROLES_ADAPTOR_H

