/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_DESTROYABLE_H_
#define MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_DESTROYABLE_H_

#include <TelepathyQt/BaseChannel>
#include <messaging/visibility.h>

#include <messaging/qt/tp/interfaces/types.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

class MESSAGING_FW_LOCAL BaseChannelDestroyableInterface : public Tp::AbstractChannelInterface
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseChannelDestroyableInterface)

public:
    static BaseChannelDestroyableInterfacePtr create() {
        return BaseChannelDestroyableInterfacePtr(new BaseChannelDestroyableInterface());
    }
    template<typename BaseChannelDestroyableInterfaceSubclass>
    static Tp::SharedPtr<BaseChannelDestroyableInterfaceSubclass> create() {
        return Tp::SharedPtr<BaseChannelDestroyableInterfaceSubclass>(
                   new BaseChannelDestroyableInterfaceSubclass());
    }
    virtual ~BaseChannelDestroyableInterface();

    QVariantMap immutableProperties() const;

    void destroy();

    typedef Tp::Callback1<void, Tp::DBusError*> DestroyCallback;
    void setDestroyCallback(const DestroyCallback &cb);
private:
    BaseChannelDestroyableInterface();
    void createAdaptor();

    class Adaptee;
    friend class Adaptee;
    struct Private;
    friend struct Private;
    Private *mPriv;
};

}
}
}
}

#endif // MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_DESTROYABLE_H_
