/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_API_PRESENCE_H
#define MESSAGING_API_PRESENCE_H

#include <messaging/visibility.h>
#include <string>

namespace messaging
{

enum class PresenceType
{
    unset,          /// < @brief An invalid presence type used as a null value
    offline,        /// < @brief offline
    available,      /// < @brief available
    away,           /// < @brief away
    extended_away,  /// < @brief Away for an extended time
    hidden,         /// < @brief Hidden (invisible)
    busy,           /// < @brief Busy, Do Not Disturb.
    unknown,        /// < @brief Unknown, unable to determine presence for this contact, for example if the protocol only allows presence of subscribed contacts.
    error           /// < @brief Error, an error occurred while trying to determine presence. The message, if set, is an error from the server.
};

struct StatusSpec
{
    enum class Flags
    {
        none = 0,
        may_set_on_self = 1 << 0,
        can_have_message = 1 << 1
    };

    PresenceType type;
    Flags flags;
};

struct Presence
{
    PresenceType type;
    std::string status;
    std::string status_message;
};

// Define bitfield operations on Parameter::Flags
MESSAGING_FW_PUBLIC StatusSpec::Flags operator|(StatusSpec::Flags lhs, StatusSpec::Flags rhs);
MESSAGING_FW_PUBLIC StatusSpec::Flags operator&(StatusSpec::Flags lhs, StatusSpec::Flags rhs);
}

#endif // MESSAGING_API_PRESENCE_H
