/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_API_MESSAGE_H
#define MESSAGING_API_MESSAGE_H

#include <messaging/boost/variant.h>

#include <chrono>
#include <string>

namespace messaging
{
// A handy fwd decl.
class Variant;

enum class DeliveryStatus
{
    unknown = 0, ///< message's disposition is unknown
    delivered = 1, ///< delivered to the intended recipient
    temporaly_failed = 2, ///< failed but may automatically try sending another copy of the message
    permanently_failed = 3, ///< failed. Any retry will result in this same error
    accepted = 4, ///< an intermediate server has accepted the message but it is not delivered yet
    read = 5, ///< read by the intended recipient
    deleted = 6 ///< deleted by the intended recipient
};

enum class AttachmentStatus
{
    AttachmentDownloaded,
    AttachmentPending,
    AttachmentError
};

struct Attachment
{
    std::string id;
    std::string name;
    std::string content_type;
    std::shared_ptr<Variant> content;
    std::uint64_t size;
    AttachmentStatus status;
    std::shared_ptr<Variant> thumbnail;
};

struct Message
{
    std::string id;
    std::string sender;
    std::string message;
    std::chrono::system_clock::time_point when;
    std::vector<Attachment> attachments;
};

MESSAGING_FW_PUBLIC std::ostream& operator<<(std::ostream& out, DeliveryStatus status);

}

#endif  // MESSAGE_H
