/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_DYNAMIC_LIBRARY_H_
#define MESSAGING_DYNAMIC_LIBRARY_H_

#include <messaging/named_symbol_loader.h>
#include <messaging/visibility.h>

#include <boost/filesystem.hpp>

namespace messaging
{
/// @brief DynamicLibrary implements NamedSymbolLoader, resolving named symbols from dynamic libraries.
///
/// On destruction, the class gives up the contained handle and closes the underlying dynamic library.
/// With that, calling code is responsible for keeping an instance of DynamicLibrary around until
/// no more code is going to access any loaded symbol.
class MESSAGING_FW_PUBLIC DynamicLibrary : public NamedSymbolLoader
{
public:
    /// @brief Constructs a new instance, trying to load the dynamic library pointed to by path.
    /// @throws std::runtime_error in case of errors.
    DynamicLibrary(const boost::filesystem::path& path);

    /// @brief Tries to load the symbol with the given name from the open dynamic library.
    /// @brief Throws std::runtime_error to indicate missing symbols or general issues.
    void* load_symbol_for_name(const std::string& name) const override;

private:
    std::shared_ptr<void> handle;
};
}

#endif  // MESSAGING_DYNAMIC_LIBRARY_H_
