/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_CONNECTOR_FACTORY_INITIALIZER_H
#define MESSAGING_CONNECTOR_FACTORY_INITIALIZER_H

#include <messaging/visibility.h>

#include <memory>

namespace messaging
{
// A handy forward declaration.
class ConnectorFactory;

/// @brief ConnectorFactoryInitializer takes care of injecting known,
/// in-tree Connector implementations into a ConnectorFactory instance.
struct MESSAGING_FW_PUBLIC ConnectorFactoryInitializer
{
    /// @brief initialize returns an instance of ConnectorFactory that
    /// contains all well-known in-tree messaging::Connector implementations.
    /// @param in dictionary Associative container that carries over arbitrary
    /// key-value pairs.
    std::shared_ptr<ConnectorFactory> initialize() const;
};
}

#endif  // MESSAGING_CONNECTOR_FACTORY_INITIALIZER_H
