/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_CONNECTOR_FACTORY_H
#define MESSAGING_CONNECTOR_FACTORY_H

#include <messaging/non_copyable.h>
#include <messaging/non_movable.h>

#include <functional>
#include <memory>
#include <string>

namespace messaging
{
// A handy forward decl.
class Connector;
template <typename, typename>
class Dictionary;

/// @brief ConnectorFactory abstracts creation of Connector instances for a given name.
class ConnectorFactory : NonCopyable, NonMovable
{
public:
    /// @brief Generator is a functor that creates a Connector instance, reading
    /// parameters from the given Dictionary.
    typedef std::function<std::shared_ptr<Connector>(const Dictionary<std::string, std::string>&)> Generator;

    /// @brief create_instance_for_name returns a new Connector instance with the given name.
    /// @throws std::out_of_range if name is not known.
    virtual Generator create_instance_for_name(const std::string& name) const = 0;

protected:
    // Only subclasses can instantiate.
    ConnectorFactory() = default;
};
}

#endif  // MESSAGING_CONNECTOR_FACTORY_H
