/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_CONNECTOR_H_
#define MESSAGING_CONNECTOR_H_

#include <messaging/messenger.h>
#include <messaging/presence_manager.h>
#include <messaging/group_starter.h>
#include <messaging/connection.h>
#include <messaging/non_copyable.h>
#include <messaging/non_movable.h>

#include <memory>
#include <map>

namespace messaging
{
// handy forward declaration
template <typename, typename>
class Dictionary;
template <typename>
class Enumerator;
struct Parameter;
class Variant;

/// @brief Connector abstracts creation of Connection instances.
class Connector : NonCopyable, NonMovable
{
public:
    /// @brief parameters returns an enumerator listing all the parameters known to the connector impl.
    virtual const Enumerator<Parameter>& parameters() const = 0;

    /// @brief run hands a thread of execution to the implementation.
    virtual void run() = 0;

    /// @brief stop requests the connector to shut down and give up the
    /// thread of execution handed via run.
    virtual void stop() = 0;

    /// @brief connect creates a connection with all the available directly or indirectly api operations
    virtual std::shared_ptr<Connection> request_connection(const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
                                                const std::shared_ptr<messaging::Messenger::Observer>& messenger_observer,
                                                const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer,
                                                const messaging::Dictionary<std::string, messaging::Variant>& dict) = 0;

protected:
    // Only subclasses can instantiate.
    Connector() = default;
};
}

#endif  // MESSAGING_CONNECTOR_H_
