/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_ASSOCIATIVE_DICTIONARY_H_
#define MESSAGING_ASSOCIATIVE_DICTIONARY_H_

#include <messaging/dictionary.h>
#include <messaging/visibility.h>

#include <map>
#include <type_traits>

namespace messaging
{
template <typename Key, typename Value, typename ValueInterface = Value>
class MESSAGING_FW_PUBLIC AssociativeDictionary : public Dictionary<Key, ValueInterface>
{
public:
    static_assert(std::is_base_of<ValueInterface, Value>::value || std::is_same<ValueInterface, Value>::value,
                  "ValueInterface has to be a base of Value");
    // From Dictionary.
    bool has_value_for_key(const Key& key) const override
    {
        return data.count(key) > 0;
    }

    const ValueInterface& value_for_key(const Key& key) const override
    {
        return data.at(key);
    }

    // Alters the dictionary, setting the given key to the given value.
    void set_value_for_key(const Key& key, const Value& value)
    {
        data.insert(std::make_pair(key, value));
    }

private:
    std::map<Key, Value> data;
};
}

#endif  // MESSAGING_ASSOCIATIVE_DICTIONARY_H_
