/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package mediathek.io.starter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.gui.dialoge.DialogProgSimmulieren;

/**
 *
 * @author emil
 */
class RuntimeExec {

    private static final int INPUT = 1;
    private static final int ERROR = 2;
    private Daten daten;
    private String url;
    private String prog;
    Thread clearIn;
    Thread clearOut;
    private Process process = null;
//    private EventListenerList listeners = new EventListenerList();
    private boolean beendenMelden = true;

    /**
     * Neue Klasse instanzieren
     */
    public RuntimeExec(Daten d, Starts s) {
        daten = d;
        url = s.film.arr[Konstanten.FILM_URL_NR];
        prog = s.prog;
    }

    /**
     * Neue Klasse instanzieren
     */
    public RuntimeExec(Daten d, String u, String p) {
        daten = d;
        url = u;
        prog = p;
    }

    //===================================
    // Public
    //===================================
//    /**
//     * Listener hinzufügen, informiert über Änderungen am Status der Downloads
//     * @param listener
//     */
//    public void addListener(RuntimeListener listener) {
//        listeners.add(RuntimeListener.class, listener);
//    }

    /**
     * Download starten
     */
    public Process exec() {
        try {
            if (daten.simmulieren) {
                if (daten.dialogLog == null) {
                    daten.dialogLog = new DialogProgSimmulieren(null, false);
                }
                daten.dialogLog.setVisible(true);
                daten.dialogLog.addText(url, prog);
            } else {
                daten.fehler.systemMeldung("========================================");
                daten.fehler.systemMeldung("Programm starten:");
                daten.fehler.systemMeldung(prog);
                process = Runtime.getRuntime().exec(prog);

////                //so gehts
////                String[] cmds = {"/bin/sh", "-c", "/mnt/daten/software/bin/rtmpdump/rtmpdump -r 'rtmpt://ndr.fcod.llnwd.net/a3715/d1/flashmedia/streams/ndr/2010/0511/TV-20100511-2329-5701.hq.mp4' | /usr/bin/mplayer -"};
////                for (int i = 0; i < cmds.length; ++i) {
////                    daten.fehler.systemMeldung(cmds[i]);
////                }
////                process = Runtime.getRuntime().exec(cmds);

// /mnt/daten/software/bin/flvstreamer/flvstreamer --host swr.fcod.llnwd.net --app a4332/e6/ --playpath swr-fernsehen/2plusleif/2010/07/374799.m -o "/tmp/fi lm/2plusLeif-Wer_sich_kennt_ist_sich_nicht_mehr_fremd" --resume
//                String[] cmds = {"/mnt/daten/software/bin/flvstreamer/flvstreamer",
//                                 "--host swr.fcod.llnwd.net --app a4332/e6/ --playpath swr-fernsehen/2plusleif/2010/07/374799.m -o '/tmp/fi lm/2plusLeif-Wer_sich_kennt_ist_sich_nicht_mehr_fremd' --resume"};
//                String cmd = "/mnt/daten/software/bin/flvstreamer/flvstreamer --host swr.fcod.llnwd.net --app a4332/e6/ --playpath swr-fernsehen/2plusleif/2010/07/374799.m -o \"\"/tmp/fi lm/2plusLeif-Wer_sich_kennt_ist_sich_nicht_mehr_fremd\"\" --resume";
//                process = Runtime.getRuntime().exec(cmd);

                clearIn = new Thread(new ClearInOut(INPUT, process));
                clearOut = new Thread(new ClearInOut(ERROR, process));
                clearIn.start();
                clearOut.start();
            }
        } catch (IOException ex) {
            //bescheid geben
            if (process == null) {
                //Fehler es läuft auch nichts
//                notifyEvent();
            }
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Fehler beim Starten", JOptionPane.ERROR_MESSAGE);
        }
        return process;
    }

    //===================================
    // Private
    //===================================
//    private String[] inArr(String str) {
//        String[] ret = null;
//        LinkedList<String> liste = new LinkedList<String>();
//        str = str.trim();
//        while (str.contains(" ")) {
//            liste.add(str.substring(0, str.indexOf(" ")));
//            str = str.substring(str.indexOf(" ") + 1);
//        }
//        ret = new String[liste.size()];
//        for (int i = 0; i < liste.size(); ++i) {
//            ret[i] = liste.get(i);
//        }
//        return ret;
//    }
//    private void notifyEvent() {
//        if (beendenMelden) {
//            beendenMelden = false;
//            RuntimeExecEvent event;
//            event = new RuntimeExecEvent(this);
//            for (RuntimeListener l : listeners.getListeners(RuntimeListener.class)) {
//                l.starter(event);
//            }
//        }
//    }

    private class ClearInOut implements Runnable {

        private int art;
        private BufferedReader buff;
        private InputStream in;
        private Process process;

        public ClearInOut(int a, Process p) {
            art = a;
            process = p;
        }

        @Override
        public void run() {
            String titel = "";
            try {
                switch (art) {
                    case INPUT:
                        in = process.getInputStream();
                        titel = "INPUTSTREAM";
                        break;
                    case ERROR:
                        in = process.getErrorStream();
                        titel = "ERRORSTREAM";
                        break;
                }
                buff = new BufferedReader(new InputStreamReader(in));
                String inStr;
                while ((inStr = buff.readLine()) != null) {
                    if (daten.dialogFehler != null) {
                        daten.fehler.playerMeldung(titel, inStr);
                    }
                }
            } catch (IOException ex) {
                ///würde beim Abbrechen passieren
//                new Fehler(daten).fehlermeldung_debug(ex, "RuntimeExec.ClearInOut.run-1");
            } finally {
                try {
//                    notifyEvent();
                    buff.close();
                } catch (IOException ex) {
//                    new Fehler(daten).fehlermeldung_debug(ex, "RuntimeExec.ClearInOut.run-2");
                }
            }
        }

    }

}
