/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.BeobFilmeLaden;

public class MediathekNoGui {

    private Daten daten;
    private Date startZeit = new Date(System.currentTimeMillis());
    private Date stopZeit = null;
    private String output = "";

    public MediathekNoGui(String[] ar) {
        boolean debug = false;
        boolean update = false;
        String pfad = "";
        if (ar != null) {
            if (ar.length > 0) {
                if (!ar[0].startsWith("-")) {
                    if (!ar[0].endsWith(File.separator)) {
                        ar[0] += File.separator;
                    }
                    pfad = ar[0];
                }
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-D")) {
                    debug = true;
                }
                if (ar[i].equals("-update")) {
                    update = true;
                }
                if (ar[i].equalsIgnoreCase("-o")) {
                    if (ar.length > i) {
                        output = ar[i + 1];
                    }
                }
            }
        }
        daten = new Daten(pfad, debug, null, true /*noGui*/);
        // hier ist Standard alles zu laden, nur wenn explizit angegeben wird nur upgedatet
        daten.allesLaden = !update;
        daten.keinFehlerFenster = true; //in diesem Modus keine Fehler anzeigen
        System.out.println("");
        System.out.println("========================================");
        System.out.println(Konstanten.Programmname + " " + Konstanten.VERSION);
        if (daten.allesLaden) {
            System.out.println("Laden: alles");
        } else {
            System.out.println("Laden: nur update");
        }
        System.out.println("========================================");
        System.out.println("");
        initListener();
        daten.filmeLaden.filmeBeimSenderLaden();
    }

    private void initListener() {
        //zum Laden
        daten.filmeLaden.addAdListener(new BeobachterLadenFilme());
    }

    private void undTschuess() {
//        daten.ioXml.filmeSchreiben(); // macht filmeLaden schon
        if (!output.equals("")) {
            //datei schreiben
            daten.ioXml.exportFilme(output);
        }
        stopZeit = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        int minuten = 0;
        try {
            minuten = Math.round((stopZeit.getTime() - startZeit.getTime()) / (1000 * 60));
        } catch (Exception ex) {
            minuten = -1;
        }
        System.out.println("");
        System.out.println("========================================");
        System.out.println("  " + daten.filmeLaden.getSeitenZaehlerLauf() + " Seiten geladen");
        System.out.println("  " + daten.filmeLaden.listeFilmeSchattenliste.size() + " Filme gesamt");
        System.out.println("  --> Beginn: " + sdf.format(startZeit));
        System.out.println("  --> Fertig: " + sdf.format(stopZeit));
        System.out.println("  --> Dauer[Min]: " + minuten);
        System.out.println("========================================");
        if (daten.filmeLaden.listeFilmeSchattenliste.isEmpty()) {
            //Satz mit x, war wohl nix
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    private synchronized void progressBar(int max, int progress) {
        int proz = 0;
        String text = "";
        if (max != 0) {
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (max > 0 && proz == 100) {
                proz = 99;
            }
            text = "  [ ";
            int a = proz / 10;
            for (int i = 0; i < a; ++i) {
                text += "#";
            }
            for (int i = 0; i < (10 - a); ++i) {
                text += "-";
            }
            text += " ]  " + daten.filmeLaden.getSeitenZaehlerLauf() + " Seiten  /  " + proz + "% von " + max + " Themen  /  Filme: " + daten.filmeLaden.listeFilmeSchattenliste.size() + "\r";
            daten.fehler.progressMeldung(text);
        }
    }

    private class BeobachterLadenFilme extends BeobFilmeLaden {

        @Override
        public void initProgressBar(String sender, int threads, int max, int progress, String text) {
            progressBar(max, progress);
        }

        @Override
        public void beenden() {
            undTschuess();
        }
    }
}
