/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.daten.DatenPod;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.io.starter.Starts;
import mediathek.TModel;
import mediathek.beobachter.DownloadCellRenderer;
import mediathek.filme.DatenFilm;
import mediathek.gui.dialoge.DialogPod;
import mediathek.gui.dialoge.DialogPodBasis;
import mediathek.gui.dialoge.DialogPodster;
import mediathek.filme.FilmListener;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;

public class GuiPodder extends PanelVorlage {

    private TModel tModel1;
    private TModel tModel2;
    private BeobachterTableSelect1 beobachterTableSelect1;

    public GuiPodder(Daten d) {
        super(d);
        initComponents();
        jProgressBar1.setVisible(false);
        jButtonStop.setVisible(false);
        jButtonNeu.addActionListener(new BeobachterNeu());
        jButtonLoeschen.addActionListener(new BeobLoeschen());
        jButtonAendern.addActionListener(new BeobAendern());
        jButtonSuchen.addActionListener(new BeobSuchen());
        jButtonDownloaden.addActionListener(new BeobDownloadAll());
        jButtonDownloadLoeschen.addActionListener(new BeobDownloadLoeschen(false));
        jButtonDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
        jButtonAufraeumen.addActionListener(new BeobAufraeumen());
        jButtonPodster.addActionListener(new BeobPodster());
        jButtonStop.addActionListener(new BeobPodsStop());
        daten.starterClass.addListener(new BeobStart());
        jTable1.addMouseListener(new BeobMausTabelle1(jTable1));
        beobachterTableSelect1 = new BeobachterTableSelect1();
        jTable1.getSelectionModel().addListSelectionListener(beobachterTableSelect1);
        jTable2.addMouseListener(new BeobMausTabelle2(jTable2));
        jProgressBar1.setForeground(new java.awt.Color(102, 153, 255));
        daten.feedReaderPods.addAdListener(new BeobachterLaden());
        load1();
    }
    //===================================
    // public
    //===================================

    @Override
    public void neuLaden() {
    }

    public static boolean downloadAll(Daten daten, TModel tMod) {
        //liefert false, wenn es nichts zu laden gibt
        boolean ret = false;
        String ordner = "";
        String url = "";
        if (tMod != null) {
            LinkedList<Starts> startsListe = new LinkedList<Starts>();
            for (int i = 0; i < tMod.getRowCount(); ++i) {
                ordner = (tMod.getValueAt(i, Konstanten.FILM_ZIEL_PFAD_NR).toString());
                url = (tMod.getValueAt(i, Konstanten.FILM_URL_NR).toString());
                //DatenFilm(Daten ddaten, String ssender, String tthema, String ttitel, String uurl, String zielPfad) {
                DatenFilm film = new DatenFilm(daten, Konstanten.SENDER_PODCAST/*Sender*/,
                        (tMod.getValueAt(i, Konstanten.FILM_THEMA_NR).toString())/*tthema*/,
                        (tMod.getValueAt(i, Konstanten.FILM_TITEL_NR).toString()) /*ttitel*/,
                        url /*url*/,
                        "");
                Starts starts = new Starts(Starts.QUELLE_PODCAST, film, Starts.ART_DOWNLOAD, "", false);
                starts.film.dateiNamenBauen(ordner, film.arr[Konstanten.FILM_ZIEL_DATEI_NR]);
                //hinzufügen
                startsListe.add(starts);
                ret = true;
            }
            daten.starterClass.addListe(startsListe);
        }
        return ret;
    }

    public void basisziel() {
        DialogPodBasis dialogPodBasis = new DialogPodBasis(null, true, daten);
        dialogPodBasis.setVisible(true);
        if (dialogPodBasis.geaendert) {
            super.getSpalten(jTable1);
            load1();
            super.setSpalten(jTable1);
        }
    }

    public void podAnlegen() {
        DatenPod datenPod = new DatenPod();
        DialogPod dialogPod = new DialogPod(null, true, daten, datenPod);
        dialogPod.setVisible(true);
        if (dialogPod.ok) {
            daten.listePod.addPod(datenPod);
            super.getSpalten(jTable1);
            load1();
            super.setSpalten(jTable1);
            int neu = tModel1.getRowCount();
            jTable1.setRowSelectionInterval(jTable1.convertRowIndexToView(neu - 1), jTable1.convertRowIndexToView(neu - 1));
            jTable1.scrollRectToVisible(jTable1.getCellRect(neu - 1, 0, true));
        }
    }

    public void podLoeschen() {
        int rows[] = jTable1.getSelectedRows();
        if (rows.length > 0) {
            int ret = -1;
            ret = JOptionPane.showConfirmDialog(null, "L\u00f6schen?", " ", JOptionPane.YES_NO_OPTION);
            if (ret == JOptionPane.OK_OPTION) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    int delRow = jTable1.convertRowIndexToModel(rows[i]);
                    daten.listePod.remove(delRow);
                }
                load1();
                daten.setGeaendert();
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    public void podAendern() {
        if (beobachterTableSelect1.selectedModelRow >= 0) {
            DatenPod datenPod = daten.listePod.getPodNr(beobachterTableSelect1.selectedModelRow);
            DialogPod dialogPod = new DialogPod(null, true, daten, datenPod);
            dialogPod.setVisible(true);
            if (dialogPod.ok) {
                super.getSpalten(jTable1);
                load1();
                super.setSpalten(jTable1);
            }
        }
    }

    public void podster() {
        DialogPodster dialog = new DialogPodster(null, true, daten);
        dialog.setVisible(true);
        if (dialog.podGeaendert) {
            super.getSpalten(jTable1);
            load1();
            super.setSpalten(jTable1);
        }
    }
    //===================================
    // private
    //===================================

    private synchronized void load1() {
        //Tabelle2 löschen
        tModel2 = new TModel(null, Konstanten.FILME_COLUMN_NAMES_POD);
        jTable2.setModel(tModel2);
        //Ausblenden
        jTable2.getColumnModel().getColumn(Konstanten.FILM_SENDER_NR).setMinWidth(0);
        jTable2.getColumnModel().getColumn(Konstanten.FILM_SENDER_NR).setMaxWidth(0);
        jTable2.getColumnModel().getColumn(Konstanten.FILM_SENDER_NR).setPreferredWidth(0);
        //Tabelle1 laden
        jTable2.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        tModel1 = new TModel(daten.listePod.getObjectData(), Konstanten.POD_COLUMN_NAMES);
        jTable1.setModel(tModel1);
        jTable2.setDefaultRenderer(Object.class, new DownloadCellRenderer(daten, true /*starts*/, false /*Abo*/));
        jTable1.getColumnModel().getColumn(Konstanten.POD_NR_NR).setPreferredWidth(50);
        jTable1.getColumnModel().getColumn(Konstanten.POD_NR_NR).setMaxWidth(1000);
    }

    private synchronized void load2() {
        tModel2 = daten.feedReaderPods.getListe().getPodModel();
        jTable2.setModel(tModel2);
        //Spalten ausblenden
        Funktionen.spaltenFilmSetzen(jTable2, daten, false, true /*ziel*/, false /*prog*/);
    }

    private void podsSuchen() {
        jButtonSuchen.setEnabled(false);
        jButtonDownloaden.setEnabled(false);
        //aufräumen
        jTable2.setModel(new javax.swing.table.DefaultTableModel(
                new Object[][]{},
                new String[]{}));
        daten.feedReaderPods.starten();
    }

    private void initProgressBar(int max, int progress, String text) {
        if (max == 0) {
            jProgressBar1.setMaximum(0);
            jProgressBar1.setMinimum(0);
            jProgressBar1.setValue(0);
            jProgressBar1.setStringPainted(false);
            jProgressBar1.setVisible(false);
            jButtonStop.setVisible(false);
        } else {
            jProgressBar1.setVisible(true);
            jButtonStop.setVisible(true);
            jProgressBar1.setMaximum(max);
            jProgressBar1.setMinimum(0);
            int proz = 0;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            //jProgressBar1.setString(text + "     " + "( " + proz + " % von " + max + " Podcasts )");
            jProgressBar1.setString("( " + proz + "% von " + max + " Podcasts )  " + Funktionen.textLaenge(text));
            jProgressBar1.setStringPainted(true);
            jProgressBar1.setValue(progress);
        }
    }

    private void deleteDownload(boolean dauerhaft) {
        int rows[] = jTable2.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = jTable2.convertRowIndexToModel(rows[i]);
                if (dauerhaft) {
                    daten.log.zeileSchreiben(tModel2.getValueAt(delRow, Konstanten.FILM_TITEL_NR).toString(), tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString(), Konstanten.LOG_DATEI_POD);
                }
                daten.starterClass.filmLoeschen(tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
                tModel2.removeRow(delRow);
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void aufraeumen() {
        for (int i = 0; i < tModel2.getRowCount(); ++i) {
            int s = daten.starterClass.getState(tModel2.getValueAt(i, Konstanten.FILM_URL_NR).toString());
            if (s >= Starts.STATUS_FERTIG) {
                tModel2.removeRow(i);
                --i;
            }
        }
        daten.starterClass.aufraeumen(Starts.QUELLE_PODCAST);
    }

    private void podsStop() {
        if (daten.feedReaderPods != null) {
            daten.feedReaderPods.stoppen();
        }
    }

    private void downloadAll() {
        downloadAll(daten, tModel2);
    }

    private void panelUpdate() {
        jTable2.repaint();
        this.validate();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jButtonSuchen = new javax.swing.JButton();
        jButtonDownloaden = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jButtonNeu = new javax.swing.JButton();
        jButtonLoeschen = new javax.swing.JButton();
        jSplitPane2 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        jButtonDownloadLoeschen = new javax.swing.JButton();
        jButtonDauerhaftLoeschen = new javax.swing.JButton();
        jButtonAufraeumen = new javax.swing.JButton();
        jButtonAendern = new javax.swing.JButton();
        jButtonPodster = new javax.swing.JButton();
        jProgressBar1 = new javax.swing.JProgressBar();
        jButtonStop = new javax.swing.JButton();

        jLabel1.setText("jLabel1");

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jButtonSuchen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/view-refresh.png"))); // NOI18N
        jButtonSuchen.setText("neue Podcasts suchen");
        jButtonSuchen.setToolTipText("nach neuen Podcasts suchen");

        jButtonDownloaden.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/go-next.png"))); // NOI18N
        jButtonDownloaden.setText("alle Downloads starten");
        jButtonDownloaden.setToolTipText("alle in der unteren Tabelle angezeigten Downloads starten");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonSuchen)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonDownloaden)
                .addContainerGap(315, Short.MAX_VALUE))
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonDownloaden, jButtonSuchen});

        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonSuchen)
                    .addComponent(jButtonDownloaden))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonDownloaden, jButtonSuchen});

        jPanel4.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jButtonNeu.setText("neuer Podcast");
        jButtonNeu.setToolTipText("einen neuen Podcast anlegen");

        jButtonLoeschen.setText("Podcast löschen");
        jButtonLoeschen.setToolTipText("markierten Podcast löschen");

        jSplitPane2.setDividerLocation(150);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jScrollPane1.setViewportView(jTable1);

        jSplitPane2.setTopComponent(jScrollPane1);

        jTable2.setAutoCreateRowSorter(true);
        jTable2.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jTable2.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jScrollPane2.setViewportView(jTable2);

        jSplitPane2.setRightComponent(jScrollPane2);

        jButtonDownloadLoeschen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/edit-cut.png"))); // NOI18N
        jButtonDownloadLoeschen.setText("Download löschen");
        jButtonDownloadLoeschen.setToolTipText("markierten Download löschen");

        jButtonDauerhaftLoeschen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/user-trash.png"))); // NOI18N
        jButtonDauerhaftLoeschen.setText("Download dauerhaft löschen");
        jButtonDauerhaftLoeschen.setToolTipText("markierten Download dauerhaft löschen");

        jButtonAufraeumen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/edit-clear.png"))); // NOI18N
        jButtonAufraeumen.setText("Tabelle aufräumen");
        jButtonAufraeumen.setToolTipText("abgeschlossene Downloads aus der Tabelle entfernen");

        jButtonAendern.setText("Podcast ändern");
        jButtonAendern.setToolTipText("Einstellungen des markierten Podcast ändern");

        jButtonPodster.setText("Podcast bei Podster.de suchen");
        jButtonPodster.setToolTipText("bei Podster.de nach Podcasts suchen");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSplitPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 767, Short.MAX_VALUE)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jButtonNeu)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonLoeschen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonAendern)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 50, Short.MAX_VALUE)
                        .addComponent(jButtonPodster))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jButtonDownloadLoeschen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonDauerhaftLoeschen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonAufraeumen)))
                .addContainerGap())
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonAendern, jButtonLoeschen, jButtonNeu});

        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButtonNeu)
                    .addComponent(jButtonLoeschen)
                    .addComponent(jButtonAendern)
                    .addComponent(jButtonPodster))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSplitPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 305, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButtonDownloadLoeschen)
                    .addComponent(jButtonDauerhaftLoeschen)
                    .addComponent(jButtonAufraeumen))
                .addContainerGap())
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonLoeschen, jButtonNeu});

        jProgressBar1.setFont(new java.awt.Font("Monospaced", 1, 12));

        jButtonStop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/process-stop.png"))); // NOI18N
        jButtonStop.setText("Stop");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(jProgressBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 696, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonStop)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonStop))
                .addGap(37, 37, 37))
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonStop, jProgressBar1});

    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAendern;
    private javax.swing.JButton jButtonAufraeumen;
    private javax.swing.JButton jButtonDauerhaftLoeschen;
    private javax.swing.JButton jButtonDownloadLoeschen;
    private javax.swing.JButton jButtonDownloaden;
    private javax.swing.JButton jButtonLoeschen;
    private javax.swing.JButton jButtonNeu;
    private javax.swing.JButton jButtonPodster;
    private javax.swing.JButton jButtonStop;
    private javax.swing.JButton jButtonSuchen;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    // End of variables declaration//GEN-END:variables

    private class BeobachterTableSelect1 implements ListSelectionListener {

        public int selectedModelRow = -1;

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                if (jTable1.getSelectedRow() >= 0) {
                    selectedModelRow = jTable1.convertRowIndexToModel(jTable1.getSelectedRow());
                } else {
                    selectedModelRow = -1;
                }
            }
        }
    }

    private class BeobachterNeu implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            podAnlegen();
        }
    }

    private class BeobPodster implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            podster();
        }
    }

    private class BeobPodsStop implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            podsStop();
        }
    }

    private class BeobLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            podLoeschen();
        }
    }

    private class BeobAendern implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            podAendern();
        }
    }

    private class BeobSuchen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            podsSuchen();
        }
    }

    private class BeobDownloadLoeschen implements ActionListener {

        boolean dauerhaft = false;

        public BeobDownloadLoeschen(boolean d) {
            dauerhaft = d;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            deleteDownload(dauerhaft);
        }
    }

    private class BeobDownloadAll implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            downloadAll();
        }
    }

    private class BeobAufraeumen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            aufraeumen();
        }
    }

    private class BeobProg implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            basisziel();
        }
    }

    private class BeobStart implements StartListener {

        @Override
        public void starter(StartEvent ev) {
            panelUpdate();
            if (ev.allesStop()) {
            }
        }
    }

    private class BeobachterLaden implements FilmListener {

        int max;
        int count;
        int progress;

        public BeobachterLaden() {
            count = 0;
            max = 0;
        }

        @Override
        public void start(String sender, int m) {
            ++count;
            max += m;
            initProgressBar(max, 0, "");
        }

        @Override
        public void progress(String sender, String text) {
            ++progress;
            if (progress > max) {
                progress = max;
            }
            initProgressBar(max, progress, text);
        }

        @Override
        public void fertig(String sender, boolean stop) {
            --count;
            if (count <= 0) {
                max = 0;
                progress = 0;
                load1();
                load2();
                initProgressBar(0, 0, "");
                jButtonSuchen.setEnabled(true);
                jButtonDownloaden.setEnabled(true);
            }
        }

        @Override
        public void addMax(String sender, int m) {
            max += m;
        }

        @Override
        public void threads(String sender, int tthreads) {
        }
    }

//    public class BeobMausTabelle1 extends MouseAdapter {
//
//        @Override
//        public void mousePressed(MouseEvent arg0) {
//            if (arg0.getButton() == MouseEvent.BUTTON1) {
//                if (arg0.getClickCount() > 1) {
//                    podAendern();
//                }
//            }
//        }
//    }
    private class BeobMausTabelle1 extends MouseAdapter {

        private BeobUrl beobUrl = new BeobUrl();
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle1(JTable ttabelle) {
            tabelle = ttabelle;
        }

        private class BeobUrl implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = tabelle.rowAtPoint(p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard(
                            tabelle.getModel().getValueAt(tabelle.convertRowIndexToModel(nr),
                            Konstanten.FILM_URL_NR).toString());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
            } else if (arg0.getButton() == MouseEvent.BUTTON3) {
                showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            p = evt.getPoint();
            int nr = tabelle.rowAtPoint(p);
            if (nr >= 0) {
                tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            //
            JMenuItem itemAendern = new JMenuItem("Podcast ändern");
            itemAendern.addActionListener(new BeobAendern());
            menu.add(itemAendern);
            JMenuItem itemLoeschen = new JMenuItem("Podcast löschen");
            itemLoeschen.addActionListener(new BeobLoeschen());
            menu.add(itemLoeschen);
            //Menü anzeigen
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public class BeobMausTabelle2 extends MouseAdapter {

        private BeobUrl beobUrl = new BeobUrl();
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle2(JTable ttabelle) {
            tabelle = ttabelle;
        }

        private class BeobUrl implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = tabelle.rowAtPoint(p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard(
                            tabelle.getModel().getValueAt(tabelle.convertRowIndexToModel(nr),
                            Konstanten.FILM_URL_NR).toString());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
            } else if (arg0.getButton() == MouseEvent.BUTTON3) {
                showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            p = evt.getPoint();
            int nr = tabelle.rowAtPoint(p);
            if (nr >= 0) {
                tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            //url
            JMenuItem itemVor = new JMenuItem("URL kopieren");
            itemVor.addActionListener(beobUrl);
            menu.add(itemVor);
            //##Trenner##
            menu.addSeparator();
            //löschen
            JMenuItem itemLoeschen = new JMenuItem("Download löschen");
            itemLoeschen.addActionListener(new BeobDownloadLoeschen(false));
            menu.add(itemLoeschen);
            //dauerhaft löschen
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft löschen");
            itemDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
            menu.add(itemDauerhaftLoeschen);
            //Menü anzeigen
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}
