/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Konstanten;

public class ListePod extends LinkedList<DatenPod> {

    private int nr = 0;

    public void addPod(String name, String pfad, String ziel) {
        addPod(new DatenPod(name, pfad, ziel));
    }

    public void addPod(DatenPod datenPod) {
        String str = String.valueOf(nr++);
        while (str.length() < 3) {
            str = "0" + str;
        }
        datenPod.arr[Konstanten.POD_NR_NR] = str;
        super.add(datenPod);
    }

    public DatenPod getPodNr(int i) {
        return super.get(i);
    }

    @Override
    public DatenPod remove(int idx) {
        return super.remove(idx);
    }

    public String urlExists(String url) {
        String ret = null;
        DatenPod datenPod;
        ListIterator<DatenPod> iterator = this.listIterator();
        while (iterator.hasNext()) {
            datenPod = iterator.next();
            if (datenPod.arr[Konstanten.POD_URL_NR].equals(url)) {
                ret = datenPod.arr[Konstanten.POD_NAME_NR];
                break;
            }
        }
        return ret;
    }

    public void sort() {
        Collections.<DatenPod>sort(this);
    }

    public String getZiel(String name) {
        String ret = null;
        DatenPod datenPod;
        ListIterator<DatenPod> iterator = this.listIterator();
        while (iterator.hasNext()) {
            datenPod = iterator.next();
            if (datenPod.arr[Konstanten.POD_NAME_NR].equals(name)) {
                ret = datenPod.arr[Konstanten.POD_ZIELPFAD_NR];
                break;
            }
        }
        return ret;
    }

    public Object[][] getObjectData() {
        Object[][] object;
        DatenPod daten;
        int i = 0;
        ListIterator<DatenPod> iterator = this.listIterator(0);
        object = new Object[this.size()][Konstanten.POD_MAX_ELEM];
        while (iterator.hasNext()) {
            daten = iterator.next();
            object[i] = daten.arr;
            ++i;
        }
        return object;
    }

}
