/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import mediathek.Funktionen;
import mediathek.Konstanten;

public class ListeFilmUpdate extends LinkedList<DatenFilmUpdate> {

    //gesesen und geschrieben immer in alle, ist komplett
    //this enthält "nach 20"
    public LinkedList<DatenFilmUpdate> alle = new LinkedList<DatenFilmUpdate>();
    private Random random = new Random();

    public void sort() {
        int nr = 0;
        Collections.<DatenFilmUpdate>sort(this);
        Iterator<DatenFilmUpdate> it = this.iterator();
        while (it.hasNext()) {
            String str = String.valueOf(nr++);
            while (str.length() < 3) {
                str = "0" + str;
            }
            it.next().arr[Konstanten.FILM_UPDATE_NR_NR] = str;
        }
    }

    public boolean addAlle(DatenFilmUpdate film) {
        // Film wird in die BackListe geschrieben, check20 muss dann selbst aufgerufen werden
        boolean ret = false;
        ListIterator<DatenFilmUpdate> it = alle.listIterator();
        while (it.hasNext()) {
            if (it.next().arr[Konstanten.FILM_UPDATE_URL_NR].equals(film.arr[Konstanten.FILM_UPDATE_URL_NR])) {
                return false;
            }
        }
        return alle.add(film);
    }

//    public boolean add(DatenFilmUpdate film) {
//        // Film wird in die BackListe geschrieben und
//        // mit check20 in die aktuelle Liste
//        boolean ret = false;
//        ListIterator<DatenFilmUpdate> it = alle.listIterator();
//        while (it.hasNext()) {
//            if (it.next().arr[Konstanten.FILM_UPDATE_URL_NR].equals(film.arr[Konstanten.FILM_UPDATE_URL_NR])) {
//                return false;
//            }
//        }
//        ret = alle.add(film);
//        check20(nur20); //aktuelle Liste bauen wenn eine neue URL dazukam
//        return ret;
//    }
    public void check20(boolean nur20) {
        // FilmUpdates aus der Backliste "alle" in die "Liste" übernehmen
        // mit Prüfung nach "20 Uhr"
        DatenFilmUpdate film;
        this.clear();
        ListIterator<DatenFilmUpdate> it = alle.listIterator();
        while (it.hasNext()) {
            film = it.next();
            if (check20_(nur20, film.arr[Konstanten.FILM_UPDATE_URL_NR])) {
                super.add(film); //wichtig super.add !!
            }
        }
        this.sort();
    }

    private boolean check20_(boolean nur20, String url) {
        boolean ret = false;
        if (nur20) {
            String sub = url.substring(url.length() - 6);
            if (sub.compareTo("20" + Konstanten.FORMAT_ZIP) >= 0
                    || sub.compareTo("04" + Konstanten.FORMAT_ZIP) <= 0) {
                ret = true;
            }
            if (sub.compareTo("20" + Konstanten.FORMAT_BZ2) >= 0
                    || sub.compareTo("04" + Konstanten.FORMAT_BZ2) <= 0) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public String[][] getTableObjectData() {
        DatenFilmUpdate filmUpdate;
        String[][] object;
        ListIterator<DatenFilmUpdate> iterator = this.listIterator();
        object = new String[this.size()][Konstanten.FILM_UPDATE_MAX_ELEM];
        int i = 0;
        while (iterator.hasNext()) {
            filmUpdate = iterator.next();
            object[i] = filmUpdate.arr;
            ++i;
        }
        return object;
    }

    public int getNr(String url) {
        int nr = 0;
        ListIterator<DatenFilmUpdate> iterator = this.listIterator();
        while (iterator.hasNext()) {
            if (iterator.next().arr[Konstanten.FILM_UPDATE_URL_NR].equals(url)) {
                break;
            }
            ++nr;
        }
        if (nr >= this.size()) {
            nr = 0;
        }
        return nr;
    }

    public DatenFilmUpdate getNrUpdate(String url) {
        DatenFilmUpdate update = null;
        ListIterator<DatenFilmUpdate> iterator = this.listIterator();
        while (iterator.hasNext()) {
            update = iterator.next();
            if (update.arr[Konstanten.FILM_UPDATE_URL_NR].equals(url)) {
                return update;
            }
        }
        return null;
    }

    public String getRand(int errcount) {
        final int MAXMINUTEN = 100; //gut 1 Stunden
        int minCount = 2;
        if (errcount > 0) {
            minCount = 2 * errcount;
        }
        String ret = "";
        if (!this.isEmpty()) {
            DatenFilmUpdate film = null;
            Iterator<DatenFilmUpdate> it;
            LinkedList<DatenFilmUpdate> listePrio = new LinkedList<DatenFilmUpdate>();
            LinkedList<DatenFilmUpdate> listeZeit = new LinkedList<DatenFilmUpdate>();
            //aktuellsten auswählen
            it = this.iterator();
            Date today = new Date(System.currentTimeMillis());
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Date d;
            int minuten = 200;
            int count = 0;
            while (it.hasNext()) {
                film = it.next();
                date = film.arr[Konstanten.FILM_UPDATE_DATUM_NR] + " " + film.arr[Konstanten.FILM_UPDATE_ZEIT_NR];
                try {
                    d = sdf.parse(date);
                    minuten = Math.round((today.getTime() - d.getTime()) / (1000 * 60));
                } catch (ParseException ex) {
                }
                if (minuten < MAXMINUTEN) {
                    listeZeit.add(film);
                    ++count;
                } else if (count < minCount) {
                    listeZeit.add(film);
                    ++count;
                }
            }
            //nach prio gewichten
            it = listeZeit.iterator();
            while (it.hasNext()) {
                film = it.next();
                if (film.arr[Konstanten.FILM_UPDATE_PRIO_NR].equals(Konstanten.FILM_UPDATE_PRIO_1)) {
                    listePrio.add(film.getCopy());
                    listePrio.add(film.getCopy());
                } else {
                    listePrio.add(film.getCopy());
                }
            }
            int nr = random.nextInt(listePrio.size());
            film = listePrio.get(nr);
            ret = film.arr[Konstanten.FILM_UPDATE_URL_NR];
        }
        return ret;
    }

    public Date getAktuellster() {
        // holt den ersten Eintrag (Liste muss schon sortiert sein) und gibt das Datum zurück
        Date ret = null;
        if (!this.isEmpty()) {
            DatenFilmUpdate film = this.getFirst();
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            date = film.arr[Konstanten.FILM_UPDATE_DATUM_NR] + " " + film.arr[Konstanten.FILM_UPDATE_ZEIT_NR];
            try {
                ret = sdf.parse(date);
            } catch (ParseException ex) {
                ret = null;
            }
        }
        return ret;
    }
}
