/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import mediathek.Konstanten;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mediathek.gui.dialoge.DialogEditAbo;
import org.apache.commons.lang.StringEscapeUtils;

public class ListeAbo extends LinkedList<DatenAbo> {

    Daten daten;

    public ListeAbo(Daten ddaten) {
        daten = ddaten;
    }
    private int nr = 0;

    public boolean addAbo(String sender, String thema, boolean exakt, String text) {
        //abo anlegen, oder false wenns schon existiert
        boolean ret = false;
        DatenAbo datenAbo = new DatenAbo(thema, sender, thema, exakt, text, thema, "");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(null, true, daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (!aboSuchen(datenAbo.arr[Konstanten.ABO_SENDER_NR],
                    datenAbo.arr[Konstanten.ABO_THEMA_NR],
                    Boolean.parseBoolean(datenAbo.arr[Konstanten.ABO_THEMA_EXAKT_NR]),
                    datenAbo.arr[Konstanten.ABO_TITEL_NR])) {
                addAbo(datenAbo);
                sort();
                ret = true;
            } else {
                JOptionPane.showMessageDialog(null, "Abo existiert bereits",
                        "Abo anlegen", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        return ret;
    }

    public boolean addEinmalAbo(String sender, String thema, String text, String url) {
        //abo anlegen, oder false wenns schon existiert
        boolean ret = false;
        // DatenAbo(String name, String sender, String thema, boolean exakt, String text, String ziel, String programmname) {
        DatenAbo datenAbo = new DatenAbo(thema, sender, thema, true, text, thema, "");
        datenAbo.arr[Konstanten.ABO_EINMAL_URL_NR] = url;
//        datenAbo.arr[Konstanten.ABO_EINMAL_NR] = Boolean.toString(true);
        DialogEditAbo dialogEditAbo = new DialogEditAbo(null, true, daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (!einmalAboSuchen(datenAbo.arr[Konstanten.ABO_EINMAL_URL_NR])) {
                addAbo(datenAbo);
                sort();
                ret = true;
            } else {
                JOptionPane.showMessageDialog(null, "Abo existiert bereits",
                        "Abo anlegen", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        return ret;
    }

    public void erledigteEinmalAboLoeschen() {
        ListIterator<DatenAbo> it = this.listIterator();
        while (it.hasNext()) {
            DatenAbo abo = it.next();
            if (abo.binEinmal() && Boolean.parseBoolean(abo.arr[Konstanten.ABO_EINMAL_ERLEDIGT_NR])) {
                it.remove();
            }
        }
    }

    public void aboLoeschen(DatenAbo abo) {
        if (abo != null) {
            this.remove(abo);
        }
    }

    public void addAbo(DatenAbo datenAbo) {
        String str = String.valueOf(nr++);
        while (str.length() < 3) {
            str = "0" + str;
        }
        datenAbo.arr[Konstanten.ABO_NR_NR] = str;
        //für die neue Funktion
        if (datenAbo.arr[Konstanten.ABO_THEMA_EXAKT_NR].equals("")) {
            datenAbo.arr[Konstanten.ABO_THEMA_EXAKT_NR] = Boolean.toString(true);
        }
        super.add(datenAbo);
    }

    public DatenAbo getAboNr(int i) {
        return this.get(i);
    }

//    public String getName(String sender, String thema, String text) {
//        String ret = "";
//        DatenAbo datenAbo = getAbo(sender, thema, text);
//        if (datenAbo != null) {
//            ret = datenAbo.arr[Konstanten.ABO_NAME_NR];
//        }
//        return ret;
//    }
    public void sort() {
        Collections.<DatenAbo>sort(this);
    }

    public Object[][] getObjectData() {
        Object[][] object;
        DatenAbo datenAbo;
        int i = 0;
        ListIterator<DatenAbo> iterator = this.listIterator();
        object = new Object[this.size()][Konstanten.ABO_MAX_ELEM];
        while (iterator.hasNext()) {
            datenAbo = iterator.next();
            object[i] = datenAbo.arr;
            ++i;
        }
        return object;
    }

    public boolean aboSuchen(String sender, String thema, boolean exakt, String text) {
        //Abo suchen
        boolean ret = false;
        DatenAbo abo = null;
        Iterator<DatenAbo> it = this.iterator();
        while (it.hasNext()) {
            abo = it.next();
            if (abo.arr[Konstanten.ABO_SENDER_NR].equalsIgnoreCase(sender)
                    && abo.arr[Konstanten.ABO_THEMA_NR].equalsIgnoreCase(thema)
                    && abo.arr[Konstanten.ABO_TITEL_NR].equalsIgnoreCase(text)
                    && (Boolean.parseBoolean(abo.arr[Konstanten.ABO_THEMA_EXAKT_NR]) && exakt)) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean einmalAboSuchen(String url) {
        //Abo suchen
        if (url.equals("")) {
            return false;
        }
        boolean ret = false;
        DatenAbo abo = null;
        Iterator<DatenAbo> it = this.iterator();
        while (it.hasNext()) {
            abo = it.next();
            if (abo.arr[Konstanten.ABO_EINMAL_URL_NR].equals(url)) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean aboExists(String sender, String thema) {
        thema = StringEscapeUtils.unescapeHtml(thema.trim());
        boolean ret = false;
        if (getAbo(sender, thema, "", "") != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isPattern(String textSuchen) {
        return textSuchen.startsWith("#:");
    }

    public static Pattern makePattern(String textSuchen) {
        Pattern p = null;
        try {
            if (isPattern(textSuchen)) {
                p = Pattern.compile(textSuchen.substring(2));
            }
        } catch (Exception ex) {
            p = null;
        }
        return p;
    }

    public static boolean aboPruefen(String senderSuchen, String themaSuchen, boolean themaExakt, String textSuchen,
            String imSender, String imThema, String imText) {
        //prüfen ob xxxSuchen im String imXxx enthalten ist
        Pattern p1 = makePattern(themaSuchen);
        boolean ret = false;
        if (senderSuchen.equals("") || imSender.equalsIgnoreCase(senderSuchen)) {
            if (p1 != null) {
                if (p1.matcher(imThema).matches()) {
                    ret = textPruefen(textSuchen, imText);
                }
            } else if (themaSuchen.equals("")
                    || themaExakt && imThema.equalsIgnoreCase(themaSuchen)
                    || !themaExakt && (imThema.toLowerCase().contains(themaSuchen.toLowerCase()))) {
                ret = textPruefen(textSuchen, imText);
            }
        }
        return ret;
    }

    private static boolean textPruefen(String textSuchen, String imText) {
        Pattern p = makePattern(textSuchen);
        boolean ret = false;
        if (p != null) {
            ret = p.matcher(imText).matches();
        } else if (textSuchen.equals("") || imText.toLowerCase().contains(textSuchen.toLowerCase())) {
            ret = true;
        }
        return ret;
    }

    public DatenAbo getAbo(String sender, String thema, String text, String url) {
        DatenAbo datenAbo = null;
        ListIterator<DatenAbo> it = this.listIterator();
        if (sender.equals("") && thema.equals("") && text.equals("") && url.equals("")) {
            daten.fehler.fehlerMeldung("Abo", "Leeres Abo!");
        } else {
            while (it.hasNext()) {
                datenAbo = it.next();
                if (!datenAbo.arr[Konstanten.ABO_EINMAL_URL_NR].equals("")) {
                    //eimal-Abo: nur die URL prüfen
                    if (datenAbo.arr[Konstanten.ABO_EINMAL_URL_NR].equals(url)) {
                        return datenAbo;
                    }
                } else if (aboPruefen(datenAbo.arr[Konstanten.ABO_SENDER_NR], datenAbo.arr[Konstanten.ABO_THEMA_NR],
                        // aboPruefen(String senderSuchen, String themaSuchen, boolean themaExakt, String textSuchen,
                        //                     String imSender, String imThema, String imText) {
                        Boolean.parseBoolean(datenAbo.arr[Konstanten.ABO_THEMA_EXAKT_NR]),
                        datenAbo.arr[Konstanten.ABO_TITEL_NR],
                        sender, thema, text)) {
                    return datenAbo;
                }
            }

        }
        return null;
    }

    public DatenAbo getEinmalAbo(String url) {
        DatenAbo datenAbo = null;
        ListIterator<DatenAbo> it = this.listIterator();
        while (it.hasNext()) {
            datenAbo = it.next();
            if (!url.equals("")) {
                //eimal-Abo: nur die URL prüfen
                if (datenAbo.arr[Konstanten.ABO_EINMAL_URL_NR].equals(url)) {
                    return datenAbo;
                }
            }
        }
        return null;
    }
}
