/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <med.h>
#define MESGERR 1
#include "med_utils.h"
#include <string.h>

#include <unistd.h>
#include <time.h>
#include <assert.h>
#include <stdlib.h>

static int cmp(const med_int *p1, const med_int *p2) { return *p1-*p2; }

med_err generateFilterArray( const med_size nbofentities, const med_size nbofvaluesperentity, const med_size nbofconstituentpervalue,
			     const med_size profilearraysize, const med_int * const profilearray,
			     med_int  * const nbofentitiesfiltered, med_int **filterarray ) {


  med_err    _ret=-1;
  med_int    _nbofentitiesfiltered=0,_maxfilternbofentities=0;
  med_int    *_indexarray=NULL;
  int        _i=0;
  struct tm  *_tm ;
  time_t _tt=time(0);

  _tm = localtime(&_tt);


  /*Taille du tableau des numéros d'entités à filtrer */
  if ( profilearraysize ) {
    _maxfilternbofentities = profilearraysize;
  } else {
    _maxfilternbofentities = nbofentities;
  }

  /* Allocation du tableau de filtre */

  srandom((*_tm).tm_sec * (*_tm).tm_min );
  _nbofentitiesfiltered         = 1 + (int) ((float)(_maxfilternbofentities) * (random() / (RAND_MAX + 1.0)));
  /*       _nbofentitiesfiltered         = 2; */

  (*filterarray)         = malloc(_nbofentitiesfiltered*sizeof(med_int));

/*   if ( profilearraysize) { */
/*     _indexarray     = malloc(_nbofentitiesfiltered*sizeof(med_int)); */
/*   } else { */
/*     _indexarray=(*filterarray); */
/*   } */

  _indexarray=(*filterarray);

  for (_i=0; _i < _nbofentitiesfiltered; ++_i ) {
    _indexarray[_i] =  1 + (int) ((double)(_maxfilternbofentities) * (random() / (RAND_MAX + 1.0)));
  }

  /*N'enlève pas les doublons, mais celà fonctionne*/
  qsort(_indexarray, _nbofentitiesfiltered, sizeof(med_int), (int(*)(const void *, const void *) ) cmp);

  for (_i=0; _i < _nbofentitiesfiltered; ++_i ) {
    ISCRUTE(_indexarray[_i]);
  }

  /* Cette indirection ne doit jamais être faite car le tableau filtre contient des indices de profils.*/
/*   if ( profilearraysize) */
/*     for (_i=0; _i < _nbofentitiesfiltered; ++_i ) { */
/*       (*filterarray)[_i] = profilearray[_indexarray[_i]]; */
/*       ISCRUTE((*filterarray)[_i]); */
/*     } */

  *nbofentitiesfiltered=_nbofentitiesfiltered;

  _ret=0;

 ERROR:
/*   if ( profilearraysize) free(_indexarray); */

  return _ret;

}
