/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/uploadtask.h>

#include "uploadtask_priv.h"
#include "taskhandler.h"

using namespace mcloud::api;
using namespace std;

UploadTask::UploadTask(std::shared_ptr<UploadTaskPriv>  p)
    :p_(p){

}

const string & UploadTask::task_id() const {
    return p_->task_id();
}

const string & UploadTask::content_id() const {
    return p_->content_id();
}

const string & UploadTask::content_name() const {
    return p_->content_name();
}

const string & UploadTask::file_path() const {
    return p_->file_path();
}

const string & UploadTask::task_url() const {
    return p_->task_url();
}

Task::Status UploadTask::status() const {
    return p_->task_handler()->status();
}

size_t UploadTask::file_size() const {
    return p_->file_size();
}

bool UploadTask::is_need_upload() const {
    return p_->is_need_upload();
}

Task::ProgressHandler &UploadTask::progress_changed() {
    return p_->progress_changed();
}

Task::StatusHandler &UploadTask::status_changed() {
    return p_->status_changed();
}

const string & UploadTask::error_string() const {
    return p_->error_string();
}

void UploadTask::cancel() {
    p_->task_handler()->cancel();
}

