/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/client.h>

#include <core/net/error.h>
#include <core/net/uri.h>
#include <core/net/http/client.h>
#include <core/net/http/request.h>
#include <core/net/http/response.h>

#include <boost/filesystem.hpp>
#include <boost/algorithm/string.hpp>

#include "client_priv.h"

using namespace mcloud::api;
using namespace std;

Client::Client(int request_timeout)
    : p_(std::make_shared<ClientPriv>(request_timeout)) {
}

Client::~Client() {
    p_->sync_manager()->cancel();
}

void Client::set_access_token(const string &access_token) {
    p_->set_access_token(access_token);
}

string Client::cloud_root_folder_id() {
    return p_->cloud_sync_folder_id();
}

bool Client::exist_on_cloud(const string &file_path, const string &folder_id) {
    return p_->exist_on_cloud(file_path, folder_id);
}

DiskInfo Client::disk_info() {
    return p_->disk_info();
}

Client::ResourceList Client::cloud_content_list(int start_index,
                                                int count,
                                                CloudContent::Type type,
                                                const std::string & folder_id) {
    return p_->cloud_content_list(start_index, count, type, folder_id);
}

CloudContent::Ptr Client::content_info(const string &content_id) {
    return p_->content_info(content_id);
}

CloudFolder::Ptr Client::create_folder(const string &folder_name,
                                       const string &folder_id) {
    return p_->create_folder(folder_name, folder_id);
}

Client::ResourceList Client::look_up(const string &name,
                                     const string &folder_id,
                                     CloudResource::Property property) {
    return p_->look_up(name, folder_id, property);
}

bool Client::move_items(const Client::Stringlist &folder_ids,
                        const Client::Stringlist &content_ids,
                        const std::string &folder_id) {
    return p_->move_items(folder_ids, content_ids, folder_id);
}

bool Client::update_folder(const std::string &folder_id,
                           const std::string &new_folder_name) {
    return p_->update_folder(folder_id, new_folder_name);
}

SyncManager::Ptr Client::syncmanager() const {
    return p_->sync_manager();
}

bool Client::delete_contents(const vector<string> &content_ids) {
    return p_->delete_contents(content_ids);
}

Client::OutlinkList Client::create_folder_extranet_link(const Stringlist &folder_ids) {
    return p_->create_folder_extranet_link(folder_ids);
}

Client::OutlinkList Client::create_content_extranet_link(const Stringlist &content_ids) {
    return p_->create_content_extranet_link(content_ids);
}

Client::Stringlist Client::copy_folders(const Client::Stringlist &folder_ids,
                                        const std::string &folder_id) {
    return p_->copy_folders(folder_ids, folder_id);
}

Client::Stringlist Client::copy_contents(const Client::Stringlist &contents_ids,
                                         const string &folder_id) {
    return p_->copy_contents(contents_ids, folder_id);
}

bool Client::refresh_token(const string &refresh_token) {
    return p_->refersh_token(refresh_token);
}
