/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/syncmanager.h>
#include <mcloud/api/taskqueue.h>

#include "syncmanager_priv.h"
#include "client_priv.h"
#include "syncthread.h"

#include <iostream>

using namespace mcloud::api;
using namespace std;

SyncManagerPriv::SyncManagerPriv(ClientPriv *client)
    : download_thread_()
    , upload_thread_()
    , client_(client){
    start();
}

SyncManagerPriv::~SyncManagerPriv() {
    download_thread_.stop();
    upload_thread_.stop();
}

DownloadTask::Ptr SyncManagerPriv::add_download_task(const string &content_id) {
    auto item_p = client_->create_download_link(content_id);
    cout << "push download link url in queue : " + item_p->task_url() << endl;
    download_thread_.add_task(item_p);

    auto item = std::shared_ptr<DownloadTask>(new DownloadTask(item_p));
    download_queue_.push(item);
    return item;
}

DownloadTask::Ptr SyncManagerPriv::add_download_task(const DownloadBufferCb &buffer_cb) {
    auto item_p = client_->create_download_link(buffer_cb);
    cout << "push download link url in queue : " + item_p->task_url() << endl;
    download_thread_.add_task(item_p);

    auto item = std::shared_ptr<DownloadTask>(new DownloadTask(item_p));
    download_queue_.push(item);
    return item;
}

UploadTask::Ptr SyncManagerPriv::add_upload_task(const UploadRequest &request_item) {
    auto item_p = client_->create_upload_link(request_item);
    cout << "push upload link url in queue : " + item_p->task_url() << endl;
    upload_thread_.add_task(item_p);

    auto item = std::shared_ptr<UploadTask>(new UploadTask(item_p));
    upload_queue_.push(item);
    return item;
}

UploadTask::Ptr SyncManagerPriv::add_upload_task(const UploadBufferCb &buffer_cb) {
    auto item_p = client_->create_upload_link(buffer_cb);
    cout << "push upload link url in queue : " + item_p->task_url() << endl;
    upload_thread_.add_task(item_p);

    auto item =  std::shared_ptr<UploadTask>(new UploadTask(item_p));
    upload_queue_.push(item);
    return item;
}

TaskQueue<DownloadTask::Ptr> SyncManagerPriv::download_queue() {
    return download_queue_;
}

TaskQueue<UploadTask::Ptr> SyncManagerPriv::upload_queue() {
    return upload_queue_;
}

void SyncManagerPriv::start() {
    download_thread_.start();
    upload_thread_.start();
}

void SyncManagerPriv::cancel() {
    download_thread_.cancel();
    upload_thread_.cancel();
}

void SyncManagerPriv::pause() {
    download_thread_.pause();
    upload_thread_.pause();
}
