/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_DOWNLOADTASKPRIV_H_
#define MCLOUD_API_DOWNLOADTASKPRIV_H_

#include <mcloud/api/task.h>

#include <memory>
#include <fstream>

namespace tinyxml2 {
    class XMLElement;
}

namespace mcloud {
namespace api {

class TaskHandler;

class DownloadTaskPriv {
public:
    typedef std::shared_ptr<DownloadTaskPriv>  Ptr;

    DownloadTaskPriv(const tinyxml2::XMLElement *root,
                     Task::Buffer_Callback write_cb = nullptr);
  
    virtual ~DownloadTaskPriv() = default;

    const std::string & task_url() const;
  
	Task::Status status() const;
  
	const std::string & task_id() const;
  
    const std::string & content_id() const;
  
    const std::string & content_name() const;
  
    const std::string & file_path() const;

    const std::string & error_string() const; 

    void set_error_string(const std::string & err);
  
    Task::ProgressHandler & progress_changed();
  
    Task::StatusHandler & status_changed(); 

    Task::Buffer_Callback & buffer_callback();
  
    void cancel();

    std::shared_ptr<TaskHandler> task_handler() const;

private:
    std::string task_url_;

    std::string content_id_;

    std::string content_name_;

    std::string file_path_;

    std::string error_string_;

    std::ofstream   ofs_;

    Task::ProgressHandler progress_handler_;

    Task::StatusHandler status_handler_;

    Task::Buffer_Callback buffer_callback_;

    std::shared_ptr<TaskHandler> task_handler_;
};

}
}

#endif // MCLOUD_API_DOWNLOADTASKPRIV_H_
