/*
 * Copyright (C) 2016 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of version 3 of the GNU Lesser General Public License as published
 * by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_CONFIG_H_
#define MCLOUD_API_CONFIG_H_

#include <memory>
#include <string>

namespace mcloud {
namespace api {

struct Config {
    typedef std::shared_ptr<Config> Ptr;

    /*
     * The access token provided by mlcoud
     */
    std::string access_token { };

    /*
     * The login user id after authenticated
     */
    std::string user_id { };

    /*
     * The client id provided by cmcc mcloud for 3rd-party client
     */
    std::string client_id { CLIENT_ID };

    /*
     * The client password provided by cmcc mcloud for 3rd-party client
     */
    std::string client_password { CLIENT_PASS };

    /*
     * The root of all API request URLs
     */
    std::string apiroot {"https://ose.caiyun.feixin.10086.cn"};

    /*
     * The custom HTTP user agent string for this library
     */
    std::string user_agent {"mcloud-lib"};

    /*
     *  request timeout for mcloud restful api
     */
    int request_timeout = 1;
};

}
}

#endif /* MCLOUD_API_CONFIG_H_ */
