
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/git/sql/sql_yacc.yy"

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include <my_global.h>
#include "sql_priv.h"
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"
#include "lex_token.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !MY_TEST(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!MY_TEST(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 955 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADMIN_SYM = 262,
     ADDDATE_SYM = 263,
     AFTER_SYM = 264,
     AGAINST = 265,
     AGGREGATE_SYM = 266,
     ALGORITHM_SYM = 267,
     ALL = 268,
     ALTER = 269,
     ALWAYS_SYM = 270,
     ANALYZE_SYM = 271,
     AND_AND_SYM = 272,
     AND_SYM = 273,
     ANY_SYM = 274,
     AS = 275,
     ASC = 276,
     ASCII_SYM = 277,
     ASENSITIVE_SYM = 278,
     AT_SYM = 279,
     AUTHORS_SYM = 280,
     AUTOEXTEND_SIZE_SYM = 281,
     AUTO_INC = 282,
     AUTO_SYM = 283,
     AVG_ROW_LENGTH = 284,
     AVG_SYM = 285,
     BACKUP_SYM = 286,
     BEFORE_SYM = 287,
     BEGIN_SYM = 288,
     BETWEEN_SYM = 289,
     BIGINT = 290,
     BINARY = 291,
     BINLOG_SYM = 292,
     BIN_NUM = 293,
     BIT_AND = 294,
     BIT_OR = 295,
     BIT_SYM = 296,
     BIT_XOR = 297,
     BLOB_SYM = 298,
     BLOCK_SYM = 299,
     BOOLEAN_SYM = 300,
     BOOL_SYM = 301,
     BOTH = 302,
     BTREE_SYM = 303,
     BY = 304,
     BYTE_SYM = 305,
     CACHE_SYM = 306,
     CALL_SYM = 307,
     CASCADE = 308,
     CASCADED = 309,
     CASE_SYM = 310,
     CAST_SYM = 311,
     CATALOG_NAME_SYM = 312,
     CHAIN_SYM = 313,
     CHANGE = 314,
     CHANGED = 315,
     CHARSET = 316,
     CHAR_SYM = 317,
     CHECKPOINT_SYM = 318,
     CHECKSUM_SYM = 319,
     CHECK_SYM = 320,
     CIPHER_SYM = 321,
     CLASS_ORIGIN_SYM = 322,
     CLIENT_SYM = 323,
     CLIENT_STATS_SYM = 324,
     CLOSE_SYM = 325,
     COALESCE = 326,
     CODE_SYM = 327,
     COLLATE_SYM = 328,
     COLLATION_SYM = 329,
     COLUMNS = 330,
     COLUMN_ADD_SYM = 331,
     COLUMN_CHECK_SYM = 332,
     COLUMN_CREATE_SYM = 333,
     COLUMN_DELETE_SYM = 334,
     COLUMN_GET_SYM = 335,
     COLUMN_SYM = 336,
     COLUMN_NAME_SYM = 337,
     COMMENT_SYM = 338,
     COMMITTED_SYM = 339,
     COMMIT_SYM = 340,
     COMPACT_SYM = 341,
     COMPLETION_SYM = 342,
     COMPRESSED_SYM = 343,
     CONCURRENT = 344,
     CONDITION_SYM = 345,
     CONNECTION_SYM = 346,
     CONSISTENT_SYM = 347,
     CONSTRAINT = 348,
     CONSTRAINT_CATALOG_SYM = 349,
     CONSTRAINT_NAME_SYM = 350,
     CONSTRAINT_SCHEMA_SYM = 351,
     CONTAINS_SYM = 352,
     CONTEXT_SYM = 353,
     CONTINUE_SYM = 354,
     CONTRIBUTORS_SYM = 355,
     CONVERT_SYM = 356,
     COUNT_SYM = 357,
     CPU_SYM = 358,
     CREATE = 359,
     CROSS = 360,
     CUBE_SYM = 361,
     CURDATE = 362,
     CURRENT_SYM = 363,
     CURRENT_USER = 364,
     CURRENT_ROLE = 365,
     CURRENT_POS_SYM = 366,
     CURSOR_SYM = 367,
     CURSOR_NAME_SYM = 368,
     CURTIME = 369,
     DATABASE = 370,
     DATABASES = 371,
     DATAFILE_SYM = 372,
     DATA_SYM = 373,
     DATETIME = 374,
     DATE_ADD_INTERVAL = 375,
     DATE_SUB_INTERVAL = 376,
     DATE_SYM = 377,
     DAY_HOUR_SYM = 378,
     DAY_MICROSECOND_SYM = 379,
     DAY_MINUTE_SYM = 380,
     DAY_SECOND_SYM = 381,
     DAY_SYM = 382,
     DEALLOCATE_SYM = 383,
     DECIMAL_NUM = 384,
     DECIMAL_SYM = 385,
     DECLARE_SYM = 386,
     DEFAULT = 387,
     DEFINER_SYM = 388,
     DELAYED_SYM = 389,
     DELAY_KEY_WRITE_SYM = 390,
     DELETE_SYM = 391,
     DESC = 392,
     DESCRIBE = 393,
     DES_KEY_FILE = 394,
     DETERMINISTIC_SYM = 395,
     DIAGNOSTICS_SYM = 396,
     DIRECTORY_SYM = 397,
     DISABLE_SYM = 398,
     DISCARD = 399,
     DISK_SYM = 400,
     DISTINCT = 401,
     DIV_SYM = 402,
     DOUBLE_SYM = 403,
     DO_SYM = 404,
     DROP = 405,
     DUAL_SYM = 406,
     DUMPFILE = 407,
     DUPLICATE_SYM = 408,
     DYNAMIC_SYM = 409,
     EACH_SYM = 410,
     ELSE = 411,
     ELSEIF_SYM = 412,
     ENABLE_SYM = 413,
     ENCLOSED = 414,
     END = 415,
     ENDS_SYM = 416,
     END_OF_INPUT = 417,
     ENGINES_SYM = 418,
     ENGINE_SYM = 419,
     ENUM = 420,
     EQ = 421,
     EQUAL_SYM = 422,
     ERROR_SYM = 423,
     ERRORS = 424,
     ESCAPED = 425,
     ESCAPE_SYM = 426,
     EVENTS_SYM = 427,
     EVENT_SYM = 428,
     EVERY_SYM = 429,
     EXCHANGE_SYM = 430,
     EXAMINED_SYM = 431,
     EXECUTE_SYM = 432,
     EXISTS = 433,
     EXIT_SYM = 434,
     EXPANSION_SYM = 435,
     EXPORT_SYM = 436,
     EXTENDED_SYM = 437,
     EXTENT_SIZE_SYM = 438,
     EXTRACT_SYM = 439,
     FALSE_SYM = 440,
     FAST_SYM = 441,
     FAULTS_SYM = 442,
     FETCH_SYM = 443,
     FILE_SYM = 444,
     FIRST_SYM = 445,
     FIXED_SYM = 446,
     FLOAT_NUM = 447,
     FLOAT_SYM = 448,
     FLUSH_SYM = 449,
     FORCE_SYM = 450,
     FOREIGN = 451,
     FOR_SYM = 452,
     FOUND_SYM = 453,
     FROM = 454,
     FULL = 455,
     FULLTEXT_SYM = 456,
     FUNCTION_SYM = 457,
     GE = 458,
     GENERAL = 459,
     GENERATED_SYM = 460,
     GEOMETRYCOLLECTION = 461,
     GEOMETRY_SYM = 462,
     GET_FORMAT = 463,
     GET_SYM = 464,
     GLOBAL_SYM = 465,
     GRANT = 466,
     GRANTS = 467,
     GROUP_SYM = 468,
     GROUP_CONCAT_SYM = 469,
     GT_SYM = 470,
     HANDLER_SYM = 471,
     HARD_SYM = 472,
     HASH_SYM = 473,
     HAVING = 474,
     HELP_SYM = 475,
     HEX_NUM = 476,
     HEX_STRING = 477,
     HIGH_PRIORITY = 478,
     HOST_SYM = 479,
     HOSTS_SYM = 480,
     HOUR_MICROSECOND_SYM = 481,
     HOUR_MINUTE_SYM = 482,
     HOUR_SECOND_SYM = 483,
     HOUR_SYM = 484,
     ID_SYM = 485,
     IDENT = 486,
     IDENTIFIED_SYM = 487,
     IDENT_QUOTED = 488,
     IF = 489,
     IGNORE_SYM = 490,
     IGNORE_SERVER_IDS_SYM = 491,
     IMPORT = 492,
     INDEXES = 493,
     INDEX_SYM = 494,
     INDEX_STATS_SYM = 495,
     INFILE = 496,
     INITIAL_SIZE_SYM = 497,
     INNER_SYM = 498,
     INOUT_SYM = 499,
     INSENSITIVE_SYM = 500,
     INSERT = 501,
     INSERT_METHOD = 502,
     INSTALL_SYM = 503,
     INTERVAL_SYM = 504,
     INTO = 505,
     INT_SYM = 506,
     INVOKER_SYM = 507,
     IN_SYM = 508,
     IO_SYM = 509,
     IPC_SYM = 510,
     IS = 511,
     ISOLATION = 512,
     ISSUER_SYM = 513,
     ITERATE_SYM = 514,
     JOIN_SYM = 515,
     KEYS = 516,
     KEY_BLOCK_SIZE = 517,
     KEY_SYM = 518,
     KILL_SYM = 519,
     LANGUAGE_SYM = 520,
     LAST_SYM = 521,
     LAST_VALUE = 522,
     LE = 523,
     LEADING = 524,
     LEAVES = 525,
     LEAVE_SYM = 526,
     LEFT = 527,
     LESS_SYM = 528,
     LEVEL_SYM = 529,
     LEX_HOSTNAME = 530,
     LIKE = 531,
     LIMIT = 532,
     LINEAR_SYM = 533,
     LINES = 534,
     LINESTRING = 535,
     LIST_SYM = 536,
     LOAD = 537,
     LOCAL_SYM = 538,
     LOCATOR_SYM = 539,
     LOCKS_SYM = 540,
     LOCK_SYM = 541,
     LOGFILE_SYM = 542,
     LOGS_SYM = 543,
     LONGBLOB = 544,
     LONGTEXT = 545,
     LONG_NUM = 546,
     LONG_SYM = 547,
     LOOP_SYM = 548,
     LOW_PRIORITY = 549,
     LT = 550,
     MASTER_CONNECT_RETRY_SYM = 551,
     MASTER_GTID_POS_SYM = 552,
     MASTER_HOST_SYM = 553,
     MASTER_LOG_FILE_SYM = 554,
     MASTER_LOG_POS_SYM = 555,
     MASTER_PASSWORD_SYM = 556,
     MASTER_PORT_SYM = 557,
     MASTER_SERVER_ID_SYM = 558,
     MASTER_SSL_CAPATH_SYM = 559,
     MASTER_SSL_CA_SYM = 560,
     MASTER_SSL_CERT_SYM = 561,
     MASTER_SSL_CIPHER_SYM = 562,
     MASTER_SSL_CRL_SYM = 563,
     MASTER_SSL_CRLPATH_SYM = 564,
     MASTER_SSL_KEY_SYM = 565,
     MASTER_SSL_SYM = 566,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 567,
     MASTER_SYM = 568,
     MASTER_USER_SYM = 569,
     MASTER_USE_GTID_SYM = 570,
     MASTER_HEARTBEAT_PERIOD_SYM = 571,
     MATCH = 572,
     MAX_CONNECTIONS_PER_HOUR = 573,
     MAX_QUERIES_PER_HOUR = 574,
     MAX_ROWS = 575,
     MAX_SIZE_SYM = 576,
     MAX_SYM = 577,
     MAX_UPDATES_PER_HOUR = 578,
     MAX_USER_CONNECTIONS_SYM = 579,
     MAX_VALUE_SYM = 580,
     MEDIUMBLOB = 581,
     MEDIUMINT = 582,
     MEDIUMTEXT = 583,
     MEDIUM_SYM = 584,
     MEMORY_SYM = 585,
     MERGE_SYM = 586,
     MESSAGE_TEXT_SYM = 587,
     MICROSECOND_SYM = 588,
     MIGRATE_SYM = 589,
     MINUTE_MICROSECOND_SYM = 590,
     MINUTE_SECOND_SYM = 591,
     MINUTE_SYM = 592,
     MIN_ROWS = 593,
     MIN_SYM = 594,
     MODE_SYM = 595,
     MODIFIES_SYM = 596,
     MODIFY_SYM = 597,
     MOD_SYM = 598,
     MONTH_SYM = 599,
     MULTILINESTRING = 600,
     MULTIPOINT = 601,
     MULTIPOLYGON = 602,
     MUTEX_SYM = 603,
     MYSQL_SYM = 604,
     MYSQL_ERRNO_SYM = 605,
     NAMES_SYM = 606,
     NAME_SYM = 607,
     NATIONAL_SYM = 608,
     NATURAL = 609,
     NCHAR_STRING = 610,
     NCHAR_SYM = 611,
     NDBCLUSTER_SYM = 612,
     NE = 613,
     NEG = 614,
     NEW_SYM = 615,
     NEXT_SYM = 616,
     NODEGROUP_SYM = 617,
     NONE_SYM = 618,
     NOT2_SYM = 619,
     NOT_SYM = 620,
     NOW_SYM = 621,
     NO_SYM = 622,
     NO_WAIT_SYM = 623,
     NO_WRITE_TO_BINLOG = 624,
     NULL_SYM = 625,
     NUM = 626,
     NUMBER_SYM = 627,
     NUMERIC_SYM = 628,
     NVARCHAR_SYM = 629,
     OFFSET_SYM = 630,
     OLD_PASSWORD = 631,
     ON = 632,
     ONE_SYM = 633,
     ONLY_SYM = 634,
     ONLINE_SYM = 635,
     OPEN_SYM = 636,
     OPTIMIZE = 637,
     OPTIONS_SYM = 638,
     OPTION = 639,
     OPTIONALLY = 640,
     OR2_SYM = 641,
     ORDER_SYM = 642,
     OR_OR_SYM = 643,
     OR_SYM = 644,
     OUTER = 645,
     OUTFILE = 646,
     OUT_SYM = 647,
     OWNER_SYM = 648,
     PACK_KEYS_SYM = 649,
     PAGE_SYM = 650,
     PAGE_CHECKSUM_SYM = 651,
     PARAM_MARKER = 652,
     PARSER_SYM = 653,
     PARSE_VCOL_EXPR_SYM = 654,
     PARTIAL = 655,
     PARTITION_SYM = 656,
     PARTITIONS_SYM = 657,
     PARTITIONING_SYM = 658,
     PASSWORD = 659,
     PERSISTENT_SYM = 660,
     PHASE_SYM = 661,
     PLUGINS_SYM = 662,
     PLUGIN_SYM = 663,
     POINT_SYM = 664,
     POLYGON = 665,
     PORT_SYM = 666,
     POSITION_SYM = 667,
     PRECISION = 668,
     PREPARE_SYM = 669,
     PRESERVE_SYM = 670,
     PREV_SYM = 671,
     PRIMARY_SYM = 672,
     PRIVILEGES = 673,
     PROCEDURE_SYM = 674,
     PROCESS = 675,
     PROCESSLIST_SYM = 676,
     PROFILE_SYM = 677,
     PROFILES_SYM = 678,
     PROXY_SYM = 679,
     PURGE = 680,
     QUARTER_SYM = 681,
     QUERY_SYM = 682,
     QUICK = 683,
     RANGE_SYM = 684,
     READS_SYM = 685,
     READ_ONLY_SYM = 686,
     READ_SYM = 687,
     READ_WRITE_SYM = 688,
     REAL = 689,
     REBUILD_SYM = 690,
     RECOVER_SYM = 691,
     REDOFILE_SYM = 692,
     REDO_BUFFER_SIZE_SYM = 693,
     REDUNDANT_SYM = 694,
     REFERENCES = 695,
     REGEXP = 696,
     RELAY = 697,
     RELAYLOG_SYM = 698,
     RELAY_LOG_FILE_SYM = 699,
     RELAY_LOG_POS_SYM = 700,
     RELAY_THREAD = 701,
     RELEASE_SYM = 702,
     RELOAD = 703,
     REMOVE_SYM = 704,
     RENAME = 705,
     REORGANIZE_SYM = 706,
     REPAIR = 707,
     REPEATABLE_SYM = 708,
     REPEAT_SYM = 709,
     REPLACE = 710,
     REPLICATION = 711,
     REQUIRE_SYM = 712,
     RESET_SYM = 713,
     RESIGNAL_SYM = 714,
     RESOURCES = 715,
     RESTORE_SYM = 716,
     RESTRICT = 717,
     RESUME_SYM = 718,
     RETURNED_SQLSTATE_SYM = 719,
     RETURNING_SYM = 720,
     RETURNS_SYM = 721,
     RETURN_SYM = 722,
     REVERSE_SYM = 723,
     REVOKE = 724,
     RIGHT = 725,
     ROLE_SYM = 726,
     ROLLBACK_SYM = 727,
     ROLLUP_SYM = 728,
     ROUTINE_SYM = 729,
     ROWS_SYM = 730,
     ROW_FORMAT_SYM = 731,
     ROW_SYM = 732,
     ROW_COUNT_SYM = 733,
     RTREE_SYM = 734,
     SAVEPOINT_SYM = 735,
     SCHEDULE_SYM = 736,
     SCHEMA_NAME_SYM = 737,
     SECOND_MICROSECOND_SYM = 738,
     SECOND_SYM = 739,
     SECURITY_SYM = 740,
     SELECT_SYM = 741,
     SENSITIVE_SYM = 742,
     SEPARATOR_SYM = 743,
     SERIALIZABLE_SYM = 744,
     SERIAL_SYM = 745,
     SESSION_SYM = 746,
     SERVER_SYM = 747,
     SERVER_OPTIONS = 748,
     SET = 749,
     SET_VAR = 750,
     SHARE_SYM = 751,
     SHIFT_LEFT = 752,
     SHIFT_RIGHT = 753,
     SHOW = 754,
     SHUTDOWN = 755,
     SIGNAL_SYM = 756,
     SIGNED_SYM = 757,
     SIMPLE_SYM = 758,
     SLAVE = 759,
     SLAVES = 760,
     SLAVE_POS_SYM = 761,
     SLOW = 762,
     SMALLINT = 763,
     SNAPSHOT_SYM = 764,
     SOCKET_SYM = 765,
     SOFT_SYM = 766,
     SONAME_SYM = 767,
     SOUNDS_SYM = 768,
     SOURCE_SYM = 769,
     SPATIAL_SYM = 770,
     SPECIFIC_SYM = 771,
     SQLEXCEPTION_SYM = 772,
     SQLSTATE_SYM = 773,
     SQLWARNING_SYM = 774,
     SQL_BIG_RESULT = 775,
     SQL_BUFFER_RESULT = 776,
     SQL_CACHE_SYM = 777,
     SQL_CALC_FOUND_ROWS = 778,
     SQL_NO_CACHE_SYM = 779,
     SQL_SMALL_RESULT = 780,
     SQL_SYM = 781,
     SQL_THREAD = 782,
     SSL_SYM = 783,
     STARTING = 784,
     STARTS_SYM = 785,
     START_SYM = 786,
     STATS_AUTO_RECALC_SYM = 787,
     STATS_PERSISTENT_SYM = 788,
     STATS_SAMPLE_PAGES_SYM = 789,
     STATUS_SYM = 790,
     STDDEV_SAMP_SYM = 791,
     STD_SYM = 792,
     STOP_SYM = 793,
     STORAGE_SYM = 794,
     STRAIGHT_JOIN = 795,
     STRING_SYM = 796,
     SUBCLASS_ORIGIN_SYM = 797,
     SUBDATE_SYM = 798,
     SUBJECT_SYM = 799,
     SUBPARTITIONS_SYM = 800,
     SUBPARTITION_SYM = 801,
     SUBSTRING = 802,
     SUM_SYM = 803,
     SUPER_SYM = 804,
     SUSPEND_SYM = 805,
     SWAPS_SYM = 806,
     SWITCHES_SYM = 807,
     SYSDATE = 808,
     TABLES = 809,
     TABLESPACE = 810,
     TABLE_REF_PRIORITY = 811,
     TABLE_STATS_SYM = 812,
     TABLE_SYM = 813,
     TABLE_CHECKSUM_SYM = 814,
     TABLE_NAME_SYM = 815,
     TEMPORARY = 816,
     TEMPTABLE_SYM = 817,
     TERMINATED = 818,
     TEXT_STRING = 819,
     TEXT_SYM = 820,
     THAN_SYM = 821,
     THEN_SYM = 822,
     TIMESTAMP = 823,
     TIMESTAMP_ADD = 824,
     TIMESTAMP_DIFF = 825,
     TIME_SYM = 826,
     TINYBLOB = 827,
     TINYINT = 828,
     TINYTEXT = 829,
     TO_SYM = 830,
     TRAILING = 831,
     TRANSACTION_SYM = 832,
     TRANSACTIONAL_SYM = 833,
     TRIGGERS_SYM = 834,
     TRIGGER_SYM = 835,
     TRIM = 836,
     TRUE_SYM = 837,
     TRUNCATE_SYM = 838,
     TYPES_SYM = 839,
     TYPE_SYM = 840,
     UDF_RETURNS_SYM = 841,
     ULONGLONG_NUM = 842,
     UNCOMMITTED_SYM = 843,
     UNDEFINED_SYM = 844,
     UNDERSCORE_CHARSET = 845,
     UNDOFILE_SYM = 846,
     UNDO_BUFFER_SIZE_SYM = 847,
     UNDO_SYM = 848,
     UNICODE_SYM = 849,
     UNINSTALL_SYM = 850,
     UNION_SYM = 851,
     UNIQUE_SYM = 852,
     UNKNOWN_SYM = 853,
     UNLOCK_SYM = 854,
     UNSIGNED = 855,
     UNTIL_SYM = 856,
     UPDATE_SYM = 857,
     UPGRADE_SYM = 858,
     USAGE = 859,
     USER = 860,
     USER_STATS_SYM = 861,
     USE_FRM = 862,
     USE_SYM = 863,
     USING = 864,
     UTC_DATE_SYM = 865,
     UTC_TIMESTAMP_SYM = 866,
     UTC_TIME_SYM = 867,
     VALUES = 868,
     VALUE_SYM = 869,
     VARBINARY = 870,
     VARCHAR = 871,
     VARIABLES = 872,
     VARIANCE_SYM = 873,
     VARYING = 874,
     VAR_SAMP_SYM = 875,
     VIA_SYM = 876,
     VIEW_SYM = 877,
     VIRTUAL_SYM = 878,
     WAIT_SYM = 879,
     WARNINGS = 880,
     WEEK_SYM = 881,
     WEIGHT_STRING_SYM = 882,
     WHEN_SYM = 883,
     WHERE = 884,
     WHILE_SYM = 885,
     WITH = 886,
     WITH_CUBE_SYM = 887,
     WITH_ROLLUP_SYM = 888,
     WORK_SYM = 889,
     WRAPPER_SYM = 890,
     WRITE_SYM = 891,
     X509_SYM = 892,
     XA_SYM = 893,
     XML_SYM = 894,
     XOR = 895,
     YEAR_MONTH_SYM = 896,
     YEAR_SYM = 897,
     ZEROFILL = 898,
     IMPOSSIBLE_ACTION = 899
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQ 421
#define EQUAL_SYM 422
#define ERROR_SYM 423
#define ERRORS 424
#define ESCAPED 425
#define ESCAPE_SYM 426
#define EVENTS_SYM 427
#define EVENT_SYM 428
#define EVERY_SYM 429
#define EXCHANGE_SYM 430
#define EXAMINED_SYM 431
#define EXECUTE_SYM 432
#define EXISTS 433
#define EXIT_SYM 434
#define EXPANSION_SYM 435
#define EXPORT_SYM 436
#define EXTENDED_SYM 437
#define EXTENT_SIZE_SYM 438
#define EXTRACT_SYM 439
#define FALSE_SYM 440
#define FAST_SYM 441
#define FAULTS_SYM 442
#define FETCH_SYM 443
#define FILE_SYM 444
#define FIRST_SYM 445
#define FIXED_SYM 446
#define FLOAT_NUM 447
#define FLOAT_SYM 448
#define FLUSH_SYM 449
#define FORCE_SYM 450
#define FOREIGN 451
#define FOR_SYM 452
#define FOUND_SYM 453
#define FROM 454
#define FULL 455
#define FULLTEXT_SYM 456
#define FUNCTION_SYM 457
#define GE 458
#define GENERAL 459
#define GENERATED_SYM 460
#define GEOMETRYCOLLECTION 461
#define GEOMETRY_SYM 462
#define GET_FORMAT 463
#define GET_SYM 464
#define GLOBAL_SYM 465
#define GRANT 466
#define GRANTS 467
#define GROUP_SYM 468
#define GROUP_CONCAT_SYM 469
#define GT_SYM 470
#define HANDLER_SYM 471
#define HARD_SYM 472
#define HASH_SYM 473
#define HAVING 474
#define HELP_SYM 475
#define HEX_NUM 476
#define HEX_STRING 477
#define HIGH_PRIORITY 478
#define HOST_SYM 479
#define HOSTS_SYM 480
#define HOUR_MICROSECOND_SYM 481
#define HOUR_MINUTE_SYM 482
#define HOUR_SECOND_SYM 483
#define HOUR_SYM 484
#define ID_SYM 485
#define IDENT 486
#define IDENTIFIED_SYM 487
#define IDENT_QUOTED 488
#define IF 489
#define IGNORE_SYM 490
#define IGNORE_SERVER_IDS_SYM 491
#define IMPORT 492
#define INDEXES 493
#define INDEX_SYM 494
#define INDEX_STATS_SYM 495
#define INFILE 496
#define INITIAL_SIZE_SYM 497
#define INNER_SYM 498
#define INOUT_SYM 499
#define INSENSITIVE_SYM 500
#define INSERT 501
#define INSERT_METHOD 502
#define INSTALL_SYM 503
#define INTERVAL_SYM 504
#define INTO 505
#define INT_SYM 506
#define INVOKER_SYM 507
#define IN_SYM 508
#define IO_SYM 509
#define IPC_SYM 510
#define IS 511
#define ISOLATION 512
#define ISSUER_SYM 513
#define ITERATE_SYM 514
#define JOIN_SYM 515
#define KEYS 516
#define KEY_BLOCK_SIZE 517
#define KEY_SYM 518
#define KILL_SYM 519
#define LANGUAGE_SYM 520
#define LAST_SYM 521
#define LAST_VALUE 522
#define LE 523
#define LEADING 524
#define LEAVES 525
#define LEAVE_SYM 526
#define LEFT 527
#define LESS_SYM 528
#define LEVEL_SYM 529
#define LEX_HOSTNAME 530
#define LIKE 531
#define LIMIT 532
#define LINEAR_SYM 533
#define LINES 534
#define LINESTRING 535
#define LIST_SYM 536
#define LOAD 537
#define LOCAL_SYM 538
#define LOCATOR_SYM 539
#define LOCKS_SYM 540
#define LOCK_SYM 541
#define LOGFILE_SYM 542
#define LOGS_SYM 543
#define LONGBLOB 544
#define LONGTEXT 545
#define LONG_NUM 546
#define LONG_SYM 547
#define LOOP_SYM 548
#define LOW_PRIORITY 549
#define LT 550
#define MASTER_CONNECT_RETRY_SYM 551
#define MASTER_GTID_POS_SYM 552
#define MASTER_HOST_SYM 553
#define MASTER_LOG_FILE_SYM 554
#define MASTER_LOG_POS_SYM 555
#define MASTER_PASSWORD_SYM 556
#define MASTER_PORT_SYM 557
#define MASTER_SERVER_ID_SYM 558
#define MASTER_SSL_CAPATH_SYM 559
#define MASTER_SSL_CA_SYM 560
#define MASTER_SSL_CERT_SYM 561
#define MASTER_SSL_CIPHER_SYM 562
#define MASTER_SSL_CRL_SYM 563
#define MASTER_SSL_CRLPATH_SYM 564
#define MASTER_SSL_KEY_SYM 565
#define MASTER_SSL_SYM 566
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 567
#define MASTER_SYM 568
#define MASTER_USER_SYM 569
#define MASTER_USE_GTID_SYM 570
#define MASTER_HEARTBEAT_PERIOD_SYM 571
#define MATCH 572
#define MAX_CONNECTIONS_PER_HOUR 573
#define MAX_QUERIES_PER_HOUR 574
#define MAX_ROWS 575
#define MAX_SIZE_SYM 576
#define MAX_SYM 577
#define MAX_UPDATES_PER_HOUR 578
#define MAX_USER_CONNECTIONS_SYM 579
#define MAX_VALUE_SYM 580
#define MEDIUMBLOB 581
#define MEDIUMINT 582
#define MEDIUMTEXT 583
#define MEDIUM_SYM 584
#define MEMORY_SYM 585
#define MERGE_SYM 586
#define MESSAGE_TEXT_SYM 587
#define MICROSECOND_SYM 588
#define MIGRATE_SYM 589
#define MINUTE_MICROSECOND_SYM 590
#define MINUTE_SECOND_SYM 591
#define MINUTE_SYM 592
#define MIN_ROWS 593
#define MIN_SYM 594
#define MODE_SYM 595
#define MODIFIES_SYM 596
#define MODIFY_SYM 597
#define MOD_SYM 598
#define MONTH_SYM 599
#define MULTILINESTRING 600
#define MULTIPOINT 601
#define MULTIPOLYGON 602
#define MUTEX_SYM 603
#define MYSQL_SYM 604
#define MYSQL_ERRNO_SYM 605
#define NAMES_SYM 606
#define NAME_SYM 607
#define NATIONAL_SYM 608
#define NATURAL 609
#define NCHAR_STRING 610
#define NCHAR_SYM 611
#define NDBCLUSTER_SYM 612
#define NE 613
#define NEG 614
#define NEW_SYM 615
#define NEXT_SYM 616
#define NODEGROUP_SYM 617
#define NONE_SYM 618
#define NOT2_SYM 619
#define NOT_SYM 620
#define NOW_SYM 621
#define NO_SYM 622
#define NO_WAIT_SYM 623
#define NO_WRITE_TO_BINLOG 624
#define NULL_SYM 625
#define NUM 626
#define NUMBER_SYM 627
#define NUMERIC_SYM 628
#define NVARCHAR_SYM 629
#define OFFSET_SYM 630
#define OLD_PASSWORD 631
#define ON 632
#define ONE_SYM 633
#define ONLY_SYM 634
#define ONLINE_SYM 635
#define OPEN_SYM 636
#define OPTIMIZE 637
#define OPTIONS_SYM 638
#define OPTION 639
#define OPTIONALLY 640
#define OR2_SYM 641
#define ORDER_SYM 642
#define OR_OR_SYM 643
#define OR_SYM 644
#define OUTER 645
#define OUTFILE 646
#define OUT_SYM 647
#define OWNER_SYM 648
#define PACK_KEYS_SYM 649
#define PAGE_SYM 650
#define PAGE_CHECKSUM_SYM 651
#define PARAM_MARKER 652
#define PARSER_SYM 653
#define PARSE_VCOL_EXPR_SYM 654
#define PARTIAL 655
#define PARTITION_SYM 656
#define PARTITIONS_SYM 657
#define PARTITIONING_SYM 658
#define PASSWORD 659
#define PERSISTENT_SYM 660
#define PHASE_SYM 661
#define PLUGINS_SYM 662
#define PLUGIN_SYM 663
#define POINT_SYM 664
#define POLYGON 665
#define PORT_SYM 666
#define POSITION_SYM 667
#define PRECISION 668
#define PREPARE_SYM 669
#define PRESERVE_SYM 670
#define PREV_SYM 671
#define PRIMARY_SYM 672
#define PRIVILEGES 673
#define PROCEDURE_SYM 674
#define PROCESS 675
#define PROCESSLIST_SYM 676
#define PROFILE_SYM 677
#define PROFILES_SYM 678
#define PROXY_SYM 679
#define PURGE 680
#define QUARTER_SYM 681
#define QUERY_SYM 682
#define QUICK 683
#define RANGE_SYM 684
#define READS_SYM 685
#define READ_ONLY_SYM 686
#define READ_SYM 687
#define READ_WRITE_SYM 688
#define REAL 689
#define REBUILD_SYM 690
#define RECOVER_SYM 691
#define REDOFILE_SYM 692
#define REDO_BUFFER_SIZE_SYM 693
#define REDUNDANT_SYM 694
#define REFERENCES 695
#define REGEXP 696
#define RELAY 697
#define RELAYLOG_SYM 698
#define RELAY_LOG_FILE_SYM 699
#define RELAY_LOG_POS_SYM 700
#define RELAY_THREAD 701
#define RELEASE_SYM 702
#define RELOAD 703
#define REMOVE_SYM 704
#define RENAME 705
#define REORGANIZE_SYM 706
#define REPAIR 707
#define REPEATABLE_SYM 708
#define REPEAT_SYM 709
#define REPLACE 710
#define REPLICATION 711
#define REQUIRE_SYM 712
#define RESET_SYM 713
#define RESIGNAL_SYM 714
#define RESOURCES 715
#define RESTORE_SYM 716
#define RESTRICT 717
#define RESUME_SYM 718
#define RETURNED_SQLSTATE_SYM 719
#define RETURNING_SYM 720
#define RETURNS_SYM 721
#define RETURN_SYM 722
#define REVERSE_SYM 723
#define REVOKE 724
#define RIGHT 725
#define ROLE_SYM 726
#define ROLLBACK_SYM 727
#define ROLLUP_SYM 728
#define ROUTINE_SYM 729
#define ROWS_SYM 730
#define ROW_FORMAT_SYM 731
#define ROW_SYM 732
#define ROW_COUNT_SYM 733
#define RTREE_SYM 734
#define SAVEPOINT_SYM 735
#define SCHEDULE_SYM 736
#define SCHEMA_NAME_SYM 737
#define SECOND_MICROSECOND_SYM 738
#define SECOND_SYM 739
#define SECURITY_SYM 740
#define SELECT_SYM 741
#define SENSITIVE_SYM 742
#define SEPARATOR_SYM 743
#define SERIALIZABLE_SYM 744
#define SERIAL_SYM 745
#define SESSION_SYM 746
#define SERVER_SYM 747
#define SERVER_OPTIONS 748
#define SET 749
#define SET_VAR 750
#define SHARE_SYM 751
#define SHIFT_LEFT 752
#define SHIFT_RIGHT 753
#define SHOW 754
#define SHUTDOWN 755
#define SIGNAL_SYM 756
#define SIGNED_SYM 757
#define SIMPLE_SYM 758
#define SLAVE 759
#define SLAVES 760
#define SLAVE_POS_SYM 761
#define SLOW 762
#define SMALLINT 763
#define SNAPSHOT_SYM 764
#define SOCKET_SYM 765
#define SOFT_SYM 766
#define SONAME_SYM 767
#define SOUNDS_SYM 768
#define SOURCE_SYM 769
#define SPATIAL_SYM 770
#define SPECIFIC_SYM 771
#define SQLEXCEPTION_SYM 772
#define SQLSTATE_SYM 773
#define SQLWARNING_SYM 774
#define SQL_BIG_RESULT 775
#define SQL_BUFFER_RESULT 776
#define SQL_CACHE_SYM 777
#define SQL_CALC_FOUND_ROWS 778
#define SQL_NO_CACHE_SYM 779
#define SQL_SMALL_RESULT 780
#define SQL_SYM 781
#define SQL_THREAD 782
#define SSL_SYM 783
#define STARTING 784
#define STARTS_SYM 785
#define START_SYM 786
#define STATS_AUTO_RECALC_SYM 787
#define STATS_PERSISTENT_SYM 788
#define STATS_SAMPLE_PAGES_SYM 789
#define STATUS_SYM 790
#define STDDEV_SAMP_SYM 791
#define STD_SYM 792
#define STOP_SYM 793
#define STORAGE_SYM 794
#define STRAIGHT_JOIN 795
#define STRING_SYM 796
#define SUBCLASS_ORIGIN_SYM 797
#define SUBDATE_SYM 798
#define SUBJECT_SYM 799
#define SUBPARTITIONS_SYM 800
#define SUBPARTITION_SYM 801
#define SUBSTRING 802
#define SUM_SYM 803
#define SUPER_SYM 804
#define SUSPEND_SYM 805
#define SWAPS_SYM 806
#define SWITCHES_SYM 807
#define SYSDATE 808
#define TABLES 809
#define TABLESPACE 810
#define TABLE_REF_PRIORITY 811
#define TABLE_STATS_SYM 812
#define TABLE_SYM 813
#define TABLE_CHECKSUM_SYM 814
#define TABLE_NAME_SYM 815
#define TEMPORARY 816
#define TEMPTABLE_SYM 817
#define TERMINATED 818
#define TEXT_STRING 819
#define TEXT_SYM 820
#define THAN_SYM 821
#define THEN_SYM 822
#define TIMESTAMP 823
#define TIMESTAMP_ADD 824
#define TIMESTAMP_DIFF 825
#define TIME_SYM 826
#define TINYBLOB 827
#define TINYINT 828
#define TINYTEXT 829
#define TO_SYM 830
#define TRAILING 831
#define TRANSACTION_SYM 832
#define TRANSACTIONAL_SYM 833
#define TRIGGERS_SYM 834
#define TRIGGER_SYM 835
#define TRIM 836
#define TRUE_SYM 837
#define TRUNCATE_SYM 838
#define TYPES_SYM 839
#define TYPE_SYM 840
#define UDF_RETURNS_SYM 841
#define ULONGLONG_NUM 842
#define UNCOMMITTED_SYM 843
#define UNDEFINED_SYM 844
#define UNDERSCORE_CHARSET 845
#define UNDOFILE_SYM 846
#define UNDO_BUFFER_SIZE_SYM 847
#define UNDO_SYM 848
#define UNICODE_SYM 849
#define UNINSTALL_SYM 850
#define UNION_SYM 851
#define UNIQUE_SYM 852
#define UNKNOWN_SYM 853
#define UNLOCK_SYM 854
#define UNSIGNED 855
#define UNTIL_SYM 856
#define UPDATE_SYM 857
#define UPGRADE_SYM 858
#define USAGE 859
#define USER 860
#define USER_STATS_SYM 861
#define USE_FRM 862
#define USE_SYM 863
#define USING 864
#define UTC_DATE_SYM 865
#define UTC_TIMESTAMP_SYM 866
#define UTC_TIME_SYM 867
#define VALUES 868
#define VALUE_SYM 869
#define VARBINARY 870
#define VARCHAR 871
#define VARIABLES 872
#define VARIANCE_SYM 873
#define VARYING 874
#define VAR_SAMP_SYM 875
#define VIA_SYM 876
#define VIEW_SYM 877
#define VIRTUAL_SYM 878
#define WAIT_SYM 879
#define WARNINGS 880
#define WEEK_SYM 881
#define WEIGHT_STRING_SYM 882
#define WHEN_SYM 883
#define WHERE 884
#define WHILE_SYM 885
#define WITH 886
#define WITH_CUBE_SYM 887
#define WITH_ROLLUP_SYM 888
#define WORK_SYM 889
#define WRAPPER_SYM 890
#define WRITE_SYM 891
#define X509_SYM 892
#define XA_SYM 893
#define XML_SYM 894
#define XOR 895
#define YEAR_MONTH_SYM 896
#define YEAR_SYM 897
#define ZEROFILL 898
#define IMPOSSIBLE_ACTION 899




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 897 "/home/buildbot/git/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  LEX_TYPE lex_type;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2342 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 958 "/home/buildbot/git/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2359 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  623
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   66118

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  664
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1003
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2831
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4803

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   899

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   657,     2,     2,     2,   651,   646,     2,
     654,   655,   649,   648,   656,   647,   662,   650,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   663,   660,
       2,     2,     2,     2,   661,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   652,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   658,   645,   659,   653,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   129,   131,   135,   137,   139,   144,
     146,   149,   150,   155,   156,   159,   163,   165,   168,   169,
     173,   174,   181,   183,   187,   191,   195,   199,   203,   207,
     211,   215,   219,   223,   227,   231,   235,   239,   243,   247,
     253,   255,   256,   258,   262,   264,   268,   272,   276,   280,
     284,   288,   292,   293,   295,   297,   298,   306,   307,   308,
     324,   325,   326,   342,   343,   344,   360,   361,   368,   369,
     373,   378,   384,   389,   393,   396,   407,   409,   413,   416,
     419,   422,   425,   428,   431,   434,   435,   449,   450,   457,
     460,   461,   463,   467,   469,   470,   473,   474,   477,   478,
     480,   484,   489,   490,   493,   494,   497,   499,   501,   503,
     505,   507,   509,   511,   513,   515,   517,   519,   521,   523,
     524,   528,   530,   531,   534,   535,   538,   541,   544,   547,
     550,   554,   558,   560,   562,   564,   567,   571,   575,   576,
     581,   582,   586,   587,   589,   593,   595,   596,   598,   602,
     604,   605,   609,   610,   612,   616,   618,   623,   624,   626,
     628,   630,   631,   635,   638,   642,   643,   647,   648,   654,
     660,   661,   669,   675,   676,   679,   681,   683,   685,   689,
     691,   693,   695,   699,   700,   702,   704,   706,   708,   711,
     713,   717,   719,   721,   722,   724,   725,   728,   732,   738,
     740,   742,   744,   746,   748,   750,   752,   754,   756,   758,
     760,   762,   764,   766,   768,   772,   777,   778,   780,   782,
     786,   788,   792,   796,   798,   801,   803,   805,   807,   809,
     813,   817,   819,   821,   823,   825,   827,   829,   831,   833,
     835,   837,   839,   841,   843,   845,   849,   850,   853,   855,
     857,   859,   861,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   880,   886,   887,   890,   891,   895,   896,   899,
     902,   905,   908,   909,   916,   919,   920,   923,   925,   927,
     931,   932,   933,   934,   942,   943,   946,   949,   951,   953,
     954,   955,   964,   965,   972,   974,   977,   979,   982,   983,
     984,   991,   992,   993,  1000,  1001,  1004,  1005,  1011,  1012,
    1014,  1015,  1021,  1022,  1025,  1026,  1032,  1037,  1038,  1039,
    1048,  1049,  1057,  1059,  1061,  1063,  1065,  1067,  1070,  1075,
    1081,  1082,  1087,  1092,  1097,  1101,  1105,  1108,  1111,  1112,
    1115,  1117,  1120,  1124,  1126,  1128,  1130,  1132,  1134,  1137,
    1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,
    1161,  1164,  1168,  1170,  1172,  1174,  1176,  1178,  1180,  1182,
    1185,  1189,  1191,  1193,  1195,  1197,  1199,  1201,  1203,  1205,
    1207,  1210,  1214,  1216,  1218,  1220,  1223,  1226,  1229,  1231,
    1233,  1235,  1237,  1240,  1244,  1248,  1252,  1256,  1260,  1264,
    1268,  1272,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1289,
    1297,  1301,  1302,  1308,  1310,  1313,  1318,  1319,  1320,  1326,
    1327,  1335,  1337,  1338,  1340,  1341,  1346,  1347,  1348,  1352,
    1358,  1365,  1366,  1371,  1374,  1377,  1380,  1383,  1384,  1386,
    1387,  1391,  1392,  1394,  1396,  1400,  1402,  1407,  1413,  1419,
    1420,  1423,  1424,  1425,  1433,  1434,  1445,  1447,  1451,  1453,
    1455,  1456,  1459,  1460,  1464,  1466,  1470,  1471,  1478,  1480,
    1481,  1482,  1488,  1489,  1494,  1496,  1498,  1500,  1504,  1506,
    1510,  1511,  1512,  1518,  1520,  1524,  1526,  1528,  1529,  1533,
    1535,  1539,  1540,  1545,  1547,  1548,  1550,  1553,  1555,  1559,
    1564,  1568,  1572,  1576,  1580,  1585,  1590,  1594,  1595,  1596,
    1603,  1604,  1606,  1607,  1609,  1611,  1614,  1616,  1618,  1619,
    1621,  1623,  1626,  1628,  1629,  1633,  1635,  1639,  1640,  1642,
    1644,  1647,  1649,  1652,  1656,  1660,  1664,  1668,  1672,  1676,
    1680,  1684,  1688,  1692,  1696,  1700,  1704,  1708,  1712,  1716,
    1720,  1724,  1728,  1732,  1736,  1737,  1744,  1746,  1748,  1752,
    1757,  1762,  1765,  1768,  1771,  1775,  1779,  1783,  1787,  1791,
    1795,  1799,  1804,  1809,  1811,  1813,  1815,  1817,  1819,  1821,
    1823,  1825,  1827,  1829,  1831,  1833,  1835,  1838,  1840,  1842,
    1844,  1846,  1848,  1850,  1854,  1856,  1858,  1861,  1864,  1865,
    1874,  1875,  1885,  1886,  1896,  1897,  1907,  1916,  1919,  1920,
    1922,  1927,  1928,  1930,  1933,  1934,  1938,  1941,  1942,  1952,
    1953,  1956,  1957,  1959,  1961,  1962,  1964,  1967,  1969,  1971,
    1974,  1977,  1982,  1986,  1990,  1994,  1998,  2000,  2003,  2005,
    2007,  2011,  2014,  2018,  2021,  2024,  2026,  2030,  2034,  2037,
    2041,  2043,  2046,  2049,  2052,  2054,  2057,  2059,  2061,  2063,
    2066,  2070,  2073,  2077,  2080,  2083,  2087,  2091,  2095,  2096,
    2103,  2104,  2111,  2114,  2116,  2118,  2120,  2122,  2124,  2126,
    2128,  2130,  2132,  2134,  2136,  2139,  2142,  2144,  2147,  2149,
    2152,  2156,  2159,  2161,  2163,  2165,  2167,  2169,  2171,  2173,
    2176,  2177,  2179,  2181,  2187,  2188,  2190,  2193,  2195,  2197,
    2199,  2201,  2205,  2209,  2213,  2217,  2218,  2220,  2221,  2223,
    2224,  2226,  2229,  2231,  2233,  2236,  2239,  2244,  2246,  2250,
    2253,  2255,  2258,  2261,  2264,  2268,  2272,  2276,  2280,  2283,
    2286,  2288,  2291,  2293,  2295,  2297,  2299,  2301,  2302,  2305,
    2307,  2309,  2311,  2313,  2315,  2316,  2319,  2321,  2323,  2324,
    2326,  2328,  2331,  2334,  2336,  2339,  2342,  2343,  2345,  2347,
    2349,  2353,  2355,  2359,  2360,  2362,  2363,  2368,  2370,  2372,
    2374,  2375,  2377,  2380,  2382,  2384,  2387,  2389,  2393,  2397,
    2399,  2401,  2402,  2405,  2406,  2408,  2414,  2415,  2419,  2423,
    2425,  2426,  2429,  2432,  2435,  2436,  2440,  2444,  2451,  2458,
    2460,  2462,  2465,  2468,  2471,  2473,  2476,  2479,  2481,  2483,
    2484,  2486,  2488,  2490,  2492,  2493,  2495,  2497,  2499,  2500,
    2502,  2505,  2506,  2508,  2509,  2511,  2512,  2514,  2516,  2519,
    2521,  2524,  2526,  2529,  2532,  2535,  2539,  2542,  2546,  2550,
    2554,  2558,  2560,  2562,  2564,  2566,  2570,  2572,  2574,  2576,
    2581,  2584,  2586,  2591,  2592,  2594,  2597,  2598,  2601,  2603,
    2607,  2608,  2609,  2617,  2618,  2624,  2632,  2633,  2639,  2640,
    2646,  2647,  2653,  2654,  2659,  2660,  2671,  2675,  2680,  2684,
    2688,  2696,  2697,  2701,  2703,  2708,  2709,  2713,  2714,  2717,
    2718,  2720,  2721,  2724,  2727,  2730,  2733,  2735,  2737,  2739,
    2744,  2749,  2750,  2757,  2762,  2763,  2769,  2770,  2777,  2782,
    2786,  2788,  2796,  2799,  2801,  2803,  2804,  2811,  2812,  2816,
    2819,  2820,  2826,  2827,  2828,  2835,  2837,  2841,  2843,  2845,
    2849,  2853,  2857,  2860,  2865,  2866,  2874,  2875,  2876,  2885,
    2891,  2897,  2901,  2906,  2909,  2912,  2919,  2925,  2929,  2935,
    2937,  2939,  2941,  2943,  2945,  2946,  2948,  2950,  2953,  2956,
    2960,  2964,  2968,  2972,  2973,  2975,  2976,  2978,  2979,  2982,
    2983,  2985,  2988,  2990,  2992,  2994,  2995,  2997,  2999,  3000,
    3003,  3005,  3006,  3008,  3010,  3012,  3013,  3020,  3021,  3027,
    3032,  3037,  3041,  3042,  3044,  3046,  3050,  3054,  3057,  3060,
    3061,  3064,  3066,  3070,  3071,  3073,  3075,  3076,  3079,  3084,
    3086,  3090,  3091,  3097,  3098,  3100,  3102,  3106,  3107,  3112,
    3113,  3118,  3119,  3121,  3123,  3126,  3128,  3130,  3132,  3133,
    3136,  3137,  3143,  3145,  3149,  3152,  3153,  3157,  3159,  3164,
    3166,  3167,  3172,  3174,  3175,  3180,  3181,  3183,  3187,  3188,
    3190,  3194,  3196,  3198,  3201,  3205,  3206,  3211,  3212,  3216,
    3217,  3219,  3221,  3224,  3226,  3228,  3230,  3232,  3234,  3237,
    3238,  3241,  3242,  3248,  3249,  3251,  3253,  3254,  3259,  3264,
    3268,  3274,  3276,  3280,  3284,  3285,  3292,  3294,  3296,  3298,
    3302,  3305,  3309,  3311,  3313,  3314,  3321,  3323,  3325,  3327,
    3331,  3335,  3340,  3341,  3348,  3349,  3352,  3353,  3358,  3359,
    3362,  3364,  3367,  3372,  3375,  3379,  3382,  3386,  3387,  3391,
    3392,  3393,  3400,  3403,  3405,  3407,  3410,  3413,  3422,  3427,
    3428,  3430,  3433,  3435,  3437,  3439,  3441,  3442,  3445,  3450,
    3454,  3456,  3458,  3462,  3467,  3468,  3469,  3470,  3473,  3476,
    3478,  3480,  3481,  3484,  3488,  3489,  3492,  3496,  3497,  3500,
    3504,  3508,  3512,  3515,  3519,  3524,  3528,  3533,  3537,  3542,
    3544,  3548,  3553,  3557,  3561,  3568,  3570,  3576,  3583,  3589,
    3597,  3604,  3613,  3619,  3626,  3631,  3636,  3642,  3646,  3651,
    3653,  3657,  3661,  3665,  3669,  3673,  3677,  3683,  3689,  3693,
    3697,  3701,  3705,  3709,  3713,  3715,  3717,  3719,  3721,  3723,
    3725,  3727,  3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,
    3745,  3747,  3748,  3751,  3753,  3756,  3758,  3760,  3762,  3765,
    3768,  3770,  3772,  3775,  3778,  3783,  3785,  3789,  3791,  3793,
    3795,  3797,  3799,  3803,  3805,  3807,  3809,  3811,  3815,  3818,
    3821,  3824,  3827,  3831,  3835,  3841,  3848,  3853,  3858,  3866,
    3869,  3876,  3882,  3889,  3896,  3901,  3906,  3912,  3917,  3924,
    3927,  3930,  3935,  3940,  3945,  3956,  3963,  3972,  3979,  3984,
    3989,  3996,  4001,  4006,  4011,  4018,  4023,  4031,  4039,  4047,
    4054,  4061,  4068,  4075,  4079,  4084,  4091,  4100,  4103,  4106,
    4115,  4124,  4131,  4138,  4141,  4148,  4155,  4164,  4173,  4180,
    4189,  4196,  4199,  4208,  4217,  4220,  4223,  4226,  4233,  4240,
    4245,  4250,  4259,  4264,  4269,  4274,  4279,  4283,  4292,  4297,
    4302,  4309,  4314,  4319,  4324,  4331,  4340,  4345,  4349,  4356,
    4361,  4368,  4374,  4383,  4391,  4402,  4404,  4411,  4416,  4421,
    4426,  4431,  4436,  4443,  4448,  4449,  4455,  4462,  4465,  4469,
    4470,  4475,  4476,  4480,  4481,  4483,  4485,  4489,  4494,  4499,
    4505,  4510,  4515,  4520,  4526,  4531,  4532,  4533,  4541,  4546,
    4552,  4557,  4563,  4568,  4573,  4578,  4583,  4588,  4594,  4595,
    4604,  4605,  4609,  4613,  4615,  4620,  4621,  4623,  4624,  4627,
    4628,  4629,  4634,  4639,  4642,  4643,  4647,  4650,  4654,  4657,
    4659,  4661,  4664,  4666,  4669,  4671,  4674,  4677,  4680,  4681,
    4685,  4686,  4688,  4690,  4694,  4696,  4700,  4702,  4706,  4707,
    4709,  4710,  4713,  4718,  4724,  4726,  4728,  4730,  4732,  4737,
    4739,  4743,  4747,  4748,  4755,  4756,  4765,  4770,  4771,  4780,
    4781,  4792,  4799,  4800,  4809,  4810,  4821,  4828,  4830,  4833,
    4835,  4837,  4840,  4841,  4843,  4849,  4850,  4856,  4860,  4866,
    4869,  4870,  4871,  4879,  4881,  4882,  4883,  4890,  4891,  4895,
    4896,  4897,  4903,  4904,  4906,  4907,  4909,  4910,  4913,  4917,
    4921,  4923,  4925,  4926,  4934,  4935,  4943,  4945,  4948,  4949,
    4950,  4953,  4954,  4957,  4958,  4960,  4962,  4964,  4966,  4970,
    4972,  4976,  4978,  4980,  4982,  4984,  4986,  4988,  4990,  4992,
    4994,  4996,  4998,  5000,  5002,  5004,  5006,  5008,  5010,  5012,
    5014,  5016,  5018,  5020,  5022,  5024,  5026,  5027,  5029,  5031,
    5032,  5035,  5036,  5038,  5039,  5040,  5044,  5045,  5046,  5050,
    5053,  5054,  5055,  5060,  5065,  5068,  5069,  5071,  5073,  5077,
    5081,  5083,  5086,  5087,  5089,  5090,  5095,  5100,  5103,  5104,
    5106,  5108,  5109,  5111,  5112,  5114,  5117,  5123,  5128,  5130,
    5134,  5138,  5140,  5142,  5144,  5146,  5148,  5150,  5151,  5154,
    5158,  5163,  5165,  5168,  5171,  5173,  5175,  5177,  5179,  5181,
    5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,
    5203,  5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,
    5223,  5224,  5225,  5232,  5233,  5235,  5239,  5241,  5245,  5246,
    5249,  5253,  5255,  5258,  5260,  5261,  5265,  5266,  5267,  5275,
    5278,  5280,  5281,  5285,  5286,  5294,  5295,  5303,  5308,  5315,
    5320,  5325,  5330,  5335,  5336,  5343,  5348,  5353,  5359,  5366,
    5371,  5373,  5377,  5379,  5382,  5384,  5388,  5390,  5391,  5394,
    5395,  5397,  5398,  5399,  5408,  5409,  5410,  5417,  5418,  5420,
    5422,  5424,  5426,  5428,  5431,  5433,  5435,  5437,  5441,  5446,
    5447,  5451,  5455,  5457,  5460,  5463,  5464,  5468,  5469,  5475,
    5479,  5481,  5485,  5487,  5491,  5493,  5495,  5496,  5498,  5499,
    5504,  5505,  5507,  5511,  5513,  5515,  5517,  5518,  5519,  5526,
    5527,  5528,  5540,  5544,  5546,  5550,  5554,  5556,  5560,  5561,
    5563,  5564,  5569,  5570,  5571,  5581,  5582,  5588,  5589,  5596,
    5597,  5600,  5602,  5606,  5609,  5614,  5615,  5618,  5619,  5622,
    5624,  5626,  5628,  5629,  5634,  5635,  5637,  5638,  5640,  5642,
    5646,  5648,  5650,  5653,  5656,  5659,  5661,  5663,  5665,  5667,
    5668,  5672,  5673,  5677,  5680,  5685,  5690,  5694,  5699,  5704,
    5706,  5710,  5714,  5718,  5722,  5729,  5732,  5735,  5736,  5743,
    5744,  5752,  5758,  5761,  5763,  5765,  5767,  5773,  5779,  5782,
    5785,  5787,  5792,  5796,  5799,  5803,  5806,  5809,  5811,  5815,
    5820,  5824,  5828,  5831,  5835,  5838,  5842,  5844,  5846,  5848,
    5850,  5854,  5858,  5862,  5866,  5870,  5874,  5878,  5882,  5886,
    5888,  5890,  5892,  5894,  5896,  5897,  5899,  5900,  5903,  5904,
    5906,  5908,  5910,  5911,  5914,  5915,  5918,  5919,  5922,  5925,
    5926,  5931,  5932,  5937,  5939,  5941,  5943,  5945,  5947,  5949,
    5951,  5952,  5954,  5956,  5957,  5959,  5961,  5962,  5967,  5968,
    5973,  5975,  5976,  5978,  5983,  5984,  5988,  5992,  5994,  5997,
    6000,  6003,  6006,  6009,  6013,  6016,  6018,  6020,  6022,  6024,
    6027,  6029,  6031,  6033,  6035,  6037,  6039,  6041,  6042,  6044,
    6045,  6049,  6050,  6054,  6058,  6060,  6061,  6066,  6068,  6071,
    6072,  6074,  6075,  6079,  6083,  6086,  6089,  6090,  6096,  6097,
    6099,  6101,  6102,  6104,  6106,  6109,  6111,  6114,  6116,  6119,
    6120,  6121,  6122,  6123,  6146,  6148,  6150,  6151,  6153,  6154,
    6156,  6158,  6159,  6161,  6163,  6164,  6167,  6170,  6172,  6176,
    6181,  6185,  6189,  6190,  6193,  6196,  6198,  6202,  6206,  6207,
    6212,  6213,  6217,  6219,  6221,  6222,  6226,  6229,  6233,  6235,
    6237,  6240,  6241,  6244,  6248,  6250,  6256,  6258,  6260,  6263,
    6266,  6268,  6270,  6272,  6274,  6276,  6278,  6280,  6283,  6286,
    6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6307,
    6309,  6311,  6313,  6315,  6317,  6320,  6323,  6326,  6328,  6330,
    6334,  6340,  6342,  6344,  6346,  6348,  6350,  6354,  6359,  6365,
    6367,  6373,  6377,  6380,  6382,  6386,  6389,  6392,  6397,  6399,
    6401,  6403,  6405,  6407,  6409,  6411,  6413,  6415,  6417,  6419,
    6421,  6423,  6425,  6429,  6432,  6434,  6436,  6438,  6440,  6442,
    6444,  6446,  6448,  6450,  6452,  6454,  6456,  6458,  6460,  6462,
    6464,  6466,  6468,  6470,  6472,  6474,  6476,  6478,  6480,  6482,
    6484,  6486,  6488,  6490,  6492,  6494,  6496,  6498,  6500,  6502,
    6504,  6506,  6508,  6510,  6512,  6514,  6516,  6518,  6520,  6522,
    6524,  6526,  6528,  6530,  6532,  6534,  6536,  6538,  6540,  6542,
    6544,  6546,  6548,  6550,  6552,  6554,  6556,  6558,  6560,  6562,
    6564,  6566,  6568,  6570,  6572,  6574,  6576,  6578,  6580,  6582,
    6584,  6586,  6588,  6590,  6592,  6594,  6596,  6598,  6600,  6602,
    6604,  6606,  6608,  6610,  6612,  6614,  6616,  6618,  6620,  6622,
    6624,  6626,  6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,
    6644,  6646,  6648,  6650,  6652,  6654,  6656,  6658,  6660,  6662,
    6664,  6666,  6668,  6670,  6672,  6674,  6676,  6678,  6680,  6682,
    6684,  6686,  6688,  6690,  6692,  6694,  6696,  6698,  6700,  6702,
    6704,  6706,  6708,  6710,  6712,  6714,  6716,  6718,  6720,  6722,
    6724,  6726,  6728,  6730,  6732,  6734,  6736,  6738,  6740,  6742,
    6744,  6746,  6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,
    6764,  6766,  6768,  6770,  6772,  6774,  6776,  6778,  6780,  6782,
    6784,  6786,  6788,  6790,  6792,  6794,  6796,  6798,  6800,  6802,
    6804,  6806,  6808,  6810,  6812,  6814,  6816,  6818,  6820,  6822,
    6824,  6826,  6828,  6830,  6832,  6834,  6836,  6838,  6840,  6842,
    6844,  6846,  6848,  6850,  6852,  6854,  6856,  6858,  6860,  6862,
    6864,  6866,  6868,  6870,  6872,  6874,  6876,  6878,  6880,  6882,
    6884,  6886,  6888,  6890,  6892,  6894,  6896,  6898,  6900,  6902,
    6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,  6920,  6922,
    6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,  6940,  6942,
    6944,  6946,  6948,  6950,  6952,  6954,  6956,  6958,  6960,  6962,
    6964,  6966,  6968,  6970,  6972,  6974,  6976,  6978,  6980,  6982,
    6984,  6986,  6988,  6990,  6992,  6994,  6996,  6998,  7000,  7002,
    7004,  7006,  7008,  7010,  7012,  7014,  7016,  7018,  7020,  7022,
    7024,  7026,  7028,  7030,  7032,  7034,  7036,  7038,  7040,  7042,
    7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,  7060,  7062,
    7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,  7080,  7082,
    7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,  7100,  7102,
    7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,  7120,  7122,
    7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,  7140,  7142,
    7144,  7146,  7148,  7150,  7152,  7154,  7156,  7158,  7160,  7162,
    7164,  7166,  7168,  7170,  7172,  7174,  7176,  7178,  7180,  7181,
    7185,  7186,  7190,  7191,  7195,  7196,  7200,  7201,  7205,  7208,
    7209,  7212,  7213,  7216,  7217,  7222,  7223,  7227,  7229,  7231,
    7233,  7235,  7236,  7238,  7240,  7242,  7243,  7246,  7249,  7252,
    7256,  7260,  7265,  7272,  7275,  7279,  7283,  7286,  7290,  7296,
    7298,  7302,  7306,  7308,  7310,  7314,  7318,  7320,  7324,  7327,
    7330,  7333,  7336,  7339,  7341,  7343,  7348,  7353,  7355,  7357,
    7359,  7361,  7363,  7364,  7369,  7371,  7373,  7375,  7379,  7383,
    7385,  7387,  7390,  7393,  7396,  7397,  7401,  7406,  7410,  7411,
    7419,  7421,  7424,  7426,  7428,  7430,  7432,  7434,  7436,  7437,
    7443,  7445,  7447,  7449,  7451,  7453,  7457,  7464,  7471,  7478,
    7486,  7492,  7496,  7501,  7503,  7507,  7516,  7525,  7534,  7541,
    7546,  7547,  7551,  7552,  7556,  7558,  7562,  7565,  7567,  7569,
    7570,  7572,  7574,  7577,  7578,  7580,  7582,  7586,  7587,  7591,
    7592,  7596,  7597,  7601,  7602,  7606,  7608,  7610,  7612,  7614,
    7616,  7618,  7620,  7622,  7624,  7626,  7628,  7631,  7634,  7636,
    7640,  7643,  7646,  7649,  7652,  7655,  7658,  7661,  7664,  7666,
    7668,  7671,  7672,  7674,  7678,  7680,  7683,  7686,  7689,  7691,
    7695,  7699,  7701,  7703,  7707,  7709,  7713,  7715,  7719,  7721,
    7723,  7725,  7727,  7732,  7738,  7743,  7750,  7752,  7753,  7757,
    7761,  7763,  7765,  7766,  7769,  7772,  7775,  7778,  7779,  7782,
    7783,  7787,  7790,  7792,  7795,  7798,  7801,  7804,  7807,  7808,
    7812,  7813,  7815,  7816,  7820,  7823,  7824,  7826,  7829,  7830,
    7832,  7837,  7842,  7848,  7851,  7855,  7856,  7858,  7859,  7864,
    7865,  7867,  7869,  7870,  7872,  7873,  7876,  7879,  7881,  7882,
    7884,  7886,  7889,  7893,  7896,  7897,  7904,  7908,  7909,  7910,
    7911,  7913,  7916,  7918,  7920,  7922,  7924,  7926,  7928,  7930,
    7932,  7934,  7937,  7940,  7944,  7946,  7948,  7950,  7952,  7954,
    7956,  7958,  7960,  7962,  7964,  7966,  7968,  7970,  7971,  7975,
    7979,  7983,  7987,  7988,  7992,  7996,  7997,  8005,  8006,  8010,
    8012,  8016,  8017,  8021,  8024,  8029,  8030,  8034,  8039,  8044,
    8045,  8046,  8047,  8064,  8073,  8081,  8082,  8083,  8084,  8085,
    8086,  8102,  8103,  8104,  8105,  8106,  8119,  8124,  8129,  8133,
    8138,  8142,  8145,  8147,  8151,  8157,  8159,  8161,  8162,  8164,
    8166,  8167,  8170,  8171,  8172,  8176,  8177,  8180,  8186,  8190,
    8194,  8198
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     665,     0,    -1,   162,    -1,    -1,   668,   666,   660,   667,
      -1,   668,   162,    -1,    -1,   162,    -1,   669,    -1,  1596,
      -1,  1055,    -1,  1126,    -1,  1139,    -1,   723,    -1,   681,
      -1,  1142,    -1,  1115,    -1,  1602,    -1,   690,    -1,   670,
      -1,  1394,    -1,  1428,    -1,  1345,    -1,  1347,    -1,   674,
      -1,  1435,    -1,   759,    -1,  1562,    -1,  1552,    -1,   679,
      -1,  1358,    -1,  1664,    -1,  1666,    -1,  1156,    -1,  1456,
      -1,  1463,    -1,  1544,    -1,  1148,    -1,   970,    -1,   878,
      -1,  1163,    -1,   672,    -1,  1452,    -1,  1605,    -1,  1151,
      -1,  1120,    -1,  1361,    -1,  1446,    -1,   758,    -1,  1559,
      -1,  1603,    -1,  1604,    -1,  1175,    -1,  1517,    -1,   751,
      -1,  1414,    -1,  1461,    -1,  1102,    -1,  1105,    -1,  1407,
      -1,  1665,    -1,  1550,    -1,  1386,    -1,  1462,    -1,  1656,
      -1,   671,   414,  1509,    -1,   128,    -1,   150,    -1,   414,
    1509,   199,   673,    -1,  1506,    -1,   661,  1511,    -1,    -1,
     177,  1509,   675,   676,    -1,    -1,   609,   677,    -1,   677,
     656,   678,    -1,   678,    -1,   661,  1511,    -1,    -1,   220,
     680,  1511,    -1,    -1,    59,   313,   688,   575,   682,   683,
      -1,   684,    -1,   683,   656,   684,    -1,   298,   166,  1506,
      -1,   314,   166,  1506,    -1,   301,   166,  1506,    -1,   302,
     166,  1324,    -1,   296,   166,  1324,    -1,   311,   166,  1324,
      -1,   305,   166,  1506,    -1,   304,   166,  1506,    -1,   306,
     166,  1506,    -1,   307,   166,  1506,    -1,   310,   166,  1506,
      -1,   312,   166,  1324,    -1,   308,   166,  1506,    -1,   309,
     166,  1506,    -1,   316,   166,  1493,    -1,   236,   166,   654,
     685,   655,    -1,   687,    -1,    -1,   686,    -1,   685,   656,
     686,    -1,  1324,    -1,   299,   166,  1506,    -1,   300,   166,
    1326,    -1,   444,   166,  1506,    -1,   445,   166,  1324,    -1,
     315,   166,   111,    -1,   315,   166,   506,    -1,   315,   166,
     367,    -1,    -1,   689,    -1,  1506,    -1,    -1,   934,   930,
     558,   933,  1502,   691,   866,    -1,    -1,    -1,   104,  1032,
     239,   933,  1509,  1036,   377,  1502,   692,   654,  1049,   655,
    1037,   693,  1089,    -1,    -1,    -1,   104,  1033,   239,   933,
    1509,  1035,   377,  1502,   694,   654,  1049,   655,  1038,   695,
    1089,    -1,    -1,    -1,   104,  1034,   239,   933,  1509,  1035,
     377,  1502,   696,   654,  1049,   655,  1039,   697,  1089,    -1,
      -1,   104,   115,   933,  1509,   698,   927,    -1,    -1,   934,
     699,  1624,    -1,   104,   605,   716,  1583,    -1,   104,   471,
     716,  1566,  1564,    -1,   104,   287,   213,   829,    -1,   104,
     555,   826,    -1,   104,   700,    -1,   492,  1511,   196,   118,
     635,  1511,   383,   654,   701,   655,    -1,   702,    -1,   701,
     656,   702,    -1,   605,  1506,    -1,   224,  1506,    -1,   115,
    1506,    -1,   393,  1506,    -1,   404,  1506,    -1,   510,  1506,
      -1,   411,  1324,    -1,    -1,  1192,   173,   933,   717,   704,
     377,   481,   705,   710,   707,   712,   149,   713,    -1,    -1,
     174,  1198,  1294,   706,   708,   709,    -1,    24,  1198,    -1,
      -1,   158,    -1,   143,   377,   504,    -1,   143,    -1,    -1,
     530,  1198,    -1,    -1,   161,  1198,    -1,    -1,   711,    -1,
     377,    87,   415,    -1,   377,    87,   365,   415,    -1,    -1,
      83,  1506,    -1,    -1,   714,   715,    -1,   775,    -1,   777,
      -1,   773,    -1,   794,    -1,   812,    -1,   814,    -1,   809,
      -1,   779,    -1,   781,    -1,   782,    -1,   783,    -1,   784,
      -1,   786,    -1,    -1,  1509,   662,  1509,    -1,  1509,    -1,
      -1,   718,   720,    -1,    -1,   719,   721,    -1,    83,  1506,
      -1,   265,   526,    -1,   367,   526,    -1,    97,   526,    -1,
     430,   526,   118,    -1,   341,   526,   118,    -1,   722,    -1,
     720,    -1,   140,    -1,  1204,   140,    -1,   526,   485,   133,
      -1,   526,   485,   252,    -1,    -1,    52,   717,   724,   725,
      -1,    -1,   654,   726,   655,    -1,    -1,   727,    -1,   727,
     656,  1198,    -1,  1198,    -1,    -1,   729,    -1,   729,   656,
     731,    -1,   731,    -1,    -1,  1509,   730,   993,    -1,    -1,
     733,    -1,   733,   656,   734,    -1,   734,    -1,   735,   730,
    1509,   993,    -1,    -1,   253,    -1,   392,    -1,   244,    -1,
      -1,   736,   772,   660,    -1,   772,   660,    -1,   737,   772,
     660,    -1,    -1,   738,   739,   660,    -1,    -1,   131,   770,
     740,   993,   771,    -1,   131,  1509,    90,   197,   747,    -1,
      -1,   131,   744,   216,   197,   741,   745,   772,    -1,   131,
    1509,   112,   197,   742,    -1,    -1,   743,  1175,    -1,   179,
      -1,    99,    -1,   746,    -1,   745,   656,   746,    -1,   750,
      -1,  1324,    -1,   748,    -1,   518,   749,  1507,    -1,    -1,
     614,    -1,   747,    -1,  1509,    -1,   519,    -1,  1204,   198,
      -1,   517,    -1,   501,   752,   754,    -1,  1509,    -1,   748,
      -1,    -1,   752,    -1,    -1,   494,   755,    -1,   757,   166,
     756,    -1,   755,   656,   757,   166,   756,    -1,  1492,    -1,
    1229,    -1,  1498,    -1,    67,    -1,   542,    -1,    94,    -1,
      96,    -1,    95,    -1,    57,    -1,   482,    -1,   560,    -1,
      82,    -1,   113,    -1,   332,    -1,   350,    -1,   459,   753,
     754,    -1,   209,   760,   141,   761,    -1,    -1,   108,    -1,
     762,    -1,    90,   766,   767,    -1,   763,    -1,   762,   656,
     763,    -1,   764,   166,   765,    -1,  1509,    -1,   661,  1511,
      -1,   372,    -1,   478,    -1,   756,    -1,   768,    -1,   767,
     656,   768,    -1,   764,   166,   769,    -1,    67,    -1,   542,
      -1,    94,    -1,    96,    -1,    95,    -1,    57,    -1,   482,
      -1,   560,    -1,    82,    -1,   113,    -1,   332,    -1,   350,
      -1,   464,    -1,  1509,    -1,   770,   656,  1509,    -1,    -1,
     132,  1198,    -1,   775,    -1,   777,    -1,   773,    -1,   794,
      -1,   812,    -1,   814,    -1,   809,    -1,   779,    -1,   781,
      -1,   782,    -1,   783,    -1,   784,    -1,   786,    -1,    -1,
     234,   774,   789,   160,   234,    -1,    -1,   776,   669,    -1,
      -1,   467,   778,  1198,    -1,    -1,   780,   818,    -1,   271,
    1510,    -1,   259,  1510,    -1,   381,  1509,    -1,    -1,   188,
     787,  1509,   250,   785,   788,    -1,    70,  1509,    -1,    -1,
     361,   199,    -1,   199,    -1,  1509,    -1,   788,   656,  1509,
      -1,    -1,    -1,    -1,   790,  1198,   567,   791,   737,   792,
     793,    -1,    -1,   157,   789,    -1,   156,   737,    -1,   795,
      -1,   798,    -1,    -1,    -1,    55,   796,  1198,   797,   800,
     808,   160,    55,    -1,    -1,    55,   799,   801,   808,   160,
      55,    -1,   802,    -1,   800,   802,    -1,   805,    -1,   801,
     805,    -1,    -1,    -1,   628,   803,  1198,   804,   567,   737,
      -1,    -1,    -1,   628,   806,  1198,   807,   567,   737,    -1,
      -1,   156,   737,    -1,    -1,  1510,   663,   810,   818,   811,
      -1,    -1,  1510,    -1,    -1,  1510,   663,   813,   816,   811,
      -1,    -1,   815,   816,    -1,    -1,    33,   817,   738,   736,
     160,    -1,   293,   737,   160,   293,    -1,    -1,    -1,   630,
     819,  1198,   149,   820,   737,   160,   630,    -1,    -1,   454,
     737,   601,   821,  1198,   160,   454,    -1,    32,    -1,     9,
      -1,   246,    -1,   602,    -1,   136,    -1,   851,   853,    -1,
     851,    59,   848,   832,    -1,   851,     6,   848,   827,   836,
      -1,    -1,   608,   287,   213,  1509,    -1,   851,     6,   848,
     839,    -1,   851,   150,   848,   839,    -1,   852,   831,   842,
      -1,   852,   831,   845,    -1,     6,   849,    -1,     6,   850,
      -1,    -1,   833,   834,    -1,   835,    -1,   834,   835,    -1,
     834,   656,   835,    -1,   854,    -1,   855,    -1,   856,    -1,
     837,    -1,   838,    -1,   837,   838,    -1,   837,   656,   838,
      -1,   854,    -1,   855,    -1,   856,    -1,   857,    -1,   860,
      -1,   862,    -1,   864,    -1,   861,    -1,   840,    -1,   841,
      -1,   840,   841,    -1,   840,   656,   841,    -1,   854,    -1,
     855,    -1,   856,    -1,   862,    -1,   864,    -1,   843,    -1,
     844,    -1,   843,   844,    -1,   843,   656,   844,    -1,   854,
      -1,   858,    -1,   859,    -1,   860,    -1,   862,    -1,   864,
      -1,   861,    -1,   846,    -1,   847,    -1,   846,   847,    -1,
     846,   656,   847,    -1,   854,    -1,   862,    -1,   864,    -1,
     117,  1506,    -1,   591,  1506,    -1,   437,  1506,    -1,  1509,
      -1,  1509,    -1,   431,    -1,   433,    -1,   365,     4,    -1,
     242,  1378,   865,    -1,    26,  1378,   865,    -1,   321,  1378,
     865,    -1,   183,  1378,   865,    -1,   592,  1378,   865,    -1,
     438,  1378,   865,    -1,   362,  1378,  1325,    -1,    83,  1378,
    1506,    -1,  1421,   164,  1378,   942,    -1,    -1,   864,    -1,
     624,    -1,   368,    -1,  1327,    -1,  1505,    -1,    -1,   654,
     948,   655,   867,   935,   873,   870,    -1,   935,   873,   870,
      -1,    -1,   654,   923,   655,   868,  1609,    -1,   869,    -1,
     276,  1502,    -1,   654,   276,  1502,   655,    -1,    -1,    -1,
    1471,   926,   923,   871,  1606,    -1,    -1,  1471,   926,   654,
     923,   655,   872,  1609,    -1,   874,    -1,    -1,   875,    -1,
      -1,   401,   877,   876,   880,    -1,    -1,    -1,   401,   879,
     880,    -1,    49,   881,   891,   892,   899,    -1,   883,   263,
     884,   654,   885,   655,    -1,    -1,   883,   218,   882,   889,
      -1,   429,   889,    -1,   429,   888,    -1,   281,   889,    -1,
     281,   888,    -1,    -1,   278,    -1,    -1,    12,   166,  1325,
      -1,    -1,   886,    -1,   887,    -1,   886,   656,   887,    -1,
    1509,    -1,    75,   654,   885,   655,    -1,   654,  1192,   897,
    1193,   655,    -1,   654,  1192,   897,  1193,   655,    -1,    -1,
     402,  1325,    -1,    -1,    -1,   546,    49,   883,   218,   890,
     893,   898,    -1,    -1,   546,    49,   883,   263,   884,   654,
     895,   655,   894,   898,    -1,   896,    -1,   895,   656,   896,
      -1,  1509,    -1,  1201,    -1,    -1,   545,  1325,    -1,    -1,
     654,   900,   655,    -1,   901,    -1,   900,   656,   901,    -1,
      -1,   401,   902,   903,   904,   920,   915,    -1,  1509,    -1,
      -1,    -1,   613,   273,   566,   905,   907,    -1,    -1,   613,
     253,   906,   908,    -1,   325,    -1,   910,    -1,   910,    -1,
     654,   909,   655,    -1,   910,    -1,   909,   656,   910,    -1,
      -1,    -1,   654,   911,   913,   912,   655,    -1,   914,    -1,
     913,   656,   914,    -1,   325,    -1,  1201,    -1,    -1,   654,
     916,   655,    -1,   917,    -1,   916,   656,   917,    -1,    -1,
     546,   918,   919,   920,    -1,  1511,    -1,    -1,   921,    -1,
     921,   922,    -1,   922,    -1,   555,  1378,  1511,    -1,  1421,
     164,  1378,   942,    -1,    91,  1378,  1506,    -1,   362,  1378,
    1325,    -1,   320,  1378,  1327,    -1,   338,  1378,  1327,    -1,
     118,   142,  1378,  1506,    -1,   239,   142,  1378,  1506,    -1,
      83,  1378,  1506,    -1,    -1,    -1,   486,   924,  1186,  1190,
     925,   946,    -1,    -1,    20,    -1,    -1,   928,    -1,   929,
      -1,   928,   929,    -1,   941,    -1,   940,    -1,    -1,   931,
      -1,   932,    -1,   932,   931,    -1,   561,    -1,    -1,   234,
    1204,   178,    -1,   104,    -1,   104,   389,   455,    -1,    -1,
     937,    -1,   938,    -1,   938,   936,    -1,   938,    -1,   938,
     937,    -1,   938,   656,   937,    -1,   164,  1378,   942,    -1,
     320,  1378,  1326,    -1,   338,  1378,  1326,    -1,    29,  1378,
    1324,    -1,   404,  1378,  1506,    -1,    83,  1378,  1506,    -1,
      27,  1378,  1326,    -1,   394,  1378,  1324,    -1,   394,  1378,
     132,    -1,   532,  1378,  1324,    -1,   532,  1378,   132,    -1,
     533,  1378,  1324,    -1,   533,  1378,   132,    -1,   534,  1378,
    1324,    -1,   534,  1378,   132,    -1,    64,  1378,  1324,    -1,
     559,  1378,  1324,    -1,   396,  1378,  1330,    -1,   135,  1378,
    1324,    -1,   476,  1378,   944,    -1,    -1,   596,  1378,   939,
     654,  1444,   655,    -1,   940,    -1,   941,    -1,   247,  1378,
     945,    -1,   118,   142,  1378,  1506,    -1,   239,   142,  1378,
    1506,    -1,   555,  1509,    -1,   539,   145,    -1,   539,   330,
      -1,    91,  1378,  1506,    -1,   262,  1378,  1324,    -1,   578,
    1378,  1330,    -1,  1505,  1377,  1506,    -1,  1505,  1377,  1509,
      -1,  1505,  1377,  1327,    -1,  1505,  1377,   132,    -1,  1004,
     995,  1378,   997,    -1,  1004,    73,  1378,  1003,    -1,  1511,
      -1,  1511,    -1,   132,    -1,   191,    -1,   154,    -1,    88,
      -1,   439,    -1,    86,    -1,   395,    -1,   367,    -1,   190,
      -1,   266,    -1,  1317,    -1,  1185,  1189,    -1,   541,    -1,
     434,    -1,   130,    -1,   251,    -1,   949,    -1,   950,    -1,
     949,   656,   950,    -1,   951,    -1,   952,    -1,   961,   957,
      -1,   961,  1021,    -1,    -1,  1027,  1052,  1036,   654,  1049,
     655,   953,  1037,    -1,    -1,  1033,  1030,  1052,  1035,   654,
    1049,   655,   954,  1038,    -1,    -1,  1034,  1030,  1052,  1035,
     654,  1049,   655,   955,  1039,    -1,    -1,   959,  1028,  1052,
    1036,   654,  1049,   655,   956,  1037,    -1,   959,   196,   263,
    1052,   654,  1049,   655,  1021,    -1,   959,   958,    -1,    -1,
     958,    -1,    65,   654,  1198,   655,    -1,    -1,   960,    -1,
      93,  1051,    -1,    -1,  1501,   962,   963,    -1,   972,   990,
      -1,    -1,   972,   965,    20,   964,   654,   971,   655,   966,
     967,    -1,    -1,   205,    15,    -1,    -1,   623,    -1,   405,
      -1,    -1,   968,    -1,   968,   969,    -1,   969,    -1,   597,
      -1,   597,   263,    -1,    83,  1506,    -1,   399,   654,   971,
     655,    -1,  1192,  1198,  1193,    -1,   980,   988,   984,    -1,
     981,   989,   984,    -1,   193,   982,   984,    -1,    41,    -1,
      41,   987,    -1,    46,    -1,    45,    -1,   976,   987,  1007,
      -1,   976,  1007,    -1,   977,   987,  1008,    -1,   977,  1008,
      -1,    36,   987,    -1,    36,    -1,   978,   987,  1007,    -1,
     979,   987,  1008,    -1,   615,   987,    -1,   642,   988,   984,
      -1,   122,    -1,   571,   988,    -1,   568,   988,    -1,   119,
     988,    -1,   572,    -1,    43,   988,    -1,   975,    -1,   326,
      -1,   289,    -1,   292,   615,    -1,   292,   978,  1007,    -1,
     574,  1007,    -1,   565,   988,  1007,    -1,   328,  1007,    -1,
     290,  1007,    -1,   130,   982,   984,    -1,   373,   982,   984,
      -1,   191,   982,   984,    -1,    -1,   165,   973,   654,  1054,
     655,  1007,    -1,    -1,   494,   974,   654,  1054,   655,  1007,
      -1,   292,  1007,    -1,   490,    -1,   207,    -1,   206,    -1,
     409,    -1,   346,    -1,   280,    -1,   345,    -1,   410,    -1,
     347,    -1,    62,    -1,   356,    -1,   353,    62,    -1,   976,
     619,    -1,   616,    -1,   353,   616,    -1,   374,    -1,   356,
     616,    -1,   353,    62,   619,    -1,   356,   619,    -1,   251,
      -1,   573,    -1,   508,    -1,   327,    -1,    35,    -1,   434,
      -1,   148,    -1,   148,   413,    -1,    -1,   987,    -1,   983,
      -1,   654,   371,   656,   371,   655,    -1,    -1,   985,    -1,
     985,   986,    -1,   986,    -1,   502,    -1,   600,    -1,   643,
      -1,   654,   291,   655,    -1,   654,   587,   655,    -1,   654,
     129,   655,    -1,   654,   371,   655,    -1,    -1,   987,    -1,
      -1,   983,    -1,    -1,   991,    -1,   991,   992,    -1,   992,
      -1,   370,    -1,  1204,   370,    -1,   132,   994,    -1,   377,
     602,   366,  1195,    -1,    27,    -1,   490,   132,   614,    -1,
    1020,   263,    -1,   597,    -1,   597,   263,    -1,    83,  1506,
      -1,    73,  1001,    -1,  1505,  1377,  1506,    -1,  1505,  1377,
    1509,    -1,  1505,  1377,  1327,    -1,  1505,  1377,   132,    -1,
     972,  1002,    -1,   366,  1195,    -1,  1491,    -1,    62,   494,
      -1,    61,    -1,  1511,    -1,    36,    -1,   996,    -1,   132,
      -1,    -1,   995,   997,    -1,  1511,    -1,    36,    -1,   999,
      -1,   132,    -1,  1511,    -1,    -1,    73,  1003,    -1,  1001,
      -1,   132,    -1,    -1,   132,    -1,    22,    -1,    36,    22,
      -1,    22,    36,    -1,   594,    -1,   594,    36,    -1,    36,
     594,    -1,    -1,  1005,    -1,  1006,    -1,    50,    -1,   995,
     996,  1008,    -1,    36,    -1,    36,   995,   996,    -1,    -1,
      36,    -1,    -1,   654,  1325,  1010,   655,    -1,    21,    -1,
     137,    -1,   468,    -1,    -1,  1011,    -1,  1011,  1012,    -1,
    1012,    -1,  1325,    -1,  1014,  1013,    -1,  1015,    -1,  1016,
     656,  1015,    -1,  1014,   647,  1014,    -1,  1016,    -1,  1017,
      -1,    -1,   274,  1018,    -1,    -1,   417,    -1,   440,  1502,
    1022,  1024,  1025,    -1,    -1,   654,  1023,   655,    -1,  1023,
     656,  1509,    -1,  1509,    -1,    -1,   317,   200,    -1,   317,
     400,    -1,   317,   503,    -1,    -1,   377,   602,  1026,    -1,
     377,   136,  1026,    -1,   377,   602,  1026,   377,   136,  1026,
      -1,   377,   136,  1026,   377,   602,  1026,    -1,   462,    -1,
      53,    -1,   494,   370,    -1,   367,     5,    -1,   494,   132,
      -1,  1029,    -1,   417,   263,    -1,   597,  1030,    -1,   263,
      -1,   239,    -1,    -1,  1029,    -1,   261,    -1,   239,    -1,
     238,    -1,    -1,   597,    -1,   201,    -1,   515,    -1,    -1,
    1035,    -1,  1035,  1043,    -1,    -1,  1040,    -1,    -1,  1042,
      -1,    -1,  1041,    -1,  1045,    -1,  1040,  1045,    -1,  1046,
      -1,  1041,  1046,    -1,  1047,    -1,  1042,  1047,    -1,   609,
    1048,    -1,   585,  1048,    -1,   262,  1378,  1324,    -1,    83,
    1506,    -1,  1505,  1377,  1506,    -1,  1505,  1377,  1509,    -1,
    1505,  1377,  1327,    -1,  1505,  1377,   132,    -1,  1044,    -1,
    1043,    -1,  1044,    -1,  1044,    -1,   631,   398,  1505,    -1,
      48,    -1,   479,    -1,   218,    -1,  1049,   656,  1050,  1315,
      -1,  1050,  1315,    -1,  1509,    -1,  1509,   654,   371,   655,
      -1,    -1,  1501,    -1,   933,  1051,    -1,    -1,   662,  1509,
      -1,  1488,    -1,  1054,   656,  1488,    -1,    -1,    -1,    14,
    1056,  1094,   558,  1502,  1057,  1068,    -1,    -1,    14,   115,
    1067,  1058,   928,    -1,    14,   115,  1509,   603,   118,   142,
     352,    -1,    -1,    14,   419,   717,  1059,   718,    -1,    -1,
      14,   202,   717,  1060,   718,    -1,    -1,    14,  1630,  1627,
    1061,  1632,    -1,    -1,    14,  1627,  1062,  1632,    -1,    -1,
      14,  1627,   173,   717,  1063,  1064,  1065,   707,   712,  1066,
      -1,    14,   555,   828,    -1,    14,   287,   213,   830,    -1,
      14,   555,   825,    -1,    14,   555,   824,    -1,    14,   492,
    1511,   383,   654,   701,   655,    -1,    -1,   377,   481,   705,
      -1,   711,    -1,   377,   481,   705,   711,    -1,    -1,   450,
     575,   717,    -1,    -1,   149,   713,    -1,    -1,  1509,    -1,
      -1,   144,   555,    -1,   237,   555,    -1,  1083,   874,    -1,
    1083,  1072,    -1,  1072,    -1,   875,    -1,  1074,    -1,   150,
     401,  1356,  1081,    -1,   435,   401,  1150,  1073,    -1,    -1,
     382,   401,  1150,  1073,  1069,  1150,    -1,    16,   401,  1150,
    1073,    -1,    -1,    65,   401,  1073,  1070,  1144,    -1,    -1,
     452,   401,  1150,  1073,  1071,  1122,    -1,    71,   401,  1150,
    1325,    -1,   583,   401,  1073,    -1,  1077,    -1,   175,   401,
    1082,   631,   558,  1502,   877,    -1,   449,   403,    -1,    13,
      -1,  1081,    -1,    -1,     6,   401,   933,  1150,  1075,  1076,
      -1,    -1,   654,   900,   655,    -1,   402,  1325,    -1,    -1,
     451,   401,  1150,  1078,  1079,    -1,    -1,    -1,  1081,  1080,
     250,   654,   900,   655,    -1,  1082,    -1,  1081,   656,  1082,
      -1,  1509,    -1,  1085,    -1,  1083,   656,  1085,    -1,     6,
    1092,   933,    -1,  1084,   951,  1100,    -1,     6,   952,    -1,
    1084,   654,   948,   655,    -1,    -1,    59,  1092,  1356,  1501,
    1086,   961,  1100,    -1,    -1,    -1,   342,  1092,  1356,  1501,
    1087,   963,  1088,  1100,    -1,   150,  1092,  1356,  1501,  1099,
      -1,   150,   196,   263,  1356,  1501,    -1,   150,   417,   263,
      -1,   150,  1029,  1356,  1501,    -1,   143,   261,    -1,   158,
     261,    -1,    14,  1092,  1501,   494,   132,  1491,    -1,    14,
    1092,  1501,   150,   132,    -1,   450,  1101,  1502,    -1,   101,
     575,   995,   997,  1002,    -1,   936,    -1,   195,    -1,  1308,
      -1,  1090,    -1,  1091,    -1,    -1,  1091,    -1,  1090,    -1,
    1091,  1090,    -1,  1090,  1091,    -1,    12,  1378,   132,    -1,
      12,  1378,  1509,    -1,   286,  1378,   132,    -1,   286,  1378,
    1509,    -1,    -1,    81,    -1,    -1,   235,    -1,    -1,  1095,
    1096,    -1,    -1,  1097,    -1,  1097,  1098,    -1,  1098,    -1,
     235,    -1,   380,    -1,    -1,   462,    -1,    53,    -1,    -1,
       9,  1509,    -1,   190,    -1,    -1,   575,    -1,   166,    -1,
      20,    -1,    -1,   531,   504,   688,  1109,  1103,  1113,    -1,
      -1,   531,    13,   505,  1109,  1104,    -1,   538,   504,   688,
    1109,    -1,   538,    13,   505,  1109,    -1,   531,   577,  1106,
      -1,    -1,  1107,    -1,  1108,    -1,  1107,   656,  1108,    -1,
     631,    92,   509,    -1,   432,   379,    -1,   432,   636,    -1,
      -1,  1110,  1111,    -1,  1112,    -1,  1111,   656,  1112,    -1,
      -1,   527,    -1,   446,    -1,    -1,   601,  1114,    -1,   601,
     297,   166,  1506,    -1,   687,    -1,  1114,   656,   687,    -1,
      -1,    64,  1546,  1116,  1351,  1117,    -1,    -1,   428,    -1,
     182,    -1,  1546,  1351,  1122,    -1,    -1,   622,  1119,  1351,
    1125,    -1,    -1,   452,  1150,  1121,  1118,    -1,    -1,  1123,
      -1,  1124,    -1,  1124,  1123,    -1,   428,    -1,   182,    -1,
     607,    -1,    -1,   199,   349,    -1,    -1,    16,  1150,  1546,
    1127,  1128,    -1,  1129,    -1,  1128,   656,  1129,    -1,  1352,
    1130,    -1,    -1,   405,   197,  1131,    -1,    13,    -1,    75,
    1132,   238,  1134,    -1,    13,    -1,    -1,   654,  1133,  1136,
     655,    -1,    13,    -1,    -1,   654,  1135,  1137,   655,    -1,
      -1,  1509,    -1,  1136,   656,  1509,    -1,    -1,  1138,    -1,
    1137,   656,  1138,    -1,  1509,    -1,   417,    -1,    37,  1506,
      -1,  1546,  1351,  1144,    -1,    -1,   622,  1141,  1351,  1147,
      -1,    -1,    65,  1143,  1140,    -1,    -1,  1145,    -1,  1146,
      -1,  1146,  1145,    -1,   428,    -1,   186,    -1,   329,    -1,
     182,    -1,    60,    -1,   197,   603,    -1,    -1,   197,   603,
      -1,    -1,   382,  1150,  1546,  1149,  1351,    -1,    -1,   369,
      -1,   283,    -1,    -1,   450,  1546,  1152,  1154,    -1,   450,
     605,   716,  1153,    -1,  1514,   575,  1514,    -1,  1153,   656,
    1514,   575,  1514,    -1,  1155,    -1,  1154,   656,  1155,    -1,
    1502,   575,  1502,    -1,    -1,    51,   239,  1157,  1158,   253,
    1162,    -1,  1159,    -1,  1161,    -1,  1160,    -1,  1159,   656,
    1160,    -1,  1502,  1171,    -1,  1502,  1169,  1171,    -1,  1509,
      -1,   132,    -1,    -1,   282,   239,   250,    51,  1164,  1165,
      -1,  1168,    -1,  1166,    -1,  1167,    -1,  1166,   656,  1167,
      -1,  1502,  1171,  1174,    -1,  1502,  1169,  1171,  1174,    -1,
      -1,   401,   877,  1170,   654,  1073,   655,    -1,    -1,  1172,
    1173,    -1,    -1,  1029,   654,  1290,   655,    -1,    -1,   235,
     270,    -1,  1176,    -1,   486,  1179,    -1,   654,  1177,   655,
    1609,    -1,   486,  1181,    -1,   654,  1177,   655,    -1,   486,
    1269,    -1,   654,  1178,   655,    -1,    -1,  1181,  1180,  1606,
      -1,    -1,    -1,  1182,  1186,  1190,  1183,  1184,  1189,    -1,
    1311,  1317,    -1,  1340,    -1,  1185,    -1,  1340,  1185,    -1,
    1185,  1340,    -1,   199,  1249,  1300,  1305,  1302,  1311,  1317,
    1331,    -1,   199,   151,  1300,  1317,    -1,    -1,  1187,    -1,
    1187,  1188,    -1,  1188,    -1,  1623,    -1,   524,    -1,   522,
      -1,    -1,   197,   602,    -1,   286,   253,   496,   340,    -1,
    1190,   656,  1191,    -1,  1191,    -1,   649,    -1,  1192,  1496,
    1193,    -1,  1192,  1198,  1193,  1194,    -1,    -1,    -1,    -1,
      20,  1509,    -1,    20,  1506,    -1,  1509,    -1,  1506,    -1,
      -1,   654,   655,    -1,   654,  1325,   655,    -1,    -1,   654,
     655,    -1,   654,  1325,   655,    -1,    -1,   654,   655,    -1,
    1198,  1202,  1198,    -1,  1198,   640,  1198,    -1,  1198,  1203,
    1198,    -1,   365,  1198,    -1,  1199,   256,   582,    -1,  1199,
     256,  1204,   582,    -1,  1199,   256,   185,    -1,  1199,   256,
    1204,   185,    -1,  1199,   256,   598,    -1,  1199,   256,  1204,
     598,    -1,  1199,    -1,  1199,   256,   370,    -1,  1199,   256,
    1204,   370,    -1,  1199,   167,  1200,    -1,  1199,  1206,  1200,
      -1,  1199,  1206,  1207,   654,  1618,   655,    -1,  1200,    -1,
    1201,   253,   654,  1618,   655,    -1,  1201,  1204,   253,   654,
    1618,   655,    -1,  1201,   253,   654,  1198,   655,    -1,  1201,
     253,   654,  1198,   656,  1242,   655,    -1,  1201,  1204,   253,
     654,  1198,   655,    -1,  1201,  1204,   253,   654,  1198,   656,
    1242,   655,    -1,  1201,    34,  1201,    18,  1200,    -1,  1201,
    1204,    34,  1201,    18,  1200,    -1,  1201,   513,   276,  1201,
      -1,  1201,   276,  1212,  1304,    -1,  1201,  1204,   276,  1212,
    1304,    -1,  1201,   441,  1201,    -1,  1201,  1204,   441,  1201,
      -1,  1201,    -1,  1201,   645,  1201,    -1,  1201,   646,  1201,
      -1,  1201,   497,  1201,    -1,  1201,   498,  1201,    -1,  1201,
     648,  1201,    -1,  1201,   647,  1201,    -1,  1201,   648,   249,
    1198,  1294,    -1,  1201,   647,   249,  1198,  1294,    -1,  1201,
     649,  1201,    -1,  1201,   650,  1201,    -1,  1201,   651,  1201,
      -1,  1201,   147,  1201,    -1,  1201,   343,  1201,    -1,  1201,
     652,  1201,    -1,  1212,    -1,   389,    -1,   386,    -1,    18,
      -1,    17,    -1,   365,    -1,   364,    -1,   657,    -1,   364,
      -1,   166,    -1,   203,    -1,   215,    -1,   268,    -1,   295,
      -1,   358,    -1,    13,    -1,    19,    -1,    -1,    20,  1209,
      -1,   251,    -1,   600,   251,    -1,   148,    -1,   434,    -1,
     193,    -1,   130,   982,    -1,   976,  1007,    -1,   977,    -1,
     122,    -1,   571,   988,    -1,   119,   988,    -1,  1198,   656,
    1198,  1208,    -1,  1210,    -1,  1211,   656,  1210,    -1,  1498,
      -1,  1213,    -1,  1214,    -1,  1217,    -1,  1215,    -1,  1212,
      73,  1511,    -1,  1492,    -1,  1490,    -1,  1229,    -1,  1225,
      -1,  1212,   388,  1212,    -1,   648,  1212,    -1,   647,  1212,
      -1,   653,  1212,    -1,  1205,  1212,    -1,   654,  1618,   655,
      -1,   654,  1198,   655,    -1,   654,  1198,   656,  1242,   655,
      -1,   477,   654,  1198,   656,  1242,   655,    -1,   178,   654,
    1618,   655,    -1,   658,  1509,  1198,   659,    -1,   317,  1243,
      10,   654,  1201,  1219,   655,    -1,    36,  1212,    -1,    56,
     654,  1198,    20,  1239,   655,    -1,    55,  1245,  1247,  1246,
     160,    -1,   101,   654,  1198,   656,  1239,   655,    -1,   101,
     654,  1198,   609,   996,   655,    -1,   132,   654,  1498,   655,
      -1,   613,   654,  1499,   655,    -1,   249,  1198,  1294,   648,
    1198,    -1,    62,   654,  1242,   655,    -1,    62,   654,  1242,
     609,   996,   655,    -1,   109,  1197,    -1,   110,  1197,    -1,
     122,   654,  1198,   655,    -1,   127,   654,  1198,   655,    -1,
     229,   654,  1198,   655,    -1,   246,   654,  1198,   656,  1198,
     656,  1198,   656,  1198,   655,    -1,   249,   654,  1198,   656,
    1198,   655,    -1,   249,   654,  1198,   656,  1198,   656,  1242,
     655,    -1,   272,   654,  1198,   656,  1198,   655,    -1,   337,
     654,  1198,   655,    -1,   344,   654,  1198,   655,    -1,   470,
     654,  1198,   656,  1198,   655,    -1,   484,   654,  1198,   655,
      -1,   571,   654,  1198,   655,    -1,   568,   654,  1198,   655,
      -1,   568,   654,  1198,   656,  1198,   655,    -1,   581,   654,
    1198,   655,    -1,   581,   654,   269,  1198,   199,  1198,   655,
      -1,   581,   654,   576,  1198,   199,  1198,   655,    -1,   581,
     654,    47,  1198,   199,  1198,   655,    -1,   581,   654,   269,
     199,  1198,   655,    -1,   581,   654,   576,   199,  1198,   655,
      -1,   581,   654,    47,   199,  1198,   655,    -1,   581,   654,
    1198,   199,  1198,   655,    -1,   605,   654,   655,    -1,   642,
     654,  1198,   655,    -1,     8,   654,  1198,   656,  1198,   655,
      -1,     8,   654,  1198,   656,   249,  1198,  1294,   655,    -1,
     107,  1197,    -1,   114,  1196,    -1,   120,   654,  1198,   656,
     249,  1198,  1294,   655,    -1,   121,   654,  1198,   656,   249,
    1198,  1294,   655,    -1,   184,   654,  1294,   199,  1198,   655,
      -1,   208,   654,  1296,   656,  1198,   655,    -1,   366,  1196,
      -1,   412,   654,  1201,   253,  1198,   655,    -1,   543,   654,
    1198,   656,  1198,   655,    -1,   543,   654,  1198,   656,   249,
    1198,  1294,   655,    -1,   547,   654,  1198,   656,  1198,   656,
    1198,   655,    -1,   547,   654,  1198,   656,  1198,   655,    -1,
     547,   654,  1198,   199,  1198,   197,  1198,   655,    -1,   547,
     654,  1198,   199,  1198,   655,    -1,   553,  1196,    -1,   569,
     654,  1295,   656,  1198,   656,  1198,   655,    -1,   570,   654,
    1295,   656,  1198,   656,  1198,   655,    -1,   610,  1197,    -1,
     612,  1196,    -1,   611,  1196,    -1,    76,   654,  1198,   656,
    1211,   655,    -1,    79,   654,  1198,   656,  1242,   655,    -1,
      77,   654,  1198,   655,    -1,    78,   654,  1211,   655,    -1,
      80,   654,  1198,   656,  1198,    20,  1239,   655,    -1,    22,
     654,  1198,   655,    -1,    61,   654,  1198,   655,    -1,    71,
     654,  1242,   655,    -1,    74,   654,  1198,   655,    -1,   115,
     654,   655,    -1,   234,   654,  1198,   656,  1198,   656,  1198,
     655,    -1,   267,   654,  1242,   655,    -1,   333,   654,  1198,
     655,    -1,   343,   654,  1198,   656,  1198,   655,    -1,   376,
     654,  1198,   655,    -1,   404,   654,  1198,   655,    -1,   426,
     654,  1198,   655,    -1,   454,   654,  1198,   656,  1198,   655,
      -1,   455,   654,  1198,   656,  1198,   656,  1198,   655,    -1,
     468,   654,  1198,   655,    -1,   478,   654,   655,    -1,   583,
     654,  1198,   656,  1198,   655,    -1,   626,   654,  1198,   655,
      -1,   626,   654,  1198,   656,  1198,   655,    -1,   627,   654,
    1198,  1019,   655,    -1,   627,   654,  1198,    20,    62,  1009,
    1019,   655,    -1,   627,   654,  1198,    20,    36,  1009,   655,
      -1,   627,   654,  1198,   656,  1324,   656,  1324,   656,  1324,
     655,    -1,  1216,    -1,    97,   654,  1198,   656,  1198,   655,
      -1,   206,   654,  1242,   655,    -1,   280,   654,  1242,   655,
      -1,   345,   654,  1242,   655,    -1,   346,   654,  1242,   655,
      -1,   347,   654,  1242,   655,    -1,   409,   654,  1198,   656,
    1198,   655,    -1,   410,   654,  1242,   655,    -1,    -1,  1505,
     654,  1218,  1222,   655,    -1,  1509,   662,  1509,   654,  1241,
     655,    -1,  1220,  1221,    -1,   253,    45,   340,    -1,    -1,
     253,   354,   265,   340,    -1,    -1,   631,   427,   180,    -1,
      -1,  1223,    -1,  1224,    -1,  1223,   656,  1224,    -1,  1192,
    1198,  1193,  1194,    -1,    30,   654,  1237,   655,    -1,    30,
     654,   146,  1237,   655,    -1,    39,   654,  1237,   655,    -1,
      40,   654,  1237,   655,    -1,    42,   654,  1237,   655,    -1,
     102,   654,  1299,   649,   655,    -1,   102,   654,  1237,   655,
      -1,    -1,    -1,   102,   654,   146,  1226,  1242,  1227,   655,
      -1,   339,   654,  1237,   655,    -1,   339,   654,   146,  1237,
     655,    -1,   322,   654,  1237,   655,    -1,   322,   654,   146,
    1237,   655,    -1,   537,   654,  1237,   655,    -1,   618,   654,
    1237,   655,    -1,   536,   654,  1237,   655,    -1,   620,   654,
    1237,   655,    -1,   548,   654,  1237,   655,    -1,   548,   654,
     146,  1237,   655,    -1,    -1,   214,   654,  1232,  1228,  1242,
    1234,  1233,   655,    -1,    -1,   661,  1230,  1231,    -1,  1511,
     495,  1198,    -1,  1511,    -1,   661,  1533,  1511,  1053,    -1,
      -1,   146,    -1,    -1,   488,  1488,    -1,    -1,    -1,   387,
      49,  1235,  1236,    -1,  1236,   656,  1497,  1315,    -1,  1497,
    1315,    -1,    -1,  1299,  1238,  1198,    -1,    36,   988,    -1,
      62,   988,  1007,    -1,   356,   988,    -1,   251,    -1,   502,
      -1,   502,   251,    -1,   600,    -1,   600,   251,    -1,   122,
      -1,   571,   988,    -1,   119,   988,    -1,   130,   982,    -1,
      -1,   148,  1240,   989,    -1,    -1,  1242,    -1,  1198,    -1,
    1242,   656,  1198,    -1,  1244,    -1,   654,  1244,   655,    -1,
    1498,    -1,  1244,   656,  1498,    -1,    -1,  1198,    -1,    -1,
     156,  1198,    -1,   628,  1198,   567,  1198,    -1,  1247,   628,
    1198,   567,  1198,    -1,  1263,    -1,  1252,    -1,  1251,    -1,
    1248,    -1,   658,  1509,  1248,   659,    -1,  1250,    -1,  1251,
     656,  1250,    -1,  1248,  1260,  1248,    -1,    -1,  1248,  1260,
    1248,   377,  1253,  1198,    -1,    -1,  1248,  1260,  1248,   609,
    1254,   654,  1293,   655,    -1,  1248,   354,  1259,  1263,    -1,
      -1,  1248,   272,  1279,   260,  1248,   377,  1255,  1198,    -1,
      -1,  1248,   272,  1279,   260,  1263,  1256,   609,   654,  1293,
     655,    -1,  1248,   354,   272,  1279,   260,  1263,    -1,    -1,
    1248,   470,  1279,   260,  1248,   377,  1257,  1198,    -1,    -1,
    1248,   470,  1279,   260,  1263,  1258,   609,   654,  1293,   655,
      -1,  1248,   354,   470,  1279,   260,  1263,    -1,   260,    -1,
     243,   260,    -1,   540,    -1,  1259,    -1,   105,   260,    -1,
      -1,  1262,    -1,   401,   654,  1293,   655,   877,    -1,    -1,
    1264,  1502,  1261,  1298,  1288,    -1,  1278,  1277,  1274,    -1,
     654,  1277,  1265,   655,  1298,    -1,  1272,  1610,    -1,    -1,
      -1,  1265,   596,  1614,  1266,  1615,  1267,  1610,    -1,  1269,
      -1,    -1,    -1,  1270,  1621,  1190,  1271,   946,  1189,    -1,
      -1,  1277,  1273,  1251,    -1,    -1,    -1,  1275,  1186,  1190,
    1276,   946,    -1,    -1,   486,    -1,    -1,   390,    -1,    -1,
     197,   260,    -1,   197,   387,    49,    -1,   197,   213,    49,
      -1,   195,    -1,   235,    -1,    -1,  1281,  1029,  1280,  1283,
     654,  1292,   655,    -1,    -1,   608,  1029,  1280,  1284,   654,
    1290,   655,    -1,  1282,    -1,  1285,  1282,    -1,    -1,    -1,
    1287,  1285,    -1,    -1,  1289,  1286,    -1,    -1,  1292,    -1,
    1509,    -1,   417,    -1,  1291,    -1,  1292,   656,  1291,    -1,
    1509,    -1,  1293,   656,  1509,    -1,  1295,    -1,   123,    -1,
     124,    -1,   125,    -1,   126,    -1,   226,    -1,   227,    -1,
     228,    -1,   335,    -1,   336,    -1,   483,    -1,   641,    -1,
     127,    -1,   626,    -1,   229,    -1,   337,    -1,   344,    -1,
     426,    -1,   484,    -1,   333,    -1,   642,    -1,   122,    -1,
     571,    -1,   119,    -1,   568,    -1,    -1,    20,    -1,   166,
      -1,    -1,  1297,  1509,    -1,    -1,    13,    -1,    -1,    -1,
     629,  1301,  1198,    -1,    -1,    -1,   219,  1303,  1198,    -1,
     171,  1212,    -1,    -1,    -1,   213,    49,  1306,  1307,    -1,
    1306,   656,  1497,  1315,    -1,  1497,  1315,    -1,    -1,   632,
      -1,   633,    -1,   387,    49,  1309,    -1,  1309,   656,  1310,
      -1,  1310,    -1,  1499,  1315,    -1,    -1,  1312,    -1,    -1,
     387,    49,  1313,  1314,    -1,  1314,   656,  1497,  1315,    -1,
    1497,  1315,    -1,    -1,    21,    -1,   137,    -1,    -1,  1318,
      -1,    -1,  1318,    -1,   277,  1319,    -1,   277,  1319,   475,
     176,  1321,    -1,   277,   475,   176,  1321,    -1,  1320,    -1,
    1320,   656,  1320,    -1,  1320,   375,  1320,    -1,  1509,    -1,
    1490,    -1,   587,    -1,   291,    -1,   371,    -1,  1320,    -1,
      -1,   277,  1320,    -1,   277,   475,   176,    -1,   277,  1320,
     475,   176,    -1,   371,    -1,   647,   371,    -1,   647,   291,
      -1,   371,    -1,   221,    -1,   291,    -1,   587,    -1,   129,
      -1,   192,    -1,   371,    -1,   221,    -1,   291,    -1,   587,
      -1,  1328,    -1,   371,    -1,   587,    -1,   291,    -1,   129,
      -1,   192,    -1,   371,    -1,   587,    -1,   221,    -1,   291,
      -1,  1328,    -1,  1329,    -1,   129,    -1,   192,    -1,  1324,
      -1,   132,    -1,    -1,    -1,   419,  1509,  1332,   654,  1333,
     655,    -1,    -1,  1334,    -1,  1334,   656,  1335,    -1,  1335,
      -1,  1192,  1198,  1193,    -1,    -1,  1337,  1338,    -1,  1338,
     656,  1339,    -1,  1339,    -1,   661,  1511,    -1,  1511,    -1,
      -1,   250,  1341,  1342,    -1,    -1,    -1,   391,  1508,  1343,
     998,  1344,  1472,  1475,    -1,   152,  1508,    -1,  1336,    -1,
      -1,   149,  1346,  1242,    -1,    -1,   150,  1357,  1546,  1356,
    1348,  1351,  1099,    -1,    -1,   150,   239,  1356,  1509,   377,
    1502,  1349,    -1,   150,   115,  1356,  1509,    -1,   150,   202,
    1356,  1509,   662,  1509,    -1,   150,   202,  1356,  1509,    -1,
     150,   419,  1356,   717,    -1,   150,   605,   716,  1582,    -1,
     150,   471,   716,  1566,    -1,    -1,   150,   622,  1356,  1350,
    1351,  1099,    -1,   150,   173,  1356,   717,    -1,   150,   580,
    1356,   717,    -1,   150,   555,   851,   862,   863,    -1,   150,
     287,   213,   852,   862,   863,    -1,   150,   492,  1356,  1511,
      -1,  1352,    -1,  1351,   656,  1352,    -1,  1502,    -1,  1502,
    1261,    -1,  1355,    -1,  1354,   656,  1355,    -1,  1503,    -1,
      -1,   234,   178,    -1,    -1,   561,    -1,    -1,    -1,   246,
    1359,  1364,  1093,  1366,  1360,  1368,  1384,    -1,    -1,    -1,
     455,  1362,  1365,  1366,  1363,  1368,    -1,    -1,   294,    -1,
     134,    -1,   223,    -1,  1393,    -1,   134,    -1,   250,  1367,
      -1,  1367,    -1,  1353,    -1,  1371,    -1,   654,   655,  1371,
      -1,   654,  1370,   655,  1371,    -1,    -1,   494,  1369,  1375,
      -1,  1370,   656,  1495,    -1,  1495,    -1,   613,  1374,    -1,
     614,  1374,    -1,    -1,   923,  1372,  1606,    -1,    -1,   654,
     923,   655,  1373,  1609,    -1,  1374,   656,  1379,    -1,  1379,
      -1,  1375,   656,  1376,    -1,  1376,    -1,  1499,  1377,  1383,
      -1,   166,    -1,   495,    -1,    -1,  1377,    -1,    -1,   654,
    1380,  1381,   655,    -1,    -1,  1382,    -1,  1382,   656,  1383,
      -1,  1383,    -1,  1198,    -1,   132,    -1,    -1,    -1,   377,
     153,  1385,   263,   602,  1391,    -1,    -1,    -1,   602,  1387,
    1393,  1093,  1249,   494,  1389,  1388,  1300,  1311,  1322,    -1,
    1389,   656,  1390,    -1,  1390,    -1,  1499,  1377,  1383,    -1,
    1391,   656,  1392,    -1,  1392,    -1,  1499,  1377,  1383,    -1,
      -1,   294,    -1,    -1,   136,  1395,  1405,  1396,    -1,    -1,
      -1,   199,  1502,  1261,  1397,  1300,  1311,  1322,  1398,  1401,
      -1,    -1,  1402,  1399,   199,  1249,  1300,    -1,    -1,   199,
    1354,  1400,   609,  1249,  1300,    -1,    -1,   465,  1190,    -1,
    1403,    -1,  1402,   656,  1403,    -1,  1509,  1404,    -1,  1509,
     662,  1509,  1404,    -1,    -1,   662,   649,    -1,    -1,  1406,
    1405,    -1,   428,    -1,   294,    -1,   235,    -1,    -1,   583,
    1409,  1408,  1352,    -1,    -1,   558,    -1,    -1,  1411,    -1,
    1412,    -1,  1411,   656,  1412,    -1,   103,    -1,   330,    -1,
      44,   254,    -1,    98,   552,    -1,   395,   187,    -1,   255,
      -1,   551,    -1,   514,    -1,    13,    -1,    -1,   197,   427,
     371,    -1,    -1,   499,  1415,  1416,    -1,   116,  1427,    -1,
    1423,   554,  1422,  1427,    -1,  1423,   579,  1422,  1427,    -1,
     172,  1422,  1427,    -1,   558,   535,  1422,  1427,    -1,   381,
     554,  1422,  1427,    -1,   407,    -1,   407,   512,  1506,    -1,
     407,   512,  1427,    -1,   164,   943,  1419,    -1,   164,    13,
    1419,    -1,  1423,    75,  1424,  1502,  1422,  1427,    -1,  1420,
     288,    -1,   504,   225,    -1,    -1,    37,   172,  1425,  1426,
    1417,  1316,    -1,    -1,   443,   688,   172,  1425,  1426,  1418,
    1316,    -1,  1031,  1424,  1502,  1422,  1300,    -1,  1421,   163,
      -1,    25,    -1,   100,    -1,   418,    -1,   102,   654,   649,
     655,   625,    -1,   102,   654,   649,   655,   169,    -1,   625,
    1316,    -1,   169,  1316,    -1,   423,    -1,   422,  1410,  1413,
    1316,    -1,  1532,   535,  1427,    -1,  1423,   421,    -1,  1532,
     617,  1427,    -1,   995,  1427,    -1,    74,  1427,    -1,   212,
      -1,   212,   197,  1513,    -1,   104,   115,   933,  1509,    -1,
     104,   558,  1502,    -1,   104,   622,  1502,    -1,   313,   535,
      -1,    13,   505,   535,    -1,   504,   535,    -1,   504,   689,
     535,    -1,    69,    -1,   606,    -1,   557,    -1,   240,    -1,
     104,   419,   717,    -1,   104,   202,   717,    -1,   104,   580,
     717,    -1,   419,   535,  1427,    -1,   202,   535,  1427,    -1,
     419,    72,   717,    -1,   202,    72,   717,    -1,   104,   173,
     717,    -1,  1432,   197,  1198,    -1,   535,    -1,   348,    -1,
     288,    -1,   313,    -1,    36,    -1,    -1,   539,    -1,    -1,
    1424,  1509,    -1,    -1,   200,    -1,   199,    -1,   253,    -1,
      -1,   253,  1506,    -1,    -1,   199,  1326,    -1,    -1,   276,
    1506,    -1,   629,  1198,    -1,    -1,  1432,  1502,  1429,  1434,
      -1,    -1,  1432,  1433,  1430,  1431,    -1,  1175,    -1,  1358,
      -1,  1361,    -1,  1386,    -1,  1394,    -1,   137,    -1,   138,
      -1,    -1,   182,    -1,   402,    -1,    -1,  1488,    -1,  1509,
      -1,    -1,   194,  1150,  1436,  1437,    -1,    -1,  1546,  1438,
    1444,  1439,    -1,  1442,    -1,    -1,  1440,    -1,   631,   432,
     286,  1445,    -1,    -1,   197,  1441,   181,    -1,  1442,   656,
    1443,    -1,  1443,    -1,   168,   288,    -1,   164,   288,    -1,
     204,   288,    -1,   507,   288,    -1,    36,   288,    -1,   442,
     288,   688,    -1,   427,    51,    -1,   225,    -1,   418,    -1,
     288,    -1,   535,    -1,   504,   688,    -1,    69,    -1,   606,
      -1,   557,    -1,   240,    -1,   313,    -1,   139,    -1,   460,
      -1,    -1,  1351,    -1,    -1,    18,   143,    63,    -1,    -1,
     458,  1447,  1448,    -1,  1448,   656,  1449,    -1,  1449,    -1,
      -1,   504,  1450,   688,  1451,    -1,   313,    -1,   427,    51,
      -1,    -1,    13,    -1,    -1,   425,  1453,  1454,    -1,  1420,
     288,  1455,    -1,   575,  1506,    -1,    32,  1198,    -1,    -1,
     264,  1457,  1458,  1459,  1460,    -1,    -1,   217,    -1,   511,
      -1,    -1,    91,    -1,   427,    -1,   427,   230,    -1,  1198,
      -1,   605,  1514,    -1,   500,    -1,   608,  1509,    -1,    -1,
      -1,    -1,    -1,   282,  1468,  1464,  1470,  1469,   241,  1508,
    1465,  1471,   250,   558,  1502,  1261,  1466,   998,  1467,  1478,
    1472,  1475,  1479,  1481,  1484,    -1,   118,    -1,   639,    -1,
      -1,   283,    -1,    -1,    89,    -1,   294,    -1,    -1,   455,
      -1,   235,    -1,    -1,    75,  1473,    -1,  1473,  1474,    -1,
    1474,    -1,   563,    49,  1488,    -1,   385,   159,    49,  1488,
      -1,   159,    49,  1488,    -1,   170,    49,  1488,    -1,    -1,
     279,  1476,    -1,  1476,  1477,    -1,  1477,    -1,   563,    49,
    1488,    -1,   529,    49,  1488,    -1,    -1,   475,   232,    49,
    1488,    -1,    -1,   235,   371,  1480,    -1,   279,    -1,   475,
      -1,    -1,   654,  1482,   655,    -1,   654,   655,    -1,  1482,
     656,  1483,    -1,  1483,    -1,  1499,    -1,   661,  1511,    -1,
      -1,   494,  1485,    -1,  1485,   656,  1486,    -1,  1486,    -1,
    1499,  1377,  1192,  1383,  1193,    -1,   564,    -1,   355,    -1,
     590,   564,    -1,  1487,  1507,    -1,  1507,    -1,  1489,    -1,
     221,    -1,   222,    -1,    38,    -1,   397,    -1,  1492,    -1,
     648,  1493,    -1,   647,  1493,    -1,  1487,    -1,  1493,    -1,
    1494,    -1,   370,    -1,   185,    -1,   582,    -1,   221,    -1,
     222,    -1,    38,    -1,   590,  1489,    -1,   371,    -1,   291,
      -1,   587,    -1,   129,    -1,   192,    -1,   122,   564,    -1,
     571,   564,    -1,   568,   564,    -1,  1499,    -1,  1496,    -1,
    1509,   662,   649,    -1,  1509,   662,  1509,   662,   649,    -1,
    1198,    -1,  1509,    -1,  1500,    -1,  1509,    -1,  1500,    -1,
    1509,   662,  1509,    -1,   662,  1509,   662,  1509,    -1,  1509,
     662,  1509,   662,  1509,    -1,  1509,    -1,  1509,   662,  1509,
     662,  1509,    -1,  1509,   662,  1509,    -1,   662,  1509,    -1,
    1509,    -1,  1509,   662,  1509,    -1,   662,  1509,    -1,  1509,
    1404,    -1,  1509,   662,  1509,  1404,    -1,  1509,    -1,   231,
      -1,   233,    -1,   564,    -1,   564,    -1,   564,    -1,  1505,
      -1,  1515,    -1,  1505,    -1,  1516,    -1,  1509,    -1,  1506,
      -1,   275,    -1,  1511,    -1,  1511,   661,  1511,    -1,   109,
    1197,    -1,  1512,    -1,  1567,    -1,  1512,    -1,  1516,    -1,
      22,    -1,    31,    -1,    33,    -1,    50,    -1,    51,    -1,
      61,    -1,    64,    -1,    63,    -1,    70,    -1,    76,    -1,
      77,    -1,    78,    -1,    79,    -1,    80,    -1,    83,    -1,
      85,    -1,    97,    -1,   128,    -1,   149,    -1,   160,    -1,
     176,    -1,   177,    -1,   194,    -1,   209,    -1,   216,    -1,
     220,    -1,   224,    -1,   248,    -1,   265,    -1,   367,    -1,
     381,    -1,   384,    -1,   383,    -1,   393,    -1,   398,    -1,
     411,    -1,   414,    -1,   449,    -1,   452,    -1,   458,    -1,
     461,    -1,   472,    -1,   480,    -1,   485,    -1,   492,    -1,
     500,    -1,   502,    -1,   510,    -1,   504,    -1,   505,    -1,
     512,    -1,   531,    -1,   538,    -1,   583,    -1,   594,    -1,
     595,    -1,   635,    -1,   638,    -1,   603,    -1,     5,    -1,
       8,    -1,     7,    -1,     9,    -1,    10,    -1,    11,    -1,
      12,    -1,    15,    -1,    19,    -1,    24,    -1,    25,    -1,
      27,    -1,    26,    -1,    28,    -1,    29,    -1,    30,    -1,
      37,    -1,    41,    -1,    44,    -1,    46,    -1,    45,    -1,
      48,    -1,    54,    -1,    57,    -1,    58,    -1,    60,    -1,
      66,    -1,    69,    -1,    68,    -1,    67,    -1,    71,    -1,
      72,    -1,    74,    -1,    82,    -1,    75,    -1,    84,    -1,
      86,    -1,    87,    -1,    88,    -1,    89,    -1,    91,    -1,
      92,    -1,    94,    -1,    96,    -1,    95,    -1,    98,    -1,
     100,    -1,   111,    -1,   103,    -1,   106,    -1,   108,    -1,
     113,    -1,   118,    -1,   117,    -1,   119,    -1,   122,    -1,
     127,    -1,   133,    -1,   135,    -1,   139,    -1,   141,    -1,
     142,    -1,   143,    -1,   144,    -1,   145,    -1,   152,    -1,
     153,    -1,   154,    -1,   161,    -1,   165,    -1,   164,    -1,
     163,    -1,   168,    -1,   169,    -1,   171,    -1,   173,    -1,
     172,    -1,   174,    -1,   175,    -1,   180,    -1,   181,    -1,
     182,    -1,   183,    -1,   187,    -1,   186,    -1,   198,    -1,
     158,    -1,   200,    -1,   189,    -1,   190,    -1,   191,    -1,
     204,    -1,   205,    -1,   207,    -1,   206,    -1,   208,    -1,
     212,    -1,   210,    -1,   218,    -1,   217,    -1,   225,    -1,
     229,    -1,   230,    -1,   232,    -1,   236,    -1,   240,    -1,
     252,    -1,   237,    -1,   238,    -1,   242,    -1,   254,    -1,
     255,    -1,   257,    -1,   258,    -1,   247,    -1,   262,    -1,
     267,    -1,   266,    -1,   270,    -1,   273,    -1,   274,    -1,
     280,    -1,   281,    -1,   283,    -1,   285,    -1,   287,    -1,
     288,    -1,   320,    -1,   313,    -1,   316,    -1,   297,    -1,
     298,    -1,   302,    -1,   299,    -1,   300,    -1,   314,    -1,
     315,    -1,   301,    -1,   303,    -1,   296,    -1,   311,    -1,
     305,    -1,   304,    -1,   306,    -1,   307,    -1,   308,    -1,
     309,    -1,   310,    -1,   318,    -1,   319,    -1,   321,    -1,
     323,    -1,   324,    -1,   329,    -1,   330,    -1,   331,    -1,
     332,    -1,   333,    -1,   334,    -1,   337,    -1,   338,    -1,
     342,    -1,   340,    -1,   344,    -1,   345,    -1,   346,    -1,
     347,    -1,   348,    -1,   349,    -1,   350,    -1,   352,    -1,
     351,    -1,   353,    -1,   356,    -1,   357,    -1,   361,    -1,
     360,    -1,   368,    -1,   362,    -1,   363,    -1,   372,    -1,
     374,    -1,   375,    -1,   376,    -1,   378,    -1,   380,    -1,
     379,    -1,   394,    -1,   395,    -1,   400,    -1,   403,    -1,
     402,    -1,   404,    -1,   405,    -1,   406,    -1,   408,    -1,
     407,    -1,   409,    -1,   410,    -1,   415,    -1,   416,    -1,
     418,    -1,   420,    -1,   421,    -1,   422,    -1,   423,    -1,
     424,    -1,   426,    -1,   427,    -1,   428,    -1,   431,    -1,
     435,    -1,   436,    -1,   438,    -1,   437,    -1,   439,    -1,
     442,    -1,   443,    -1,   444,    -1,   445,    -1,   446,    -1,
     448,    -1,   451,    -1,   453,    -1,   456,    -1,   460,    -1,
     463,    -1,   464,    -1,   466,    -1,   468,    -1,   471,    -1,
     473,    -1,   474,    -1,   475,    -1,   478,    -1,   476,    -1,
     477,    -1,   479,    -1,   481,    -1,   482,    -1,   484,    -1,
     490,    -1,   489,    -1,   491,    -1,   503,    -1,   496,    -1,
     506,    -1,   507,    -1,   509,    -1,   511,    -1,   513,    -1,
     514,    -1,   522,    -1,   521,    -1,   524,    -1,   527,    -1,
     530,    -1,   535,    -1,   539,    -1,   541,    -1,   542,    -1,
     543,    -1,   544,    -1,   546,    -1,   545,    -1,   549,    -1,
     550,    -1,   551,    -1,   552,    -1,   560,    -1,   557,    -1,
     554,    -1,   559,    -1,   555,    -1,   561,    -1,   562,    -1,
     565,    -1,   566,    -1,   577,    -1,   578,    -1,   579,    -1,
     568,    -1,   569,    -1,   570,    -1,   571,    -1,   584,    -1,
     585,    -1,   586,    -1,   202,    -1,   588,    -1,   589,    -1,
     592,    -1,   591,    -1,   598,    -1,   601,    -1,   605,    -1,
     606,    -1,   607,    -1,   617,    -1,   622,    -1,   623,    -1,
     614,    -1,   625,    -1,   624,    -1,   626,    -1,   627,    -1,
     634,    -1,   637,    -1,   639,    -1,   642,    -1,   621,    -1,
      -1,   494,  1518,  1519,    -1,    -1,  1535,  1520,  1525,    -1,
      -1,   577,  1521,  1537,    -1,    -1,  1531,  1522,  1523,    -1,
      -1,  1534,  1524,  1525,    -1,   577,  1537,    -1,    -1,   656,
    1526,    -1,    -1,  1527,  1529,    -1,    -1,  1526,   656,  1528,
    1529,    -1,    -1,  1531,  1530,  1534,    -1,  1535,    -1,   210,
      -1,   283,    -1,   491,    -1,    -1,   210,    -1,   283,    -1,
     491,    -1,    -1,   210,   662,    -1,   283,   662,    -1,   491,
     662,    -1,  1536,  1377,  1543,    -1,  1536,  1377,  1543,    -1,
     661,  1511,  1377,  1198,    -1,   661,   661,  1533,  1536,  1377,
    1543,    -1,   995,  1000,    -1,   351,  1377,  1198,    -1,   351,
     997,  1002,    -1,   471,  1511,    -1,   404,  1377,  1542,    -1,
     404,   197,  1514,  1377,  1542,    -1,  1509,    -1,  1509,   662,
    1509,    -1,   132,   662,  1509,    -1,  1538,    -1,  1539,    -1,
    1538,   656,  1539,    -1,  1539,   656,  1538,    -1,  1540,    -1,
     257,   274,  1541,    -1,   432,   379,    -1,   432,   636,    -1,
     432,   588,    -1,   432,    84,    -1,   453,   432,    -1,   489,
      -1,   564,    -1,   404,   654,   564,   655,    -1,   376,   654,
     564,   655,    -1,  1198,    -1,   132,    -1,   377,    -1,    13,
      -1,    36,    -1,    -1,   286,  1546,  1545,  1547,    -1,   558,
      -1,   554,    -1,  1548,    -1,  1547,   656,  1548,    -1,  1502,
    1298,  1549,    -1,   432,    -1,   636,    -1,   636,    89,    -1,
     294,   636,    -1,   432,   283,    -1,    -1,   599,  1551,  1546,
      -1,   216,  1502,   381,  1298,    -1,   216,  1504,    70,    -1,
      -1,   216,  1504,   432,  1553,  1554,  1300,  1317,    -1,  1555,
      -1,  1509,  1556,    -1,   190,    -1,   361,    -1,   190,    -1,
     361,    -1,   416,    -1,   266,    -1,    -1,  1558,  1557,   654,
    1382,   655,    -1,   166,    -1,   203,    -1,   268,    -1,   215,
      -1,   295,    -1,   469,   716,  1560,    -1,  1570,   377,  1569,
    1581,   199,  1584,    -1,  1570,   377,   202,  1581,   199,  1584,
      -1,  1570,   377,   419,  1581,   199,  1584,    -1,    13,  1571,
     656,   211,   384,   199,  1584,    -1,   424,   377,  1514,   199,
    1582,    -1,  1561,   199,  1584,    -1,     7,   384,   197,  1568,
      -1,  1568,    -1,   211,   716,  1563,    -1,  1570,   377,  1569,
    1581,   575,  1583,  1591,  1592,    -1,  1570,   377,   202,  1581,
     575,  1583,  1591,  1592,    -1,  1570,   377,   419,  1581,   575,
    1583,  1591,  1592,    -1,   424,   377,  1514,   575,  1583,  1593,
      -1,  1568,   575,  1583,  1565,    -1,    -1,   631,     7,  1513,
      -1,    -1,   631,     7,   384,    -1,  1568,    -1,  1566,   656,
    1568,    -1,   110,  1197,    -1,  1511,    -1,  1567,    -1,    -1,
     558,    -1,  1572,    -1,    13,  1571,    -1,    -1,   418,    -1,
    1573,    -1,  1572,   656,  1573,    -1,    -1,   486,  1574,  1588,
      -1,    -1,   246,  1575,  1588,    -1,    -1,   602,  1576,  1588,
      -1,    -1,   440,  1577,  1588,    -1,   136,    -1,   604,    -1,
     239,    -1,    14,    -1,   104,    -1,   150,    -1,   177,    -1,
     448,    -1,   500,    -1,   420,    -1,   189,    -1,   211,   384,
      -1,   499,   116,    -1,   549,    -1,   104,   561,   554,    -1,
     286,   554,    -1,   456,   504,    -1,   456,    68,    -1,   104,
     622,    -1,   499,   622,    -1,   104,   474,    -1,    14,   474,
      -1,   104,   605,    -1,   173,    -1,   580,    -1,   104,   555,
      -1,    -1,    18,    -1,  1580,  1578,  1579,    -1,  1580,    -1,
     544,   564,    -1,   258,   564,    -1,    66,   564,    -1,   649,
      -1,  1509,   662,   649,    -1,   649,   662,   649,    -1,  1502,
      -1,  1514,    -1,  1582,   656,  1514,    -1,  1587,    -1,  1583,
     656,  1587,    -1,  1513,    -1,  1584,   656,  1513,    -1,   621,
      -1,   631,    -1,   609,    -1,    20,    -1,  1514,   232,    49,
     564,    -1,  1514,   232,    49,   404,   564,    -1,  1514,   232,
    1585,  1511,    -1,  1514,   232,  1585,  1511,  1586,  1506,    -1,
    1513,    -1,    -1,   654,  1589,   655,    -1,  1589,   656,  1590,
      -1,  1590,    -1,  1509,    -1,    -1,   457,  1579,    -1,   457,
     528,    -1,   457,   637,    -1,   457,   363,    -1,    -1,   631,
    1594,    -1,    -1,   631,   211,   384,    -1,  1594,  1595,    -1,
    1595,    -1,   211,   384,    -1,   319,  1324,    -1,   323,  1324,
      -1,   318,  1324,    -1,   324,  1323,    -1,    -1,    33,  1597,
    1598,    -1,    -1,   634,    -1,    -1,    18,   367,    58,    -1,
      18,    58,    -1,    -1,   447,    -1,   367,   447,    -1,    -1,
     480,    -1,    85,  1598,  1599,  1600,    -1,   472,  1598,  1599,
    1600,    -1,   472,  1598,   575,  1601,  1509,    -1,   480,  1509,
      -1,   447,   480,  1509,    -1,    -1,  1607,    -1,    -1,   596,
    1614,  1608,  1176,    -1,    -1,  1607,    -1,  1611,    -1,    -1,
    1611,    -1,    -1,  1612,  1613,    -1,  1312,  1316,    -1,  1318,
      -1,    -1,   146,    -1,    13,    -1,   486,  1268,    -1,   654,
    1178,   655,    -1,  1615,  1610,    -1,    -1,  1616,   596,  1614,
    1617,  1615,  1610,    -1,  1619,  1616,  1620,    -1,    -1,    -1,
      -1,  1622,    -1,  1622,  1623,    -1,  1623,    -1,   540,    -1,
     223,    -1,   146,    -1,   525,    -1,   520,    -1,   521,    -1,
     523,    -1,    13,    -1,  1629,  1625,    -1,  1628,  1626,    -1,
    1630,  1627,  1632,    -1,  1632,    -1,  1640,    -1,  1651,    -1,
    1645,    -1,   703,    -1,  1632,    -1,  1640,    -1,  1651,    -1,
    1645,    -1,  1644,    -1,   703,    -1,  1628,    -1,  1629,    -1,
      -1,   133,   166,  1513,    -1,    12,   166,   589,    -1,    12,
     166,   331,    -1,    12,   166,   562,    -1,    -1,   526,   485,
     133,    -1,   526,   485,   252,    -1,    -1,  1631,   622,  1502,
    1633,  1634,    20,  1636,    -1,    -1,   654,  1635,   655,    -1,
    1509,    -1,  1635,   656,  1509,    -1,    -1,  1637,  1638,  1639,
      -1,   486,  1179,    -1,   654,  1177,   655,  1609,    -1,    -1,
     631,    65,   384,    -1,   631,    54,    65,   384,    -1,   631,
     283,    65,   384,    -1,    -1,    -1,    -1,   580,  1192,   717,
     822,   823,   377,  1192,  1641,  1502,   197,  1192,  1642,   155,
     477,  1643,   772,    -1,    11,  1192,   202,  1509,   466,   947,
     512,  1506,    -1,  1192,   202,  1509,   466,   947,   512,  1506,
      -1,    -1,    -1,    -1,    -1,    -1,  1192,   202,   717,   654,
    1646,   728,   655,  1647,   466,  1648,   993,  1649,   719,  1650,
     772,    -1,    -1,    -1,    -1,    -1,   419,  1192,   717,  1652,
     654,  1653,   732,   655,  1654,   719,  1655,   772,    -1,   638,
    1658,  1657,  1659,    -1,   638,   160,  1657,  1661,    -1,   638,
     414,  1657,    -1,   638,    85,  1657,  1660,    -1,   638,   472,
    1657,    -1,   638,   436,    -1,  1488,    -1,  1488,   656,  1488,
      -1,  1488,   656,  1488,   656,  1324,    -1,    33,    -1,   531,
      -1,    -1,   260,    -1,   463,    -1,    -1,   378,   406,    -1,
      -1,    -1,   550,  1662,  1663,    -1,    -1,   197,   334,    -1,
     248,   408,  1509,   512,  1506,    -1,   248,   512,  1506,    -1,
     595,   408,  1509,    -1,   595,   512,  1506,    -1,   644,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1940,  1940,  1952,  1951,  1976,  1983,  1985,  1989,  1990,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,
    2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,
    2045,  2046,  2047,  2048,  2049,  2053,  2062,  2063,  2067,  2076,
    2082,  2092,  2091,  2101,  2103,  2107,  2108,  2112,  2125,  2124,
    2144,  2143,  2152,  2153,  2157,  2161,  2165,  2169,  2173,  2177,
    2182,  2186,  2190,  2194,  2198,  2202,  2207,  2211,  2216,  2247,
    2252,  2255,  2257,  2258,  2262,  2268,  2272,  2288,  2292,  2298,
    2308,  2318,  2331,  2335,  2339,  2355,  2354,  2399,  2404,  2398,
    2411,  2416,  2409,  2423,  2428,  2421,  2434,  2433,  2446,  2445,
    2461,  2465,  2469,  2473,  2477,  2484,  2497,  2498,  2502,  2506,
    2510,  2514,  2518,  2522,  2526,  2534,  2533,  2564,  2563,  2570,
    2577,  2578,  2584,  2590,  2600,  2606,  2612,  2614,  2621,  2622,
    2626,  2632,  2641,  2642,  2650,  2650,  2706,  2707,  2708,  2709,
    2710,  2711,  2712,  2713,  2714,  2715,  2716,  2717,  2718,  2723,
    2737,  2753,  2771,  2772,  2776,  2777,  2782,  2784,  2786,  2788,
    2790,  2792,  2794,  2800,  2801,  2802,  2806,  2810,  2818,  2817,
    2830,  2832,  2835,  2837,  2841,  2845,  2852,  2854,  2858,  2859,
    2864,  2884,  2912,  2914,  2918,  2919,  2923,  2950,  2951,  2952,
    2953,  2957,  2958,  2962,  2963,  2968,  2971,  2998,  2997,  3061,
    3077,  3076,  3132,  3158,  3158,  3181,  3182,  3187,  3189,  3194,
    3216,  3227,  3231,  3253,  3254,  3258,  3262,  3271,  3277,  3283,
    3292,  3306,  3329,  3335,  3336,  3342,  3345,  3349,  3357,  3377,
    3379,  3397,  3403,  3405,  3407,  3409,  3411,  3413,  3415,  3417,
    3419,  3421,  3423,  3425,  3430,  3445,  3461,  3462,  3467,  3473,
    3482,  3488,  3497,  3505,  3514,  3523,  3525,  3534,  3539,  3545,
    3554,  3562,  3564,  3566,  3568,  3570,  3572,  3574,  3576,  3578,
    3580,  3582,  3584,  3586,  3591,  3609,  3630,  3631,  3635,  3636,
    3637,  3638,  3639,  3640,  3641,  3642,  3643,  3644,  3645,  3646,
    3647,  3652,  3651,  3658,  3658,  3713,  3712,  3741,  3741,  3756,
    3809,  3852,  3873,  3872,  3894,  3913,  3915,  3916,  3920,  3940,
    3963,  3965,  3981,  3963,  4000,  4002,  4003,  4007,  4008,  4013,
    4019,  4012,  4040,  4039,  4055,  4056,  4060,  4061,  4066,  4070,
    4065,  4091,  4095,  4090,  4114,  4124,  4129,  4128,  4163,  4164,
    4169,  4168,  4200,  4200,  4215,  4214,  4251,  4263,  4265,  4262,
    4292,  4291,  4312,  4314,  4319,  4321,  4323,  4340,  4345,  4351,
    4358,  4359,  4367,  4373,  4382,  4388,  4394,  4395,  4399,  4399,
    4404,  4405,  4406,  4410,  4411,  4412,  4416,  4420,  4421,  4422,
    4426,  4427,  4428,  4429,  4430,  4431,  4432,  4433,  4437,  4441,
    4442,  4443,  4447,  4448,  4449,  4450,  4451,  4455,  4459,  4460,
    4461,  4465,  4466,  4467,  4468,  4469,  4470,  4471,  4475,  4479,
    4480,  4481,  4485,  4486,  4487,  4492,  4500,  4508,  4516,  4528,
    4540,  4545,  4550,  4558,  4566,  4574,  4582,  4590,  4598,  4606,
    4619,  4632,  4645,  4647,  4651,  4656,  4669,  4670,  4722,  4721,
    4724,  4730,  4730,  4731,  4745,  4746,  4750,  4752,  4751,  4755,
    4754,  4760,  4797,  4798,  4803,  4802,  4821,  4840,  4839,  4856,
    4860,  4868,  4867,  4870,  4872,  4874,  4876,  4881,  4882,  4888,
    4889,  4906,  4907,  4911,  4912,  4916,  4935,  4945,  4956,  4965,
    4966,  4982,  4984,  4983,  4988,  4986,  4997,  4998,  5002,  5020,
    5036,  5037,  5053,  5068,  5090,  5091,  5096,  5095,  5119,  5129,
    5151,  5150,  5168,  5167,  5187,  5209,  5213,  5242,  5254,  5255,
    5260,  5271,  5259,  5296,  5297,  5301,  5314,  5335,  5348,  5374,
    5375,  5380,  5379,  5416,  5421,  5422,  5426,  5427,  5431,  5433,
    5439,  5445,  5447,  5449,  5451,  5453,  5455,  5465,  5480,  5464,
    5494,  5495,  5499,  5500,  5504,  5505,  5509,  5510,  5514,  5515,
    5519,  5520,  5524,  5529,  5533,  5541,  5545,  5551,  5553,  5557,
    5558,  5562,  5563,  5564,  5568,  5573,  5578,  5583,  5588,  5593,
    5598,  5603,  5618,  5624,  5639,  5644,  5659,  5665,  5683,  5688,
    5693,  5698,  5703,  5708,  5714,  5713,  5739,  5740,  5741,  5746,
    5751,  5756,  5758,  5760,  5762,  5768,  5773,  5778,  5784,  5790,
    5796,  5805,  5813,  5830,  5853,  5867,  5868,  5869,  5870,  5871,
    5872,  5873,  5877,  5878,  5879,  5883,  5884,  5888,  5889,  5890,
    5891,  5896,  5903,  5904,  5908,  5909,  5913,  5914,  5922,  5921,
    5930,  5928,  5938,  5936,  5946,  5944,  5952,  5973,  5979,  5981,
    5985,  5989,  5990,  5994,  5999,  5998,  6024,  6027,  6026,  6036,
    6038,  6043,  6046,  6050,  6057,  6058,  6062,  6063,  6067,  6073,
    6079,  6083,  6099,  6115,  6116,  6117,  6118,  6123,  6127,  6132,
    6137,  6141,  6146,  6151,  6157,  6162,  6168,  6172,  6177,  6182,
    6200,  6202,  6204,  6217,  6219,  6224,  6229,  6241,  6246,  6251,
    6256,  6258,  6260,  6262,  6264,  6266,  6268,  6270,  6273,  6272,
    6277,  6276,  6280,  6282,  6291,  6292,  6293,  6299,  6300,  6301,
    6302,  6303,  6307,  6311,  6312,  6316,  6317,  6321,  6322,  6323,
    6324,  6325,  6329,  6330,  6331,  6332,  6333,  6337,  6342,  6344,
    6350,  6351,  6353,  6358,  6367,  6368,  6372,  6373,  6377,  6378,
    6379,  6383,  6384,  6385,  6386,  6389,  6390,  6394,  6395,  6399,
    6400,  6404,  6405,  6409,  6410,  6411,  6412,  6419,  6420,  6426,
    6432,  6438,  6444,  6445,  6458,  6464,  6470,  6476,  6485,  6506,
    6512,  6517,  6518,  6522,  6530,  6534,  6535,  6539,  6540,  6544,
    6553,  6557,  6558,  6562,  6570,  6571,  6575,  6576,  6580,  6581,
    6586,  6587,  6591,  6598,  6607,  6612,  6620,  6621,  6622,  6623,
    6624,  6625,  6630,  6638,  6639,  6644,  6643,  6656,  6657,  6661,
    6664,  6665,  6666,  6667,  6671,  6679,  6686,  6687,  6691,  6701,
    6702,  6706,  6707,  6710,  6712,  6716,  6728,  6729,  6733,  6740,
    6753,  6754,  6756,  6758,  6764,  6769,  6775,  6781,  6788,  6798,
    6799,  6800,  6801,  6802,  6806,  6810,  6811,  6815,  6816,  6820,
    6821,  6825,  6826,  6827,  6831,  6832,  6836,  6840,  6853,  6865,
    6866,  6870,  6871,  6875,  6876,  6880,  6881,  6885,  6886,  6890,
    6891,  6895,  6896,  6900,  6901,  6905,  6907,  6908,  6914,  6920,
    6926,  6934,  6935,  6939,  6943,  6944,  6957,  6958,  6959,  6963,
    6964,  6968,  6974,  6988,  6989,  6993,  7005,  7006,  7010,  7011,
    7019,  7037,  7018,  7057,  7056,  7070,  7082,  7081,  7100,  7099,
    7118,  7117,  7136,  7130,  7150,  7149,  7182,  7187,  7192,  7197,
    7202,  7212,  7213,  7214,  7215,  7219,  7220,  7232,  7233,  7237,
    7238,  7241,  7243,  7251,  7259,  7261,  7263,  7264,  7272,  7273,
    7277,  7286,  7284,  7297,  7310,  7309,  7322,  7320,  7333,  7340,
    7350,  7351,  7378,  7385,  7389,  7394,  7393,  7409,  7411,  7416,
    7424,  7423,  7439,  7443,  7442,  7454,  7455,  7459,  7474,  7475,
    7479,  7488,  7492,  7497,  7503,  7502,  7514,  7525,  7513,  7541,
    7550,  7559,  7569,  7578,  7584,  7590,  7599,  7608,  7627,  7645,
    7655,  7659,  7664,  7665,  7668,  7670,  7671,  7672,  7673,  7676,
    7681,  7692,  7697,  7708,  7709,  7713,  7714,  7718,  7718,  7721,
    7723,  7727,  7728,  7732,  7733,  7741,  7742,  7743,  7747,  7748,
    7753,  7761,  7762,  7763,  7764,  7769,  7768,  7778,  7777,  7784,
    7791,  7801,  7818,  7821,  7828,  7832,  7839,  7843,  7847,  7854,
    7854,  7860,  7861,  7865,  7866,  7867,  7871,  7872,  7885,  7892,
    7893,  7898,  7897,  7909,  7910,  7911,  7915,  7916,  7916,  7921,
    7920,  7941,  7942,  7946,  7947,  7951,  7952,  7953,  7957,  7958,
    7963,  7962,  7983,  7984,  7988,  7993,  7994,  8001,  8003,  8007,
    8009,  8008,  8020,  8022,  8021,  8034,  8035,  8040,  8049,  8050,
    8051,  8055,  8061,  8070,  8078,  8079,  8079,  8083,  8082,  8108,
    8109,  8113,  8114,  8118,  8119,  8120,  8121,  8122,  8123,  8127,
    8128,  8133,  8132,  8153,  8154,  8155,  8160,  8159,  8165,  8172,
    8177,  8185,  8186,  8190,  8204,  8203,  8216,  8217,  8221,  8222,
    8226,  8236,  8246,  8247,  8252,  8251,  8262,  8263,  8267,  8268,
    8272,  8282,  8293,  8292,  8300,  8300,  8309,  8310,  8315,  8316,
    8325,  8334,  8335,  8339,  8344,  8349,  8354,  8359,  8358,  8378,
    8386,  8378,  8393,  8394,  8395,  8396,  8397,  8401,  8408,  8415,
    8417,  8428,  8429,  8433,  8434,  8462,  8492,  8494,  8500,  8510,
    8511,  8512,  8526,  8531,  8556,  8562,  8568,  8569,  8570,  8571,
    8572,  8576,  8577,  8578,  8582,  8583,  8584,  8588,  8589,  8594,
    8645,  8652,  8695,  8701,  8707,  8713,  8719,  8725,  8731,  8737,
    8741,  8747,  8753,  8759,  8765,  8771,  8775,  8781,  8790,  8796,
    8804,  8810,  8820,  8826,  8835,  8845,  8851,  8861,  8867,  8876,
    8880,  8886,  8892,  8898,  8904,  8910,  8916,  8922,  8928,  8934,
    8940,  8946,  8952,  8958,  8964,  8968,  8969,  8973,  8974,  8978,
    8979,  8983,  8984,  8988,  8989,  8990,  8991,  8992,  8993,  8997,
    8998,  9003,  9009,  9013,  9020,  9027,  9034,  9041,  9048,  9053,
    9059,  9066,  9073,  9081,  9092,  9114,  9121,  9129,  9130,  9131,
    9132,  9133,  9134,  9145,  9146,  9147,  9148,  9149,  9155,  9159,
    9165,  9171,  9177,  9183,  9185,  9192,  9199,  9205,  9229,  9238,
    9245,  9253,  9259,  9266,  9272,  9286,  9293,  9309,  9315,  9321,
    9329,  9337,  9343,  9349,  9355,  9361,  9375,  9386,  9392,  9398,
    9404,  9410,  9416,  9422,  9428,  9434,  9440,  9446,  9452,  9458,
    9464,  9470,  9476,  9482,  9490,  9511,  9518,  9524,  9531,  9538,
    9545,  9552,  9558,  9564,  9571,  9577,  9584,  9590,  9596,  9602,
    9608,  9614,  9632,  9638,  9644,  9651,  9658,  9666,  9673,  9680,
    9687,  9694,  9711,  9717,  9723,  9729,  9735,  9742,  9748,  9754,
    9760,  9766,  9772,  9783,  9789,  9795,  9801,  9807,  9815,  9821,
    9832,  9838,  9844,  9852,  9862,  9868,  9884,  9890,  9897,  9904,
    9911,  9918,  9925,  9929,  9949,  9948, 10020, 10061, 10063, 10068,
   10069, 10073, 10074, 10078, 10079, 10083, 10090, 10098, 10125, 10131,
   10137, 10143, 10149, 10155, 10164, 10171, 10173, 10170, 10180, 10191,
   10197, 10203, 10209, 10215, 10221, 10227, 10233, 10239, 10246, 10245,
   10265, 10264, 10279, 10289, 10297, 10313, 10314, 10319, 10324, 10327,
   10330, 10329, 10346, 10348, 10354, 10353, 10370, 10372, 10374, 10376,
   10378, 10380, 10382, 10384, 10386, 10388, 10394, 10400, 10403, 10402,
   10408, 10409, 10413, 10420, 10428, 10429, 10433, 10440, 10448, 10449,
   10453, 10454, 10458, 10466, 10477, 10478, 10490, 10501, 10502, 10508,
   10509, 10529, 10533, 10531, 10549, 10547, 10558, 10568, 10566, 10584,
   10583, 10593, 10604, 10602, 10621, 10620, 10631, 10643, 10644, 10645,
   10649, 10650, 10658, 10659, 10663, 10678, 10678, 10693, 10733, 10818,
   10829, 10834, 10826, 10853, 10873, 10881, 10873, 10890, 10889, 10912,
   10929, 10912, 10936, 10940, 10966, 10967, 10972, 10975, 10976, 10977,
   10981, 10982, 10987, 10986, 10992, 10991, 10999, 11000, 11003, 11005,
   11005, 11009, 11009, 11014, 11015, 11019, 11021, 11026, 11027, 11031,
   11042, 11055, 11056, 11057, 11058, 11059, 11060, 11061, 11062, 11063,
   11064, 11065, 11066, 11070, 11071, 11072, 11073, 11074, 11075, 11076,
   11077, 11078, 11082, 11083, 11084, 11085, 11088, 11090, 11091, 11095,
   11096, 11104, 11106, 11110, 11112, 11111, 11125, 11128, 11127, 11142,
   11148, 11162, 11164, 11168, 11170, 11175, 11176, 11196, 11221, 11225,
   11226, 11230, 11242, 11244, 11249, 11248, 11283, 11285, 11290, 11291,
   11292, 11297, 11304, 11308, 11309, 11313, 11320, 11324, 11331, 11338,
   11345, 11355, 11388, 11392, 11398, 11404, 11413, 11421, 11425, 11432,
   11433, 11437, 11438, 11439, 11443, 11444, 11445, 11446, 11447, 11448,
   11452, 11453, 11454, 11455, 11456, 11460, 11461, 11462, 11463, 11464,
   11468, 11469, 11470, 11471, 11472, 11476, 11481, 11482, 11486, 11487,
   11490, 11493, 11492, 11535, 11536, 11540, 11541, 11545, 11555, 11555,
   11565, 11566, 11570, 11589, 11622, 11621, 11634, 11642, 11633, 11644,
   11656, 11668, 11667, 11685, 11684, 11695, 11695, 11711, 11718, 11740,
   11760, 11772, 11776, 11781, 11780, 11790, 11796, 11803, 11808, 11813,
   11823, 11824, 11828, 11839, 11852, 11853, 11857, 11869, 11873, 11881,
   11882, 11890, 11898, 11889, 11908, 11915, 11907, 11925, 11933, 11934,
   11942, 11946, 11947, 11958, 11959, 11963, 11972, 11973, 11974, 11976,
   11975, 11986, 11987, 11991, 11992, 11994, 11993, 11997, 11996, 12002,
   12003, 12007, 12008, 12012, 12022, 12023, 12027, 12028, 12033, 12032,
   12046, 12047, 12051, 12056, 12064, 12065, 12073, 12075, 12075, 12083,
   12091, 12082, 12113, 12114, 12118, 12126, 12127, 12131, 12141, 12142,
   12149, 12148, 12164, 12175, 12163, 12178, 12177, 12189, 12188, 12201,
   12203, 12207, 12208, 12212, 12225, 12241, 12242, 12246, 12247, 12251,
   12252, 12253, 12258, 12257, 12278, 12280, 12283, 12285, 12288, 12289,
   12292, 12296, 12300, 12304, 12308, 12312, 12316, 12320, 12324, 12332,
   12335, 12345, 12344, 12360, 12367, 12375, 12383, 12391, 12399, 12407,
   12414, 12421, 12427, 12429, 12431, 12440, 12444, 12449, 12448, 12454,
   12453, 12458, 12467, 12474, 12479, 12484, 12489, 12491, 12493, 12495,
   12497, 12499, 12506, 12514, 12516, 12524, 12531, 12538, 12545, 12551,
   12557, 12565, 12573, 12577, 12582, 12589, 12594, 12601, 12608, 12615,
   12622, 12629, 12636, 12642, 12649, 12656, 12661, 12666, 12671, 12681,
   12683, 12685, 12690, 12691, 12694, 12696, 12700, 12701, 12705, 12706,
   12710, 12711, 12715, 12716, 12720, 12721, 12724, 12726, 12733, 12744,
   12743, 12759, 12758, 12768, 12769, 12770, 12771, 12772, 12776, 12777,
   12781, 12782, 12783, 12787, 12788, 12789, 12804, 12803, 12816, 12815,
   12826, 12830, 12831, 12844, 12847, 12846, 12858, 12859, 12864, 12866,
   12868, 12870, 12872, 12874, 12885, 12887, 12889, 12891, 12897, 12899,
   12910, 12912, 12914, 12916, 12918, 12920, 12922, 12927, 12928, 12932,
   12933, 12937, 12936, 12946, 12947, 12951, 12951, 12954, 12955, 12959,
   12960, 12965, 12964, 12975, 12979, 12983, 12996, 12995, 13010, 13011,
   13012, 13015, 13016, 13017, 13018, 13026, 13030, 13039, 13045, 13057,
   13068, 13078, 13088, 13056, 13096, 13097, 13101, 13102, 13106, 13107,
   13115, 13119, 13120, 13121, 13124, 13126, 13130, 13131, 13135, 13140,
   13147, 13152, 13159, 13161, 13165, 13166, 13170, 13175, 13183, 13184,
   13187, 13189, 13197, 13199, 13203, 13204, 13205, 13209, 13211, 13216,
   13217, 13226, 13227, 13231, 13232, 13236, 13249, 13272, 13284, 13291,
   13310, 13318, 13323, 13335, 13343, 13358, 13378, 13379, 13380, 13388,
   13389, 13390, 13391, 13405, 13411, 13417, 13423, 13429, 13435, 13452,
   13462, 13472, 13478, 13487, 13499, 13505, 13511, 13527, 13528, 13532,
   13541, 13556, 13560, 13606, 13610, 13627, 13631, 13709, 13733, 13763,
   13764, 13780, 13790, 13794, 13800, 13806, 13816, 13822, 13831, 13841,
   13842, 13870, 13884, 13898, 13913, 13914, 13924, 13925, 13935, 13936,
   13937, 13941, 13956, 13988, 13998, 13998, 14000, 14010, 14011, 14012,
   14013, 14014, 14015, 14016, 14017, 14018, 14019, 14020, 14021, 14022,
   14023, 14024, 14025, 14026, 14027, 14028, 14029, 14030, 14031, 14032,
   14033, 14034, 14035, 14036, 14037, 14038, 14039, 14040, 14041, 14042,
   14043, 14044, 14045, 14046, 14047, 14048, 14049, 14050, 14051, 14052,
   14053, 14054, 14055, 14056, 14057, 14058, 14059, 14060, 14061, 14062,
   14063, 14064, 14065, 14066, 14067, 14068, 14069, 14079, 14080, 14081,
   14082, 14083, 14084, 14085, 14086, 14087, 14088, 14089, 14090, 14091,
   14092, 14093, 14094, 14095, 14096, 14097, 14098, 14099, 14100, 14101,
   14102, 14103, 14104, 14105, 14106, 14107, 14108, 14109, 14110, 14111,
   14112, 14113, 14114, 14115, 14116, 14117, 14118, 14119, 14120, 14121,
   14122, 14123, 14124, 14125, 14126, 14127, 14128, 14133, 14134, 14135,
   14136, 14137, 14138, 14139, 14140, 14141, 14142, 14143, 14144, 14145,
   14146, 14147, 14148, 14149, 14150, 14151, 14152, 14153, 14154, 14155,
   14156, 14157, 14158, 14159, 14160, 14161, 14162, 14163, 14164, 14165,
   14166, 14167, 14168, 14169, 14170, 14171, 14172, 14173, 14174, 14175,
   14176, 14177, 14178, 14179, 14180, 14181, 14182, 14183, 14184, 14185,
   14186, 14187, 14188, 14189, 14190, 14191, 14192, 14193, 14194, 14195,
   14196, 14197, 14198, 14199, 14200, 14201, 14202, 14203, 14204, 14205,
   14206, 14207, 14208, 14209, 14210, 14211, 14212, 14213, 14214, 14215,
   14216, 14217, 14218, 14219, 14220, 14221, 14222, 14223, 14224, 14225,
   14226, 14227, 14228, 14229, 14230, 14231, 14232, 14233, 14234, 14235,
   14236, 14237, 14238, 14239, 14240, 14241, 14242, 14243, 14244, 14245,
   14246, 14247, 14248, 14249, 14250, 14251, 14252, 14253, 14254, 14255,
   14256, 14257, 14258, 14259, 14260, 14261, 14262, 14263, 14264, 14265,
   14266, 14267, 14268, 14269, 14270, 14271, 14272, 14273, 14274, 14275,
   14276, 14277, 14278, 14279, 14280, 14281, 14282, 14283, 14284, 14285,
   14286, 14287, 14288, 14289, 14290, 14291, 14292, 14293, 14294, 14295,
   14296, 14297, 14298, 14299, 14300, 14301, 14302, 14303, 14304, 14305,
   14306, 14307, 14308, 14309, 14310, 14311, 14312, 14313, 14314, 14315,
   14316, 14317, 14318, 14319, 14320, 14321, 14322, 14323, 14324, 14325,
   14326, 14327, 14328, 14329, 14330, 14331, 14332, 14333, 14334, 14335,
   14336, 14337, 14338, 14339, 14340, 14341, 14342, 14343, 14344, 14345,
   14346, 14347, 14348, 14349, 14350, 14351, 14352, 14353, 14354, 14355,
   14356, 14357, 14358, 14359, 14360, 14361, 14362, 14363, 14364, 14365,
   14366, 14367, 14368, 14369, 14370, 14371, 14372, 14373, 14374, 14375,
   14376, 14377, 14378, 14379, 14380, 14381, 14382, 14383, 14384, 14385,
   14386, 14387, 14388, 14389, 14390, 14391, 14392, 14393, 14405, 14404,
   14422, 14421, 14428, 14427, 14437, 14436, 14447, 14446, 14452, 14460,
   14462, 14467, 14467, 14476, 14475, 14489, 14488, 14493, 14497, 14498,
   14499, 14503, 14504, 14505, 14506, 14510, 14511, 14512, 14513, 14518,
   14542, 14568, 14579, 14591, 14604, 14619, 14638, 14644, 14669, 14682,
   14708, 14751, 14765, 14766, 14767, 14768, 14772, 14789, 14806, 14807,
   14811, 14812, 14813, 14814, 14818, 14819, 14828, 14839, 14840, 14841,
   14847, 14853, 14865, 14864, 14880, 14881, 14885, 14886, 14890, 14905,
   14906, 14907, 14912, 14913, 14918, 14917, 14937, 14949, 14962, 14961,
   14995, 14996, 15000, 15001, 15005, 15006, 15007, 15008, 15010, 15009,
   15022, 15023, 15024, 15025, 15026, 15032, 15037, 15043, 15054, 15065,
   15069, 15076, 15085, 15087, 15092, 15097, 15104, 15116, 15128, 15135,
   15147, 15148, 15151, 15152, 15155, 15160, 15168, 15179, 15201, 15204,
   15206, 15210, 15211, 15218, 15220, 15224, 15225, 15230, 15229, 15233,
   15232, 15236, 15235, 15239, 15238, 15241, 15242, 15243, 15244, 15245,
   15246, 15247, 15248, 15249, 15250, 15251, 15252, 15253, 15254, 15255,
   15256, 15257, 15258, 15259, 15260, 15261, 15262, 15263, 15264, 15265,
   15266, 15270, 15271, 15275, 15276, 15280, 15290, 15300, 15313, 15328,
   15341, 15354, 15366, 15371, 15379, 15384, 15392, 15397, 15404, 15404,
   15405, 15405, 15408, 15437, 15442, 15448, 15454, 15460, 15464, 15468,
   15469, 15473, 15500, 15502, 15506, 15510, 15514, 15521, 15522, 15526,
   15527, 15531, 15532, 15536, 15537, 15543, 15549, 15555, 15565, 15564,
   15574, 15575, 15580, 15581, 15582, 15587, 15588, 15589, 15593, 15594,
   15598, 15610, 15619, 15629, 15638, 15652, 15653, 15658, 15657, 15673,
   15674, 15675, 15679, 15680, 15684, 15684, 15706, 15707, 15711, 15712,
   15713, 15717, 15721, 15728, 15731, 15729, 15745, 15752, 15773, 15797,
   15799, 15803, 15804, 15808, 15809, 15817, 15818, 15819, 15820, 15826,
   15832, 15842, 15844, 15846, 15851, 15852, 15853, 15854, 15855, 15859,
   15860, 15861, 15862, 15863, 15864, 15874, 15875, 15880, 15893, 15906,
   15908, 15910, 15916, 15917, 15919, 15925, 15924, 15941, 15942, 15946,
   15951, 15959, 15959, 15983, 15984, 15989, 15990, 15992, 15994, 16012,
   16018, 16023, 16005, 16084, 16101, 16125, 16156, 16160, 16169, 16192,
   16121, 16255, 16279, 16288, 16295, 16254, 16315, 16319, 16323, 16327,
   16331, 16335, 16342, 16349, 16356, 16366, 16367, 16371, 16372, 16373,
   16377, 16378, 16383, 16385, 16384, 16390, 16391, 16395, 16402, 16412,
   16418, 16429
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL",
  "GENERATED_SYM", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT",
  "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY",
  "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "ID_SYM", "IDENT", "IDENTIFIED_SYM",
  "IDENT_QUOTED", "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM",
  "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD",
  "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM",
  "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEG", "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM",
  "NOT2_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM",
  "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM",
  "NVARCHAR_SYM", "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM",
  "ONLY_SYM", "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM",
  "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM",
  "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM",
  "PAGE_CHECKSUM_SYM", "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM",
  "PARTIAL", "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM",
  "PASSWORD", "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM",
  "POINT_SYM", "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION",
  "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES",
  "PROCEDURE_SYM", "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM",
  "PROFILES_SYM", "PROXY_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY",
  "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM",
  "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "REMOVE_SYM", "RENAME",
  "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESIGNAL_SYM", "RESOURCES",
  "RESTORE_SYM", "RESTRICT", "RESUME_SYM", "RETURNED_SQLSTATE_SYM",
  "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM", "REVERSE_SYM", "REVOKE",
  "RIGHT", "ROLE_SYM", "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM",
  "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLAVES",
  "SLAVE_POS_SYM", "SLOW", "SMALLINT", "SNAPSHOT_SYM", "SOCKET_SYM",
  "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATS_AUTO_RECALC_SYM", "STATS_PERSISTENT_SYM",
  "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM",
  "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN", "STRING_SYM",
  "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE",
  "TABLE_REF_PRIORITY", "TABLE_STATS_SYM", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM",
  "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('",
  "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'", "$accept",
  "query", "$@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "$@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "$@3", "change", "$@4", "master_defs", "master_def",
  "ignore_server_id_list", "ignore_server_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "sp_cursor_stmt", "$@20",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@21", "sp_proc_stmt_statement", "$@22", "sp_proc_stmt_return", "$@23",
  "sp_proc_stmt_unlabeled", "$@24", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@26", "$@27", "$@28", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@29", "$@30", "searched_case_stmt", "$@31",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@32", "$@33", "searched_when_clause", "$@34",
  "$@35", "else_clause_opt", "sp_labeled_control", "$@36", "sp_opt_label",
  "sp_labeled_block", "$@37", "sp_unlabeled_block", "$@38",
  "sp_block_content", "$@39", "sp_unlabeled_control", "$@40", "$@41",
  "$@42", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@61", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "opt_select_from", "udf_type", "create_field_list",
  "field_list", "field_list_item", "column_def", "key_def", "$@62", "$@63",
  "$@64", "$@65", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "$@66", "field_def", "@67",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr",
  "virtual_column_func", "type", "$@68", "$@69", "spatial_type", "char",
  "nchar", "varchar", "nvarchar", "int_type", "real_type", "float_options",
  "precision", "field_options", "field_opt_list", "field_option",
  "field_length", "opt_field_length", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "type_with_opt_collate",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@70", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_if_not_exists_ident", "opt_component", "string_list", "alter",
  "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77", "$@78",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@79", "$@80", "$@81",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@82", "add_part_extra", "reorg_partition_rule", "$@83",
  "reorg_parts_rule", "$@84", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@85", "$@86", "$@87",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@88",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@89", "$@90", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@91",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@92", "opt_checksum_type",
  "repair_table_or_view", "$@93", "repair", "$@94", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "opt_view_repair_type", "analyze",
  "$@95", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@96", "persistent_index_stat_spec",
  "$@97", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check_view_or_table", "$@98", "check", "$@99",
  "opt_mi_check_type", "mi_check_types", "mi_check_type",
  "opt_view_check_type", "optimize", "$@100", "opt_no_write_to_binlog",
  "rename", "$@101", "rename_list", "table_to_table_list",
  "table_to_table", "keycache", "$@102", "keycache_list_or_parts",
  "keycache_list", "assign_to_keycache", "assign_to_keycache_parts",
  "key_cache_name", "preload", "$@103", "preload_list_or_parts",
  "preload_list", "preload_keys", "preload_keys_parts", "adm_partition",
  "$@104", "cache_keys_spec", "$@105", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_paren_derived", "select_init2", "$@106", "select_part2", "$@107",
  "$@108", "select_into", "select_from", "select_options",
  "select_option_list", "select_option", "select_lock_type",
  "select_item_list", "select_item", "remember_name", "remember_end",
  "select_alias", "opt_default_time_precision", "opt_time_precision",
  "optional_braces", "expr", "bool_pri", "predicate", "bit_expr", "or",
  "and", "not", "not2", "comp_op", "all_or_any", "opt_dyncol_type",
  "dyncol_type", "dyncall_create_element", "dyncall_create_list",
  "simple_expr", "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "geometry_function", "function_call_generic",
  "@109", "fulltext_options", "opt_natural_language_mode",
  "opt_query_expansion", "opt_udf_expr_list", "udf_expr_list", "udf_expr",
  "sum_expr", "$@110", "$@111", "$@112", "variable", "$@113",
  "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "$@114", "gorder_list", "in_sum_expr", "$@115",
  "cast_type", "$@116", "opt_expr_list", "expr_list", "ident_list_arg",
  "ident_list", "opt_expr", "opt_else", "when_list", "table_ref",
  "join_table_list", "esc_table_ref", "derived_table_list", "join_table",
  "$@117", "$@118", "$@119", "$@120", "$@121", "$@122", "inner_join",
  "normal_join", "opt_use_partition", "use_partition", "table_factor",
  "$@123", "select_derived_union", "$@124", "$@125",
  "select_init2_derived", "select_part2_derived", "$@126", "$@127",
  "select_derived", "$@128", "select_derived2", "$@129", "$@130",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@131",
  "$@132", "index_hints_list", "opt_index_hints_list", "$@133",
  "opt_key_definition", "$@134", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@135", "having_clause", "$@136", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@137", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@138", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@139",
  "select_var_list", "select_var_ident", "into", "$@140",
  "into_destination", "$@141", "$@142", "do", "$@143", "drop", "$@144",
  "$@145", "$@146", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@147",
  "$@148", "replace", "$@149", "$@150", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@151", "fields", "insert_values", "$@152", "$@153", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@154", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@155", "update", "$@156", "$@157", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@158", "single_multi", "$@159", "$@160", "$@161", "$@162",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@163", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@164", "show_param",
  "$@165", "$@166", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@167", "$@168", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@169", "flush_options", "$@170", "opt_flush_lock",
  "flush_lock", "$@171", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@172",
  "reset_options", "reset_option", "$@173", "slave_reset_options", "purge",
  "$@174", "purge_options", "purge_option", "kill", "$@175", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@176", "$@177",
  "$@178", "$@179", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "hex_or_bin_String", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user_maybe_role",
  "user_or_role", "user", "keyword", "keyword_sp", "set", "$@180",
  "start_option_value_list", "$@181", "$@182", "$@183",
  "start_option_value_list_following_option_type", "$@184",
  "option_value_list_continued", "option_value_list", "$@185", "$@186",
  "option_value", "$@187", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@188",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@189", "handler", "$@190", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@191",
  "handler_rkey_mode", "revoke", "revoke_command", "admin_option_for_role",
  "grant", "grant_command", "opt_with_admin", "opt_with_admin_option",
  "role_list", "current_role", "grant_role", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@192", "$@193", "$@194", "$@195", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "user_and_role_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@196", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@197",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@198",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@199", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_algorithm", "view_suid",
  "view_tail", "$@200", "view_list_opt", "view_list", "view_select",
  "$@201", "view_select_aux", "view_check_option", "trigger_tail", "$@202",
  "$@203", "$@204", "udf_tail", "sf_tail", "$@205", "$@206", "$@207",
  "$@208", "$@209", "sp_tail", "$@210", "$@211", "$@212", "$@213", "xa",
  "xid", "begin_or_start", "opt_join_or_resume", "opt_one_phase",
  "opt_suspend", "$@214", "opt_migrate", "install", "uninstall",
  "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   124,    38,    45,    43,    42,
      47,    37,    94,   126,    40,    41,    44,    33,   123,   125,
      59,    64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   664,   665,   666,   665,   665,   667,   667,   668,   668,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   670,   671,   671,   672,   673,
     673,   675,   674,   676,   676,   677,   677,   678,   680,   679,
     682,   681,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   686,   687,   687,   687,   687,   687,
     687,   687,   688,   688,   689,   691,   690,   692,   693,   690,
     694,   695,   690,   696,   697,   690,   698,   690,   699,   690,
     690,   690,   690,   690,   690,   700,   701,   701,   702,   702,
     702,   702,   702,   702,   702,   704,   703,   706,   705,   705,
     707,   707,   707,   707,   708,   708,   709,   709,   710,   710,
     711,   711,   712,   712,   714,   713,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   716,
     717,   717,   718,   718,   719,   719,   720,   720,   720,   720,
     720,   720,   720,   721,   721,   721,   722,   722,   724,   723,
     725,   725,   726,   726,   727,   727,   728,   728,   729,   729,
     730,   731,   732,   732,   733,   733,   734,   735,   735,   735,
     735,   736,   736,   737,   737,   738,   738,   740,   739,   739,
     741,   739,   739,   743,   742,   744,   744,   745,   745,   746,
     747,   747,   748,   749,   749,   750,   750,   750,   750,   750,
     751,   752,   752,   753,   753,   754,   754,   755,   755,   756,
     756,   756,   757,   757,   757,   757,   757,   757,   757,   757,
     757,   757,   757,   757,   758,   759,   760,   760,   761,   761,
     762,   762,   763,   764,   764,   765,   765,   766,   767,   767,
     768,   769,   769,   769,   769,   769,   769,   769,   769,   769,
     769,   769,   769,   769,   770,   770,   771,   771,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   774,   773,   776,   775,   778,   777,   780,   779,   781,
     782,   783,   785,   784,   786,   787,   787,   787,   788,   788,
     790,   791,   792,   789,   793,   793,   793,   794,   794,   796,
     797,   795,   799,   798,   800,   800,   801,   801,   803,   804,
     802,   806,   807,   805,   808,   808,   810,   809,   811,   811,
     813,   812,   815,   814,   817,   816,   818,   819,   820,   818,
     821,   818,   822,   822,   823,   823,   823,   824,   825,   826,
     827,   827,   828,   828,   829,   830,   831,   831,   833,   832,
     834,   834,   834,   835,   835,   835,   836,   837,   837,   837,
     838,   838,   838,   838,   838,   838,   838,   838,   839,   840,
     840,   840,   841,   841,   841,   841,   841,   842,   843,   843,
     843,   844,   844,   844,   844,   844,   844,   844,   845,   846,
     846,   846,   847,   847,   847,   848,   849,   850,   851,   852,
     853,   853,   853,   854,   855,   856,   857,   858,   859,   860,
     861,   862,   863,   863,   864,   864,   865,   865,   867,   866,
     866,   868,   866,   866,   869,   869,   870,   871,   870,   872,
     870,   873,   874,   874,   876,   875,   877,   879,   878,   880,
     881,   882,   881,   881,   881,   881,   881,   883,   883,   884,
     884,   885,   885,   886,   886,   887,   888,   889,   890,   891,
     891,   892,   893,   892,   894,   892,   895,   895,   896,   897,
     898,   898,   899,   899,   900,   900,   902,   901,   903,   904,
     905,   904,   906,   904,   907,   907,   908,   908,   909,   909,
     911,   912,   910,   913,   913,   914,   914,   915,   915,   916,
     916,   918,   917,   919,   920,   920,   921,   921,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   924,   925,   923,
     926,   926,   927,   927,   928,   928,   929,   929,   930,   930,
     931,   931,   932,   933,   933,   934,   934,   935,   935,   936,
     936,   937,   937,   937,   938,   938,   938,   938,   938,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   938,   938,   938,   939,   938,   938,   938,   938,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   940,   941,   942,   943,   944,   944,   944,   944,   944,
     944,   944,   945,   945,   945,   946,   946,   947,   947,   947,
     947,   948,   949,   949,   950,   950,   951,   951,   953,   952,
     954,   952,   955,   952,   956,   952,   952,   952,   957,   957,
     958,   959,   959,   960,   962,   961,   963,   964,   963,   965,
     965,   966,   966,   966,   967,   967,   968,   968,   969,   969,
     969,   970,   971,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   973,   972,
     974,   972,   972,   972,   975,   975,   975,   975,   975,   975,
     975,   975,   976,   977,   977,   978,   978,   979,   979,   979,
     979,   979,   980,   980,   980,   980,   980,   981,   981,   981,
     982,   982,   982,   983,   984,   984,   985,   985,   986,   986,
     986,   987,   987,   987,   987,   988,   988,   989,   989,   990,
     990,   991,   991,   992,   992,   992,   992,   992,   992,   992,
     992,   992,   992,   992,   992,   992,   992,   992,   993,   994,
     994,   995,   995,   996,   996,   997,   997,   998,   998,   999,
     999,  1000,  1000,  1001,  1002,  1002,  1003,  1003,  1004,  1004,
    1005,  1005,  1005,  1006,  1006,  1006,  1007,  1007,  1007,  1007,
    1007,  1007,  1007,  1008,  1008,  1010,  1009,  1011,  1011,  1012,
    1013,  1013,  1013,  1013,  1014,  1015,  1016,  1016,  1017,  1018,
    1018,  1019,  1019,  1020,  1020,  1021,  1022,  1022,  1023,  1023,
    1024,  1024,  1024,  1024,  1025,  1025,  1025,  1025,  1025,  1026,
    1026,  1026,  1026,  1026,  1027,  1028,  1028,  1029,  1029,  1030,
    1030,  1031,  1031,  1031,  1032,  1032,  1033,  1034,  1035,  1036,
    1036,  1037,  1037,  1038,  1038,  1039,  1039,  1040,  1040,  1041,
    1041,  1042,  1042,  1043,  1043,  1044,  1044,  1044,  1044,  1044,
    1044,  1045,  1045,  1046,  1047,  1047,  1048,  1048,  1048,  1049,
    1049,  1050,  1050,  1051,  1051,  1052,  1053,  1053,  1054,  1054,
    1056,  1057,  1055,  1058,  1055,  1055,  1059,  1055,  1060,  1055,
    1061,  1055,  1062,  1055,  1063,  1055,  1055,  1055,  1055,  1055,
    1055,  1064,  1064,  1064,  1064,  1065,  1065,  1066,  1066,  1067,
    1067,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,
    1068,  1069,  1068,  1068,  1070,  1068,  1071,  1068,  1068,  1068,
    1068,  1068,  1072,  1073,  1073,  1075,  1074,  1076,  1076,  1076,
    1078,  1077,  1079,  1080,  1079,  1081,  1081,  1082,  1083,  1083,
    1084,  1085,  1085,  1085,  1086,  1085,  1087,  1088,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1089,  1089,  1089,  1089,  1089,  1090,
    1090,  1091,  1091,  1092,  1092,  1093,  1093,  1095,  1094,  1096,
    1096,  1097,  1097,  1098,  1098,  1099,  1099,  1099,  1100,  1100,
    1100,  1101,  1101,  1101,  1101,  1103,  1102,  1104,  1102,  1102,
    1102,  1105,  1106,  1106,  1107,  1107,  1108,  1108,  1108,  1110,
    1109,  1111,  1111,  1112,  1112,  1112,  1113,  1113,  1113,  1114,
    1114,  1116,  1115,  1117,  1117,  1117,  1118,  1119,  1118,  1121,
    1120,  1122,  1122,  1123,  1123,  1124,  1124,  1124,  1125,  1125,
    1127,  1126,  1128,  1128,  1129,  1130,  1130,  1131,  1131,  1132,
    1133,  1132,  1134,  1135,  1134,  1136,  1136,  1136,  1137,  1137,
    1137,  1138,  1138,  1139,  1140,  1141,  1140,  1143,  1142,  1144,
    1144,  1145,  1145,  1146,  1146,  1146,  1146,  1146,  1146,  1147,
    1147,  1149,  1148,  1150,  1150,  1150,  1152,  1151,  1151,  1153,
    1153,  1154,  1154,  1155,  1157,  1156,  1158,  1158,  1159,  1159,
    1160,  1161,  1162,  1162,  1164,  1163,  1165,  1165,  1166,  1166,
    1167,  1168,  1170,  1169,  1172,  1171,  1173,  1173,  1174,  1174,
    1175,  1176,  1176,  1177,  1177,  1178,  1178,  1180,  1179,  1182,
    1183,  1181,  1184,  1184,  1184,  1184,  1184,  1185,  1185,  1186,
    1186,  1187,  1187,  1188,  1188,  1188,  1189,  1189,  1189,  1190,
    1190,  1190,  1191,  1191,  1192,  1193,  1194,  1194,  1194,  1194,
    1194,  1195,  1195,  1195,  1196,  1196,  1196,  1197,  1197,  1198,
    1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1199,  1199,  1199,  1199,  1199,  1199,  1200,  1200,  1200,  1200,
    1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,
    1201,  1201,  1201,  1201,  1201,  1201,  1201,  1201,  1201,  1201,
    1201,  1201,  1201,  1201,  1201,  1202,  1202,  1203,  1203,  1204,
    1204,  1205,  1205,  1206,  1206,  1206,  1206,  1206,  1206,  1207,
    1207,  1208,  1208,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1210,  1211,  1211,  1212,  1212,  1212,
    1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,
    1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,  1212,
    1212,  1212,  1212,  1212,  1212,  1212,  1212,  1213,  1213,  1213,
    1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,
    1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,  1213,
    1213,  1213,  1213,  1213,  1213,  1214,  1214,  1214,  1214,  1214,
    1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,
    1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,
    1214,  1214,  1215,  1215,  1215,  1215,  1215,  1215,  1215,  1215,
    1215,  1215,  1215,  1215,  1215,  1215,  1215,  1215,  1215,  1215,
    1215,  1215,  1215,  1215,  1215,  1215,  1216,  1216,  1216,  1216,
    1216,  1216,  1216,  1216,  1218,  1217,  1217,  1219,  1219,  1220,
    1220,  1221,  1221,  1222,  1222,  1223,  1223,  1224,  1225,  1225,
    1225,  1225,  1225,  1225,  1225,  1226,  1227,  1225,  1225,  1225,
    1225,  1225,  1225,  1225,  1225,  1225,  1225,  1225,  1228,  1225,
    1230,  1229,  1231,  1231,  1231,  1232,  1232,  1233,  1233,  1234,
    1235,  1234,  1236,  1236,  1238,  1237,  1239,  1239,  1239,  1239,
    1239,  1239,  1239,  1239,  1239,  1239,  1239,  1239,  1240,  1239,
    1241,  1241,  1242,  1242,  1243,  1243,  1244,  1244,  1245,  1245,
    1246,  1246,  1247,  1247,  1248,  1248,  1249,  1250,  1250,  1251,
    1251,  1252,  1253,  1252,  1254,  1252,  1252,  1255,  1252,  1256,
    1252,  1252,  1257,  1252,  1258,  1252,  1252,  1259,  1259,  1259,
    1260,  1260,  1261,  1261,  1262,  1264,  1263,  1263,  1263,  1265,
    1266,  1267,  1265,  1268,  1270,  1271,  1269,  1273,  1272,  1275,
    1276,  1274,  1277,  1278,  1279,  1279,  1280,  1280,  1280,  1280,
    1281,  1281,  1283,  1282,  1284,  1282,  1285,  1285,  1286,  1287,
    1286,  1289,  1288,  1290,  1290,  1291,  1291,  1292,  1292,  1293,
    1293,  1294,  1294,  1294,  1294,  1294,  1294,  1294,  1294,  1294,
    1294,  1294,  1294,  1295,  1295,  1295,  1295,  1295,  1295,  1295,
    1295,  1295,  1296,  1296,  1296,  1296,  1297,  1297,  1297,  1298,
    1298,  1299,  1299,  1300,  1301,  1300,  1302,  1303,  1302,  1304,
    1304,  1305,  1305,  1306,  1306,  1307,  1307,  1307,  1308,  1309,
    1309,  1310,  1311,  1311,  1313,  1312,  1314,  1314,  1315,  1315,
    1315,  1316,  1316,  1317,  1317,  1318,  1318,  1318,  1319,  1319,
    1319,  1320,  1320,  1320,  1320,  1320,  1321,  1322,  1322,  1322,
    1322,  1323,  1323,  1323,  1324,  1324,  1324,  1324,  1324,  1324,
    1325,  1325,  1325,  1325,  1325,  1326,  1326,  1326,  1326,  1326,
    1327,  1327,  1327,  1327,  1327,  1328,  1329,  1329,  1330,  1330,
    1331,  1332,  1331,  1333,  1333,  1334,  1334,  1335,  1337,  1336,
    1338,  1338,  1339,  1339,  1341,  1340,  1343,  1344,  1342,  1342,
    1342,  1346,  1345,  1348,  1347,  1349,  1347,  1347,  1347,  1347,
    1347,  1347,  1347,  1350,  1347,  1347,  1347,  1347,  1347,  1347,
    1351,  1351,  1352,  1353,  1354,  1354,  1355,  1356,  1356,  1357,
    1357,  1359,  1360,  1358,  1362,  1363,  1361,  1364,  1364,  1364,
    1364,  1365,  1365,  1366,  1366,  1367,  1368,  1368,  1368,  1369,
    1368,  1370,  1370,  1371,  1371,  1372,  1371,  1373,  1371,  1374,
    1374,  1375,  1375,  1376,  1377,  1377,  1378,  1378,  1380,  1379,
    1381,  1381,  1382,  1382,  1383,  1383,  1384,  1385,  1384,  1387,
    1388,  1386,  1389,  1389,  1390,  1391,  1391,  1392,  1393,  1393,
    1395,  1394,  1397,  1398,  1396,  1399,  1396,  1400,  1396,  1401,
    1401,  1402,  1402,  1403,  1403,  1404,  1404,  1405,  1405,  1406,
    1406,  1406,  1408,  1407,  1409,  1409,  1410,  1410,  1411,  1411,
    1412,  1412,  1412,  1412,  1412,  1412,  1412,  1412,  1412,  1413,
    1413,  1415,  1414,  1416,  1416,  1416,  1416,  1416,  1416,  1416,
    1416,  1416,  1416,  1416,  1416,  1416,  1416,  1417,  1416,  1418,
    1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,
    1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,
    1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,
    1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1419,
    1419,  1419,  1420,  1420,  1421,  1421,  1422,  1422,  1423,  1423,
    1424,  1424,  1425,  1425,  1426,  1426,  1427,  1427,  1427,  1429,
    1428,  1430,  1428,  1431,  1431,  1431,  1431,  1431,  1432,  1432,
    1433,  1433,  1433,  1434,  1434,  1434,  1436,  1435,  1438,  1437,
    1437,  1439,  1439,  1440,  1441,  1440,  1442,  1442,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1444,  1444,  1445,
    1445,  1447,  1446,  1448,  1448,  1450,  1449,  1449,  1449,  1451,
    1451,  1453,  1452,  1454,  1455,  1455,  1457,  1456,  1458,  1458,
    1458,  1459,  1459,  1459,  1459,  1460,  1460,  1461,  1462,  1464,
    1465,  1466,  1467,  1463,  1468,  1468,  1469,  1469,  1470,  1470,
    1470,  1471,  1471,  1471,  1472,  1472,  1473,  1473,  1474,  1474,
    1474,  1474,  1475,  1475,  1476,  1476,  1477,  1477,  1478,  1478,
    1479,  1479,  1480,  1480,  1481,  1481,  1481,  1482,  1482,  1483,
    1483,  1484,  1484,  1485,  1485,  1486,  1487,  1487,  1487,  1487,
    1488,  1488,  1489,  1489,  1489,  1490,  1491,  1491,  1491,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1493,
    1493,  1493,  1493,  1493,  1494,  1494,  1494,  1495,  1495,  1496,
    1496,  1497,  1498,  1498,  1499,  1499,  1500,  1500,  1500,  1501,
    1501,  1501,  1501,  1502,  1502,  1502,  1503,  1503,  1504,  1505,
    1505,  1506,  1507,  1508,  1509,  1509,  1510,  1510,  1511,  1511,
    1511,  1512,  1512,  1512,  1513,  1513,  1514,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1518,  1517,
    1520,  1519,  1521,  1519,  1522,  1519,  1524,  1523,  1523,  1525,
    1525,  1527,  1526,  1528,  1526,  1530,  1529,  1529,  1531,  1531,
    1531,  1532,  1532,  1532,  1532,  1533,  1533,  1533,  1533,  1534,
    1535,  1535,  1535,  1535,  1535,  1535,  1535,  1535,  1535,  1536,
    1536,  1536,  1537,  1537,  1537,  1537,  1538,  1539,  1540,  1540,
    1541,  1541,  1541,  1541,  1542,  1542,  1542,  1543,  1543,  1543,
    1543,  1543,  1545,  1544,  1546,  1546,  1547,  1547,  1548,  1549,
    1549,  1549,  1549,  1549,  1551,  1550,  1552,  1552,  1553,  1552,
    1554,  1554,  1555,  1555,  1556,  1556,  1556,  1556,  1557,  1556,
    1558,  1558,  1558,  1558,  1558,  1559,  1560,  1560,  1560,  1560,
    1560,  1560,  1561,  1561,  1562,  1563,  1563,  1563,  1563,  1563,
    1564,  1564,  1565,  1565,  1566,  1566,  1567,  1568,  1568,  1569,
    1569,  1570,  1570,  1571,  1571,  1572,  1572,  1574,  1573,  1575,
    1573,  1576,  1573,  1577,  1573,  1573,  1573,  1573,  1573,  1573,
    1573,  1573,  1573,  1573,  1573,  1573,  1573,  1573,  1573,  1573,
    1573,  1573,  1573,  1573,  1573,  1573,  1573,  1573,  1573,  1573,
    1573,  1578,  1578,  1579,  1579,  1580,  1580,  1580,  1581,  1581,
    1581,  1581,  1582,  1582,  1583,  1583,  1584,  1584,  1585,  1585,
    1586,  1586,  1587,  1587,  1587,  1587,  1587,  1588,  1588,  1589,
    1589,  1590,  1591,  1591,  1591,  1591,  1591,  1592,  1592,  1593,
    1593,  1594,  1594,  1595,  1595,  1595,  1595,  1595,  1597,  1596,
    1598,  1598,  1599,  1599,  1599,  1600,  1600,  1600,  1601,  1601,
    1602,  1603,  1603,  1604,  1605,  1606,  1606,  1608,  1607,  1609,
    1609,  1609,  1610,  1610,  1612,  1611,  1613,  1613,  1614,  1614,
    1614,  1615,  1615,  1616,  1617,  1616,  1618,  1619,  1620,  1621,
    1621,  1622,  1622,  1623,  1623,  1623,  1623,  1623,  1623,  1623,
    1623,  1624,  1624,  1624,  1625,  1625,  1625,  1625,  1625,  1626,
    1626,  1626,  1626,  1626,  1626,  1627,  1627,  1628,  1629,  1630,
    1630,  1630,  1631,  1631,  1631,  1633,  1632,  1634,  1634,  1635,
    1635,  1637,  1636,  1638,  1638,  1639,  1639,  1639,  1639,  1641,
    1642,  1643,  1640,  1644,  1644,  1646,  1647,  1648,  1649,  1650,
    1645,  1652,  1653,  1654,  1655,  1651,  1656,  1656,  1656,  1656,
    1656,  1656,  1657,  1657,  1657,  1658,  1658,  1659,  1659,  1659,
    1660,  1660,  1661,  1662,  1661,  1663,  1663,  1664,  1664,  1665,
    1665,  1666
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     0,     3,
       0,     6,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     0,     1,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     1,     0,     7,     0,     0,    15,
       0,     0,    15,     0,     0,    15,     0,     6,     0,     3,
       4,     5,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    13,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     0,     1,     1,     3,
       1,     3,     3,     1,     2,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     5,     0,     2,     0,     3,     0,     2,     2,
       2,     2,     0,     6,     2,     0,     2,     1,     1,     3,
       0,     0,     0,     7,     0,     2,     2,     1,     1,     0,
       0,     8,     0,     6,     1,     2,     1,     2,     0,     0,
       6,     0,     0,     6,     0,     2,     0,     5,     0,     1,
       0,     5,     0,     2,     0,     5,     4,     0,     0,     8,
       0,     7,     1,     1,     1,     1,     1,     2,     4,     5,
       0,     4,     4,     4,     3,     3,     2,     2,     0,     2,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     0,     7,
       3,     0,     5,     1,     2,     4,     0,     0,     5,     0,
       7,     1,     0,     1,     0,     4,     0,     0,     3,     5,
       6,     0,     4,     2,     2,     2,     2,     0,     1,     0,
       3,     0,     1,     1,     3,     1,     4,     5,     5,     0,
       2,     0,     0,     7,     0,    10,     1,     3,     1,     1,
       0,     2,     0,     3,     1,     3,     0,     6,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     3,     1,     3,
       0,     0,     5,     1,     3,     1,     1,     0,     3,     1,
       3,     0,     4,     1,     0,     1,     2,     1,     3,     4,
       3,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     1,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     0,     6,     1,     1,     3,     4,
       4,     2,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     0,     8,
       0,     9,     0,     9,     0,     9,     8,     2,     0,     1,
       4,     0,     1,     2,     0,     3,     2,     0,     9,     0,
       2,     0,     1,     1,     0,     1,     2,     1,     1,     2,
       2,     4,     3,     3,     3,     3,     1,     2,     1,     1,
       3,     2,     3,     2,     2,     1,     3,     3,     2,     3,
       1,     2,     2,     2,     1,     2,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     3,     3,     3,     0,     6,
       0,     6,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     5,     0,     1,     2,     1,     1,     1,
       1,     3,     3,     3,     3,     0,     1,     0,     1,     0,
       1,     2,     1,     1,     2,     2,     4,     1,     3,     2,
       1,     2,     2,     2,     3,     3,     3,     3,     2,     2,
       1,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     0,     1,
       1,     2,     2,     1,     2,     2,     0,     1,     1,     1,
       3,     1,     3,     0,     1,     0,     4,     1,     1,     1,
       0,     1,     2,     1,     1,     2,     1,     3,     3,     1,
       1,     0,     2,     0,     1,     5,     0,     3,     3,     1,
       0,     2,     2,     2,     0,     3,     3,     6,     6,     1,
       1,     2,     2,     2,     1,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     1,     1,     0,     1,
       2,     0,     1,     0,     1,     0,     1,     1,     2,     1,
       2,     1,     2,     2,     2,     3,     2,     3,     3,     3,
       3,     1,     1,     1,     1,     3,     1,     1,     1,     4,
       2,     1,     4,     0,     1,     2,     0,     2,     1,     3,
       0,     0,     7,     0,     5,     7,     0,     5,     0,     5,
       0,     5,     0,     4,     0,    10,     3,     4,     3,     3,
       7,     0,     3,     1,     4,     0,     3,     0,     2,     0,
       1,     0,     2,     2,     2,     2,     1,     1,     1,     4,
       4,     0,     6,     4,     0,     5,     0,     6,     4,     3,
       1,     7,     2,     1,     1,     0,     6,     0,     3,     2,
       0,     5,     0,     0,     6,     1,     3,     1,     1,     3,
       3,     3,     2,     4,     0,     7,     0,     0,     8,     5,
       5,     3,     4,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     2,     3,
       3,     3,     3,     0,     1,     0,     1,     0,     2,     0,
       1,     2,     1,     1,     1,     0,     1,     1,     0,     2,
       1,     0,     1,     1,     1,     0,     6,     0,     5,     4,
       4,     3,     0,     1,     1,     3,     3,     2,     2,     0,
       2,     1,     3,     0,     1,     1,     0,     2,     4,     1,
       3,     0,     5,     0,     1,     1,     3,     0,     4,     0,
       4,     0,     1,     1,     2,     1,     1,     1,     0,     2,
       0,     5,     1,     3,     2,     0,     3,     1,     4,     1,
       0,     4,     1,     0,     4,     0,     1,     3,     0,     1,
       3,     1,     1,     2,     3,     0,     4,     0,     3,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     0,
       2,     0,     5,     0,     1,     1,     0,     4,     4,     3,
       5,     1,     3,     3,     0,     6,     1,     1,     1,     3,
       2,     3,     1,     1,     0,     6,     1,     1,     1,     3,
       3,     4,     0,     6,     0,     2,     0,     4,     0,     2,
       1,     2,     4,     2,     3,     2,     3,     0,     3,     0,
       0,     6,     2,     1,     1,     2,     2,     8,     4,     0,
       1,     2,     1,     1,     1,     1,     0,     2,     4,     3,
       1,     1,     3,     4,     0,     0,     0,     2,     2,     1,
       1,     0,     2,     3,     0,     2,     3,     0,     2,     3,
       3,     3,     2,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     3,     3,     3,     3,     3,     5,     5,     3,     3,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     1,     2,     1,     1,     1,     2,     2,
       1,     1,     2,     2,     4,     1,     3,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     5,     4,     6,     2,
       2,     4,     4,     4,    10,     6,     8,     6,     4,     4,
       6,     4,     4,     4,     6,     4,     7,     7,     7,     6,
       6,     6,     6,     3,     4,     6,     8,     2,     2,     8,
       8,     6,     6,     2,     6,     6,     8,     8,     6,     8,
       6,     2,     8,     8,     2,     2,     2,     6,     6,     4,
       4,     8,     4,     4,     4,     4,     3,     8,     4,     4,
       6,     4,     4,     4,     6,     8,     4,     3,     6,     4,
       6,     5,     8,     7,    10,     1,     6,     4,     4,     4,
       4,     4,     6,     4,     0,     5,     6,     2,     3,     0,
       4,     0,     3,     0,     1,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       0,     4,     4,     2,     0,     3,     2,     3,     2,     1,
       1,     2,     1,     2,     1,     2,     2,     2,     0,     3,
       0,     1,     1,     3,     1,     3,     1,     3,     0,     1,
       0,     2,     4,     5,     1,     1,     1,     1,     4,     1,
       3,     3,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     1,
       1,     2,     0,     1,     5,     0,     5,     3,     5,     2,
       0,     0,     7,     1,     0,     0,     6,     0,     3,     0,
       0,     5,     0,     1,     0,     1,     0,     2,     3,     3,
       1,     1,     0,     7,     0,     7,     1,     2,     0,     0,
       2,     0,     2,     0,     1,     1,     1,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       2,     0,     1,     0,     0,     3,     0,     0,     3,     2,
       0,     0,     4,     4,     2,     0,     1,     1,     3,     3,
       1,     2,     0,     1,     0,     4,     4,     2,     0,     1,
       1,     0,     1,     0,     1,     2,     5,     4,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     0,     2,     3,
       4,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     6,     0,     1,     3,     1,     3,     0,     2,
       3,     1,     2,     1,     0,     3,     0,     0,     7,     2,
       1,     0,     3,     0,     7,     0,     7,     4,     6,     4,
       4,     4,     4,     0,     6,     4,     4,     5,     6,     4,
       1,     3,     1,     2,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     0,     9,     0,     5,     0,     6,     0,
       2,     1,     3,     2,     4,     0,     2,     0,     2,     1,
       1,     1,     0,     4,     0,     1,     0,     1,     1,     3,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     0,
       3,     0,     3,     2,     4,     4,     3,     4,     4,     1,
       3,     3,     3,     3,     6,     2,     2,     0,     6,     0,
       7,     5,     2,     1,     1,     1,     5,     5,     2,     2,
       1,     4,     3,     2,     3,     2,     2,     1,     3,     4,
       3,     3,     2,     3,     2,     3,     1,     1,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     0,     1,     1,     0,     4,     0,     4,
       1,     0,     1,     4,     0,     3,     3,     1,     2,     2,
       2,     2,     2,     3,     2,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       3,     0,     3,     3,     1,     0,     4,     1,     2,     0,
       1,     0,     3,     3,     2,     2,     0,     5,     0,     1,
       1,     0,     1,     1,     2,     1,     2,     1,     2,     0,
       0,     0,     0,    22,     1,     1,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     4,
       0,     3,     1,     1,     0,     3,     2,     3,     1,     1,
       2,     0,     2,     3,     1,     5,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     2,     2,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       0,     3,     0,     3,     0,     3,     0,     3,     2,     0,
       2,     0,     2,     0,     4,     0,     3,     1,     1,     1,
       1,     0,     1,     1,     1,     0,     2,     2,     2,     3,
       3,     4,     6,     2,     3,     3,     2,     3,     5,     1,
       3,     3,     1,     1,     3,     3,     1,     3,     2,     2,
       2,     2,     2,     1,     1,     4,     4,     1,     1,     1,
       1,     1,     0,     4,     1,     1,     1,     3,     3,     1,
       1,     2,     2,     2,     0,     3,     4,     3,     0,     7,
       1,     2,     1,     1,     1,     1,     1,     1,     0,     5,
       1,     1,     1,     1,     1,     3,     6,     6,     6,     7,
       5,     3,     4,     1,     3,     8,     8,     8,     6,     4,
       0,     3,     0,     3,     1,     3,     2,     1,     1,     0,
       1,     1,     2,     0,     1,     1,     3,     0,     3,     0,
       3,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       2,     0,     1,     3,     1,     2,     2,     2,     1,     3,
       3,     1,     1,     3,     1,     3,     1,     3,     1,     1,
       1,     1,     4,     5,     4,     6,     1,     0,     3,     3,
       1,     1,     0,     2,     2,     2,     2,     0,     2,     0,
       3,     2,     1,     2,     2,     2,     2,     2,     0,     3,
       0,     1,     0,     3,     2,     0,     1,     2,     0,     1,
       4,     4,     5,     2,     3,     0,     1,     0,     4,     0,
       1,     1,     0,     1,     0,     2,     2,     1,     0,     1,
       1,     2,     3,     2,     0,     6,     3,     0,     0,     0,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     3,
       3,     3,     0,     3,     3,     0,     7,     0,     3,     1,
       3,     0,     3,     2,     4,     0,     3,     4,     4,     0,
       0,     0,    16,     8,     7,     0,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2,     5,     3,     3,
       3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   930,  1143,  2698,     0,     0,     0,     0,     0,  1127,
    2700,   585,    66,  1800,  1928,  1929,  1711,  1739,     2,     0,
    1143,   276,   179,     0,    78,  1741,     0,  1986,     0,     0,
    1143,     0,   487,     0,  1981,     0,     0,  1143,  1744,  1971,
     253,   179,  2700,     0,  1189,  2488,  1841,  1997,     0,     0,
       0,  1824,     0,  2564,  1789,     0,     0,  2831,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,   128,    38,    10,    57,    58,    16,
      45,    11,    12,    15,    37,    44,    33,    40,    52,  1180,
      22,    23,    30,    46,    62,    20,    59,    55,    21,  1930,
      25,    47,    42,    34,    56,    63,    35,    53,    36,    61,
      28,    49,    27,     9,    17,    50,    51,    43,    64,    31,
      60,    32,     0,   959,     0,     0,     0,     0,     0,     0,
    1037,   942,  2765,  2766,  2767,  1145,  1144,     0,  2700,  2101,
    1123,  1154,  2177,  2179,  2178,  2180,  2181,  2182,  2183,  2184,
    2185,  2118,  2186,  2187,  2189,  2188,  2190,  2191,  2192,  2119,
    2120,  2193,  2194,  2195,  2197,  2196,  2198,  2121,  2122,  2199,
    2200,  2201,  2202,  2123,  2125,  2124,  2203,  2206,  2205,  2204,
    2126,  2207,  2208,  2209,  2211,  2127,  2128,  2129,  2130,  2131,
    2210,  2132,  2212,  2133,  2213,  2214,  2215,  2216,  2217,  2218,
    2219,  2221,  2220,  2134,  2222,  2223,  2225,  2226,  2227,  2224,
    2228,  2230,  2229,  2231,  2232,  2233,  2135,  2234,  2235,  2236,
    2237,  2238,  2239,  2240,  2241,  2136,  2242,  2243,  2244,  2263,
    2137,  2245,  2248,  2247,  2246,  2249,  2250,  2251,  2253,  2252,
    2254,  2255,  2138,  2139,  2256,  2257,  2258,  2259,  2261,  2260,
    2265,  2266,  2267,  2140,  2262,  2264,  2465,  2268,  2269,  2271,
    2270,  2272,  2141,  2274,  2273,  2142,  2276,  2275,  2143,  2144,
    2277,  2278,  2279,  2099,  2280,  2100,  2281,  2284,  2285,  2282,
    2286,  2291,  2145,  2283,  2287,  2288,  2289,  2290,  2292,  2146,
    2294,  2293,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,
    2303,  2316,  2307,  2308,  2310,  2311,  2314,  2309,  2315,  2319,
    2318,  2320,  2321,  2322,  2323,  2324,  2317,  2305,  2312,  2313,
    2306,  2325,  2326,  2304,  2327,  2328,  2329,  2330,  2331,  2332,
    2333,  2334,  2335,  2336,  2337,  2339,  2338,  2340,  2341,  2342,
    2343,  2344,  2345,  2346,  2348,  2347,  2349,  2350,  2351,  2353,
    2352,  2355,  2356,  2147,  2354,  2357,  2358,  2359,  2360,  2361,
    2363,  2362,  2148,  2150,  2149,  2151,  2364,  2365,  2152,  2366,
    2368,  2367,  2369,  2370,  2371,  2373,  2372,  2374,  2375,  2153,
    2154,  2376,  2377,  2378,  2379,  2380,  2381,  2382,  2383,  2384,
    2385,  2386,  2387,  2388,  2389,  2391,  2390,  2392,  2393,  2394,
    2395,  2396,  2397,  2398,  2155,  2399,  2156,  2400,  2401,  2157,
    2402,  2158,  2403,  2404,  2405,  2406,  2407,  2159,  2408,  2409,
    2410,  2412,  2413,  2411,  2414,  2160,  2415,  2416,  2417,  2161,
    2419,  2418,  2420,  2162,  2422,  2163,  2164,  2421,  2166,  2167,
    2423,  2424,  2425,  2165,  2426,  2168,  2427,  2428,  2430,  2429,
    2431,  2432,  2433,  2169,  2434,  2170,  2435,  2436,  2437,  2438,
    2439,  2441,  2440,  2442,  2443,  2444,  2445,  2448,  2450,  2447,
    2449,  2446,  2451,  2452,  2453,  2454,  2458,  2459,  2460,  2461,
    2455,  2456,  2457,  2171,  2462,  2463,  2464,  2466,  2467,  2469,
    2468,  2172,  2173,  2470,  2471,  2176,  2472,  2473,  2474,  2478,
    2475,  2487,  2476,  2477,  2480,  2479,  2481,  2482,  2483,  2174,
    2484,  2175,  2485,  2486,   198,  2104,   181,  2105,  2117,   112,
    2555,  2554,  1081,     0,  2701,  2702,   583,   886,     0,     0,
     179,     0,   887,     0,   885,   179,   134,     0,     0,     0,
    1817,     0,  1737,  1737,  1737,  1737,     0,  1737,   179,  1737,
       0,  1740,  1737,   179,  1737,     0,    71,  1936,   277,     0,
       0,     0,     0,     0,  2098,     0,  1747,     0,     0,  1988,
    2004,     0,  2005,  1999,  2552,     0,  1214,     0,     0,     0,
       0,   179,  1146,  1089,  1798,     0,   243,   252,   254,   255,
     251,     0,  2702,  2713,  1181,  1187,  1199,     0,  1908,   255,
       0,   112,  1062,     0,   112,  1825,  1822,     0,     0,     0,
    1798,  1998,  2815,     0,     0,     0,  2811,     0,  2816,     0,
    1189,     0,     0,     1,     5,     0,     0,   582,  2767,     0,
     579,   580,  2258,  2368,  1921,  1919,  2093,     0,   933,   960,
       0,   938,     0,   936,  2110,  2109,  2108,     0,   949,   948,
     946,     0,   448,     0,  1039,     0,  2772,   940,  1100,  2699,
       0,   200,     0,     0,   113,   114,     0,  1125,  1128,     0,
       0,  2705,     0,     0,     0,   586,     0,     0,   133,     0,
       0,   583,   583,   583,  1821,  1820,  1819,     0,  1817,  2178,
    2118,  2192,     0,  2067,     0,     0,     0,  1498,     0,  2123,
       0,  2207,  2209,  2127,  2128,  2129,  2130,  2131,  2134,     0,
       0,  1227,  1227,  1227,  1224,     0,     0,     0,  2232,  2233,
    2072,     0,     0,     0,  2063,  2073,  2271,  2272,     0,  2065,
    2066,  2278,     0,     0,     0,  2293,     0,  2298,  2070,     0,
       0,  2334,  2336,     0,     0,  2340,  2341,  2342,  2343,  2047,
    1282,     0,  1224,  2062,  2069,  2360,  2055,  2369,  2374,  2375,
       0,  2384,     0,     0,  2406,     0,  2413,  2411,  2417,     0,
       0,  2438,     0,     0,  1224,  2046,  2458,  2459,  2460,  2461,
       0,  2064,  2171,  2071,     0,  2472,  1227,  1224,  1224,     0,
       0,     0,  2481,  2482,  2486,     0,     0,     0,  2737,  1281,
       0,  1460,     0,  1492,  1239,  1245,  1259,     0,  1274,  1308,
    1309,  1311,  1415,  1310,  1316,  1315,  1712,  2059,  1314,  1313,
    2060,  2061,  1307,  2083,  2104,  2082,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1904,     0,     0,  1723,  1737,
      73,     0,     0,  2613,  2628,  2629,  1227,  2625,  2630,  2252,
    2139,  2265,     0,  2627,  2619,     0,  2379,  2383,  2623,  2398,
    2401,  2617,     0,  2163,  2442,  2649,  2621,  2626,  2607,  2594,
    2608,     0,     0,  2611,  2615,  2095,  1606,  2567,  2568,     0,
      79,  1749,  1750,  1748,  1035,     0,  2828,  1989,  1990,  1991,
       0,  2008,     0,  1141,     0,     0,   497,   488,     0,  1903,
    1902,     0,  1982,  2714,     0,     0,     0,  1752,  1799,     0,
    1751,  1977,     0,  1975,  1972,  1974,   244,     0,     0,   274,
    2179,  2613,  2383,  2585,     0,  2593,     0,  2708,  2705,  2715,
    2750,  2745,  2744,  2747,  2748,  1205,  2749,  1204,  2746,  2743,
    1214,  1200,  1202,  1203,   802,     0,     0,  2508,  2509,  2348,
    2369,  2407,  2510,  2455,     0,     0,  2529,  2489,  2494,  2490,
       0,     0,  1863,     0,   802,  1886,  1916,  1864,     0,     0,
    1916,     0,  1641,  1906,  1909,     0,  2512,  1877,   883,   882,
    1889,   881,  2513,  1902,     0,  1849,  1865,     0,  1826,  1870,
     112,  2514,     0,  1905,  1888,     0,  1887,  1641,  1916,     0,
    1842,     0,     0,     0,     0,     0,   250,  1069,  1069,     0,
       0,  1061,  1063,  1064,  1069,  1069,     0,  2829,  2830,  2565,
    1035,  2054,  2052,  2053,  2102,  2812,  2051,  2050,  2820,  2822,
    2808,  2810,  2817,  1183,     0,  2719,     6,    65,   129,  1214,
    1214,  2767,   583,   581,     0,  1933,  2770,  2771,  2769,   818,
       0,  1227,  2111,  2114,  2768,  2115,   182,   947,     0,   449,
     182,     0,     0,     0,     0,     0,   450,   451,   387,     0,
    1043,  1044,  1038,  1040,  1042,   944,     0,     0,   943,  2772,
       0,     0,  1156,  1158,  1157,  1174,   202,   199,   180,    80,
    1083,  1730,  1732,     0,  1129,  2704,     0,     0,  2706,  2710,
    1280,  1279,     0,   126,   132,     0,  2600,  2604,     0,     0,
    2114,  2676,     0,   130,  2664,     0,     0,     0,     0,  1801,
    1805,  1811,  1815,  1818,     0,     0,  1611,  1329,  1611,  1611,
    1611,  1499,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1611,     0,  1367,  1339,  1340,
       0,  1368,     0,     0,     0,  2074,     0,     0,     0,  2737,
       0,     0,     0,  1465,     0,     0,     0,  2737,     0,     0,
       0,     0,     0,     0,  1494,  1496,  2082,  1611,     0,     0,
    1611,     0,     0,     0,     0,     0,  1232,  1373,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1611,  1611,     0,     0,  1611,  1381,  2076,     0,     0,
       0,  2075,     0,     0,     0,  2048,  2068,     0,  1384,  1386,
    1385,     0,  1611,  1611,     0,     0,     0,  1319,  1318,  1320,
       0,     0,     0,     0,     0,     0,  1278,  1277,  1276,  1275,
       0,     0,     0,  1283,     0,  1284,  1285,     0,  1286,  1287,
    1288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1321,     0,     0,     0,  2049,  1424,     0,  1738,  1717,  1725,
    1719,     0,  1904,  1720,  1722,  1729,   462,     0,  1726,  2116,
    2662,  1721,     0,  1713,     0,    72,     0,  1960,  1965,     0,
       0,     0,  1955,  1963,  1957,  1964,  1956,     0,     0,  1966,
     112,     0,  1958,  1962,  1961,  1937,  1940,  1947,  1938,     0,
       0,   275,   278,   280,     0,   283,  2614,  2612,  2646,  2645,
    2650,     0,  2647,  2643,  2606,  2636,  2677,  2640,     0,  2677,
    2642,  2641,  2677,  2637,  2644,  2677,     0,  2609,     0,  1607,
    1608,     0,  2566,     0,  2094,  1036,     0,     0,  1992,  1993,
       0,  1164,  2009,  2010,  2006,  1606,  2553,  2556,     0,   691,
    1215,   498,     0,     0,   509,     0,     0,    68,    69,     0,
    1148,     0,  1147,  1151,     0,  1087,  1090,     0,     0,  1755,
    1745,  1754,  1532,  1978,   112,     0,   242,   267,   262,   270,
     264,   266,   265,   271,   272,   273,   268,   263,   269,   256,
       0,     0,  2612,     0,     0,  2609,  2709,     0,  2711,  2728,
    1188,  2716,  1211,  1190,  1210,     0,  1201,   801,     0,   804,
     806,  1774,  1775,   805,   814,     0,   803,     0,     0,  2526,
       0,  2515,     0,   810,   812,   811,  2523,   809,     0,     0,
    2499,     0,     0,  1912,     0,     0,  1876,     0,   583,     0,
       0,     0,     0,     0,     0,  1843,     0,     0,   634,     0,
    1869,  1642,  1910,  1911,  1916,     0,     0,  1916,     0,  1882,
    1906,  1916,     0,  1916,  1838,     0,     0,  1830,  1835,  1831,
       0,  1837,  1836,  1839,  1827,  1828,     0,  1856,  1884,     0,
    1906,  1868,  1875,     0,  1855,  1862,     0,  1873,  1906,  1906,
       0,  1916,  1916,  1057,  1073,  1055,  1067,  1068,     0,     0,
    1060,  1059,  1823,  1535,     0,     0,  2809,  2823,  2807,  2818,
    2819,  2806,  1184,  2720,  1182,  2721,     0,     7,     4,  1214,
    1214,  1214,  2764,     0,  2752,  2759,  2760,  2763,  2762,  2761,
    2758,     0,  2751,  2754,  2755,  2757,  2756,  2772,     0,  1923,
    1924,  1925,  1926,  1927,  1922,  1920,  1934,  1935,   819,   818,
     574,   577,   576,     0,     0,  2113,     0,   939,     0,  1904,
     937,     0,     0,  1904,   398,  1904,   452,   931,  1041,   951,
       0,     0,   941,  1101,  1102,  1105,     0,     0,   486,  1174,
    1160,  1176,     0,   203,   205,     0,  1085,  1084,     0,  1082,
    1139,  1137,  1136,  1134,     0,  1135,  1133,  1124,  1130,  1131,
    2703,  2707,   584,   818,  1904,     0,     0,   131,     0,   390,
       0,     0,   888,   888,   888,  1807,  1734,  1532,  1736,  2093,
       0,     0,     0,  1813,     0,     0,  1612,  1611,     0,  1474,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,     0,
       0,     0,     0,  1305,     0,     0,     0,     0,     0,  1445,
       0,  1474,  1228,  1686,  1687,  1671,  1672,  1670,  1673,  1225,
       0,  1674,  1685,  1396,     0,     0,     0,     0,     0,     0,
    1582,  1583,  1584,  1585,  1593,  1586,  1587,  1588,  1595,  1600,
    1589,  1590,  1596,  1597,  1598,  1591,  1599,  1594,  1592,  1601,
       0,  1581,     0,  1604,  1602,  1605,  1603,     0,  1466,  1458,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1611,     0,     0,     0,  1611,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1407,     0,     0,     0,     0,     0,
    1611,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1363,     0,  2085,  2084,     0,     0,     0,   851,     0,
    1323,     0,  1322,  1544,     0,  2722,  2738,     0,  2515,  1461,
    1463,     0,  1230,  1229,  1231,  1242,  1235,  1240,  1233,  1237,
       0,  1289,  2185,  1243,     0,     0,  1271,  2737,  1620,  1272,
    1257,  1262,  1263,     0,  1260,  1261,     0,  1265,     0,  1264,
    1268,  1269,  1270,  1273,     0,     0,     0,     0,  1312,  1317,
    1493,  1214,  2086,     0,     0,   462,   465,   464,  1727,   463,
    1776,     0,  1045,     0,     0,    74,    76,  1952,  1949,  1948,
    1950,  1954,   112,  1959,  1951,     0,  1967,  2232,  2458,  2461,
     287,     0,   260,   259,   261,   284,     0,     0,  2639,     0,
    2620,     0,  2624,  2618,  2622,  2602,     0,     0,  2610,     0,
    2648,  2631,  2635,  2634,  2632,     0,  2633,  2638,  2616,  1610,
    2266,  2352,     0,  1613,  2570,  1742,  2827,  1994,  2472,  1995,
    1987,     0,  2007,     0,     0,     0,  1142,   692,     0,  1214,
     496,   495,   494,   493,     0,   511,   491,   499,    70,     0,
       0,  1983,     0,     0,     0,     0,     0,  1091,  1753,     0,
       0,  1733,  1533,  1979,  1973,     0,     0,     0,     0,     0,
    2666,  2591,     0,     0,     0,  2712,  2730,  2729,  2717,  1214,
    1632,  1215,  1215,  2082,  2531,     0,  2525,  2524,     0,     0,
       0,  2544,  2527,     0,     0,  2493,  2532,  2533,  2536,     0,
       0,     0,     0,     0,  2530,  2455,  2495,  2496,     0,  2501,
    2491,  2550,  2551,  2548,  2549,  2547,  2520,  1883,     0,  1914,
    1917,  1918,     0,     0,  1897,  1891,  1890,  1880,  1892,  1881,
    1901,  1900,  1899,  1853,  1852,  1654,  1655,  2410,  1653,  1645,
    1648,  1652,  1651,  1846,  1907,  1896,  1894,  1878,  1916,  1851,
    1850,  1895,  1893,  1832,  1833,  1834,     0,  1641,     0,  1912,
    1885,  1916,  1906,     0,  1916,  1916,  1898,  1872,  1874,  1058,
    1075,  1074,  1070,  1071,  1076,  1066,  1065,  1553,  1552,     0,
    1507,     0,  1509,  1506,  1505,  1504,     0,  1552,  2813,  2821,
    2825,     0,  1641,  2727,  2725,     0,     0,     0,   583,     0,
       0,  2753,   115,   575,  1776,  1776,     0,  2112,     0,     0,
       0,     0,     0,     0,     0,   183,   192,     0,     0,   396,
     397,  1776,   395,   438,   439,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,     0,   136,   445,  1776,  1776,
     392,   418,   419,   422,   423,   424,   425,   426,   388,     0,
     393,   818,     0,   953,   955,  2773,  2774,  2775,     0,     0,
    1104,  1163,  1155,  1162,  1159,  1174,  1172,  1161,   878,   877,
       0,  1175,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,   100,  1731,     0,
    1126,  1138,  1132,   127,   818,  1776,  1776,  1776,  1776,   394,
     427,   428,   431,   432,   433,   434,   437,   435,   436,     0,
    2605,     0,     0,  1904,     0,  2668,  2669,     0,  2665,   889,
       0,     0,     0,     0,     0,  1802,     0,  2096,  1812,  1535,
    1816,  1815,     0,  1392,     0,  1438,     0,  1440,  1441,  1442,
       0,     0,     0,     0,     0,  1393,     0,  1337,  1394,  1395,
       0,  1389,     0,  1390,     0,     0,     0,     0,     0,     0,
       0,  1444,     0,  1226,     0,     0,  1341,  1342,  1334,  1326,
       0,  1417,     0,     0,  1343,     0,     0,     0,     0,  1398,
       0,  1418,  1495,     0,  1497,  2086,     0,  1450,  1399,  1348,
       0,  1448,     0,  1349,  1419,  1420,  1421,  1401,  1402,     0,
    1423,     0,  1403,     0,     0,  1406,     0,     0,  1351,  1454,
    1452,     0,     0,     0,     0,  1456,  1353,     0,     0,     0,
    1352,     0,     0,     0,     0,     0,     0,     0,  1355,     0,
    1335,  1453,  1455,  1409,     0,     0,     0,     0,     0,  1364,
       0,  2731,  1543,  2739,  1544,     0,     0,  2733,  2723,  2728,
    2736,  1327,     0,     0,  2087,  1236,  1241,  1234,  1238,  2737,
       0,     0,     0,     0,  1255,  1254,     0,     0,     0,  2737,
    1620,  1258,     0,     0,  1434,  1435,  1490,     0,  1718,  1715,
    1728,  1777,     0,  2663,  1047,  1046,  1724,  1045,    77,     0,
    1953,  1946,  1968,  1941,     0,   279,   288,   281,   285,   286,
     282,  2681,     0,  2680,     0,     0,  2599,  2658,  2661,  2093,
       0,     0,     0,  2580,  2574,  2581,  2583,  2577,  2582,  2584,
    2575,  2576,  2571,  2578,  1614,  1643,     0,  1996,  1165,  1167,
    1168,  1166,  1174,     0,     0,  2559,  2560,  2558,  2557,   501,
       0,   510,     0,   522,     0,     0,     0,  1985,  1984,     0,
    1149,  1152,  1153,  1098,  1096,  1095,  1097,  1086,  1092,  1093,
     567,  1759,     0,     0,     0,  1765,  1746,  1756,     0,  1980,
    1976,     0,   257,  2592,     0,     0,     0,     0,     0,     0,
       0,  1209,  1535,  1704,  1206,  1194,  1643,  1633,  1193,  1216,
    1212,     0,   817,   816,   815,   813,     0,     0,     0,     0,
    2538,  2539,     0,     0,  2516,  2517,  2518,     0,  2521,  2498,
    2499,     0,  2500,     0,  1913,     0,  1857,     0,  1879,     0,
       0,     0,     0,  1848,     0,  1871,  1829,  1914,  1847,  1613,
    1906,  1844,  1845,  1073,     0,  1056,  1552,  1535,     0,     0,
    1527,  1554,     0,  1554,  1529,  1530,  1535,     0,  1535,  1532,
    1549,     0,     0,  2824,  1634,  2726,     0,  2801,     0,     0,
       0,   181,   587,     0,     0,   935,   186,   189,   187,     0,
     188,     0,     0,   447,   446,     0,  1904,   440,   140,   139,
     141,   142,  1668,  1669,  1665,  1666,  1664,  1667,   144,   143,
     138,   950,     0,     0,     0,  1904,   420,   399,   400,   403,
     404,   405,  1033,  1776,  1033,     0,  1776,  1776,  1033,  1776,
       0,     0,  1776,  1776,     0,     0,  1776,     0,     0,  1033,
       0,  1776,     0,  1020,     0,     0,  1776,  1776,  1776,  1776,
    1776,  1033,     0,     0,  1776,  1776,   486,  1776,     0,     0,
    1051,     0,     0,  1776,  1776,  1776,  1776,     0,     0,  1776,
    1776,     0,  1776,   967,  1019,   589,   616,   617,   932,   966,
     968,   980,   482,     0,   998,  1022,  1023,  1021,     0,     0,
       0,     0,   150,  2777,  1103,     0,     0,  1573,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,  1904,   429,  2601,     0,
       0,  1776,   389,   406,   407,   410,   411,   412,   413,   414,
     417,   415,   416,     0,  2672,  2674,     0,     0,   890,     0,
       0,     0,  1735,  1815,  1535,  1613,  2094,  1613,     0,  1814,
       0,     0,  1439,  1475,     0,  1501,     0,  1331,   775,   775,
     775,  1484,   760,  1488,  1479,   775,  1480,   775,  1482,     0,
       0,     0,  1291,  1306,     0,     0,     0,     0,     0,  1446,
    1443,     0,     0,     0,     0,  1469,     0,     0,     0,  1336,
       0,  1429,  1451,  1449,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1457,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     840,   846,   849,   850,   852,   844,     0,  1411,  1324,  1214,
    2740,  2742,  1185,     0,  2732,  2734,   926,  1462,     0,  1252,
    1248,     0,  1246,  1619,  1267,  1266,     0,     0,     0,  1256,
    1215,  1425,  1214,     0,  1491,  2088,  1716,   461,   633,  1714,
      75,  1944,     0,  1939,  1942,     0,     0,  2678,     0,  2689,
       0,     0,     0,     0,     0,     0,     0,     0,  2569,  1644,
    1786,     0,  1174,  1178,  2103,  2000,  2562,  2563,  2561,     0,
     502,   503,   505,  1215,   519,   497,     0,   489,   492,     0,
     501,     0,     0,  1088,  1094,  1199,     0,  1778,  1763,  1770,
    1764,     0,     0,     0,  1762,  2078,  2077,  2084,  2715,     0,
    1579,     0,     0,  2590,  2667,     0,     0,     0,  2718,  1613,
    1613,  1698,     0,     0,  1191,  1196,  1192,  1195,     0,  1213,
    1220,  1219,  2079,  2086,  2528,     0,     0,     0,     0,  2543,
    2537,  2534,  2535,     0,  2497,  2519,  2503,  2502,  2505,  2507,
    1678,  1679,  1677,  1675,  1676,  1915,  1641,  1867,  1866,  1656,
    1647,     0,  1650,  1649,  1840,  1859,  1861,  1916,  1072,     0,
    1079,  1077,     0,  2722,  1547,     0,  1531,  1528,  1555,     0,
    1554,  1554,  1535,     0,  1511,  1790,  1793,     0,  1510,  1606,
    1537,  1199,  2814,  2826,     0,     0,     0,   383,   382,     0,
     145,  2795,     0,     0,   671,   116,   473,   482,   588,   591,
     632,   631,   191,   190,   196,   197,  1682,  1683,  1680,  1681,
     453,   466,  1684,   467,   441,   137,   454,   455,   421,     0,
     401,  1034,   923,   583,  1002,     0,   672,   583,   874,   879,
     879,   583,     0,     0,  1143,     0,     0,  1737,     0,     0,
    1143,     0,     0,     0,  1776,     0,  1013,   962,     0,  1737,
       0,  1737,  1737,  1014,     0,     0,   963,  1776,     0,     0,
       0,     0,     0,  1737,  1143,     0,     0,     0,   484,     0,
    1143,   982,  1054,  1053,  1052,     0,  1143,  1143,     0,     0,
       0,     0,   622,   623,   621,     0,     0,     0,   614,   590,
     818,   964,   483,   965,   671,     0,  1048,   668,   674,  2089,
       0,     0,   160,     0,     0,   952,     0,   153,   151,   162,
       0,     0,  1107,     0,  1106,     0,  1576,     0,  1577,  1574,
    1575,   101,    88,    84,   105,   106,    86,    87,    91,    90,
      92,    93,    96,    97,    94,    89,    95,    85,   109,   111,
     110,    98,   107,   108,    83,   460,   459,   458,   457,   430,
       0,     0,     0,  1904,   408,  2673,  2671,  2670,     0,   916,
     918,   917,   904,   903,   117,   120,   123,     0,  1613,  1632,
    2097,  1806,     0,  1365,  1502,     0,     0,   776,  1476,   826,
    1486,     0,  1487,   762,   761,   777,  1478,  1481,  1485,  1483,
    1330,  1338,  1387,     0,  1304,  1388,     0,  1416,  1333,  1332,
       0,     0,     0,  1371,  1372,     0,  1467,     0,     0,  1345,
       0,  1347,     0,     0,  1431,  1400,  1422,  1374,  1404,     0,
    1350,  1325,     0,  1375,     0,  1380,  1378,     0,  1354,     0,
       0,  1361,     0,  1359,     0,  1360,     0,  1362,  1408,  1410,
       0,     0,   851,   837,   838,   839,     0,   841,   843,   845,
       0,     0,  1545,  2741,  1186,     0,     0,  1464,  1244,     0,
    1253,  1250,     0,  1247,  1216,  1436,  1426,     0,     0,   296,
     291,   299,   293,   295,   294,   300,   301,   302,   303,   297,
     292,   298,   290,   289,  2679,     0,  2598,  2603,  2660,  2659,
    2682,  2682,  2682,     0,  1615,     0,  1743,  1169,  1174,  1178,
       0,  1170,  2011,   506,     0,     0,     0,   526,     0,   524,
     500,     0,  1150,  1099,  1214,  1760,  1772,     0,  1780,     0,
       0,  1757,  1767,     0,     0,     0,  1766,   486,     0,   258,
       0,  2587,  2588,  2586,  1643,  1621,     0,     0,  1710,     0,
    1705,  1207,     0,  1218,  1217,     0,  2546,  2545,  2541,  2540,
    2542,  2522,     0,     0,  1858,  1646,  1641,  1854,     0,     0,
    2728,  1606,  1539,  1535,  1508,  1535,     0,     0,  1516,  1535,
    1512,  1514,     0,  1613,     0,  1571,  1214,  2081,  1635,  1638,
       0,  2802,   386,   384,   385,     0,     0,   206,   649,   650,
     648,   647,     0,   474,     0,     0,     0,   651,   652,   654,
     655,  2011,   481,   818,   592,   402,   673,   924,  1143,     0,
       0,     0,   879,   667,   583,   923,   888,   880,   583,   583,
    1000,  1029,  1030,     0,     0,   600,   597,     0,   609,   983,
     974,   984,   995,   997,     0,   599,   624,     0,     0,   612,
    1737,     0,  1011,     0,     0,   594,     0,     0,   643,   644,
     642,   618,   625,  1031,  1032,   595,   596,     0,     0,  1628,
    1630,  1638,   602,   601,  1689,  1688,   611,     0,   598,     0,
    1017,   990,     0,   640,   638,   635,   637,   636,   641,   639,
     613,   604,   603,   606,   605,   608,   607,   610,   626,   979,
       0,  1033,  1033,   999,     0,  2092,     0,  1050,  1001,     0,
     656,   669,   657,     0,     0,   630,   629,   627,   628,   161,
     149,     0,     0,   954,   956,     0,     0,   957,  2779,     0,
    2781,  1109,  1110,     0,     0,  1177,     0,     0,   102,   104,
       0,   391,   456,   409,  2675,     0,     0,     0,  1815,  1808,
    1657,     0,  1503,     0,     0,     0,     0,   820,   831,   829,
     823,     0,   827,   828,  1477,     0,     0,   778,  1489,   742,
     775,  1301,   760,  1295,  1297,  1293,     0,   743,  1296,   775,
       0,   826,  1300,  1292,     0,  1447,     0,     0,  1470,     0,
       0,     0,     0,     0,     0,     0,  1328,     0,  1427,     0,
       0,     0,     0,     0,     0,  1358,  1356,  1357,   835,  1413,
       0,   848,   842,   840,   847,     0,  1643,  2722,   927,  1249,
       0,  1437,  1945,  1969,     0,     0,  2687,  2687,  2687,  1785,
    1784,     0,  1783,  1787,  1171,  1179,  2013,  2012,     0,   504,
     507,     0,   499,     0,   523,     0,   490,   568,     0,     0,
       0,  1781,  1769,  2719,  1758,  1761,  2086,  1534,  1580,  2589,
    1198,     0,  1616,  1709,  1706,     0,  1699,  1701,  1703,     0,
    2080,  2504,  2506,  1860,  1078,  1080,  1540,  1538,  1548,     0,
    1504,  1535,  1535,     0,  1504,     0,     0,  1792,  1632,  1794,
    1536,  1568,  1550,     0,  1639,  1640,  1637,     0,   217,  1214,
       0,     0,   207,   209,   210,     0,     0,   471,   468,   671,
     470,   570,   593,   985,     0,   583,   875,   876,   888,   925,
       0,   888,   888,     0,     0,   973,  1004,  1129,     0,   978,
     814,   619,     0,   969,  1012,  1045,     0,   620,  1006,   971,
       0,  1631,   485,   970,   992,   976,  1967,  1003,  1049,   856,
     756,   705,   696,   775,   699,   698,   775,   710,   760,   758,
     728,   760,   760,   735,   734,   752,   738,   718,   826,   826,
     717,   755,   826,   739,   737,   741,     0,   743,   760,   748,
     736,   740,   757,   733,   730,   754,   775,   775,   775,   714,
     753,   826,     0,   746,   775,   675,   779,   716,   826,   833,
       0,     0,   775,   777,  2091,   147,   152,   163,   164,   945,
    2778,     0,  2776,     0,  1115,     0,  1173,  1578,    99,     0,
       0,     0,     0,     0,     0,  1803,  1366,   773,   771,   774,
     772,   822,   821,   825,     0,   824,   833,     0,     0,  1303,
    1298,   744,  1302,  1294,  1299,  1391,  1369,  1370,     0,  1468,
    1459,  1397,     0,  1346,  1428,     0,     0,  1405,  1376,  1379,
    1377,  1382,  1383,     0,  1412,     0,  1206,  1206,   645,  2735,
    1251,     0,  1943,  2690,     0,     0,  2686,  2684,     0,  2685,
    2683,  2651,     0,  2596,  2597,  2595,  2579,     0,     0,     0,
    1214,   512,     0,   529,   528,   525,  1643,  1771,  1773,  1779,
    1768,     0,  1617,  1632,   807,  1702,     0,  1208,     0,  1517,
       0,  1521,  1526,  1522,     0,  1513,     0,  1657,  1572,     0,
    1643,  1638,     0,   220,   218,   219,     0,   213,   215,   210,
    2789,     0,  2796,     0,     0,  2794,   475,  2719,   587,   653,
     571,     0,   987,     0,     0,     0,     0,     0,     0,  1016,
       0,     0,   975,   996,  1018,  1010,  1009,     0,     0,  1143,
    1629,   991,   993,  1091,     0,     0,   860,   704,   697,   715,
     713,   764,   759,     0,   764,   764,   724,   742,   719,     0,
     826,   732,   723,   744,   747,   749,   751,   764,     0,   826,
     712,   711,   721,   708,   764,   787,     0,     0,     0,     0,
     783,     0,   854,     0,   790,     0,   676,   780,   782,     0,
       0,     0,   745,   826,   701,   834,   833,   703,   826,   833,
     764,   764,     0,   154,   958,   323,  2780,  1189,     0,  2785,
       0,  1116,  1112,  1113,  1108,   103,   135,     0,  1638,   921,
       0,     0,  2410,  1658,  1809,   832,   830,     0,  1471,  1638,
       0,  1430,  1432,   836,     0,  1546,   646,     0,  2657,  2656,
    2655,  2652,     0,     0,     0,     0,     0,     0,  2688,  2692,
    1782,     0,     0,     0,   520,     0,     0,   554,   569,  1625,
    1638,     0,  1643,     0,  1707,  1700,  1541,     0,     0,     0,
       0,     0,  1791,  1560,  1561,     0,     0,  1566,  1570,  1551,
    1636,  2793,  2803,   217,     0,     0,   158,     0,   208,   814,
     211,   472,   482,     0,   477,     0,     0,   986,   670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1015,
    2056,  1048,   486,  1007,   972,     0,   977,   615,     0,   859,
       0,   864,   768,   769,   770,   725,   765,   767,     0,   727,
     695,   720,   750,   726,     0,   722,   709,   793,   792,  1221,
     785,   800,   680,     0,     0,   791,   677,   781,   789,   784,
       0,   700,   702,   706,   707,   693,   694,  2090,     0,   156,
     349,     0,   335,   321,     0,     0,     0,   325,   165,   168,
     166,     0,   167,   173,     0,   174,   175,   176,   177,   178,
     169,   347,   348,   172,   170,   171,     0,  2106,     0,  2107,
    2783,     0,     0,  2782,  1111,     0,  1118,   891,     0,   920,
       0,   893,   895,  1659,     0,  1214,  1804,   763,     0,  1473,
    1344,  1414,  1970,  2653,  2693,  2696,  2694,  2695,  1661,     0,
    2697,  2691,     0,  1532,  1215,     0,   513,     0,   516,   518,
     532,     0,  1776,  1776,     0,     0,  1776,  1776,  1776,  1776,
     547,   555,   557,     0,  1626,  1627,     0,  1622,  1624,  1618,
    1690,   808,  2014,  2722,  1518,     0,  1523,     0,  1515,  1556,
    1556,  1567,   184,   214,     0,     0,   150,   159,  2797,   798,
    2011,     0,  2715,   989,     0,     0,     0,   658,     0,     0,
    2058,  2057,  1005,   981,  1048,     0,   857,     0,   861,   862,
     863,     0,   855,   766,     0,   928,     0,     0,   799,  1221,
     788,     0,   797,   796,   794,   795,   155,     0,   148,     0,
       0,   334,   337,     0,     0,   340,   330,   329,   331,     0,
     324,   323,   323,   377,   328,   374,   373,   366,  2719,     0,
       0,     0,  1117,  1122,     0,  1119,  1121,     0,  1776,   118,
     892,   912,   911,   897,     0,  1638,     0,     0,   121,   894,
     914,   901,   124,   896,   913,   899,  1660,  1810,  1638,  1663,
    1662,  1788,  1796,     0,  2001,     0,   521,   514,     0,     0,
     530,     0,     0,  1776,  1776,     0,     0,     0,     0,     0,
     527,   556,  1776,  1638,     0,  1197,     0,  2022,  1542,     0,
       0,     0,  1564,  1562,  2804,   216,  1214,   162,     0,   469,
     479,   478,   988,     0,   664,   891,   660,   662,  1008,     0,
     858,     0,     0,   826,     0,   826,  1222,     0,   786,  1214,
     157,   350,   361,   364,   356,   336,     0,     0,     0,   326,
     323,     0,   310,   308,   309,   315,   316,   317,   318,   319,
     320,   311,   314,   312,   313,   323,     0,   225,     0,     0,
    2784,     0,  2786,     0,  1114,     0,   906,     0,  1024,   898,
       0,   919,   922,     0,  1024,   902,  1024,   900,  1472,     0,
       0,   807,   508,   520,   517,   540,   533,   536,     0,   566,
     560,     0,     0,   562,   563,   561,   558,   551,     0,   549,
       0,  1623,  1691,     0,     0,     0,     0,  2015,  2017,     0,
    1708,  1520,  1525,     0,  1557,     0,     0,     0,   194,   193,
     185,     0,   323,  2790,     0,  2798,  2719,   666,   891,   659,
     893,   895,     0,   870,     0,   869,     0,   866,   865,   729,
     929,   731,  1223,     0,     0,     0,   323,   357,     0,   332,
       0,     0,     0,     0,   223,   380,     0,   221,   368,   368,
    2787,  2788,  1120,   905,   119,  1026,  1025,   910,   909,   907,
     908,   915,   122,   125,  1795,  1797,  2002,   515,   540,     0,
     538,     0,   534,   531,   535,   564,   565,     0,   548,     0,
     559,     0,     0,     0,     0,     0,  2016,     0,     0,  2023,
    2025,  1559,  1558,  1573,     0,   195,  2805,     0,   164,   184,
     480,   665,   661,   663,   994,   872,   873,   871,     0,     0,
     681,   358,   364,   354,   362,   323,     0,     0,   322,   341,
     376,   224,     0,   378,     0,   323,     0,   367,   369,   371,
    1028,  1027,  2028,   537,     0,   545,   541,   543,   546,   554,
     553,   550,  1214,  2020,  2021,     0,  2018,     0,     0,  2024,
       0,     0,     0,   146,  2799,     0,     0,   683,   682,   684,
       0,   355,     0,     0,   353,   333,   338,   323,     0,   323,
     236,   235,     0,   227,   304,   375,     0,   226,     0,  2014,
     539,     0,     0,   552,     0,     0,  1694,  1696,  2019,  2027,
    2026,  1565,  1563,  2791,   323,   868,   867,     0,   688,   678,
     685,   687,   359,     0,   323,     0,   323,     0,   323,     0,
       0,     0,     0,     0,   222,     0,  2022,   544,   542,  1215,
    1692,  1214,   323,  2800,   690,   689,   686,     0,   351,   323,
     339,   344,   381,     0,   230,   305,   306,     0,   233,     0,
    2030,  1697,  1695,  2792,   323,   323,   340,   343,   379,     0,
       0,   228,   229,   241,   240,   232,     0,  2029,     0,  2034,
     323,   323,   345,   249,   247,   323,   237,   245,   239,     0,
     246,   307,   234,     0,     0,  2041,     0,   231,   248,  2032,
    2033,  2031,  2036,     0,     0,  2038,  2039,     0,  2003,   238,
    2040,  2035,     0,  2042,  2044,     0,  2037,     0,  1214,  2043,
       0,  1215,  2045
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   625,  1538,    60,    61,    62,    63,    64,  1377,
      65,   840,  1295,  1845,  1846,    66,   565,    67,  1605,  2165,
    2166,  3517,  3518,  2167,   663,   664,    68,  2542,  3525,  4458,
    3526,  4464,  3527,  4466,  1623,   628,   536,  2105,  2106,  1542,
    3376,  3095,  4003,  3099,  4159,  4308,  4266,  2123,  3507,  4004,
    4005,  4168,   560,  2540,  1577,  4394,  2085,  4510,  2086,    69,
     661,  1087,  1602,  1603,  3681,  3682,  3914,  3683,  3906,  3907,
    3908,  3909,  4625,  4430,  4547,  4626,  4711,  4749,  4755,  4756,
    4672,  4765,  4766,  4767,  4753,   917,  4768,    70,   588,   589,
     919,  1409,  1860,  1410,    71,    72,   559,  1321,  1322,  1323,
    1324,  2380,  1861,  2375,  2376,  3272,  4673,  4751,  4431,  4432,
    4315,  4433,  4171,  4434,  4319,  4435,  4174,  4436,  4437,  4438,
    4439,  4617,  4440,  4314,  4665,  4427,  4428,  4667,  4731,  4747,
    4441,  4181,  4309,  4534,  4182,  4310,  4612,  4423,  4613,  4660,
    4727,  4424,  4535,  4663,  4538,  4442,  4448,  4627,  4443,  4449,
    4444,  4186,  4326,  4447,  4324,  4446,  4669,  4622,  2979,  3375,
     648,   649,   678,  2193,   650,  1104,  1057,  1579,  2118,  2119,
    2577,  2578,  2692,  2693,  2694,  2110,  2111,  2112,  2179,  2180,
    2181,  2092,  2093,  2094,  1583,  2089,  2090,   651,  1058,  1068,
    2113,  2114,  2115,  2698,  2183,  2184,  2185,  2186,  2116,  1838,
    2117,  3000,  2985,  3918,  3917,  2986,  3690,  4272,  4516,  3391,
    3392,  3082,  3457,  2136,    73,   577,   897,  1374,  2424,  1375,
    2426,  2859,  2860,  2861,  1910,  1911,  3871,  1915,  2423,  4054,
    4473,  4227,  4228,  2863,  4226,  2867,  3298,  3299,  3623,  3873,
    4057,  4478,  4369,  4573,  4476,  4569,  4477,  4571,  4682,  4636,
    4637,  4380,  4488,  4489,  4577,  4639,  4240,  4241,  4242,  2445,
    2875,  3876,  3921,  2173,  1569,  1570,   629,   630,   631,  3405,
      74,  2987,  2634,  2988,  2989,  3480,  2636,  2637,  2827,  1467,
    3470,  3441,  3846,  3382,  3386,  3387,  3388,  3389,  3390,  4405,
    4520,  4521,  4518,  3490,  3403,  3015,  3016,  3087,  3493,  3775,
    4301,  3985,  4659,  4699,  4700,  4701,    75,   894,  4089,  3953,
    3968,  3777,  3778,  3779,  3780,  3781,  3782,  3783,  3172,  3173,
    4125,  4126,  4127,  3167,  3168,  3548,  3986,  3987,  3988,  4090,
    4140,  3541,  1433,  1434,  4064,  1445,  1446,  2473,  1956,  2474,
    1573,  3542,  3543,  3544,  3997,  3231,  3843,  3237,  3238,  3239,
    2790,  2791,  2792,  2793,  2794,  2318,  3989,  3492,  3946,  4118,
    4121,  4292,  4527,  3017,  3404,  3018,  3408,   999,   537,  3019,
    3020,  2199,  2200,  4339,  4348,  4352,  4340,  4353,  4349,  4341,
    4342,  4343,  4355,  4351,  3152,  4017,  4018,  3396,  3406,  3247,
    4294,    76,   130,  2121,  1049,  1060,  1056,  1079,   656,  1589,
    2124,  2652,  3789,   638,  2638,  3939,  3707,  3943,  2639,  3420,
    2640,  3922,  4097,  2641,  3724,  3941,  4115,  3421,  3422,  2642,
    2643,  2644,  3931,  3938,  4284,  4554,  4555,  4556,  3021,  1356,
     653,   654,  1072,  1073,  1074,  2366,  3488,  3065,    77,  2044,
    2039,    78,  1011,  1012,  1013,  1513,  1514,  2042,  2043,  2515,
    2951,    79,   666,  1609,  1386,  1926,    80,   906,  2437,  2438,
    2439,  2873,    81,  1080,  1593,  1594,  2130,  3104,  3513,  3794,
    4014,  4196,  4010,  4334,  4335,    82,   668,  1093,    83,   523,
    1617,  1618,  1619,  2170,    84,  1368,   137,    85,   905,  1380,
    1382,  1383,    86,   660,  1081,  1082,  1083,  1084,  2132,    87,
    1901,  2408,  2409,  2410,  2411,  1599,  2656,  1600,  1601,  2141,
    3291,    88,    89,   622,  2326,   594,   929,   595,   596,  1950,
    2464,  3847,   940,   941,   942,  2904,  1423,  1424,  1425,  1907,
    2909,  4298,  1151,  1147,   803,   804,   805,   806,  1241,  1242,
    3990,   807,  1251,  1804,  3184,  3563,  1663,  1664,   808,   809,
     810,   811,   812,   813,  1831,  3203,  3204,  3578,  2353,  2354,
    2355,   814,  2240,  3190,  2253,   815,  1234,  1789,  1719,  3570,
    3196,  3828,  4028,  1648,  2216,  2739,  3175,  2823,  2320,  1173,
    1174,  1132,  2223,  1654,  2050,  2051,  2052,  2053,  2054,  3665,
    3666,  4067,  3890,  4069,  3894,  2525,  2526,  1931,  1932,  2055,
    2056,  2952,  3888,  4253,  2321,  2322,  2323,  3596,  2953,  3353,
    2970,  2971,  3900,  2516,  2057,  2959,  4392,  4076,  4077,  4507,
    4506,  4078,  3898,  3899,  3670,  3671,  3107,  3108,  3109,  2889,
    1710,  1711,  1717,  1351,  1352,  1649,  2405,  2847,  3883,  4061,
    2344,  3642,  4059,  4247,  2647,  3449,  3450,  2466,  2467,  2974,
    3368,  3676,  1470,  3848,  2849,  2009,  2939,  2940,  3805,  4220,
    4754,  2795,  2935,  3001,  1681,  1682,  3456,  4385,  4581,  4685,
    4686,  4687,  3328,  3329,  3646,  3647,  2468,  2901,  3330,  3884,
    4252,    90,   541,    91,  1843,  2826,  1292,  2372,  1091,  1389,
    1635,  1636,   827,   555,    92,   566,  2406,    93,   584,  1929,
     884,   909,  1390,  1391,  2446,  2876,  2883,  2447,  2888,  3633,
    2878,  3305,  3306,  2361,  2362,  2879,  3308,  3630,  3611,  3612,
    3286,  3868,    94,   610,  3363,  2965,  2966,  4361,  4362,   910,
      95,   540,  1119,  2715,  4024,  1641,  2204,  4206,  1120,  1121,
    2207,   687,   688,    96,  1016,   606,  1493,  1494,  1495,  2027,
      97,   598,  1000,  2936,  3346,  2003,   901,  1287,  1474,  1003,
    1475,  1989,  2496,  1456,    98,  1045,  1044,  1564,    99,   634,
    1565,   100,   841,  1315,  1856,  2833,  2834,  3257,  1316,  1317,
    2373,  3852,   101,   585,   914,   915,  1394,  2450,   102,   579,
     902,  1921,   103,   569,   889,  1360,  1900,   104,   105,   106,
     891,  3292,  4471,  4632,   573,  1903,  1364,  3691,  4387,  4497,
    4498,  4500,  4589,  4590,  4679,  4759,  4781,  4775,  4784,  4785,
    4788,  4793,  4794,   817,  1025,  1026,   818,  4109,   819,   820,
     821,  2884,  2885,  3369,   822,  2886,   823,  3088,  1092,  1638,
     563,   515,   645,  1027,  2855,   825,  4188,  1052,  1289,  1111,
    1112,   517,   518,   107,   597,   957,  1450,  1440,  1449,  1976,
    2490,  1980,  2492,  2493,  3342,  2927,  3343,  2928,  1005,  1972,
    1977,  2929,   960,  1965,  1966,  1967,  1968,  2920,  1962,  1986,
     108,   892,   522,  1366,  1367,  2417,   109,   609,   110,  1353,
    1893,  1894,  2402,  2846,  2403,   111,   923,   924,   112,   869,
    1627,  2386,  1106,  1055,  1107,  1879,   872,  1327,   873,   874,
    1342,  1336,  1345,  1339,  4042,  3860,  3861,  2390,  1291,  1113,
    1941,  2197,  3148,  1114,  1870,  2382,  2383,  3606,  3863,  3276,
    4048,  4049,   113,   138,   525,   671,  1099,  1417,   114,   115,
     116,   117,  1420,  1533,  2460,  1534,  2327,  1535,  1536,  2064,
    1948,  1785,  1786,  3245,  1231,  1232,  2330,  2799,  2800,   943,
    1038,  1552,  1544,   131,   132,   133,   134,  1077,  1078,  2653,
    3101,  3509,  3792,  3793,  4009,  4193,  1546,  4085,  4597,  4722,
    1547,  1548,  3377,  4087,  4398,  4599,  4694,  1549,  2976,  3678,
    4262,  4512,   118,  1028,   619,  1531,  1526,  1528,  2060,  2533,
     119,   120,   121
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4071
static const int yypact[] =
{
    4498,   303,  1352, -4071,   435,   776, 57844,   759,  1183, -4071,
     481,  2313, -4071, -4071, -4071, -4071, -4071,  2405, -4071, 57844,
    1352,  1055, -4071, 26011, -4071, -4071,  1211, -4071,   200,  1183,
    1352,   536, -4071, 57844, -4071,   935,  1488,  1352, -4071, -4071,
   50848, -4071,   481, 57844, -4071, -4071, -4071, -4071, 50848,   181,
     363,   654,  1288, -4071, -4071, 57844,  2316, -4071,  -183,  1487,
    1162, -4071, -4071,  1148, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071,   638, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, 26650,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071,  1448, 57844,  1506, 57844,  1581, 57844, 48940, 57844,
   -4071,  1577, -4071, -4071,  1670, -4071, -4071,  1183,   481, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  1170, -4071, -4071,   435,
   -4071, -4071, -4071,  -173, -4071,  1840,  1654, -4071,  1663,  1447,
   -4071, 48940, -4071, 57844, -4071, -4071, -4071,  1689,  1741,  1770,
      93, 12367,  1767,  1767,  1767,  1767,  1809,  1767, -4071,  1767,
   57844, -4071,  1767, -4071,  1767,  1183, -4071, -4071, -4071,  1989,
   36856, 57844,  1676,   921,  -140, 48940,  1446, 57844,   435,   804,
   -4071,  1913, -4071, -4071, -4071,  1183, -4071,  2122,  1942,  1134,
   57844, -4071, -4071, -4071,  1105,    11,  1565, -4071, -4071,  1693,
   -4071, 37492,   198, -4071, -4071, -4071,  1291, 28567,  6228,  1693,
    1710,   435,  -134,  1718,   435, -4071, -4071, 57844,   435,  1183,
    1940, -4071, -4071,   274,   274,   274, -4071,   274, -4071,   274,
   -4071,  -183,  1596, -4071, -4071,  1576, 57844, -4071,   314,  1684,
   -4071,  1692,   842,  1004, -4071, -4071,  1597,  1085, -4071,  1690,
   41308, -4071, 57844, -4071, -4071, -4071, -4071,  1893, -4071, -4071,
   -4071,  1545, -4071,  1745,  1353, 57844,  1783, -4071, -4071, -4071,
   26011,  1659, 57844,  1750, -4071, -4071, 26011, -4071, -4071, 26011,
     189,  1377,  1811, 57844, 57844, -4071, 45760,  2135, -4071,  2334,
   41308,  1654,  1654,  1654, -4071, -4071, -4071, 51484,    93,  1688,
    1694,  1696, 17631, -4071,  1712,  1714,  1725, 12367,  1734,  1736,
    1742,  1755,  1757,  1773,  1775,  1780,  1789,  1794,  1806,  1810,
    1816,  1819,  1819,  1819,  1827,  1837,  1849,  1851,  -201,  1853,
   -4071,  1855,  1861,  1878, -4071, -4071,  1882,  1894,  1901, -4071,
   -4071,  1904,  1920,  1951, 13025,  1963,  1965,  1970, -4071, 22804,
    1977,  1980,  1984,  1988,  2002,  2013,  2021,  2023,  2028, -4071,
   -4071, 12367,  1827, -4071, -4071,  2033, -4071,  2039,  2047,  2053,
    2056,  2060,  2079,  2086,  2099,  2102,  2107,  2110,  2126,  2129,
    2136,  2152,  2155,  2163,  1827, -4071,  -182,  2168,  2177,  1138,
    2180, -4071,  2192, -4071,   281,  2197,  1819,  1827,  1827,  2203,
    2207,  2209,  2212,  2252,  2263, 17631, 17631, 17631, 12367, -4071,
   57844, -4071, 57844,   875,  3653, -4071,  2539, 17631,   955, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  1716,  1835, -4071, -4071,
   -4071, -4071, -4071, -4071,  2266,  1752,  2392, 57844, 57844, 57844,
   57844, 57844, 57844, 45760, 48940,  1959, 57844, 46396, -4071,  1767,
    2000,  2858, 31757,  2302,  2276,  1604,  1819, -4071, -4071,  -105,
     709,   712,  2386, -4071, -4071,  2249,   757,  2546, -4071,   856,
     442, -4071,   211,   905,   940, -4071, -4071, -4071, -4071, -4071,
   -4071,  2359,  2560,  2288, -4071, -4071,   151, -4071, -4071, 57844,
   -4071, -4071, -4071, -4071,  2716,  2441, -4071, -4071, -4071,   145,
    2908,   205, 26011, -4071,  2300, 12367,  1587, -4071,  -209, -4071,
   -4071,  2674, -4071, -4071, 46396, 26011,  1371, -4071, -4071, 23445,
   -4071, -4071,  2928, -4071,  2327, -4071, -4071,  1835,  3429, -4071,
    2603,  2302,  2612, -4071,  2793, -4071,  2621,  2527,  1377,  2425,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    2376,  1291, -4071, -4071,   234,  2534,  2369,   354,   569, 40672,
      65, 48940,   788,    31, 29205, 41944,  2371, -4071, -4071, -4071,
      88,  2530, -4071,  2869, -4071, -4071,   -56, -4071,  2389,  1759,
     -56, 47032,  2768,   178, -4071,   384, -4071,  2853, -4071, -4071,
   -4071, -4071, -4071,  2531,  2499,  2568, -4071,   388,  2262, -4071,
     435, -4071,   903, -4071, -4071,  2558, -4071,  2768,   -56,   178,
   -4071,  2807,  2934,   629,  2903,  1081, -4071, -4071, -4071,  -108,
    3015, -4071,  2453, -4071, -4071, -4071, 26011, -4071, -4071, -4071,
    2716, -4071, -4071, -4071, -4071,  2457, -4071, -4071,  2739,  2576,
   -4071, -4071,   915, -4071,  2463,   870,  2965, -4071, -4071,   294,
    1139,  1670,  1654, -4071,  1143, 42580, -4071, -4071, -4071,  2996,
    3013,  1819,  2475, -4071, -4071, -4071, -4071, -4071,  3128, -4071,
   -4071,  2485,  3023,  3023,  3023,  3144, -4071, -4071, -4071, 26011,
   -4071, -4071, -4071,  1353, -4071, -4071,  2664,  2535, -4071,  1783,
   26011,  2900,  2504, -4071, -4071,  2761, 12367, -4071, -4071, -4071,
     546, -4071, -4071, 26011,  1032, -4071,  3106,  2718, -4071, -4071,
   -4071, -4071,  2991, -4071, -4071,  3128,  -230, -4071,  3052,  3023,
    2941, -4071,  2945,  2525, -4071, 57844, 57844, 57844, 26011, -4071,
    2536, -4071,  2532, -4071, 12367, 12367,   358,  3122,  3186,  3186,
    3186,   875,  2572, 12367, 12367, 12367, 12367, 12367, 12367, 12367,
   12367, 12367, 12367, 12367, 12367,  1035,  2547, -4071, -4071, -4071,
    1948, -4071,  2551, 12367, 12367, -4071, 12367, 12367, 27289, -4071,
    4071, 12367,   369,  3062, 12367, 12367, 12367, 12367,  3717, 12367,
   12367, 12367, 27289,  3199,  2554, -4071,  2549,  1160, 12367, 12367,
    1520, 12367, 12367, 12367, 12367, 12367, -4071, -4071, 12367, 12367,
   12367, 12367, 17631, 12367, 12367, 12367, 12367, 12367, 12367,  2557,
   12367,  3186,  3186, 12367, 12367,  1641, -4071, -4071, 12367,  1264,
    1264, -4071, 12367,  9077, 12367, -4071, -4071,  2561, -4071, -4071,
   -4071, 27289,  3186,  3186, 12367, 12367, 12367,  3122,  3122,  3122,
     208,  2562,  -141, 12367, 29843,  2556, -4071, -4071, -4071, -4071,
   12367, 12367, 12367, -4071, 17631, -4071, -4071,  2092, -4071, -4071,
   -4071, 13683, 17631, 17631,  2565, 17631, 17631, 17631, 17631, 17631,
    2946, 17631, 17631, 18289, 18947, 17631, 17631, 17631, 17631,  1024,
    3122, 48940, 17631, 12367, -4071, -4071, 57844, -4071, -4071, -4071,
    2559,  2851,  1959, -4071,  2573, -4071,   749,  3067, -4071, -4071,
   -4071,  2580, 26011, -4071,  2571, -4071,  2958, -4071, -4071,  2959,
    2961,  2963, -4071, -4071, -4071, -4071, -4071,  3201,  2966, -4071,
     435,  2967, -4071, -4071, -4071, -4071,  2597, -4071, -4071, 19605,
   48940, -4071,  2600, -4071,  3093, -4071, -4071, -4071, -4071, -4071,
   -4071,  2709, -4071, -4071, -4071, -4071,  2619, -4071, 46396,  2619,
   -4071, -4071,  2619, -4071, -4071,  2619, 41308,   843,  3837, -4071,
   -4071, 57844, -4071, 58480, -4071, -4071, 23445,   435, -4071,  3042,
   14341, -4071, -4071, -4071,  2994,   163,  2622, -4071, 26011, -4071,
     875, -4071,    97,    97,  2872,   171, 48940, -4071, -4071,   182,
    2623,  2708,  2628, -4071,  2711, -4071, -4071, 26011, 26011, -4071,
   -4071, -4071,  2886, -4071,   435,    11, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  2636,
    3123,  3096,  2643, 46396, 41308,  1117, -4071, 57844, -4071,  1673,
   -4071, -4071, -4071,  2645, -4071, 12367, -4071, -4071, 57844, -4071,
   -4071, -4071, -4071, -4071,  3229, 12367, -4071, 46396,  1430, -4071,
      47,  1285,    88, -4071, -4071, -4071, -4071, -4071, 57844, 52120,
    2647,  9735,  2769,  3057,   435, 12367, -4071,  2656,  1654, 57844,
   57844, 57844, 26011, 57844, 26011, -4071,   844,   844, -4071, 43216,
   -4071, -4071, -4071, -4071,   -56, 57844, 57844,   -56, 41308, -4071,
     178,   925, 57844,   -56, -4071,  3059,  2772, -4071, -4071, -4071,
    3133, -4071, -4071,  3129,  2669, -4071,  3155, -4071, -4071,  2796,
     178, -4071, -4071, 26011, -4071, -4071,   178, -4071,   178,   178,
   12367,   -56,   -56, -4071,   -82, -4071, -4071, -4071,  2823,  -134,
   -4071, -4071, -4071,  1250,   274,  2927, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  1316, -4071, -4071, -4071,
   -4071, -4071, -4071,   221, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071,  1608, -4071, -4071, -4071, -4071, -4071,  1783, 26011, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,    87,
   -4071, -4071, -4071,  2030,  3193, -4071, 48940,  2949,  -137,     2,
    2949,  2248,   435,   688, -4071,   688, -4071, -4071, -4071,  2970,
     199, 26011, -4071,  2688, -4071,  2944, 52756, 26011, -4071, -4071,
   -4071,  1584,  2700,  2695,   875,  4194, -4071, -4071, 26011, -4071,
     223, -4071, -4071, -4071,  2754, -4071, -4071, -4071, -4071,  2066,
   -4071, -4071, -4071,   191,  2144,  3351, 45760, -4071,  2724,  2752,
     184, 41308, -4071, -4071, -4071,  2705, -4071,  2886, -4071,  -219,
   57844,  3164, 34305, -4071,   330,   378, -4071,  3186,  2713, -4071,
    2714,  2715,  2719, 12367,   232,   386,   680,  1440,  1546,   909,
     350,  1037,   374, -4071,  1573,   451,   547,   549,   235, -4071,
    2720,  2717, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    2721, -4071, -4071, -4071,   553,   690,  1229,  1242,  2726,  2728,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    3165, -4071,  1589, -4071, -4071, -4071, -4071,  2731, -4071, -4071,
    1284,   708,   732,   222,  2736,  1600,   736,  1633,  1644,  2734,
   27289, 57844,  3186,  2740,  1308,  1320,  3186,  2741,   790,  1324,
    1665,  1681,  1691,  1341,  1379,   867,  1768,  2855,  1400,   887,
     892,  1407,   965,   977, -4071,  1416,  2743,  2745,  1023,   262,
    3186,  2746,   266,  2735,  2738,  1418, 10393, 11051, 11709,   217,
    1043, -4071,  2747, -4071,  2549,  2748,  2749,   304,   161,  1492,
   -4071, 12367, -4071, -4071,   685,  1414,  2810,   147,  1285, -4071,
    2914, 57844,  2461,   158, -4071, -4071, -4071, -4071, -4071, -4071,
     919, -4071,  2759, -4071,  2760,  2096,  2765, 12367,  1327,  2765,
    2921,  2618,  2618, 17631,  3515,  2473, 13025,  1202, 13025,  1202,
    2765,  2765,  2765, -4071, 17631,  2766, 17631, 17631, -4071,  3122,
     875,  2767,  -243, 57844, 26011,   749, -4071, -4071, -4071, -4071,
      88, 46396,   153, 26011, 48940,  2775, -4071, -4071, -4071, -4071,
   -4071, -4071,   435, -4071, -4071,  3094, 26011,  2860,  2875,  2876,
   -4071, 32395, -4071, -4071, -4071, -4071, 32395,   -34, -4071, 57844,
   -4071,  2861, -4071, -4071, -4071,  1258, 24084, 24084, -4071, 24084,
   -4071, -4071, -4071, -4071, -4071,   442, -4071, -4071, -4071, -4071,
     745,   746,  3177,  2804, -4071, -4071, -4071, -4071, 33669,   875,
   -4071, 26011, -4071,  3203,  1017, 26011,  2798, -4071,  2792, -4071,
   -4071, -4071, -4071, -4071,  1845,  2906, -4071,  3437, -4071, 12367,
     435, -4071, 46396, 46396, 26011, 26011, 26011,   677, -4071,  2295,
    2803, -4071, -4071,  3445, -4071,  3429, 19605, 45760,  3248,  3262,
   -4071,  2806, 24084, 24084, 24084, -4071, -4071, -4071, -4071, -4071,
    1342,   875, -4071,  2801, -4071, 47668, -4071,   875,    88,  2811,
    2812, -4071, -4071,  3194,  -104, -4071,  2813,  2814, -4071,  2805,
    2809,  2815, 53392, 12367, -4071,    47, -4071, -4071,    88, -4071,
   -4071, -4071, 17631,  1855, -4071,   875, -4071, -4071,   435,  3274,
   -4071,   875,  2821, 57844, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071,  3302, -4071,  3004,
     671, -4071, -4071, -4071, -4071, -4071, -4071, -4071,   -56, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  3054,  2768,  2262,  3057,
   -4071,   -56,   178, 26011,   -56,   -56,   875, -4071, -4071, -4071,
   -4071, -4071,  2828, -4071,  2881, -4071, -4071, -4071, -4071, 57844,
    2175,  2995, -4071,  2834, -4071, -4071, 26011, -4071,  2835, -4071,
    3295,  3448,  2768, -4071, -4071,  3296, 57844, 57844,  1654, 57844,
   57844, -4071, -4071, -4071,    88,    88,  3147, -4071,   435,  2982,
    2983,  2987,  2988,  2989,  3031, -4071, -4071,   435,   435, -4071,
   -4071,    88, -4071,  1711, -4071, -4071, -4071, -4071,   435,   435,
     435,   435,  2620,   435,   435,  1830, -4071, -4071,    88,    88,
   -4071,   144, -4071, -4071, -4071, -4071, -4071, -4071, -4071,   275,
   -4071,  3735,   131, -4071,  3068, -4071, -4071, -4071, 26011,  3320,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    2865, -4071, -4071, 12367,  3356,  3360,  3361,  3362,  3363,  3365,
    3366,  3367,  3371,  3373,  3374,  3377,  3378,  3379,  3380,  3381,
    3384,  3385,  3386,  3389,  3390,  2901, -4071, -4071, -4071,  2957,
   -4071, -4071, -4071, -4071,   210,    88,    88,    88,    88, -4071,
    2044, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, 41308,
   -4071, 48940,  3277,  2048,  1156, -4071, -4071, 48940, -4071,  1509,
    3197,  3198,  3200, 57844,  2971, -4071, 34305, -4071, -4071,  1250,
   -4071,  2923, 14999, -4071,  2931, -4071, 12367, -4071, -4071, -4071,
    1628, 12367, 12367,  3427,  2826, -4071, 48304, -4071, -4071, -4071,
   12367, -4071, 12367, -4071, 12367, 12367, 12367, 12367, 48304,  2826,
   12367, -4071,  2935, -4071,  3343,  3346, -4071, -4071, -4071, -4071,
   12367, -4071, 12367, 12367, -4071, 12367, 12367, 12367, 12367, -4071,
   12367, -4071, -4071, 17631, -4071,  2938,  2947, -4071, -4071, -4071,
    2948, -4071, 12367, -4071, -4071, -4071, -4071, -4071, -4071, 12367,
   -4071, 12367, -4071, 12367, 12367, -4071, 12367, 12367, -4071, -4071,
   -4071, 15657, 12367, 12367,  2950, -4071, -4071, 12367, 12367, 12367,
   -4071, 12367,   332, 12367,  1626, 12367,  2036, 12367, -4071, 12367,
   -4071, -4071, -4071, -4071, 12367,   371,  1845,  2620,  2951, -4071,
    1863, -4071, -4071,  1164, -4071,   685,  2952, -4071, -4071,  1673,
   -4071, -4071, 48940, 12367, -4071, -4071, -4071, -4071, -4071, -4071,
   17631,   356,  2955, 17631, -4071,  2921,  3717,  3717,  2149, 12367,
    1327,  2921, 12367,  2956,  2940, -4071, 12367, 57844, -4071, -4071,
   -4071, -4071, 48940, -4071, -4071, -4071, -4071,   153, -4071,  2571,
   -4071, -4071,  2798,   319,  3449,  2960, -4071, -4071, -4071, -4071,
   -4071, -4071,  1885, -4071, 41308,  3607, -4071,  2964, -4071,  2968,
    3044,  3045,  3050, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071,  2768,  2295, -4071, -4071,  2972,
   -4071, -4071,  2761,  3063,  2999,  3348,  3543, -4071, -4071, 57844,
   17631, -4071,  3587,  2986,  2992,  3471,  2993,   875, -4071,  3070,
   -4071, -4071, -4071,    22, -4071, -4071, -4071, -4071, -4071,   877,
   -4071, -4071,  2998,  2998, 21524, -4071, -4071, -4071, 57844, -4071,
   -4071,  3476, -4071, -4071,  3259, 46396, 41308,  3456,  3458,  3459,
     976, -4071,   702, -4071,   172,  3398,  2768, -4071,  3462, 49576,
   -4071, 34941, -4071, -4071, -4071, -4071,  1430,  3100,  3101,  1424,
   -4071, -4071,  3409,  3237, -4071, -4071, -4071,    88,   875, -4071,
    2647,  9735,  3014, 30481, -4071,  1256, -4071,   295, -4071, 43852,
    3495, 43852, 43852, -4071,  3301, -4071, -4071,  3274, -4071,  2804,
     178, -4071, -4071,   -82,  2154, -4071, -4071,  1051,  3419,  3425,
   -4071,  3297,  2115,  3297, -4071, -4071,  1051, 27289,  1250,  2886,
   -4071,  2620,  3352, -4071, -4071, -4071, 57844, -4071,  1723, 57844,
    3034,  -179,  4989, 47668, 44488, -4071, -4071, -4071, -4071,  3571,
   -4071,  3576,  1141, -4071, -4071,  1551,     2, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071,  2248,  1551,  1551,   688, -4071,   141, -4071, -4071,
   -4071, -4071,  2742,    88,  3614,  3300,    88,    88,  3614,    88,
    3303,  3304,    88,    88,  3132,  3556,    88,  3450,  3153,  2905,
    3452,    88,  3315, -4071,  3166,  3577,    88,    88,    88,    88,
      88,  3614,  3324,  3678,    88,    88, -4071,    88,  3327,  3326,
     177,  3329,  3330,    88,    88,    88,    88,   152, 57844,    88,
      88,  3331,    88, -4071, -4071,  6711, -4071, -4071, -4071, -4071,
   -4071, -4071,  1267, 24729, -4071, -4071, -4071, -4071,    88,  1261,
    1588,  3158,  1976,  3082, -4071,   347,  3083, 54028,   875,  3084,
    2620,   435,   435,  1256,   435,  2620,   435,   435,   435,   435,
     435,   435,   435,  2620,  2620,   435,   896,  1923,   435,  2620,
    4194, -4071,   435,  1845,  1551,  1551,  2144, -4071, -4071,  3357,
    3526,    88, -4071,  1708, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071,  3179, -4071,   169,   995,   995, -4071, 26011,
   26011, 26011, -4071,  3086,  1250,  2804,  1442,  2804,  3095, -4071,
   13025,  1556, -4071,   875, 12367,   875,  2072, -4071,  3091,  3091,
    3091, -4071,  3092, -4071, -4071,  3091,  3499,  3091,  3501,  3098,
    3099,  1891,   863, -4071,  1907,  2082,  1566,  3108,  3110,  1716,
   -4071, 12367, 12367,  1582,  1606,  -111,  1113,  1127,   380, -4071,
    1624,  3831, -4071, -4071,  1632,  1642,  1683,  1721,  1180,  1753,
    1910, 13025,  1760,  1102,   397, -4071,  1762,  1189,  1193,  1791,
   12367,  1800, 12367,  1804, 12367,  1844,  1868,  1876,  3115,  3115,
     196, -4071,  3116, -4071, -4071, -4071,  3117, -4071, -4071,  2376,
    1164, -4071, -4071,  3119, -4071, -4071,  3109,   875,  3120, -4071,
   -4071, 12367, -4071,   955, -4071, -4071, 17631,   501,  3121, -4071,
     875, -4071, -4071,  3125,  1716, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071,  3323, -4071, -4071,  3806, 32395, -4071, 57844,  1368,
    3393,  3135, 35577, 41308, 41308, 41308,  3127, 12367, -4071, -4071,
    3410, 26011, -4071,  3554, -4071, -4071, -4071, -4071, -4071,  3136,
    3134, -4071, -4071, -4071,  2921,  3514,  3392, -4071, -4071,  1845,
   57844, 46396,  3453, -4071, -4071,  1291, 27289, -4071,  3145, -4071,
    3145,  2103,  3148,  1912, -4071, -4071, -4071,  3142,  2425,  1921,
   -4071, 19605,  3606,  2580, -4071, 41308, 41308, 41308, -4071,  2804,
    2804,   155,  3205,  3557, -4071, -4071, -4071, -4071, 54664, -4071,
   -4071, -4071, -4071,  -237, -4071,  3154,  3159,   230,  3383, -4071,
   -4071, -4071, -4071,  9735, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  2768, -4071, -4071, -4071,
   -4071, 43852, -4071, -4071, -4071, -4071, -4071,   -56, -4071,  3650,
   -4071,  3169,  1404,  1414, -4071,  1167, -4071, -4071, -4071,  3561,
    3297,  3297,  1051,  3562,   967,  3172, -4071,    88, -4071,  2686,
   -4071,  1291, -4071, -4071, 12367,  3368,  3175, -4071, -4071,   110,
   -4071, -4071,  1177, 26011, 20246, -4071, -4071,  3430, -4071,  3695,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,   275,
   -4071, -4071, 27928,  1654, -4071,   245, -4071,  1654, -4071,  1584,
    1584,  1654, 55300, 27928,  1352,  1256,  2620,  1767,  2620, 55936,
    1352,   435,   435,  2518,    88,  2620, -4071, -4071,  3570,  1767,
    3572,  1767,  1767, -4071, 48940, 57844, -4071,    88,  1214,  2620,
   56572,  1256,  1256,  1767,  1352, 27289,  2422,  2443, -4071,   435,
    1352, -4071, -4071, -4071, -4071, 26011,  1352,  1352,  2500,  2637,
    2790,  2864, -4071, -4071, -4071,  2620,  2443, 55936, -4071, -4071,
    6864, -4071, -4071, -4071, 20885, 57844,   290,   937, -4071,  3176,
   38764,  3422, -4071, 12367, 12367,  3468, 57844,  3470, -4071,  3756,
   57844,  3828, -4071,   138, -4071, 55936, -4071,  3195, -4071,  3196,
   -4071,  2620, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    3206, 57844,  1551,  2048, -4071, -4071, -4071, -4071,   435, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, 34305,  2804,  3467,
   -4071, -4071,  3717, -4071,   875, 12367,   984, -4071, -4071,   220,
   -4071,  1357, -4071, -4071, -4071,  3208, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071,  3519, -4071, -4071,  2826, -4071, -4071, -4071,
    3202,  3717,  3717, -4071, -4071,  3800,  3388, 12367, 12367, -4071,
   12367, -4071,   224,  3210,  3224, -4071, -4071, -4071, -4071, 12367,
   -4071, -4071,  3717, -4071, 12367, -4071, -4071, 12367, -4071, 12367,
   12367, -4071,  1909, -4071,  1916, -4071,  1929, -4071, -4071, -4071,
    1845,  3211,  3595, -4071, -4071, -4071,  1845,  3403, -4071, -4071,
    1845,  2620,  2645, -4071, -4071,  -141, 57844, -4071, -4071,  1935,
   -4071, -4071, 12367, -4071, 49576, -4071, -4071,  3693,  3591, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071,  3670, -4071, -4071, -4071, -4071,
    -155,  -155,  -155, 16315,   875,  3729, -4071, -4071, -4071,  3554,
    3616, -4071,    38, -4071, 57844,  3232,  1243, -4071,  1946, -4071,
   -4071,  3234, -4071, -4071,  2376,  3228, -4071,    88, 16315,  2998,
    3406, -4071, -4071,  2103, 27289, 34941, -4071, -4071, 57844, -4071,
   41308,  2806,  2806,  2806,  2768,  3681,  3063,  3063, -4071, 31119,
   -4071, -4071,  3399, -4071, -4071, 36213, -4071, -4071, -4071, -4071,
   -4071, -4071, 30481, 53392, -4071, -4071,  2768, -4071,   435,  2244,
    1673,  2953, -4071,  1250, -4071,  1051,  3636,  3638, -4071,  1051,
   -4071, -4071, 27289,  2804, 16315, -4071,  2376,   875,  3247,   344,
    1177, -4071, -4071, -4071, -4071,  3527,  3528, 57844, -4071, -4071,
   -4071, -4071,  3394, -4071, 26011,  3253,  3257,  3258, -4071, -4071,
   -4071,   251, -4071,  5230, -4071, -4071, -4071, -4071,  1352,  3261,
    3654,  3655,  1584, -4071,  1654, 27928, -4071, -4071,  1654,  1654,
   -4071, -4071, -4071,   111, 55936, -4071, -4071, 27928, -4071, -4071,
   -4071,  3260, -4071, -4071,  1845, -4071, -4071, 44488,   435, -4071,
    1767, 57844, -4071, 27928, 27928, -4071,  3282,   435, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, 27928, 55936,  3267,
   -4071,   344, -4071, -4071, -4071, -4071, -4071,  2122, -4071, 55936,
   -4071, -4071, 55936, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    3270,  2833,  2071, -4071,  3278, -4071, 57844, -4071, -4071, 26011,
   -4071, -4071, -4071,  6659, 57844, -4071, -4071, -4071, -4071, -4071,
     875,  3717,  3842, -4071, -4071,  3428,   435,  3786, -4071,  1956,
   -4071, -4071, -4071,  3698,  3283, -4071, 54028,  1960, -4071, -4071,
    2248, -4071, -4071, -4071, -4071,  3286,  3293,  3298,  2923, -4071,
    3672,  1427,   875,  3299,  3305,  3306,  3307,  3914,   168, -4071,
    3915, 48304, -4071, -4071, -4071,  1971,  3584, -4071, -4071, -4071,
    3091, -4071,  3092, -4071, -4071, -4071,  3894, -4071, -4071,  3091,
    3707,   220, -4071, -4071,  3308, -4071,  3309,  3310, -4071,   274,
    3314,  1941,  1224,  1974,  3635,  3712, -4071,  3552, -4071,  1955,
    1518,  1966,  1968,  1973,  1985, -4071, -4071, -4071, -4071, -4071,
    3333, -4071, -4071,   513, -4071,  3325,  1196,  1414, -4071, -4071,
    2006, -4071, -4071,  3967,  3611,  1537,  3369,  3369,  3369,  1855,
     875,  2010, -4071, -4071, -4071, -4071, -4071, -4071,  3748, -4071,
   -4071,  3349,  3437, 57844, -4071,  3392, -4071,  2645, 27289, 16315,
    3350,  3364, -4071,   870, -4071, -4071,  3342, -4071, -4071,  2806,
   -4071,  3957,  3788, -4071, -4071, 48940,  3372, -4071, -4071,  3668,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  2834,  2697,
    3407,  1051,  1051,  3078,  3408, 12367,  3370, -4071,  3467, -4071,
   -4071,   934,  2645, 12367, -4071, -4071, -4071,  3506,   895, -4071,
    3541,  3375,  3376, -4071, -4071,   435,  3382, -4071, -4071, 20885,
   -4071,  4003, -4071, -4071, 12367,  1654, -4071, -4071, -4071, -4071,
    3387, -4071, -4071,  3893,  3895, -4071, -4071,  2066, 57844, -4071,
    3229, -4071, 27928,  3260, -4071,   531,  3473, -4071, -4071, -4071,
   27289, -4071, -4071, -4071, 57844, -4071, 26011, -4071, -4071,  3391,
   -4071,  3091,  3091,  3091, -4071, -4071,  3091, -4071,  3092,  3622,
   -4071,  3092,  3092, -4071, -4071, -4071, -4071, -4071,   220,  1713,
   -4071, -4071,   220, -4071, -4071, -4071,   143,  1467,  3092, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  3091,  3091,  3091, -4071,
   -4071,   220,  3091, -4071,  3091, -4071,  2577, -4071,   162,   150,
    3091,  3091,  3091,  3208,  3396, -4071, -4071, -4071, -4071, -4071,
   -4071, 57844, -4071,  1058, 57844,   149, -4071, -4071, -4071,  2620,
    2014, 57844, 57844, 57844, 45124, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, 48304, -4071,  3993,  3665,  3395, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, 12367, -4071,
   -4071, -4071, 12367, -4071, -4071,  3699,  3858, -4071, -4071, -4071,
   -4071, -4071, -4071,  3411, -4071,  2620,   172,   172, -4071, -4071,
   -4071,  3897, -4071, -4071,  3479,  3483, -4071, -4071,  3498, -4071,
   -4071,   130,  2696, -4071, -4071, -4071, -4071, 16315,  3801,  3505,
   -4071, -4071,  3413,  3455, -4071, -4071,  1196, -4071, -4071, -4071,
   -4071, 12367, -4071,  3467,  2518, -4071, 31119, -4071,  -141, -4071,
    3461, -4071, -4071, -4071,  3463,   875, 57844,  3672, -4071,  1074,
    1196,   344,   435, -4071, -4071, -4071,  3416,  3418, -4071, -4071,
   -4071,  1588, -4071, 57844,  6659, -4071, -4071,   870,  6711, -4071,
   -4071,  1100,   669,  2008,  3421,  3426, 57844,  3431,  3432, -4071,
    3412, 27928, -4071, -4071, -4071, -4071, -4071, 26011,  6659,  1352,
   -4071, -4071,  3260,   877,  3433, 57844,  3765, -4071, -4071, -4071,
   -4071,  1405, -4071,  3438,  1405,  1405, -4071,  2534, -4071,  3481,
     220, -4071, -4071,  3485, -4071, -4071, -4071,  1405,  3441,   220,
   -4071, -4071, -4071, -4071,  1405, -4071, 48940,   435,  2633,  4072,
   -4071,  3496, -4071,  3970,  3844,  4085, -4071,  3447, -4071,  3846,
    3740,    88, -4071,   220, -4071, -4071,  3993, -4071,   220,  3993,
    1405,  1405, 57844,  3581, -4071, 64204, -4071, -4071,  -183,  3482,
    2024, -4071, -4071, -4071, -4071, -4071, -4071,  2029,   344,  3464,
    2040,  2042,  3936,  3640,  3656, -4071, -4071,  3469,  3472,   344,
    2018, -4071, -4071, -4071,  3475, -4071, -4071,  4062, -4071, -4071,
   -4071, -4071,   166,  3742,  2620,  2620,  2620,   845,  2696, -4071,
   -4071,  3525, 26011, 17631,  3588, 57844,  1586,  3901, -4071,  -224,
     344, 12367,  2768, 44488, -4071, -4071, -4071, 12367,  3478, 12367,
    3480,  2104, -4071, -4071, -4071,  1584,  1584, -4071,  1074, -4071,
   -4071, -4071, -4071,    67, 57844, 26011,  3468,  3671, -4071,  3229,
   -4071, -4071,  3430,  3406, -4071,  1845,  3392, -4071, -4071, 57844,
   57844,  2116, 57844, 57844,  2860,  2875,  2876,  1923,  1923, -4071,
   -4071,   290, -4071, -4071, -4071,  3891, -4071, -4071,  2130, -4071,
      55,  3768, -4071, -4071, -4071, -4071,  1405, -4071,   274, -4071,
   -4071, -4071, -4071, -4071,   274, -4071, -4071, -4071, -4071,  3488,
   -4071, -4071, -4071,  3780,  3533, -4071, -4071, -4071, -4071, -4071,
   39400, -4071, -4071, -4071, -4071, -4071, -4071, -4071, 12367,  3989,
    3523, 57844,  1246, -4071, 65476, 65476, 57844, -4071, -4071, -4071,
   -4071,  5596, -4071, -4071,   -26, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  4120, -4071,  3491, -4071,
   -4071,  3502,   231, -4071, -4071, 57844, 57208,   404, 57844, -4071,
    3787,   113,  1937, -4071,  3983,  2376, -4071, -4071, 12367, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  1508,
   -4071, -4071, 27289,  2886, -4071,  1845, -4071,  2171, -4071, -4071,
   -4071,  3602,    88,    88,  4027,  4030,    88,    88,    88,    88,
    3521,  3901, -4071,  4009, -4071, -4071, 12367, -4071, -4071,   875,
    3757, -4071,  4102,  1414,   875, 57844,   875, 57844, -4071,  3981,
    3981, -4071, -4071, -4071,  6659,  3982,  1976, -4071, -4071, -4071,
     251,  3536,  2425, -4071,  2194,  2204,  2217, -4071,  2219,  2222,
   -4071, -4071, -4071, -4071,   290,  3529, -4071, 57844, -4071, -4071,
   -4071,   310, -4071, -4071,  2224, -4071,  2231,  2112, -4071,  3488,
   -4071,  3534, -4071, -4071, -4071, -4071,   875, 12367, -4071, 12367,
    3553, -4071, -4071,  3994, 57844, -4071, -4071, -4071, -4071, 12367,
   -4071, 64204, 64204, -4071, -4071, -4071, -4071,  4147,   870,  4117,
    3815,  4138, -4071, -4071,  2237, -4071, -4071,   435,    88, -4071,
     404, -4071, -4071, -4071,    88,   344,  3550,  3808, -4071,   113,
   -4071, -4071, -4071,  1937, -4071, -4071, -4071,  2645,   344, -4071,
   -4071,  3558, -4071,    88, -4071,  3555, -4071, -4071, 57844,  3559,
   -4071,   435,   435,    88,    88,  2704,  2704,  1845, 48940,  3662,
   -4071, -4071,    88,   344, 57844, -4071,  1210,  3930, -4071,  2245,
    2257,  1269, -4071, -4071,  3626, -4071, -4071,  3756,  6659, -4071,
   -4071, -4071, -4071,  3772, -4071,   404, -4071, -4071, -4071,  3392,
   -4071,   195,   195,   220,   274,   220, -4071,  3560, -4071, -4071,
     875,   875, -4071,   254, -4071, -4071,  3968,  4057, 12367,   875,
   61024,  3563, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, 64840, 12367, -4071,   -26,  4120,
   -4071,  3835, -4071,  3836, -4071, 57208, -4071,  2620,   256, -4071,
   40036, -4071, -4071,  1799,   256, -4071,   256, -4071, -4071, 27289,
   16315,  2518, -4071,  3588, -4071,  3568, -4071, -4071,   -35, -4071,
   -4071,   435,   435, -4071, -4071, -4071, -4071, -4071,  2275, -4071,
   48940, -4071, -4071,  4175,  4177,  4073,  4181,  1210, -4071,  -136,
   -4071, -4071, -4071,  4182, -4071,  4184,  3582,  3583, -4071, -4071,
   -4071,  4095, 64204, -4071,  4089, -4071,   870, -4071,   404, -4071,
     113,  1937,  2277, -4071,  4235, -4071,   128,  3864,  3865, -4071,
   -4071, -4071, -4071,  3589,  3615, 12367, 64204, -4071,  4086, -4071,
    4011,  2111,  3954,  3592, -4071,  3585,  2091,  4122, 65476, 65476,
   -4071, -4071, -4071, -4071, -4071,  3969,  4244, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  2320,
   -4071, 16973, -4071, -4071, -4071, -4071, -4071, 48940, -4071,  3662,
   -4071,  3604,   274,   274,  4210,   274, -4071,  4211,  4212,  -136,
   -4071, -4071, -4071, 54028, 54028, -4071, -4071,  4107, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  3664,  4128,
    -114, -4071,   286, -4071,   875, 61660,  4216, 57844, -4071, -4071,
   -4071, -4071, 12367, -4071, 50212, 62296,  3605, -4071, -4071, -4071,
   -4071, -4071,  3797, -4071,  3568, -4071,  3619, -4071,  2921,  3901,
   -4071, -4071,  3621, -4071, -4071,   274, -4071,   274,   274, -4071,
    3623,  2345,  3802, -4071,  3626,   195,   195, -4071, -4071,   108,
   12367, -4071,  4123,  3713, -4071,  3628, -4071, 64204,  2164, 64204,
   -4071, -4071,  4066,  3630,   309, -4071,  3627, -4071,  4060,  4102,
   -4071, 16973,  3634, -4071, 12367,  3641,  3639, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, 64204, -4071, -4071,   435,  4038, -4071,
     108, -4071,   875,  4247, 64204, 57844, 59116,  3849, 62932,  4109,
   57844,  6659,  4110,  4112, -4071,  4255,  3930, -4071, -4071,   875,
   -4071, -4071, 64204, -4071, -4071, -4071, -4071,  3743, -4071, 59752,
   -4071,  2904, -4071,  3682, -4071, -4071,  4179,  1417, -4071,   274,
    4079, -4071, -4071, -4071, 64204, 64204, -4071, -4071, -4071, 38128,
   12367, -4071, -4071, -4071, -4071, -4071,   976, -4071,  3945,  3666,
   60388, 63568, -4071, -4071, -4071, 33033, -4071, -4071, -4071,  4119,
   -4071,   875, -4071,    10, 22163,  3825, 38128, -4071, -4071, -4071,
   -4071, -4071, -4071, 48940,  2409, -4071, -4071, 27289, -4071, -4071,
   -4071, -4071, 25370,  3669, -4071,    88, -4071, 27289, -4071, -4071,
   16315, -4071, -4071
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4071, -4071, -4071, -4071, -4071,   159, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071,  1952, -4071, -4071, -4071, -4071, -4071,
    1646, -4071,   523, -2372,  -500,  3335, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071,   812,  1761,  3294,
   -4071,   424, -4071,    72, -4071, -4071, -4071, -2988,   -58,  -258,
   -4071, -4071,   399,    18,  3281,  -257, -3233, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,   436,   431, -4071, -4071,
     263, -4071, -4071, -2278, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071,  -429,  -388,  1914, -4071, -4071, -4071,  4302, -4071,
    3753, -4071, -1821,  2418, -4071, -4071, -4071, -4071, -4071,  2488,
   -1751, -4071, -4071, -4071,  1525, -4071, -4071, -4071,  -310,   351,
   -4071,   359, -4071,   360, -4071,   362, -4071,   364,   365,   366,
     368, -4071,   370, -4071, -4071,  -383, -4071, -4071, -4071, -4071,
     372, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  -244, -4071,
   -4071,   -49, -4071, -4071,  -236,   375, -4071,  -168,   377, -4071,
     382, -4071,   -70, -4071,   -65, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071,  3280, -4071, -4071,
   -4071, -2048, -4071, -4071, -2186,  2808, -4071, -1706, -4071, -4071,
   -1902, -4071, -4071, -1643,  1053, -4071, -4071,  -121,   526, -4071,
   -1450, -1984, -1978, -4071, -4071, -4071, -2075, -2053,  -790,  2553,
   -1222, -2323, -4071, -4071, -4071, -4071,   119, -4071, -4071,   298,
    1749,  2271, -4071, -2547, -4071, -4071,   942, -4071, -4071,  1535,
     779,  1532, -4071,  1109,  3032, -1271, -4071, -4071, -4071, -4071,
   -4071, -4071,    41,   357,   -62, -4071, -3832,   791, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -2719, -4071, -4071, -4071,
    -268, -4071, -4071,  -161, -4071, -4071,  -218, -4071,   179, -2382,
   -4071, -4071, -4071, -4071,  2799, -1362, -4071,  3792, -4071,  -479,
   -4071,   506,  1790, -2776, -2005, -4071,  -937,  -936, -2959, -4071,
   -4071, -4071, -1775,  1056,  1343, -4071,   742,  1792, -2454, -4071,
   -4071, -4071, -4071, -4071,  1345, -4071, -4071,   502, -4071,   496,
   -4071, -4071, -4071, -4071, -4071,  -263, -4071,    19, -3250, -4071,
   -4071, -4071, -2975,  1259,   694, -4071, -4071, -4071,  -774, -2998,
    -822, -4071,   318, -2487, -2542,   662, -4071, -4071,   459, -3770,
   -4071,  -588, -2143, -2476,   -24, -4071, -4071,   472, -3447,  1919,
   -4071, -4071, -4071, -3412, -3521,  1664, -4071, -4071,  1215, -4071,
   -1086,  1217, -4071, -4071, -4071,  1232, -4071,    62, -4071, -4071,
   -4071, -4071, -3436, -4071, -4071, -1515, -2793, -4071, -4071,  4455,
    4456, -1578, -2402, -4070,   -52,   -50, -4071, -4071, -4071,  2270,
   -1700,   132,   120,   125,  1778,  -665,   277,  1082, -2254, -4071,
     352, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  1846,  -221,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -2393, -2915, -4071,
   -4071,  1409, -4071, -4071, -4071, -2272, -2082, -2080, -2431,  3487,
   -4071, -4071, -4071, -4071,  3440, -2275, -3795, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071,  2997,  1190, -4071, -4071,  1978, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,   568,  2076,
   -4071, -4071, -4071, -4071, -4071,  2390, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071,    66, -4071, -4071, -4071, -4071, -4071,
     813,  2907, -4071, -4071, -4071, -4071,   -12, -4071, -4071, -4071,
   -4071,  2595, -4071, -4071, -4071, -4071,  2925, -4071, -4071, -4071,
   -4071, -4071, -4071,  1674, -4071,  2117, -4071, -1536, -4071, -4071,
    1235, -1039,  2067,  -619,  2205,   521, -4071,  3912, -4071, -4071,
   -4071, -1768, -2497, -4071,  3593,  -777, -2675,  2584,  -573, -1932,
    1282,   238,  1486,  2025,  4376, -4071, -1154, -1186, -4071, -4071,
    -668, -4071, -4071, -4071, -4071, -4071,  2306,  2311,  -596, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
    1720, -4071, -4071, -4071, -4071, -1259, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071,  -871, -4071, -2119, -4071, -4071,  -489, -4071,
    3397, -4071, -4071, -4071, -2367, -1923,  2015,  1191, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071,  2026, -4071, -1605, -4071, -2806,
   -4071, -4071, -4071, -4071, -4071,  2221, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -1584, -4071, -1997,   287, -4071,   468, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,   -42,  1036,   -41, -3668,
   -1124,  1877, -4071, -4071, -1312,  3414, -2376, -4071, -4071, -4071,
    2206, -4071, -4071, -4071, -4071, -4071,   840, -3015,  3025, -4071,
   -4071, -3326,  -954, -2340,  -913, -4071, -1419,  1623,   668, -4071,
   -1933, -1143, -1517, -2992, -2419, -4071,  1490, -4071, -4071, -4071,
   -4071,  -154, -4071, -4071, -4071,   682,  2105, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071,  -555,  -907, -4071,
   -4071,  2370,  -514, -4071,  3530, -4071, -4071,  3531, -4071, -4071,
   -4071, -4071,  3216,  3188,  2172, -4071, -4071, -2351, -4071, -4071,
    2134, -4071,   951,  -934,  1067,  1271, -4071, -4071,  1273, -3275,
   -4071, -4071,  3538, -4071, -4071, -4071,  1222, -4071,   116,  3976,
    3545, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  2954,
   -1076,  3902, -4071, -4071, -4071, -4071, -4071, -4071,  2563, -4071,
   -4071, -4071, -4071, -4071, -4071,  3126,  3997,  -597, -1348, -4071,
    -789,  2567,  2085,  -867, -4071, -4071, -4071, -4071,  3999, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,  2744,
     872, -4071, -4071, -4071, -4071,  3209, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071,  1309,   -79, -4071,
     106,  -110, -4071,    16, -4071, -4071, -4071, -4071, -4071,  -185,
   -4071, -4071,  -189, -4071, -1024,  3826, -1421,   631, -1297, -2589,
   -4071,  1298,  3189, -3293,  -688, -1198, -1209, -2865,    64, -4071,
   -4071,  3663,    57,  1094,  -235,    -6, -2897,   -54,  -626,  -612,
    -738, -4071, -2324, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071,  2123, -4071, -4071, -4071,  1274, -4071,  4018, -4071,  2829,
    1276,  4023, -1392,  2646,  2139,  2141, -4071, -4071,  2148, -1948,
   -4071, -4071,   156, -4071,  2722, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071,  3795,  -454,  -452,  3214,  4034,  3709, -4071,  3284,
   -4071, -4071, -4071, -4071, -4071,   589, -4071,   900,  2178, -1288,
   -1796, -4071, -4071,  3006,   868, -4071,  1802,  -170,  -505, -4071,
   -4071,   593, -4071, -4071,  1622,  4050,  3715, -4071, -4071, -4071,
   -4071, -4071, -2797,  -918, -4071, -3487, -2859, -1749, -4071, -4071,
   -2224, -3111, -4071, -4071, -1059, -4071, -4071, -4071, -4071, -1965,
   -4071, -4071, -4071,    -7,  4016,  4017,  4021, -4071,  -802, -4071,
   -4071, -4071, -4071, -4071, -4071, -4071,  3610, -4071, -4071, -4071,
   -4071,  3612, -4071, -4071, -4071, -4071, -4071,  3613, -4071, -4071,
   -4071, -4071, -4071,  1697, -4071, -4071, -4071, -4071, -4071, -4071,
   -4071, -4071, -4071
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2773
static const yytype_int16 yytable[] =
{
     516,  1002,  1034,   895,  1102,  1559,  1747,  1680,   557,   955,
     998,  1421,  1773,   556,  1053,  1435,  1438,   564,   575,  2469,
    2470,  1566,  1863,  1772,   514,   583,  1451,   578,  1054,   828,
     829,   830,  2205,   832,   590,   834,  2328,   593,   836,  2645,
     838,  2646,   590,  1501,  1724,  1286,  1643,   673,  2011,   611,
    2010,  1175,   816,  1904,  1110,  2201,  2202,  1978,  1875,  1471,
    1862,   140,  2882,  2137,  1839,  2848,  1805,  1806,  2991,  3058,
    1809,  1810,  1811,  1812,   647,  1814,  1815,  1817,  1819,  1820,
    1821,  1822,  1823,  2740,  1471,  3435,  2140,   562,  3131,  3669,
    1795,  3316,  2829,   636,  3352,  2747,  1127,  1803,  3496,  1290,
    1689,  1008,  1913,  1465,  1015,  2805,   870,  3503,   871,  1522,
    2374,  1090,  1571,  1572,  1094,  2452,  2635,   639,  2699,   516,
    2748,   516,   646,   652,  3242,  3721,  2906,   657,  3014,  2095,
    3436,  1502,  2018,  2946,  3597,  2580,  3002,   870,  1269,   925,
    2700,  2581,  2950,   641,  3530,   643,  3880,  3397,  4041,  3824,
    2955,  3511,  2031,  3023,  3002,  3002,  3358,  3027,  3413,  2964,
    2034,  2035,  4012,   635,  1236,  1237,  1381,  2108,  3042,  2568,
    2108,  1349,  1908,  1595,  2182,  1236,  1237,  3547,  1236,  1237,
    3053,  2315,  2465,  1349,  3537,   574,  3995,  3169,  3170,  3146,
    3812,  4697,   582,  3176,   600,  3178,  4337,  3062,  3538,  1227,
    1228,  1229,  1115,  1116,  1117,  3963,  2364,  2073,  3561,  2696,
    1503,  1270,  3539,  3394,  1919,  2697,   670,  3233,  2649,  1568,
    1454,  2872,   870,   964,   945,  1236,  1237,  3409,  4071,   964,
     945,  1431,  3854,  2194,  1236,  1237,  1358,  1545,  1553,  1236,
    1237, -2093,  3537,  3776,  2091,  3174,  3372,  1095,  4523,  -934,
    3006,  3007,  1236,  1237,  1431,  4288,  3538,  1650,  1651,  1652,
    4606,  3703,  1437,  3934,  4274,  3002,  3002,  4321,  2583,  3574,
    3539,  1516, -2648,  3616,  1670,  2480,  3195,  1592,  2687,  1236,
    1237,   964,   945,  1236,  1237,  4329,  2717,  2982, -2492,  4779,
    4572,  4657, -2654,   658,  1362,  4026,  4330,  3072,  1009,  3486,
    2087,  2108,  3605,   620,  1963,  1539,  1733,  3326, -1904,  1737,
    3399,  3903,  1021, -1609,  3338,   122,  4282,  1350,   570,  1021,
    3904,  1236,  1237,  1568,   911,  1293,   122,  1343,   684,  1350,
    1756,  1757,  2125,  3234,  1761,  4519,  3956,  3961,  2378,  3159,
    3962,  3161,  1568,  3063,   273,  1783,   275,  1236,  1237,  1236,
    1237,  1775,  1776,  -572,  3878,   139,  3373,  2097,  2801,  3972,
    3102,  3137,  3138,  1155,  2040,  3674,  3994,  1236,  1237,  2902,
    1836,  1646,  -573,  1236,  1237,  4338,   603,  1472,  3304,   870,
    3901,   520,  1207,  2091,  2796,   521,  2091,   685,  2221,  1916,
   -1815,  1236,  1237,  4587,  2068,  1236,  1237,  1236,  1237,  4712,
   -2123,  1625,  2188,  1236,  1237,  2576,  2224,  2788,  4244,  4245,
    4536,  2356,   679,  -476,  1236,  1237,  2307,  2356,   123,  2357,
    2169,  4713,  3103,  2069,  3855,  3335,  1626,  4588,  4322,   835,
    4091,  1473,  4246,  2789,  1917,  2316,   124, -1815,   912,   571,
     591,  3400,  4536,  2206,  2379,  2041,  4411,   124,  4601,   667,
    2557,  2126,  1376,  1156,  2088,  4289,  1476, -1609,  2903,  3905,
    1482,  2292,  2109, -2492,  2937,  2109,  1543,  1551,  1236,  1237,
    1688,   621,  1208,  2530,  3366,  4152, -2767,   677,  4154,  1964,
    3487,  3675,  3073,   662,  1175,  4780,  3616,  4337,  1713,  4408,
    1496,  1714,  1835,  3617,  4395,  1022,  1023,  1010,  4607,  1363,
    2058,  1631,  1022,  1023,  1647,   125,   868,  3144,  1973,  4658,
    1340,   880,  1836,  1784,  4331,   913,  2831,  2091,  1236,  1237,
   -2274,   686,   879,  3324,  3325,   646,  2963,   652,  1517,  3010,
    3311,  2780,  2481,  1238,  3233,  4029,  1239,   868,  1610,  2900,
    3397,   993,  2608,  2925,   652,  1273,  3327,  1238,  4131,  3660,
    1239, -2648,  3706,  3664,   646,   875,  1096,  4135,  4290,   646,
    1432,   885,  4524,  1558,  1236,  1237,  1236,  1237,  3714,  3715,
    1236,  1237,  1359,  1455,   903,  4080,   665,  4522,  3575,  1800,
    2487,  4151,  3718,  1432,  2364,   646,  4153,  4389,  4060,  4390,
     126,   956,  4050,  2580,  1238, -1609,  2109,  1239,  2972,  2581,
    1871,  1017,  3385,  1238,  4323,  3704,  1239,  2013,  1238,  3697,
    2016,  1239,  2650,  1839,  2019,  2365,  2022,  3692,  2699,  4568,
    1037,  1238,   868,  2063,  1239,   886,  1837,  2345,  4515,  3627,
    2635,  1864,  1571,  1572,   646,   273,  1059,   275,  2348,  1863,
    2700,  2351,  4269,  2095,  2037,  2038,  1657,  1658,  1238,   516,
    3234,  1239,  1238,  3897,   636,  1239,  1088,  4525,   665,  1808,
     636,   665,  3401,   636,  3235,  1018,  4338,  1103,  1059,  2579,
     646,  3002,  1712,  1075,   646,  1939,  1829,  1862,  1608,   669,
    1725,  1122,  1727,   993,  2509,   601,  1571,  1572,  3776,  4526,
    1238,  3672,  4199,  1239,  1740,  1741,  1742,  1236,  1237,  1958,
    2907,  2168,  1746,  4209,  1506,  4698,  3617,  1236,  1237,  2696,
    3858,   839,  3374,  1540,  2108,  2697,  1238,  2033,  1238,  1239,
    1110,  1239,   127,  3002,  1085,  1236,  1237,  3112,  1606, -2123,
    2182,   893,  3117,  1176,  4248, -2300,  1238,  1842,  3849,  1239,
    3125,  3126,  1238,  2695,  4347,  1239,  3133,  -934,  2342,  1236,
    1237,  1909,  3064,  1236,  1237,  2071,  3540,  1920,   602,  3964,
    1238, -2654,  3813,  1239,  1238,  1019,  1238,  1239,  1837,  1239,
    3637,  2421,  1238,   927,  3959,  1239,  2214,  4066,  3147,   868,
    1285,  3992,  3529,  1238,  3139,  3547,  1239,  1240,  1053,  2096,
   -2654,  3158,  3512,  3933,  1233,   128,  1235,  3009,  1240, -1609,
    2575,  1240,  1940,  4013,  3166,  2195,  2331,  1236,  1237,  1608,
    1853, -1609,  2073,  1906,  3540,  2196,  3166,  2317,  3339,  3522,
    1076,  1278,   516,  1280,  1281,  1059,   516,   646,   646, -2767,
     516,   646,  1927,  1344,  2187,  3243,  1325,  1238,  1024,   572,
    1239,  4450,  3402,  3236,  2238,  1215,  1279,  3935,  1240, -2274,
    1283,  -572,  1053,  2899,  1288,  3891,  3892,  1240,   129,  2434,
    2222,  2266,  1240,  1780,  1781,  2270,  2017,   604,  4062,  3008,
    -573,  2097,  2308,  1354,  1541,  1240,  2853,  1780,  2257,  1608,
    1236,  1237,  4422,  3183,  1236,  1237,   636,  1238,  3254,  2294,
    1239,  2239,  1236,  1237,  1933,  1436, -2123,  1439,   646,   636,
    1442,  1447,  1240,   636,  1236,  1237,  1240, -2572, -2573,  1236,
    1237,  -476,  4412,  3004,  4611,  4358, -2772,  1468,  2293,  1477,
    2938,  2296,  2297,  1483,  2969, -2767,  1236,  1237,  2882,   676,
    2091,  3295,  2954,  1238,   680,  1238,  1239,  1715,  1239,  1238,
    1716,  4736,  1239,   646,  1240,   646,  1341,   833,   646,   646,
    2832,  3710,   837,  4383, -2420,  1378,  1365,  3523,  2188,  2313,
    2314,  3395,  3634,  3356,  3357,   646,  2065,  2066,  2067,  1384,
    1240,  2702,  1240,  1392,  1607,  3341,  4528,  3655, -1931,  1993,
     904,  3235,  1236,  1237,  3640,  2075,  2212,  3668,  3659,  2706,
    1240,   877,  3663,  2365,  1236,  1237,  1240,  1318,  2645,   139,
    2646,  4529,  3399,  4531,  3700,  1110,  2230,  3128,  3819,  2109,
     636,  2810,  2811,  2707,  1240,   141, -2274,  3822,  1240,  4461,
    1240,   887, -2572, -2573,  2476,  2580,  1240,  3014,  1271,  4600,
    2232,  2581,  4468,  2213,  1557,  3199,  3200,  1240,  3713,  1567,
    1236,  1237,  2264,  3149,  2491,  1876,  2501,   665,  1646,   665,
    1507,  3042,  3216,  3217,  1236,  1237,  1836,  4491,  1824,  2434,
    1236,  1237,  1387,   636, -2300,  3174,  1238,  3564,  2699,  1239,
    3319,  4095,   519,  2505,   636,  2635,  1238,  2761,  2011,  1239,
    2011,  2011,  2942,  2943,  3041,  2374, -2631,   636, -1931, -2635,
    2700,  1240,  1611,  3416,  1238,  3418,  2839,  1239,  4267,  3321,
    3322,  3323,  3429,  2363,  2335,  2435,  2095,  2235,  2535,  1632,
    1633,  1634,  1639,  3533,  1471,   524,  3442,  1836,  1238,  1236,
    1237,  1239,  1238,  3453,  3455,  1239,  3656,  2579,  1497, -1569,
    1236,  1237,  2000,  1587, -2634,  2719,  3472,  3474,  3476,  3903,
   -1932,  1240,  3477,  3455,  1236,  1237,  3115, -2724,  3904,  1471,
    3698,  2503,  1176,  2868,  3701,  3702,  3251,  3252,  4303,  2696,
    2407,  4509,  2947,   558,  2508,  2697,  1176,  2511,  2512, -1569,
     899,  2324,   870,  1646,  2190,  1529,  1238,   930,  3519,  1239,
    1790,  1669,  1637,  1508,  2429,  2430,  2809,  1240,  2047,  1240,
     576,  3949,  2001,  1240,  3950,  4565,  -578,  1236,  1237,   627,
    1105,  1454,  1608,  2236,  2328,  2237,  1236,  1237,  1509,  2244,
    1236,  1237,   605,  3150,  1612,  1774,  4218,  1828,  1613,  4695,
    4696,  1595,  2814,  2815,  3969,  3970,  3971,   993,   646,  1614,
    2350, -2300,  3974, -2632,  2864,  1773,  2182,  1571,  1572,   907,
    4000,  1236,  1237,  2695,  3947,  3948,  1236,  1237,  1864,  1238,
   -1932,  3174,  1239,  1238,  3174,  3174,  1239, -2724,  2352,  1236,
    1237,  1238,  1877,  3129,  1239,   646,  1865,  4316,  4317,  4073,
    1832,  3174,  2518,  1238,  2994,  3534,  1239,  1825,  1238,    13,
    2808,  1239, -2633, -2420,  2436,  3973,   636,  3905,  2367,  2336,
    2818,  3993,  3996,  3998,  3999,  1238,  3925, -1931,  1239,  3214,
    1826,  1236,  1237,  2096,   930,  2435,  1732,  3378,  3595,  4074,
     931,  2414,  1837,  1176,   646,   888,  3289, -2638,  1773,  1942,
    1240,  2522,  1918,  4096,   624,  1236,  1237,  2502, -1931,  2967,
    1240,  3942,   646,  1608,  2097,  2225,  2420,  1236,  1237,  2325,
     646,  1236,  1237,  1272,  3360,  1889,  2245,  1892,  1240,  1253,
     636,  1238,  2370,   878,  1239,  3535,  2048,  1282,  1236,  1237,
    2049,  1615,   636,  1238,  2255, -2631,  1239,   665, -2635,  4493,
     646,  2433,  1240,  1837, -2572, -2573,  1240,  3489,  1530,  2002,
    4494,   636,   636,  4483,  4484,  2930,  1127,   932,  2256,    25,
    2187,  1694,  2260,  2995,  4388,  2462,  1236,  1237,  3816,   908,
    1271,  1878,  3130,  2701,  3438, -2572, -2573,   646,   646,  1238,
    2519,  1945,  1239, -2634,  1896,   580,  1046,  1236,  1237,  1953,
    1392,  4509,  1954,  1238,  1236,  1237,  1239,  2520,  3379,  1238,
    1240,   646,  1239,  1236,  1237,  1236,  1237,   931,  1498,  2521,
    3936,  3924,  1974,   956, -1931,  4312,  2272,   900,  2931,  2415,
   -2420,   665,  1392,   516,   516,   516,   636,   516,   636, -1932,
    1616,  3621,    44,  2012,  2188,  1827,  1419,   139,  4558,  2014,
     516,  2702,   646,  1469,  3151,  4401,   516,  1994,  1995,  1996,
    3439,  1998,  4503,   870,  2436,  2453,  3533,   623,  1238,   139,
   -1932,  1239,  4219,  1698,  2015,  1969, -1931,   636,  2343,  1238,
    2021,  2337,  1239,  1240,  3407,  3407,  3622,  1240,  3415,  1236,
    1237,  1990, -2632,  1238,   932,  1240,  1239,  2338,  4280,  4281,
    2011,  2522,  2077,  2279,  3639,  4801,  1997,  1240,  1999,  4504,
    4357,  4580,  1240,  1646,  3445,  3446,  1943,  2047,  2020,  4094,
    3136,  2462, -1569,  2283,  4007,  1256,  2562,  2932,  2284,  1240,
    -212,  1062,   636,  2923,  1455,  3280,  3281,  3282,  1540,  2579,
    2703, -2633,   626,  1053,  2229,  4283,  1238,  2032,  1970,  1239,
     646,  3536,   868,  1236,  1237,  1238,  3361,  2688,  1239,  1238,
     881,  3440,  1239,  1236,  1237,   636,  2440,  4251,  1070,  2539,
    2133,   636,  2463,  1469,  1863,  4495, -2638,  1699,    38,  1236,
    1237,  1702,   636,  3854,  1063,  1240, -1932,  4313,  1703,  2563,
    1238,  3380,  3093,  1239,   637,  1238,  1511,  1240,  1239,   567,
     646,  2286,  2072,  1236,  1237,   646,  3091,  2933,  1238,    44,
      58,  1239,  1862,  2287,  1122,   135,  2211,  2523,  2564,  2107,
    3160,  1236,  1237,  1236,  1237,  1236,  1237,  1047,  3534,  1236,
    1237,  4628,  4628,  2416,  1646,  2127,  4505,  3365, -1932,  1236,
    1237,  2135,  3250,  1240,   592,  1076,  1736,  1773,  2616,   882,
    1238,  4025,   640,  1239,  1048,  1878,  3092,  1240,  3307,  2291,
    1673,  4189,  4075,  1240,   933,   934,  1946,   936,  1608,   938,
    1704, -2724,  2231,  2695,  1238,  1064,   607,  1239,  1512,  2309,
    1236,  1237,  1211,  2061,   939,  2048,  1238,  2524,  2565,  1239,
    1238,  4271,  4008,  1239,  3090,  1272,  2619,  1290,  3381,  1541,
    2704,   136,  4250,   568,  1176,  2265,  3300,  1238,  3545,  2061,
    1239,  3002,  2977,  1071,  2108,  3537,  2047,   520,  1236,  1237,
     883,   521,  1240,  1674,  1097,    54,  2744,  2813,  1706,  3538,
     655,  2749,  2853,  1240,  4093,  2978,  4570,  3215,  1110,  4574,
     659, -2772,  3094,  3539,  2755,  1238,  2096,  1240,  1239,  3197,
    1236,  1237,  2996,  4496,   964,  3957,  1971,  1236,  1237,  1236,
    1237,  2068,   273,  3198,   275,  2334,  1238,  1760,  2566,  1239,
    2368,  2175,  1212,  1238,   642,  3855,  1239,    58,  2770,  4359,
     608, -2724,  1238,   124,  1238,  1239,  1959,  1239,  1236,  1237,
    2070,   933,   934,   935,   936,   937,   938,  1236,  1237,  1947,
    1240,  1236,  1237,  2138,  1098,  2782,  3354,  2358,   636,  1240,
    1053,   939,   662,  1240,  1960,   646,  3209,   636,   646,  4230,
    4189,  4189,  2997,  2934,  2894,  3219,  1773,  2139,  2328,  3220,
     636,  1265,  1266,  1267,  1268,  1325,  2917,  3451,   670,  4231,
    1325,  1236,  1237,  2381,  1240,  1371,  3519,  2824,  1372,  1240,
    2389,  2389, -1904,  2389,  1458, -1904,   674,  2918,  1238,  4360,
    3832,  1239,  1240,   868,  2246,  1236,  1237,  3407,   672,  2385,
    1707,  2691,   646,  1236,  1237,   636,  2187,  2247,  2359,   636,
    3856,  2475,   675,  2701,  2048,   955,  1709,  4122,  2049,   665,
    1065,  1274,  4034,  2919,  1631,  4680,   646,   646,   636,   636,
     636,  2702,  2998,  3080,  1240,   520,  1236,  1237,   681,   521,
    1176,   646,  1459,  1236,  1237,   586,  2389,  2389,  2389,  2254,
    2388,  2388,  1238,  2388,  3536,  1239,  1236,  1237,  1240,   646,
    2091,  1978,  1238,  2091,   587,  1239,  3002,  3002,  1236,  1237,
    1240,  1460,   587,  2268,  1240,  2412,   956,  3041,  1238,  1365,
    1421,  1239,  1236,  1237,  1673,  2269,  1066,  2428,  1067,  2273,
     682,  1240,  3344,  1236,  1237,  1236,  1237,  2498,  1384,  2432,
    1236,  1237,  1238,  1385,  1961,  1239,  2277,  4189,  4189,  3275,
    3350,   826,  1236,  1237,  2567,  4123,  2388,  2388,  2388,   683,
    1238,  1396,  1238,  1239,  1238,  1239,  1373,  1239,  1238,  1240,
    4337,  1239,   831,  1471,  1631,  1236,  1237,   636,  1238,  2109,
     273,  1239,   275,  3364,  2278,  1236,  1237,  1674,  3531,  3657,
    1240,  3002,   520,  2517,  4445,  2494,   521,  1240,  4124,  2226,
     636, -1815,   720,  1236,  1237,  2282,  1240,   876,  1240,  3351,
     516,   516,  2285,  2541,   516,  3857,  1675,  3566,  3567,  1238,
    2176,  2288,  1239,  2300,  2108,  2258,  1836,  1673,  1329,  1836,
    3347,  3858,  3806,  3965,  2537,  2538,  3966,  3588,  3580,  1236,
    1237,   964,   945,   581,  2706,  2227,  1273,  2510, -1815,  1236,
    1237,  4058,  3186,  2074,  2718,  1773,  4189,  1238,  1236,  1237,
    1239,  4215,  4216,  4217,  2340,   725,  1584,  1585,  2707,  3097,
    2529,  4189,   636,  3927,  3928,  4079,  1611,  2175,  1236,  1237,
     842,  2175,  1240,  3302,  3098,  2546,  1676,  2689,  2999,  1238,
    1674,   898,  1239,  2705,  2553,  2554,  1238,  2319,  1238,  1239,
    3591,  1239,  3011,  1773,  3593,  2558,  2559,  2560,  2561,  1330,
    2569,  2570,  1629,   890,  2967,  1331,  2258,  2816,   273,  1675,
     275,   896,  1436,  3838,  3859,  1100,  1101,  1238,  1461,   916,
    1239,  1236,  1237,   646,  1436,   646,  1238,   918,  4189,  1239,
    1238,   646,  4562,  1239,  4563,  2724,  1240,  2713,  1515,  4338,
    2716,  2228,  1273,  1864,  1520,  1521,  1240,  1872, -1904,  1332,
    1873,  3163,  4189,  1874,   738,  1007,  1677,  1110,  1110,  1110,
     646,  3187,  1240,  1014,  4189,  4189,  1333,  2175,  2233,  2234,
    1238,  2691,   646,  1239,   908,  2784,  1036,  3193,  1187,  1676,
    4623,  1673,  1042,  1253,  2251,  1273,  1240,   993,  1612,  2352,
     993,  1035,  1613,   627,  1238,  2259,  1273,  1239,  4615,   879,
    1206,  3194,  1238,  1614,  1240,  1239,  1240,  3038,  1240,  1053,
    1053,  1053,  1240,  1219,  1220,  1484,  1061,  1796,  2806,  3201,
    2518,  3709,  1240,  1940,  1940,  1940,  2091,  3205,  2261,  1273,
    2091,  4189,  4365,  1050,   754,  1238,  1253,  3206,  1239,  2262,
    1730,  4189,  1238,  1069,  1674,  1239,  1485,  3540,  2828,  1076,
    2138,  1029,  1030,  1086,  1031,  1238,  1032,  1462,  1239,  1677,
    2274,  1273,  3249,  1240,  4707,  1089,   646,  1238,  3958,  3773,
    1239,  1108,  1837,  1675,  2139,  1837,  2275,  1273,  3207,  1463,
    1109,  1238,  1124,  4189,  1239,  4189,  2276,  1273,  1125,   612,
    1126,  2825,  1238,  2701,  1238,  1239,   646,  1239,  2519,  1238,
    1486,  1240,  1239,  2098,  3143,  1487,  1128,  2556,  1129,  2109,
    4189,  1238,  1273,  3629,  1239,  2520,  3208,  3785,   646,  1130,
    4189,  1464,  4189,  2011,  4189,  4023,  2091,  2960,  1133,  4706,
    1134,  4708,  3653,  1240,  1238,  1615,  1135,  1239,  4189,  1024,
    1240,   613,  1240,  1676,  1238,  4189,  2176,  1239,  3210,  1136,
    2176,  1137,  1836,  2862,  1276,  3213,  1836,  3218,  2519,  1773,
    4189,  4189,  1238,  2280,  1273,  1239,  4729,  1138,   526,  1139,
    3307,  1240,  1678,  1471,  1140,  2520,  4189,  4189,  2887,  1256,
    1240,  4189,  2890,  1141,  1240,  3427,  3221,  2521,  1142,   646,
     646,  2949,  3160,  2147,  2148,  3223,  1100,  1101,  1238,  3225,
    1143,  1239,  1797,  2911,  1144,  2913,  4760,  4761,  1238,  2161,
    1145,  1239,  2099,  1146,  4631,  4630,   614,  1238,  1236,  1237,
    1239,  1150,  2177,  1677,  1240,  2571,  2572,   956,  3040,  2475,
    1436,  1152,  1256,  2012,  1616,  2012,  2012,  1238,   993,  3227,
    1239,  4350,  4354,  1153,  2328,  1154,  2176,  1157,  1240,  1158,
     783,  1773,  1836,  3417,   527,  1159,  1240,  1488,  2798,  1273,
     542,  1774,  3451,  3228,  4553,  3431,  2910,  3433,  3434,  2522,
    2975,  3229,  1160,   516,  3398,  1678,  1161,   646,   646,  3447,
    2837,  2838,  3410,  2147,  2148,  3829,  3182,  2234,  1162,  1240,
    1238,  2562,  -884,  1239,  3452,  1163,  1240,  2980,  1164,  2161,
    4259,  4260,  3185,  1273,  3585,  3211,  1273,  3313,  3314,  1240,
    1277,  3586,  2562,  1252,  1165,  3454,  3317,  3318,   543,   964,
     945,  1240,  2177,   993,  3587,  2961,  3463,   993,  3464,  2440,
    3599,  1273,  1489,  1258,  1259,  1240,  3831,  -679,  2163,  2164,
     528,  3624,  3625,  1679,  3975,  1166,  1240,   544,  1240,  1294,
    3837,  3790,  3791,  1240,  2563,  3798,  3799,  1169,  4364,  1170,
    1253,  3839,  3074,  3840,  1171,  1240,  3809,  3817,  3841,  3833,
    1273,  1177,  3465,  4110,  1178,  2563,  2178,  3089,  1179,  3165,
    3842,  2100,  1180,  2564,   545,  2523,  1258,  1259,  1240,  4350,
    3976,  3110,  2101,  4354,  3466,  2524,  1181,  1490,  1240,  2102,
    3977,  3850,  1273,  4098,  2564,  3866,  3867,  1182,  1837,  4016,
    2572,   693,  1837,  4210,  1798,  1183,  1240,  1184,  4619,  4194,
    4195,  4110,  1185,   993,  4197,  4198,  1253,  1188,  2163,  2164,
    1799,  3467,   546,  1189,  1053,  4201,  4198,  4202,  4198,  1678,
    2686,  1190,   529,   636,   636,   636,  1349,  1191,  1940,  3978,
    1192,  3573,  1240,  2565,  1193,  2524,  2442,  2443,  3113,  3114,
    1326,  3116,  1240,  3118,  3119,  3120,  3121,  3122,  3123,  3124,
     615,  1240,  3127,  1194,  2565,  3132,  2178,  1148,  1149,  3135,
    1195,  1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  2562,
    1328,  1240,   616,  1196,   955,  4104,  1197,  3310,  2103,  4258,
    3318,  1198,   720,  3600,  1199,  1253,  2562,  4416,  1837,  3471,
    1335,  4277,  4198,  3154,  3155,  3156,  1491,  2391,  3820,  2392,
    1200,  2440,  3979,  1201,   530,  4286,  4287,  4741,   617,  2441,
    1202, -1609,  1254,  2566,  1261,  1262,  1263,  1264,  1265,  1266,
    1267,  1268,  2518,  1337,  1240,   531,  1203,  -671,   273,  1204,
     275,  1218,  2563,  1492,  2566,  1255,  1256,  1205,   724,   -67,
    4350,  4354,  1209,  3011,   547,   725,  4367,  4368,   532,  2563,
    1325,  1210,  2381,  1673,  1213,  3012,  1354,   646,   646,   646,
    -853,  2564,  2457,  2458,  2459,   636,  1214,   618, -1609,  4402,
    3625,  1217,  1350,  2104,   729,   730,  3479,  1221,  2564,  4403,
    4198,  1222,  2728,  1223,  2862,   646,  1224,  2864,   533,  4802,
    1774,  1334,  4404,  4198,  4406,  4198,   548,  4407,  4198,  4413,
    4414, -1609,  1256, -1609,  3514,  1176,  4415,  4414,  2729,   646,
     646,   646,  4454,  4455,  1296,  3468,  1674,   549,  -671, -1609,
    4501,  3318,  3334,  1100,  1101, -1609,  1225,  4043,  2442,  2443,
     534,  2565,  4502,  3318,  3011,  3288,  3712,  1226,   535,  2562,
    1275, -1609,  3473,  1338,   738,  2996,  3012,  1297,  2565, -1609,
    4578,  4579,  4604,  3625,  1346,  2012, -1609,  1347,  -671,  3469,
    2519,  1100,  1101,   527,  1348,  2730, -1609,  3980,  2731,  2444,
    3814,  1355,  4273,  1357,  3981,  1369,  2732,  2520, -1609,  1361,
     550,  1256,  1379, -1609,  3951,  3333,   551,  3954,  3955,  2521,
    1258,  1259, -1609,  1349,  2733,  4633,  4634,   636,  3089,  1393,
    1257,  2138,  2563,  1395,  3967,   552,  3011,  1411,   749,  1413,
    2828,  2566,  1414,  2562,  3982,  2997,  3475,  1298,  1415,  4139,
    4692,  3516,  1253,   753,   754,  2139,  3089,  1416,  2566,  2567,
     553,  2564,  3414,  1773,  4044,  4045,  3412,  3089,  3424,  4046,
    4047,  1419,  1299,  3423,  4363,  1422,  1300,   554,  1427,  -671,
    2567,  1428,  2078,  1448,   527,  1452,  1258,  1259,   646,  3423,
   -1609,  1453,  3448,  1457,  3444,  1469,  2079,  3383,  3459,  1774,
    1478,  2522,  1260,  1480,  3461,  3462,  2563,  4150, -1609,   636,
    4745,  4746,  1301, -1609,  4791,  4792,  1479,  3983,  1253,  4035,
    4036,  3423,  2138, -1609,  3889,  2998,  1575,  2734,  3089,  3485,
    1481,  2565,  4366,  1302,  3498,  2564,  1763,  1764,  3425,  3426,
     516,  3643,  3644,  1500,  3508,  1504,  2139,  1505,  1303,  3423,
    1510,  3038,  3864,  3865,  4295, -1609,  3910,  1518,  2281,  1519,
    4295,  3607,  3608,  1524,  3504, -1609,  3458,  1525,  1532,  1350,
    1263,  1264,  1265,  1266,  1267,  1268,  1527,  1537,  1568,  3460,
    1296,  1574,  4129,  4130,  1578,  3521,  1576,  4020,  4021,  1581,
    1582,  2543,  2544,  3013,  2138,  4133,  1304,  3497,  1586,  1590,
   -1609,  3528,  4136,  1596,  4417,  2565, -1609,  1591,  2555,  -671,
    1597,  2566,  1598,  1297,  1620,  1621, -1609,  2523,  2139,  1622,
    1628,  1305, -1609, -2116,  3984,  2573,  2574,  1630,  4155,  4156,
   -1609,  1631,  2735,  2518,  1261,  1262,  1263,  1264,  1265,  1266,
    1267,  1268,  1640,  3705,  1642,  1271, -1609,   775,  1256,  1646,
    1653,  4105,  1672, -1609,  4106,  3524,  1683,  2567,  1718,  1729,
    1730,  1731,  1754, -1609,  2080,   781,  1771,  1782,  1791,  1807,
     783,  1833,  1813,   784,  2567, -1609, -1609,  3719,  1834,  1626,
   -1609,  1840,  1844,  1298,  4485,  2566,  1841,  2524,  3723, -1609,
    3598,  3725,  2682,  2683,  2684,  2685,  1847,  1848,  2911,  1849,
    -671,  1850,  1851,  1855,  1852,  1854,  1866,   532,  1299,  1867,
    1773,  4101,  1300,  1868,  1256,  1263,  1264,  1265,  1266,  1267,
    1268,  4363,  1897,  1869,  1914,  3648,  1306,  1902,  1905,  1922,
    4107,  4108, -1609,  1923,  1924,  1307,  1925,  1930,  2862,  1936,
    2081,  2999,  1935,  1937, -1609, -1609,  4063,  4053,  1301,  1938,
    1308,  1949,  1955,  1979,  1987,  1992,  3039, -1609,  2887,  3636,
    1988,  2910,  3638,  2023,   646, -1609,  2082, -1609,  1309,  1302,
    2025,  2519,  3040,   646,  2024,  2028,  2026,  2029,  2736,  2825,
   -1609,  2030,  2045,  2059,  1303,  2076,   956,   956,  2520,  -671,
   -1609, -1609, -1609,  2393,  2128, -1609, -1609,  2122,   532,  2129,
    2521,  2143,  1258,  1259,  1421,  2142,  1774,  2171,  2189,  2191,
    2192,  2203,  1310,  2209,  2250,  1311,  2242,  2394,  2215,  2217,
    2218,  3684, -1609,  1436,  2219,  2241,  2243,  2567,   636,  2083,
    2395,  2248,  1304,  2249,  2258,  4638,  3693,  2252,  2263,  4191,
    4530,  2298,  2396,  1312,  2299,  2267,  2271,  2737,  2289,  3089,
    2290,  2295,  2310,  2311,  2312,  3654,  2329,  1305,  3423,  2333,
    4460,  3089,   520, -1290,  2339,  1313,   521,  1268,  1258,  1259,
    2349,   646, -1433, -1609,  1155,  3423,  2738,  3089,  3089,  4470,
    -671,  2369,  2522,  2404,  4275,  4276,  2384,  4278,  4279,  1207,
    1211,  3089,  3423,  2397,  2413,  2398,  2419, -1609,  3686,  2425,
     693,  2567,  2422,  3423,  1608,  3893,  3423,  2448,  2449,  2454,
    4243,  2455,  2456,  2471,  1314,  2477,  2478,  2484,  2479,  2482,
    2483,  2485,  2399,  2495,  3975,  2084,  2497,  2486,  2499,  2500,
    3728,  2504,  2514,   636,  2513,  3711,  1397,  1436,  3784,  2527,
    2528,  2531,  2532, -1609,  3717,  4638,  1398,  2534,  2536,  2545,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  2547,  2548,
    3110,  1399,  1306,  2549,  2550,  2551,  2552,  2655,  2651,  2657,
    3976,  1307,  2659,  1400,  1401,  1402,  2660,  2661,  2662,  2663,
    3977,  2664,  2665,  2666,  4104,   646,  1308,  2667,  2400,  2668,
    2669,   720,  1403,  2670,  2671,  2672,  2673,  2674,  2523, -1609,
    2675,  2676,  2677,  3729,  1309,  2678,  2679,  2680,  4643,  4644,
    2681,  4646, -1609,  3787,  2690,  1773,  1261,  1262,  1263,  1264,
    1265,  1266,  1267,  1268,  2709,  2710,  4786,  2711,  1773,  3978,
    2714,  3549, -1609,  1773, -1609,  2718,  2722,  2727,  1773,  4795,
    2750,  3885,  2751,  2401,  4786,  2752,  2822,   724,  1310,  4795,
    2357,  1311,  2762,  2763,   725,  2775,  2797,  2804, -1609, -1609,
    2812,  2821, -1609, -1609,  2840,  2835,  2836,  3874,  2524,  2843,
    2844,  4688,  1774,  4689,  4690,  2845,  2841,  2854,  2851,  1312,
    2842,  2857,  2858,   729,   730,  2856,  2865,  2869,  3550,   646,
    2866,  3551,  2891,  2892,  4243,  2871,  1909,  2870,  2463,  3552,
    3022,  1313,  2877,  3025,  3026,  2895,  3028,  2896,  2897,  3031,
    3032,  2462,  1253,  3035,  2915,  2916,  1963,  3553,  3044,  1964,
    2926,  2941,  2944,  3048,  3049,  3050,  3051,  3052,   273,  2956,
     275,  3056,  3057,  3089,  3059,  2957,  2973,  2958,  2981,  2992,
    3068,  3069,  3070,  3071,  2993,  3011,  3075,  3076,  3034,  3078,
    1314,  3024,  3423,   738,  3029,  3030,  3089,  3033,  3037,  2078,
    -853,  3036,  3554,  3043,  1774,  4757,  3045,  4772,  3423,  3047,
     636,  3046,  2586,  2079,  2587,  3054,  4511,  3055,  3060,  3061,
    3066,  3067,  3077,  3096,  1236,  1237,  3100,  3105,  3111,  3141,
    3140,  2582,  3915,  3145,  2210,  3166,  3171,  2583,  3157,  2584,
    3177,  2585,  3179,  3180,  3181,  3258,  -818,  -818,  3142,  2589,
    1436,  1404,  2586,  3188,  2587,  3189,  4508,   749,  -818,  3230,
    3555,  3246,  3240,  3241,  3244,  3248,  3253,  3277,  2592,  1405,
    3256,  3283,   753,   754,  3278,  4006,  2593,  3285,  4011,  3290,
    3294,  3293,  1371,  3297,  2588,  4019,  4019,  4019,  2012,  2589,
    2590,  3309,  3303,  3312,  3315,  3320,  2591,  3331,   646,  3336,
    3332,  1100,  1101,  2595,  3337,  3340,  3348,  3980,  2592,  1243,
    1244,  3355,  3359,  4513,  3981,  3349,  2593,  1568,  3362,  3371,
    2596,  2616,  3648,  3430,  3370,  3432,  2594,  3499,  3494,  3506,
    1690,  1691,  1692,  1693,  1694,  3502,   895,  3505,  3510,  3568,
    3515,   844,  3516,  2595,  2061,  3577,  1245,  3565,  1256,  2601,
    3520,  4798,  3546,  3259,  3982,  3576,  3589,  1568,  1246,  2316,
    2596,  3235,  3556,  3260,  3602,  3557,  3569,  3603,  2597,  2598,
     646,  3604,  3613,  4063,  3628,  2599,  3615,  3620,  3261,  3626,
    2890,  2080,  2440,  2600,  3641,  3649,  3661,  -961,  3662,  2601,
    3262,  3263,  3264,  3673,  3679,  3680,  3685,  3684,  3687,  1247,
    2602,  1406,  3688,  3716,  3689,  3694,  3708,  3695,  3696,  3265,
    4019,  1248,  2475,  3720,  3726,  3089,   273,  4114,   275,  2649,
    2603,   636,  3786,  3727,  2605,  3788,  3795,  3983,  3796,  4119,
    3801,   845,  2606,  1695,  1696,  1697,  1698,  3802,  1249,  3804,
    3811,  3815,  3803,  3558,  3807,  3818,  3821,  2607,  3823,  4081,
    3808,  3809,  3810,  3825,  3826,  3827,   273,  2081,   275,  3830,
     646,  1407,  2604,   847,  2605,  3834,   775,  3835,  1253,  3836,
    4105,  3845,  2606,  4106,  4232,  3851,  4511,   848,  3844,  1408,
    1100,  1101,  4233,  2082,   781,  3853,  4157,  2607,  3869,   783,
    3862,  4112,   784,  3870,  3335,  3879,  3881,  3882,  3887,  1436,
    1880,  1250,  1258,  1259,  1881,  2609, -1519, -1524,  3902,  4234,
    3867,  2608,  3911,  3920,  3896,  3929,  1882,  3930,  3886,  3995,
    3912,  3937,  3913,  2610,  4138,  3952,  4027,  3916,  4032,  4031,
    4037,  3926,  4243,  4038,  3984,  3945,   636,  4039,   852,  4229,
    1699,  3817,  1700,  1701,  1702,  2609,  2083,   646,  4002,  4107,
    4108,  1703,  4040,  4052,  4051, -1904,  4033,  4055,  4056,  4684,
    4068,  4082,  4070,  2610,  4083,  4099,   853,  2611,  4264,   636,
    4100,  4769,  4120,   854,  3202,  4102,  4103,  4142,  4117,  2614,
    3559,  2615,  4128,  4019,  4019,  4134,  4019,  4019,  4143,  2617,
    3992,  3428,  4144,  1238,  4132,  4146,  1239,  4145,  4769,  4148,
    4149,  4158,  4203,  4192,  3437,  4204,  4223,  2612,  4200,  3560,
    4543,  4205,  2613,   855,  4207,  4212,  4214,  4222,  4208,  2614,
    4211,  2615,  4255,  4225,  4257,  4543,  2616,  4268,  3266,  2617,
    4235,  4285,  4297,  1704,  4305,  4291,  4299,  4300,  4684,  4265,
    4307,  -352,  2084,  4325,  4327,  4311,  3267,  4328,  4346,  4356,
    4318,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  4370,  4373,
    2618,  2623,  4374,  4382,  1256,  4379,  4384,  4386,  4391,  4396,
    -370,  4422,  4451,  4409,  2619,  2620,  2621,  2622,  4419,  4332,
    4336,  4400,  4019,  4425,  1690,  1691,  1692,  1693,  1694,  4452,
    1705,  1706,  4596,  4453,   824,  4462,  4463,  4304,  4487,  4499,
    4472,  2623,  3489,  4475,  4469,  4532,  1774,  4540,  4539,  4550,
    4551,  4236,  4568,  4544,  4582,  4800,  4583,  2624,  2625,  2626,
    4585,  4591,  4584,  4592,  2627,  4595,  4593,  4594,  4598,  4237,
    4605,  4608,  4609,  4611,  4610,  4618,  4616,  4620, -2471,  2890,
    2628,  2890,  4621,  4624,  2629,  2608,  2583,  1883,  4642,  4645,
    4647,  4648,  4652,  4238,  4656,  4677,  4655,  2624,  2625,  2626,
    3268,  4664,  4678,  2630,  2627,  4681, -1693,   858,  4691,  4693,
    4704,  4410,  4709,  4703,  4705,  1884,  4710,  4714,  3269,  4718,
    2628,  2632,  4715,  1885,  2629,  4721,  4720,  1695,  1696,  1697,
    1698,  4725,  4728,  4732,  4739,  4543,  4734,  4737,  4426,  4738,
    4744,  4750,  4748,  2630,  4758,  4676,  4773,  4778,  2631,  4787,
    4774,  2830,  4015,   861,  4486,  4797,  3134,  1499,  1258,  1259,
    4320,  2632,  3800,  3005,  1550,  4086,   862,  1886,  4397,  4514,
    4653,  1580,  4654,  1707,  4088,  4084,  4263,  4789,  3270,  4752,
     599,  3393,  1006,  2451,  2377,   824,  4169,  1240,  1708,  1709,
     824,  3273,  4229,  4762,  4170,  4172,  3271,  4173,  4661,  4175,
    4176,  4177,   646,  4178,  4537,  4179,  4662,  4180,  4492,  4549,
    4183,  4629,  4184,  4548,  4723,  1624,  1887,  4185,  2360,  4399,
    4270,  3081,  2633,  2120,  4456,  -961,  4543,   824,  4543,  3722,
    3296,  3872,  3301,  3619,  1699,  1912,  1700,  1701,  1702,  4474,
    4224,  4567,  4743,  4717,   824,  1703,  3875,   865,  4641,  4543,
    4381,  4683,  2174,  1043,  4092,  3079,  3677,  3484,  4479,  4480,
    2144,  3919,  3491,  4111,  4113,  3086,  2828,  4726,  4533,   866,
     993,   867,  3562,  3960,  4293,  4001,  4147,  4566,  4137,  4336,
    4543,  4543,  3592,  3232,  4560,  4777,  4239,  3594,   824,   824,
     824,   824,  2990,  1774,  3590,  4517,   538,   539,  4602,  2708,
     824,  4603,  4459,  4467,  4465,  4345,  1261,  1262,  1263,  1264,
    1265,  1266,  1267,  1268,   646,  3153,  4296,  3699,  3083,  3483,
    2145,  2948,  2146,  2147,  2148,  2149,  2150,  1704,  2151,  2152,
    2153,  2154,  2155,  2156,  2157,  2158,  2159,  1523,  2160,  2161,
    2162,  4116,     1,  1588,     2,  2874,  2046,  4559,  2654,  2431,
    3932,  4552,  2134,  4640,  3614,  3287,  2172,  2898,  4190,  2852,
    2803,     3,  1033,  2461,  1426,     4,  3601,  4418,  4575,  4576,
    2743,  2741,  3255,  2968,  3658,  2802,  4261,  4393,  2962,     5,
       6,  4650,  3797,  4651,  1705,  1706,  2819,     7,   824,  1671,
    3940,  2062,     8,     9,  3345,  4072,  3478,  4742,  4065,  1728,
    2905,   646,  1895,  2712,  1560,  1561,  1928,  2880,  2850,  3877,
    3632,  3631,  1562,    10,  3667,  4564,  1020,  3110,  3110,  1563,
    1123,  2506,  2945,  2004,  2208,  1001,  2507,  1004,  3944,  2371,
    4716,  3618,    11,  4586,  1934,  4649,  4740,  4796,  4799,  4141,
    1216,  4666,  3635,  2924,  1952,   958,  3651,  2332,  4674,  3652,
     959,  2489,  2922,  2921,  2914,   926,    12,  2418,  1284,  1944,
    1412,  4213,  1888,  2893,    13,    14,    15,  2198,  2163,  2164,
    3274,  4221,   928,  1418,  1039,  1040,     0,    16,    17,  1041,
    1554,     0,  1555,  1556,     0,     0,     0,     0,     0,     0,
      18,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    19,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    20,     0,     0,     0,     0,  1707,     0,  4730,
       0,     0,     0,     0,  4735,     0,     0,    21,     0,    22,
       0,     0,  1708,  1709,    23,     0,     0,     0,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4790,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4770,    25,     0,    26,     0,     0,   824,
       0,     0,     0,     0,  4724,     0,     0,     0,     0,     0,
       0,     0,    27,     0,     0,     0,     0,     0,  1774,     0,
    4770,     0,     0,     0,     0,     0,     0,   646,     0,     0,
      28,  1774,     0,     0,    29,     0,  1774,   824,   824,     0,
       0,  1774,     0,     0,     0,     0,   824,   824,   824,   824,
     824,   824,   824,   824,   824,   824,   824,   824,     0,     0,
       0,     0,     0,     0,     0,     0,   824,   824,     0,   824,
     824,     0,     0,     0,   824,     0,     0,   824,   824,   824,
     824,     0,   824,   824,   824,     0,     0,     0,     0,     0,
       0,   824,   824,     0,   824,   824,   824,   824,   824,     0,
       0,   824,   824,   824,   824,   824,   824,   824,   824,   824,
     824,   824,     0,   824,     0,     0,   824,   824,     0,     0,
       0,   824,     0,     0,     0,   824,   824,   824,     0,     0,
      30,     0,     0,     0,     0,     0,     0,   824,   824,   824,
       0,     0,     0,     0,     0,     0,   824,    31,     0,    32,
       0,     0,     0,   824,   824,   824,     0,   824,     0,     0,
       0,     0,    33,     0,   824,   824,   824,     0,   824,   824,
     824,   824,   824,    34,   824,   824,   824,   824,   824,   824,
     824,   824,     0,     0,     0,   824,   824,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,    36,     0,
      37,     0,     0,    38,     0,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
      42,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,    46,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2586,     0,  2587,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,    50,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -818,  -818,     0,  2589,     0,     0,     0,     0,     0,     0,
       0,     0,  -818,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2592,  1131,     0,     0,     0,     0,     0,     0,
    2593,    51,     0,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,    52,     0,     0,     0,    53,   824,     0,
      54,     0,     0,     0,     0,     0,    55,  2595,     0,     0,
    1168,     0,     0,     0,   824,     0,     0,     0,   824,     0,
       0,  1568,     0,     0,  2596,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    58,  2601,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,  1230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     273,     0,   275,     0,     0,     0,     0,     0,  2605,     0,
       0,     0,     0,     0,     0,     0,  2606,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2607,     0,     0,     0,     0,     0,  2586,     0,  2587,
       0,     0,     0,     0,     0,  2983,     0,     0,     0,     0,
       0,  1370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2589,     0,     0,     0,     0,  4371,
    4372,     0,     0,  4375,  4376,  4377,  4378,     0,     0,  2609,
       0,     0,     0,  2592,     0,     0,   824,     0,     0,     0,
       0,  2593,     0,     0,     0,     0,     0,  2610,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2595,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1568,     0,     0,  2596,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2614,     0,  2615,     0,     0,     0,     0,
       0,     0,     0,  2617,  2601,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4457,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   824,
     824,   824,     0,     0,     0,     0,     0,     0,     0,     0,
    4481,  4482,     0,     0,   824,     0,     0,     0,     0,  4490,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   273,  1604,   275,     0,  2623,     0,     0,     0,  2605,
     824,     0,     0,     0,     0,     0,   824,  2606,     0,   824,
       0,   824,     0,     0,     0,     0,     0,   824,     0,   824,
     824,     0,  2607,     0,     0,     0,     0,     0,     0,     0,
    1644,  1645,     0,     0,     0,     0,     0,     0,     0,  1655,
    1656,     0,     0,  1659,  1660,  1661,  1662,  1665,  1666,  1667,
    1668,  2624,  2625,  2626,     0,     0,     0,     0,  2627,  1684,
    1685,     0,  1686,  1687,     0,     0,     0,     0,     0,     0,
    1720,  1721,  1722,  1723,  2628,     0,  1726,     0,  2629,     0,
    2609,     0,     0,     0,  1734,  1735,     0,  1738,  1739,     0,
       0,     0,     0,     0,  1743,  1744,  1745,  2630,  2610,  1748,
    1749,  1750,  1751,  1752,  1753,     0,  1755,     0,     0,  1758,
    1759,     0,   824,     0,  1762,  2632,     0,     0,  1765,  1769,
    1770,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1777,  1778,  1779,     0,     0,     0,     0,     0,     0,  1787,
       1,     0,     2,     0,     0,     0,  1792,  1793,  1794,     0,
       0,     0,     0,     0,  2614,     0,  2615,     0,     0,     0,
       0,     0,     0,     4,  2617,     0,   824,     0,     0,     0,
       0,     0,     0,  2984,     0,   824,     0,     5,     6,  1830,
       0,     0,     0,     0,     0,     7,     0,     0,     0,     0,
       8,     9,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    10,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      11,     0,     0,     0,     0,     0,  2623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    12,     0,     0,     0,     0,     0,
       0,     0,    13,    14,    15,     0,  1899,     0,     0,     0,
       0,     0,     0,     0,     0,    16,    17,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2624,  2625,  2626,     0,     0,     0,     0,  2627,
       0,     0,     0,    19,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2648,  2628,     0,     0,     0,  2629,
      20,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1951,     0,     0,     0,    21,   824,    22,  2630,     0,
       0,  1957,    23,     0,     0,     0,    24,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2632,  1985,     0,     0,
       0,  1991,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    25,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      27,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,    28,   824,
       0,     0,    29,     0,   824,   824,  2036,     0,     0,     0,
       0,     0,     0,   824,     0,   824,     0,   824,   824,   824,
     824,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,   824,   824,     0,   824,   824,
     824,   824,     0,   824,     0,     0,   824,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,   824,     0,   824,     0,   824,   824,     0,   824,
     824,     0,     0,     0,   824,   824,   824,     0,     0,     0,
     824,   824,   824,     0,   824,     0,   824,     0,   824,     0,
     824,     0,   824,     0,     0,     0,     0,   824,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,   824,    32,     0,     0,
       0,     0,     0,   824,     0,     0,   824,     0,     0,     0,
      33,     0,   824,     0,     0,   824,     0,     0,     0,   824,
       0,    34,     0,     0,     0,     0,     0,     0,     0,  2220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,    36,     0,    37,     0,
       0,    38,     0,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,    44,   824,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,    46,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,  2302,  2304,  2306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    51,
       0,     0,     0,  2341,     0,     0,     0,     0,     0,     0,
       0,    52,  2346,     0,  2347,    53,     0,     0,    54,     0,
       0,     0,     0,     0,    55,  2648,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3003,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,  3003,  3003,     0,     0,
      57,   961,     0,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,   962,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   899,   963,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   964,
     945,     0,     0,     0,     0,  2427,     0,   965,  2648,     0,
       0,     0,   966,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   967,     0,
     968,     0,   969,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   970,     0,     0,  3003,  3003,  2488,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    14,    15,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,   824,     0,     0,
       0, -1904,   971,     0,     0,     0,     0,   972,     0,     0,
     973,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   974,     0,
     975,     0,     0,     0,   824,     0,     0,     0,   976,     0,
     977,     0,     0,   824,     0,   824,     0,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   978,   979,   980,     0,
       0,     0,     0,     0,   824,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   981,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,   982,     0,     0,     0,     0,     0,     0,     0,  2658,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   983,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,     0,  2721,     0,
       0,     0,  2723,     0,     0,     0,     0,  2725,  2726,     0,
       0,     0,     0,     0,     0,     0,  1662,     0,  2742,   984,
    1662,     0,  2745,  2746,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2753,     0,  2754,     0,
       0,  2756,  2757,  2758,  2759,   985,  2760,   824,     0,     0,
       0,     0,     0,     0,     0,     0,   986,   987,  2764,     0,
     988,   989,  2648,     0,     0,  2765,     0,  2766,     0,  2767,
    2768,     0,  2769,     0,     0,     0,     0,  2772,  2773,  2774,
       0,   990,     0,  2776,  2777,  2778,     0,  2779,     0,  2781,
       0,  2783,     0,  2785,     0,  2786,     0,     0,     0,     0,
    2787,     0,     0,     0,  3730,  3731,     0,     0,     0,     0,
    3732,     0,  3733,     0,  3734,  3735,     0,     0,     0,  2807,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   991,
       0,  3549,     0,     0,     0,  2817,     0,     0,  2820,     0,
       0,     0,   992,     0,     0,     0,     0,     0,  2586,     0,
    2587,     0,     0,  2648,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,   824,     0,     0,
       0,     0,     0, -2511,     0,     0,     0,   993,     0,     0,
       0,     0,  -818,  -818,     0,  2589,     0,     0,  3736,     0,
       0,  3737,     0,     0,  -818,   994,   995,     0,     0,  3738,
       0,     0,     0,     0,  2592,     0,     0,     0,     0,     0,
       0,     0,  2593,     0,     0,  3003,     0,  3739,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3740,     0,     0,     0,   824,  2595,
       0,     0,     0,     0,   996,     0,     0,     0,     0,     0,
       0,     0,     0,  1568,     0, -2511,  2596,     0,     0,     0,
    3741,     0,  3742,   997,     0,     0,     0,     0,     0,     0,
     824,   824,     0,   824,     0,  3743,  3744,  1985,     0,     0,
    3481,     0,   824,     0,     0,  2601,  2583,   824,  2584,     0,
     824,     0,   824,   824,     0,     0,     0,     0,     0,     0,
       0,  2586,     0,  2587,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3745,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,  2588,     0,     0,     0,     0,  2589,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3746,
       0,     0,   273,     0,   275,     0,   824,  2592,  3747,  3748,
    2605,  3749,     0,     0,     0,  2593,     0,     0,  2606,     0,
       0,     0,     0,     0,     0,  2594,     0,     0,     0,     0,
       0,   824,     0,  2607,     0,     0,     0,     0,     0,     0,
       0,     0,  2595,     0,     0,  3750,  3751,  3752,     0,     0,
       0,     0,     0,     0,     0,     0,  1568,     0,     0,  2596,
       0,     0,     0,     0,  3753,  3754,  3755,  2597,     0,     0,
       0,     0,  3756,     0,  3482,  3757,     0,     0,     0,     0,
       0,     0,  2600,     0,     0,     0,     0,   824,  2601,     0,
       0,  2609,  3758,  3759,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2610,
       0,     0,     0,     0,     0,     0,  2648,     0,     0,  2603,
       0,     0,     0,     0,     0,     0,     0,     0,  3760,  3761,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3762,     0,   273,  3162,   275,     0,     0,
    3164,     0,     0,  2605,     0,  2614,     0,  2615,     0,     0,
       0,  2606,     0,     0,     0,  2617,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2607,  3191,  3192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3212,     0,  3763,
    2608,     0,     0,  3764,     0,     0,  3222,     0,  3224,     0,
    3226,     0,     0,     0,     0,     0,     0,  3765,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2609,     0,     0,  2623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2610,     0,     0,     0,  2611,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3284,  3766,     0,     0,  3767,     0,     0,
    3768,  3769,  3770,  3771,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2624,  2625,  2626,     0,     0,     0,     0,
    2627,  2613,     0,     0,     0,     0,     0,     0,  2614,     0,
    2615,     0,     0,     0,     0,     0,  2628,     0,  2617,     0,
    2629,     0,     0,     0,  3772,  3773,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2630,
       0,     0,   824,     0,     0,     0,     0,     0,     0,  1985,
       0,  3774,     0,     0,     0,     0,     0,  2632,     0,     0,
       0,     0,     0,     0,  2620,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,   824,     0,     0,     0,
    2623,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3367,     0,     0,     0,     0,     0,     0,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2624,  2625,  2626,     0,
       0,     0,     0,  2627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2628,
       0,     0,     0,  2629,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3991,
       0,     0,  2630,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2632,     0,     0,     0,     0,     0,     0,     0,     0,  3500,
    3501,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3532,     0,     0,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3571,  3572,     0,     0,     0,     0,     0,
       0,  2648,     0,     0,     0,  3579,     0,     0,     0,     0,
    3581,     0,     0,  3582,     0,  3583,  3584,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3991,     0,     0,     0,     0,     0,     0,     0,     0,  3610,
       0,     0,     0,     0,     0,     0,     0,     0,  4187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3610,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,     0,     0,     0,
       0,     0,     0,     0,   824,     0,     0,     0,     0,     0,
     824,     0,   824,     0,     0,     0,     0,     0,     0,     0,
    3610,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,  4187,  4187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4344,     0,     0,     0,  4344,  4344,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,   824,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   824,     0,  4187,  4187,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4344,     0,  3610,     0,     0,     0,     0,
       0,     0,  4344,     0,     0,     0,  4344,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3895,     0,     0,     0,     0,     0,     0,     0,  3367,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4344,     0,
    3923,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,  4187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4187,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4561,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4187,     0,     0,     0,     0,
       0,  4344,     0,  4344,  4344,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   824,  4187,
       0,     0,     0,     0,  3367,     0,     0,     0,  4030,     0,
       0,  4187,  4187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,     0,     0,     0,     0,     0,
       0,     0,     0,  3610,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3367,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4187,     0,
       0,     0,     0,     0,     0,   824,     0,     0,  4187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
    4187,     0,  4187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,     0,     0,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4187,     0,  4187,
       0,  4187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4187,     0,     0,     0,     0,
       0,     0,  4187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4187,  4187,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4187,  4187,     0,     0,     0,  4187,     0,
       0,     0,     0,     0,     0,     0,     0,  4249,     0,     0,
       0,     0,     0,  4254,     0,  4256,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3367,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3367,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4420,     0,  4421,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4429,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4541,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4546,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3610,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4614,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4668,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4702,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4719,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,  1766,   166,  4771,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,  3610,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,   734,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,  1767,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,  1768,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   689,   145,   146,   147,   148,  1981,     0,
     149,     0,     0,     0,   150,     0,     0,   690,     0,   152,
     153,   154,   155,   156,   157,   691,   159,     0,   160,     0,
       0,  1982,   161,   693,   694,   695,   162,   696,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     697,   698,   170,   171,     0,   172,   699,   700,   174,   175,
       0,   176,   177,   178,   179,   180,   701,   182,     0,   702,
     184,   703,   704,   705,   706,   707,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   708,   204,     0,   205,   709,   710,   206,     0,
       0,   207,   711,   208,   712,   713,   209,     0,   210,   714,
     715,     0,   211,   212,   213,   716,   717,   718,     0,     0,
       0,     0,   719,   216,   720,     0,     0,  1983,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   731,   272,   273,   274,   275,   732,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   733,   281,   282,   734,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   735,     0,     0,   292,     0,   736,   293,   294,
       0,     0,     0,     0,     0,   737,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,  1984,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,   795,   796,     0,     0,     0,     0,   797,   798,
       0,     0,   799,   800,     0,     0,   801,   802,   142,     0,
     143,   689,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   690,     0,   152,   153,   154,
     155,   156,   157,   691,   159,     0,   160,     0,     0,   692,
     161,   693,   694,   695,   162,   696,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   697,   698,
     170,   171,     0,   172,   699,   700,   174,   175,     0,   176,
     177,   178,   179,   180,   701,   182,     0,   702,   184,   703,
     704,   705,   706,   707,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     708,   204,     0,   205,   709,   710,   206,     0,     0,   207,
     711,   208,   712,   713,   209,     0,   210,   714,   715,     0,
     211,   212,   213,   716,   717,   718,     0,     0,     0,     0,
     719,   216,   720,     0,     0,   721,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,  2301,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,     0,   265,
     266,   267,     0,   268,   729,   730,     0,   269,   270,     0,
       0,     0,   731,   272,   273,   274,   275,   732,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   733,
     281,   282,   734,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     735,     0,     0,   292,     0,   736,   293,   294,     0,     0,
       0,     0,     0,   737,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   738,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,   751,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
     795,   796,     0,     0,     0,     0,   797,   798,     0,     0,
     799,   800,     0,     0,   801,   802,   142,     0,   143,   689,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   690,     0,   152,   153,   154,   155,   156,
     157,   691,   159,     0,   160,     0,     0,   692,   161,   693,
     694,   695,   162,   696,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   697,   698,   170,   171,
       0,   172,   699,   700,   174,   175,     0,   176,   177,   178,
     179,   180,   701,   182,     0,   702,   184,   703,   704,   705,
     706,   707,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   708,   204,
       0,   205,   709,   710,   206,     0,     0,   207,   711,   208,
     712,   713,   209,     0,   210,   714,   715,     0,   211,   212,
     213,   716,   717,   718,     0,     0,     0,     0,   719,   216,
     720,     0,     0,   721,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
    2303,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,     0,   265,   266,   267,
       0,   268,   729,   730,     0,   269,   270,     0,     0,     0,
     731,   272,   273,   274,   275,   732,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   733,   281,   282,
     734,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   735,     0,
       0,   292,     0,   736,   293,   294,     0,     0,     0,     0,
       0,   737,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   738,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,   795,   796,
       0,     0,     0,     0,   797,   798,     0,     0,   799,   800,
       0,     0,   801,   802,   142,     0,   143,   689,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   690,     0,   152,   153,   154,   155,   156,   157,   691,
     159,     0,   160,     0,     0,   692,   161,   693,   694,   695,
     162,   696,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   697,   698,   170,   171,     0,   172,
     699,   700,   174,   175,     0,   176,   177,   178,   179,   180,
     701,   182,     0,   702,   184,   703,   704,   705,   706,   707,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   708,   204,     0,   205,
     709,   710,   206,     0,     0,   207,   711,   208,   712,   713,
     209,     0,   210,   714,   715,     0,   211,   212,   213,   716,
     717,   718,     0,     0,     0,     0,   719,   216,   720,     0,
       0,   721,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,  2305,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,     0,   265,   266,   267,     0,   268,
     729,   730,     0,   269,   270,     0,     0,     0,   731,   272,
     273,   274,   275,   732,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   733,   281,   282,   734,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   735,     0,     0,   292,
       0,   736,   293,   294,     0,     0,     0,     0,     0,   737,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     738,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,   795,   796,     0,     0,
       0,     0,   797,   798,     0,     0,   799,   800,     0,     0,
     801,   802,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,     0,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,   734,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,     0,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   689,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   690,     0,   152,
     153,   154,   155,   156,   157,   691,   159,     0,   160,     0,
       0,   692,   161,   693,   694,   695,   162,   696,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     697,   698,   170,   171,     0,   172,   699,   700,   174,   175,
       0,   176,   177,   178,   179,   180,   701,   182,     0,   702,
     184,   703,   704,   705,   706,   707,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   708,   204,     0,   205,   709,   710,   206,     0,
       0,   207,   711,   208,   712,   713,   209,     0,   210,   714,
     715,     0,   211,   212,   213,   716,   717,   718,     0,     0,
       0,     0,   719,   216,   720,     0,     0,   721,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   731,   272,   273,   274,   275,   732,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   733,   281,   282,   734,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   735,     0,     0,   292,     0,   736,   293,   294,
       0,     0,     0,     0,     0,   737,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,   795,   796,     0,     0,     0,     0,   797,  1167,
       0,     0,   799,   800,     0,     0,   801,   802,   142,     0,
     143,   689,   145,   146,   147,   148,  1801,     0,   149,     0,
       0,     0,  1802,     0,     0,   690,     0,   152,   153,   154,
     155,   156,   157,   691,   159,     0,   160,     0,     0,   692,
     161,   693,   694,   695,   162,   696,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   697,   698,
     170,   171,     0,   172,   699,   700,   174,   175,     0,   176,
     177,   178,   179,   180,   701,   182,     0,   702,   184,   703,
     704,   705,   706,   707,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     708,   204,     0,   205,   709,   710,   206,     0,     0,   207,
     711,   208,   712,   713,   209,     0,   210,   714,   715,     0,
     211,   212,   213,   716,   717,   718,     0,     0,     0,     0,
     719,   216,   720,     0,     0,   721,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,     0,   265,
     266,   267,     0,   268,   729,   730,     0,   269,   270,     0,
       0,     0,   731,   272,   273,   274,   275,   732,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   733,
     281,   282,   734,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     735,     0,     0,   292,     0,   736,   293,   294,     0,     0,
       0,     0,     0,   737,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   738,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,     0,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
     795,   796,     0,     0,     0,     0,   797,   798,     0,     0,
     799,   800,     0,     0,   801,   802,   142,     0,   143,   689,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   690,     0,   152,   153,   154,   155,   156,
     157,   691,   159,     0,   160,     0,     0,   692,   161,   693,
     694,   695,   162,   696,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   697,   698,   170,   171,
       0,   172,   699,   700,   174,   175,     0,   176,   177,   178,
     179,   180,   701,   182,     0,   702,   184,   703,   704,   705,
     706,   707,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   708,   204,
       0,   205,   709,   710,   206,     0,     0,   207,   711,   208,
     712,   713,   209,     0,   210,   714,   715,     0,   211,   212,
     213,   716,   717,   718,     0,     0,     0,     0,   719,   216,
     720,     0,     0,   721,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,     0,   265,   266,   267,
       0,   268,   729,   730,     0,   269,   270,     0,     0,     0,
     731,   272,   273,   274,   275,   732,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   733,   281,   282,
     734,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   735,     0,
       0,   292,     0,   736,   293,   294,     0,     0,     0,     0,
       0,   737,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   738,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,  1898,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,   795,   796,
       0,     0,     0,     0,   797,   798,     0,     0,   799,   800,
       0,     0,   801,   802,   142,     0,   143,   689,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   690,     0,   152,   153,   154,   155,   156,   157,   691,
     159,     0,   160,     0,     0,   692,   161,   693,   694,   695,
     162,   696,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   697,   698,   170,   171,     0,   172,
     699,   700,   174,   175,     0,   176,   177,   178,   179,   180,
     701,   182,     0,   702,   184,   703,   704,   705,   706,   707,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   708,   204,     0,   205,
     709,   710,   206,     0,     0,   207,   711,   208,   712,   713,
     209,     0,   210,   714,   715,     0,   211,   212,   213,   716,
     717,   718,     0,     0,     0,     0,   719,   216,   720,     0,
       0,   721,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,     0,   265,   266,   267,     0,   268,
     729,   730,     0,   269,   270,     0,     0,     0,   731,   272,
     273,   274,   275,   732,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   733,   281,   282,  2720,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   735,     0,     0,   292,
       0,   736,   293,   294,     0,     0,     0,     0,     0,   737,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     738,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,   795,   796,     0,     0,
       0,     0,   797,   798,     0,     0,   799,   800,     0,     0,
     801,   802,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,     0,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,  2771,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,     0,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   689,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   690,     0,   152,
     153,   154,   155,   156,   157,   691,   159,     0,   160,     0,
       0,   692,   161,   693,   694,   695,   162,   696,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     697,   698,   170,   171,     0,   172,   699,   700,   174,   175,
       0,   176,   177,   178,   179,   180,   701,   182,     0,   702,
     184,   703,   704,   705,   706,   707,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   708,   204,     0,   205,   709,   710,   206,     0,
       0,   207,   711,   208,   712,   713,   209,     0,   210,   714,
     715,     0,   211,   212,   213,   716,   717,   718,     0,     0,
       0,     0,   719,   216,   720,     0,     0,  3609,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   731,   272,   273,   274,   275,   732,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   733,   281,   282,   734,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   735,     0,     0,   292,     0,   736,   293,   294,
       0,     0,     0,     0,     0,   737,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,   795,   796,     0,     0,     0,     0,   797,   798,
       0,     0,   799,   800,     0,     0,   801,   802,   142,     0,
     143,   689,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   690,     0,   152,   153,   154,
     155,   156,   157,   691,   159,     0,   160,     0,     0,   692,
     161,   693,   694,   695,   162,   696,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   697,   698,
     170,   171,     0,   172,   699,   700,   174,   175,     0,   176,
     177,   178,   179,   180,   701,   182,     0,   702,   184,   703,
     704,   705,   706,   707,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     708,   204,     0,   205,   709,   710,   206,     0,     0,   207,
     711,   208,   712,   713,   209,     0,   210,   714,   715,     0,
     211,   212,   213,   716,   717,   718,     0,     0,     0,     0,
     719,   216,   720,     0,     0,   721,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,     0,   265,
     266,   267,     0,   268,   729,   730,     0,   269,   270,     0,
       0,     0,   731,   272,   273,   274,   275,   732,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   733,
     281,   282,   734,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     735,     0,     0,   292,     0,   736,   293,   294,     0,     0,
       0,     0,     0,   737,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   738,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,  4635,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,     0,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
     795,   796,     0,     0,     0,     0,   797,   798,     0,     0,
     799,   800,     0,     0,   801,   802,   142,     0,   143,   689,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   690,     0,   152,   153,   154,   155,   156,
     157,   691,   159,     0,   160,     0,     0,   692,   161,   693,
     694,   695,   162,   696,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   697,   698,   170,   171,
       0,   172,   699,   700,   174,   175,     0,   176,   177,   178,
     179,   180,   701,   182,     0,   702,   184,   703,   704,   705,
     706,   707,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   708,   204,
       0,   205,   709,   710,   206,     0,     0,   207,   711,   208,
     712,   713,   209,     0,   210,   714,   715,     0,   211,   212,
     213,   716,   717,   718,     0,     0,     0,     0,   719,   216,
     720,     0,     0,   721,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,     0,   265,   266,   267,
       0,   268,   729,   730,     0,   269,   270,     0,     0,     0,
     731,   272,   273,   274,   275,   732,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   733,   281,   282,
     734,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   735,     0,
       0,   292,     0,   736,   293,   294,     0,     0,     0,     0,
       0,   737,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   738,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,     0,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,   795,   796,
       0,     0,     0,     0,   797,   798,     0,     0,   799,   800,
       0,     0,   801,   802,   142,     0,   143,   689,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   690,     0,   152,   153,   154,   155,   156,   157,   691,
     159,     0,   160,     0,     0,   692,   161,   693,   694,   695,
     162,   696,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   697,   698,   170,   171,     0,   172,
     699,   700,   174,   175,     0,   176,   177,   178,   179,   180,
     701,   182,     0,   702,   184,   703,   704,   705,   706,   707,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   708,   204,     0,   205,
     709,   710,   206,     0,     0,   207,   711,   208,   712,   713,
     209,     0,   210,   714,   715,     0,   211,   212,   213,   716,
     717,   718,     0,     0,     0,     0,   719,   216,   720,     0,
       0,   721,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,     0,   265,   266,   267,     0,   268,
     729,   730,     0,   269,   270,     0,     0,     0,   731,   272,
     273,   274,   275,   732,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   733,   281,   282,  1816,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   735,     0,     0,   292,
       0,   736,   293,   294,     0,     0,     0,     0,     0,   737,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     738,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,     0,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,   795,   796,     0,     0,
       0,     0,   797,   798,     0,     0,   799,   800,     0,     0,
     801,   802,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,     0,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,  1818,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,     0,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,     0,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,   693,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,  1857,     0,     0,
       0,     0,   215,   216,   720,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,  1858,   477,   478,  1859,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,   781,   483,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,   801,   802,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,  3012,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,   527,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,  2138,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,  2139,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,  3384,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,  2440,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,   532,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,     0,   513,     0,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,  3085,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,  3012,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,   527,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,  2138,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,  2139,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
     532,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  3085,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
    2440,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,  2881,
       0,     0,   150,     0,     0,   151,   802,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,  4782,   149,
       0,     0,     0,   150,  4783,   802,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,     0,     0,
     142,     0,   143,   144,   145,   146,   147,   148,  1172,     0,
     149,     0,     0,     0,   150,     0,   802,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,  1388,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,   561,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,     0,     0,
       0,     0,     0,  2387,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,   561,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,  3084,     0,   149,     0,     0,     0,   150,
       0,  3085,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,     0,   513,     0,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,  4783,   802,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   513,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,   561,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   632,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   633,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,     0,   513,     0,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,   561,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,   802,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,     0,
     513,     0,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
    3085,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   944,   945,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,   946,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   947,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     948,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   949,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   950,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   951,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   952,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   953,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   513,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,   954,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     644,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   139,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,  1441,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,   644,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   139,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,  1788,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   944,   945,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,   946,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   947,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   948,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   949,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   950,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   951,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   952,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   513,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,   954,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   644,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
    3645,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,  1319,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   513,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,  1320,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,     0,  1320,   152,   153,   154,
     155,   156,   157,   158,     0,     0,  -372,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,     0,     0,     0,     0,   169,  4160,     0,
     170,   171,     0,   172,     0,     0,     0,     0,     0,   176,
     177,   178,   179,  4161,   181,   182,     0,   183,   184,     0,
       0,     0,     0,     0,     0,   190,     0,   192,     0,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
       0,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,     0,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,     0,
       0,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,  4162,   250,   251,   252,     0,     0,     0,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,     0,   263,     0,   264,     0,     0,     0,     0,
     266,   267,     0,     0,     0,     0,     0,     0,   270,     0,
       0,     0,   271,   272,   273,   274,   275,  4163,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,     0,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,  4164,     0,     0,   288,     0,     0,     0,   290,
     291,     0,     0,   292,  4165,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,  -327,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
       0,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,  4166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   366,   367,     0,
       0,     0,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,     0,     0,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,     0,     0,   405,     0,   407,  -327,     0,   408,
       0,     0,     0,   410,     0,     0,   412,   413,     0,   414,
    4167,   415,     0,     0,   416,     0,   418,   419,   420,   421,
     422,   423,   424,     0,   426,   427,     0,   428,     0,     0,
       0,     0,   430,   431,   432,     0,     0,     0,     0,   434,
       0,     0,     0,     0,     0,     0,   437,     0,     0,   440,
     441,     0,   442,     0,   444,     0,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,     0,     0,     0,     0,   454,     0,
       0,     0,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,     0,     0,     0,
       0,   493,     0,     0,   494,     0,     0,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,  -327,     0,     0,     0,   508,     0,     0,
     510,     0,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,  4776,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,  1051,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   644,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,  1217,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,   142,   513,   143,   144,
     145,   146,   147,   148,  2210,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,   142,   513,   143,   144,   145,   146,   147,   148,
    2912,     0,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,  3279,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,     0,
       0,   142,  3650,   143,   144,   145,   146,   147,   148,   843,
     844,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
     845,     0,   207,     0,   208,     0,   846,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,   847,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,   848,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   849,
     240,   241,   242,   850,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   851,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,   852,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,   853,   279,     0,   280,     0,
       0,     0,   854,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   644,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,   855,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   856,   385,   386,   387,
     857,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,   858,     0,   398,   399,
     400,   401,   402,     0,   859,   404,     0,   405,   406,   407,
       0,     0,   860,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,   861,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,   862,   863,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   864,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,   865,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,   866,   495,
     867,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   920,
     144,   145,   146,   147,   148,   921,   844,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,   845,     0,   207,     0,
     208,     0,   846,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,   847,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,   848,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   849,   240,   241,   242,   850,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   851,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,   852,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,   853,   279,     0,   280,     0,     0,     0,   854,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   644,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,   855,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   856,   385,   386,   387,   922,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,   858,     0,   398,   399,   400,   401,   402,     0,
     859,   404,     0,   405,   406,   407,     0,     0,   860,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,   861,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,   862,   863,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   864,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,   865,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,   866,   495,   867,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,  2562,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
    2563,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,  2564,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,  2565,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,  1100,  1101,     0,   353,   354,     0,     0,  2566,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,  4763,   586,  4764,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,  2567,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,  1673,     0,     0,  3495,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,  1674,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,  2996,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2997,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,  2998,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,  2999,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,  1673,
       0,     0,  4302,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,  1674,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,  2996,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,  2997,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,  2998,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,  2999,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,  1673,     0,     0,  4557,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,  1674,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,  2996,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  2997,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,  2998,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,  2999,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,  1429,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,  1430,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,  1431,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   644,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,  1432,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,  1051,   846,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   644,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1443,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,  1444,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   644,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,  1021,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,  1022,  1023,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,  1024,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  2005,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,  2006,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,   756,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,  2007,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,  2008,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,  2005,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,  2006,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,   756,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,  2008,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,  1429,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
    1430,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   644,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2005,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,  2006,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,   756,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,  4022,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,  2008,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
     846,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   644,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,  1051,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   644,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,  1466,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   644,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
    2472,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   644,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1429,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   644,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   644,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,  2908,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,  4670,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,  4671,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,   586,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,  1118,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,   946,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,  1975,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,  2131,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,   946,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,  3106,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,  3411,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,  3419,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,  3443,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,  4333,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
    1890,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,  1891,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4160,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4161,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,  -342,  -342,   229,     0,  -342,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4162,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4163,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4164,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4165,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,  4166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
    -327,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,  4167,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,  -327,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,     0,     0,   152,   153,   154,   155,
     156,   157,   158,     0,     0,  -372,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,     0,     0,     0,     0,   169,  4160,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,   176,   177,
     178,   179,  4161,   181,   182,     0,   183,   184,     0,     0,
       0,     0,     0,     0,   190,     0,   192,     0,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,     0,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   226,   227,   228,     0,  -363,     0,
     229,     0,  -363,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,     0,     0,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
    4162,   250,   251,   252,     0,     0,     0,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,     0,   263,     0,   264,     0,     0,     0,     0,   266,
     267,     0,     0,     0,     0,     0,     0,   270,     0,     0,
       0,   271,   272,   273,   274,   275,  4163,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,  4164,     0,     0,   288,     0,     0,     0,   290,   291,
       0,     0,   292,  4165,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,  -327,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,     0,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,  4166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   366,   367,     0,     0,
       0,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,     0,     0,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,     0,     0,   405,     0,   407,  -327,     0,   408,     0,
       0,     0,   410,     0,     0,   412,   413,     0,   414,  4167,
     415,     0,     0,   416,     0,   418,   419,   420,   421,   422,
     423,   424,     0,   426,   427,     0,   428,     0,     0,     0,
       0,   430,   431,   432,     0,     0,     0,     0,   434,     0,
       0,     0,     0,     0,     0,   437,     0,     0,   440,   441,
       0,   442,     0,   444,     0,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,     0,     0,     0,     0,   454,     0,     0,
       0,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,     0,     0,     0,     0,
     493,     0,     0,   494,     0,     0,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
    -363,     0,  -327,     0,     0,     0,   508,     0,     0,   510,
       0,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
       0,     0,   152,   153,   154,   155,   156,   157,   158,     0,
       0,  -372,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,     0,     0,
       0,     0,   169,  4160,     0,   170,   171,     0,   172,     0,
       0,     0,     0,     0,   176,   177,   178,   179,  4161,   181,
     182,     0,   183,   184,     0,     0,     0,     0,     0,     0,
     190,     0,   192,     0,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,     0,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     226,   227,   228,     0,  -360,     0,   229,     0,  -360,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,     0,     0,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,  4162,   250,   251,   252,
       0,     0,     0,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,     0,   263,     0,
     264,     0,     0,     0,     0,   266,   267,     0,     0,     0,
       0,     0,     0,   270,     0,     0,     0,   271,   272,   273,
     274,   275,  4163,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,     0,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,  4164,     0,     0,
     288,     0,     0,     0,   290,   291,     0,     0,   292,  4165,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,  -327,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,     0,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,  4166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   366,   367,     0,     0,     0,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,     0,     0,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,     0,     0,   405,
       0,   407,  -327,     0,   408,     0,     0,     0,   410,     0,
       0,   412,   413,     0,   414,  4167,   415,     0,     0,   416,
       0,   418,   419,   420,   421,   422,   423,   424,     0,   426,
     427,     0,   428,     0,     0,     0,     0,   430,   431,   432,
       0,     0,     0,     0,   434,     0,     0,     0,     0,     0,
       0,   437,     0,     0,   440,   441,     0,   442,     0,   444,
       0,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,     0,
       0,     0,     0,   454,     0,     0,     0,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,     0,     0,     0,     0,   493,     0,     0,   494,
       0,     0,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,  -360,     0,  -327,     0,
       0,     0,   508,     0,     0,   510,     0,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4160,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4161,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,  4542,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4162,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4163,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4164,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4165,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,     0,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,  4166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   366,   367,
       0,     0,     0,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,     0,     0,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,     0,     0,   405,     0,   407,  -327,     0,
     408,     0,     0,     0,   410,     0,     0,   412,   413,     0,
     414,  4167,   415,     0,     0,   416,     0,   418,   419,   420,
     421,   422,   423,   424,     0,   426,   427,     0,   428,     0,
       0,     0,     0,   430,   431,   432,     0,     0,     0,     0,
     434,     0,     0,     0,     0,     0,     0,   437,     0,     0,
     440,   441,     0,   442,     0,   444,     0,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,     0,     0,     0,     0,   454,
       0,     0,     0,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,     0,     0,
       0,     0,   493,     0,     0,   494,     0,     0,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,  -327,     0,     0,     0,   508,     0,
       0,   510,     0,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4160,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4161,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
    -365,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4162,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4163,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4164,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4165,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,     0,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,  4166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,   367,     0,     0,     0,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,     0,     0,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,     0,
       0,   405,     0,   407,  -327,     0,   408,     0,     0,     0,
     410,     0,     0,   412,   413,     0,   414,  4167,   415,     0,
       0,   416,     0,   418,   419,   420,   421,   422,   423,   424,
       0,   426,   427,     0,   428,     0,     0,     0,     0,   430,
     431,   432,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,   437,     0,     0,   440,   441,     0,   442,
       0,   444,     0,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,     0,     0,     0,     0,   454,     0,     0,     0,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,     0,     0,     0,     0,   493,     0,
       0,   494,     0,     0,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
    -327,     0,     0,     0,   508,     0,     0,   510,     0,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4160,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4161,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,  4675,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4162,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4163,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4164,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4165,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,  4166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
    -327,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,  4167,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,  -327,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,     0,     0,   152,   153,   154,   155,
     156,   157,   158,     0,     0,  -372,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,     0,     0,     0,     0,   169,  4160,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,   176,   177,
     178,   179,  4161,   181,   182,     0,   183,   184,     0,     0,
       0,     0,     0,     0,   190,     0,   192,     0,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,     0,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,  4733,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,     0,     0,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
    4162,   250,   251,   252,     0,     0,     0,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,     0,   263,     0,   264,     0,     0,     0,     0,   266,
     267,     0,     0,     0,     0,     0,     0,   270,     0,     0,
       0,   271,   272,   273,   274,   275,  4163,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,  4164,     0,     0,   288,     0,     0,     0,   290,   291,
       0,     0,   292,  4165,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,  -327,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,     0,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,  4166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   366,   367,     0,     0,
       0,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,     0,     0,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,     0,     0,   405,     0,   407,  -327,     0,   408,     0,
       0,     0,   410,     0,     0,   412,   413,     0,   414,  4167,
     415,     0,     0,   416,     0,   418,   419,   420,   421,   422,
     423,   424,     0,   426,   427,     0,   428,     0,     0,     0,
       0,   430,   431,   432,     0,     0,     0,     0,   434,     0,
       0,     0,     0,     0,     0,   437,     0,     0,   440,   441,
       0,   442,     0,   444,     0,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,     0,     0,     0,     0,   454,     0,     0,
       0,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,     0,     0,     0,     0,
     493,     0,     0,   494,     0,     0,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,  -327,     0,     0,     0,   508,     0,     0,   510,
       0,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
       0,     0,   152,   153,   154,   155,   156,   157,   158,     0,
       0,  -372,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,     0,     0,
       0,     0,   169,  4160,     0,   170,   171,     0,   172,     0,
       0,     0,     0,     0,   176,   177,   178,   179,  4161,   181,
     182,     0,   183,   184,     0,     0,     0,     0,     0,     0,
     190,     0,   192,     0,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,     0,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,  -346,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,     0,     0,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,  4162,   250,   251,   252,
       0,     0,     0,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,     0,   263,     0,
     264,     0,     0,     0,     0,   266,   267,     0,     0,     0,
       0,     0,     0,   270,     0,     0,     0,   271,   272,   273,
     274,   275,  4163,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,     0,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,  4164,     0,     0,
     288,     0,     0,     0,   290,   291,     0,     0,   292,  4165,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,  -327,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,     0,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,  4166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   366,   367,     0,     0,     0,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,     0,     0,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,     0,     0,   405,
       0,   407,  -327,     0,   408,     0,     0,     0,   410,     0,
       0,   412,   413,     0,   414,  4167,   415,     0,     0,   416,
       0,   418,   419,   420,   421,   422,   423,   424,     0,   426,
     427,     0,   428,     0,     0,     0,     0,   430,   431,   432,
       0,     0,     0,     0,   434,     0,     0,     0,     0,     0,
       0,   437,     0,     0,   440,   441,     0,   442,     0,   444,
       0,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,     0,
       0,     0,     0,   454,     0,     0,     0,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,     0,     0,     0,     0,   493,     0,     0,   494,
       0,     0,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,  -327,     0,
       0,     0,   508,     0,     0,   510,     0,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4160,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4161,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,     0,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4162,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4163,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4164,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4165,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,     0,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,  4166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   366,   367,
       0,     0,     0,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,     0,     0,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,     0,     0,   405,     0,   407,  -327,     0,
     408,     0,     0,     0,   410,     0,     0,   412,   413,     0,
     414,  4167,   415,     0,     0,   416,     0,   418,   419,   420,
     421,   422,   423,   424,     0,   426,   427,     0,   428,     0,
       0,     0,     0,   430,   431,   432,     0,     0,     0,     0,
     434,     0,     0,     0,     0,     0,     0,   437,     0,     0,
     440,   441,     0,   442,     0,   444,     0,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,     0,     0,     0,     0,   454,
       0,     0,     0,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,     0,     0,
       0,     0,   493,     0,     0,   494,     0,     0,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,  -327,     0,     0,     0,   508,     0,
       0,   510,     0,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4160,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4161,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
       0,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4162,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4163,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4164,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4165,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,     0,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,  4166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,   367,     0,     0,     0,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,     0,     0,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,     0,
       0,   405,     0,   407,  -327,     0,   408,     0,     0,     0,
     410,     0,     0,   412,   413,     0,   414,  4167,   415,     0,
       0,   416,     0,   418,   419,   420,   421,   422,   423,   424,
       0,   426,   427,     0,   428,     0,     0,     0,     0,   430,
     431,   432,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,   437,     0,     0,   440,   441,     0,   442,
       0,   444,     0,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,     0,     0,     0,     0,   454,     0,     0,     0,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,     0,     0,     0,     0,   493,     0,
       0,  4545,     0,     0,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
    -327,     0,     0,     0,   508,     0,     0,   510,     0,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,     0,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,     0,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,     0,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
       0,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,     0,   513
};

static const yytype_int16 yycheck[] =
{
       6,   598,   621,   576,   672,  1044,  1192,  1150,    20,   597,
     598,   929,  1221,    19,   640,   949,   950,    23,    30,  1951,
    1952,  1045,  1319,  1221,     6,    37,   960,    33,   640,   543,
     544,   545,  1637,   547,    40,   549,  1785,    43,   552,  2121,
     554,  2121,    48,   997,  1168,   835,  1122,   526,  1469,    55,
    1469,   739,   541,  1365,   680,  1633,  1634,  1449,  1346,   972,
    1319,     4,  2444,  1599,  1286,  2405,  1252,  1253,  2544,  2616,
    1256,  1257,  1258,  1259,   128,  1261,  1262,  1263,  1264,  1265,
    1266,  1267,  1268,  2226,   997,  3044,  1601,    23,  2677,  3364,
    1244,  2888,  2367,    99,  2953,  2238,   692,  1251,  3090,   837,
    1159,   601,  1373,   970,   604,  2329,   560,  3095,   560,  1016,
    1861,   666,  1049,  1049,   669,  1936,  2121,   123,  2193,   125,
    2239,   127,   128,   129,  2799,  3451,  2466,   134,  2582,  1579,
    3045,   998,  1480,  2509,  3245,  2119,  2555,   591,   806,   591,
    2193,  2119,  2514,   125,  3159,   127,  3633,  3012,    18,  3561,
    2517,    13,  1500,  2584,  2573,  2574,  2962,  2588,  3023,  2526,
    1508,  1509,    13,    99,    17,    18,   904,    26,  2599,  2102,
      26,    20,    75,  1080,  1624,    17,    18,  3175,    17,    18,
    2611,    20,  1950,    20,    22,    29,    36,  2729,  2730,    20,
      22,    83,    36,  2735,    13,  2737,    83,    20,    36,   795,
     796,   797,   681,   682,   683,    62,    53,  1569,  3183,  2193,
     999,   807,    50,  2989,    32,  2193,    18,    21,    87,   132,
     276,   199,   676,    61,    62,    17,    18,  3020,  3896,    61,
      62,   166,    66,    49,    17,    18,    91,  1039,  1040,    17,
      18,   381,    22,  3493,   242,  2732,   136,    58,    53,   162,
    2573,  2574,    17,    18,   166,   200,    36,  1128,  1129,  1130,
     132,   150,   197,  3710,  4096,  2684,  2685,   293,    12,    45,
      50,   379,   377,   235,  1145,   379,   387,  1079,  2180,    17,
      18,    61,    62,    17,    18,    54,  2209,   466,   257,   279,
     325,   405,   162,   137,    89,  3816,    65,   145,   432,     9,
     437,    26,   457,   486,   257,    11,  1177,   152,   164,  1180,
      65,   244,    38,   162,    84,    12,  4111,   166,   118,    38,
     253,    17,    18,   132,   313,   839,    12,   116,   235,   166,
    1201,  1202,   133,   137,  1205,  4405,  3748,  3749,   372,  2715,
    3752,  2717,   132,   166,   231,   486,   233,    17,    18,    17,
      18,  1222,  1223,   162,  3629,   564,   246,  1579,  2323,  3771,
      13,  2684,  2685,   564,   446,    21,  3778,    17,    18,   197,
     368,    13,   162,    17,    18,   262,    13,   199,  2875,   833,
    3673,   554,   564,   242,  2317,   558,   242,   294,   156,   218,
     609,    17,    18,   529,   173,    17,    18,    17,    18,    90,
     166,   631,  1624,    17,    18,  2111,    20,    36,   632,   633,
     156,   654,   533,   162,    17,    18,   199,   654,   115,   662,
     197,   112,    75,   202,   258,   662,   656,   563,   454,   550,
    3917,   253,   656,    62,   263,   274,   133,   656,   427,   239,
      41,   196,   156,   662,   478,   527,   136,   133,  4518,   622,
    2093,   252,   661,   654,   591,   400,    72,   294,   286,   392,
      72,   199,   321,   432,   169,   321,  1039,  1040,    17,    18,
    1158,   654,   654,  2057,  2971,  3996,   173,   531,  3999,   432,
     190,   137,   330,   662,  1172,   475,   235,    83,   119,  4284,
     990,   122,  1282,   455,  4264,   221,   222,   631,   370,   294,
    1524,   656,   221,   222,   146,   202,   560,  2693,  1442,   623,
      68,   565,   368,   654,   283,   504,   197,   242,    17,    18,
     166,   428,   662,  2899,  2900,   531,  2523,   533,   636,  2577,
    2881,   199,   636,   386,    21,  3828,   389,   591,  1093,  2462,
    3405,   539,   286,  2491,   550,   656,   391,   386,  3960,  3355,
     389,   656,  3417,  3359,   560,   561,   367,  3969,   503,   565,
     495,   567,   367,  1042,    17,    18,    17,    18,  3433,  3434,
      17,    18,   427,   629,   580,  3901,   519,  4409,   354,  1247,
    1972,  3993,  3447,   495,    53,   591,  3998,  4255,  3881,  4257,
     287,   597,  3867,  2577,   386,   432,   321,   389,  2531,  2577,
    1338,   607,  2984,   386,   630,   494,   389,  1474,   386,  3402,
    1477,   389,   481,  1835,  1481,   462,  1483,  3393,  2693,   654,
     626,   386,   676,  1536,   389,   568,   624,  1813,  4398,  3304,
    2635,  1319,  1569,  1569,   640,   231,   642,   233,  1824,  1936,
    2693,  1827,  4089,  2093,  1511,  1512,  1135,  1136,   386,   655,
     137,   389,   386,  3668,   660,   389,   662,   462,   601,  1255,
     666,   604,   417,   669,   468,   608,   262,   673,   674,  2119,
     676,  3090,  1161,   655,   680,  1413,  1272,  1936,   656,   523,
    1169,   687,  1171,   539,  2032,   504,  1623,  1623,  3938,   494,
     386,  3366,  4018,   389,  1183,  1184,  1185,    17,    18,  1437,
    2468,  1608,  1191,  4029,    75,   597,   455,    17,    18,  2693,
     544,   555,   602,   419,    26,  2693,   386,  1506,   386,   389,
    1346,   389,   419,  3142,   660,    17,    18,  2660,   182,   495,
    2180,   575,  2665,   739,  4060,   166,   386,  1292,  3597,   389,
    2673,  2674,   386,  2193,   631,   389,  2679,   660,  1807,    17,
      18,   654,   575,    17,    18,  1557,   594,   575,   577,   616,
     386,   631,   594,   389,   386,   609,   386,   389,   624,   389,
    3317,  1914,   386,   575,  3749,   389,  1647,  3888,   609,   833,
     834,   619,  3158,   386,  2686,  3783,   389,   640,  1414,  1579,
     660,  2714,   654,  3708,   800,   492,   802,   656,   640,   636,
     656,   640,  1414,   654,   654,   621,   659,    17,    18,   656,
    1310,   660,  2174,  1368,   594,   631,   654,   656,   588,  3142,
     526,   827,   828,   829,   830,   831,   832,   833,   834,   526,
     836,   837,  1387,   622,  1624,  2800,   842,   386,   564,   639,
     389,  4328,   597,   647,   609,   564,   828,  3712,   640,   495,
     832,   660,  1478,   151,   836,  3661,  3662,   640,   555,   182,
     628,  1732,   640,   655,   656,  1736,  1478,   504,  3883,  2575,
     660,  2093,   655,   879,   580,   640,  2412,   655,   656,   656,
      17,    18,   628,    20,    17,    18,   892,   386,  2820,  1760,
     389,   656,    17,    18,  1394,   949,   662,   951,   904,   905,
     954,   955,   640,   909,    17,    18,   640,   162,   162,    17,
      18,   660,   602,  2556,   628,  4208,   622,   971,   656,   535,
     625,   655,   656,   535,  2529,   622,    17,    18,  3310,   530,
     242,  2863,  2516,   386,   535,   386,   389,   568,   389,   386,
     571,  4711,   389,   949,   640,   951,   504,   548,   954,   955,
     631,  3427,   553,  4246,   166,   898,   892,  3143,  2180,   655,
     656,  3009,  3313,  2960,  2961,   971,  1539,  1540,  1541,   905,
     640,  2193,   640,   909,   428,  2923,  4412,  3349,   136,  1458,
     581,   468,    17,    18,  3324,  1573,   656,  3363,  3355,   585,
     640,    70,  3359,   462,    17,    18,   640,   841,  3080,   564,
    3080,  4413,    65,  4415,  3406,  1631,   656,   111,  3550,   321,
    1016,   655,   656,   609,   640,   239,   662,  3559,   640,  4345,
     640,   217,   277,   277,  1958,  3009,   640,  3481,    73,  4516,
     656,  3009,  4358,   655,  1041,   655,   656,   640,  3431,  1045,
      17,    18,  1730,    48,  1978,   202,   375,   990,    13,   992,
     421,  3482,   655,   656,    17,    18,   368,  4383,    34,   182,
      17,    18,   906,  1069,   495,  3552,   386,  3186,  3143,   389,
    2891,   402,   313,  2027,  1080,  3080,   386,  2263,  2499,   389,
    2501,  2502,  2501,  2502,  2599,  2836,   377,  1093,   246,   377,
    3143,   640,    60,  3026,   386,  3028,  2384,   389,  4086,  2895,
    2896,  2897,  3035,  1841,   185,   428,  2556,   656,  2062,  1115,
    1116,  1117,  1118,   129,  2027,   634,  3049,   368,   386,    17,
      18,   389,   386,  3056,  3057,   389,  3350,  2577,   225,   195,
      17,    18,   288,  1069,   377,  2211,  3069,  3070,  3071,   244,
     136,   640,  3075,  3076,    17,    18,  2663,   277,   253,  2062,
    3404,  2018,  1158,  2424,  3408,  3409,   655,   656,  4150,  3143,
    1898,  4394,  2510,   108,  2031,  3143,  1172,  2034,  2035,   235,
      36,   486,  1626,    13,  1626,   260,   386,    13,  3111,   389,
    1234,   146,  1118,   554,  1922,  1923,  2340,   640,   486,   640,
     654,  3733,   348,   640,  3736,  4470,   558,    17,    18,   561,
     674,   276,   656,   656,  2953,   656,    17,    18,   579,   656,
      17,    18,   558,   218,   182,  1221,   371,  1271,   186,  4655,
    4656,  2128,  2346,  2347,  3766,  3767,  3768,   539,  1234,   197,
    1826,   662,  3774,   377,  2420,  2444,  2686,  2174,  2174,   134,
    3782,    17,    18,  2693,  3731,  3732,    17,    18,  1936,   386,
     246,  3738,   389,   386,  3741,  3742,   389,   387,  1831,    17,
      18,   386,   419,   367,   389,  1271,  1320,  4164,  4165,   195,
    1276,  3758,   105,   386,   133,   291,   389,   253,   386,   136,
    2339,   389,   377,   495,   607,  3772,  1292,   392,  1843,   370,
    2349,  3778,  3779,  3780,  3781,   386,  3698,   455,   389,   197,
     276,    17,    18,  2093,    13,   428,   146,   130,  3241,   235,
     146,   294,   624,  1319,  1320,   511,  2852,   377,  2527,   202,
     640,   354,  1376,   654,   162,    17,    18,   656,   486,  2527,
     640,  3724,  1338,   656,  2556,   655,  1909,    17,    18,   654,
    1346,    17,    18,   388,   377,  1351,   656,  1353,   640,   147,
    1356,   386,  1852,   432,   389,   371,   654,   831,    17,    18,
     658,   329,  1368,   386,   656,   656,   389,  1310,   656,   159,
    1376,  1926,   640,   624,   629,   629,   640,   440,   463,   535,
     170,  1387,  1388,  4375,  4376,   129,  1982,   223,   656,   246,
    2180,   127,   656,   252,  4253,   199,    17,    18,  3541,   294,
      73,   558,   506,  2193,   190,   660,   660,  1413,  1414,   386,
     243,  1417,   389,   656,  1357,   480,   331,    17,    18,  1425,
    1356,  4654,  1428,   386,    17,    18,   389,   260,   251,   386,
     640,  1437,   389,    17,    18,    17,    18,   146,   535,   272,
    3715,  3695,  1448,  1449,   602,   199,   656,   313,   192,   432,
     662,  1394,  1388,  1459,  1460,  1461,  1462,  1463,  1464,   455,
     428,   218,   486,  1469,  2686,   441,   596,   564,  4460,  1475,
    1476,  2693,  1478,   277,   479,  4272,  1482,  1459,  1460,  1461,
     266,  1463,   213,  1937,   607,  1937,   129,     0,   386,   564,
     486,   389,   647,   229,  1476,   210,   654,  1503,   171,   386,
    1482,   582,   389,   640,  3019,  3020,   263,   640,  3025,    17,
      18,  1454,   656,   386,   223,   640,   389,   598,  4107,  4108,
    2941,   354,  1576,   656,  3320,  4800,  1462,   640,  1464,   260,
    4205,  4490,   640,    13,  3051,  3052,   419,   486,  1481,  3921,
    2683,   199,   608,   656,   486,   343,   129,   291,   656,   640,
     655,     6,  1558,  2487,   629,  2843,  2844,  2845,   419,  3009,
     404,   656,   414,  2189,   655,  4112,   386,  1503,   283,   389,
    1576,   587,  1626,    17,    18,   386,   609,  2189,   389,   386,
     134,   367,   389,    17,    18,  1591,   486,  4063,   235,  2068,
    1596,  1597,   250,   277,  2891,   385,   656,   333,   455,    17,
      18,   337,  1608,    66,    59,   640,   602,   361,   344,   192,
     386,   434,    24,   389,   166,   386,   535,   640,   389,   408,
    1626,   656,  1558,    17,    18,  1631,   365,   371,   386,   486,
     654,   389,  2891,   656,  1640,   283,  1642,   470,   221,  1582,
    2716,    17,    18,    17,    18,    17,    18,   562,   291,    17,
      18,  4548,  4549,   636,    13,  1591,   387,  2969,   654,    17,
      18,  1597,  2816,   640,    42,   526,   146,  2876,   401,   223,
     386,  3814,   166,   389,   589,   558,   415,   640,  2876,   656,
     129,  4005,   608,   640,   520,   521,    13,   523,   656,   525,
     426,   277,   655,  3143,   386,   150,   408,   389,   617,   656,
      17,    18,   564,   387,   540,   654,   386,   540,   291,   389,
     386,  4093,   654,   389,  2648,   388,   449,  2455,   541,   580,
     564,   369,  4062,   512,  1730,  1731,  2869,   386,   371,   387,
     389,  4150,     9,   380,    26,    22,   486,   554,    17,    18,
     294,   558,   640,   192,   367,   602,  2235,  2343,   484,    36,
     173,  2240,  3288,   640,   654,    32,  4475,   655,  2384,  4478,
     138,   622,   174,    50,  2253,   386,  2556,   640,   389,   656,
      17,    18,   221,   563,    61,    62,   491,    17,    18,    17,
      18,   173,   231,   656,   233,  1791,   386,   146,   371,   389,
    1844,    83,   654,   386,   213,   258,   389,   654,  2287,   291,
     512,   387,   386,   133,   386,   389,   376,   389,    17,    18,
     202,   520,   521,   522,   523,   524,   525,    17,    18,   146,
     640,    17,    18,   239,   447,   199,   659,  1833,  1834,   640,
    2456,   540,   662,   640,   404,  1841,   656,  1843,  1844,   253,
    4164,  4165,   291,   587,  2456,   656,  3055,   263,  3597,   656,
    1856,   649,   650,   651,   652,  1861,   432,  3055,    18,   273,
    1866,    17,    18,  1869,   640,   278,  3799,  2356,   281,   640,
    1876,  1877,   164,  1879,   115,   164,   213,   453,   386,   371,
     656,   389,   640,  1937,   655,    17,    18,  3402,   234,   631,
     626,   183,  1898,    17,    18,  1901,  2686,   655,  1834,  1905,
     363,  1955,   455,  2693,   654,  2493,   642,   502,   658,  1852,
     365,   817,  3845,   489,   656,  4634,  1922,  1923,  1924,  1925,
    1926,  3143,   371,   656,   640,   554,    17,    18,   239,   558,
    1936,  1937,   173,    17,    18,   518,  1942,  1943,  1944,   655,
    1876,  1877,   386,  1879,   587,   389,    17,    18,   640,  1955,
     242,  3343,   386,   242,    40,   389,  4375,  4376,    17,    18,
     640,   202,    48,   655,   640,  1901,  1972,  3482,   386,  1905,
    2888,   389,    17,    18,   129,   655,   431,  1920,   433,   655,
     239,   640,  2936,    17,    18,    17,    18,  1993,  1924,  1925,
      17,    18,   386,   622,   564,   389,   655,  4321,  4322,   631,
     596,   234,    17,    18,   587,   600,  1942,  1943,  1944,   239,
     386,   917,   386,   389,   386,   389,   429,   389,   386,   640,
      83,   389,   213,  2936,   656,    17,    18,  2033,   386,   321,
     231,   389,   233,  2967,   655,    17,    18,   192,  3162,  3351,
     640,  4460,   554,  2049,  4322,  1988,   558,   640,   643,   609,
    2056,   609,   129,    17,    18,   655,   640,   381,   640,   655,
    2066,  2067,   655,  2069,  2070,   528,   221,  3191,  3192,   386,
     362,   655,   389,   655,    26,   648,   368,   129,   474,   368,
    2947,   544,   655,   616,  2066,  2067,   619,  3230,  3212,    17,
      18,    61,    62,   605,   585,   655,   656,  2033,   656,    17,
      18,  3876,    20,    73,   662,  3314,  4430,   386,    17,    18,
     389,  4044,  4045,  4046,    18,   192,  1063,  1064,   609,   143,
    2056,  4445,  2128,  3701,  3702,  3900,    60,    83,    17,    18,
     141,    83,   640,  2871,   158,  2078,   291,  2191,   587,   386,
     192,   199,   389,  2197,  2087,  2088,   386,   655,   386,   389,
    3236,   389,    81,  3362,  3240,  2098,  2099,  2100,  2101,   555,
    2103,  2104,  1109,   250,  3362,   561,   648,    18,   231,   221,
     233,    49,  2226,   655,   637,   364,   365,   386,   419,   614,
     389,    17,    18,  2189,  2238,  2191,   386,   494,  4512,   389,
     386,  2197,  4464,   389,  4466,   567,   640,  2203,  1008,   262,
    2206,   655,   656,  2891,  1014,  1015,   640,  1339,   164,   605,
    1342,   655,  4536,  1345,   291,   505,   371,  2843,  2844,  2845,
    2226,   655,   640,   505,  4548,  4549,   622,    83,   655,   656,
     386,   183,  2238,   389,   294,   199,   660,   655,   752,   291,
     149,   129,   558,   147,   655,   656,   640,   539,   182,  2822,
     539,   655,   186,   561,   386,   655,   656,   389,  4536,   662,
     774,   655,   386,   197,   640,   389,   640,   196,   640,  2895,
    2896,  2897,   640,   787,   788,    13,   383,   185,  2332,   655,
     105,  3424,   640,  2895,  2896,  2897,   242,   655,   655,   656,
     242,  4615,  4224,   603,   371,   386,   147,   655,   389,   655,
     656,  4625,   386,   558,   192,   389,    44,   594,  2362,   526,
     239,   614,   615,   654,   617,   386,   619,   558,   389,   371,
     655,   656,  2811,   640,   160,   575,  2332,   386,   615,   616,
     389,   196,   624,   221,   263,   624,   655,   656,   655,   580,
       6,   386,   654,  4667,   389,  4669,   655,   656,   654,    33,
     654,  2357,   386,  3143,   386,   389,  2362,   389,   243,   386,
      98,   640,   389,   115,   656,   103,   654,   656,   654,   321,
    4694,   386,   656,  3307,   389,   260,   655,  3501,  2384,   654,
    4704,   622,  4706,  3804,  4708,  3804,   242,   272,   654,  4667,
     654,  4669,  3346,   640,   386,   329,   654,   389,  4722,   564,
     640,    85,   640,   291,   386,  4729,   362,   389,   655,   654,
     362,   654,   368,  2419,   662,   655,   368,   655,   243,  3628,
    4744,  4745,   386,   655,   656,   389,  4704,   654,   115,   654,
    3628,   640,   587,  3346,   654,   260,  4760,  4761,  2444,   343,
     640,  4765,  2448,   654,   640,  3033,   655,   272,   654,  2455,
    2456,   297,  3528,   299,   300,   655,   364,   365,   386,   655,
     654,   389,   370,  2469,   654,  2471,  4744,  4745,   386,   315,
     654,   389,   224,   654,  4556,  4555,   160,   386,    17,    18,
     389,   654,   438,   371,   640,   655,   656,  2493,   417,  2543,
    2544,   654,   343,  2499,   428,  2501,  2502,   386,   539,   655,
     389,  4201,  4202,   654,  4253,   654,   362,   654,   640,   654,
     587,  3720,   368,  3027,   201,   654,   640,   255,   655,   656,
     115,  2527,  3720,   655,  4457,  3039,  2469,  3041,  3042,   354,
    2536,   655,   654,  2539,  3013,   587,   654,  2543,  2544,  3053,
     655,   656,  3021,   299,   300,  3569,   655,   656,   654,   640,
     386,   129,   239,   389,   132,   654,   640,  2539,   654,   315,
    4075,  4076,   655,   656,   655,   655,   656,   655,   656,   640,
     178,   655,   129,    34,   654,   132,   655,   656,   173,    61,
      62,   640,   438,   539,   655,   470,    86,   539,    88,   486,
     655,   656,   330,   497,   498,   640,   655,    20,   444,   445,
     287,   655,   656,   655,    27,   654,   640,   202,   640,   609,
     655,   655,   656,   640,   192,   655,   656,   654,  4223,   654,
     147,   655,  2628,   655,   654,   640,   655,   656,   655,   655,
     656,   654,   132,  3930,   654,   192,   592,  2643,   654,   567,
     655,   393,   654,   221,   239,   470,   497,   498,   640,  4349,
      73,  2657,   404,  4353,   154,   540,   654,   395,   640,   411,
      83,   655,   656,   655,   221,   655,   656,   654,   624,   655,
     656,    38,   624,   655,   582,   654,   640,   654,   567,   655,
     656,  3978,   654,   539,   655,   656,   147,   654,   444,   445,
     598,   191,   287,   654,  3320,   655,   656,   655,   656,   587,
     656,   654,   389,  2709,  2710,  2711,    20,   654,  3320,   132,
     654,  3200,   640,   291,   654,   540,   613,   614,  2661,  2662,
     418,  2664,   640,  2666,  2667,  2668,  2669,  2670,  2671,  2672,
     414,   640,  2675,   654,   291,  2678,   592,   712,   713,  2682,
     654,   645,   646,   647,   648,   649,   650,   651,   652,   129,
     474,   640,   436,   654,  3342,   122,   654,   654,   510,   655,
     656,   654,   129,  3252,   654,   147,   129,   655,   624,   132,
     384,   655,   656,  2709,  2710,  2711,   514,  1877,  3552,  1879,
     654,   486,   205,   654,   471,   655,   656,  4719,   472,   494,
     654,   105,   253,   371,   645,   646,   647,   648,   649,   650,
     651,   652,   105,   554,   640,   492,   654,    65,   231,   654,
     233,   786,   192,   551,   371,   276,   343,   654,   185,   414,
    4520,  4521,   654,    81,   419,   192,   655,   656,   515,   192,
    2836,   654,  2838,   129,   654,    93,  2842,  2843,  2844,  2845,
     263,   221,  1942,  1943,  1944,  2851,   654,   531,   162,   655,
     656,   654,   166,   605,   221,   222,  3077,   654,   221,   655,
     656,   654,    36,   654,  2870,  2871,   654,  4053,   555,  4801,
    2876,   846,   655,   656,   655,   656,   471,   655,   656,   655,
     656,   195,   343,   197,  3105,  2891,   655,   656,    62,  2895,
    2896,  2897,   655,   656,    36,   395,   192,   492,    65,   213,
     655,   656,  2908,   364,   365,   219,   654,   211,   613,   614,
     597,   291,   655,   656,    81,  2851,  3430,   654,   605,   129,
     654,   235,   132,   377,   291,   221,    93,    69,   291,   243,
     655,   656,   655,   656,   575,  2941,   250,   377,   196,   439,
     243,   364,   365,   201,   656,   119,   260,   370,   122,   654,
    3538,   235,  4095,   512,   377,   655,   130,   260,   272,    51,
     555,   343,   288,   277,  3738,  2908,   561,  3741,  3742,   272,
     497,   498,   286,    20,   148,   655,   656,  2983,  2984,    51,
     441,   239,   192,   656,  3758,   580,    81,   384,   355,   377,
    3044,   371,   199,   129,   417,   291,   132,   139,   377,   366,
     655,   656,   147,   370,   371,   263,  3012,   480,   371,   587,
     605,   221,  3024,  4222,   318,   319,  3022,  3023,  3030,   323,
     324,   596,   164,  3029,  4222,   649,   168,   622,   494,   196,
     587,   662,    83,   662,   201,   505,   497,   498,  3044,  3045,
     354,   172,  3054,   654,  3050,   277,    97,  2983,  3060,  3055,
     197,   354,   513,   554,  3066,  3067,   192,  3991,   105,  3065,
     156,   157,   204,   377,   655,   656,   535,   490,   147,  3846,
    3847,  3077,   239,   387,   377,   371,  1051,   251,  3084,  3085,
     512,   291,  4225,   225,  3090,   221,  1209,  1210,  3031,  3032,
    3096,  3326,  3327,   535,  3100,   288,   263,   163,   240,  3105,
     197,   196,  3607,  3608,  4128,   419,  3679,    92,   253,   656,
    4134,  3281,  3282,   656,  3096,   162,  3059,   378,   655,   166,
     647,   648,   649,   650,   651,   652,   550,   162,   132,  3065,
      36,   118,  3954,  3955,     6,  3141,   661,  3802,  3803,   654,
     117,  2074,  2075,   401,   239,  3967,   288,  3090,     4,   485,
     197,  3157,  3974,   253,  4297,   291,   470,   622,  2091,   417,
     656,   371,   401,    69,    58,   447,   213,   470,   263,   178,
     118,   313,   219,   232,   597,  2108,  2109,   232,  4000,  4001,
     494,   656,   356,   105,   645,   646,   647,   648,   649,   650,
     651,   652,   656,  3414,   662,    73,   243,   564,   343,    13,
     628,   568,   655,   250,   571,  3148,   655,   587,   146,    10,
     656,   662,   655,   260,   265,   582,   655,   655,   662,   654,
     587,   662,   276,   590,   587,   272,   540,  3448,   377,   656,
     277,   164,   661,   139,  4377,   371,   656,   540,  3459,   286,
    3246,  3462,  2175,  2176,  2177,  2178,   288,   288,  3254,   288,
     417,   288,    51,   656,   288,   288,   656,   515,   164,   166,
    4469,  3926,   168,   554,   343,   647,   648,   649,   650,   651,
     652,  4469,   230,   654,   402,  3329,   418,   283,   656,   656,
     647,   648,   596,   575,   656,   427,   575,   401,  3294,   166,
     341,   587,   656,   197,   608,   609,  3884,  3870,   204,   656,
     442,   656,    73,   656,   535,   649,   401,   354,  3314,  3315,
     253,  3254,  3318,   254,  3320,   629,   367,   631,   460,   225,
     187,   243,   417,  3329,   552,   656,   197,   172,   502,  3335,
     377,   535,   509,   406,   240,   142,  3342,  3343,   260,   597,
     387,   655,   656,   166,   656,   659,   660,   377,   515,   405,
     272,   656,   497,   498,  4272,   655,  3362,   603,     7,   635,
     608,   656,   504,   199,   199,   507,   649,   190,   655,   655,
     655,  3377,   419,  3427,   655,   655,   655,   587,  3384,   430,
     203,   655,   288,   655,   648,  4571,  3398,   656,   654,  4008,
    4414,   656,   215,   535,   656,   655,   655,   571,   655,  3405,
     655,   655,   655,   655,   655,  3348,   596,   313,  3414,   495,
    4344,  3417,   554,   654,   654,   557,   558,   652,   497,   498,
     654,  3427,   655,   470,   564,  3431,   600,  3433,  3434,  4363,
     597,   656,   354,   629,  4099,  4100,   575,  4102,  4103,   564,
     564,  3447,  3448,   266,   241,   268,   654,   494,  3384,    12,
      38,   587,   546,  3459,   656,   377,  3462,   654,    13,   211,
    4057,   199,   656,   662,   606,   654,   654,   662,   274,   656,
     656,   662,   295,   199,    27,   526,   655,   662,   176,   475,
    3486,   427,   601,  3489,   656,  3428,    57,  3541,  3494,   494,
     656,   656,   197,   540,  3437,  4681,    67,    49,   202,   352,
     645,   646,   647,   648,   649,   650,   651,   652,   526,   526,
    3516,    82,   418,   526,   526,   526,   485,   197,   450,   654,
      73,   427,   166,    94,    95,    96,   166,   166,   166,   166,
      83,   166,   166,   166,   122,  3541,   442,   166,   361,   166,
     166,   129,   113,   166,   166,   166,   166,   166,   470,   596,
     166,   166,   166,  3489,   460,   166,   166,   656,  4582,  4583,
     603,  4585,   609,  3506,   287,  4774,   645,   646,   647,   648,
     649,   650,   651,   652,   377,   377,  4774,   377,  4787,   132,
     609,    62,   629,  4792,   631,   662,   655,   160,  4797,  4787,
     655,  3645,   249,   416,  4792,   249,   656,   185,   504,  4797,
     662,   507,   655,   655,   192,   655,   655,   655,   655,   656,
     655,   655,   659,   660,     7,   166,   656,  3623,   540,   575,
     575,  4645,  3628,  4647,  4648,   575,   662,   564,   656,   535,
     662,   283,    89,   221,   222,   636,    49,   166,   119,  3645,
     654,   122,   166,   384,  4241,   575,   654,   654,   250,   130,
    2583,   557,   654,  2586,  2587,   199,  2589,   199,   199,  2592,
    2593,   199,   147,  2596,   564,   564,   257,   148,  2601,   432,
     656,   176,   371,  2606,  2607,  2608,  2609,  2610,   231,   260,
     233,  2614,  2615,  3689,  2617,   260,   334,   390,   654,   118,
    2623,  2624,  2625,  2626,   118,    81,  2629,  2630,   142,  2632,
     606,   401,  3708,   291,   401,   401,  3712,   575,   555,    83,
     263,   261,   193,   261,  3720,  4739,   401,  4756,  3724,   142,
    3726,   555,    27,    97,    29,   401,  4394,    49,   401,   403,
     401,   401,   401,   575,    17,    18,   654,   654,   654,   213,
     383,     6,  3685,   564,   649,   654,   654,    12,   662,    14,
     251,    16,   251,   655,   655,   432,    61,    62,  2691,    64,
    3814,   332,    27,   655,    29,   655,   140,   355,    73,   654,
     251,   662,   656,   656,   655,   655,   655,   384,    83,   350,
     655,   654,   370,   371,   649,  3791,    91,   377,  3794,   235,
     656,   655,   278,   401,    59,  3801,  3802,  3803,  3804,    64,
      65,   656,   349,   655,   662,   199,    71,   602,  3814,   655,
     253,   364,   365,   118,   655,   432,   166,   370,    83,   166,
     167,   260,   260,  4396,   377,   656,    91,   132,   656,   654,
     135,   401,  3886,   263,   466,   263,   101,   415,   662,    83,
     123,   124,   125,   126,   127,   377,  4419,   377,    20,    49,
     655,    14,   656,   118,   387,   631,   203,   655,   343,   164,
     654,  4795,   654,    57,   417,   655,   655,   132,   215,   274,
     135,   468,   353,    67,   181,   356,   488,   286,   143,   144,
    3886,   211,   153,  4471,   656,   150,   270,   655,    82,   655,
    3896,   265,   486,   158,   213,   496,   260,   162,   260,   164,
      94,    95,    96,   656,   377,   377,   512,  3913,   655,   256,
     175,   482,   655,   631,   656,   654,   656,   263,   263,   113,
    3926,   268,  3976,   656,   654,  3931,   231,  3939,   233,    87,
     195,  3937,   504,   655,   239,   149,   238,   490,   655,  3945,
     654,   104,   247,   226,   227,   228,   229,   654,   295,   277,
      36,    36,   654,   434,   655,   371,    62,   262,   251,  3902,
     655,   655,   655,   655,   655,   655,   231,   341,   233,   655,
    3976,   542,   237,   136,   239,   340,   564,   265,   147,   427,
     568,   656,   247,   571,    83,    18,  4654,   150,   655,   560,
     364,   365,    91,   367,   582,   384,  4002,   262,   250,   587,
     631,  3937,   590,   654,   662,   655,    49,   219,   340,  4063,
     173,   358,   497,   498,   177,   320,   609,   609,   512,   118,
     656,   286,   481,    20,   654,   132,   189,   132,   656,    36,
     655,   558,   656,   338,  3977,   413,   371,   655,   180,   340,
     143,   654,  4639,   564,   597,   654,  4052,   564,   211,  4055,
     333,   656,   335,   336,   337,   320,   430,  4063,   662,   647,
     648,   344,   564,   558,   263,   164,   655,   654,   613,  4642,
     609,   655,   609,   338,   656,   654,   239,   342,  4084,  4085,
     654,  4749,   317,   246,   253,   654,   654,    15,   655,   394,
     571,   396,   654,  4099,  4100,   654,  4102,  4103,   602,   404,
     619,  3034,   132,   386,   619,    20,   389,   263,  4776,   263,
     370,   530,   176,   631,  3047,   475,  4052,   382,   654,   600,
    4430,   465,   387,   286,   655,    63,   384,   602,   656,   394,
     655,   396,   654,   545,   654,  4445,   401,   466,   332,   404,
     239,   250,   654,   426,  4150,   377,   366,   614,  4721,  4085,
     161,   628,   526,    33,   663,  4161,   350,   655,   371,   176,
    4166,   646,   647,   648,   649,   650,   651,   652,   566,   142,
     435,   476,   142,   164,   343,   654,   419,    75,   197,   197,
      33,   628,    65,   654,   449,   450,   451,   452,   654,  4195,
    4196,   655,  4198,   199,   123,   124,   125,   126,   127,   384,
     483,   484,  4512,    65,   541,   655,   398,  4150,   546,   279,
     655,   476,   440,   654,   656,   655,  4222,   160,   250,   384,
     384,   320,   654,   660,    49,  4798,    49,   532,   533,   534,
      49,    49,   159,    49,   539,   140,   654,   654,   149,   338,
       5,   377,   377,   628,   655,   234,   160,   293,   663,  4255,
     555,  4257,   660,   131,   559,   286,    12,   420,   654,    49,
      49,    49,   155,   362,   136,   660,   602,   532,   533,   534,
     464,    55,   475,   578,   539,   656,   655,   440,   655,   477,
     567,  4287,   216,   160,   656,   448,   656,   660,   482,   655,
     555,   596,   232,   456,   559,   656,   655,   226,   227,   228,
     229,   263,    55,   454,    49,  4615,   197,   197,  4314,   197,
     567,   132,   630,   578,   235,  4625,   371,   198,   583,   494,
     654,  2369,  3799,   486,  4378,   656,  2680,   992,   497,   498,
    4171,   596,  3520,  2572,  1040,  3911,   499,   500,  4266,  4397,
    4598,  1060,  4599,   626,  3913,  3909,  4083,  4776,   542,  4737,
      48,   656,   599,  1935,  1866,   692,  4005,   640,   641,   642,
     697,  2836,  4368,  4746,  4005,  4005,   560,  4005,  4612,  4005,
    4005,  4005,  4378,  4005,  4423,  4005,  4612,  4005,  4384,  4449,
    4005,  4549,  4005,  4448,  4694,  1105,   549,  4005,  1835,  4270,
    4092,  2642,  2121,  1585,  4337,   660,  4706,   734,  4708,  3457,
    2865,  3622,  2870,  3294,   333,  1373,   335,   336,   337,  4368,
    4053,  4473,  4722,  4681,   751,   344,  3625,   580,  4579,  4729,
    4241,  4639,  1623,   631,  3918,  2635,  3370,  3084,  4371,  4372,
     236,  3689,  3087,  3931,  3938,  2643,  4490,  4700,  4419,   602,
     539,   604,  3183,  3749,  4126,  3783,  3987,  4471,  3976,  4455,
    4760,  4761,  3237,  2789,  4460,  4765,   555,  3240,   795,   796,
     797,   798,  2543,  4469,  3232,  4403,    11,    11,  4520,  2199,
     807,  4521,  4340,  4353,  4349,  4198,   645,   646,   647,   648,
     649,   650,   651,   652,  4490,  2707,  4134,  3405,  2642,  3080,
     296,  2513,   298,   299,   300,   301,   302,   426,   304,   305,
     306,   307,   308,   309,   310,   311,   312,  1020,   314,   315,
     316,  3943,    14,  1073,    16,  2439,  1519,  4460,  2128,  1924,
    3707,  4455,  1597,  4577,  3289,  2851,  1619,  2460,  4007,  2412,
    2325,    33,   620,  1949,   941,    37,  3254,  4299,  4481,  4482,
    2234,  2230,  2822,  2528,  3353,  2324,  4078,  4260,  2522,    51,
      52,  4593,  3516,  4594,   483,   484,  2350,    59,   895,  1145,
    3720,  1536,    64,    65,  2941,  3897,  3076,  4721,  3886,  1172,
    2465,  4577,  1356,  2203,  1044,  1044,  1388,  2443,  2406,  3628,
    3309,  3308,  1044,    85,  3362,  4469,   610,  4593,  4594,  1044,
     688,  2028,  2507,  1467,  1640,   598,  2029,   598,  3726,  1855,
    4679,  3292,   104,  4497,  1395,  4589,  4716,  4792,  4797,  3978,
     784,  4617,  3314,  2490,  1425,   597,  3342,  1788,  4624,  3343,
     597,  1975,  2483,  2482,  2476,   591,   128,  1905,   833,  1415,
     921,  4042,  1348,  2455,   136,   137,   138,  1631,   444,   445,
    2838,  4048,   592,   928,   628,   628,    -1,   149,   150,   628,
    1040,    -1,  1040,  1040,    -1,    -1,    -1,    -1,    -1,    -1,
     162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   194,    -1,    -1,    -1,    -1,   626,    -1,  4705,
      -1,    -1,    -1,    -1,  4710,    -1,    -1,   209,    -1,   211,
      -1,    -1,   641,   642,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4783,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4749,   246,    -1,   248,    -1,    -1,  1086,
      -1,    -1,    -1,    -1,  4697,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,    -1,    -1,    -1,    -1,    -1,  4774,    -1,
    4776,    -1,    -1,    -1,    -1,    -1,    -1,  4783,    -1,    -1,
     282,  4787,    -1,    -1,   286,    -1,  4792,  1124,  1125,    -1,
      -1,  4797,    -1,    -1,    -1,    -1,  1133,  1134,  1135,  1136,
    1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1153,  1154,    -1,  1156,
    1157,    -1,    -1,    -1,  1161,    -1,    -1,  1164,  1165,  1166,
    1167,    -1,  1169,  1170,  1171,    -1,    -1,    -1,    -1,    -1,
      -1,  1178,  1179,    -1,  1181,  1182,  1183,  1184,  1185,    -1,
      -1,  1188,  1189,  1190,  1191,  1192,  1193,  1194,  1195,  1196,
    1197,  1198,    -1,  1200,    -1,    -1,  1203,  1204,    -1,    -1,
      -1,  1208,    -1,    -1,    -1,  1212,  1213,  1214,    -1,    -1,
     382,    -1,    -1,    -1,    -1,    -1,    -1,  1224,  1225,  1226,
      -1,    -1,    -1,    -1,    -1,    -1,  1233,   399,    -1,   401,
      -1,    -1,    -1,  1240,  1241,  1242,    -1,  1244,    -1,    -1,
      -1,    -1,   414,    -1,  1251,  1252,  1253,    -1,  1255,  1256,
    1257,  1258,  1259,   425,  1261,  1262,  1263,  1264,  1265,  1266,
    1267,  1268,    -1,    -1,    -1,  1272,  1273,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   447,    -1,    -1,   450,    -1,
     452,    -1,    -1,   455,    -1,    -1,   458,   459,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,    -1,    -1,
     472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   480,    -1,
      -1,    -1,    -1,    -1,   486,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   494,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    29,    -1,
      -1,    -1,    -1,  1360,    -1,    -1,    -1,    -1,    -1,   531,
      -1,    -1,    -1,    -1,    -1,    -1,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      61,    62,    -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,   697,    -1,    -1,    -1,    -1,    -1,    -1,
      91,   583,    -1,    -1,    -1,    -1,    -1,    -1,  1425,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,   599,  1435,    -1,
     602,    -1,    -1,    -1,    -1,    -1,   608,   118,    -1,    -1,
     734,    -1,    -1,    -1,  1451,    -1,    -1,    -1,  1455,    -1,
      -1,   132,    -1,    -1,   135,    -1,    -1,   751,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   638,    -1,    -1,    -1,
      -1,    -1,   644,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   654,   164,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1510,   798,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,   233,    -1,    -1,    -1,    -1,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   262,    -1,    -1,    -1,    -1,    -1,    27,    -1,    29,
      -1,    -1,    -1,    -1,    -1,   276,    -1,    -1,    -1,    -1,
      -1,   895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,    -1,  4232,
    4233,    -1,    -1,  4236,  4237,  4238,  4239,    -1,    -1,   320,
      -1,    -1,    -1,    83,    -1,    -1,  1653,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   394,    -1,   396,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   404,   164,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4338,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1766,
    1767,  1768,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4373,  4374,    -1,    -1,  1781,    -1,    -1,    -1,    -1,  4382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,  1086,   233,    -1,   476,    -1,    -1,    -1,   239,
    1807,    -1,    -1,    -1,    -1,    -1,  1813,   247,    -1,  1816,
      -1,  1818,    -1,    -1,    -1,    -1,    -1,  1824,    -1,  1826,
    1827,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1124,  1125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1133,
    1134,    -1,    -1,  1137,  1138,  1139,  1140,  1141,  1142,  1143,
    1144,   532,   533,   534,    -1,    -1,    -1,    -1,   539,  1153,
    1154,    -1,  1156,  1157,    -1,    -1,    -1,    -1,    -1,    -1,
    1164,  1165,  1166,  1167,   555,    -1,  1170,    -1,   559,    -1,
     320,    -1,    -1,    -1,  1178,  1179,    -1,  1181,  1182,    -1,
      -1,    -1,    -1,    -1,  1188,  1189,  1190,   578,   338,  1193,
    1194,  1195,  1196,  1197,  1198,    -1,  1200,    -1,    -1,  1203,
    1204,    -1,  1919,    -1,  1208,   596,    -1,    -1,  1212,  1213,
    1214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1224,  1225,  1226,    -1,    -1,    -1,    -1,    -1,    -1,  1233,
      14,    -1,    16,    -1,    -1,    -1,  1240,  1241,  1242,    -1,
      -1,    -1,    -1,    -1,   394,    -1,   396,    -1,    -1,    -1,
      -1,    -1,    -1,    37,   404,    -1,  1973,    -1,    -1,    -1,
      -1,    -1,    -1,   654,    -1,  1982,    -1,    51,    52,  1273,
      -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,    -1,    -1,   476,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,   138,    -1,  1360,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   532,   533,   534,    -1,    -1,    -1,    -1,   539,
      -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2121,   555,    -1,    -1,    -1,   559,
     194,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1425,    -1,    -1,    -1,   209,  2143,   211,   578,    -1,
      -1,  1435,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   596,  1451,    -1,    -1,
      -1,  1455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   246,    -1,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2212,    -1,    -1,   282,  2216,
      -1,    -1,   286,    -1,  2221,  2222,  1510,    -1,    -1,    -1,
      -1,    -1,    -1,  2230,    -1,  2232,    -1,  2234,  2235,  2236,
    2237,    -1,    -1,  2240,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2250,    -1,  2252,  2253,    -1,  2255,  2256,
    2257,  2258,    -1,  2260,    -1,    -1,  2263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2272,    -1,    -1,    -1,    -1,
      -1,    -1,  2279,    -1,  2281,    -1,  2283,  2284,    -1,  2286,
    2287,    -1,    -1,    -1,  2291,  2292,  2293,    -1,    -1,    -1,
    2297,  2298,  2299,    -1,  2301,    -1,  2303,    -1,  2305,    -1,
    2307,    -1,  2309,    -1,    -1,    -1,    -1,  2314,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,  2333,   401,    -1,    -1,
      -1,    -1,    -1,  2340,    -1,    -1,  2343,    -1,    -1,    -1,
     414,    -1,  2349,    -1,    -1,  2352,    -1,    -1,    -1,  2356,
      -1,   425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1653,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   447,    -1,    -1,   450,    -1,   452,    -1,
      -1,   455,    -1,    -1,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,
      -1,    -1,   486,  2420,    -1,    -1,    -1,    -1,    -1,    -1,
     494,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,    -1,
      -1,    -1,    -1,    -1,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1766,  1767,  1768,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2491,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   583,
      -1,    -1,    -1,  1807,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   595,  1816,    -1,  1818,   599,    -1,    -1,   602,    -1,
      -1,    -1,    -1,    -1,   608,  2542,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2555,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   638,    -1,  2573,  2574,    -1,    -1,
     644,    13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     654,    -1,    -1,    25,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,
      62,    -1,    -1,    -1,    -1,  1919,    -1,    69,  2635,    -1,
      -1,    -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,    -1,
     102,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,  2684,  2685,  1973,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,   138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2720,    -1,    -1,    -1,  2724,    -1,    -1,
      -1,   163,   164,    -1,    -1,    -1,    -1,   169,    -1,    -1,
     172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2751,  2752,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
     202,    -1,    -1,    -1,  2771,    -1,    -1,    -1,   210,    -1,
     212,    -1,    -1,  2780,    -1,  2782,    -1,  2784,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   238,   239,   240,    -1,
      -1,    -1,    -1,    -1,  2811,    -1,    -1,    -1,    -1,  2816,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   261,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2847,   283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2143,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   313,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2923,    -1,  2212,    -1,
      -1,    -1,  2216,    -1,    -1,    -1,    -1,  2221,  2222,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2230,    -1,  2232,   381,
    2234,    -1,  2236,  2237,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2250,    -1,  2252,    -1,
      -1,  2255,  2256,  2257,  2258,   407,  2260,  2974,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   418,   419,  2272,    -1,
     422,   423,  2989,    -1,    -1,  2279,    -1,  2281,    -1,  2283,
    2284,    -1,  2286,    -1,    -1,    -1,    -1,  2291,  2292,  2293,
      -1,   443,    -1,  2297,  2298,  2299,    -1,  2301,    -1,  2303,
      -1,  2305,    -1,  2307,    -1,  2309,    -1,    -1,    -1,    -1,
    2314,    -1,    -1,    -1,    35,    36,    -1,    -1,    -1,    -1,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    -1,  2333,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   491,
      -1,    62,    -1,    -1,    -1,  2349,    -1,    -1,  2352,    -1,
      -1,    -1,   504,    -1,    -1,    -1,    -1,    -1,    27,    -1,
      29,    -1,    -1,  3080,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3093,  3094,    -1,    -1,
      -1,    -1,    -1,   535,    -1,    -1,    -1,   539,    -1,    -1,
      -1,    -1,    61,    62,    -1,    64,    -1,    -1,   119,    -1,
      -1,   122,    -1,    -1,    73,   557,   558,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,  3142,    -1,   148,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,  3165,   118,
      -1,    -1,    -1,    -1,   606,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   617,   135,    -1,    -1,    -1,
     191,    -1,   193,   625,    -1,    -1,    -1,    -1,    -1,    -1,
    3197,  3198,    -1,  3200,    -1,   206,   207,  2491,    -1,    -1,
       6,    -1,  3209,    -1,    -1,   164,    12,  3214,    14,    -1,
    3217,    -1,  3219,  3220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    27,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     251,    -1,    -1,    -1,    -1,  3252,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   280,
      -1,    -1,   231,    -1,   233,    -1,  3283,    83,   289,   290,
     239,   292,    -1,    -1,    -1,    91,    -1,    -1,   247,    -1,
      -1,    -1,    -1,    -1,    -1,   101,    -1,    -1,    -1,    -1,
      -1,  3308,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   118,    -1,    -1,   326,   327,   328,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,
      -1,    -1,    -1,    -1,   345,   346,   347,   143,    -1,    -1,
      -1,    -1,   353,    -1,   150,   356,    -1,    -1,    -1,    -1,
      -1,    -1,   158,    -1,    -1,    -1,    -1,  3364,   164,    -1,
      -1,   320,   373,   374,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,
      -1,    -1,    -1,    -1,    -1,    -1,  3393,    -1,    -1,   195,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   409,   410,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   434,    -1,   231,  2720,   233,    -1,    -1,
    2724,    -1,    -1,   239,    -1,   394,    -1,   396,    -1,    -1,
      -1,   247,    -1,    -1,    -1,   404,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   262,  2751,  2752,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2771,    -1,   490,
     286,    -1,    -1,   494,    -1,    -1,  2780,    -1,  2782,    -1,
    2784,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   320,    -1,    -1,   476,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   338,    -1,    -1,    -1,   342,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2847,   565,    -1,    -1,   568,    -1,    -1,
     571,   572,   573,   574,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   532,   533,   534,    -1,    -1,    -1,    -1,
     539,   387,    -1,    -1,    -1,    -1,    -1,    -1,   394,    -1,
     396,    -1,    -1,    -1,    -1,    -1,   555,    -1,   404,    -1,
     559,    -1,    -1,    -1,   615,   616,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   578,
      -1,    -1,  3629,    -1,    -1,    -1,    -1,    -1,    -1,  2923,
      -1,   642,    -1,    -1,    -1,    -1,    -1,   596,    -1,    -1,
      -1,    -1,    -1,    -1,   450,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3665,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3673,    -1,    -1,    -1,
     476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2974,    -1,    -1,    -1,    -1,    -1,    -1,  3694,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   532,   533,   534,    -1,
      -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,
      -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3776,
      -1,    -1,   578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3093,
    3094,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3828,    -1,    -1,    -1,  3832,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3867,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3165,    -1,    -1,  3881,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3197,  3198,    -1,    -1,    -1,    -1,    -1,
      -1,  3918,    -1,    -1,    -1,  3209,    -1,    -1,    -1,    -1,
    3214,    -1,    -1,  3217,    -1,  3219,  3220,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4005,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3308,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4053,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4061,    -1,    -1,    -1,    -1,    -1,
    4067,    -1,  4069,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4158,    -1,    -1,    -1,    -1,    -1,  4164,  4165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4197,    -1,    -1,    -1,  4201,  4202,    -1,    -1,    -1,    -1,
      -1,  4208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4246,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4307,    -1,  4309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4319,    -1,  4321,  4322,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4340,    -1,  3629,    -1,    -1,    -1,    -1,
      -1,    -1,  4349,    -1,    -1,    -1,  4353,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3665,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3673,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4405,    -1,
    3694,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4428,    -1,  4430,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4445,  4446,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4463,    -1,    -1,    -1,
      -1,    -1,    -1,  4470,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4512,    -1,    -1,    -1,    -1,
      -1,  4518,    -1,  4520,  4521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4535,  4536,
      -1,    -1,    -1,    -1,  3828,    -1,    -1,    -1,  3832,    -1,
      -1,  4548,  4549,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4571,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3867,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3881,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4615,    -1,
      -1,    -1,    -1,    -1,    -1,  4622,    -1,    -1,  4625,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4660,    -1,    -1,    -1,    -1,    -1,    -1,
    4667,    -1,  4669,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4681,    -1,    -1,  4684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4694,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4704,    -1,  4706,
      -1,  4708,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4722,    -1,    -1,    -1,    -1,
      -1,    -1,  4729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4744,  4745,    -1,
      -1,    -1,    -1,  4750,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4760,  4761,    -1,    -1,    -1,  4765,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4061,    -1,    -1,
      -1,    -1,    -1,  4067,    -1,  4069,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4800,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4208,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4246,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4307,    -1,  4309,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4319,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4428,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4470,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4535,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4622,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4660,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4684,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    47,    48,  4750,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,  4800,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,   269,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,   576,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    13,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,   454,
     455,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,   536,   537,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,   610,   611,   612,   613,   614,
      -1,    -1,   617,   618,    -1,   620,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,
      -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,   199,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,   355,   356,
     357,    -1,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,   536,
     537,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,   564,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,   610,   611,   612,   613,   614,    -1,    -1,
     617,   618,    -1,   620,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,    -1,
     647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,
     657,   658,    -1,    -1,   661,   662,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
     199,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,    -1,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,   372,    -1,   374,   375,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   393,   394,   395,    -1,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,    -1,   418,
      -1,   420,   421,   422,   423,   424,    -1,   426,   427,   428,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,    -1,    -1,   442,   443,   444,   445,   446,    -1,   448,
     449,    -1,   451,   452,   453,   454,   455,   456,    -1,   458,
      -1,   460,   461,    -1,   463,   464,    -1,   466,    -1,   468,
      -1,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,    -1,   484,   485,    -1,    -1,    -1,
     489,   490,   491,   492,    -1,    -1,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,    -1,
     509,   510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,
      -1,    -1,   521,   522,    -1,   524,    -1,    -1,   527,    -1,
      -1,   530,   531,    -1,    -1,    -1,   535,   536,   537,   538,
     539,    -1,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,    -1,   557,    -1,
     559,   560,   561,   562,    -1,   564,   565,   566,    -1,   568,
     569,   570,   571,    -1,    -1,    -1,    -1,    -1,   577,   578,
     579,    -1,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,    -1,   594,   595,    -1,    -1,   598,
      -1,    -1,   601,    -1,   603,    -1,   605,   606,   607,    -1,
      -1,   610,   611,   612,   613,   614,    -1,    -1,   617,   618,
      -1,   620,   621,   622,   623,   624,   625,   626,   627,    -1,
      -1,    -1,    -1,    -1,    -1,   634,   635,    -1,   637,   638,
     639,    -1,    -1,   642,    -1,    -1,    -1,    -1,   647,   648,
      -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,
      -1,    -1,   661,   662,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,   199,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,   454,   455,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,   564,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,   610,
     611,   612,   613,   614,    -1,    -1,   617,   618,    -1,   620,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,
      -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,
     661,   662,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,    -1,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,   454,
     455,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,   536,   537,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,   610,   611,   612,   613,   614,
      -1,    -1,   617,   618,    -1,   620,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,
      -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,
       7,     8,     9,    10,    11,    12,    13,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,   355,   356,
     357,    -1,    -1,   360,   361,   362,   363,   364,    -1,   366,
     367,   368,    -1,   370,   371,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,   536,
     537,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,   564,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,   610,   611,   612,   613,   614,    -1,    -1,
     617,   618,    -1,   620,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,    -1,
     647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,
     657,   658,    -1,    -1,   661,   662,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,    -1,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,   372,    -1,   374,   375,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   393,   394,   395,    -1,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,    -1,   418,
      -1,   420,   421,   422,   423,   424,    -1,   426,   427,   428,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,    -1,    -1,   442,   443,   444,   445,   446,    -1,   448,
     449,    -1,   451,   452,   453,   454,   455,   456,    -1,   458,
      -1,   460,   461,    -1,   463,   464,    -1,   466,    -1,   468,
      -1,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,    -1,   484,   485,    -1,    -1,    -1,
     489,   490,   491,   492,    -1,    -1,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,    -1,
     509,   510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,
      -1,    -1,   521,   522,    -1,   524,    -1,    -1,   527,    -1,
      -1,   530,   531,    -1,    -1,    -1,   535,   536,   537,   538,
     539,    -1,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,    -1,   557,    -1,
     559,   560,   561,   562,    -1,   564,   565,   566,    -1,   568,
     569,   570,   571,    -1,    -1,    -1,    -1,    -1,   577,   578,
     579,    -1,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,    -1,   594,   595,    -1,    -1,   598,
      -1,    -1,   601,    -1,   603,    -1,   605,   606,   607,    -1,
      -1,   610,   611,   612,   613,   614,    -1,    -1,   617,   618,
      -1,   620,   621,   622,   623,   624,   625,   626,   627,    -1,
      -1,    -1,    -1,    -1,    -1,   634,   635,    -1,   637,   638,
     639,    -1,    -1,   642,    -1,    -1,    -1,    -1,   647,   648,
      -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,
      -1,    -1,   661,   662,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,   454,   455,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,   564,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,   610,
     611,   612,   613,   614,    -1,    -1,   617,   618,    -1,   620,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,
      -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,
     661,   662,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,    -1,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,   454,
     455,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,   536,   537,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,   610,   611,   612,   613,   614,
      -1,    -1,   617,   618,    -1,   620,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,
      -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,   355,   356,
     357,    -1,    -1,   360,   361,   362,   363,   364,    -1,   366,
     367,   368,    -1,   370,   371,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,   536,
     537,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,   564,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,   610,   611,   612,   613,   614,    -1,    -1,
     617,   618,    -1,   620,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,    -1,
     647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,
     657,   658,    -1,    -1,   661,   662,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,    -1,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,    -1,   366,   367,   368,
      -1,   370,   371,   372,    -1,   374,   375,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   393,   394,   395,    -1,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,    -1,   418,
      -1,   420,   421,   422,   423,   424,    -1,   426,   427,   428,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,    -1,    -1,   442,   443,   444,   445,   446,    -1,   448,
     449,    -1,   451,   452,   453,   454,   455,   456,    -1,   458,
      -1,   460,   461,    -1,   463,   464,    -1,   466,    -1,   468,
      -1,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,    -1,   484,   485,    -1,    -1,    -1,
     489,   490,   491,   492,    -1,    -1,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,    -1,
     509,   510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,
      -1,    -1,   521,   522,    -1,   524,    -1,    -1,   527,    -1,
      -1,   530,   531,    -1,    -1,    -1,   535,   536,   537,   538,
     539,    -1,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,    -1,   557,    -1,
     559,   560,   561,   562,    -1,   564,   565,   566,    -1,   568,
     569,   570,   571,    -1,    -1,    -1,    -1,    -1,   577,   578,
     579,    -1,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,    -1,   594,   595,    -1,    -1,   598,
      -1,    -1,   601,    -1,   603,    -1,   605,   606,   607,    -1,
      -1,   610,   611,   612,   613,   614,    -1,    -1,   617,   618,
      -1,   620,   621,   622,   623,   624,   625,   626,   627,    -1,
      -1,    -1,    -1,    -1,    -1,   634,   635,    -1,   637,   638,
     639,    -1,    -1,   642,    -1,    -1,    -1,    -1,   647,   648,
      -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,
      -1,    -1,   661,   662,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,    -1,   366,   367,   368,    -1,   370,
     371,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,   454,   455,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,   564,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,   610,
     611,   612,   613,   614,    -1,    -1,   617,   618,    -1,   620,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,
      -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,
     661,   662,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,    -1,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,    -1,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    38,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,   183,    -1,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,    -1,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,    -1,
      -1,    -1,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,    -1,
      -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,    -1,    -1,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,   551,   552,    -1,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,    -1,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,   661,   662,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    93,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,   263,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,   276,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
      -1,    -1,   356,   357,    -1,    -1,   360,   361,   362,   363,
      -1,    -1,    -1,   367,   368,    -1,    -1,    -1,   372,    -1,
     374,   375,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,    -1,
     414,   415,   416,    -1,   418,    -1,   420,   421,   422,   423,
     424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,    -1,    -1,   442,   443,
     444,   445,   446,    -1,   448,   449,    -1,   451,   452,   453,
      -1,    -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,    -1,
     484,   485,   486,    -1,    -1,   489,   490,   491,   492,    -1,
      -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,    -1,   509,   510,   511,   512,   513,
     514,   515,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,
     524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,
      -1,   535,    -1,    -1,   538,   539,    -1,   541,   542,   543,
     544,   545,   546,    -1,    -1,   549,   550,   551,   552,    -1,
     554,   555,    -1,   557,    -1,   559,   560,   561,   562,    -1,
      -1,   565,   566,    -1,   568,   569,   570,   571,    -1,    -1,
      -1,    -1,    -1,   577,   578,   579,    -1,    -1,    -1,   583,
     584,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
     594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,
      -1,   605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,
     614,    -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,
     624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,
     634,   635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,   183,    -1,
      -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,    -1,
      -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,   263,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,    -1,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
      -1,   356,   357,    -1,    -1,   360,   361,   362,   363,    -1,
      -1,    -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,    -1,
      -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
     515,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,    -1,    -1,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,   551,   552,    -1,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,
     585,   586,    -1,   588,   589,    -1,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,    -1,    -1,
     356,   357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,
      -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,    -1,   414,   415,
     416,    -1,   418,    -1,   420,   421,   422,   423,   424,    -1,
     426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   442,   443,   444,   445,
     446,    -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,
     456,    -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,
     466,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,    -1,   484,   485,
     486,    -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,
     496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,    -1,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,
      -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,
      -1,    -1,   538,   539,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,   551,   552,    -1,   554,   555,
      -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,   565,
     566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,
      -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,   594,   595,
      -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,
      -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,   625,
     626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,
      -1,   637,   638,   639,    -1,    -1,   642,    -1,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,   655,
      -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,
     187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,
     247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,    -1,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,    -1,   340,    -1,   342,    -1,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,    -1,   356,
     357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,    -1,
     367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
      -1,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,    -1,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,    -1,
      -1,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,   551,   552,    -1,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,    -1,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,    -1,    -1,   583,   584,   585,   586,
      -1,   588,   589,    -1,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,    -1,
     617,    -1,    -1,    -1,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,   655,    15,
      -1,    -1,    -1,    19,   661,   662,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,    -1,    -1,
     356,   357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,
      -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,    -1,   414,   415,
     416,    -1,   418,    -1,   420,   421,   422,   423,   424,    -1,
     426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   442,   443,   444,   445,
     446,    -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,
     456,    -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,
     466,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,    -1,   484,   485,
      -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,
     496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,    -1,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,
      -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,
      -1,    -1,   538,   539,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,   551,   552,    -1,   554,   555,
      -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,   565,
     566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,
      -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,   594,   595,
      -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,
      -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,   625,
     626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,
      -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    12,   654,    -1,
      15,    -1,    -1,    -1,    19,    -1,   662,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,   183,    -1,
      -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,    -1,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
      -1,   356,   357,    -1,    -1,   360,   361,   362,   363,    -1,
      -1,    -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,    -1,
      -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,    -1,    -1,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,   551,   552,    -1,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,
     585,   586,    -1,   588,   589,    -1,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,    -1,    -1,
     356,   357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,
      -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,    -1,   414,   415,
     416,    -1,   418,    -1,   420,   421,   422,   423,   424,    -1,
     426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   442,   443,   444,   445,
     446,    -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,
     456,    -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,
     466,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,    -1,   484,   485,
      -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,
     496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,    -1,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,
      -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,
      -1,    -1,   538,   539,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,   551,   552,    -1,   554,   555,
      -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,   565,
     566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,
      -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,   594,   595,
      -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,
      -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,   625,
     626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,
      -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,
      -1,    -1,    -1,   649,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,   662,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
      -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,
     111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,
      -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,
      -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,    -1,    -1,   180,
     181,   182,   183,    -1,    -1,   186,   187,    -1,   189,   190,
     191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,
      -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,    -1,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287