/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpUtil;

public class JakartaRegexpMatcher
implements RegexpMatcher {
    private String pattern;

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    protected RE getCompiledPattern(int options) throws BuildException {
        int cOptions = this.getCompilerOptions(options);
        try {
            void e;
            RE reg = new RE(this.pattern);
            reg.setMatchFlags(cOptions);
            return e;
        }
        catch (RESyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean matches(String argument) throws BuildException {
        return this.matches(argument, 0);
    }

    public boolean matches(String input, int options) throws BuildException {
        return this.matches(input, this.getCompiledPattern(options));
    }

    private boolean matches(String input, RE reg) {
        return reg.match(input);
    }

    public Vector getGroups(String argument) throws BuildException {
        return this.getGroups(argument, 0);
    }

    public Vector getGroups(String input, int options) throws BuildException {
        RE reg = this.getCompiledPattern(options);
        if (!this.matches(input, reg)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int cnt = reg.getParenCount();
        int i = 0;
        while (i < cnt) {
            v.addElement(reg.getParen(i));
            ++i;
        }
        return v;
    }

    protected int getCompilerOptions(int options) {
        int cOptions = 0;
        if (RegexpUtil.hasFlag((int)options, (int)256)) {
            cOptions |= 1;
        }
        if (RegexpUtil.hasFlag((int)options, (int)4096)) {
            cOptions |= 2;
        }
        if (RegexpUtil.hasFlag((int)options, (int)65536)) {
            cOptions |= 4;
        }
        return cOptions;
    }
}

