/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.trax;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XTwice {
    public static void main(String[] args) {
        Transformer transformer = null;
        System.setProperty("javax.xml.transform.TransformerFactory", "com.jclark.xsl.trax.TransformerFactoryImpl");
        SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        Vector<String> params = new Vector<String>();
        int nArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            int k = args[i].indexOf(61);
            if (k > 0) {
                params.add(args[i]);
                continue;
            }
            args[nArgs++] = args[i];
        }
        if (nArgs != 2 && nArgs != 3) {
            System.err.println("usage: java com.jclark.xsl.trax.XTwice source stylesheet [result] [param=value]...");
            System.exit(1);
        }
        boolean succeeded = true;
        File in = new File(args[0]);
        File stylesheet = new File(args[1]);
        StreamSource styleSource = new StreamSource(stylesheet);
        try {
            transformer = factory.newTransformer(styleSource);
        }
        catch (TransformerConfigurationException ex) {
            System.err.println("unable to build transformer");
            ex.printStackTrace();
            System.exit(1);
        }
        for (int i = params.size() - 1; i >= 0; --i) {
            String paramArg = (String)params.elementAt(i);
            int k = paramArg.indexOf(61);
            transformer.setParameter(paramArg.substring(0, k), paramArg.substring(k + 1));
        }
        if (!in.isDirectory()) {
            StreamSource inputStreamSource = new StreamSource(in);
            StreamResult outputStreamResult = null;
            if (nArgs == 3) {
                try {
                    FileOutputStream fo = new FileOutputStream(new File(args[2]));
                    outputStreamResult = new StreamResult(fo);
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Output file " + args[2] + " not found");
                    System.exit(1);
                }
            } else {
                outputStreamResult = new StreamResult(System.out);
            }
            try {
                transformer.transform(inputStreamSource, outputStreamResult);
            }
            catch (TransformerException ex) {
                System.err.println("unrecoverable TransformerException");
                ex.printStackTrace();
            }
        } else {
            System.out.println("I don't transform directories");
        }
        if (!succeeded) {
            System.exit(1);
        }
    }

    static void printSAXParseException(SAXParseException e) {
        String systemId = e.getSystemId();
        int lineNumber = e.getLineNumber();
        if (systemId != null) {
            System.err.print(systemId + ":");
        }
        if (lineNumber >= 0) {
            System.err.print(lineNumber + ":");
        }
        if (systemId != null || lineNumber >= 0) {
            System.err.print(" ");
        }
        System.err.println(e.getMessage());
    }

    static class ErrorHandlerImpl
    implements ErrorHandler {
        ErrorHandlerImpl() {
        }

        public void warning(SAXParseException e) {
            XTwice.printSAXParseException(e);
        }

        public void error(SAXParseException e) {
            XTwice.printSAXParseException(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

