/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax2.RawCharactersHandler;
import com.jclark.xsl.sax2.ResultBase;
import com.jclark.xsl.tr.OutputMethod;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OutputMethodDefaulter
implements ContentHandler,
CommentHandler,
RawCharactersHandler {
    private final ResultBase _result;
    private final OutputMethod _outputMethod;
    private final Vector _savedEvents = new Vector();
    private Locator _locator;

    OutputMethodDefaulter(ResultBase result, OutputMethod outputMethod) {
        this._result = result;
        this._outputMethod = outputMethod;
    }

    public void startDocument() {
    }

    public void endDocument() throws SAXException {
        this.getContentHandler(false).endDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.getContentHandler(qName.equalsIgnoreCase("html") && atts.getValue("xmlns") == null).startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        throw new Error("unbalanced call to endElement");
    }

    public void characters(char[] buf, int off, int len) throws SAXException {
        block3: for (int i = 0; i < len; ++i) {
            switch (buf[off + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.getContentHandler(false).characters(buf, off, len);
                    return;
                }
            }
        }
        this._savedEvents.addElement(new CharactersEvent(buf, off, len));
    }

    public void ignorableWhitespace(char[] buf, int off, int len) throws SAXException {
        this._savedEvents.addElement(new IgnorableWhitespaceEvent(buf, off, len));
    }

    public void processingInstruction(String target, String content) {
        this._savedEvents.addElement(new ProcessingInstructionEvent(target, content));
    }

    public void setDocumentLocator(Locator loc) {
        this._locator = loc;
    }

    public void startPrefixMapping(String prefix, String namespace) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
    }

    public void comment(String content) {
        this._savedEvents.addElement(new CommentEvent(content));
    }

    public void rawCharacters(String chars) {
        this._savedEvents.addElement(new RawCharactersEvent(chars));
    }

    private ContentHandler getContentHandler(boolean isHtml) throws SAXException {
        Name name = this._outputMethod.getNameTable().createName(isHtml ? "html" : "xml");
        try {
            ContentHandler handler = this._result.setOutputMethod(name, this._outputMethod);
            if (this._locator != null) {
                handler.setDocumentLocator(this._locator);
            }
            handler.startDocument();
            Enumeration iter = this._savedEvents.elements();
            while (iter.hasMoreElements()) {
                ((Event)iter.nextElement()).emit(handler);
            }
            return handler;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    static class IgnorableWhitespaceEvent
    extends Event {
        private char[] buf;

        IgnorableWhitespaceEvent(char[] b, int off, int len) {
            this.buf = new char[len];
            System.arraycopy(b, off, this.buf, 0, len);
        }

        void emit(ContentHandler handler) throws SAXException {
            handler.ignorableWhitespace(this.buf, 0, this.buf.length);
        }
    }

    static class CharactersEvent
    extends Event {
        private char[] buf;

        CharactersEvent(char[] b, int off, int len) {
            this.buf = new char[len];
            System.arraycopy(b, off, this.buf, 0, len);
        }

        void emit(ContentHandler handler) throws SAXException {
            handler.characters(this.buf, 0, this.buf.length);
        }
    }

    static class RawCharactersEvent
    extends Event {
        private String chars;

        RawCharactersEvent(String chars) {
            this.chars = chars;
        }

        void emit(ContentHandler handler) throws SAXException {
            if (handler instanceof RawCharactersHandler) {
                ((RawCharactersHandler)((Object)handler)).rawCharacters(this.chars);
            } else {
                char[] buf = this.chars.toCharArray();
                handler.characters(buf, 0, buf.length);
            }
        }
    }

    static class CommentEvent
    extends Event {
        private String content;

        CommentEvent(String content) {
            this.content = content;
        }

        void emit(ContentHandler handler) throws SAXException {
            if (handler instanceof CommentHandler) {
                ((CommentHandler)((Object)handler)).comment(this.content);
            }
        }
    }

    static class ProcessingInstructionEvent
    extends Event {
        private String target;
        private String content;

        ProcessingInstructionEvent(String target, String content) {
            this.target = target;
            this.content = content;
        }

        void emit(ContentHandler handler) throws SAXException {
            handler.processingInstruction(this.target, this.content);
        }
    }

    static abstract class Event {
        Event() {
        }

        abstract void emit(ContentHandler var1) throws SAXException;
    }
}

