/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleBooleanExpr;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

class EncodeURIFunction
implements Function {
    static BitSet dontNeedEncodingRFC2396;
    static BitSet dontNeedEncodingRFC2732;
    static final int caseDiff = 32;
    static String dfltEncName;

    EncodeURIFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length < 2 || args.length > 3) {
            throw new ParseException("expected 2 or 3 arguments");
        }
        final ConvertibleStringExpr se = args[0].makeStringExpr();
        final ConvertibleBooleanExpr se2 = args[1].makeBooleanExpr();
        final ConvertibleStringExpr se3 = args.length == 2 ? new LiteralExpr("") : args[2].makeStringExpr();
        return new ConvertibleStringExpr(){

            public String eval(Node node, ExprContext context) throws XSLException {
                return EncodeURIFunction.encodeURI(se.eval(node, context), se2.eval(node, context), se3.eval(node, context));
            }
        };
    }

    private static final String encodeURI(String s, boolean encodeURISubset, String enc) {
        try {
            if ("".equals(enc)) {
                enc = dfltEncName;
            }
            boolean needToChange = false;
            boolean wroteUnencodedChar = false;
            int maxBytesPerChar = 10;
            StringBuffer out = new StringBuffer(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, enc);
            for (int i = 0; i < s.length(); ++i) {
                int c = s.charAt(i);
                if (EncodeURIFunction.dontNeedEncoding(c, encodeURISubset)) {
                    if (c == 32) {
                        c = 43;
                        needToChange = true;
                    }
                    out.append((char)c);
                    wroteUnencodedChar = true;
                    continue;
                }
                try {
                    char d;
                    if (wroteUnencodedChar) {
                        writer = new OutputStreamWriter((OutputStream)buf, enc);
                        wroteUnencodedChar = false;
                    }
                    writer.write(c);
                    if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                        writer.write(d);
                        ++i;
                    }
                    writer.flush();
                }
                catch (IOException e) {
                    buf.reset();
                    continue;
                }
                byte[] ba = buf.toByteArray();
                for (int j = 0; j < ba.length; ++j) {
                    out.append('%');
                    char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    out.append(ch);
                    ch = Character.forDigit(ba[j] & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    out.append(ch);
                }
                buf.reset();
                needToChange = true;
            }
            return needToChange ? out.toString() : s;
        }
        catch (UnsupportedEncodingException uex) {
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static final boolean dontNeedEncoding(int c, boolean encodeURISubset) {
        return encodeURISubset ? dontNeedEncodingRFC2396.get(c) : dontNeedEncodingRFC2396.get(c) || dontNeedEncodingRFC2732.get(c);
    }

    static {
        int i;
        dfltEncName = "UTF-8";
        dontNeedEncodingRFC2396 = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncodingRFC2396.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncodingRFC2396.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncodingRFC2396.set(i);
        }
        dontNeedEncodingRFC2396.set(32);
        dontNeedEncodingRFC2396.set(45);
        dontNeedEncodingRFC2396.set(95);
        dontNeedEncodingRFC2396.set(46);
        dontNeedEncodingRFC2396.set(42);
        dontNeedEncodingRFC2732 = new BitSet(256);
        dontNeedEncodingRFC2732.set(59);
        dontNeedEncodingRFC2732.set(47);
        dontNeedEncodingRFC2732.set(63);
        dontNeedEncodingRFC2732.set(58);
        dontNeedEncodingRFC2732.set(64);
        dontNeedEncodingRFC2732.set(38);
        dontNeedEncodingRFC2732.set(61);
        dontNeedEncodingRFC2732.set(43);
        dontNeedEncodingRFC2732.set(36);
        dontNeedEncodingRFC2732.set(44);
        dontNeedEncodingRFC2732.set(91);
        dontNeedEncodingRFC2732.set(93);
    }
}

