const double cheb_table_tmax = 30;
const double cheb_table_delta = 0.5;
const size_t cheb_table_mmax = 10;
double cheb_table[][88]={
{
// [0,0.50 ]: m=0 maxabs=1.411093464298574e-13 maxrel=1.4110934642985724e-13
0.9225620128254464,
-0.14376122975414912,
0.020941648881248522,
-0.002452715479378476,
0.000235997651027557,
-0.000019170981830737773,
1.3470072437538336e-6,
-8.303934753460698e-8,
// [0,0.50 ]: m=1 maxabs=1.25954802143724e-13 maxrel=3.7786440643117147e-13
0.28752245950823613,
-0.08376659545364744,
0.014716292882247196,
-0.0018879840616398504,
0.00019170973868261638,
-0.00001613669564431154,
1.1628054288774348e-6,
-7.304190347568398e-8,
// [0,0.50 ]: m=2 maxabs=1.136590821460004e-13 maxrel=5.682954107300009e-13
0.16753319090723864,
-0.05886517146532266,
0.011327904375232989,
-0.0015336804559930917,
0.0001613668844793646,
-0.000013929219001881977,
1.0228171231509808e-6,
-6.51888648831467e-8,
// [0,0.50 ]: m=3 maxabs=1.0361156377314273e-13 maxrel=7.252809464119972e-13
0.11773034293059441,
-0.045311617443446695,
0.009202082740855884,
-0.0012909373750767904,
0.00013929212463536714,
-0.000012251733430757432,
9.128535270351977e-7,
-5.885792285057865e-8,
// [0,0.50 ]: m=4 maxabs=9.514611321037592e-14 maxrel=8.563150188933809e-13
0.09062323488684626,
-0.036808330911033936,
0.00774562425497998,
-0.001114339092641799,
0.00012251727407221023,
-0.000010934125035884645,
8.242035120648305e-7,
-5.364621615348856e-8,
// [0,0.50 ]: m=5 maxabs=8.804068585277491e-14 maxrel=9.68447544380522e-13
0.07361666182202371,
-0.03098249697179002,
0.0066860345600377345,
-0.000980140117682248,
0.00010934119466087979,
-9.871961462956802e-6,
7.512250821927126e-7,
-4.928136842444809e-8,
// [0,0.50 ]: m=6 maxabs=8.125444761475364e-14 maxrel=1.0563078189917948e-12
0.06196499394354022,
-0.026744138195616916,
0.005880840710038178,
-0.0008747313378877381,
0.00009871956213210447,
-8.997609440122808e-6,
6.901067626117111e-7,
-4.557506783637167e-8,
// [0,0.50 ]: m=7 maxabs=7.652212197228891e-14 maxrel=1.147831829584332e-12
0.0534882763912485,
-0.02352336279843583,
0.005248388028671605,
-0.0007897581600096812,
0.00008997606328663314,
-8.265358793492271e-6,
6.381711079166686e-7,
-4.238252019177115e-8,
// [0,0.50 ]: m=8 maxabs=7.184530748105544e-14 maxrel=1.2213702271779405e-12
0.04704672559683674,
-0.020993552076006772,
0.004738548963444083,
-0.0007198100535157448,
0.00008265354267238555,
-7.643199811999523e-6,
5.935003036547157e-7,
-3.960946752950958e-8,
// [0,0.50 ]: m=9 maxabs=6.766809335090329e-14 maxrel=1.2856937736671601e-12
0.04198710415198017,
-0.01895419581747007,
0.0043188603242978185,
-0.0006612297936172897,
0.00007643195541467157,
-7.108062267567646e-6,
5.546691984803327e-7,
-3.7176771940317704e-8,
// [0,0.50 ]: m=10 maxabs=6.399047958183246e-14 maxrel=1.343800071218478e-12
0.0379083916349086,
-0.01727544126298479,
0.00396737876472532,
-0.0006114570115350189,
0.00007108058240301862,
-6.642895717927431e-6,
5.20603679102592e-7,
-3.50253705444214e-8
},
{
// [0.50,1.0 ]: m=0 maxabs=8.981704269217516e-14 maxrel=1.0497251310654137e-13
0.7975078096148953,
-0.10838041895797,
0.014826330095336892,
-0.0016762034818245484,
0.00015770431459094725,
-0.000012614628517204322,
8.764037421556591e-7,
-5.356872801365819e-8,
// [0.50,1.0 ]: m=1 maxabs=8.021361352916756e-14 maxrel=3.220218061181868e-13
0.21676083791590028,
-0.059305320335623204,
0.01005722089475729,
-0.0012616363453658982,
0.00012614623479738224,
-0.000010499291753055304,
7.501222708505832e-7,
-4.680460528251248e-8,
// [0.50,1.0 ]: m=2 maxabs=7.208122987378829e-14 maxrel=5.12120461486707e-13
0.11861064067121105,
-0.04022888353844853,
0.007569818075572084,
-0.0010091715014848423,
0.00010499287256441454,
-8.985886286207017e-6,
6.554082987005183e-7,
-4.154758945361639e-8,
// [0.50,1.0 ]: m=3 maxabs=6.550315845288424e-14 maxrel=6.737481434451337e-13
0.08045776707686565,
-0.030279272265817482,
0.006055029011940928,
-0.000839944439422004,
0.00008985882227901756,
-7.850894335181635e-6,
5.817963715371467e-7,
-3.734639204974008e-8,
// [0.50,1.0 ]: m=4 maxabs=5.997979890537408e-14 maxrel=8.102803815743808e-13
0.060558544531605474,
-0.02422011601464185,
0.005039666639363324,
-0.0007188719030152923,
0.00007850890556444262,
-6.968838839386282e-6,
5.229704944657889e-7,
-3.391336358019627e-8,
// [0.50,1.0 ]: m=5 maxabs=5.52960455202367e-14 maxrel=9.265277065634217e-13
0.04844023202925661,
-0.020158666527123306,
0.004313231420700035,
-0.0006280724576781131,
0.00006968835357986545,
-6.263999782733103e-6,
4.748985516074664e-7,
-3.105603661309284e-8,
// [0.50,1.0 ]: m=6 maxabs=5.1333937101105676e-14 maxrel=1.0275070600511627e-12
0.040317333054221256,
-0.017252925654827948,
0.00376843474850001,
-0.0005575079474755027,
0.00006263996542633406,
-5.688042024256179e-6,
4.348881603404269e-7,
-2.8641210691500128e-8,
// [0.50,1.0 ]: m=7 maxabs=4.789224572476769e-14 maxrel=1.1151905614909464e-12
0.034505851309632234,
-0.015073738968047727,
0.0033450476871301135,
-0.000501120761471288,
0.0000568803898642686,
-5.208692673916165e-6,
4.010741783609909e-7,
-2.6573828481460285e-8,
// [0.50,1.0 ]: m=8 maxabs=4.488770466437586e-14 maxrel=1.1922508724033003e-12
0.030147477936073343,
-0.01338019072431746,
0.0030067245709526898,
-0.0004550440870430186,
0.0000520868983952652,
-4.803596109985165e-6,
3.7212429637440703e-7,
-2.47840384047724e-8,
// [0.50,1.0 ]: m=9 maxabs=4.220235272356376e-14 maxrel=1.2593344954354098e-12
0.02676038144861398,
-0.012026898261137259,
0.002730264524260109,
-0.0004166960941648811,
0.00004803593443929759,
-4.456784221150877e-6,
3.47061814022337e-7,
-2.3219575085295393e-8,
// [0.50,1.0 ]: m=10 maxabs=3.982925100842749e-14 maxrel=1.3192719586334077e-12
0.024053796522254877,
-0.01092105807571158,
0.002500176566876381,
-0.0003842883286631169,
0.000044567817040920463,
-4.156551568322061e-6,
3.2515461493506755e-7,
-2.1840492559227332e-8
},
{
// [1.0,1.5 ]: m=0 maxabs=5.795364188543317e-14 maxrel=7.760011941123063e-14
0.7024234313969104,
-0.08318372690734321,
0.01062987823653928,
-0.0011557527698907095,
0.00010607082572914465,
-8.341290834362573e-6,
5.723949562944893e-7,
-3.4662256857854546e-8,
// [1.0,1.5 ]: m=1 maxabs=5.129230373768223e-14 maxrel=2.7071129306794425e-13
0.1663674538146601,
-0.04251951291677796,
0.006934516621862405,
-0.0008485677806003662,
0.00008341287477209323,
-6.857463589136635e-6,
4.853790464573009e-7,
-3.0066373375641155e-8,
// [1.0,1.5 ]: m=2 maxabs=4.581057755359552e-14 maxrel=4.568776967620602e-13
0.08503902583353165,
-0.027738066461528498,
0.005091406685861174,
-0.0006673040347537073,
0.00006857460623413862,
-5.814597936975137e-6,
4.210233264794111e-7,
-2.653460818943903e-8,
// [1.0,1.5 ]: m=3 maxabs=4.1466829969749597e-14 maxrel=6.213909252821091e-13
0.05547613292303671,
-0.02036562672026129,
0.004003824210474092,
-0.000548597777167594,
0.00005814595332281162,
-5.043378024775014e-6,
3.7156788753657324e-7,
-2.373822064398008e-8,
// [1.0,1.5 ]: m=4 maxabs=3.785166624581393e-14 maxrel=7.6278101513451e-13
0.040731253440503885,
-0.016015296820927526,
0.003291586664802797,
-0.0004651684653077274,
0.0000504337562733864,
-4.450763027582442e-6,
3.3241183164118305e-7,
-2.1470796802837308e-8,
// [1.0,1.5 ]: m=5 maxabs=3.480549182199866e-14 maxrel=8.841765938271223e-13
0.03203059364183793,
-0.013166346640073009,
0.0027910107934935595,
-0.0004034708156841857,
0.00004450760829927266,
-3.981593370154883e-6,
3.006614943786509e-7,
-1.9595995410905315e-8,
// [1.0,1.5 ]: m=6 maxabs=3.222422328974517e-14 maxrel=9.89473682307492e-13
0.026332693280130045,
-0.011164043156375307,
0.0024208248956346986,
-0.00035606157033188395,
0.0000398159133201108,
-3.601180210110211e-6,
2.744091271574088e-7,
-1.8020482604705348e-8,
// [1.0,1.5 ]: m=7 maxabs=2.998989945268704e-14 maxrel=1.0808728223776606e-12
0.022328086312735737,
-0.009683299566250976,
0.002136369423416634,
-0.00031852795806266857,
0.000036011783105544825,
-3.2866551654379394e-6,
2.5234754210746427e-7,
-1.6678213748229658e-8,
// [1.0,1.5 ]: m=8 maxabs=2.8036600818737156e-14 maxrel=1.1606814079749635e-12
0.019366599132488015,
-0.008545477678508714,
0.0019111677497113694,
-0.00028809487114862353,
0.000032866533865278015,
-3.0223500331380354e-6,
2.3355187479632806e-7,
-1.5521181117737856e-8,
// [1.0,1.5 ]: m=9 maxabs=2.6336571812279885e-14 maxrel=1.2318160586835856e-12
0.017090955357004448,
-0.007644670984671394,
0.0017285692281390943,
-0.00026293283787172806,
0.000030223483695230765,
-2.7971798449288163e-6,
2.173497754372625e-7,
-1.4513634039410047e-8,
// [1.0,1.5 ]: m=10 maxabs=2.4816954047324202e-14 maxrel=1.2943742121253036e-12
0.015289341969330529,
-0.006914276899247254,
0.0015775970284071352,
-0.0002417884019278899,
0.000027971782773599547,
-2.603086611140667e-6,
2.0324100105439597e-7,
-1.3628456199754226e-8
},
{
// [1.5,2.0 ]: m=0 maxabs=3.7414515929867775e-14 maxrel=5.6402295292533146e-14
0.6288120982551069,
-0.06500545068637688,
0.007723527171441156,
-0.000804566329115313,
0.00007184539872947243,
-5.544940252809949e-6,
3.753853406319305e-7,
-2.2502900500837e-8,
// [1.5,2.0 ]: m=1 maxabs=3.2807090377673376e-14 maxrel=2.2357252163440913e-13
0.13001090137273852,
-0.03089410866683112,
0.004827397976214841,
-0.000574763946722431,
0.00005544938240877851,
-4.49736041636672e-6,
3.151047836098216e-7,
-1.9365776038485654e-8,
// [1.5,2.0 ]: m=2 maxabs=2.921274333544943e-14 maxrel=4.0369421658328357e-13
0.061788217333647553,
-0.01930959188827018,
0.0034485836817401317,
-0.0004435957227808949,
0.00004497358545086678,
-3.774888137453038e-6,
2.71180718287428e-7,
-1.6983928497738224e-8,
// [1.5,2.0 ]: m=3 maxabs=2.6277591214096674e-14 maxrel=5.684199782832476e-13
0.038619183776527365,
-0.013794334712198052,
0.0026615743379381543,
-0.0003597892740998014,
0.00003774886464820332,
-3.248499896853594e-6,
2.3782856261664634e-7,
-1.511662193466603e-8,
// [1.5,2.0 ]: m=4 maxabs=2.3925306180672123e-14 maxrel=7.143721963675906e-13
0.027588669424384364,
-0.010646297338455525,
0.0021587356457250084,
-0.000301991449041698,
0.000032484983960187216,
-2.8488370955389033e-6,
2.1168071480906482e-7,
-1.3614793160758674e-8,
// [1.5,2.0 ]: m=5 maxabs=2.1926904736346842e-14 maxrel=8.40194957529392e-13
0.02129259467690017,
-0.008634942570808499,
0.0018119486952956143,
-0.00025988035534160666,
0.000028488357020400283,
-2.535525444064478e-6,
1.9065167708068905e-7,
-1.238168971813313e-8,
// [1.5,2.0 ]: m=6 maxabs=8.873457524316564e-14 maxrel=4.163254887197986e-12
0.017269885141580062,
-0.0072477947681872865,
0.0015592821270721455,
-0.00022790732725678557,
0.000025355308659585694,
-2.28343783223844e-6,
1.732096229169124e-7,
-1.1531276092220351e-8,
// [1.5,2.0 ]: m=7 maxabs=1.8797463585684682e-14 maxrel=1.045298614319481e-12
0.014495589540183054,
-0.006237128521792625,
0.001367443798469066,
-0.000202842342825831,
0.000022835620589470665,
-2.076683949409076e-6,
1.5895974930986287e-7,
-1.047843405536351e-8,
// [1.5,2.0 ]: m=8 maxabs=1.7536319618649543e-14 maxrel=1.128637340682839e-12
0.012474257043576598,
-0.005469775184374681,
0.001217054057785108,
-0.000182685344771556,
0.000020766828414751572,
-1.9038685107479132e-6,
1.467335524873359e-7,
-9.729185028453377e-9,
// [1.5,2.0 ]: m=9 maxabs=1.6438239658356224e-14 maxrel=1.2025310848562544e-12
0.010939550368741224,
-0.004868216222274192,
0.001096112069406595,
-0.00016613498197851317,
0.000019038674747876665,
-1.7573978825581797e-6,
1.3624173283487346e-7,
-9.079310515665043e-9,
// [1.5,2.0 ]: m=10 maxabs=1.5485876470044957e-14 maxrel=1.2695371394439956e-12
0.009736432444540696,
-0.004384448269314831,
0.000996809892606092,
-0.00015230973043639168,
0.000017573969039133363,
-1.6317092915644743e-6,
1.2714163827153303e-7,
-8.51057659618131e-9
},
{
// [2.0,2.5 ]: m=0 maxabs=2.3869795029440866e-14 maxrel=3.990643517883973e-14
0.5707922624165785,
-0.05171033753940945,
0.005690633355124788,
-0.0005658616184509315,
0.00004903366526890262,
-3.7072490297551508e-6,
2.4728091378206547e-7,
-1.466047485809212e-8,
// [2.0,2.5 ]: m=1 maxabs=2.1038726316646716e-14 maxrel=1.8183517511048067e-13
0.10342067507880964,
-0.0227625334082874,
0.003395169711578308,
-0.00039226981106469923,
0.00003707247789699716,
-2.9626785895243216e-6,
2.0528754642130373e-7,
-1.2509254880140982e-8,
// [2.0,2.5 ]: m=2 maxabs=1.8630930131990908e-14 maxrel=3.519066787583468e-13
0.04552506681656534,
-0.01358067883566858,
0.002353618867286078,
-0.0002965802488928068,
0.0000296267739556747,
-2.4593640760295426e-6,
1.7516773553951638e-7,
-1.089659674966763e-8,
// [2.0,2.5 ]: m=3 maxabs=1.6715795414512513e-14 maxrel=5.168017198052216e-13
0.027161357671328892,
-0.009414475459724394,
0.001779481494145063,
-0.00023701456842739382,
0.000024593630257011365,
-2.098395786704131e-6,
1.5258599760288182e-7,
-9.645357181835959e-9,
// [2.0,2.5 ]: m=4 maxabs=1.5126788710517758e-14 maxrel=6.643472626883464e-13
0.01882895091944134,
-0.007117925968134598,
0.001422087411278054,
-0.0001967493798679535,
0.000020983948344858052,
-1.8277890375903661e-6,
1.350655021463988e-7,
-8.647756909283126e-9,
// [2.0,2.5 ]: m=5 maxabs=1.383268499743906e-14 maxrel=7.951039178832883e-13
0.014235851936262346,
-0.005688349637460385,
0.0011804962798636445,
-0.00016787189281582108,
0.00001827788163325064,
-1.6178479807371975e-6,
1.2109657973934226e-7,
-7.834604828514855e-9,
// [2.0,2.5 ]: m=6 maxabs=1.272940086671781e-14 maxrel=9.086694292758047e-13
0.01137669927491445,
-0.004721985112462304,
0.0010072313574998304,
-0.00014622333274416798,
0.000016178471749243937,
-1.450474100349007e-6,
1.0971024134903932e-7,
-7.159552906523513e-9,
// [2.0,2.5 ]: m=7 maxabs=1.1796119636642288e-14 maxrel=1.0086553973332649e-12
0.009443970224918703,
-0.0040289254235629625,
0.0008773399970278449,
-0.00012942803143944708,
0.000014504733509259144,
-1.3140514527202966e-6,
1.0025770770267926e-7,
-6.5904703244264086e-9,
// [2.0,2.5 ]: m=8 maxabs=1.0984269049885143e-14 maxrel=1.0960115207893982e-12
0.008057850847120438,
-0.003509359982149378,
0.0007765681891621236,
-0.00011603810654325057,
0.000013140507512604593,
-1.2008032624728976e-6,
9.228907292620028e-8,
-6.104427554747395e-9,
// [2.0,2.5 ]: m=9 maxabs=1.0276501871686605e-14 maxrel=1.1731380177874872e-12
0.007018719964293704,
-0.003106272751098562,
0.0006962286397527459,
-0.00010512428213498115,
0.000012008026041396847,
-1.1053372104495976e-6,
8.548304477571204e-8,
-5.684613673676698e-9,
// [2.0,2.5 ]: m=10 maxabs=9.653736143810931e-15 maxrel=1.2415708018483595e-12
0.00621254550219232,
-0.0027849145538171374,
0.0006307456932700575,
-0.00009606441608366647,
0.00001105336596954875,
-1.023802120899987e-6,
7.960422815237871e-8,
-5.318424386008149e-9
},
{
// [2.5,3.0 ]: m=0 maxabs=1.5654144647214707e-14 maxrel=2.8655271275652815e-14
0.5242522560799032,
-0.041847672261198905,
0.004253594828355123,
-0.0004023330753386338,
0.00003373862143556551,
-2.493982023680281e-6,
1.636766080889586e-7,
-9.587122021436658e-9,
// [2.5,3.0 ]: m=1 maxabs=1.3572476476042539e-14 maxrel=1.4618992454609164e-13
0.08369534452238862,
-0.01701437930549703,
0.0024139984528086973,
-0.0002699092882400792,
0.00002493981012895318,
-1.96107926663901e-6,
1.342518844734822e-7,
-8.105118827349819e-9,
// [2.5,3.0 ]: m=2 maxabs=1.394717674685353e-15 maxrel=3.549998623615018e-14
0.03402875861099553,
-0.009655993804128168,
0.0016194557297479855,
-0.00019951876324327266,
0.000019610781790526014,
-1.6083413953503005e-6,
1.1351412246870553e-7,
-7.1011972732699995e-9,
// [2.5,3.0 ]: m=3 maxabs=1.0623446566881967e-14 maxrel=4.644974914427114e-13
0.019311987608769666,
-0.006477822914066181,
0.001197112529673008,
-0.00015688652014944336,
0.000016083934930432875,
-1.3596458522863695e-6,
9.814348139493797e-8,
-6.167317219302441e-9,
// [2.5,3.0 ]: m=4 maxabs=9.591286098675766e-15 maxrel=6.147404200264652e-13
0.012955645828127527,
-0.004788450113318335,
0.0009413191213559406,
-0.0001286716943883945,
0.00001359645241232108,
-1.1756583060879095e-6,
8.636198105852381e-8,
-5.502617458807314e-9,
// [2.5,3.0 ]: m=5 maxabs=8.734332701543224e-15 maxrel=7.486414201721261e-13
0.009576900226632334,
-0.003765276480574677,
0.0007720301667463084,
-0.0001087718132504852,
0.00001175657751711254,
-1.034481882545589e-6,
7.705437802744268e-8,
-4.964974039676946e-9,
// [2.5,3.0 ]: m=6 maxabs=8.017891905964802e-15 maxrel=8.667799970617099e-13
0.007530552961145342,
-0.003088120662569523,
0.0006526308798862873,
-0.00009405279676420035,
0.000010344813721415254,
-9.229569301583892e-7,
6.95259588555636e-8,
-4.521582912372741e-9,
// [2.5,3.0 ]: m=7 maxabs=7.40553451894499e-15 maxrel=9.701322381282014e-13
0.006176241325135374,
-0.002610523515492137,
0.0005643167809375243,
-0.00008275867188419544,
9.22956460469278e-6,
-8.327552619420161e-7,
6.331719117910926e-8,
-4.149915653156702e-9,
// [2.5,3.0 ]: m=8 maxabs=6.884250114413959e-15 maxrel=1.0617954898557916e-12
0.00522104703098087,
-0.0022572671200059595,
0.000496552031632522,
-0.00007383666660500697,
8.327548255446037e-6,
-7.583685268599234e-7,
5.8112783188158945e-8,
-3.834038664063267e-9,
// [2.5,3.0 ]: m=9 maxabs=6.42194630806614e-15 maxrel=1.1412294528421783e-12
0.004514534240008657,
-0.0019862081230507607,
0.0004430199999373362,
-0.0000666205252049678,
7.583681179309862e-6,
-6.960174824399574e-7,
5.368962128270009e-8,
-3.5624007243648715e-9,
// [2.5,3.0 ]: m=10 maxabs=6.027296717281416e-15 maxrel=1.213608325193781e-12
0.003972416246099186,
-0.0017720799964986017,
0.00039972315149520966,
-0.00006066957939316966,
6.960171135926045e-6,
-6.430280008867663e-7,
4.9885591697957656e-8,
-3.3263419618350795e-9
},
{
// [3.0,3.5 ]: m=0 maxabs=9.992007221626409e-15 maxrel=1.9811906028979838e-14
0.48628724457869804,
-0.0344240797497667,
0.0032263513602634325,
-0.00028935848255486,
0.000023417539308012155,
-1.6889767311736403e-6,
1.088992737245835e-7,
-6.295293406342314e-9,
// [3.0,3.5 ]: m=1 maxabs=8.701372955499664e-15 maxrel=1.1485533408390322e-13
0.0688481594995277,
-0.012905405435912579,
0.0017361508958615214,
-0.00018734052021095952,
0.000016889760331043165,
-1.3048155830356826e-6,
8.815617548102899e-8,
-5.268932720169385e-9,
// [3.0,3.5 ]: m=2 maxabs=7.629313847345998e-15 maxrel=2.579051179464385e-13
0.02581081087182121,
-0.006944603579030781,
0.0011240431216327066,
-0.00013511825924372226,
0.000013048150983007522,
-1.0561789350753595e-6,
7.378051120624779e-8,
-4.520203852523916e-9,
// [3.0,3.5 ]: m=3 maxabs=6.772360450213455e-15 maxrel=4.1411773829546387e-13
0.013889207158058182,
-0.004496172482670213,
0.0008107095557862899,
-0.00010438536226596778,
0.000010561785032466146,
-8.838839691740313e-7,
6.32966799670155e-8,
-3.952311825691985e-9,
// [3.0,3.5 ]: m=4 maxabs=6.087144677202616e-15 maxrel=5.645926300553452e-13
0.008992344965337393,
-0.0032428382197192897,
0.0006263121738871312,
-0.00008449441729242979,
8.838835807642342e-6,
-7.582446550324355e-7,
5.534479694091496e-8,
-3.5079994353849673e-9,
// [3.0,3.5 ]: m=5 maxabs=5.523359547510154e-15 maxrel=7.014345103621947e-13
0.006485676439435854,
-0.002505248692470483,
0.0005069665040159912,
-0.00007071080957412567,
7.582443066732189e-6,
-6.629557184789155e-7,
4.912313725173202e-8,
-3.1515245117491478e-9,
// [3.0,3.5 ]: m=6 maxabs=5.052382123782451e-15 maxrel=8.230629351631045e-13
0.0050104973849384535,
-0.0020278660132713746,
0.00042426485768574885,
-0.00006065965623654538,
6.6295539779412936e-6,
-5.884053033963601e-7,
4.413159593587956e-8,
-2.8595791008133794e-9,
// [3.0,3.5 ]: m=7 maxabs=4.659467256473704e-15 maxrel=9.31471362546799e-13
0.0040557320265404515,
-0.0016970594281876588,
0.00036395793764016574,
-0.00005303653403163133,
5.884050099552698e-6,
-5.285980042280257e-7,
4.004348498292613e-8,
-2.6163061403077205e-9,
// [3.0,3.5 ]: m=8 maxabs=4.318594093444261e-15 maxrel=1.026325878723642e-12
0.0033941188563731497,
-0.0014558317482062638,
0.0003182192043944479,
-0.00004707249497238534,
5.285977299939403e-6,
-4.796177862264052e-7,
3.663708916379784e-8,
-2.4106327576022175e-9,
// [3.0,3.5 ]: m=9 maxabs=4.024124783397198e-15 maxrel=1.1103145310130214e-12
0.002911663496410525,
-0.001272876815395477,
0.0002824349700259474,
-0.000042287905689082315,
4.79617531004442e-6,
-4.388071047952581e-7,
3.375702152813384e-8,
-2.2345514055428123e-9,
// [3.0,3.5 ]: m=10 maxabs=3.7665183472146424e-15 maxrel=1.1847605083993666e-12
0.002545753630789096,
-0.001129739878070582,
0.0002537274343108726,
-0.00003836948381802919,
4.3880686901504476e-6,
-4.0430340427609727e-7,
3.129128067794601e-8,
-2.0822783241314656e-9
},
{
// [3.5,4.0 ]: m=0 maxabs=6.8833827526759706e-15 maxrel=1.465026324944697e-14
0.4548219890540052,
-0.02875361621319911,
0.0024833991912293395,
-0.00021060617162847324,
0.000016404819232111816,
-1.151990835873639e-6,
7.28573787482038e-8,
-4.152248574545361e-9,
// [3.5,4.0 ]: m=1 maxabs=2.968458812091512e-14 maxrel=4.726311416498358e-13
0.05750723242658047,
-0.009933596759485365,
0.0012636370260804834,
-0.00013123873517164054,
0.000011519930072019537,
-8.726876584631566e-7,
5.8093098809610205e-8,
-4.069862150195418e-9,
// [3.5,4.0 ]: m=2 maxabs=4.898859096158503e-15 maxrel=2.1673093988441202e-13
0.019867193523087426,
-0.005054548117295767,
0.000787432130388883,
-0.00009215935418796254,
8.729985220940091e-6,
-6.966103718310833e-7,
4.813211479701927e-8,
-2.923703257792193e-9,
// [3.5,4.0 ]: m=3 maxabs=4.328135072562134e-15 maxrel=3.658181684278131e-13
0.010109096234589337,
-0.0031497285190754815,
0.0005529561253363841,
-0.0000698399809547372,
6.966100947966684e-6,
-5.76633247378761e-7,
4.094069327723694e-8,
-2.5389157960884123e-9,
// [3.5,4.0 ]: m=4 maxabs=3.869300713166268e-15 maxrel=5.147077215523736e-13
0.00629945703814902,
-0.0022118244991568997,
0.00041903988591341767,
-0.000055728895124126045,
5.766330012199441e-6,
-4.904479589834488e-7,
3.555269156593718e-8,
-2.24091272657723e-9,
// [3.5,4.0 ]: m=5 maxabs=3.49893725104522e-15 maxrel=6.53834790847292e-13
0.004423648998312065,
-0.0016761595416966528,
0.00033437337091072407,
-0.00004613071837563257,
4.904477378526458e-6,
-4.258808412577442e-7,
3.137985382627474e-8,
-2.0038710472898225e-9,
// [3.5,4.0 ]: m=6 maxabs=3.191891195797325e-15 maxrel=7.793759606093988e-13
0.003352319083391719,
-0.0013374934818742557,
0.00027678431040679963,
-0.00003923588977349803,
4.258806380129525e-6,
-3.7587908786209396e-7,
2.806066334566495e-8,
-1.8111527483954027e-9,
// [3.5,4.0 ]: m=7 maxabs=2.9308153126628156e-15 maxrel=8.903073563063656e-13
0.002674986963747006,
-0.001107137240015269,
0.00023541533877918938,
-0.000034070515541578114,
3.7587890442667137e-6,
-3.361086667169662e-7,
2.536200656853163e-8,
-1.6515680277290453e-9,
// [3.5,4.0 ]: m=8 maxabs=2.706168622523819e-15 maxrel=9.875844221248915e-13
0.0022142744800292156,
-0.0009416613536345563,
0.00020442309337865417,
-0.000030070371631958702,
3.3610849485491013e-6,
-3.0377503382161213e-7,
2.3127445861775806e-8,
-1.5174236305534204e-9,
// [3.5,4.0 ]: m=9 maxabs=2.5201195297253065e-15 maxrel=1.0765902655852848e-12
0.0018833227072685794,
-0.0008176923721421619,
0.00018042222988477855,
-0.00002688873443150602,
3.0377489897506197e-6,
-2.770030848524502e-7,
2.124839098084323e-8,
-1.4030406791200398e-9,
// [3.5,4.0 ]: m=10 maxabs=2.3548871186385156e-15 maxrel=1.1544801087284543e-12
0.0016353847442831578,
-0.0007216889182651714,
0.0001613324067009839,
-0.000024302042875413244,
2.7700293555967678e-6,
-2.54491501337083e-7,
1.9647347585094853e-8,
-1.3045062859904207e-9
},
{
// [4.0,4.5 ]: m=0 maxabs=4.274358644806853e-15 maxrel=9.69152889873877e-15
0.42835648751204314,
-0.024358367859001646,
0.0019394996070979669,
-0.00015518566269354518,
0.000011604813944168985,
-7.917283562528952e-7,
4.9034912145935797e-8,
-2.75183810129835e-9,
// [4.0,4.5 ]: m=1 maxabs=3.649858193455202e-15 maxrel=6.907294729561706e-14
0.048716735718002044,
-0.007757998426176684,
0.0009311139762392296,
-0.00009283859988263128,
7.91728278158139e-6,
-5.875731533222716e-7,
3.852801106378539e-8,
-2.250931816064736e-9,
// [4.0,4.5 ]: m=2 maxabs=3.157196726277789e-15 maxrel=1.801458386904166e-13
0.01551599685235192,
-0.0037244559031037673,
0.0005570315994354635,
-0.00006333833636387483,
5.8757296626601975e-6,
-4.616247329431553e-7,
3.151905064235694e-8,
-1.896934381242633e-9,
// [4.0,4.5 ]: m=3 maxabs=2.770353391134961e-15 maxrel=3.1974867892928105e-13
0.007448911806206186,
-0.002228126396144205,
0.00038003001831487366,
-0.00004700590119018984,
4.616245576772981e-6,
-3.7761536385264854e-7,
2.6562686514105122e-8,
-1.6351610423128097e-9,
// [4.0,4.5 ]: m=4 maxabs=2.465042059363043e-15 maxrel=4.658331715270869e-13
0.004456252792287359,
-0.0015201200718587941,
0.0002820354072513432,
-0.00003693002064881843,
3.7761521455599954e-6,
-3.1821428315949526e-7,
2.2897065888411523e-8,
-1.4345779920297678e-9,
// [4.0,4.5 ]: m=5 maxabs=2.2191450066433305e-15 maxrel=6.057131065668285e-13
0.0030402401437164875,
-0.0011281416277586886,
0.00022158012399715063,
-0.0000302092670290414,
3.1821414411632638e-6,
-2.742861053279155e-7,
2.0088541057222447e-8,
-1.2764715441509996e-9,
// [4.0,4.5 ]: m=6 maxabs=2.01574867908505e-15 maxrel=7.335012912799933e-13
0.002256283255516381,
-0.0008863204948665741,
0.0001812556022696737,
-0.000025457176409228463,
2.742859780684976e-6,
-2.406316485413826e-7,
1.7874673777752387e-8,
-1.148910988458164e-9,
// [4.0,4.5 ]: m=7 maxabs=1.846613140177311e-15 maxrel=8.48534488128386e-13
0.0017726409897322857,
-0.0007250224080591002,
0.00015274305854255784,
-0.00002194291902732923,
2.406315323504082e-6,
-2.141045866253696e-7,
1.6088470691715738e-8,
-1.0439801954336357e-9,
// [4.0,4.5 ]: m=8 maxabs=1.7034984534092246e-15 maxrel=9.511481539365725e-13
0.001450044816117355,
-0.0006109722332362745,
0.00013165751424505735,
-0.000019250559946109723,
2.1410447895939984e-6,
-1.9270302734350862e-7,
1.461916511500559e-8,
-9.562958001536744e-10,
// [4.0,4.5 ]: m=9 maxabs=1.5812004483528597e-15 maxrel=1.042731357281808e-12
0.0012219444664719411,
-0.0005266300561171289,
0.00011550335972809216,
-0.00001712839277485478,
1.9270295242998885e-6,
-1.7509927954189026e-7,
1.3390669227555842e-8,
-8.818680251522556e-10,
// [4.0,4.5 ]: m=10 maxabs=1.4732139119733034e-15 maxrel=1.122875513942351e-12
0.0010532601122335305,
-0.00046201343811349193,
0.0001027703567190205,
-0.000015416268149473508,
1.7509918629086296e-6,
-1.6038126208729035e-7,
1.2349137642884105e-8,
-8.180489479601424e-10
},
{
// [4.5,5.0 ]: m=0 maxabs=8.382183835919932e-15 maxrel=2.011836067642901e-14
0.4057932930418428,
-0.020902189357755428,
0.0015363347846143681,
-0.00011579321558600053,
8.293317692000655e-6,
-5.484701983176997e-7,
3.361231183880962e-8,
-1.8487849247325814e-9,
// [4.5,5.0 ]: m=1 maxabs=2.366162821232365e-15 maxrel=5.2512094967389497e-14
0.041804378720050626,
-0.006145338997738305,
0.0006947591420685595,
-0.00006634828234401183,
5.485400426143796e-6,
-3.9798922962880384e-7,
2.565979668455639e-8,
-1.4800189353115515e-9,
// [4.5,5.0 ]: m=2 maxabs=2.0435042547006788e-15 maxrel=1.4823617351805428e-13
0.012290677995475724,
-0.0027790365670663847,
0.0003980896941498511,
-0.00004388325168272271,
3.979891139571471e-6,
-3.0745435856665874e-7,
2.072397813859498e-8,
-1.2348184091384703e-9,
// [4.5,5.0 ]: m=3 maxabs=1.777224201138239e-15 maxrel=2.7664274093860287e-13
0.005558073134131724,
-0.001592358775568741,
0.0002632995101868064,
-0.0000318391703574056,
3.0745424064056524e-6,
-2.482917779387013e-7,
1.7291196815568266e-8,
-1.0559722050748564e-9,
// [4.5,5.0 ]: m=4 maxabs=1.5746952353179466e-15 maxrel=4.185445897747684e-13
0.003184717551136723,
-0.0010531980398483163,
0.00019103502221934994,
-0.000024596375207993506,
2.4829167842015124e-6,
-2.0714918013027016e-7,
1.4786787279582107e-8,
-9.204643386550694e-10,
// [4.5,5.0 ]: m=5 maxabs=1.40989650510015e-15 maxrel=5.577168980339772e-13
0.002106396079695857,
-0.0007641400880812063,
0.0001475782513229088,
-0.000019863366100655026,
2.0714908234407102e-6,
-1.7713593800726401e-7,
1.2889586263566544e-8,
-8.146909443148922e-10,
// [4.5,5.0 ]: m=6 maxabs=1.2776238400569184e-15 maxrel=6.885904912812819e-13
0.0015282801761617817,
-0.0005903130045786259,
0.00011918019666448252,
-0.00001657195510606624,
1.7713585738180287e-6,
-1.54401269160928e-7,
1.1408252136735498e-8,
-7.300217365435578e-10,
// [4.5,5.0 ]: m=7 maxabs=1.1653004949874202e-15 maxrel=8.060365833030748e-13
0.0011806260091566897,
-0.00047672078601270173,
0.00009943173069094295,
-0.000014170894398959073,
1.5440119503662722e-6,
-1.366512323572351e-7,
1.0222701898574628e-8,
-6.608598654330206e-10,
// [4.5,5.0 ]: m=8 maxabs=1.0722759485881639e-15 maxrel=9.124240286077203e-13
0.0009534415720248707,
-0.00039772692217451296,
0.00008502536644489813,
-0.000012352119172827485,
1.366511642145001e-6,
-1.2244615428894037e-7,
9.254217434561826e-9,
-6.033780147044824e-10,
// [4.5,5.0 ]: m=9 maxabs=9.916113069552424e-16 maxrel=1.0062222588097454e-12
0.0007954538443485257,
-0.00034010146523751983,
0.0000741127150861648,
-0.000010932114810160044,
1.224460900067624e-6,
-1.1084255040308573e-7,
8.449332404790567e-9,
-5.548309977755251e-10,
// [4.5,5.0 ]: m=10 maxabs=9.230897296541585e-16 maxrel=1.0909632738862573e-12
0.0006802029304749119,
-0.00029645085983512587,
0.00006559268892323106,
-9.795707375837425e-6,
1.1084246261624423e-6,
-1.01199052517121e-7,
7.77044357741273e-9,
-5.134922437627053e-10
},
{
// [5.0,5.5 ]: m=0 maxabs=1.887379141862766e-15 maxrel=4.769573996119677e-15
0.3863194216613601,
-0.018146281107722657,
0.0012336924793731872,
-0.00008750035868421456,
5.9902239129842355e-6,
-3.8330107329780066e-7,
2.2647808084540863e-8,
-1.2271109811241744e-9,
// [5.0,5.5 ]: m=1 maxabs=1.5543122344752192e-15 maxrel=3.9959246260862756e-14
0.03629256221544419,
-0.004934769916530936,
0.000525002152174753,
-0.00004792182960347869,
3.833009946095386e-6,
-2.71406801188965e-7,
1.7181943350234968e-8,
-9.773381558017516e-10,
// [5.0,5.5 ]: m=2 maxabs=1.3183898417423734e-15 maxrel=1.1990336902943175e-13
0.009869539833061155,
-0.0021000086079107118,
0.0002875309776857744,
-0.000030664111091044577,
2.714067158924126e-6,
-2.0588077149763636e-7,
1.3685437025142004e-8,
-8.066763105223509e-10,
// [5.0,5.5 ]: m=3 maxabs=1.1423154089307275e-15 maxrel=2.3680214562745123e-13
0.004200017215820886,
-0.0011501239100746275,
0.00018398466659885667,
-0.00002171256399887981,
2.058807013277352e-6,
-1.6396872455363075e-7,
1.1295712331388609e-8,
-6.839328973384502e-10,
// [5.0,5.5 ]: m=4 maxabs=1.0065732969355423e-15 maxrel=3.723978150021886e-13
0.00230024782014879,
-0.0007359386658172386,
0.0001302753840414794,
-0.000016470479233884276,
1.639686604123551e-6,
-1.3532652483314732e-7,
9.577110727251484e-9,
-5.920588813872388e-10,
// [5.0,5.5 ]: m=5 maxabs=8.975025583835006e-16 maxrel=5.102746307916467e-13
0.0014718773316340348,
-0.0005211015356570323,
0.00009882287544580923,
-0.000013117513186758095,
1.3532646817657994e-6,
-1.1472994123466584e-7,
8.290634089723982e-9,
-5.210254290532963e-10,
// [5.0,5.5 ]: m=6 maxabs=8.090316611086834e-16 maxrel=6.416031981866579e-13
0.0010422030713136941,
-0.00039529150132876684,
0.00007870507915804218,
-0.000010826135629581752,
1.147298869490773e-6,
-9.931325726304169e-8,
7.296152956808028e-9,
-4.64679034975724e-10,
// [5.0,5.5 ]: m=7 maxabs=7.362816953349061e-16 maxrel=7.626348696741528e-13
0.0007905830026571716,
-0.00031482031622298063,
0.0000649568138122673,
-9.178407322848564e-6,
9.931321088819018e-7,
-8.739671987321554e-8,
6.506988438641438e-9,
-4.189644588655088e-10,
// [5.0,5.5 ]: m=8 maxabs=6.750242725894751e-16 maxrel=8.717052460541118e-13
0.0006296406324456562,
-0.00025982725487633094,
0.000055070443967758735,
-7.945071780171973e-6,
8.739667555874881e-7,
-7.794082503975935e-8,
5.866980165406826e-9,
-3.8122491995531017e-10,
// [5.0,5.5 ]: m=9 maxabs=5.959859342152818e-16 maxrel=9.274054181943497e-13
0.000519654509752353,
-0.00022028177552965518,
0.00004767043071071908,
-6.991747699882697e-6,
7.79407853818508e-7,
-7.027267069426724e-8,
5.338421883249118e-9,
-3.4958617953229173e-10,
// [5.0,5.5 ]: m=10 maxabs=5.785302792382652e-16 maxrel=1.0572219305601949e-12
0.0004405635510589852,
-0.0001906817225269697,
0.000041950486228633416,
-6.235275467277098e-6,
7.027263650331272e-7,
-6.393984508855472e-8,
4.895043201853749e-9,
-3.22649955240743e-10
},
{
// [5.5,6.0 ]: m=0 maxabs=1.27675647831893e-15 maxrel=3.3817410436780496e-15
0.3693249610515071,
-0.015919225228477836,
0.0010036148977082817,
-0.00006695980999414568,
4.37402656076367e-6,
-2.702412709702681e-7,
1.555512611607224e-8,
-8.265401581906769e-10,
// [5.5,6.0 ]: m=1 maxabs=1.0200174038743626e-15 maxrel=3.0044103301997535e-14
0.031838450456955346,
-0.004014459590189317,
0.0004017588599699233,
-0.00003499223797406835,
2.702412731139762e-6,
-1.8641787972246244e-7,
1.1571477175007679e-8,
-6.484444291424306e-10,
// [5.5,6.0 ]: m=2 maxabs=8.586881206085195e-16 maxrel=9.661480687703072e-14
0.008028919180378222,
-0.0016070354393644245,
0.0002099534278758695,
-0.000021619322478677057,
1.8641784162070772e-6,
-1.3865947508536795e-7,
9.079422484553077e-9,
-5.289707909546646e-10,
// [5.5,6.0 ]: m=3 maxabs=7.363901155521546e-16 maxrel=2.0074090297894605e-13
0.0032140708787284987,
-0.000839813711069165,
0.00012971593490555846,
-0.000014913444695134802,
1.3865943068204142e-6,
-1.0878640664941316e-7,
7.4070084010619386e-9,
-4.4435420147406777e-10,
// [5.5,6.0 ]: m=4 maxabs=6.431487287184012e-16 maxrel=3.276544981900352e-13
0.001679627422138036,
-0.0005188637392493731,
0.00008948066820083949,
-0.000011092769369708906,
1.0878636654568307e-6,
-8.87409203424936e-8,
6.222242742364138e-9,
-3.8180522706410077e-10,
// [5.5,6.0 ]: m=5 maxabs=5.728924279413405e-16 maxrel=4.640782724146285e-13
0.0010377274784983915,
-0.00035792267247725915,
0.00006655661624517677,
-8.702922369515942e-6,
8.874088461670052e-7,
-7.454167557422905e-8,
5.34641315328041e-9,
-3.3395978734497734e-10,
// [5.5,6.0 ]: m=6 maxabs=5.138034095408806e-16 maxrel=5.95404117520028e-13
0.0007158453449541455,
-0.0002662264646912805,
0.00005221753424136228,
-7.099282345789771e-6,
7.454164319410444e-7,
-6.404583054501507e-8,
4.676473820185516e-9,
-2.963306228291541e-10,
// [5.5,6.0 ]: m=7 maxabs=4.658816735170213e-16 maxrel=7.18593697767031e-13
0.0005324529293823318,
-0.00020887013670562783,
0.00004259569409668099,
-5.963341847777457e-6,
6.404580123041525e-7,
-5.60179204169455e-8,
4.1495666805028955e-9,
-2.660395838796726e-10,
// [5.5,6.0 ]: m=8 maxabs=4.2587461335230614e-16 maxrel=8.308877004833942e-13
0.0004177402734110135,
-0.00017038277615140778,
0.00003578005111085126,
-5.123673521612537e-6,
5.601788981166397e-7,
-4.9704340316475036e-8,
3.725507681523326e-9,
-2.411995872514455e-10,
// [5.5,6.0 ]: m=9 maxabs=3.9221013589663123e-16 maxrel=9.324929565896034e-13
0.0003407655523026229,
-0.000143120204228079,
0.00003074204114815628,
-4.481439797604629e-6,
4.970431569220565e-7,
-4.462341222314943e-8,
3.377581857096151e-9,
-2.2047759195429812e-10,
// [5.5,6.0 ]: m=10 maxabs=3.647256108241237e-16 maxrel=1.0274745275281893e-12
0.00028624040845597217,
-0.0001229681643945157,
0.000026888638803170318,
-3.976353178211113e-6,
4.462339024896449e-7,
-4.045488913903597e-8,
3.087377024227703e-9,
-2.0296894429436322e-10
},
{
// [6.0,6.5 ]: m=0 maxabs=9.43689570931383e-16 maxrel=2.6097021813184936e-15
0.35434650944701185,
-0.014096642212430895,
0.0008264939914920365,
-0.00005188217587981761,
3.2295722260187684e-6,
-1.9231140678995915e-7,
1.0764944014582687e-8,
-5.599918422508938e-10,
// [6.0,6.5 ]: m=1 maxabs=6.696032617270475e-16 maxrel=2.2374217339587304e-14
0.028193284424862155,
-0.003305975965534218,
0.0003112930552763257,
-0.00002583659493290131,
1.9231138970230213e-6,
-1.2901626196600507e-7,
7.840815558481505e-9,
-4.323331366150662e-10,
// [6.0,6.5 ]: m=2 maxabs=5.594483210025203e-16 maxrel=7.689694482390068e-14
0.006611951931068268,
-0.0012451722207645615,
0.00015501956961551478,
-0.000015384924791200118,
1.290162367264992e-6,
-9.395914903907285e-8,
6.053487025670747e-9,
-3.482629269615218e-10,
// [6.0,6.5 ]: m=3 maxabs=4.77048955893622e-16 maxrel=1.688781136305963e-13
0.002490344441528885,
-0.0006200782781789934,
0.00009230954877034023,
-0.000010321310255906515,
9.395911802617118e-7,
-7.25332167700597e-8,
4.876673018265968e-9,
-2.896450880841314e-10,
// [6.0,6.5 ]: m=4 maxabs=4.145989107584569e-16 maxrel=2.8766731056475723e-13
0.0012401565563577713,
-0.00036923819483980757,
0.00006192786155467112,
-7.5167391047439515e-6,
7.253318761075691e-7,
-5.842740925268563e-8,
4.05602225527822e-9,
-2.46912126532729e-10,
// [6.0,6.5 ]: m=5 maxabs=3.651592916931179e-16 maxrel=4.176252868725539e-13
0.0007384763896793345,
-0.0002477114460099417,
0.000045100434646160153,
-5.8026633609456755e-6,
5.842739031336746e-7,
-4.8591937070747784e-8,
3.457306340720108e-9,
-2.1451183822171287e-10,
// [6.0,6.5 ]: m=6 maxabs=3.2699537522162814e-16 maxrel=5.496240252462768e-13
0.0004954228920195065,
-0.00018040173840119393,
0.00003481598019940011,
-4.674198612681361e-6,
4.859189647289075e-7,
-4.1416674321332386e-8,
3.0043665659949535e-9,
-1.8934709638499454e-10,
// [6.0,6.5 ]: m=7 maxabs=2.951198313505543e-16 maxrel=6.738515580253027e-13
0.0003608034768022429,
-0.00013926392063232126,
0.000028045191690030992,
-3.887358328519268e-6,
4.1416655733854744e-7,
-3.5988938312495666e-8,
2.6514541176703688e-9,
-1.6922533936737166e-10,
// [6.0,6.5 ]: m=8 maxabs=2.6904476910227793e-16 maxrel=7.892492411341266e-13
0.0002785278412645097,
-0.0001121807666108668,
0.000023324149983860532,
-3.3133384288253427e-6,
3.598892133252231e-7,
-3.176013738042698e-8,
2.369697886618575e-9,
-1.5282986973867123e-10,
// [6.0,6.5 ]: m=9 maxabs=2.4692704478357363e-16 maxrel=8.934961499781575e-13
0.00022436153322161152,
-0.00009329659979945995,
0.00001988003058471106,
-2.8791191457008016e-6,
3.176012169085852e-7,
-2.8384159869077965e-8,
2.1401203311151655e-9,
-1.3923884870670435e-10,
// [6.0,6.5 ]: m=10 maxabs=2.2811613709095013e-16 maxrel=9.874810597283778e-13
0.0001865931995988077,
-0.00007952012221402756,
0.000017274714885010077,
-2.540814727809991e-6,
2.838414545545045e-7,
-2.5633516468451477e-8,
1.9498051556218797e-9,
-1.2780480111730712e-10
},
{
// [6.5,7.0 ]: m=0 maxabs=5.551115123125783e-16 maxrel=1.597449992617686e-15
0.34102752653081364,
-0.01258728321888945,
0.0006884520342631803,
-0.00004069012616535122,
2.4114574268878486e-6,
-1.3817736912053228e-7,
7.509342295414309e-9,
-3.8202083803995124e-10,
// [6.5,7.0 ]: m=1 maxabs=4.510281037539698e-16 maxrel=1.6946383432936285e-14
0.025174566437779065,
-0.002753808136760889,
0.00024414075697133187,
-0.000019291670940689812,
1.381773994956365e-6,
-9.000260197247438e-8,
5.347430705983613e-9,
-2.8975563964446884e-10,
// [6.5,7.0 ]: m=2 maxabs=3.668940151690947e-16 maxrel=6.088238447957024e-14
0.005507616273521607,
-0.0009765630276598874,
0.00011575002566152883,
-0.000011054200966295066,
9.000257894754303e-7,
-6.40827683525825e-8,
4.057311359109799e-9,
-2.302796088467665e-10,
// [6.5,7.0 ]: m=3 maxabs=3.0964814046186007e-16 maxrel=1.4061179891399198e-13
0.001953126055319614,
-0.0004630001024609804,
0.0000663252058122904,
-7.200213718389737e-6,
6.408274858418299e-7,
-4.861667800945747e-8,
3.2245544473097615e-9,
-1.8948502008647323e-10,
// [6.5,7.0 ]: m=4 maxabs=2.669305748659312e-16 maxrel=2.494390597137067e-13
0.0009260002049218296,
-0.00026530082309281715,
0.000043201282323103015,
-5.1266261409297835e-6,
4.861666091986267e-7,
-3.863460827984924e-8,
2.6533386984462416e-9,
-1.601302146635995e-10,
// [6.5,7.0 ]: m=5 maxabs=2.338624086051233e-16 maxrel=3.740568678311136e-13
0.0005306016461855218,
-0.00017280512915743396,
0.000030759756856473715,
-3.889338271941762e-6,
3.8634593739644953e-7,
-3.178824469941006e-8,
2.2422883538355397e-9,
-1.381780232172643e-10,
// [6.5,7.0 ]: m=6 maxabs=2.082752373344654e-16 maxrel=5.038459538078965e-13
0.0003456102583146623,
-0.00012303902730750895,
0.000023336029641455433,
-3.0907722352814397e-6,
3.1788231625254104e-7,
-2.6861994247602147e-8,
1.934911034647329e-9,
-1.2124153303186433e-10,
// [6.5,7.0 ]: m=7 maxabs=1.8724171518824662e-16 maxrel=6.289152521660465e-13
0.000246078054614924,
-0.00009334411846049968,
0.000018544633420742528,
-2.5430627424505982e-6,
2.686198210536684e-7,
-2.317849792513024e-8,
1.6977688247493143e-9,
-1.0782143286181342e-10,
// [6.5,7.0 ]: m=8 maxabs=1.7149367863289466e-16 maxrel=7.525749994067991e-13
0.0001866882369209077,
-0.00007417853358788439,
0.000015258376462448673,
-2.1489623755627205e-6,
2.3178483657457032e-7,
-2.0336785686326918e-8,
1.510021824896584e-9,
-9.693155052494263e-11,
// [6.5,7.0 ]: m=9 maxabs=1.5569143196891844e-16 maxrel=8.538413317548322e-13
0.00014835706717520247,
-0.00006103350576073996,
0.000012893774289679082,
-1.8542821699292688e-6,
2.0336746572373228e-7,
-1.808713218357938e-8,
1.358139765372855e-9,
-8.805292262683132e-11,
// [6.5,7.0 ]: m=10 maxabs=1.4338573731120796e-16 maxrel=9.505111834082578e-13
0.00012206701152140905,
-0.00005157509708002205,
0.000011125693026369383,
-1.6269428734450834e-6,
1.8087123124862283e-7,
-1.626746025487718e-8,
1.2330308710183263e-9,
-8.057769275158555e-11
},
{
// [7.0,7.5 ]: m=0 maxabs=3.3306690738754696e-16 maxrel=9.945233054831201e-16
0.32909028563741366,
-0.011323452112019636,
0.0005795736059406165,
-0.00003228846242390565,
1.8208950316577646e-6,
-1.0026654332354007e-7,
5.2819721349784174e-9,
-2.621489307694311e-10,
// [7.0,7.5 ]: m=1 maxabs=2.949029909160572e-16 maxrel=1.2361603809030116e-14
0.02264690422403918,
-0.0023182944235611677,
0.00019373077457871484,
-0.000014567168084894544,
1.0026648802118502e-6,
-6.330968146830864e-8,
3.6719381867353845e-9,
-1.9527941004223735e-10,
// [7.0,7.5 ]: m=2 maxabs=2.419939248987646e-16 maxrel=4.794859750034221e-14
0.004636588847122169,
-0.0007749230981644233,
0.00008740300852575095,
-8.02132503537155e-6,
6.330965959163419e-7,
-4.400583255170606e-8,
2.7346147351288533e-9,
-1.5296367433153158e-10,
// [7.0,7.5 ]: m=3 maxabs=2.0144476364780672e-16 maxrel=1.1594971862839323e-13
0.0015498461963287492,
-0.0003496120339813419,
0.000048127950222187104,
-5.064777629333603e-6,
4.400581929747752e-7,
-3.27687128684096e-8,
2.141917037573847e-9,
-1.2442383233422241e-10,
// [7.0,7.5 ]: m=4 maxabs=1.723881454251952e-16 maxrel=2.145362600196647e-13
0.0006992240679625946,
-0.00019251180078693982,
0.000030388665784458958,
-3.520469614729097e-6,
3.2768701644392263e-7,
-2.5663931627382592e-8,
1.7422919929831644e-9,
-1.041805837581037e-10,
// [7.0,7.5 ]: m=5 maxabs=1.5016200088924236e-16 maxrel=3.326392085086719e-13
0.0003850236015738055,
-0.00012155466305068855,
0.000021122817695508972,
-2.6214996172003335e-6,
2.5663922107895584e-7,
-2.0874043253217078e-8,
1.4588330309426998e-9,
-8.922578344154124e-11,
// [7.0,7.5 ]: m=6 maxabs=1.36501053515925e-16 maxrel=4.714126587691724e-13
0.0002431093261011823,
-0.00008449127070608004,
0.00001572899771058441,
-2.053116805006232e-6,
2.087403345234069e-7,
-1.7476857326349154e-8,
1.2494720162466253e-9,
-7.769157064633346e-11,
// [7.0,7.5 ]: m=7 maxabs=1.1907250359322052e-16 maxrel=5.844325739520678e-13
0.00016898254141203603,
-0.00006291599077030968,
0.000012318700854260338,
-1.669925488084089e-6,
1.7476810820353314e-7,
-1.4967296381359213e-8,
1.0895208499334521e-9,
-6.884441185223648e-11,
// [7.0,7.5 ]: m=8 maxabs=1.0766127572781059e-16 maxrel=7.029388008278382e-13
0.00012583198154058774,
-0.00004927480335682515,
0.000010019552933591847,
-1.3981472738721776e-6,
1.4967289598290456e-7,
-1.3051131255013747e-8,
9.640388772814026e-10,
-6.165032221306524e-11,
// [7.0,7.5 ]: m=9 maxabs=9.82287168271867e-17 maxrel=8.128546253858416e-13
0.00009854960671360192,
-0.000040078211679909175,
8.388883647885209e-6,
-1.197385346136301e-6,
1.3051125052820962e-7,
-1.1547555278000964e-8,
8.633029036418242e-10,
-5.576304192880846e-11,
// [7.0,7.5 ]: m=10 maxabs=9.027338338657431e-17 maxrel=9.1306670748376e-13
0.00008015642335977368,
-0.00003355553454186632,
7.184312081096618e-6,
-1.0440919911756362e-6,
1.1547549576059805e-7,
-1.0340560209493828e-8,
7.808650264209877e-10,
-5.0865643239051636e-11
},
{
// [7.5,8.0 ]: m=0 maxabs=2.220446049250313e-16 maxrel=6.862345985369669e-16
0.31831584432385973,
-0.010254358122041259,
0.0004927048886768897,
-0.000025910555121330713,
1.3903225824211272e-6,
-7.349142312794843e-8,
3.747380414035669e-9,
-1.8150865414174106e-10,
// [7.5,8.0 ]: m=1 maxabs=1.942890293094024e-16 maxrel=9.022251034019006e-15
0.020508716244082743,
-0.00197081955457004,
0.00015546333071137498,
-0.000011122585993880428,
7.349145907935129e-7,
-4.491829536684978e-8,
2.5395620975180774e-9,
-1.3241242273033808e-10,
// [7.5,8.0 ]: m=2 maxabs=1.5785983631388945e-16 maxrel=3.696939878494884e-14
0.0039416391091399924,
-0.0006218533227459124,
0.00006673551597059552,
-5.879320711281187e-6,
4.4918286470903907e-7,
-3.0436471918845966e-8,
1.8540398443338141e-9,
-1.0210357860166756e-10,
// [7.5,8.0 ]: m=3 maxabs=1.3097162243624894e-16 maxrel=9.44643878329686e-14
0.0012437066454918208,
-0.00026694206380216374,
0.00003527592427357339,
-3.593466122491069e-6,
3.04364640939237e-7,
-2.221771584267003e-8,
1.4296991514745389e-9,
-8.203067509808804e-11,
// [7.5,8.0 ]: m=4 maxabs=1.3032110113275763e-16 maxrel=2.1359038485870588e-13
0.0005338841276043796,
-0.00014110369702782582,
0.000021560796739899452,
-2.4349197847621462e-6,
2.2217709365039542e-7,
-1.7130884036917182e-8,
1.148629560327401e-9,
-6.800931794423066e-11,
// [7.5,8.0 ]: m=5 maxabs=9.660241356845845e-17 maxrel=2.934328707698986e-13
0.00028220739405563207,
-0.00008624318690440888,
0.00001460951871334191,
-1.7774189575104432e-6,
1.7130878257016077e-7,
-1.3762217087986312e-8,
9.522852831972138e-10,
-5.777674347241916e-11,
// [7.5,8.0 ]: m=6 maxabs=7.665309359472516e-17 maxrel=3.747367964788636e-13
0.00017248637380877353,
-0.000058438074804511366,
0.000010664513749423469,
-1.3704722154569662e-6,
1.376221112863547e-7,
-1.140864835180038e-8,
8.090625588655964e-10,
-5.0072482299695445e-11,
// [7.5,8.0 ]: m=7 maxabs=7.592125712829745e-17 maxrel=5.407267702987919e-13
0.00011687614960892376,
-0.00004265805495350862,
8.222833298646404e-6,
-1.1009786559576985e-6,
1.1408649251159856e-7,
-9.692041026004164e-9,
7.008430562327361e-10,
-4.4041199306886125e-11,
// [7.5,8.0 ]: m=8 maxabs=6.833184192089892e-17 maxrel=6.599963845256289e-13
0.00008531610990701348,
-0.00003289133315624587,
6.605871938922538e-6,
-9.126934734805401e-7,
9.692036827966726e-8,
-8.39539497643855e-9,
6.167098170199638e-10,
-3.926192602234564e-11,
// [7.5,8.0 ]: m=9 maxabs=6.211123195626334e-17 maxrel=7.718954806799161e-13
0.00006578266631245138,
-0.000026423487721348867,
5.476160844312111e-6,
-7.753643197450927e-7,
8.395391604818038e-8,
-7.387309251993166e-9,
5.497122191432776e-10,
-3.5367342042320544e-11,
// [7.5,8.0 ]: m=10 maxabs=5.687995647402078e-17 maxrel=8.743884663406151e-13
0.00005284697544266962,
-0.00002190464334584962,
4.652185921171342e-6,
-6.716325843226906e-7,
7.387305649831987e-8,
-6.5844896631469905e-9,
4.952581097927104e-10,
-3.2151912705053637e-11
},
{
// [8.0,8.5 ]: m=0 maxabs=1.1102230246251565e-16 maxrel=3.54354369844392e-16
0.3085296009370361,
-0.009341464920598007,
0.00042263281037406943,
-0.00002101521951538335,
1.0732090188495387e-6,
-5.4415289342891514e-8,
2.6822983351906977e-9,
-1.263575988103175e-10,
// [8.0,8.5 ]: m=1 maxabs=1.3183898417423734e-16 maxrel=6.739949555921986e-15
0.01868292984119599,
-0.0016905312414026274,
0.00012609131711320846,
-8.58567575824963e-6,
5.441526585068495e-7,
-3.215345396034074e-8,
1.7696122909347558e-9,
-9.031779014030725e-11,
// [8.0,8.5 ]: m=2 maxabs=1.0581813203458523e-16 maxrel=2.9017595063893634e-14
0.0033810624828051333,
-0.0005043652683855726,
0.00005151405455939277,
-4.3532239528194796e-6,
3.215344081130449e-7,
-2.120962179765292e-8,
1.2648703626221259e-9,
-6.84994475783229e-11,
// [8.0,8.5 ]: m=3 maxabs=6.591949208711867e-17 maxrel=5.892910051731321e-14
0.0010087305367711828,
-0.00020605621818319504,
0.000026119343725935215,
-2.5722774042221066e-6,
2.1209612125498676e-7,
-1.515797589173297e-8,
9.592726755230017e-10,
-5.449642710154072e-11,
// [8.0,8.5 ]: m=4 maxabs=7.258733544790452e-17 maxrel=1.5495827740638515e-13
0.00041211243636941994,
-0.00010447737484919056,
0.0000154336643226532,
-1.6967708736407509e-6,
1.515806992658126e-7,
-1.1494013780279412e-8,
7.605173135962599e-10,
-4.4549665618053583e-11,
// [8.0,8.5 ]: m=5 maxabs=6.236872997222864e-17 maxrel=2.5716275512073e-13
0.00020895474969834788,
-0.00006173465725395225,
0.000010180625245009876,
-1.2126470602286443e-6,
1.1494009551964588e-7,
-9.11213522164753e-9,
6.238309391967219e-10,
-3.752326356199036e-11,
// [8.0,8.5 ]: m=6 maxabs=5.4508264221708735e-17 maxrel=3.7393228931998234e-13
0.00012346931450787568,
-0.00004072250094851651,
7.2758823641193224e-6,
-9.19522024962629e-7,
9.1121315629974e-8,
-7.473867921601038e-9,
5.254426913765094e-10,
-3.227518699604291e-11,
// [8.0,8.5 ]: m=7 maxabs=4.8382521947165635e-17 maxrel=4.963733070464806e-13
0.00008144500189700771,
-0.00002910352942890366,
5.517132152183778e-6,
-7.289716279618344e-7,
7.473864720779588e-8,
-6.294724406712643e-9,
4.5195487038690195e-10,
-2.8234108911123524e-11,
// [8.0,8.5 ]: m=8 maxabs=4.3408744480888384e-17 maxrel=6.164821359134968e-13
0.000058207058857785304,
-0.000022068528584275623,
4.373829769886195e-6,
-5.979101559638131e-7,
6.294721584323915e-8,
-5.4140672098712356e-9,
3.953678683235171e-10,
-2.5042419812775235e-11,
// [8.0,8.5 ]: m=9 maxabs=3.699839913606784e-17 maxrel=6.870887183501063e-13
0.00004413705716852867,
-0.000017495319057730757,
3.587460936942529e-6,
-5.035785986362313e-7,
5.414065161510909e-8,
-4.73603274458389e-9,
3.506670925967916e-10,
-2.2376138520718236e-11,
// [8.0,8.5 ]: m=10 maxabs=3.589386817284823e-17 maxrel=8.351652101032338e-13
0.00003499063811517927,
-0.000014349843730842047,
3.0214716281524306e-6,
-4.331259693961307e-7,
4.7359868023962323e-8,
-4.200466371441176e-9,
3.146134843592663e-10,
-2.035109835553447e-11
},
{
// [8.5,9.0 ]: m=0 maxabs=2.220446049250313e-16 maxrel=7.305012809221604e-16
0.2995907749600616,
-0.008555208960998274,
0.0003655199460198421,
-0.000017217067282633242,
8.372725235108247e-7,
-4.070166592184655e-8,
1.937384913704568e-9,
-8.87587296740098e-11,
// [8.5,9.0 ]: m=1 maxabs=9.020562075079397e-17 maxrel=5.0484038102564215e-15
0.017110417921996888,
-0.0014620797840250656,
0.00010330240369089694,
-6.698182476805079e-6,
4.0701666364761457e-7,
-2.3225860933629963e-8,
1.2427341843241714e-9,
-6.200808672773903e-11,
// [8.5,9.0 ]: m=2 maxabs=7.068998164605489e-17 maxrel=2.2503891547613554e-14
0.0029241595680499265,
-0.0004132096147181114,
0.00004018909487268606,
-3.2561351257299627e-6,
2.3225845751614302e-7,
-1.4895433242831436e-8,
8.685842984815151e-10,
-4.620984355720776e-11,
// [8.5,9.0 ]: m=3 maxabs=5.551115123125783e-17 maxrel=6.087259475116912e-14
0.0008264192294363255,
-0.00016075637945777075,
0.000019536810761159144,
-1.858069041524677e-6,
1.489542585390353e-7,
-1.0409635003534003e-8,
6.471497002915554e-10,
-3.579186490608033e-11,
// [8.5,9.0 ]: m=4 maxabs=4.7488055154865094e-17 maxrel=1.306306503939942e-13
0.0003215127589106928,
-0.00007814724300230278,
0.00001114841444121941,
-1.191635448294813e-6,
1.0409455288181411e-7,
-7.753991054807804e-9,
5.058110916751604e-10,
-2.9293904623408993e-11,
// [8.5,9.0 ]: m=5 maxabs=4.03594258707729e-17 maxrel=2.2361291123960667e-13
0.00015629448600458328,
-0.00004459365774099482,
7.149812691881591e-6,
-8.327573781777547e-7,
7.753988253820864e-8,
-6.060564966412467e-9,
4.102042110486843e-10,
-2.4446776775392153e-11,
// [8.5,9.0 ]: m=6 maxabs=3.507394027990607e-17 maxrel=3.3461892254036525e-13
0.00008918731548197123,
-0.00002859925074714492,
4.996544270848169e-6,
-6.203198755334595e-7,
6.060562589308933e-8,
-4.914624547322667e-9,
3.423309205764945e-10,
-2.086886587971109e-11,
// [8.5,9.0 ]: m=7 maxabs=3.0913314442992945e-17 maxrel=4.5336826941474345e-13
0.000057198501494273744,
-0.000019986177065673794,
3.7219192547447093e-6,
-4.84845715845977e-7,
4.9146224875953445e-8,
-4.101167786775218e-9,
2.922300612724666e-10,
-1.8141584132335677e-11,
// [8.5,9.0 ]: m=8 maxabs=2.7633602871224294e-17 maxrel=5.733673597230616e-13
0.00003997235413133346,
-0.0000148876770033478,
2.9090742964295263e-6,
-3.9317042424763164e-7,
4.101165982978315e-8,
-3.5007584130291267e-9,
2.540398910489559e-10,
-1.600619725495811e-11,
// [8.5,9.0 ]: m=9 maxabs=2.4936649967166602e-17 maxrel=6.883527521755895e-13
0.00002977535400667533,
-0.000011636297171752704,
2.3590225467077854e-6,
-3.28093837079089e-7,
3.5007567849794734e-8,
-3.0431176291212618e-9,
2.2413883728939222e-10,
-1.4296241216895981e-11,
// [8.5,9.0 ]: m=10 maxabs=2.2690318591048197e-17 maxrel=7.955994422692421e-13
0.000023272594343493966,
-9.436090174232341e-6,
1.9685630235739384e-6,
-2.800610467286192e-7,
3.0431161608929535e-8,
-2.684828367553261e-9,
2.0019441044714857e-10,
-1.2900461330399836e-11
},
{
// [9.0,9.5 ]: m=0 maxabs=2.220446049250313e-16 maxrel=7.516681238125082e-16
0.2913846672994536,
-0.00787266366614606,
0.00031851263747722424,
-0.00001423918225192913,
6.599453857605646e-7,
-3.075259525720967e-8,
1.4123840576281755e-9,
-6.267990005594356e-11,
// [9.0,9.5 ]: m=1 maxabs=5.898059818321144e-17 maxrel=3.595415267806771e-15
0.015745327332291423,
-0.0012740505498599023,
0.00008543509356537788,
-5.279564850602134e-6,
3.0752523518282473e-7,
-1.693236452164102e-8,
8.797728604847063e-10,
-4.288266678935936e-11,
// [9.0,9.5 ]: m=2 maxabs=4.683753385137379e-17 maxrel=1.7174163202523714e-14
0.002548101099719575,
-0.000341740374230723,
0.000031677389108395944,
-2.460203112098894e-6,
1.6932358576615704e-7,
-1.0545493985208449e-8,
6.005442451410246e-10,
-3.134951698992406e-11,
// [9.0,9.5 ]: m=3 maxabs=3.7947076036992655e-17 maxrel=5.054878920279056e-14
0.000683480748461407,
-0.00012670955640995928,
0.000014761218675789099,
-1.354589629835588e-6,
1.0545489952468237e-7,
-7.197476609451293e-9,
4.3901884852605105e-10,
-2.413841941839321e-11,
// [9.0,9.5 ]: m=4 maxabs=3.0899761915836876e-17 maxrel=1.0838843933238341e-13
0.0002534191128198999,
-0.00005904487468426427,
8.127537780879046e-6,
-8.43639951604055e-7,
7.197474080061158e-8,
-5.260974510967547e-9,
3.3801950107453293e-10,
-1.9339303546099848e-11,
// [9.0,9.5 ]: m=5 maxabs=2.6183482465524932e-17 maxrel=1.9297159962462966e-13
0.0001180897493685136,
-0.00003251015110790135,
5.061839711034586e-6,
-5.757985508072079e-7,
5.2609726341502394e-8,
-4.050240679404307e-9,
2.7081027015148855e-10,
-1.5980679819982384e-11,
// [9.0,9.5 ]: m=6 maxabs=2.256495771485456e-17 maxrel=2.966617116401837e-13
0.00006502030221579064,
-0.000020247358830918935,
3.4547913060030116e-6,
-4.208783394055876e-7,
4.0502391340984247e-8,
-3.244648495847737e-9,
2.2377896339248242e-10,
-1.3531825454887149e-11,
// [9.0,9.5 ]: m=7 maxabs=2.5038293920837118e-17 maxrel=5.20782302851087e-13
0.00004049471766183082,
-0.000013819165212643214,
2.5252700372126652e-6,
-3.2401958498122773e-7,
3.2446469606977555e-8,
-2.6809746874567858e-9,
1.8949941066856496e-10,
-1.168081762882836e-11,
// [9.0,9.5 ]: m=8 maxabs=1.7611509039311413e-17 maxrel=5.303218511166637e-13
0.000027638330425188728,
-0.000010101080139647768,
1.9441175241522866e-6,
-2.595721754557137e-7,
2.6809644349802097e-8,
-2.2700049222163753e-9,
1.6362301807613768e-10,
-1.0251664104225534e-11,
// [9.0,9.5 ]: m=9 maxabs=1.5819187322921313e-17 maxrel=6.454691485824654e-13
0.000020202160279284603,
-7.776470087704445e-6,
1.5574330535025686e-6,
-2.144775107893254e-7,
2.2700038950647027e-8,
-1.9600587626692244e-9,
1.4355622056975902e-10,
-9.113129194668465e-12,
// [9.0,9.5 ]: m=10 maxabs=1.098093512820475e-17 maxrel=5.775334963359941e-13
0.000015552940175408568,
-6.229732205956667e-6,
1.2868650647342412e-6,
-1.8160063491720463e-7,
1.960058453238664e-8,
-1.7195742397325034e-9,
1.275993924094761e-10,
-8.256553913760531e-12
},
{
// [9.5,10. ]: m=0 maxabs=1.6653345369377348e-16 maxrel=5.791939648379163e-16
0.2838169076324133,
-0.007275861870991553,
0.0002794671574563395,
-0.000011880760299808352,
5.25325839395937e-7,
-2.346730412407927e-8,
1.0391506513073553e-9,
-4.476487797048936e-11,
// [9.5,10. ]: m=1 maxabs=3.8163916471489756e-17 maxrel=2.522563755377056e-15
0.014551723741983597,
-0.00111786862980066,
0.00007128456176341692,
-4.202607686402373e-6,
2.3467295274639464e-7,
-1.2459459551843213e-8,
6.279867211692149e-10,
-2.985175594650605e-11,
// [9.5,10. ]: m=2 maxabs=3.122502256758253e-17 maxrel=1.3093059660017168e-14
0.0022357372596010106,
-0.0002851382470326703,
0.00002521564612400673,
-1.8773844627938926e-6,
1.2459451649134018e-7,
-7.527794218947844e-9,
4.181820053939858e-10,
-2.1399522227628977e-11,
// [9.5,10. ]: m=3 maxabs=3.3285006695304986e-17 maxrel=5.337100825023452e-14
0.0005702764940653161,
-0.00010086258448030989,
0.000011264306779148694,
-9.967567595362977e-7,
7.527791224427852e-8,
-5.012161313383381e-9,
2.996760255453514e-10,
-1.6079139803407928e-11,
// [9.5,10. ]: m=4 maxabs=2.0328790734103208e-17 maxrel=9.00191330479636e-14
0.00020172516896031773,
-0.00004505722710030848,
5.980540595355246e-6,
-6.022238868706684e-7,
5.012101381598683e-8,
-3.591017884079428e-9,
2.2703037956579667e-10,
-1.28215228214209e-11,
// [9.5,10. ]: m=5 maxabs=8.551644635479416e-18 maxrel=8.300043381312621e-14
0.00009011445420074125,
-0.000023922162370195318,
3.6133433198455463e-6,
-4.009685391280409e-7,
3.591017899062409e-8,
-2.720318943055353e-9,
1.7951920218918997e-10,
-1.0699694676578708e-11,
// [9.5,10. ]: m=6 maxabs=1.4602848010664138e-17 maxrel=2.621218848495555e-13
0.000047844324742344396,
-0.00001445337327999189,
2.4058111215145796e-6,
-2.8728167595484225e-7,
2.7204320090920516e-8,
-2.151189832747458e-9,
1.4680193352161433e-10,
-8.800553073197512e-12,
// [9.5,10. ]: m=7 maxabs=1.2793585635328952e-17 maxrel=3.7432337027792617e-13
0.00002890674655998047,
-9.62324447876221e-6,
1.7236900554439701e-6,
-2.176348570147493e-7,
2.1511896285740673e-8,
-1.7587796947964908e-9,
1.2322124500882832e-10,
-7.576812408752952e-12,
// [9.5,10. ]: m=8 maxabs=1.123504501238104e-17 maxrel=4.875690921376337e-13
0.000019246488957372175,
-6.894760219091139e-6,
1.3058091334375192e-6,
-1.7209537453899945e-7,
1.758792961244117e-8,
-1.4763567389205068e-9,
1.0565515405390735e-10,
-6.5802621767116186e-12,
// [9.5,10. ]: m=9 maxabs=1.0076303940537157e-17 maxrel=6.041734348256293e-13
0.000013789520438177452,
-5.223236528072339e-6,
1.032572247734736e-6,
-1.4070366413991943e-7,
1.4763560696648391e-8,
-1.2656799067416062e-9,
9.214502312472045e-11,
-5.8190077198386375e-12,
// [9.5,10. ]: m=10 maxabs=9.09205165582766e-18 maxrel=7.137591135673302e-13
0.000010446473056119423,
-4.130288985844391e-6,
8.442219858802489e-7,
-1.1810868943974875e-7,
1.265678761244282e-8,
-1.1037855567336867e-9,
8.149952566131085e-11,
-5.2081879264071246e-12
},
{
// [10.,11. ]: m=0 maxabs=1.1102230246251565e-16 maxrel=3.961582024432231e-16
0.27680913501250665,
-0.006750579939308897,
0.0002467568422952205,
-9.994833523432409e-6,
4.221170605463074e-7,
-1.8082833684735674e-8,
7.718880022084685e-10,
-3.2247039753817565e-11,
// [10.,11. ]: m=1 maxabs=2.949029909160572e-17 maxrel=2.104931448266398e-15
0.013501159878617124,
-0.0009870273691465477,
0.00005996900116594163,
-3.3769375653596498e-6,
1.8082811950901274e-7,
-9.253818988313109e-9,
4.520541885179563e-10,
-2.094526870085777e-11,
// [10.,11. ]: m=2 maxabs=2.168404344971009e-17 maxrel=1.0329448989256412e-14
0.001974054738292747,
-0.00023987600464910882,
0.000020261625394384237,
-1.446625536016574e-6,
9.25381554907887e-8,
-5.419119273753833e-9,
2.933469708617774e-10,
-1.4696625218322466e-11,
// [10.,11. ]: m=3 maxabs=1.6154612370034016e-17 maxrel=3.0915478501554705e-14
0.00047975200929805236,
-0.00008104650156653717,
8.67975321947174e-6,
-7.403056704983469e-7,
5.41911590843102e-8,
-3.5160790392576645e-9,
2.0584580947809666e-10,
-1.088729128467538e-11,
// [10.,11. ]: m=4 maxabs=1.3335686721571705e-17 maxrel=7.38330657541583e-14
0.0001620930031335041,
-0.000034719012862223315,
4.441834038992956e-6,
-4.3352971458850283e-7,
3.516052189548495e-8,
-2.4665961894593373e-9,
1.5329557815217812e-10,
-8.538314230702325e-12,
// [10.,11. ]: m=5 maxabs=1.1085967213664283e-17 maxrel=1.4031315811328995e-13
0.00006943802572444004,
-0.00001776733614923076,
2.601178288167167e-6,
-2.8128444479494594e-7,
2.4665953434918684e-8,
-1.8369583707985794e-9,
1.1956335613825018e-10,
-6.9032384938002566e-12,
// [10.,11. ]: m=6 maxabs=9.432558900623889e-18 maxrel=2.2903001226330704e-13
0.00003553467229845658,
-0.000010404713147062688,
1.6877066692503077e-6,
-1.9732785173518947e-7,
1.8369577254750227e-8,
-1.4326072525399067e-9,
9.66660451850216e-11,
-5.74174398284498e-12,
// [10.,11. ]: m=7 maxabs=8.175562006898507e-18 maxrel=3.336945850403564e-13
0.00002080942629403849,
-6.750826672251728e-6,
1.1839671108233689e-6,
-1.4695680886902412e-7,
1.4326067044024342e-8,
-1.1581605771399196e-9,
8.040196764705727e-11,
-4.88517423837336e-12,
// [10.,11. ]: m=8 maxabs=7.196391919872536e-18 maxrel=4.468392105003279e-13
0.000013501653344457608,
-4.735868439156764e-6,
8.817408535771626e-7,
-1.146087017063862e-7,
1.1581600948817138e-8,
-9.632361319057168e-10,
6.840785900441878e-11,
-4.23343879646509e-12,
// [10.,11. ]: m=9 maxabs=6.417121608398579e-18 maxrel=5.619519668429002e-13
9.471736878310258e-6,
-3.5269634106719105e-6,
6.876522105527088e-7,
-9.265295306483474e-8,
9.63235712501202e-9,
-8.194977188952524e-10,
5.928157039268416e-11,
-3.7243081129398335e-12,
// [10.,11. ]: m=10 maxabs=5.768294370801785e-18 maxrel=6.724224782956091e-13
7.053926821332225e-6,
-2.7506088389702975e-6,
5.559177186700462e-7,
-7.705898659054726e-8,
8.194973443769623e-9,
-7.101347558276647e-10,
5.215229996577959e-11,
-3.3176208787687474e-12
},
{
// [11.,11. ]: m=0 maxabs=5.551115123125783e-17 maxrel=2.0297004015710748e-16
0.27029572185648826,
-0.006285448289492548,
0.00021913514145146604,
-8.4728296928364e-6,
3.422268131844245e-7,
-1.4066047622123804e-8,
5.785985202523054e-10,
-2.3402914926821186e-11,
// [11.,11. ]: m=1 maxabs=2.42861286636753e-17 maxrel=1.8649750167346127e-15
0.012570896578984282,
-0.0008765405657824668,
0.000050836978197376255,
-2.7378152816117934e-6,
1.4066017154007477e-7,
-6.936812506610048e-9,
3.2820277940721196e-10,
-1.4805405119039128e-11,
// [11.,11. ]: m=2 maxabs=1.474514954580286e-17 maxrel=7.931734564837422e-15
0.0017530811315645248,
-0.0002033479127792101,
0.000016426891691308853,
-1.1252817765718002e-6,
6.93681043653651e-8,
-3.93459557274311e-9,
2.0734166598742233e-10,
-1.0161353755055634e-11,
// [11.,11. ]: m=3 maxabs=1.1167282376600696e-17 maxrel=2.5304879965088253e-14
0.0004066958255584124,
-0.00006570756675796077,
6.751690660276536e-6,
-5.549451257290826e-7,
3.934594470577051e-8,
-2.485311017591835e-9,
1.4229313452858756e-10,
-7.432820773073039e-12,
// [11.,11. ]: m=4 maxabs=8.863352760068999e-18 maxrel=6.079455418238858e-14
0.00013141513351591573,
-0.000027006762635503833,
3.329670754977535e-6,
-3.14767781176147e-7,
2.485310200621451e-8,
-1.7053740321558176e-9,
1.0408589408780865e-10,
-5.712849321717116e-12,
// [11.,11. ]: m=5 maxabs=7.26415455565288e-18 maxrel=1.1875165035870007e-13
0.00005401352527100355,
-0.000013318683015452878,
1.8886066874596903e-6,
-1.9882499432655546e-7,
1.7053734921629623e-8,
-1.2473193293898727e-9,
7.99971807946513e-11,
-4.563684454435293e-12,
// [11.,11. ]: m=6 maxabs=6.118966010965066e-18 maxrel=1.9911585981322192e-13
0.000026637366030902266,
-7.554426746166635e-6,
1.1929499662883885e-6,
-1.3643002622378785e-7,
1.2473188920546572e-8,
-9.585565746835908e-10,
6.390557293666204e-11,
-3.758672773146894e-12,
// [11.,11. ]: m=7 maxabs=5.603969979034451e-18 maxrel=3.16385117308785e-13
0.000015108853492303542,
-4.77179986158395e-6,
8.185801568827893e-7,
-9.978564124580556e-8,
9.58556817832628e-9,
-7.656440731744691e-10,
5.2618989020568776e-11,
-3.2342615253923006e-12,
// [11.,11. ]: m=8 maxabs=9.24959978401696e-19 maxrel=8.156237375673351e-14
9.543599724093583e-6,
-3.274320627577209e-6,
5.987138121846718e-7,
-7.66846086367146e-8,
7.65676858923058e-9,
-6.305410396287151e-10,
4.4422125502883625e-11,
-2.7836883446614733e-12,
// [11.,11. ]: m=9 maxabs=4.092863201132779e-18 maxrel=5.201141117999795e-13
6.5486412555004225e-6,
-2.3948552450687815e-6,
4.601076282860728e-7,
-6.125425895539698e-8,
6.3056706723548385e-9,
-5.321201007091854e-10,
3.823184920814443e-11,
-2.3882165463554512e-12,
// [11.,11. ]: m=10 maxabs=3.668499694558375e-18 maxrel=6.315786873228192e-13
4.7897104901280525e-6,
-1.8404305110756068e-6,
3.6752555391090963e-7,
-5.044544807885064e-8,
5.32119862726768e-9,
-4.579882660924598e-10,
3.3442650823427534e-11,
-2.1171498561560345e-12
},
{
// [11.,11. ]: m=0 maxabs=5.551115123125783e-17 maxrel=2.0774607158083475e-16
0.26422126459516876,
-0.00587129460661132,
0.00019563755745968133,
-7.233791664754482e-6,
2.7980858087649736e-7,
-1.1041807641498573e-8,
4.3767079272059e-10,
-1.7143995818485288e-11,
// [11.,11. ]: m=1 maxabs=2.0816681711721685e-17 maxrel=1.7140122245123301e-15
0.011742589213222819,
-0.000782550229822104,
0.0000434027500078712,
-2.2384691880657538e-6,
1.1041791475104533e-7,
-5.247483148557468e-9,
2.4041704519694147e-10,
-1.0961612405767627e-11,
// [11.,11. ]: m=2 maxabs=9.75781955236954e-18 maxrel=5.894619098036467e-15
0.0015651004596450796,
-0.0001736110000126979,
0.000013430815015269212,
-8.833438735184653e-7,
5.247662650895672e-8,
-2.881435921607753e-9,
1.476928097937117e-10,
-7.0724652062038345e-12,
// [11.,11. ]: m=3 maxabs=7.589415207398531e-18 maxrel=2.0213484697843157e-14
0.00034722200002538725,
-0.00005372326005608137,
5.30006324180449e-6,
-4.198132107428646e-7,
2.8814349943238755e-8,
-1.770409546068767e-9,
9.904473075626083e-11,
-5.076292019966356e-12,
// [11.,11. ]: m=4 maxabs=5.8140341499535175e-18 maxrel=4.8978301066863143e-14
0.00010744652011215846,
-0.00002120025296345257,
2.5188792648619317e-6,
-2.305149498855025e-7,
1.770409009242061e-8,
-1.1870951938635998e-9,
7.108540625232223e-11,
-3.841323462675023e-12,
// [11.,11. ]: m=5 maxabs=1.889899911913795e-17 maxrel=3.95355786946598e-13
0.00004240050592752692,
-0.000010075517055189877,
1.3830896879997129e-6,
-1.4163285779696008e-7,
1.1871015268114362e-8,
-8.518046891015636e-10,
5.3667258564501e-11,
-3.1484163121104294e-12,
// [11.,11. ]: m=6 maxabs=3.991219247462263e-18 maxrel=1.7246583033337055e-13
0.000020151034112969872,
-5.5323587958790714e-6,
8.497970350727768e-7,
-9.496768434504968e-8,
8.518882327577145e-9,
-6.445485745502712e-10,
4.242493776469143e-11,
-2.469217377861718e-12,
// [11.,11. ]: m=7 maxabs=3.4135427774348304e-18 maxrel=2.642940310555746e-13
0.000011064717591756273,
-3.3991881382732502e-6,
5.698061062489373e-7,
-6.815113932491412e-8,
6.445483368598143e-9,
-5.083245368745242e-10,
3.457664550917905e-11,
-2.065840932606988e-12,
// [11.,11. ]: m=8 maxabs=2.9663093812845598e-18 maxrel=3.6862338794531017e-13
6.798376276544936e-6,
-2.2792244232715095e-6,
4.0890683609842913e-7,
-5.1563935911063013e-8,
5.083243382894742e-9,
-4.142577361670284e-10,
2.8928133037714662e-11,
-1.7653259376482103e-12,
// [11.,11. ]: m=9 maxabs=2.614790708174025e-18 maxrel=4.789904744161903e-13
4.558448846541689e-6,
-1.6356273428944142e-6,
3.0938361559437236e-7,
-4.0666007024925904e-8,
4.142575655344937e-9,
-3.465620082474223e-10,
2.4720023264376957e-11,
-1.5348337130376399e-12,
// [11.,11. ]: m=10 maxabs=2.332728736738343e-18 maxrel=5.897595198630181e-13
3.271254685781306e-6,
-1.2375344610540638e-6,
2.439960422644777e-7,
-3.314065811967048e-8,
3.4656185518550355e-9,
-2.961326631801179e-10,
2.1492569998529362e-11,
-1.3536510664118698e-12
},
{
// [11.,12. ]: m=0 maxabs=0. maxrel=0.
0.25853864294198275,
-0.005500654332279458,
0.00017551083334924674,
-6.216794329894424e-6,
2.3060207570098543e-7,
-8.744189051106713e-9,
3.3404713016428245e-10,
-1.2563192702964086e-11,
// [11.,12. ]: m=1 maxabs=1.3877787807814457e-17 maxrel=1.2214328522303118e-15
0.011001308664559771,
-0.0007020433333798314,
0.000037300766006450794,
-1.8448169959875445e-6,
8.744142208426338e-8,
-4.0055773036889986e-9,
1.775252546503511e-10,
-7.571364555419014e-12,
// [11.,12. ]: m=2 maxabs=9.75781955236954e-17 maxrel=6.586243868065359e-14
0.0014040866667522007,
-0.0001492030640391507,
0.000011068902110748738,
-6.995312945265412e-7,
4.005500955401749e-8,
-2.129777825163884e-9,
1.0738082111412231e-10,
-2.8720374112667925e-12,
// [11.,12. ]: m=3 maxabs=4.87890977618477e-18 maxrel=1.516910470184411e-14
0.00029840612804131976,
-0.00004427560790344808,
4.19718945507616e-6,
-3.2044622978576787e-7,
2.1284242909854838e-8,
-1.271142893059142e-9,
6.942485183549863e-11,
-3.4878662954542807e-12,
// [11.,12. ]: m=4 maxabs=3.903127820947816e-18 maxrel=4.0053290150158005e-14
0.00008855121580689286,
-0.0000167887578177627,
1.9226773790236746e-6,
-1.7027404483740984e-7,
1.2711424909062493e-8,
-8.321240452251456e-10,
4.8842740138285445e-11,
-2.5962232269272834e-12,
// [11.,12. ]: m=5 maxabs=3.1374100366299285e-18 maxrel=8.323912249743289e-14
0.00003357751563552328,
-7.690709514118438e-6,
1.0216442692267821e-6,
-1.0169147825058578e-7,
8.321237774173403e-9,
-5.85355074326213e-10,
3.6355655441234266e-11,
-2.0202068562807926e-12,
// [11.,12. ]: m=6 maxabs=6.406957213031528e-18 maxrel=3.6432258083358285e-13
0.000015381419028240763,
-4.086577074929881e-6,
6.101488708517451e-7,
-6.656997140792438e-8,
5.853535256162874e-9,
-4.35631850736833e-10,
2.8324406803311714e-11,
-1.6646098564243118e-12,
// [11.,12. ]: m=7 maxabs=2.2073678605447067e-18 maxrel=2.3236812012948293e-13
8.173154150631527e-6,
-2.440595477282653e-6,
3.994197949624657e-7,
-4.682844325514654e-8,
4.356570871003455e-9,
-3.3896195184610886e-10,
2.280008905537396e-11,
-1.3497167363555394e-12,
// [11.,12. ]: m=8 maxabs=1.9083652301639387e-18 maxrel=3.3160987200038684e-13
4.881190954564302e-6,
-1.5976791787320504e-6,
2.8097065962764524e-7,
-3.485261167895187e-8,
3.3896182290661614e-9,
-2.7317185639591556e-10,
1.890015359060953e-11,
-1.1445370985770424e-12,
// [11.,12. ]: m=9 maxabs=1.6745841367217518e-18 maxrel=4.391607382226453e-13
3.195358357463237e-6,
-1.1238826375450246e-6,
2.0911567015690917e-7,
-2.711698445411429e-8,
2.7317174533630064e-9,
-2.2643107847950538e-10,
1.6027072907124635e-11,
-9.88699911373966e-13,
// [11.,12. ]: m=10 maxabs=1.1934694226813092e-18 maxrel=4.4046750840333623e-13
2.2477652750857445e-6,
-8.364626797574041e-7,
1.6270190683028758e-7,
-2.185377378414389e-8,
2.2643095368855525e-9,
-1.9199809791301026e-10,
1.384554675360713e-11,
-8.701398959068976e-13
},
{
// [12.,12. ]: m=0 maxabs=5.551115123125783e-17 maxrel=2.1698331247411737e-16
0.2532075048282792,
-0.005167402443078996,
0.00015816137521131442,
-5.375569627432378e-6,
1.9147597502646364e-7,
-6.983014820613868e-9,
2.5721663038514465e-10,
-9.29766968991927e-12,
// [12.,12. ]: m=1 maxabs=6.938893903907228e-18 maxrel=6.509655714306437e-16
0.010334804886158603,
-0.0006326455008384624,
0.000032253417812114887,
-1.531808060640137e-6,
6.982948514037984e-8,
-3.084344241924467e-9,
1.3225545368793587e-10,
-5.4694675813107406e-12,
// [12.,12. ]: m=2 maxabs=4.553649124439119e-18 maxrel=3.4182260203197997e-15
0.001265291001676881,
-0.00012901367124474298,
9.190848368117546e-6,
-5.586360246945974e-7,
3.084338777461824e-8,
-1.585726224602128e-9,
7.674142959170242e-11,
-3.4992049170273532e-12,
// [12.,12. ]: m=3 maxabs=3.3610267347050637e-18 maxrel=1.2121467780654626e-14
0.0002580273424894782,
-0.00003676339347008628,
3.3518161487458823e-6,
-2.4674719701308915e-7,
1.5857254714391726e-8,
-9.199902286994546e-10,
4.90133620326404e-11,
-2.41167165880385e-12,
// [12.,12. ]: m=4 maxabs=2.6156377411212794e-18 maxrel=3.2445241412559835e-14
0.00007352678694017058,
-0.000013407264593253426,
1.480483182266363e-6,
-1.2685810676284258e-7,
9.199899800961628e-9,
-5.874982904165944e-10,
3.377134247292958e-11,
-1.7642961604936246e-12,
// [12.,12. ]: m=5 maxabs=2.0735366548785272e-18 maxrel=6.917469741312571e-14
0.00002681452918650526,
-5.92193272774357e-6,
7.611486407184293e-7,
-7.359925126387749e-8,
5.874981091934627e-9,
-4.047486624142967e-10,
2.4705789259624785e-11,
-1.3533375657055343e-12,
// [12.,12. ]: m=6 maxabs=1.7059243557701609e-18 maxrel=1.265269172048933e-13
0.000011843865455486127,
-3.044594561820344e-6,
4.4159550767773043e-7,
-4.699989085349456e-8,
4.0474853756765786e-9,
-2.960652069372823e-10,
1.8950699697042555e-11,
-1.077913700126231e-12,
// [12.,12. ]: m=7 maxabs=1.4374149114905477e-18 maxrel=2.039719691560984e-13
6.089189123639913e-6,
-1.7663820298464683e-6,
2.819993451952247e-7,
-3.237991757505073e-8,
2.9606510773558944e-9,
-2.2707656819407595e-10,
1.509397300347109e-11,
-8.848076458416193e-13,
// [12.,12. ]: m=8 maxabs=1.2332799712022613e-18 maxrel=2.9728757260581463e-13
3.532764059692292e-6,
-1.1279973800540505e-6,
1.9427950551261433e-7,
-2.3685237690225493e-8,
2.270764847874466e-9,
-1.808486010260843e-10,
1.2389982178604613e-11,
-7.441870078229867e-13,
// [12.,12. ]: m=9 maxabs=2.769797737521562e-18 maxrel=1.0325548832671612e-12
2.255994760098629e-6,
-7.771180215257838e-7,
1.4211142638595605e-7,
-1.8166141477011733e-8,
1.8084840753304177e-9,
-1.4845528840855801e-10,
1.042331923600777e-11,
-6.081290853824343e-13,
// [12.,12. ]: m=10 maxabs=9.512179997665793e-19 maxrel=5.093227484979241e-13
1.5542360428535233e-6,
-5.684457042409141e-7,
1.0899686238013258e-7,
-1.4467903973380994e-8,
1.484403012765347e-9,
-1.2484275476824904e-10,
8.94056020486699e-12,
-5.567942097881614e-13
},
{
// [12.,13. ]: m=0 maxabs=5.551115123125783e-17 maxrel=2.2145757956139306e-16
0.2481930729317521,
-0.004866473933555372,
0.00014311735922248193,
-4.674666707352554e-6,
1.6010879884210338e-7,
-5.621235031066313e-9,
1.9976383487438742e-10,
-7.166008834181681e-12,
// [12.,13. ]: m=1 maxabs=8.673617379884035e-18 maxrel=8.650815315050172e-16
0.009732947867111437,
-0.0005724694368808891,
0.000028048000237889603,
-1.280870664198026e-6,
5.621259048127048e-8,
-2.395217370075739e-9,
9.936565582369476e-11,
-3.996864104507978e-12,
// [12.,13. ]: m=2 maxabs=3.903127820947816e-18 maxrel=3.244457715900553e-15
0.0011449388737617893,
-0.00011219200094904005,
7.685223984903203e-6,
-4.4970082216066344e-7,
2.395217253533755e-8,
-1.1914476944150731e-9,
5.596876482940037e-11,
-2.5152251636391743e-12,
// [12.,13. ]: m=3 maxabs=2.358139725155972e-18 maxrel=9.807041997005103e-15
0.0002243840018980489,
-0.00003074089593877857,
2.6982049340672457e-6,
-1.9161741321394263e-7,
1.1914510586998055e-8,
-6.712139965164546e-10,
3.485739196622067e-11,
-1.678182430050477e-12,
// [12.,13. ]: m=4 maxabs=2.564138137928218e-17 maxrel=3.816932745529178e-13
0.00006148179187748236,
-0.000010792819736303416,
1.1497044793663564e-6,
-9.531610819448003e-8,
6.712145541220984e-9,
-4.179790057280063e-10,
2.3475912839634154e-11,
-9.344397212417673e-13,
// [12.,13. ]: m=5 maxabs=1.3857459017080354e-18 maxrel=5.765531990931574e-14
0.000021585639470169777,
-4.598817916925926e-6,
5.718967915055167e-7,
-5.369713608351859e-8,
4.17836074107939e-9,
-2.8168919605390556e-10,
1.688402691487924e-11,
-9.109901452296834e-13,
// [12.,13. ]: m=6 maxabs=1.128247885742728e-18 maxrel=1.0821134848493631e-13
9.197635833851131e-6,
-2.2875871653219236e-6,
3.221828165686828e-7,
-3.342691392113287e-8,
2.8168910589001248e-9,
-2.0233961671337163e-10,
1.2756751014890177e-11,
-7.165615747203317e-13,
// [12.,13. ]: m=7 maxabs=9.39359538505019e-19 maxrel=1.7815772826745543e-13
4.57517433064334e-6,
-1.2887312657059703e-6,
2.005614835761446e-7,
-2.2535151216576373e-8,
2.0233955074219133e-9,
-1.5286269652393158e-10,
1.0033975926675157e-11,
-5.820960697748745e-13,
// [12.,13. ]: m=8 maxabs=8.000226186816867e-19 maxrel=2.653905078823014e-13
2.577462531411509e-6,
-8.022459338303998e-7,
1.3521090734065845e-7,
-1.618718302157642e-8,
1.5286264176890084e-9,
-1.2022569413684878e-10,
8.151093539148785e-12,
-4.853516895524323e-13,
// [12.,13. ]: m=9 maxabs=6.924494343803905e-19 maxrel=3.642934180158304e-13
1.60449186766044e-6,
-5.408436289588941e-7,
9.712309816407004e-8,
-1.2229027489359855e-8,
1.202256479351796e-9,
-9.765810650261347e-11,
6.79640326633923e-12,
-4.1337611430775196e-13,
// [12.,13. ]: m=10 maxabs=6.090166890758419e-19 maxrel=4.700860744433599e-13
1.0816872579174747e-6,
-3.8849239230632634e-7,
7.337416496634527e-8,
-9.618065831493074e-9,
9.765806620070923e-10,
-8.142247808322723e-11,
5.788555589969917e-12,
-3.582844206464976e-13
},
{
// [13.,14. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.1292162577672176e-16
0.24346519637103445,
-0.004593649736315005,
0.00013000065128413485,
-4.086686872930483e-6,
1.3476474450050923e-7,
-4.559645247665849e-9,
1.5643896184367823e-10,
-5.306474896197827e-12,
// [13.,14. ]: m=1 maxabs=3.469446951953614e-18 maxrel=3.669986586913438e-16
0.00918729947263095,
-0.0005200026051241813,
0.00002452012125016583,
-1.0781182727878869e-6,
4.559617248800116e-8,
-1.875376649810867e-9,
7.528242360248925e-11,
-2.9310336766391844e-12,
// [13.,14. ]: m=2 maxabs=2.1467203015212988e-17 maxrel=1.968187170444216e-14
0.0010400052102480406,
-0.00009808048499924202,
6.4687096422118536e-6,
-3.647694435917124e-7,
1.8753694034461964e-8,
-9.028152980430594e-10,
4.126465434918005e-11,
-1.453646718860282e-12,
// [13.,14. ]: m=3 maxabs=1.4907779871675686e-18 maxrel=7.110289558684223e-15
0.0001961609699973374,
-0.000025874838559796657,
2.1886167349422043e-6,
-1.5002981631301493e-7,
9.026947480939698e-9,
-4.936603870075164e-10,
2.4975046919258284e-11,
-1.1757397615937118e-12,
// [13.,14. ]: m=4 maxabs=1.179069862577986e-18 maxrel=2.0919848437511847e-14
0.00005174967711959194,
-8.754466938946763e-6,
9.001788980030649e-7,
-7.221561247931647e-8,
4.936602203780847e-9,
-2.9938874367126724e-10,
1.6465686866374207e-11,
-8.288100527883268e-13,
// [13.,14. ]: m=5 maxabs=9.283481101907132e-19 maxrel=4.779695671809768e-14
0.00001750893387789274,
-3.600715591408811e-6,
4.332936749491566e-7,
-3.949284172849416e-8,
2.9938864755786778e-9,
-1.9735704583337247e-10,
1.160637747435534e-11,
-6.163686867281985e-13,
// [13.,14. ]: m=6 maxabs=7.420008617947671e-19 maxrel=9.12627584243784e-14
7.201431182817152e-6,
-1.7331746993296212e-6,
2.3695705041335464e-7,
-2.395111048778252e-8,
1.9735699050577473e-9,
-1.3909714431127708e-10,
8.630913896288468e-12,
-4.78422839504239e-13,
// [13.,14. ]: m=7 maxabs=6.140988867593677e-19 maxrel=1.5436392067080938e-13
3.46634939865888e-6,
-9.478282012779239e-7,
1.437066629609748e-7,
-1.5788574256547833e-8,
1.3909709867893089e-9,
-1.0342682234874214e-10,
6.699379988137421e-12,
-3.843809322580448e-13,
// [13.,14. ]: m=8 maxabs=5.183841637196318e-19 maxrel=2.347530244512003e-13
1.8956564025555686e-6,
-5.748266515338089e-7,
9.473144556612439e-8,
-1.1127780298029604e-8,
1.0342678657222578e-9,
-8.027348036874337e-11,
5.382477363793479e-12,
-3.175540697726579e-13,
// [13.,14. ]: m=9 maxabs=4.461746049662027e-19 maxrel=3.288204356748048e-13
1.1496533030673778e-6,
-3.7892578200240474e-7,
6.676668181087773e-8,
-8.274153409627124e-9,
8.027345023706719e-10,
-6.448908482026425e-11,
4.4467197544417035e-12,
-2.6837788530032127e-13,
// [13.,14. ]: m=10 maxabs=3.9069394692104603e-19 maxrel=4.318773741516191e-13
7.578515640046096e-7,
-2.670667270178203e-7,
4.9644920476999537e-8,
-6.421885046363356e-9,
6.448905921127263e-10,
-5.327397559953611e-11,
3.758108705443897e-12,
-2.310943985666417e-13
},
{
// [14.,14. ]: m=0 maxabs=1.1102230246251565e-16 maxrel=4.602907651882996e-16
0.23899759095537698,
-0.00434539133184247,
0.00011850581948885689,
-3.590276571367883e-6,
1.1413493680306594e-7,
-3.7252389207588526e-9,
1.2344357306603792e-10,
-4.036549280013731e-12,
// [14.,14. ]: m=1 maxabs=0. maxrel=0.
0.008690782663685979,
-0.00047402327794633783,
0.000021541659434262776,
-9.130797150127595e-7,
3.7252145781556624e-8,
-1.4799777442253682e-9,
5.750133898436696e-11,
-2.1741806866366096e-12,
// [14.,14. ]: m=2 maxabs=1.5178830414797062e-18 maxrel=1.5292951103143768e-15
0.0009480465558926494,
-0.00008616663773551253,
5.478478292428851e-6,
-2.980172220050588e-7,
1.4799748591884044e-8,
-6.895136362168194e-10,
3.052520805985981e-11,
-1.2876422123920208e-12,
// [14.,14. ]: m=3 maxabs=1.1384122811097797e-18 maxrel=6.195356684527421e-15
0.00017233327547102508,
-0.000021913913168857352,
1.788103332091145e-6,
-1.1839802212497373e-7,
6.895135633434764e-9,
-3.6598752608814057e-10,
1.8029233230195855e-11,
-8.294024514740294e-13,
// [14.,14. ]: m=4 maxabs=8.063753657860939e-19 maxrel=1.694465985850903e-14
0.00004382782633771373,
-7.152413327807142e-6,
7.103881328375874e-7,
-5.516110742531646e-8,
3.6598742141489147e-9,
-2.1613596738593843e-10,
1.1614727804427403e-11,
-5.732093974347976e-13,
// [14.,14. ]: m=5 maxabs=6.2002811739014785e-19 maxrel=3.9212147100253703e-14
0.00001430482665561378,
-2.841552530940336e-6,
3.309666445984475e-7,
-2.927901010540059e-8,
2.161359061391117e-9,
-1.3921945543536117e-10,
8.02687831350642e-12,
-4.192161895518782e-13,
// [14.,14. ]: m=6 maxabs=4.895850435129856e-19 maxrel=7.660289220974093e-14
5.683105061880367e-6,
-1.3238665780802115e-6,
1.756740606639177e-7,
-1.7290885028894493e-8,
1.392194128437296e-9,
-9.620219528398019e-11,
5.870395537605172e-12,
-3.2089254087058884e-13,
// [14.,14. ]: m=7 maxabs=4.019171334721655e-19 maxrel=1.3280053715249756e-13
2.647733156160196e-6,
-7.026962424067245e-7,
1.0374531019541574e-7,
-1.1137562982997582e-8,
9.620216597871446e-10,
-7.034918267283039e-11,
4.493429240268674e-12,
-2.548207098876569e-13,
// [14.,14. ]: m=8 maxabs=3.366955965335844e-19 maxrel=2.0648606569942958e-13
1.4053924848132719e-6,
-4.1498124057805215e-7,
6.682537791507683e-8,
-7.696181422228045e-9,
7.034915974852377e-10,
-5.384297220687597e-11,
3.568226068190045e-12,
-2.0846983807230685e-13,
// [14.,14. ]: m=9 maxabs=2.882029603032757e-19 maxrel=2.9532137601615673e-13
8.299624811559514e-7,
-2.6730151148964465e-7,
4.617708854798353e-8,
-5.627939606293685e-9,
5.384295276744244e-10,
-4.2753181427826106e-11,
2.919198722201156e-12,
-1.7474480927326112e-13,
// [14.,14. ]: m=10 maxabs=4.419394402299312e-19 maxrel=6.949111465311745e-13
5.3460302297966e-7,
-1.8470835402891498e-7,
3.3767637632185973e-8,
-4.307442610866988e-9,
4.275314425733349e-10,
-3.497087109567998e-11,
2.448117608157959e-12,
-1.555234269762885e-13
},
{
// [14.,14. ]: m=0 maxabs=1.6653345369377348e-16 maxrel=7.031056999683863e-16
0.23476722569555653,
-0.004118711896496724,
0.00010838431484172467,
-3.168658628793588e-6,
9.72241906036157e-8,
-3.0642979133151995e-9,
9.813576971494058e-11,
-3.1974912836063828e-12,
// [14.,14. ]: m=1 maxabs=0. maxrel=0.
0.008237423792994253,
-0.0004335372593643056,
0.000019011951747785276,
-7.77793642079574e-7,
3.064320176432909e-8,
-1.1768054148556185e-9,
4.427023060436408e-11,
-1.6214228849493359e-12,
// [14.,14. ]: m=2 maxabs=9.75781955236954e-19 maxrel=1.0766696619127351e-15
0.0008670745187286016,
-0.00007604780698991983,
4.666761853837676e-6,
-2.451456566157782e-7,
1.1768026280903993e-8,
-5.308698716572464e-10,
2.2809143204912564e-11,
-9.36410692569899e-13,
// [14.,14. ]: m=3 maxabs=7.589415207398531e-19 maxrel=4.690355209354392e-15
0.00015209561397983875,
-0.000018667047414759604,
1.4708739397823654e-6,
-9.414423353529973e-8,
5.308697477794838e-9,
-2.7348782778021006e-10,
1.3113769148743259e-11,
-5.890768239135208e-13,
// [14.,14. ]: m=4 maxabs=5.827586677109586e-19 maxrel=1.441667480288327e-14
0.00003733409482951852,
-5.8834957587383516e-6,
5.648654012746185e-7,
-4.246959540333948e-8,
2.7348773898961265e-9,
-1.5721570897949688e-10,
8.25005136930859e-12,
-3.9888916362144123e-13,
// [14.,14. ]: m=5 maxabs=4.2182240773264157e-19 maxrel=3.2539832502615195e-14
0.000011766991517476334,
-2.2594616048185517e-6,
2.5481757245501e-7,
-2.1879030318130735e-8,
1.5721566121475764e-9,
-9.889310273127302e-11,
5.586028943268103e-12,
-2.8670435457106834e-13,
// [14.,14. ]: m=6 maxabs=3.2864878353466853e-19 maxrel=6.49117002227657e-14
4.518923209636867e-6,
-1.0192702896087052e-6,
1.3127418193037735e-7,
-1.2577261347672061e-8,
9.88930744240797e-10,
-6.695124068987326e-11,
4.0147571746234435e-12,
-2.1625873889930483e-13,
// [14.,14. ]: m=7 maxabs=2.659683454378503e-19 maxrel=1.145927688201336e-13
2.038540579217256e-6,
-5.250967275557146e-7,
7.546356810069391e-8,
-7.911452582093595e-9,
6.69512211679879e-10,
-4.811347027955181e-11,
3.0282461452506944e-12,
-1.6962464376371673e-13,
// [14.,14. ]: m=8 maxabs=2.4796889530869642e-19 maxrel=2.043101586443305e-13
1.0501934551126816e-6,
-3.018542722971347e-7,
4.7468715138823365e-8,
-5.35610366099221e-9,
4.81137120252861e-10,
-3.628196689043106e-11,
2.3697448753916623e-12,
-1.4973655342487653e-13,
// [14.,14. ]: m=9 maxabs=1.8687664398798001e-19 maxrel=2.64254303501569e-13
6.037085445370701e-7,
-1.8987486190564034e-7,
3.213661836774696e-8,
-3.849080819090105e-9,
3.628743227207371e-10,
-2.8460228356687014e-11,
1.9232093138571665e-12,
-1.1412654107421608e-13,
// [14.,14. ]: m=10 maxabs=1.615715346887578e-19 maxrel=3.589058956524778e-13
3.7974972381119535e-7,
-1.2854647337635618e-7,
2.30944849227554e-8,
-2.9029983665053914e-9,
2.8460217396813913e-10,
-2.3042180519565113e-11,
1.5981221655433303e-12,
-9.687950387125461e-14
},
{
// [14.,15. ]: m=0 maxabs=0. maxrel=0.
0.23075382371016606,
-0.003911075100403791,
0.00009943244837427111,
-2.808548825661151e-6,
8.326972989971175e-8,
-2.5370350022349785e-9,
7.858798612296398e-11,
-2.2904015577606005e-12,
// [14.,15. ]: m=1 maxabs=3.469446951953614e-18 maxrel=4.3231298713937344e-16
0.007822150200807076,
-0.00039772979349265563,
0.000016851293002690312,
-6.661579248906553e-7,
2.536964948598998e-8,
-9.425208808530693e-10,
3.4346810736380884e-11,
-1.2231538021951722e-12,
// [14.,15. ]: m=2 maxabs=4.336808689942018e-19 maxrel=5.223891359074458e-16
0.0007954595869853107,
-0.00006740517200969687,
3.996947550026038e-6,
-2.0295722965568304e-7,
9.425194853942962e-9,
-4.118804225074067e-10,
1.7176837958705728e-11,
-6.858980221898333e-13,
// [14.,15. ]: m=3 maxabs=4.607859233063394e-19 maxrel=3.2196142400072286e-15
0.00013481034401938952,
-0.000015987790199681274,
1.217743378202507e-6,
-7.54015755063383e-8,
4.118801314292674e-9,
-2.059632400605555e-10,
9.610677653422792e-12,
-4.213449493149867e-13,
// [14.,15. ]: m=4 maxabs=3.6591823321385775e-19 maxrel=1.059759541075555e-14
0.00003197558039936176,
-4.870973512537487e-6,
4.5240945310455355e-7,
-3.2950421445018444e-8,
2.0596315476483354e-9,
-1.152232516676862e-10,
5.90151169380442e-12,
-2.7938518576266917e-13,
// [14.,15. ]: m=5 maxabs=2.829090043829363e-19 maxrel=2.644423230635612e-14
9.741947025074673e-6,
-1.8096378122250081e-6,
1.9770252869384597e-7,
-1.6477060089652388e-8,
1.1522322190717834e-9,
-7.074418625298711e-11,
3.912315801432891e-12,
-1.9718433168513136e-13,
// [14.,15. ]: m=6 maxabs=2.210755992333724e-19 maxrel=5.4713635339086594e-14
3.6192756244498278e-6,
-7.908101146322139e-7,
9.886236055488588e-8,
-9.217863474505527e-9,
7.074416368552112e-10,
-4.689286747689558e-11,
2.7613057437354664e-12,
-1.4646642271270857e-13,
// [14.,15. ]: m=7 maxabs=1.7533582008164017e-19 maxrel=9.773949797281487e-14
1.5816202292643173e-6,
-3.9544944210877036e-7,
5.530718085754916e-8,
-5.659537524659818e-9,
4.689285352875261e-10,
-3.309314456313201e-11,
2.0509749955535538e-12,
-1.1340161394422382e-13,
// [14.,15. ]: m=8 maxabs=3.171079596283287e-18 maxrel=3.482816169786235e-12
7.908988842168458e-7,
-2.2122872335362562e-7,
3.395722527519658e-8,
-3.751431686684095e-9,
3.309290512631875e-10,
-2.457523884237546e-11,
1.5944512703727527e-12,
-1.0035699142478193e-13,
// [14.,15. ]: m=9 maxabs=1.2165510704939889e-19 maxrel=2.3560774798645807e-13
4.4245744668296924e-7,
-1.3582890054964646e-7,
2.2508590983759995e-8,
-2.6474536620869905e-9,
2.4577635554572527e-10,
-1.9027400155707925e-11,
1.271760879942397e-12,
-7.47767524996063e-14,
// [14.,15. ]: m=10 maxabs=1.0444975030829591e-19 maxrel=3.2548564185842855e-13
2.7165780109923896e-7,
-9.003436387350548e-8,
1.5884721977747704e-8,
-1.966213305090915e-9,
1.902739317035e-10,
-1.5237510270202513e-11,
1.0470984254513273e-12,
-6.298371061461882e-14
},
{
// [15.,16. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.2129724755674178e-16
0.22693945331824295,
-0.0037203150013328736,
0.00009148217939220393,
-2.499350363158777e-6,
7.168230353613385e-8,
-2.11321717042129e-9,
6.343391839055287e-11,
-1.8368566948377092e-12,
// [15.,16. ]: m=1 maxabs=1.3608905669038052e-15 maxrel=1.784209086004273e-13
0.007440630002749485,
-0.0003659287173556356,
0.000014996100673065516,
-5.734617078746321e-7,
2.1140488826739946e-8,
-7.456489259777015e-10,
1.1267755188240578e-11,
-2.287141704058342e-11,
// [15.,16. ]: m=2 maxabs=5.421010862427522e-19 maxrel=7.107365115511729e-16
0.0007318574351156512,
-0.00005998440882969639,
3.4407519945452206e-6,
-1.6905458104173084e-7,
7.600970243069392e-9,
-3.219416346514775e-10,
1.3034520599330683e-11,
-5.068718175087467e-13,
// [15.,16. ]: m=3 maxabs=3.2526065174565133e-19 maxrel=2.558856693434221e-15
0.00011996881765939324,
-0.00001376300797785281,
1.014327486257565e-6,
-6.08077744617456e-8,
3.2194162247131756e-9,
-1.5629788652582724e-10,
7.0964213661387386e-12,
-3.0348529304176276e-13,
// [15.,16. ]: m=4 maxabs=2.608861477543245e-19 maxrel=8.799094965828596e-15
0.000027526015955704867,
-4.057309944829444e-6,
3.6484664683470486e-7,
-2.575533763788315e-8,
1.5629779978544142e-9,
-8.508269426834116e-11,
4.2516176851053165e-12,
-1.9693934437819366e-13,
// [15.,16. ]: m=5 maxabs=1.9481757786848908e-19 maxrel=2.1927646451058336e-14
8.114619889658692e-6,
-1.4593865872048504e-6,
1.54532025846448e-7,
-1.2503829326491185e-8,
8.50826677994177e-10,
-5.0968197417132105e-11,
2.7580120831689597e-12,
-1.3642055901918335e-13,
// [15.,16. ]: m=6 maxabs=1.486542822431297e-19 maxrel=4.577531888339913e-14
2.9187731744096063e-6,
-6.181281032881265e-7,
7.502297596896433e-8,
-6.8066173252716595e-9,
5.096818374472961e-10,
-3.3058727079699565e-11,
1.910329876105591e-12,
-9.97101799509213e-14,
// [15.,16. ]: m=7 maxabs=1.1625527201065272e-19 maxrel=8.32152325838896e-14
1.236256206576167e-6,
-3.00091903801522e-7,
4.083970395940121e-8,
-4.077457673838194e-9,
3.305871687351711e-10,
-2.2895402234368923e-11,
1.3962672226520897e-12,
-7.615541164885293e-14,
// [15.,16. ]: m=8 maxabs=9.5185327447702e-20 maxrel=1.3828547516871614e-13
6.001838076029901e-7,
-1.6335881577870883e-7,
2.4464746048233004e-8,
-2.644699705417064e-9,
2.2895395295711164e-10,
-1.6732595692901077e-11,
1.0663974368035835e-12,
-6.029153194964398e-14,
// [15.,16. ]: m=9 maxabs=7.919758056827708e-20 maxrel=2.0849479261532256e-13
3.267176315573725e-7,
-9.785898414492571e-8,
1.586819823681518e-8,
-1.8316335438649394e-9,
1.6732589971015771e-10,
-1.277833484430417e-11,
8.442638577329013e-13,
-4.9159748177026544e-14,
// [15.,16. ]: m=10 maxabs=6.760381710273385e-20 maxrel=2.934480596554654e-13
1.957179682898146e-7,
-6.347279290715597e-8,
1.098980126665426e-8,
-1.3386088018768627e-9,
1.2778330250589415e-10,
-1.0115766095043661e-11,
6.883831792273663e-13,
-4.106677588679193e-14
},
{
// [16.,16. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.2330229442796923e-16
0.2233081907765642,
-0.0035445721631520133,
0.00008439400190882574,
-2.232549989129927e-6,
6.20033195460314e-8,
-1.7703074901699549e-9,
5.146600332017508e-11,
-1.54205253393783e-12,
// [16.,16. ]: m=1 maxabs=0. maxrel=0.
0.007089144326302775,
-0.00033757600763307995,
0.000013395299914067752,
-4.960266514565448e-7,
1.7703289117493448e-8,
-6.170161175908718e-10,
2.1134127616434254e-11,
-7.107898398619685e-13,
// [16.,16. ]: m=2 maxabs=4.336808689942018e-19 maxrel=6.171594367516138e-16
0.0006751520152661497,
-0.000053581199655653414,
2.9761599094037286e-6,
-1.416263329458602e-7,
6.170154761947247e-9,
-2.5344695948125807e-10,
9.964898848855e-12,
-3.763890864373759e-13,
// [16.,16. ]: m=3 maxabs=2.846030702774449e-19 maxrel=2.5112000675732046e-15
0.00010716239931130562,
-0.000011904639637373703,
8.497579978442821e-7,
-4.936124720561092e-8,
2.5344669269423314e-9,
-1.1949437144971102e-10,
5.278908979785558e-12,
-2.2016192650136343e-13,
// [16.,16. ]: m=4 maxabs=1.8295911660692887e-19 maxrel=7.150905245778652e-15
0.00002380927927474685,
-3.399031991239892e-6,
2.961674832879188e-7,
-2.0275740896232137e-8,
1.1949429390499989e-9,
-6.32944043477427e-11,
3.0848863974506113e-12,
-1.3974795724448435e-13,
// [16.,16. ]: m=5 maxabs=1.3213713977167085e-19 maxrel=1.7803325352321832e-14
6.798063982479627e-6,
-1.1846699330581907e-6,
1.216544453932506e-7,
-9.559547236491447e-9,
6.329438235987237e-10,
-3.698297718865029e-11,
1.957192868280076e-12,
-9.494157814737793e-14,
// [16.,16. ]: m=6 maxabs=9.994988777600744e-20 maxrel=3.8037821674485315e-14
2.3693398661162937e-6,
-4.866177815063715e-7,
5.7357283427555097e-8,
-5.063553254613612e-9,
3.6982965508067267e-10,
-2.3460721096279605e-11,
1.32956056138951e-12,
-6.824349812748153e-14,
// [16.,16. ]: m=7 maxabs=7.771527291058206e-20 maxrel=7.091259466643739e-14
9.732355630126902e-7,
-2.2942913365999853e-7,
3.03813195329422e-8,
-2.9586392486382483e-9,
2.3460713992718226e-10,
-1.5935455191236395e-11,
9.55638606131587e-13,
-5.1381935302950314e-14,
// [16.,16. ]: m=8 maxabs=6.268043809681823e-20 maxrel=1.1954984475732824e-13
4.588582673199568e-7,
-1.2152527809252014e-7,
1.7751835495636296e-8,
-1.8768586893073618e-9,
1.5935450171678315e-10,
-1.1452592585702124e-11,
7.195064397989948e-13,
-4.018821264905907e-14,
// [16.,16. ]: m=9 maxabs=5.1986647137732683e-20 maxrel=1.8465343897765026e-13
2.43050556185009e-7,
-7.100734195086684e-8,
1.1261152138800016e-8,
-1.2748372807805274e-9,
1.1452588675188476e-10,
-8.621914346068346e-12,
5.627595144638574e-13,
-3.2433049480855454e-14,
// [16.,16. ]: m=10 maxabs=4.3886894579613436e-20 maxrel=2.634751682195454e-13
1.4201468390170962e-7,
-4.504460852897348e-8,
7.649023686983473e-9,
-9.162081431232117e-10,
8.621911266493231e-11,
-6.743042333497495e-12,
4.541615429909087e-13,
-2.6858939446891688e-14
},
{
// [16.,16. ]: m=0 maxabs=0. maxrel=0.
0.21984584034828938,
-0.0033822423493213823,
0.00007805140943674489,
-2.0012620065484537e-6,
5.3873097010518796e-8,
-1.491174721611758e-9,
4.2043608792952014e-11,
-1.2018938867456616e-12,
// [16.,16. ]: m=1 maxabs=1.734723475976807e-18 maxrel=2.505506374881942e-16
0.0067644846986401825,
-0.00031220563774519283,
0.000012007572057661309,
-4.3098486756822404e-7,
1.4911682727707385e-8,
-5.039976983974256e-10,
1.675086454863142e-11,
-5.548837932322246e-13,
// [16.,16. ]: m=2 maxabs=0. maxrel=0.
0.000624411275490411,
-0.00004803028823030342,
2.5859092028996085e-6,
-1.1929347451393934e-7,
5.040008131964963e-9,
-2.008974589649331e-10,
7.673500732557705e-12,
-2.839084542320051e-13,
// [16.,16. ]: m=3 maxabs=1.2197274440461925e-19 maxrel=1.2026912789403547e-15
0.00009606057646061073,
-0.000010343636811416214,
7.157608466537619e-7,
-4.032007182405635e-8,
2.0089804568877158e-9,
-9.201979447171198e-11,
3.955750528432961e-12,
-1.6127638985527124e-13,
// [16.,16. ]: m=4 maxabs=1.1519648082658485e-19 maxrel=5.1933951233351395e-15
0.000020687273622833213,
-2.863043386512276e-6,
2.419204308667929e-7,
-1.60718476492945e-8,
9.20199017617923e-10,
-4.7431198536641466e-11,
2.2543136817505035e-12,
-9.991883439454198e-14,
// [16.,16. ]: m=5 maxabs=8.555032767268433e-20 maxrel=1.3721013337842389e-14
5.726086773024701e-6,
-9.676817234011482e-7,
9.643108588162314e-8,
-7.361594759937281e-9,
4.743121776710699e-10,
-2.7026747014955463e-11,
1.39823287381095e-12,
-6.65161299972088e-14,
// [16.,16. ]: m=6 maxabs=6.522153693858113e-20 maxrel=3.0480775625198697e-14
1.9353634468023387e-6,
-3.857243434805376e-7,
4.416956855552745e-8,
-3.794499257766368e-9,
2.7026752529224407e-10,
-1.676117345793002e-11,
9.310468373556781e-13,
-4.697873829619541e-14,
// [16.,16. ]: m=7 maxabs=5.092785595366481e-20 maxrel=5.882440423297781e-14
7.714486869610815e-7,
-1.76678274188023e-7,
2.276699554580714e-8,
-2.162141564714897e-9,
1.6761174469519118e-10,
-1.1159490468061718e-11,
6.576711504390552e-13,
-3.4842523866496796e-14,
// [16.,16. ]: m=8 maxabs=4.097521882342678e-20 maxrel=1.018502204204248e-13
3.533565483760379e-7,
-9.106798215689425e-8,
1.2972849388969356e-8,
-1.3408950097189438e-9,
1.1159489576230497e-10,
-7.881959908664764e-12,
4.878235569801389e-13,
-2.6905782888525435e-14,
// [16.,16. ]: m=9 maxabs=3.380190855136692e-20 maxrel=1.6080088620923606e-13
1.82135964313779e-7,
-5.1891397534883395e-8,
8.045370059192036e-9,
-8.927600055109221e-10,
7.88195873555122e-11,
-5.845826505253886e-12,
3.7671854765152575e-13,
-2.1479015591334856e-14,
// [16.,16. ]: m=10 maxabs=2.8428543292222455e-20 maxrel=2.343746592344893e-13
1.0378279506975652e-7,
-3.218148021954712e-8,
5.3565600340157355e-9,
-6.305573874726629e-10,
5.845825242727436e-11,
-4.514012815682865e-12,
3.007465845223673e-13,
-1.762422855362362e-14
},
{
// [16.,17. ]: m=0 maxabs=1.6653345369377348e-16 maxrel=7.633057330333799e-16
0.21653970056917216,
-0.003231935035991256,
0.00007235655618996508,
-1.7998812741392865e-6,
4.700766156962615e-8,
-1.2624888977598565e-9,
3.459413441944352e-11,
-9.29766968991927e-13,
// [16.,17. ]: m=1 maxabs=5.0306980803327406e-17 maxrel=7.6092064067273e-15
0.006463870071982394,
-0.0002894262247447107,
0.000010799287661913547,
-3.760616286214617e-7,
1.2624634301528075e-8,
-4.1325816468438864e-10,
1.372168092900033e-11,
-2.429299672030736e-12,
// [16.,17. ]: m=2 maxabs=1.0842021724855044e-19 maxrel=1.8039128991751152e-16
0.0005788524494951207,
-0.000043197150591387694,
2.256369218042491e-6,
-1.0099839920911509e-7,
4.1413237739046515e-9,
-1.6029443643757435e-10,
5.950517459846437e-12,
-2.1419364815381853e-13,
// [16.,17. ]: m=3 maxabs=2.0938654456126304e-17 maxrel=2.2993647048022017e-13
0.000086394301182688,
-9.025476871049334e-6,
6.059903968681293e-7,
-3.3130617685525987e-8,
1.6029363588618458e-9,
-7.121036085173308e-11,
3.0092552171153327e-12,
-4.23891710019876e-13,
// [16.,17. ]: m=4 maxabs=8.809142651444724e-20 maxrel=4.560948196026262e-15
0.000018050953744086506,
-2.423961579764654e-6,
1.987835705423398e-7,
-1.2823590476888069e-8,
7.136057486223536e-10,
-3.579958321734431e-11,
1.6590478140913782e-12,
-7.186294336839755e-14,
// [16.,17. ]: m=5 maxabs=5.844527336054672e-20 maxrel=1.1099742050825966e-14
4.847923159529347e-6,
-7.951342821235304e-7,
7.694154285375027e-8,
-5.708847817997877e-9,
3.579959515095977e-10,
-1.9891012020091798e-11,
1.0056638982703244e-12,
-4.687008573351399e-14,
// [16.,17. ]: m=6 maxabs=4.383395502041004e-20 maxrel=2.5003885490347414e-14
1.590268564247095e-6,
-3.0776617138309155e-7,
3.4253086904871325e-8,
-2.8639688850273035e-9,
1.9891015839908455e-10,
-1.205576295973638e-11,
6.560640700384072e-13,
-3.251445239604909e-14,
// [16.,17. ]: m=7 maxabs=3.4304834363799164e-20 maxrel=4.982248840742869e-14
6.15532342766191e-7,
-1.3701234759624433e-7,
1.7183813309376217e-8,
-1.5912821956771061e-9,
1.2055763866706294e-10,
-7.863861611938319e-12,
4.551757975784433e-13,
-2.3742661109507887e-14,
// [16.,17. ]: m=8 maxabs=2.736975210815458e-20 maxrel=8.803255489355729e-14
2.740246951924846e-7,
-6.873525321981969e-8,
9.547693174416479e-9,
-9.644618164069028e-10,
7.863861128986977e-11,
-5.455323797762466e-12,
3.324128267602463e-13,
-1.809117072736058e-14,
// [16.,17. ]: m=9 maxabs=2.2234614865425384e-20 maxrel=1.4064105944430248e-13
1.3747050643963348e-7,
-3.819077268371354e-8,
5.786770898995898e-9,
-6.291094482724709e-10,
5.455323045355904e-11,
-3.9835986057536164e-12,
2.5330084998567406e-13,
-1.4278750403481528e-14,
// [16.,17. ]: m=10 maxabs=1.8568550390590365e-20 maxrel=2.087388466624256e-13
7.638154536742074e-8,
-2.3147083584651553e-8,
3.774656690230626e-9,
-4.364262968984294e-10,
3.9835978034366776e-11,
-3.0352589298901596e-12,
1.9992836037379822e-13,
-1.1603040473873306e-14
},
{
// [17.,18. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.2913077599768165e-16
0.21337836798688778,
-0.0030924396484803907,
0.00006722683206278592,
-1.6238170522567546e-6,
4.1181318669605285e-8,
-1.074065101786238e-9,
2.8556318431782535e-11,
-7.256717806766259e-13,
// [17.,18. ]: m=1 maxabs=8.673617379884035e-19 maxrel=1.3720147592350878e-16
0.006184879296960641,
-0.00026890732824585425,
9.742902321002258e-6,
-3.294506573893241e-7,
1.0740521387742502e-8,
-3.4220526838610794e-10,
1.0731296655064596e-11,
-3.3874131949553437e-13,
// [17.,18. ]: m=2 maxabs=2.168404344971009e-19 maxrel=3.887383636883753e-16
0.0005378146564928729,
-0.00003897160928401193,
1.9767039424489717e-6,
-8.592418002321508e-8,
3.4220802317840733e-9,
-1.287039682027862e-10,
4.645778732113768e-12,
-1.6343560001811216e-13,
// [17.,18. ]: m=3 maxabs=2.710505431213761e-20 maxrel=3.304325139623169e-16
0.00007794321856802853,
-7.906815769692664e-6,
5.155450796765439e-7,
-2.737664563457726e-8,
1.2870457099959135e-9,
-5.5715009191448804e-11,
2.269177629147137e-12,
-8.810684751653919e-14,
// [17.,18. ]: m=4 maxabs=6.098637220230962e-20 maxrel=3.611415710032816e-15
0.000015813631539386277,
-2.062180318653589e-6,
1.6425987371473903e-7,
-1.0296367755806526e-8,
5.571513251556771e-10,
-2.721044034894326e-11,
1.2295483861389703e-12,
-5.2056342451568415e-14,
// [17.,18. ]: m=5 maxabs=3.9810548520952116e-20 maxrel=8.908356056503197e-15
4.1243606373073375e-6,
-6.570394948261857e-7,
6.177820652043711e-8,
-4.457211905868247e-9,
2.721045879327807e-10,
-1.4742093763853528e-11,
7.282142160406441e-13,
-3.323730336242324e-14,
// [17.,18. ]: m=6 maxabs=4.676108912788409e-17 maxrel=3.236951257661514e-11
1.3140789899795076e-6,
-2.471128260595336e-7,
2.6743260965291062e-8,
-2.1768375893927555e-9,
1.4750470802364802e-10,
-8.730076282631421e-12,
2.738220188411092e-13,
-2.2635200832877704e-14,
// [17.,18. ]: m=7 maxabs=2.3187526931086472e-20 maxrel=4.207266081666329e-14
4.942256521190752e-7,
-1.0697308571613445e-7,
1.3061025535508528e-8,
-1.1793683660811638e-9,
8.73007740573321e-11,
-5.576679264814482e-12,
3.168570194645797e-13,
-1.6263973729783427e-14,
// [17.,18. ]: m=8 maxabs=1.8211208365967457e-20 maxrel=7.527526595809829e-14
2.139461714322691e-7,
-5.2244102130085514e-8,
7.076210196425185e-9,
-6.984066701035149e-10,
5.576679345576706e-11,
-3.797700337343299e-12,
2.2769302619909315e-13,
-1.222090460395427e-14,
// [17.,18. ]: m=9 maxabs=1.4664257899340075e-20 maxrel=1.2246088546166064e-13
1.044882042601686e-7,
-2.8304840776385985e-8,
4.1904400208421715e-9,
-4.461347200745434e-10,
3.797700035448022e-11,
-2.728741817549866e-12,
1.7110238565896751e-13,
-9.530715595780123e-15,
// [17.,18. ]: m=10 maxabs=1.2096689277975477e-20 maxrel=1.841214468390883e-13
5.660968155276808e-8,
-1.676176007587808e-8,
2.6768083208128236e-9,
-3.0381630238449375e-10,
2.728741328127409e-11,
-2.0503534481253874e-12,
1.3344566255818479e-13,
-7.666147653076876e-15
},
{
// [18.,18. ]: m=0 maxabs=5.551115123125783e-17 maxrel=2.6203199249155374e-16
0.21035157148846673,
-0.002962697914548158,
0.00006259214060470239,
-1.4692876053492862e-6,
3.6213394462327796e-8,
-9.17892597549527e-10,
2.3709057709294137e-11,
-7.256717806766259e-13,
// [18.,18. ]: m=1 maxabs=8.673617379884035e-19 maxrel=1.4329876287863182e-16
0.0059253958290966325,
-0.000250368562416441,
8.815725593220246e-6,
-2.897072052967871e-7,
9.179426757232831e-9,
-2.8428803230575993e-10,
8.6680218606896e-12,
-2.643316154222475e-13,
// [18.,18. ]: m=2 maxabs=0. maxrel=0.
0.0005007371248337151,
-0.000035262902373061265,
1.7382432308009466e-6,
-7.343542078947716e-8,
2.842894766235836e-9,
-1.0396216027260523e-10,
3.650881126312455e-12,
-1.2490200326587432e-13,
// [18.,18. ]: m=3 maxabs=1.3552527156068805e-20 maxrel=1.828572150925214e-16
0.00007052580474612615,
-6.952972923123589e-6,
4.406125244292447e-7,
-2.2743161083488953e-8,
1.0396254576428503e-9,
-4.378429482078042e-11,
1.7365087866287566e-12,
-6.573964480403332e-14,
// [18.,18. ]: m=4 maxabs=1.3944195190879194e-16 maxrel=9.407544750337657e-12
0.000013905945846102861,
-1.7624500965258945e-6,
1.3645898106779782e-7,
-8.317076040629191e-9,
4.377139614823799e-10,
-2.0213233565198434e-11,
1.2142823550549614e-12,
-1.4332961630755064e-12,
// [18.,18. ]: m=5 maxabs=2.795208725939191e-20 maxrel=7.33507185121266e-15
3.5249001953560942e-6,
-5.458358657440586e-7,
4.9902031089310246e-8,
-3.502751203360862e-9,
2.0823710701882134e-10,
-1.100162615579265e-11,
5.308750371523282e-13,
-2.3722591527866097e-14,
// [18.,18. ]: m=6 maxabs=5.4193167965330136e-18 maxrel=4.527623006526321e-12
1.0916717314992233e-6,
-1.9960812425346714e-7,
2.1016506098594146e-8,
-1.6659029007259036e-9,
1.1002622738659388e-10,
-6.317823298014498e-12,
3.093086724701266e-13,
-1.226542101219938e-13,
// [18.,18. ]: m=7 maxabs=1.5617169965001163e-20 maxrel=3.518472367873875e-14
3.9921624868331185e-7,
-8.406602886143172e-8,
9.99538486189222e-9,
-8.801307617683481e-10,
6.364550865388312e-11,
-3.9800570869351696e-12,
2.2187625372890985e-13,
-1.1199994398154308e-14,
// [18.,18. ]: m=8 maxabs=1.214962883717887e-20 maxrel=6.41110095227186e-14
1.6813205772286293e-7,
-3.9981539439447505e-8,
5.280784570614756e-9,
-5.091643936682099e-10,
3.9800571016345704e-11,
-2.6594028457466435e-12,
1.5679885645897081e-13,
-8.294468294713665e-15,
// [18.,18. ]: m=9 maxabs=9.714409113822757e-21 maxrel=1.0636612114052203e-13
7.996307887889257e-8,
-2.112313827621274e-8,
3.0549863622038043e-9,
-3.1840481781161653e-10,
2.6594025951641024e-11,
-1.8791901663977965e-12,
1.1613046338977126e-13,
-6.38830138618285e-15,
// [18.,18. ]: m=10 maxabs=7.960786215210338e-21 maxrel=1.6292497206368792e-13
4.224627655242286e-8,
-1.2219945443845758e-8,
1.910428907103881e-9,
-2.127524062834897e-10,
1.8791898521685407e-11,
-1.3916588642523849e-12,
8.944636638590964e-14,
-5.083648819240333e-15
},
{
// [18.,18. ]: m=0 maxabs=8.326672684688674e-17 maxrel=3.9862341546488444e-16
0.20745003174546942,
-0.0028417810943084246,
0.00005839272159290845,
-1.3331603909092241e-6,
3.195846545680824e-8,
-7.879165611297029e-10,
1.981424119894381e-11,
-5.442538355074695e-13,
// [18.,18. ]: m=1 maxabs=3.365363543395006e-16 maxrel=5.799971117889122e-14
0.005683562188612238,
-0.00023357088637091268,
7.998962398100625e-6,
-2.55667918661594e-7,
7.878887294643474e-9,
-2.3648409371325354e-10,
7.984692744949914e-12,
-2.2450470714683115e-12,
// [18.,18. ]: m=2 maxabs=0. maxrel=0.
0.00046714177273197933,
-0.00003199584934985854,
1.5340069513105758e-6,
-6.303461154433473e-8,
2.373745006339623e-9,
-8.445946264975965e-11,
2.8869857893172298e-12,
-9.615682591851531e-14,
// [18.,18. ]: m=3 maxabs=8.131516293641283e-20 maxrel=1.2108273997198105e-15
0.00006399169869971896,
-6.136027805176185e-6,
3.782076690940977e-7,
-1.8989962202011777e-8,
8.445971140876381e-10,
-3.4624755064592586e-11,
1.337741424606245e-12,
-4.9440376292741925e-14,
// [18.,18. ]: m=4 maxabs=2.879912020664621e-20 maxrel=2.2055070739143727e-15
0.000012272055610352891,
-1.5128306763427833e-6,
1.1393977315278239e-7,
-6.756778133533973e-9,
3.462484279548147e-10,
-1.6042002167168422e-11,
6.893669455684359e-13,
-2.7853811100647773e-14,
// [18.,18. ]: m=5 maxabs=1.8634724839594607e-20 maxrel=5.709111118646926e-15
3.0256613526855983e-6,
-4.5575909259436804e-7,
4.0540668794888844e-8,
-2.769988091592798e-9,
1.6042011939194782e-10,
-8.266005086337692e-12,
3.896132106029674e-13,
-1.7045303304734513e-14,
// [18.,18. ]: m=6 maxabs=1.4399560103323106e-20 maxrel=1.4444044276843963e-14
9.115181851887642e-7,
-1.6216267516852118e-7,
1.66199285460928e-8,
-1.283361394134703e-9,
8.26600984286098e-11,
-4.671159161917404e-12,
2.384796153301422e-13,
-1.1166992047308003e-14,
// [18.,18. ]: m=7 maxabs=1.0482032722271967e-20 maxrel=2.9151097476172805e-14
3.2432535033705136e-7,
-6.64797141767705e-8,
7.70016836391451e-9,
-6.612810909285856e-10,
4.671160330435273e-11,
-2.858844743142686e-12,
1.563008204910469e-13,
-7.755595702290719e-15,
// [18.,18. ]: m=8 maxabs=8.232101456127731e-21 maxrel=5.5100990185619746e-14
1.3295942835354203e-7,
-3.080067345012066e-8,
3.967686545412018e-9,
-3.7369304767482473e-10,
2.858844962282026e-11,
-1.873487276773576e-12,
1.0857125708639368e-13,
-5.65761073947988e-15,
// [18.,18. ]: m=9 maxabs=6.432156443212343e-21 maxrel=9.172146046132989e-14
6.160134690024055e-8,
-1.5870746177441166e-8,
2.2421582861053066e-9,
-2.2870776512626018e-10,
1.8734872020938627e-11,
-1.3012417139684467e-12,
7.920892929019742e-14,
-4.300859441745259e-15,
// [18.,18. ]: m=10 maxabs=5.260868695837256e-21 maxrel=1.437849590952529e-13
3.174149235488104e-8,
-8.96863314111181e-9,
1.3722465908744013e-9,
-1.4987910845465923e-10,
1.3012415580703208e-11,
-9.492377183413865e-13,
6.021702254646363e-14,
-3.3841737309099515e-15
},
{
// [18.,19. ]: m=0 maxabs=5.415112802609201e-14 maxrel=2.6281396109129726e-13
0.20466534140145703,
-0.0027288711237203065,
0.00005457740812082105,
-1.2128415762985504e-6,
2.822827722773274e-8,
-5.386341311903154e-10,
1.685882948592252e-10,
-3.2351355072289826e-10,
// [18.,19. ]: m=1 maxabs=1.734723475976807e-18 maxrel=3.115106674889228e-16
0.005457742245548643,
-0.00021830959390016302,
7.276962482930475e-6,
-2.2639039188810514e-7,
6.791211628205078e-9,
-1.9915686428830391e-10,
5.7520472908271514e-12,
-1.6866199589945015e-13,
// [18.,19. ]: m=2 maxabs=5.421010862427522e-20 maxrel=1.2006146948078825e-16
0.0004366191878003447,
-0.000029107849931581055,
1.3583423497072337e-6,
-5.432969728904261e-8,
1.9915891138563136e-9,
-6.899147344185304e-11,
2.2967573866501936e-12,
-7.480832748796516e-14,
// [18.,19. ]: m=3 maxabs=1.3552527156068805e-20 maxrel=2.2211462736938103e-16
0.00005821569986316509,
-5.433369398788129e-6,
3.2597818348945215e-7,
-1.5932714459884835e-8,
6.89917927558175e-10,
-2.7546693559356114e-11,
1.0371489195390575e-12,
-3.7387554435037646e-14,
// [18.,19. ]: m=4 maxabs=1.3552527156068805e-20 maxrel=1.1740598512007023e-15
0.000010866738797576648,
-1.3039127339354247e-6,
9.559628671493777e-8,
-5.519344270940956e-9,
2.7546755965374206e-10,
-1.243789250881762e-11,
5.213807409266826e-13,
-2.0583086110004623e-14,
// [18.,19. ]: m=5 maxabs=1.2281977735187355e-20 maxrel=4.374577234622858e-15
2.6078254678709057e-6,
-3.823851468473239e-7,
3.311606561877047e-8,
-2.2037409680331234e-9,
1.2437902231102563e-10,
-6.251905416726519e-12,
2.87842697781518e-13,
-1.2325837373486563e-14,
// [18.,19. ]: m=6 maxabs=9.740878893424454e-21 maxrel=1.1673602089382095e-14
7.647702936946531e-7,
-1.3246426246666352e-7,
1.3222445804560469e-8,
-9.950324981829348e-10,
6.251910584427524e-11,
-3.451109137824498e-12,
1.7239578152629306e-13,
-7.915200780433407e-15,
// [18.,19. ]: m=7 maxabs=7.146840492458159e-21 maxrel=2.439771694833735e-14
2.649285249333335e-7,
-5.288978321292672e-8,
5.970194988312669e-9,
-5.001530585169774e-10,
3.451110257074032e-11,
-2.066721125957562e-12,
1.1077581844826782e-13,
-5.4006638650336376e-15,
// [18.,19. ]: m=8 maxabs=5.492479267352104e-21 maxrel=4.634767696638461e-14
1.057795664258553e-7,
-2.3880779949455727e-8,
3.0009183508760305e-9,
-2.760889721885503e-10,
2.066721441132986e-11,
-1.3278549693230196e-12,
7.559895113911296e-14,
-3.878414212219488e-15,
// [18.,19. ]: m=9 maxabs=4.137425075092236e-19 maxrel=7.633758502952386e-12
4.776155989713101e-8,
-1.2003673380913864e-8,
1.6565338711380964e-9,
-1.6533827770195596e-10,
1.3278308464070017e-11,
-9.031139451692997e-13,
5.477123321112347e-14,
-8.971130027260813e-15,
// [18.,19. ]: m=10 maxabs=3.477467295172928e-21 maxrel=1.2607610407060981e-13
2.4007346801304804e-8,
-6.626135330627688e-9,
9.920269743713312e-10,
-1.0622847879948182e-10,
9.060961664683443e-12,
-6.507551806139332e-13,
4.0723203248050224e-14,
-2.261880238430024e-15
},
{
// [19.,20. ]: m=0 maxabs=6.619704784327496e-14 maxrel=3.255895683460584e-13
0.20198986248673384,
-0.0026232449097173685,
0.00005110214758389735,
-1.1060871868313652e-6,
2.5224809956161302e-8,
-7.598846539456749e-10,
-1.72086259614518e-10,
3.956952156570764e-10,
// [19.,20. ]: m=1 maxabs=0. maxrel=0.
0.005246489821382824,
-0.0002044086376712403,
6.6366299132051544e-6,
-2.0110763645450187e-7,
5.8762259808342195e-9,
-1.6786054137849414e-10,
4.723953212881239e-12,
-1.3606345887686736e-13,
// [19.,20. ]: m=2 maxabs=1.0842021724855044e-19 maxrel=2.566777568989548e-16
0.00040881727534250006,
-0.000026546519652600433,
1.2066458171209689e-6,
-4.700981356339028e-8,
1.6786267027666815e-9,
-5.6650958975695486e-11,
1.8375764315586564e-12,
-5.873051642927282e-14,
// [19.,20. ]: m=3 maxabs=0. maxrel=0.
0.00005309303930520122,
-4.826583268495346e-6,
2.8205888107768133e-7,
-1.3429014114400497e-8,
5.665138105975904e-10,
-2.204240352376052e-11,
8.091155647068759e-13,
-2.8457282658980236e-14,
// [19.,20. ]: m=4 maxabs=1.1858461261560205e-20 maxrel=1.1582781313280348e-15
9.653166536991023e-6,
-1.1282355242943344e-6,
8.05740846523193e-8,
-4.532111116826564e-9,
2.2042450531565107e-10,
-9.703505437486475e-12,
3.968839355936106e-13,
-1.5309630519989316e-14,
// [19.,20. ]: m=5 maxabs=8.893845946170154e-21 maxrel=3.668103792138707e-15
2.2564710485887247e-6,
-3.222963386002876e-7,
2.719266669410406e-8,
-1.7633963970909715e-9,
9.703514532596992e-11,
-4.759229179156426e-12,
2.1404572149602775e-13,
-8.965912584835078e-15,
// [19.,20. ]: m=6 maxabs=6.564505341220828e-21 maxrel=9.354835879084943e-15
6.445926772005957e-7,
-1.0877066677083608e-7,
1.0580378380381975e-8,
-7.76281384072984e-10,
4.759232186349666e-11,
-2.5664289381516452e-12,
1.254246774567351e-13,
-5.644050795849059e-15,
// [19.,20. ]: m=7 maxabs=4.923379005915621e-21 maxrel=2.0521282418883926e-14
2.1754133354168016e-7,
-4.2321513517819676e-8,
4.657688303746357e-9,
-3.807387229508746e-10,
2.566429772807266e-11,
-1.5036766796638222e-12,
7.899173229835636e-14,
-3.781861790624904e-15,
// [19.,20. ]: m=8 maxabs=3.7190040340384124e-21 maxrel=3.933117180213407e-14
8.464302703564115e-8,
-1.8630753212375734e-8,
2.284432337552541e-9,
-2.053144861942117e-10,
1.503676865028333e-11,
-9.468986730080646e-13,
5.2940450235630386e-14,
-2.67276869781589e-15,
// [19.,20. ]: m=9 maxabs=2.871971086784112e-21 maxrel=6.813046548843062e-14
3.7261506424750986e-8,
-9.137729348276762e-9,
1.2318869171718386e-9,
-1.2029422646941251e-10,
9.468986734304612e-12,
-6.345440404160141e-13,
3.741857118409033e-14,
-1.9762266172900616e-15,
// [19.,20. ]: m=10 maxabs=2.306179547797841e-21 maxrel=1.1018770669711699e-13
1.8275458696552988e-8,
-4.9275476672035e-9,
7.21765358860415e-10,
-7.575195320159794e-11,
6.3454398099748865e-12,
-4.484534730951607e-13,
2.7669105528762626e-14,
-1.5180540721692067e-15
},
{
// [20.,20. ]: m=0 maxabs=0. maxrel=0.
0.19941663819492128,
-0.0025242612094746697,
0.0000479290019315127,
-1.011158985157039e-6,
2.2398914711054202e-8,
-5.103187584669606e-10,
1.1848859543860532e-11,
-3.1748140404602384e-13,
// [20.,20. ]: m=1 maxabs=1.734723475976807e-18 maxrel=3.3710658447761586e-16
0.00504852241894581,
-0.0001917160077248487,
6.066953894583449e-6,
-1.7919133551299034e-7,
5.1033756684840995e-9,
-1.4209954749639807e-10,
3.898005497667754e-12,
-1.1055156033745473e-13,
// [20.,20. ]: m=2 maxabs=0. maxrel=0.
0.00038343201544971617,
-0.000024267815578162856,
1.0751480111453363e-6,
-4.0827009660410656e-8,
1.421018799278121e-9,
-4.67498730918069e-11,
1.478616046640827e-12,
-4.6240316102685393e-14,
// [20.,20. ]: m=3 maxabs=6.776263578034403e-21 maxrel=1.3352606985113802e-16
0.000048535631156327745,
-4.300592044565032e-6,
2.4496205768857255e-7,
-1.1368151116470387e-8,
4.675025578066581e-10,
-1.7735754353738874e-11,
6.35009867800725e-13,
-2.1846777698898055e-14,
// [20.,20. ]: m=4 maxabs=3.218725199566341e-20 maxrel=3.5337058666627507e-15
8.601184089131896e-6,
-9.798482307618762e-7,
6.820890641998382e-8,
-3.740020633060929e-9,
1.7736283743021436e-10,
-7.612653134785675e-12,
2.8301466579440606e-13,
-3.8951597694018566e-14,
// [20.,20. ]: m=5 maxabs=7.199780051661553e-21 maxrel=3.425356890230301e-15
1.959696461481905e-6,
-2.7283562661596465e-7,
2.244012569207043e-8,
-1.418865247912785e-9,
7.615685426898031e-11,
-3.645789918960042e-12,
1.6019548717158946e-13,
-6.565175387753307e-15,
// [20.,20. ]: m=6 maxabs=4.9763185651190145e-21 maxrel=8.395190028634634e-15
5.456712532319443e-7,
-8.976050276425465e-8,
8.51319148573593e-9,
-6.092549940171169e-10,
3.645792369535979e-11,
-1.9208204443140996e-12,
9.183297729004029e-14,
-4.0482595348744466e-15,
// [20.,20. ]: m=7 maxabs=3.414601568618898e-21 maxrel=1.7289212492383735e-14
1.7952100552851497e-7,
-3.405276594036311e-8,
3.655529963534662e-9,
-2.916634920388205e-10,
1.9208207334361034e-11,
-1.1010038335535833e-12,
5.66737195249068e-14,
-2.663869308973652e-15,
// [20.,20. ]: m=8 maxabs=2.5013941723603557e-21 maxrel=3.296773598825552e-14
6.810553188072796e-8,
-1.46221198523221e-8,
1.7499809520684945e-9,
-1.5366573118965038e-10,
1.1010040451911605e-11,
-6.793895033608149e-13,
3.728754714742229e-14,
-1.851656800203086e-15,
// [20.,20. ]: m=9 maxabs=1.945528800724721e-21 maxrel=5.898017333890701e-14
2.9244239704644042e-8,
-6.999923806953315e-9,
9.219943871269728e-10,
-8.808037637201188e-11,
6.7938951868536254e-12,
-4.4694441269074796e-13,
2.592264912855823e-14,
-1.349241424647217e-15,
// [20.,20. ]: m=10 maxabs=1.5352472168984194e-21 maxrel=9.60547678805706e-14
1.3999847613906387e-8,
-3.6879775475078772e-9,
5.284822582544741e-10,
-5.4351201483893666e-11,
4.469443830511807e-12,
-3.106879902201043e-13,
1.889031056918283e-14,
-1.0232729232507862e-15
},
{
// [20.,20. ]: m=0 maxabs=5.551115123125783e-17 maxrel=2.8012398208389113e-16
0.1969393167285447,
-0.0024313495694251266,
0.000045024987072364235,
-9.264392446040898e-7,
2.0015556298982162e-8,
-4.4472341533904097e-10,
1.007436526767472e-11,
-3.6283589033831295e-13,
// [20.,20. ]: m=1 maxabs=8.673617379884035e-19 maxrel=1.7507749062342396e-16
0.004862699138847658,
-0.00018009994828783527,
5.558635424886019e-6,
-1.60124474674667e-7,
4.447798305178033e-9,
-1.2079334743929435e-10,
3.232392978135996e-12,
-8.716565334299315e-14,
// [20.,20. ]: m=2 maxabs=5.421010862427522e-20 maxrel=1.4589792908622624e-16
0.00036019989657567705,
-0.00002223454169938572,
9.607468474234226e-7,
-3.5582390866420995e-8,
1.2079408150154425e-9,
-3.876287995756811e-11,
1.196113847232826e-12,
-3.623043924520752e-14,
// [20.,20. ]: m=3 maxabs=6.776263578034403e-21 maxrel=1.4589809095341188e-16
0.00004446908339877371,
-3.8429873896709934e-6,
2.1349434502135455e-7,
-9.663527335947709e-9,
3.8763085627526535e-10,
-1.434634700362833e-11,
5.012523346490454e-13,
-1.680308421595428e-14,
// [20.,20. ]: m=4 maxabs=1.48908392127306e-17 maxrel=1.8320747856037913e-12
7.685974779349819e-6,
-8.539773801857107e-7,
5.798116324313712e-8,
-3.1010426527940208e-9,
1.4347404127750573e-10,
-6.056872487963956e-12,
2.00540796201086e-13,
1.1548452509409895e-13,
// [20.,20. ]: m=5 maxabs=4.658681209898652e-21 maxrel=2.5475149158876e-15
1.7079547601487566e-6,
-2.3192465597012505e-7,
1.8606283417904502e-8,
-1.1477102791565777e-9,
6.011613536016154e-11,
-2.809939151995244e-12,
1.2064846305325864e-13,
-4.837634243845734e-15,
// [20.,20. ]: m=6 maxabs=3.3881317890172014e-21 maxrel=6.737919924027471e-15
4.6384931194026793e-7,
-7.442513366874205e-8,
6.886261673329797e-9,
-4.809291974007743e-10,
2.8099412007199808e-11,
-1.4466839419196314e-12,
6.766349154337466e-14,
-2.9240169356644906e-15,
// [20.,20. ]: m=7 maxabs=2.4087499437544166e-21 maxrel=1.4743848661235505e-14
1.4885026733748922e-7,
-2.7545046691445308e-8,
2.8855751838161e-9,
-2.24795370340935e-10,
1.446684716425981e-11,
-8.112521208969047e-13,
4.0911274475800676e-14,
-1.8871894754589714e-15,
// [20.,20. ]: m=8 maxabs=1.760240343512843e-21 maxrel=2.875578849047088e-14
5.509009338289165e-8,
-1.1542300733997363e-8,
1.3487722219418378e-9,
-1.1573482782954021e-10,
8.112522628052561e-12,
-4.904511062666513e-13,
2.641602454169355e-14,
-1.2900004747417486e-15,
// [20.,20. ]: m=9 maxabs=1.3267977025350564e-21 maxrel=5.1101087558293635e-14
2.308460146799905e-8,
-5.395088886873582e-9,
6.944089668129633e-10,
-6.490021699533219e-11,
4.904512605174305e-12,
-3.166458392584324e-13,
1.805597259018769e-14,
-9.256472764525667e-16,
// [20.,20. ]: m=10 maxabs=1.017432153440224e-21 maxrel=8.284296269478955e-14
1.0790177773747497e-8,
-2.7776358665865407e-9,
3.894013020072091e-10,
-3.923612775111829e-11,
3.16645786365934e-12,
-2.164123382585439e-13,
1.2960730843661108e-14,
-6.928209357076811e-16
},
{
// [20.,21. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4180195825131953e-16
0.19455208528757398,
-0.002344001015832018,
0.00004236146121142283,
-8.506312630471564e-7,
1.793491357101261e-8,
-3.8893881452722197e-10,
8.645698949467613e-12,
-2.0409518831530103e-13,
// [20.,21. ]: m=1 maxabs=2.6020852139652106e-18 maxrel=5.450512805096976e-16
0.004688002031661902,
-0.0001694458448357188,
5.103787574534079e-6,
-1.4347948359699858e-7,
3.889442524149706e-9,
-1.0308445795071934e-10,
2.692391125718429e-12,
-7.653569561823788e-14,
// [20.,21. ]: m=2 maxabs=1.6263032587282567e-19 maxrel=4.655646760738732e-16
0.00033889168967146205,
-0.000020415150298039344,
8.608768992596726e-7,
-3.111554375053099e-8,
1.0308755081166126e-9,
-3.228627370976365e-11,
9.724418201077674e-13,
-2.8656594366319396e-14,
// [20.,21. ]: m=3 maxabs=2.0328790734103208e-20 maxrel=4.772041345426383e-16
0.00004083030059607917,
-3.4435075970181206e-6,
1.866932624305094e-7,
-8.247004761658808e-9,
3.228637546773298e-10,
-1.1663621111606772e-11,
3.9785938646685554e-13,
-1.3071526139659986e-14,
// [20.,21. ]: m=4 maxabs=4.235164736271502e-21 maxrel=5.823051054019886e-16
6.887015194036703e-6,
-7.467730497144242e-7,
4.94820285361368e-8,
-2.582910315911117e-9,
1.1663664153073779e-10,
-4.771770418505292e-12,
1.8165981823066702e-13,
-6.54475977884183e-15,
// [20.,21. ]: m=5 maxabs=3.5998900258307764e-21 maxrel=2.2548578338162524e-15
1.493546099428885e-6,
-1.9792811414078637e-7,
1.549746189098237e-8,
-9.330932768873287e-10,
4.7717766475368136e-11,
-2.1785566448092293e-12,
9.142442721806285e-14,
-3.588648813913959e-15,
// [20.,21. ]: m=6 maxabs=2.329340604949326e-21 maxrel=5.438573695837749e-15
3.9585622828159306e-7,
-6.198984756179908e-8,
5.598559659437e-9,
-3.817422157720039e-10,
2.178559082949811e-11,
-1.0962932061860714e-12,
5.0165011462225384e-14,
-2.1235261006545395e-15,
// [20.,21. ]: m=7 maxabs=1.5881867761018131e-21 maxrel=1.1697461460620951e-14
1.2397969512360138e-7,
-2.2394238636416913e-8,
2.290453294217885e-9,
-1.742847794995069e-10,
1.0962937205975096e-11,
-6.014746309040949e-13,
2.9713626575068926e-14,
-1.3450512506783626e-15,
// [20.,21. ]: m=8 maxabs=1.1911400820763599e-21 maxrel=2.399452502155909e-14
4.4788477272836016e-8,
-9.161813175986498e-9,
1.0457086768311927e-9,
-8.77035329782959e-11,
6.014748411731072e-12,
-3.562246210093987e-13,
1.8824203816479042e-14,
-9.033095941915059e-16,
// [20.,21. ]: m=9 maxabs=8.801201717564214e-22 maxrel=4.282230657256421e-14
1.8323626351973552e-8,
-4.182834706701061e-9,
5.262211978565598e-10,
-4.8118012239048225e-11,
3.562246358355183e-12,
-2.2565102398800974e-13,
1.2645920032125774e-14,
-6.383770591620399e-16,
// [20.,21. ]: m=10 maxabs=6.832511859688009e-22 maxrel=7.196665291188859e-14
8.365669413401915e-9,
-2.104884790965484e-9,
2.8870807344093684e-10,
-2.8497989286922263e-11,
2.2565101647357478e-12,
-1.515742756156917e-13,
8.937499488236433e-15,
-4.7123777788954745e-16
},
{
// [21.,21. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4352083261556195e-16
0.19224961265608248,
-0.002261760141948193,
0.000039913412534096336,
-7.826156496876291e-7,
1.6112628422223998e-8,
-3.411465245967223e-10,
7.38711195485659e-12,
-2.948041608998793e-13,
// [21.,21. ]: m=1 maxabs=0. maxrel=0.
0.004523520283895714,
-0.000159653650131256,
4.695693855309745e-6,
-1.2890111054337007e-7,
3.412051288824036e-9,
-8.830770942604654e-11,
2.253019539761878e-12,
-5.811043556199543e-14,
// [21.,21. ]: m=2 maxabs=1.0842021724855044e-19 maxrel=3.296494318014482e-16
0.0003193073002625115,
-0.000018782775420966116,
7.734066628377213e-7,
-2.729641629859419e-8,
8.830830909130491e-10,
-2.7008095539571663e-11,
7.944453925812665e-13,
-2.3253032522902136e-14,
// [21.,21. ]: m=3 maxabs=1.3552527156068805e-20 maxrel=3.461320629903716e-16
0.00003756555084193333,
-3.0936266513308614e-6,
1.6377849762965682e-7,
-7.06466532658037e-9,
2.70083343675932e-10,
-9.528714520079528e-12,
3.174897087004963e-13,
-1.016489707429722e-14,
// [21.,21. ]: m=4 maxabs=1.6940658945086007e-21 maxrel=2.5959976543993334e-16
6.187253302661965e-6,
-6.55113990512422e-7,
4.238799194443004e-8,
-2.160666977042036e-9,
9.528734522618388e-11,
-3.807869978775864e-12,
1.4164487873690325e-13,
-4.990405283412122e-15,
// [21.,21. ]: m=5 maxabs=2.329340604949326e-21 maxrel=1.6657866679248738e-15
1.310227981024886e-6,
-1.6955196777497667e-7,
1.2964001858489678e-8,
-7.622988691346947e-10,
3.80787512025449e-11,
-1.6987240685815847e-12,
6.969495276358836e-14,
-2.6763479173867048e-15,
// [21.,21. ]: m=6 maxabs=1.7999450129153882e-21 maxrel=4.915001300708469e-15
3.3910393554996414e-7,
-5.185600743234888e-8,
4.573793213679862e-9,
-3.0463007194463515e-10,
1.6987256013742556e-11,
-8.357514463250462e-13,
3.741937813049659e-14,
-1.5515862772722199e-15,
// [21.,21. ]: m=7 maxabs=1.1911400820763599e-21 maxrel=1.0509991198220693e-14
1.0371201486469923e-7,
-1.8295172853770665e-8,
1.8277804314164847e-9,
-1.358980858925533e-10,
8.357517721786558e-12,
-4.486705781735082e-13,
2.1712043330764052e-14,
-9.640752267540284e-16,
// [21.,21. ]: m=8 maxabs=8.536503921547246e-22 maxrel=2.1099459997958345e-14
3.6590345707542965e-8,
-7.311121725038926e-9,
8.153885152600218e-10,
-6.68601667538752e-11,
4.486707009472951e-12,
-2.603054445246168e-13,
1.349317253279363e-14,
-6.362035753743244e-16,
// [21.,21. ]: m=9 maxabs=6.088049308390284e-22 maxrel=3.721764404269705e-14
1.4622243450078341e-8,
-3.2615540606068905e-9,
4.0116100050695454e-10,
-3.589367338215249e-11,
2.6030546558108575e-12,
-1.617520638108917e-13,
8.906194495764769e-15,
-4.4250670115342816e-16,
// [21.,21. ]: m=10 maxabs=4.516406144539531e-22 maxrel=6.118151545140731e-14
6.523108121213773e-9,
-1.6046440017128574e-9,
2.153620402919487e-10,
-2.0824449833102077e-11,
1.6175206523225615e-12,
-1.067535390479917e-13,
6.195039073552595e-15,
-3.220696121018629e-16
},
{
// [21.,22. ]: m=0 maxabs=0. maxrel=0.
0.19002699908966,
-0.0021842183762238176,
0.00003765893649415847,
-7.214353980240976e-7,
1.45115902528715e-8,
-3.0021268339023473e-10,
6.377974634853157e-12,
-1.8141794516915647e-13,
// [21.,22. ]: m=1 maxabs=8.673617379884035e-19 maxrel=1.9513851966829008e-16
0.004368436752448303,
-0.0001506357459674742,
4.328612360676249e-6,
-1.1609288038719636e-7,
3.002380170155248e-9,
-7.591911377871157e-11,
1.8919553090443573e-12,
-4.8897805533874204e-14,
// [21.,22. ]: m=2 maxabs=1.2468324983583301e-18 maxrel=4.020666721003877e-15
0.0003012714919349211,
-0.000017314449442108866,
6.965572858050775e-7,
-2.401905225175824e-8,
7.59117179302602e-10,
-2.272922197848772e-11,
1.0298435918214458e-12,
4.5283619907457417e-13,
// [21.,22. ]: m=3 maxabs=6.776263578034403e-21 maxrel=1.879225220478485e-16
0.00003462889888505614,
-2.786229126673397e-6,
1.4411427041883282e-7,
-6.073609976201303e-9,
2.2686626471424815e-10,
-7.820801427017626e-12,
2.54649772416432e-13,
-7.994614038826353e-15,
// [21.,22. ]: m=4 maxabs=8.470329472543003e-22 maxrel=1.4429791377548704e-16
5.572458253347125e-6,
-5.764570816704611e-7,
3.644165983379286e-8,
-1.814930291630535e-9,
7.820830071587544e-11,
-3.0542678717185806e-12,
1.1105727919210088e-13,
-3.8270616027276436e-15,
// [21.,22. ]: m=5 maxabs=1.2705494208814505e-21 maxrel=1.0341440513028114e-15
1.152914163340934e-6,
-1.4576663933291957e-7,
1.0889581747124816e-8,
-6.256664909220262e-10,
3.0542718669818765e-11,
-1.3319100324839173e-12,
5.3441662625756486e-14,
-1.9976154278975302e-15,
// [21.,22. ]: m=6 maxabs=1.164670302474663e-21 maxrel=3.705808960191375e-15
2.9153327866567673e-7,
-4.35583269869056e-8,
3.753998950787025e-9,
-2.443418020256577e-10,
1.3319054812115691e-11,
-6.408441714181263e-13,
2.807952901400485e-14,
-1.1408951615635968e-15,
// [21.,22. ]: m=7 maxabs=8.337980574534519e-22 maxrel=8.776369448912874e-15
8.711665397381318e-8,
-1.5015995802460736e-8,
1.4660508118653967e-9,
-1.0655246583071442e-10,
6.4084455155814296e-12,
-3.366929401100041e-13,
1.596055377101552e-14,
-6.952012248557949e-16,
// [21.,22. ]: m=8 maxabs=5.757177063369073e-22 maxrel=1.7377247267265066e-14
3.003199160492312e-8,
-5.864203247018834e-9,
6.393147948850498e-10,
-5.126758178258098e-11,
3.366930693126668e-12,
-1.9135746630235922e-13,
9.728755382569383e-15,
-4.506140119486504e-16,
// [21.,22. ]: m=9 maxabs=4.1689902872672595e-22 maxrel=3.185492498945325e-14
1.1728406494038148e-8,
-2.557259179237849e-9,
3.0760549067183967e-10,
-2.693545761242926e-11,
1.9135749689231882e-12,
-1.1662935825887947e-13,
6.3076358064408245e-15,
-3.0833597900168694e-16,
// [21.,22. ]: m=10 maxabs=3.1184709093249143e-22 maxrel=5.4026425959800536e-14
5.114518358475671e-9,
-1.2304219624707641e-9,
1.6161274567435643e-10,
-1.5308608401943168e-11,
1.166293595355731e-12,
-7.560865675628729e-14,
4.316644570503896e-15,
-2.2113913454433724e-16
},
{
// [22.,23. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4689825546464102e-16
0.18787973243210115,
-0.0021110082271325555,
0.000035578789735633894,
-6.66269373940538e-7,
1.3100779783318514e-8,
-2.6491271977786746e-10,
5.487892841366984e-12,
-2.2677243146144559e-13,
// [22.,23. ]: m=1 maxabs=8.673617379884035e-19 maxrel=2.0198510156206413e-16
0.004222016454266803,
-0.00014231515893883652,
3.997616213914641e-6,
-1.0480631598427289e-7,
2.6495849060417067e-9,
-6.549320695078108e-11,
1.5952023225616063e-12,
-4.0393839354069995e-14,
// [22.,23. ]: m=2 maxabs=1.0625181290357943e-17 maxrel=3.628999069943066e-14
0.00028463031787842477,
-0.00001599046486877537,
6.288379161911399e-7,
-2.1196516509459542e-8,
6.547729246459368e-10,
-2.0050007571198934e-11,
9.217834278257305e-13,
1.701457608318639e-12,
// [22.,23. ]: m=3 maxabs=0. maxrel=0.
0.000031980929711109614,
-2.515351581278237e-6,
1.271800876948757e-7,
-5.239527379172283e-9,
1.9131832550344215e-10,
-6.447624733831913e-12,
2.0525507172328865e-13,
-6.33921958064832e-15,
// [22.,23. ]: m=4 maxabs=0. maxrel=0.
5.030703162556706e-6,
-5.08720350775447e-7,
3.143716425060025e-8,
-1.5305467415355303e-9,
6.447660793117419e-11,
-2.46187333834331e-12,
8.753728663063596e-14,
-2.9578411012763014e-15,
// [22.,23. ]: m=5 maxabs=8.470329472543003e-22 maxrel=7.823506238117346e-16
1.0174407015509237e-6,
-1.2574865700074705e-7,
9.183280444098129e-9,
-5.158129258992057e-10,
2.4618798750147016e-11,
-1.0498668598758592e-12,
4.12073927185106e-14,
-1.5171565639384585e-15,
// [22.,23. ]: m=6 maxabs=8.999725064576941e-22 maxrel=3.325068031995305e-15
2.51497314001492e-7,
-3.6733121775572554e-8,
3.094877554263254e-9,
-1.969504229687215e-10,
1.049868326233998e-11,
-4.941718949200111e-13,
2.119438653531373e-14,
-8.434847232684422e-16,
// [22.,23. ]: m=7 maxabs=5.69100261436483e-22 maxrel=7.117112547973211e-15
7.34662435511464e-8,
-1.2379510216558508e-8,
1.181702537632314e-9,
-8.398948582780762e-11,
4.941721152251659e-12,
-2.541434392282153e-13,
1.1802173760901535e-14,
-5.040319717064334e-16,
// [22.,23. ]: m=8 maxabs=3.8712052667481695e-22 maxrel=1.420442570547681e-14
2.4759020433116358e-8,
-4.726810150218526e-9,
5.039369149819991e-10,
-3.953378171115212e-11,
2.541434514016844e-12,
-1.4150585450921001e-13,
7.055600107413141e-15,
-3.209456993098944e-16,
// [22.,23. ]: m=9 maxabs=2.8289576949313546e-22 maxrel=2.6882474585501286e-14
9.453620300437406e-9,
-2.015747659716856e-9,
2.372026902469334e-10,
-2.0331484558144238e-11,
1.4150587968193354e-12,
-8.45861600297068e-14,
4.492459201478194e-15,
-2.1600076475640172e-16,
// [22.,23. ]: m=10 maxabs=2.125854174261281e-22 maxrel=4.6846985615002743e-14
4.031495319433732e-9,
-9.488107608381565e-10,
1.2198890734504933e-10,
-1.1320476346875218e-11,
8.458616551347027e-13,
-5.385223956767239e-14,
3.02382485209907e-15,
-1.526041084421452e-16
},
{
// [23.,23. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4855817544357513e-16
0.18580364956651185,
-0.0020417983454357248,
0.00003365601632231332,
-6.164104898341978e-7,
1.1854030309629778e-8,
-2.345096233573708e-10,
4.750882439117285e-12,
-2.267724314614456e-14,
// [23.,23. ]: m=1 maxabs=2.6020852139652106e-18 maxrel=6.267298032200778e-16
0.004083596690873872,
-0.0001346240652841314,
3.6984629700106146e-6,
-9.483232382112878e-8,
2.3447474380858643e-9,
-5.668292082254184e-11,
1.350536128930156e-12,
-3.7559183960801926e-14,
// [23.,23. ]: m=2 maxabs=1.0842021724855044e-19 maxrel=3.9170613233328965e-16
0.0002692481305682738,
-0.000014793851879958373,
5.689939410864698e-7,
-1.8757981697115695e-8,
5.668545042029416e-10,
-1.6194948210026454e-11,
4.4504089674308696e-13,
-1.2224451383468551e-14,
// [23.,23. ]: m=3 maxabs=1.3552527156068805e-20 maxrel=4.4066945274745543e-16
0.00002958770375991734,
-2.275975764332642e-6,
1.1254789009106723e-7,
-4.534836340830868e-9,
1.619508852408431e-10,
-5.338265805572962e-12,
1.6622596392086042e-13,
-4.999401992423959e-15,
// [23.,23. ]: m=4 maxabs=0. maxrel=0.
4.551951528665449e-6,
-4.5019156036094216e-7,
2.7209018030012093e-8,
-1.2956071937800598e-9,
5.338285845958554e-11,
-1.9937655284950034e-12,
6.93552837449828e-14,
-2.2927766889397255e-15,
// [23.,23. ]: m=5 maxabs=6.352747104407253e-22 maxrel=6.639582214744574e-16
9.003831207218798e-7,
-1.0883607211865982e-7,
7.773643159338696e-9,
-4.270629186224414e-10,
1.9937701609350762e-11,
-8.31808114153028e-13,
3.1949433118060494e-14,
-1.151665260332575e-15,
// [23.,23. ]: m=6 maxabs=5.823351512373315e-22 maxrel=2.4898833562960207e-15
2.176721442373125e-7,
-3.109457263673017e-8,
2.5623775109686743e-9,
-1.59501637558141e-10,
8.318091610882692e-12,
-3.831574758009355e-13,
1.6089024504900596e-14,
-6.276285870974171e-16,
// [23.,23. ]: m=7 maxabs=3.970466940254533e-22 maxrel=5.876799978850116e-15
6.218914527346185e-8,
-1.024951004350712e-8,
9.570098251573102e-10,
-6.654474739232868e-11,
3.831577408632308e-12,
-1.929298905851124e-13,
8.7781441309456e-15,
-3.6779454761973136e-16,
// [23.,23. ]: m=8 maxabs=1.107359920914539e-18 maxrel=4.917924889923962e-11
2.0499020086344537e-8,
-3.828039347910474e-9,
3.992683366061782e-10,
-3.065193989134765e-11,
1.9309664679493606e-12,
-1.0837260110748891e-13,
7.954991213109257e-16,
4.242962050847868e-15,
// [23.,23. ]: m=9 maxabs=1.9686898578762059e-22 maxrel=2.3153997704783697e-14
7.65607860080352e-9,
-1.5970739370611515e-9,
1.8391576984427025e-10,
-1.5434403165044996e-11,
1.052513141478714e-12,
-6.170266030078696e-14,
3.217711635817587e-15,
-1.521276451118158e-16,
// [23.,23. ]: m=10 maxabs=1.4392942658422682e-22 maxrel=4.013398305288872e-14
3.194147874122344e-9,
-7.356630792732358e-10,
9.260641898550217e-11,
-8.420109274555348e-12,
6.170266659238386e-13,
-3.857281999080023e-14,
2.129590870598573e-15,
-1.058397394461964e-16
},
{
// [23.,23. ]: m=0 maxabs=0. maxrel=0.
0.18379490245109786,
-0.001976289272806002,
0.000031875633219560874,
-5.712478786194066e-7,
1.0749267661594067e-8,
-2.079999261195278e-10,
4.138596874171382e-12,
-1.8141794516915647e-13,
// [23.,23. ]: m=1 maxabs=2.6020852139652106e-18 maxrel=6.477364311904562e-16
0.0039525785456170056,
-0.00012750253287021758,
3.4274872279349937e-6,
-8.599426783354095e-8,
2.0805017149366072e-9,
-4.9212363699545925e-11,
1.1475039363873306e-12,
-3.401586471921684e-14,
// [23.,23. ]: m=2 maxabs=1.6263032587282567e-19 maxrel=6.207474185098254e-16
0.0002550050657404602,
-0.000013709948911641907,
5.159656044223911e-7,
-1.6644015963479703e-8,
4.921572376274548e-10,
-1.3758647714275429e-11,
3.7001111180252275e-13,
-1.0009876857477873e-14,
// [23.,23. ]: m=3 maxabs=2.0328790734103208e-20 maxrel=7.13859587208344e-16
0.000027419897823284227,
-2.0638624176707283e-6,
9.98640956954257e-8,
-3.937258293090162e-9,
1.3758787318977386e-10,
-4.437840218914063e-12,
1.3522745699330588e-13,
-4.013916328358107e-15,
// [23.,23. ]: m=4 maxabs=1.6940658945086007e-21 maxrel=3.9092330852418343e-16
4.127724835341706e-6,
-3.994563827793196e-7,
2.3623549735578144e-8,
-1.1007030706219757e-9,
4.437870797992687e-11,
-1.6219969009363365e-12,
5.5220242791942755e-14,
-1.7855007115799856e-15,
// [23.,23. ]: m=5 maxabs=1.0587911840678754e-22 maxrel=1.2487860768629288e-16
7.989127655586143e-7,
-9.449419894135506e-8,
6.604218421827606e-9,
-3.550297003723253e-10,
1.6219997432259564e-11,
-6.623042230930795e-13,
2.4902955424878257e-14,
-8.789957718199725e-16,
// [23.,23. ]: m=6 maxabs=3.970466940254533e-22 maxrel=1.9583451682491355e-15
1.8898839788270043e-7,
-2.6416873686841484e-8,
2.13017820169717e-9,
-1.297599981630638e-10,
6.623049670517094e-12,
-2.986576516869982e-13,
1.2281437749444972e-14,
-4.695157515552506e-16,
// [23.,23. ]: m=7 maxabs=1.2427349764759874e-17 maxrel=2.1689900852024492e-10
5.283374738121977e-8,
-8.520712273204897e-9,
7.785616467875342e-10,
-5.29921359321463e-11,
2.967867729199013e-12,
-1.122370632231025e-13,
5.5410355039916747e-14,
-5.0480220678205014e-14,
// [23.,23. ]: m=8 maxabs=1.885971796620903e-22 maxrel=1.0095612455412242e-14
1.704142561303941e-8,
-3.11423995508312e-9,
3.1790644812918525e-10,
-2.3892636063377038e-11,
1.4727565630768885e-12,
-7.873285726804993e-14,
3.77572791660211e-15,
-1.65587565234994e-16,
// [23.,23. ]: m=9 maxabs=1.348304398461435e-22 maxrel=1.953595715558267e-14
6.228479910166303e-9,
-1.271625792411125e-9,
1.4335581636806947e-10,
-1.1782056728021128e-11,
7.873287456730144e-13,
-4.526826801396419e-14,
2.317654833128032e-15,
-1.0773545524984748e-16,
// [23.,23. ]: m=10 maxabs=1.0878293594715495e-19 maxrel=3.8190183564235213e-11
2.5432515849351187e-9,
-5.734232662992064e-10,
7.069232896386357e-11,
-6.298577613579698e-12,
4.5278395635935145e-13,
-2.8259950534283586e-14,
1.276691096755919e-15,
1.0135402304563551e-15
},
{
// [23.,24. ]: m=0 maxabs=5.551115123125783e-17 maxrel=3.0364716074295377e-16
0.1818499281088923,
-0.001914209769054175,
0.000030224364648880245,
-5.30251993450084e-7,
9.767781696288116e-9,
-1.850463040725396e-10,
3.611350971023521e-12,
-1.3606345887686736e-13,
// [23.,24. ]: m=1 maxabs=1.3010426069826053e-18 maxrel=3.3448632561976907e-16
0.0038284195381142866,
-0.00012089745858808311,
3.1815119406959757e-6,
-7.814237731242478e-8,
1.8507367289181907e-9,
-4.285874938447866e-11,
9.800821022224352e-13,
-2.267724314614456e-14,
// [23.,24. ]: m=2 maxabs=5.421010862427522e-20 maxrel=2.1834524149976012e-16
0.00024179491717619275,
-0.000012726047762181532,
4.6885426367761595e-7,
-1.480590287148096e-8,
4.2858924128249855e-10,
-1.1729427539673854e-11,
3.0877812615888044e-13,
-8.1496342556457e-15,
// [23.,24. ]: m=3 maxabs=1.3552527156068805e-20 maxrel=5.131113432511694e-16
0.00002545209552436403,
-1.8754170547037113e-6,
8.883541713460414e-8,
-3.428714140644568e-9,
1.1729544964027822e-10,
-3.703776411879377e-12,
1.1048927542891124e-13,
-3.2139012808439737e-15,
// [23.,24. ]: m=4 maxabs=8.470329472543003e-22 maxrel=2.1532358260207206e-16
3.7508341094075636e-6,
-3.5534166853664547e-7,
2.0572284826811374e-8,
-9.383636620104489e-10,
3.703800986303536e-11,
-1.325301095459901e-12,
4.41760904253733e-14,
-1.402794551307221e-15,
// [23.,24. ]: m=5 maxabs=1.0587911840678754e-22 maxrel=1.4055869686177866e-16
7.106833370732654e-7,
-8.228913930651568e-8,
5.630181969254769e-9,
-2.963041065384802e-10,
1.325305069772327e-11,
-5.29855267755183e-13,
1.95100555467082e-14,
-6.755317372445788e-16,
// [23.,24. ]: m=6 maxabs=3.970466940254533e-22 maxrel=2.2521505829562756e-15
1.6457827861302306e-7,
-2.2520727876656005e-8,
1.7778246385046125e-9,
-1.0602441983133443e-10,
5.298562458228875e-12,
-2.339862552412607e-13,
9.425653066021698e-15,
-3.532722156450952e-16,
// [23.,24. ]: m=7 maxabs=1.6543612251060553e-22 maxrel=3.392754876389878e-15
4.50414557533141e-8,
-7.111298553817589e-9,
6.361465188344496e-10,
-4.2388507553770135e-11,
2.339864585153858e-12,
-1.1303275867433891e-13,
4.939329766069831e-15,
-1.9940902750876037e-16,
// [23.,24. ]: m=8 maxabs=1.4558378780933287e-22 maxrel=9.35575225217913e-15
1.4222597107634482e-8,
-2.5445860751864637e-9,
2.543310452030351e-10,
-1.8718921891957186e-11,
1.1303294541163831e-12,
-5.922524570789252e-14,
2.7856580670474285e-15,
-1.1994981236905815e-16,
// [23.,24. ]: m=9 maxabs=9.512577044359818e-23 maxrel=1.690499386301329e-14
5.089172150373042e-9,
-1.0173241807369734e-9,
1.1231353133912664e-10,
-9.042638635125242e-12,
5.922526299024816e-13,
-3.3399096750473236e-14,
1.6787347409363188e-15,
-7.675317375723557e-17,
// [23.,24. ]: m=10 maxabs=6.824240053562478e-23 maxrel=3.0017069131261196e-14
2.034648361474262e-9,
-4.4925412530414914e-10,
5.4255831790321974e-11,
-4.738023101680661e-12,
3.339912827392921e-13,
-2.0125289138793486e-14,
1.0735284843724785e-15,
-5.169559550623049e-17
},
{
// [24.,25. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.5343022384720602e-16
0.17996542203872173,
-0.0018553136289585436,
0.000028690416868475694,
-4.929624804438865e-7,
8.893639524410212e-9,
-1.6499820380365118e-10,
3.1521367973140938e-12,
-1.5874070202301192e-13,
// [24.,25. ]: m=1 maxabs=8.673617379884035e-19 maxrel=2.3014533581882584e-16
0.0037106272579242932,
-0.00011476166746775233,
2.957774858972908e-6,
-7.1149210884952e-8,
1.6503665656843322e-9,
-3.742976422550303e-11,
8.365776729382391e-13,
-2.1259915449510525e-14,
// [24.,25. ]: m=2 maxabs=5.421010862427522e-20 maxrel=2.301453365872762e-16
0.00022952333493550623,
-0.00001183109943584243,
4.2689526469412944e-7,
-1.3202933716673534e-8,
3.743083808653177e-10,
-1.0032734034804254e-11,
2.586623046357114e-13,
-6.732306559011666e-15,
// [24.,25. ]: m=3 maxabs=6.776263578034403e-21 maxrel=2.7617441275726524e-16
0.00002366219887168597,
-1.707581058773392e-6,
7.921760220937936e-8,
-2.994467180910789e-9,
1.0032850178857324e-10,
-3.102773412088857e-12,
9.065291616688909e-14,
-2.5633700138342116e-15,
// [24.,25. ]: m=4 maxabs=8.470329472543003e-22 maxrel=2.367209772517695e-16
3.415162117546841e-6,
-3.1687040883654446e-7,
1.7966803076519386e-8,
-8.026280584108427e-10,
3.102785365168354e-11,
-1.0874136409217134e-12,
3.550395499250167e-14,
-1.1034809630287933e-15,
// [24.,25. ]: m=5 maxabs=1.2705494208814505e-21 maxrel=1.8937700380174454e-15
6.337408176730545e-7,
-7.186721230546e-8,
4.815768348599331e-9,
-2.4822285131122936e-10,
1.0874163122252019e-11,
-4.2584892676403766e-13,
1.5360583035450588e-14,
-5.031236501235075e-16,
// [24.,25. ]: m=6 maxabs=2.117582368135751e-22 maxrel=1.3772943457201954e-15
1.437344246108448e-7,
-1.9263073393440483e-8,
1.489337116081532e-9,
-8.699331917856642e-11,
4.258402756430031e-12,
-1.8422644441517575e-13,
7.271882019326163e-15,
-2.6713305219762573e-16,
// [24.,25. ]: m=7 maxabs=1.3896634290890865e-22 maxrel=3.3373531798102146e-15
3.852614678688211e-8,
-5.957348464183422e-9,
5.219599149827269e-10,
-3.4067227799919635e-11,
1.8422657219858592e-12,
-8.720725366048974e-14,
3.735604973346795e-15,
-1.4773742412767412e-16,
// [24.,25. ]: m=8 maxabs=1.257314531080602e-22 maxrel=9.663016108596925e-15
1.1914696928367332e-8,
-2.087839659843662e-9,
2.0440336675652184e-10,
-1.473812922882043e-11,
8.72073090620238e-13,
-4.479436275949897e-14,
2.0665961668597964e-15,
-8.727456542612684e-17,
// [24.,25. ]: m=9 maxabs=6.534726839168919e-23 maxrel=1.4182821903085263e-14
4.175679319687715e-9,
-8.176134669759694e-10,
8.842877535839478e-11,
-6.97658672250696e-12,
4.479435122701663e-13,
-2.4779191836123373e-14,
1.2226853299321022e-15,
-5.489195482650421e-17,
// [24.,25. ]: m=10 maxabs=4.694249976238432e-23 maxrel=2.574994962638943e-14
1.6352269339520788e-9,
-3.537151013979262e-10,
4.185952033329211e-11,
-3.583549523172917e-12,
2.4779194034169524e-13,
-1.4658557994015476e-14,
7.684191927647511e-16,
-3.641058428581173e-17
},
{
// [25.,25. ]: m=0 maxabs=5.551115123125783e-17 maxrel=3.1004043363949757e-16
0.17813831459582904,
-0.0017993769149250787,
0.000027263286547579982,
-4.5897788923746184e-7,
8.113220626795702e-9,
-1.4744318295314202e-10,
2.789300906975781e-12,
-2.0409518831530103e-13,
// [25.,25. ]: m=1 maxabs=0. maxrel=0.
0.0035987538298585886,
-0.00010905314617921945,
2.7538672827518084e-6,
-6.490595554251675e-8,
1.4751342372067014e-9,
-3.277948990710151e-11,
7.178764783451387e-13,
-1.8070928132083947e-14,
// [25.,25. ]: m=2 maxabs=2.710505431213761e-20 maxrel=1.211600069691628e-16
0.00021810629235844917,
-0.000011015469130906425,
3.8943573232547665e-7,
-1.1801075305292543e-8,
3.278066923724205e-10,
-8.608883032082096e-12,
2.1746568201596976e-13,
-5.5142905697167924e-15,
// [25.,25. ]: m=3 maxabs=0. maxrel=0.
0.000022030938261813933,
-1.5577429292951532e-6,
7.080645175488585e-8,
-2.62245367261077e-9,
8.608970823525757e-11,
-2.6086703468587948e-12,
7.467891328910258e-14,
-2.0817000544312387e-15,
// [25.,25. ]: m=4 maxabs=1.6940658945086007e-21 maxrel=5.194736149505314e-16
3.115485858590327e-6,
-2.832258070185988e-7,
1.5734722025223317e-8,
-6.887177015539577e-10,
2.6086851254672162e-11,
-8.958156167318022e-13,
2.865979511856399e-14,
-8.740648832269463e-16,
// [25.,25. ]: m=5 maxabs=2.117582368135751e-22 maxrel=3.535309304248437e-16
5.664516140371812e-7,
-6.293888810036087e-8,
4.132306207465709e-9,
-2.0869482855220166e-10,
8.958182278860192e-12,
-3.437548761659589e-13,
1.2151482882973507e-14,
-4.044193714455636e-16,
// [25.,25. ]: m=6 maxabs=2.6469779601696886e-23 maxrel=1.968531339993777e-16
1.258777762007176e-7,
-1.652922482966212e-8,
1.2521689707786036e-9,
-7.166546616103922e-11,
3.4375558765074048e-12,
-1.4574172671811911e-13,
5.638871200155946e-15,
-2.032477675318399e-16,
// [25.,25. ]: m=7 maxabs=9.26442286059391e-23 maxrel=2.5969811314341503e-15
3.305844965932572e-8,
-5.008675882999421e-9,
4.2999279685700354e-10,
-2.7500451457381853e-11,
1.457418802846159e-12,
-6.762458780557738e-14,
2.840341864844512e-15,
-1.1020968539500492e-16,
// [25.,25. ]: m=8 maxabs=6.948317145445432e-23 maxrel=6.362876040778998e-15
1.0017351765999106e-8,
-1.7199711873643293e-9,
1.6500270871406207e-10,
-1.1659352944302552e-11,
6.762462912229782e-13,
-3.4060022394503455e-14,
1.5416008223706354e-15,
-6.398665984245165e-17,
// [25.,25. ]: m=9 maxabs=4.714929491552258e-23 maxrel=1.2446572144085789e-14
3.4399423747288832e-9,
-6.600108348175342e-10,
6.995611765639521e-11,
-5.409971876138067e-12,
3.406003462182815e-13,
-1.8484379186977296e-14,
8.95424295033182e-16,
-3.9509285519230694e-17,
// [25.,25. ]: m=10 maxabs=3.226004388956808e-23 maxrel=2.1969500139469613e-14
1.3200216696352028e-9,
-2.7982447060029694e-10,
3.245983125357644e-11,
-2.7248037788377966e-12,
1.8484383323559702e-13,
-1.073541670537385e-14,
5.530004482413822e-16,
-2.577970742612136e-17
},
{
// [25.,25. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.565940664773411e-16
0.1763657499579808,
-0.0017461955440266942,
0.000025933597162524518,
-4.279471501520943e-7,
7.414920987260322e-9,
-1.320850200324156e-10,
2.4094570842778593e-12,
-2.0409518831530103e-13,
// [25.,25. ]: m=1 maxabs=0. maxrel=0.
0.0034923910880626566,
-0.00010373438864724292,
2.5676828605654403e-6,
-5.931940175062243e-8,
1.3214709787824092e-9,
-2.8782714385574564e-11,
6.182206246755581e-13,
-1.7362264283766928e-14,
// [25.,25. ]: m=2 maxabs=1.3552527156068805e-19 maxrel=6.371828885665187e-16
0.00020746877729449433,
-0.000010270731442143693,
3.559164093441323e-7,
-1.0571770083761869e-8,
2.878446403786101e-10,
-7.409715840221561e-12,
1.835051816599027e-13,
-4.62846075932052e-15,
// [25.,25. ]: m=3 maxabs=2.0328790734103208e-20 maxrel=9.557743453312734e-16
0.000020541462884288057,
-1.4236656373670168e-6,
6.343062043761811e-8,
-2.302757338311909e-9,
7.409806447462128e-11,
-2.2008581780339597e-12,
6.176171531172257e-14,
-1.702454166855335e-15,
// [25.,25. ]: m=4 maxabs=0. maxrel=0.
2.847331274734068e-6,
-2.537224817491729e-7,
1.3816544016281097e-8,
-5.927845555319846e-10,
2.2008768143057704e-11,
-7.408306298138496e-13,
2.3232789927625504e-14,
-6.962068666083199e-16,
// [25.,25. ]: m=5 maxabs=1.0587911840678754e-22 maxrel=1.9753946134741042e-16
5.074449634983306e-7,
-5.526617606474854e-8,
3.5567073310856693e-9,
-1.7607015844995355e-10,
7.40833427363225e-12,
-2.7867269939435734e-13,
9.657231816259083e-15,
-3.159228972233579e-16,
// [25.,25. ]: m=6 maxabs=7.940933880509066e-23 maxrel=6.734315681551426e-16
1.1053235212949471e-7,
-1.4226829324178232e-8,
1.0564209499819216e-9,
-5.926668040327184e-11,
2.7867361991475315e-12,
-1.1582817207463692e-13,
4.3941083842495584e-15,
-1.5534461738467823e-16,
// [25.,25. ]: m=7 maxabs=7.279189390466644e-23 maxrel=2.3742994752226237e-15
2.8453658648358075e-8,
-4.225683799839392e-9,
3.5560008232094864e-10,
-2.229389298001931e-11,
1.1582829886119118e-12,
-5.269766851461966e-14,
2.170820999741706e-15,
-8.265726404625369e-17,
// [25.,25. ]: m=8 maxabs=4.7976475528075605e-23 maxrel=5.2164215317064065e-15
8.451367599679082e-9,
-1.4224003292374344e-9,
1.3376335785225613e-10,
-9.26626575139969e-12,
5.269770383753278e-13,
-2.603218365527664e-14,
1.1560970451391497e-15,
-4.712053378330144e-17,
// [25.,25. ]: m=9 maxabs=3.3914405114674135e-23 maxrel=1.0846464589304875e-14
2.844800658475058e-9,
-5.350534313808408e-10,
5.559759450065277e-11,
-4.2158174291281485e-12,
2.603219486356961e-13,
-1.3862422658991656e-14,
6.593097659538261e-16,
-2.858847565427604e-17,
// [25.,25. ]: m=10 maxabs=2.2540671692070004e-23 maxrel=1.8975306203333595e-14
1.0701068627617902e-9,
-2.2239037798454544e-10,
2.5294904571676982e-11,
-2.082576309149621e-12,
1.3862426670967073e-13,
-7.90482423910809e-15,
4.001116022717768e-16,
-1.8347724266121358e-17
},
{
// [25.,26. ]: m=0 maxabs=1.1102230246251565e-16 maxrel=6.326090190820383e-16
0.1746450673491059,
-0.001695583178078006,
0.000024692958889711008,
-3.995624467184672e-7,
6.788669783855636e-9,
-1.185750524281e-10,
2.142999477310661e-12,
-1.8141794516915647e-13,
// [25.,26. ]: m=1 maxabs=0. maxrel=0.
0.0033911663561658353,
-0.00009877183555278761,
2.397374633427222e-6,
-5.4309455164017034e-8,
1.1863711477190363e-9,
-2.533887383169698e-11,
5.333581288395953e-13,
-1.3818945042181841e-14,
// [25.,26. ]: m=2 maxabs=5.421010862427522e-20 maxrel=2.6780860352441025e-16
0.0001975436711055773,
-9.589498533666312e-6,
3.2585673036780604e-7,
-9.490970093793666e-9,
2.533993433607311e-10,
-6.396312696037439e-12,
1.5530257507141138e-13,
-3.986234146783223e-15,
// [25.,26. ]: m=3 maxabs=5.082197683525802e-20 maxrel=2.5609197925159325e-15
0.00001917899706733381,
-1.3034269214673576e-6,
5.6945820452555014e-8,
-2.027194838637142e-9,
6.396454346625625e-11,
-1.8629980169806808e-12,
5.129577451279849e-14,
-1.4145594784765466e-15,
// [25.,26. ]: m=4 maxabs=4.235164736271502e-22 maxrel=1.5548442540228295e-16
2.606853842934674e-6,
-2.2778328180750582e-7,
1.2163169027608348e-8,
-5.117164365414632e-10,
1.8630124241504548e-11,
-6.149130581381509e-13,
1.890026899070397e-14,
-6.048556674112044e-16,
// [25.,26. ]: m=5 maxabs=0. maxrel=0.
4.5556656361577127e-7,
-4.865267611236003e-8,
3.070298589162654e-9,
-1.4904096709431005e-10,
6.149416291772749e-12,
-2.268379603756424e-13,
7.709163168039723e-15,
-2.469769637384137e-16,
// [25.,26. ]: m=6 maxabs=2.6469779601696886e-23 maxrel=2.553129884507552e-16
9.730535222471236e-8,
-1.2281194356516758e-8,
8.942458021897477e-10,
-4.919533533020414e-11,
2.2683848759414447e-12,
-9.246395125796767e-14,
3.440438305628511e-15,
-1.1937940804168508e-16,
// [25.,26. ]: m=7 maxabs=3.639594695233322e-23 maxrel=1.377225785546595e-15
2.4562388713035094e-8,
-3.5769832086925313e-9,
2.9517201189068144e-10,
-1.814708156009515e-11,
9.246407064413406e-13,
-4.126142957372192e-14,
1.6674817584091558e-15,
-6.232005193806535e-17,
// [25.,26. ]: m=8 maxabs=3.3087224502121107e-23 maxrel=4.256970159863447e-15
7.153966417385243e-9,
-1.1806880475279924e-9,
1.0888248933896135e-10,
-7.39712702606724e-12,
4.126146022070502e-13,
-1.9996641779782898e-14,
8.714460244964123e-16,
-3.4982545963845693e-17,
// [25.,26. ]: m=9 maxabs=2.2333876538931747e-23 maxrel=8.620914159365633e-15
2.3613760950559998e-9,
-4.355299573387688e-10,
4.43827621587131e-11,
-3.3009174912522106e-12,
1.999666017356951e-13,
-1.045050913161475e-14,
4.880427409254426e-16,
-2.079576582397345e-17,
// [25.,26. ]: m=10 maxabs=1.5923226791645783e-23 maxrel=1.6501035277378437e-14
8.710599146776145e-10,
-1.7753104862195342e-10,
1.9805504944951166e-11,
-1.5997333289684775e-12,
1.0450512495739427e-13,
-5.851580798682063e-15,
2.910341931208153e-16,
-1.3125888916064295e-17
},
{
// [26.,27. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.5969524013599642e-16
0.172973784239596,
-0.0016473693736676117,
0.00002353384818694789,
-3.735531452621381e-7,
6.225877302076193e-9,
-1.0671768891805967e-10,
1.8822111811299986e-12,
-6.803172943843368e-14,
// [26.,27. ]: m=1 maxabs=4.336808689942018e-19 maxrel=1.297523826143169e-16
0.0032947387473448975,
-0.00009413539274338196,
2.241318865384131e-6,
-4.980708448013588e-8,
1.0672943391405825e-9,
-2.236113477830465e-11,
4.617830801595765e-13,
-1.2047285421389297e-14,
// [26.,27. ]: m=2 maxabs=5.421010862427522e-20 maxrel=2.811301624742656e-16
0.00018827078548677424,
-8.965275461474746e-6,
2.988425059110738e-7,
-8.538355754320715e-9,
2.23623383649568e-10,
-5.537158819915804e-12,
1.3191113164063482e-13,
-3.4104447700256464e-15,
// [26.,27. ]: m=3 maxabs=2.40896170199123e-18 maxrel=1.2992430527596068e-13
0.000017930550922890925,
-1.19537002231522e-6,
5.123015072333643e-8,
-1.7889618180403657e-9,
5.5255589780315045e-11,
-1.8224835871231253e-12,
2.9543185436708974e-13,
5.482428378724101e-13,
// [26.,27. ]: m=4 maxabs=8.470329472543003e-22 maxrel=3.3936428271547925e-16
2.3907400472703407e-6,
-2.0492053758543047e-7,
1.0733923447491474e-8,
-4.429857381399727e-10,
1.5820720701876045e-11,
-5.122685236868833e-13,
1.5454269918718083e-14,
-4.453370960859382e-16,
// [26.,27. ]: m=5 maxabs=2.6469779601696886e-22 maxrel=6.127412053758969e-16
4.098410751708706e-7,
-4.293569378968335e-8,
2.657914427571464e-9,
-1.2656577481345398e-10,
5.1227025571556844e-12,
-1.853727232744548e-13,
6.180414690566782e-15,
-1.9464033919839956e-16,
// [26.,27. ]: m=6 maxabs=6.617444900424221e-23 maxrel=7.241494758470463e-16
8.587138757935959e-8,
-1.0631657710183598e-8,
7.593946484483588e-10,
-4.098162431055818e-11,
1.8537330131571212e-12,
-7.412947132076045e-14,
2.706171142692771e-15,
-9.218382731479757e-17,
// [26.,27. ]: m=7 maxabs=2.9778502051908996e-23 maxrel=1.3034746623631579e-15
2.1263315420368735e-8,
-3.0375785937425777e-9,
2.4588974577959045e-10,
-1.482986603358179e-11,
7.412958042579434e-13,
-3.2456050156771905e-14,
1.287109254703239e-15,
-4.723272231214496e-17,
// [26.,27. ]: m=8 maxabs=2.3161057151484775e-23 maxrel=3.514606304127088e-15
6.075157187484759e-9,
-9.835589830923439e-10,
8.897919618234364e-11,
-5.9303674602443335e-12,
3.2456077361222966e-13,
-1.543552636662674e-14,
6.603557043390758e-16,
-2.596353441314207e-17,
// [26.,27. ]: m=9 maxabs=6.617444900424222e-24 maxrel=3.0717287890848517e-15
1.9671179661849574e-9,
-3.55916784714219e-10,
3.558220475514127e-11,
-2.5964867935083667e-12,
1.5435535729574696e-13,
-7.91851144026537e-15,
3.6318147020555265e-16,
-1.526270868155228e-17,
// [26.,27. ]: m=10 maxabs=1.1063540692896745e-23 maxrel=1.4056934663682737e-14
7.118335694281697e-10,
-1.4232881900433738e-10,
1.55789207435695e-11,
-1.2348433280085913e-12,
7.91853859746081e-14,
-4.354311673704695e-15,
2.1280822812508145e-16,
-9.44005645112238e-18
},
{
// [27.,27. ]: m=0 maxabs=5.551115123125783e-17 maxrel=3.2244691814435293e-16
0.17134958128195726,
-0.0016013979558784513,
0.00002244950404982426,
-3.4968075125434755e-7,
5.719067492654174e-9,
-9.61869441320688e-11,
1.6724466820281612e-12,
-6.803172943843368e-14,
// [27.,27. ]: m=1 maxabs=4.336808689942018e-19 maxrel=1.3351317704655895e-16
0.003202795911766901,
-0.00008979801619520251,
2.098084484926352e-6,
-4.575262045070618e-8,
9.620874772556441e-10,
-1.9779339504414196e-11,
4.011037381474319e-13,
-1.2401617345547807e-14,
// [27.,27. ]: m=2 maxabs=8.131516293641283e-20 maxrel=4.4226239910737043e-16
0.0001795960323904159,
-8.392337939614022e-6,
2.7451572135985627e-7,
-7.696701540914929e-9,
1.978122850188214e-10,
-4.8065319287372735e-12,
1.1236751144876708e-13,
-2.812509648008163e-15,
// [27.,27. ]: m=3 maxabs=1.1458593947820395e-15 maxrel=6.606108121186228e-11
0.000016784675879228456,
-1.0980628854320836e-6,
4.618020916943657e-8,
-1.582498441064065e-9,
4.806642090843919e-11,
-1.3476346902738386e-12,
3.5698249304430386e-14,
-9.301213009160854e-16,
// [27.,27. ]: m=4 maxabs=8.470329472543003e-22 maxrel=3.697366413650042e-16
2.1961257708642355e-6,
-1.847208366767756e-7,
9.49499063913032e-9,
-3.8453139158268753e-10,
1.347644911054317e-11,
-4.2821026010578393e-13,
1.2677055052217896e-14,
-3.5917630593411335e-16,
// [27.,27. ]: m=5 maxabs=0. maxrel=0.
3.694416733535613e-7,
-3.797996255632031e-8,
2.3071883483893198e-9,
-1.0781159989900071e-10,
4.282118589274869e-12,
-1.5206317320279437e-13,
4.9753639105329565e-15,
-1.5346309410576039e-16,
// [27.,27. ]: m=6 maxabs=3.970466940254533e-23 maxrel=4.917571656187195e-16
7.595992511263012e-8,
-9.228753393472862e-9,
6.468695991711689e-10,
-3.4256951769900214e-11,
1.520634881247807e-12,
-5.967665635977114e-14,
2.1380997960520196e-15,
-7.145463119016802e-17,
// [27.,27. ]: m=7 maxabs=9.926167350636332e-24 maxrel=5.012155139318882e-16
1.8457506786946614e-8,
-2.587478396648614e-9,
2.0554171057325182e-10,
-1.216508047278306e-11,
5.967672202554182e-13,
-2.5643635243572625e-14,
9.982170345860589e-16,
-3.598413270930412e-17,
// [27.,27. ]: m=8 maxabs=1.819797347616661e-23 maxrel=3.2467965870718663e-15
5.174956793296991e-9,
-8.221668422735e-10,
7.299048281501291e-11,
-4.774138533350041e-12,
2.564366454099868e-13,
-1.1971263078176508e-14,
5.028364204562877e-16,
-1.9422132180151414e-17,
// [27.,27. ]: m=9 maxabs=1.1994118882018901e-23 maxrel=6.671776277796734e-15
1.6443336845472998e-9,
-2.919619312488469e-10,
2.864483119252516e-11,
-2.0514936049232274e-12,
1.1971272754225925e-13,
-6.029827071667405e-15,
2.7161020239575835e-16,
-1.1177458020546982e-17,
// [27.,27. ]: m=10 maxabs=7.754818242684634e-24 maxrel=1.2033900596893972e-14
5.839238624977063e-10,
-1.1457932476336186e-10,
1.2308961628044971e-11,
-9.57702088466836e-13,
6.029829158438457e-14,
-3.256757140463486e-15,
1.5641623748135e-16,
-6.824070017260556e-18
},
{
// [27.,27. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.6273732758130855e-16
0.16977028877386896,
-0.0015575255850630752,
0.000021433838324431256,
-3.277345318068451e-7,
5.261779821616397e-9,
-8.687651849287981e-11,
1.496698047645541e-12,
-6.803172943843368e-14,
// [27.,27. ]: m=1 maxabs=8.673617379884035e-19 maxrel=2.7461924029651196e-16
0.0031150511701355196,
-0.00008573535329305356,
1.96640718228001e-6,
-4.209434276727852e-8,
8.689196791841675e-10,
-1.753785789793273e-11,
3.4910552827717075e-13,
-7.0866384831701746e-15,
// [27.,27. ]: m=2 maxabs=8.131516293641283e-20 maxrel=4.634199680922935e-16
0.00017147070658610423,
-7.865628729052457e-6,
2.525660567520303e-7,
-6.951358816803857e-9,
1.7537822672356677e-10,
-4.183195636906677e-12,
9.601287857432591e-14,
-2.4360319785897477e-15,
// [27.,27. ]: m=3 maxabs=3.3881317890172014e-21 maxrel=2.0853898608828568e-16
0.000015731257458105483,
-1.0102642269995915e-6,
4.170815280338943e-8,
-1.4030259886188118e-9,
4.183327170522566e-11,
-1.1513585071579983e-12,
2.99382793732365e-14,
-7.640282114667844e-16,
// [27.,27. ]: m=4 maxabs=1.6940658945086007e-21 maxrel=8.043646739194859e-16
2.020528453999264e-6,
-1.6683261121297374e-7,
8.418155924154001e-9,
-3.346661899861871e-10,
1.1513674222262011e-11,
-3.5913316065892437e-13,
1.0437653069627243e-14,
-2.917009883453348e-16,
// [27.,27. ]: m=5 maxabs=1.0587911840678754e-22 maxrel=3.0163678262960116e-16
3.3366522242596453e-7,
-3.3672623696393394e-8,
2.0079971383810353e-9,
-9.210940098485739e-11,
3.5913513713695213e-12,
-1.2519563173424535e-13,
4.021236967782402e-15,
-1.2219087960788417e-16,
// [27.,27. ]: m=6 maxabs=1.3234889800848443e-23 maxrel=1.8509538853206153e-16
6.734524739277754e-8,
-8.031988553465646e-9,
5.526564055701395e-10,
-2.8730813228496874e-11,
1.2519607697402126e-12,
-4.823362038223658e-14,
1.6965771099467611e-15,
-5.571039041945304e-17,
// [27.,27. ]: m=7 maxabs=2.6469779601696886e-23 maxrel=1.5377186447620933e-15
1.6063977106931914e-8,
-2.210625622251105e-9,
1.7238487931486848e-10,
-1.0015687295256143e-11,
4.823369292462342e-13,
-2.0348291401246143e-14,
7.777246736688497e-16,
-2.7903855294526116e-17,
// [27.,27. ]: m=8 maxabs=1.3234889800848443e-23 maxrel=2.767913708798945e-15
4.42125124450354e-9,
-6.895395172296467e-10,
6.009412357136444e-11,
-3.858696094756507e-12,
2.0348508499354946e-13,
-9.327176585813652e-15,
3.8474312548923644e-16,
-1.459802543987997e-17,
// [27.,27. ]: m=9 maxabs=8.06501097239202e-24 maxrel=5.35786862073014e-15
1.3790790344595852e-9,
-2.4037649427722354e-10,
2.3152176563445365e-11,
-1.6278810054135327e-12,
9.327183290039204e-14,
-4.613809015596922e-15,
2.0416027084080325e-16,
-8.260049394732082e-18,
// [27.,27. ]: m=10 maxabs=3.5155176033503676e-24 maxrel=6.6381196345683644e-15
4.807529885544686e-10,
-9.260870624885731e-11,
9.76728603021106e-12,
-7.461748592849038e-13,
4.613811978444859e-14,
-2.4480460299757724e-15,
1.1554932714827907e-16,
-4.9912068231422936e-18
},
{
// [27.,28. ]: m=0 maxabs=8.326672684688674e-17 maxrel=4.927117274763749e-16
0.1682338744689366,
-0.0015156204906982783,
0.000020481357980889712,
-3.0752789927168804e-7,
4.848406277599204e-9,
-7.862483664307645e-11,
1.3152801024763844e-12,
0,
// [27.,28. ]: m=1 maxabs=8.673617379884035e-19 maxrel=2.822827605352801e-16
0.003031240981405853,
-0.00008192543192188606,
1.845167383660699e-6,
-3.8787302130420514e-8,
7.862287286911553e-10,
-1.5581989968068283e-11,
3.049912037194364e-13,
-8.1496342556457e-15,
// [27.,28. ]: m=2 maxabs=0. maxrel=0.
0.00016385086384377708,
-7.380669534513689e-6,
2.3272381215296978e-7,
-6.289832443419237e-9,
1.5582912684385626e-10,
-3.64991640228457e-12,
8.224929789529384e-14,
-2.1038457996911456e-15,
// [27.,28. ]: m=3 maxabs=6.776263578034403e-21 maxrel=4.447423707741957e-16
0.000014761339069028205,
-9.308952486069188e-7,
3.7738994565579605e-8,
-1.2466331216192097e-9,
3.6500476504279616e-11,
-9.864892296547595e-13,
2.5188017014986494e-14,
-6.297696308285995e-16,
// [27.,28. ]: m=4 maxabs=1.2705494208814505e-21 maxrel=6.552008210901822e-16
1.8617904972138875e-6,
-1.5095597826214488e-7,
7.479798725132424e-9,
-2.9200382135534653e-10,
9.864951688884429e-12,
-3.0216396628576223e-13,
8.623345587845895e-15,
-2.366826524652539e-16,
// [27.,28. ]: m=5 maxabs=5.293955920339377e-23 maxrel=1.6683355330468594e-16
3.0191195652430004e-7,
-2.99191949003659e-8,
1.7520229269997185e-9,
-7.891961843993652e-11,
3.0216552185405643e-12,
-1.034395537300757e-13,
3.2626694991653508e-15,
-9.732016959919978e-17,
// [27.,28. ]: m=6 maxabs=1.4558378780933287e-22 maxrel=2.2939621071409692e-15
5.983838980072021e-8,
-7.008091707955146e-9,
4.735177103936576e-10,
-2.4173243548451976e-11,
1.0343988225323153e-12,
-3.9135158402241903e-14,
1.3519069159590173e-15,
-4.374000955875146e-17,
// [27.,28. ]: m=7 maxabs=1.6543612251060553e-23 maxrel=1.1028679215589423e-15
1.4016183415910392e-8,
-1.8940708415503464e-9,
1.4503946123285937e-10,
-8.275191549194014e-12,
3.9135248144617046e-13,
-1.6214027025033307e-14,
6.086356098318178e-16,
-2.1164433549781532e-17,
// [27.,28. ]: m=8 maxabs=9.926167350636332e-24 maxrel=2.4263217202644325e-15
3.78814168310078e-9,
-5.801578449202556e-10,
4.965114928176091e-11,
-3.1308202907561964e-12,
1.6214044344348647e-13,
-7.299452434768773e-15,
2.9576900522630694e-16,
-1.1026240048687114e-17,
// [27.,28. ]: m=9 maxabs=5.997059441009451e-24 maxrel=4.742704141942198e-15
1.1603156898408002e-9,
-1.9860459712096498e-10,
1.8784921740839726e-11,
-1.297123789205589e-12,
7.299457303945226e-14,
-3.546919422585661e-15,
1.5421179202509449e-16,
-6.132522353771798e-18,
// [27.,28. ]: m=10 maxabs=3.877409121342317e-24 maxrel=8.876852506413435e-15
3.972091942419856e-10,
-7.513968695975245e-11,
7.782742733891352e-12,
-5.8395672691439e-13,
3.5469212429828764e-14,
-1.849179610641964e-15,
8.579649423051051e-17,
-3.620741153591062e-18
},
{
// [28.,29. ]: m=0 maxabs=5.551115123125783e-17 maxrel=3.3144716534934834e-16
0.1667384325793881,
-0.0014755613502511937,
0.000019587097569535778,
-2.888952389075247e-7,
4.4740301508229725e-9,
-7.130859107305156e-11,
1.1848859543860532e-12,
6.803172943843368e-14,
// [28.,29. ]: m=1 maxabs=8.673617379884035e-19 maxrel=2.900162696819223e-16
0.0029511227005101157,
-0.00007834839027426087,
1.7333714650671961e-6,
-3.5792331083706804e-8,
7.126790214164191e-10,
-1.3873955073407449e-11,
2.6628044100511933e-13,
-7.795302331487193e-15,
// [28.,29. ]: m=2 maxabs=5.421010862427522e-20 maxrel=3.3835231465498837e-16
0.00015669678054852645,
-6.93348586021334e-6,
2.1475398563051165e-7,
-5.701433058372259e-9,
1.3875164784742272e-10,
-3.192432364923573e-12,
7.068921886962249e-14,
-1.7052223850128232e-15,
// [28.,29. ]: m=3 maxabs=1.6940658945086007e-21 maxrel=1.1842331023145897e-16
0.00001386697172042734,
-8.590159425176168e-7,
3.420859828960849e-8,
-1.110013316994709e-9,
3.192513473715587e-11,
-8.475546095076721e-13,
2.1260607504049895e-14,
-5.38418431631484e-16,
// [28.,29. ]: m=4 maxabs=1.0587911840678754e-21 maxrel=5.921165552458574e-16
1.7180318850353488e-6,
-1.3683439315773163e-7,
6.6600798915766225e-9,
-2.5540109542704257e-10,
8.47567468205414e-12,
-2.550161396015643e-13,
7.149182912165927e-15,
-1.9360225738934145e-16,
// [28.,29. ]: m=5 maxabs=1.0587911840678754e-22 maxrel=3.6842809464893683e-16
2.7366878631547465e-7,
-2.66403195661605e-8,
1.5324065713050763e-9,
-6.780540197354205e-11,
2.5501781965857548e-12,
-8.57554327220779e-14,
2.6569595769321087e-15,
-7.794264249678134e-17,
// [28.,29. ]: m=6 maxabs=0. maxrel=0.
5.3280639132307565e-8,
-6.129626285187591e-9,
4.0683241164518636e-10,
-2.040142680975887e-11,
8.575571952934855e-13,
-3.187126981559584e-14,
1.0814974180515518e-15,
-3.429454643154024e-17,
// [28.,29. ]: m=7 maxabs=8.271806125530277e-24 maxrel=6.312236921767214e-16
1.2259252570375172e-8,
-1.6273296465627154e-9,
1.224085608187793e-10,
-6.860458243071636e-12,
3.187132424984174e-13,
-1.2971672181999337e-14,
4.7836310114013335e-16,
-1.634303014755451e-17,
// [28.,29. ]: m=8 maxabs=6.617444900424222e-24 maxrel=1.885261392225996e-15
3.25465929312572e-9,
-4.896342432664551e-10,
4.116274944829098e-11,
-2.549706273846948e-12,
1.2971684822216677e-13,
-5.737197391664583e-15,
2.28409593256183e-16,
-8.368858751020076e-18,
// [28.,29. ]: m=9 maxabs=4.1359030627651384e-24 maxrel=3.881465489585508e-15
9.792684865329361e-10,
-1.6465099778852959e-10,
1.529823764025229e-11,
-1.037734967677797e-12,
5.737201252897224e-14,
-2.7391877811030384e-15,
1.1703933104698208e-16,
-4.575737557440154e-18,
// [28.,29. ]: m=10 maxabs=2.946830932220161e-24 maxrel=8.151355919736837e-15
3.2930199557711304e-10,
-6.119295055837689e-11,
6.2264098049675195e-12,
-4.589762047168494e-13,
2.7391892206833467e-14,
-1.4034728990779149e-15,
6.401487593329031e-17,
-2.6572968183531505e-18
},
{
// [29.,29. ]: m=0 maxabs=8.326672684688674e-17 maxrel=5.015901304738643e-16
0.16528217383537228,
-0.0014372362942138715,
0.00001874656035941242,
-2.7168928336861933e-7,
4.134390954231621e-9,
-6.469108805746727e-11,
1.0601611170822581e-12,
-6.803172943843368e-14,
// [29.,29. ]: m=1 maxabs=0. maxrel=0.
0.002874472588435023,
-0.00007498624143459424,
1.6301356826577528e-6,
-3.3075216663901234e-8,
6.47123695650184e-10,
-1.2379493746033159e-11,
2.335047380204573e-13,
-4.9606469382191225e-15,
// [29.,29. ]: m=2 maxabs=1.0842021724855044e-19 maxrel=7.073204574619102e-16
0.00014997248286918857,
-6.520542730602625e-6,
1.9845129978775063e-7,
-5.1769903186758515e-9,
1.2379756761360847e-10,
-2.7988415708555645e-12,
6.088419015579876e-14,
-1.417327696634035e-15,
// [29.,29. ]: m=3 maxabs=5.082197683525802e-21 maxrel=3.7797436966303107e-16
0.00001304108546120585,
-7.938051991462957e-7,
3.106194186538063e-8,
-9.903806378613835e-10,
2.798900166248345e-11,
-7.301385601941856e-13,
1.7995840214562076e-14,
-4.4153079611939175e-16,
// [29.,29. ]: m=4 maxabs=2.117582368135751e-22 maxrel=1.2824130456422456e-16
1.5876103982926531e-6,
-1.2424776746104807e-7,
5.942283820738749e-9,
-2.2391202576766265e-10,
7.301463960898413e-12,
-2.1586675488286362e-13,
5.9460460954675535e-15,
-1.5778843497683592e-16,
// [29.,29. ]: m=5 maxabs=2.117582368135751e-22 maxrel=8.121949518266413e-16
2.484955349221031e-7,
-2.3769135282868555e-8,
1.3434721537954814e-9,
-5.841171447415986e-11,
2.1586788406716475e-12,
-7.132849884369137e-14,
2.1716671445496103e-15,
-6.26309358131739e-17,
// [29.,29. ]: m=6 maxabs=0. maxrel=0.
4.7538270565724185e-8,
-5.373888615143363e-9,
3.5047028661453657e-10,
-1.7269432027811884e-11,
7.132877706786373e-13,
-2.604894502698657e-14,
8.685784586657915e-16,
-2.7157733994265585e-17,
// [29.,29. ]: m=7 maxabs=4.963083675318166e-24 maxrel=4.3249947709758216e-16
1.0747777230287104e-8,
-1.4018811464444161e-9,
1.0361659210551028e-10,
-5.706302682521699e-12,
2.6049022346678606e-13,
-1.0418198835307813e-14,
3.777566862306828e-16,
-1.2371826560298273e-17,
// [29.,29. ]: m=8 maxabs=2.895132143935597e-24 maxrel=9.587095100403935e-16
2.8037622928899266e-9,
-4.144663683998954e-10,
3.423781605755604e-11,
-2.083922639945767e-12,
1.0418132233400732e-13,
-4.52813838498419e-15,
1.7717373417613208e-16,
-6.385622378180828e-18,
// [29.,29. ]: m=9 maxabs=3.5155176033503676e-24 maxrel=3.903349177932693e-15
8.28932736799821e-10,
-1.3695126422662806e-10,
1.2503535836107e-11,
-8.334507178114684e-13,
4.5281432734324886e-14,
-2.124778062966534e-15,
8.9240483539619e-17,
-3.430704936999569e-18,
// [29.,29. ]: m=10 maxabs=1.34416849539867e-24 maxrel=4.477480848427473e-15
2.7390252845326713e-10,
-5.001414334250713e-11,
5.00070430575243e-12,
-3.6225153767613845e-13,
2.1247795003028605e-14,
-1.0701626278688025e-15,
4.7987048665766886e-17,
-1.926424034249438e-18
},
{
// [29.,30. ]: m=0 maxabs=0. maxrel=0.
0.16386341648294103,
-0.001400542021216538,
0.00001795566693872545,
-2.557787410727007e-7,
3.82574658837411e-9,
-5.878224889019997e-11,
9.240976582053909e-13,
-1.8141794516915647e-13,
// [29.,30. ]: m=1 maxabs=8.673617379884035e-19 maxrel=3.05690760227456e-16
0.002801084042439454,
-0.00007182266775315808,
1.5346723874908046e-6,
-3.0606002115158474e-8,
5.885767397669341e-10,
-1.1066251052120685e-11,
2.0542393303089544e-13,
-5.66931078653614e-15,
// [29.,30. ]: m=2 maxabs=5.421010862427522e-20 maxrel=3.693763352858856e-16
0.00014364533550632728,
-6.138689549858875e-6,
1.8363601175230862e-7,
-4.708615627510186e-9,
1.106725768005093e-10,
-2.459300236312516e-12,
5.256846281070376e-14,
-1.2844532250745941e-15,
// [29.,30. ]: m=3 maxabs=6.776263578034403e-21 maxrel=5.3559568635018805e-16
0.000012277379099718676,
-7.345440470079414e-7,
2.825169369250487e-8,
-8.853806439245258e-10,
2.4593896627350255e-11,
-6.306071033280572e-13,
1.5276757929369142e-14,
-3.667889058672063e-16,
// [29.,30. ]: m=4 maxabs=8.470329472543003e-22 maxrel=5.547241053130965e-16
1.4690880940158883e-6,
-1.1300677476958941e-7,
5.3122838607769096e-9,
-1.9675118367468476e-10,
6.3061184471265326e-12,
-1.832528196467798e-13,
4.961771526845602e-15,
-1.2958721249742337e-16,
// [29.,30. ]: m=5 maxabs=5.293955920339377e-23 maxrel=2.234305465533556e-16
2.2601354953918433e-7,
-2.1249135442992184e-8,
1.1805071013244588e-9,
-5.044895090313181e-11,
1.8325384279264613e-12,
-5.951724997697471e-14,
1.7810564238349554e-15,
-5.0476727965451625e-17,
// [29.,30. ]: m=6 maxabs=3.1763735522036263e-22 maxrel=7.0685307080922405e-15
4.2498270885969716e-8,
-4.7220284052787035e-9,
3.0269370528892507e-10,
-1.4660308109045806e-11,
5.951741753324587e-13,
-2.1366533074479003e-14,
7.010945017926352e-16,
-1.64146686057317e-17,
// [29.,30. ]: m=7 maxabs=4.963083675318166e-24 maxrel=4.927583648833377e-16
9.444056810545515e-9,
-1.2107748210012528e-9,
8.796185004457201e-11,
-4.76139709523992e-12,
2.1364348137408308e-13,
-8.398989227590754e-15,
2.9942037013118247e-16,
-9.37923134512288e-18,
// [29.,30. ]: m=8 maxabs=4.963083675318166e-24 maxrel=1.9053355521288764e-15
2.421549642005411e-9,
-3.518474001128689e-10,
2.8568382700247044e-11,
-1.7091489294899055e-12,
8.398780402646758e-14,
-3.588337085245711e-15,
1.3802061344425402e-16,
-4.889662687848684e-18,
// [29.,30. ]: m=9 maxabs=2.3781442610899546e-24 maxrel=3.1148679250077782e-15
7.036948002257646e-10,
-1.1427353079837136e-10,
1.0254893574402414e-11,
-6.719025346716185e-13,
3.588340368587046e-14,
-1.6552737002787869e-15,
6.835225510659492e-17,
-2.5854049222342973e-18,
// [29.,30. ]: m=10 maxabs=1.4475660719677984e-24 maxrel=5.787910999761087e-15
2.2854706159675392e-10,
-4.101957429616938e-11,
4.031415206930036e-12,
-2.8706728657452e-13,
1.6552751409150868e-14,
-8.196813539511855e-16,
3.6150261280065253e-17,
-1.452537322993612e-18
},
{
// [30.,30. ]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.7010469703647858e-16
0.16248057811773134,
-0.0013653830093895002,
0.000017210710204324993,
-2.410463553478474e-7,
3.544773419801834e-9,
-5.365152262838476e-11,
8.957511042727101e-13,
4.535448629228912e-14,
// [30.,30. ]: m=1 maxabs=3.6038880213418167e-16 maxrel=1.3031348735955077e-13
0.002730766018778151,
-0.00006884284081240568,
1.4462782345011215e-6,
-2.83585039830552e-8,
5.357184279058325e-10,
-8.918667405541224e-12,
1.1857717841964496e-12,
-2.255322697268908e-12,
// [30.,30. ]: m=2 maxabs=2.710505431213761e-20 maxrel=1.9275209973818118e-16
0.00013768568161727718,
-5.785112671984917e-6,
1.701503724534008e-7,
-4.28950514946221e-9,
9.91272073940723e-11,
-2.165786065074026e-12,
4.55261158180534e-14,
-9.522670461759922e-16,
// [30.,30. ]: m=3 maxabs=1.6940658945086007e-21 maxrel=1.4215467358809993e-16
0.000011570225343970388,
-6.806014898120796e-7,
2.5737030875031668e-8,
-7.930177163498047e-10,
2.165804023889323e-11,
-5.459968613716955e-13,
1.3005434931149952e-14,
-3.0588810640246263e-16,
// [30.,30. ]: m=4 maxabs=1.0587911840678754e-21 maxrel=7.488505140365729e-16
1.3612029796241685e-6,
-1.0294812349969089e-7,
4.758106295905239e-9,
-1.7326433295630924e-10,
5.460004873590144e-12,
-1.5599858729768049e-13,
4.152889530545764e-15,
-1.0726845360267354e-16,
// [30.,30. ]: m=5 maxabs=7.940933880509066e-23 maxrel=3.681848405319442e-16
2.058962469993849e-7,
-1.903242518352096e-8,
1.0395859971003747e-9,
-4.3680041856455946e-11,
1.5599961382271942e-12,
-4.981434661612413e-14,
1.4656633808683041e-15,
-4.076633770988702e-17,
// [30.,30. ]: m=6 maxabs=1.9852334701272664e-23 maxrel=4.937024319099884e-16
3.8064850367018564e-8,
-4.158343988382253e-9,
2.620802510465582e-10,
-1.2479969888983034e-11,
4.981447605532887e-13,
-1.758101332956274e-14,
5.665372023005417e-16,
-1.7090503116837252e-17,
// [30.,30. ]: m=7 maxabs=1.6543612251060553e-24 maxrel=1.867208466637417e-16
8.316687976761842e-9,
-1.048321004177863e-9,
7.487981930308041e-11,
-3.985158397506647e-12,
1.7581053351637695e-13,
-6.795501647682985e-15,
2.380140464521318e-16,
-7.73425014509196e-18,
// [30.,30. ]: m=8 maxabs=1.6543612251060553e-24 maxrel=7.344361827964502e-16
2.0966420083557866e-9,
-2.9951927720827367e-10,
2.3910950377916892e-11,
-1.4064844224206025e-12,
6.795511326900375e-14,
-2.8547276993677337e-15,
1.0796946294931778e-16,
-3.763046557835725e-18,
// [30.,30. ]: m=9 maxabs=1.4475660719677984e-24 maxrel=2.2303188643938733e-15
5.990385544165697e-10,
-9.564380150972665e-11,
8.438906532094256e-12,
-5.436409832037641e-13,
2.8547308508421384e-14,
-1.294897106972993e-15,
5.258387437193638e-17,
-1.9562874717089146e-18,
// [30.,30. ]: m=10 maxabs=9.822769774067204e-25 maxrel=4.699659261116057e-15
1.912876030194602e-10,
-3.375562612732136e-11,
3.261845898474398e-12,
-2.2837851035471267e-13,
1.2948981269947088e-14,
-6.306005535201324e-16,
2.7355035431851462e-17,
-1.0814196970827747e-18
},
{
// [30.,30. ]: m=0 maxabs=5.551115123125783e-17 maxrel=3.4308041032380366e-16
0.16113216826417662,
-0.0013316708120984602,
0.000016508315852455744,
-2.2738726662175179e-7,
3.28865344672196e-9,
-4.894882933095303e-11,
7.540183346093066e-13,
4.535448629228912e-14,
// [30.,30. ]: m=1 maxabs=8.673617379884035e-19 maxrel=3.216378846792597e-16
0.0026633416241965565,
-0.00006603326340775727,
1.3643236240638404e-6,
-2.630927109154922e-8,
4.892218190932542e-10,
-8.893997045321688e-12,
1.596265318334082e-13,
-4.9606469382191225e-15,
// [30.,30. ]: m=2 maxabs=0. maxrel=0.
0.00013206652681859923,
-5.457294496033671e-6,
1.5785562576986893e-7,
-3.913775828548576e-9,
8.894942876260649e-11,
-1.9112484054929723e-12,
3.953569172524861e-14,
-9.301213009160854e-16,
// [30.,30. ]: m=3 maxabs=1.6940658945086007e-21 maxrel=1.5076775846587197e-16
0.000010914588992068184,
-6.314225030710368e-7,
2.348265492242322e-8,
-7.11595579590039e-10,
1.911310004834988e-11,
-4.738706777578842e-13,
1.1100900838797967e-14,
-2.6574894311888157e-16,
// [30.,30. ]: m=4 maxabs=1.8592373192231892e-19 maxrel=1.4182938438270523e-13
1.262845006139196e-6,
-9.393061963688189e-8,
4.2695739826354625e-9,
-1.529057081643352e-10,
4.72841082537949e-12,
-1.38317404818137e-13,
5.013134949689624e-14,
5.784953100065216e-14,
// [30.,30. ]: m=5 maxabs=2.6469779601696886e-23 maxrel=1.3461407128665626e-16
1.878612393785479e-7,
-1.7078293886667594e-8,
9.174288598720733e-10,
-3.79102583904106e-11,
1.3315554538801623e-12,
-4.1816958952464205e-14,
1.2099924819790287e-15,
-3.326187129857095e-17,
// [30.,30. ]: m=6 maxabs=7.345363839470886e-22 maxrel=2.0375676217181078e-14
3.4156587773323594e-8,
-3.66971543949226e-9,
2.2746155025800543e-10,
-1.0652444358260352e-11,
4.181707054963785e-13,
-1.4511640272670457e-14,
4.612083937447411e-16,
-2.1567230918400443e-17,
// [30.,30. ]: m=7 maxabs=3.308722450212111e-24 maxrel=4.2361081674955287e-16
7.3394308789447954e-9,
-9.098462008837225e-10,
6.39146651925303e-11,
-3.345370604200343e-12,
1.451472254056534e-13,
-5.517672192172423e-15,
1.9006967039979272e-16,
-6.0757522548389316e-18,
// [30.,30. ]: m=8 maxabs=8.271806125530277e-25 maxrel=4.236111550856797e-16
1.81969240176748e-9,
-2.55658660766938e-10,
2.007222362003034e-11,
-1.161177924319924e-12,
5.517679813262527e-14,
-2.279715532297928e-15,
8.480413685009437e-17,
-2.910481322076069e-18,
// [30.,30. ]: m=9 maxabs=1.137373342260413e-24 maxrel=2.0557658123794138e-15
5.113173215338987e-10,
-8.028889447853842e-11,
6.967067543292187e-12,
-4.4141444595837753e-13,
2.279719205432096e-14,
-1.0170806740220955e-15,
4.062639772643123e-17,
-1.4873428003155481e-18,
// [30.,30. ]: m=10 maxabs=6.979336418416171e-25 maxrel=3.983696486442133e-15
1.6057778895708219e-10,
-2.786827017237708e-11,
2.6484866750924983e-12,
-1.8237756815539506e-13,
1.017081601479563e-14,
-4.872126287073274e-16,
2.0792328571889627e-17,
-8.091217485926526e-19
}
};
