/*
 * Library LZNT1 decompression testing program
 *
 * Copyright (C) 2009-2016, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <memory.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include <stdio.h>

#include "fwnt_test_libcerror.h"
#include "fwnt_test_libcnotify.h"
#include "fwnt_test_libcstring.h"
#include "fwnt_test_libfwnt.h"
#include "fwnt_test_macros.h"
#include "fwnt_test_unused.h"

/* Define to make fwnt_test_lzxpress generate verbose output
#define FWNT_TEST_LZXPRESS
 */

uint8_t fwnt_test_lzxpress_compressed_byte_stream[ 3575 ] = {
	0x01, 0x00, 0x00, 0x00, 0x09, 0x09, 0x20, 0x20, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x45, 0x53,
	0x53, 0x45, 0x52, 0x20, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x4c, 0x20, 0x50, 0x55, 0x42, 0x4c,
	0x49, 0x43, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x06, 0x45, 0x4e, 0x53, 0x45, 0x0a, 0x20, 0x01,
	0x07, 0x00, 0x2a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x33, 0x2c, 0x20, 0x32, 0x39,
	0x20, 0x4a, 0x75, 0x6e, 0x65, 0x20, 0x32, 0x30, 0x30, 0x37, 0x0a, 0x0a, 0x00, 0x00, 0x02, 0x00,
	0x20, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x43, 0x29, 0xa2, 0x00,
	0x20, 0x46, 0x72, 0x65, 0x65, 0x20, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x46,
	0x6f, 0x00, 0x00, 0x00, 0x04, 0x75, 0x6e, 0x64, 0x61, 0x74, 0xe8, 0x01, 0x2c, 0x20, 0x49, 0x6e,
	0x63, 0x2e, 0x20, 0x3c, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x66, 0x73, 0x66, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x3e, 0x0a, 0x20, 0x80, 0x00, 0x00, 0x02, 0x45, 0x76, 0x65, 0x72, 0x79, 0x6f,
	0xa0, 0x02, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x63, 0xe8, 0x02, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x69, 0x80, 0x00, 0x54, 0x00,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x58, 0x01, 0x62, 0x78, 0x02, 0x6d, 0xe1,
	0x00, 0x69, 0x65, 0x73, 0x0a, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0xc8, 0x01, 0x6c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x80, 0x00, 0x10, 0x00, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2c, 0x20, 0x78, 0x01, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20, 0x69,
	0x74, 0xf1, 0x02, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x6c, 0x6c, 0x00, 0x00, 0x7a, 0x02, 0x6f, 0x77,
	0x65, 0x64, 0x2e, 0x0a, 0xf8, 0x05, 0x20, 0x54, 0xd1, 0x01, 0x98, 0x02, 0xfa, 0x06, 0x52, 0x02,
	0x65, 0x3b, 0x09, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c,
	0x20, 0x50, 0x75, 0x62, 0x5b, 0x50, 0x03, 0x90, 0xf8, 0x02, 0x20, 0x4c, 0x1c, 0x03, 0x69, 0x6e,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x08, 0x04, 0x91, 0x01, 0x74, 0xb0, 0x05, 0x73,
	0x52, 0x05, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x79, 0x07, 0x73, 0x71, 0x02, 0xcd, 0x02, 0x33, 0xdf,
	0x02, 0xa7, 0x02, 0x04, 0xb0, 0x76, 0x32, 0x40, 0x0a, 0xa4, 0x02, 0x2c, 0x20, 0x73, 0x75, 0x70,
	0x70, 0x6c, 0x65, 0xd9, 0x05, 0xf0, 0x07, 0x62, 0x79, 0x7a, 0x01, 0x61, 0x64, 0x6b, 0x02, 0x70,
	0x01, 0xd2, 0x08, 0x73, 0x71, 0x02, 0x61, 0x07, 0x73, 0x22, 0x01, 0x65, 0x50, 0x06, 0x40, 0x06,
	0x20, 0x20, 0x30, 0x2e, 0x60, 0x41, 0x90, 0x20, 0x20, 0x41, 0x57, 0x01, 0x44, 0x65, 0x66, 0x69,
	0x6e, 0x2b, 0x04, 0x2e, 0x20, 0xf1, 0x00, 0x41, 0x73, 0x20, 0x75, 0x73, 0x80, 0x01, 0x68, 0x65,
	0x72, 0x65, 0x69, 0x50, 0x0c, 0x22, 0x92, 0x09, 0xcc, 0x03, 0x22, 0x20, 0x72, 0x65, 0x66, 0x2e,
	0x20, 0xa7, 0xf5, 0x40, 0x05, 0x91, 0x0b, 0x87, 0x05, 0xcb, 0x63, 0x08, 0x0a, 0x67, 0x08, 0x2c,
	0xb2, 0x07, 0x51, 0x01, 0x22, 0xe2, 0x06, 0x50, 0x4c, 0x7f, 0x02, 0xdf, 0x07, 0x47, 0x02, 0x3a,
	0x06, 0x22, 0x54, 0x18, 0x01, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x3f, 0x02, 0x02, 0x61,
	0xc0, 0x0a, 0x58, 0x02, 0x10, 0x06, 0x77, 0x10, 0x49, 0x8a, 0x05, 0x6f, 0x72, 0x6b, 0x20, 0x67,
	0x61, 0x00, 0x6e, 0x35, 0x09, 0x57, 0x06, 0x2c, 0x0a, 0x6f, 0x20, 0x03, 0x72, 0x98, 0x00, 0x61,
	0x6e, 0xb8, 0x04, 0x20, 0x41, 0x88, 0x0a, 0x69, 0x63, 0xfa, 0x13, 0x20, 0x6f, 0x72, 0x28, 0x02,
	0x43, 0x6f, 0x6d, 0x62, 0x0e, 0x8c, 0xc2, 0x50, 0x69, 0xc1, 0x01, 0x57, 0x31, 0x02, 0x61, 0x73,
	0x20, 0x64, 0x51, 0x09, 0x57, 0x0a, 0x13, 0x41, 0x6e, 0x20, 0x22, 0xbf, 0x01, 0x22, 0xb9, 0x11,
	0x61, 0x6e, 0x79, 0xc3, 0x03, 0xc0, 0x02, 0x74, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x82, 0x0a, 0xa1,
	0x06, 0x28, 0x03, 0x69, 0xc9, 0xe0, 0x00, 0x80, 0x88, 0x0d, 0x72, 0x66, 0x61, 0x63, 0x65, 0x20,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x0a, 0xf4, 0x0d, 0x4c, 0x06, 0x5b, 0x14, 0x77,
	0x68, 0x69, 0x63, 0x68, 0x2d, 0x14, 0x3a, 0x05, 0x77, 0x69, 0x18, 0x02, 0x62, 0x61, 0xc9, 0x0c,
	0x04, 0xe5, 0x07, 0xcd, 0x00, 0x05, 0x87, 0x01, 0x31, 0x2e, 0x0a, 0x13, 0x0e, 0xc0, 0x15, 0x61,
	0xb8, 0x10, 0x62, 0x63, 0x6c, 0x61, 0x73, 0x82, 0x12, 0x38, 0x08, 0x52, 0x00, 0xb6, 0x05, 0x3f,
	0x03, 0xe1, 0x02, 0x64, 0x65, 0x10, 0x12, 0x64, 0x40, 0x01, 0x6d, 0x6f, 0x64, 0x65, 0x0a, 0x90,
	0x01, 0x75, 0x73, 0x87, 0xc2, 0xc5, 0xf3, 0x32, 0x02, 0x37, 0x05, 0x5a, 0xf7, 0x01, 0xf3, 0x07,
	0x20, 0x22, 0x27, 0x09, 0x23, 0xfb, 0x07, 0xeb, 0x07, 0xb8, 0x01, 0x64, 0x75, 0x63, 0xbb, 0x01,
	0x63, 0x22, 0x01, 0xd1, 0x02, 0xc0, 0x0a, 0x6c, 0x69, 0x6e, 0x6b, 0x2b, 0x03, 0x0a, 0x97, 0x0b,
	0x77, 0x69, 0x74, 0x68, 0x07, 0x03, 0x63, 0x81, 0x1b, 0xf0, 0x03, 0x7b, 0x44, 0x6f, 0x00, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0xd7, 0x1b, 0x3c, 0x01, 0x0a, 0xc2, 0x01, 0x7b,
	0x09, 0xb1, 0x00, 0xaf, 0x0d, 0x94, 0x77, 0xb0, 0x0d, 0x6d, 0x61, 0x64, 0x7a, 0x21, 0x61, 0x6c,
	0x73, 0x38, 0x21, 0x90, 0x1e, 0x89, 0x21, 0x19, 0x14, 0x4c, 0x48, 0x04, 0xf8, 0x0b, 0x46, 0xc1,
	0x80, 0xb2, 0x94, 0x25, 0x22, 0x92, 0x06, 0x99, 0x03, 0x22, 0x4d, 0x60, 0x05, 0x6d, 0xa0, 0x13,
	0x43, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x31, 0x1d, 0x80, 0x05, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x08, 0x18, 0x66, 0xef, 0x10, 0x6d, 0x65, 0x61, 0x50, 0x1b, 0xa8, 0x02, 0x0a, 0xd1, 0xfa, 0x35,
	0xe0, 0x9f, 0x01, 0x7a, 0x92, 0x01, 0xe7, 0x04, 0x2c, 0x20, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x3a,
	0x01, 0xa1, 0x11, 0x73, 0x5b, 0x01, 0x63, 0x59, 0x0c, 0x81, 0x01, 0xa0, 0x21, 0xe6, 0x20, 0xcf,
	0x06, 0x38, 0xe9, 0x12, 0x2c, 0x11, 0x22, 0x73, 0xe8, 0x0c, 0x61, 0x17, 0x69, 0xa8, 0x0d, 0x73,
	0x6f, 0x6c, 0x04, 0x2a, 0xfe, 0x0e, 0xf6, 0xbf, 0x80, 0x2a, 0x0a, 0x6f, 0x11, 0x5f, 0x0b, 0x01,
	0x33, 0x1c, 0xca, 0x12, 0x4d, 0x12, 0x41, 0x08, 0xdd, 0x2d, 0x3f, 0x08, 0x5f, 0x06, 0x24, 0x6f,
	0x0d, 0x43, 0x20, 0x05, 0x4f, 0x08, 0x1f, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0xb0, 0x2a, 0x50,
	0x01, 0x81, 0x03, 0x2f, 0x60, 0x01, 0x17, 0x07, 0x9e, 0x08, 0xc7, 0x04, 0x13, 0x68, 0x29, 0x8f,
	0x08, 0x68, 0x30, 0x61, 0x0f, 0x67, 0x44, 0x40, 0x0a, 0x59, 0x05, 0x75, 0x74, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0xa1, 0x12, 0x67, 0x72, 0x61, 0xf0, 0x29, 0x6e, 0x65, 0x65, 0x99, 0x14, 0x19, 0x02,
	0x72, 0x65, 0x53, 0x13, 0xa1, 0x01, 0x37, 0x09, 0x38, 0x66, 0x72, 0x6f, 0x6d, 0x6a, 0x04, 0x37,
	0x03, 0x11, 0x1b, 0xe7, 0x0b, 0xb0, 0x46, 0x6e, 0x80, 0x97, 0xa9, 0x01, 0x53, 0x79, 0x28, 0x29,
	0x6d, 0xa4, 0x12, 0x60, 0x31, 0xa7, 0x0b, 0xca, 0x08, 0x31, 0x2e, 0x20, 0x45, 0x78, 0x63, 0x65,
	0x70, 0x3a, 0x08, 0x70, 0x23, 0x53, 0x20, 0x07, 0x51, 0x00, 0xbf, 0x2d, 0x44, 0x50, 0x4c, 0x62,
	0x01, 0x59, 0x6f, 0x75, 0xf8, 0x13, 0x09, 0x18, 0x6e, 0xce, 0xa3, 0x6e, 0x3d, 0x76, 0x65, 0x00,
	0x35, 0xd7, 0x24, 0x78, 0x37, 0x00, 0x24, 0x73, 0x03, 0x02, 0x73, 0x08, 0x02, 0x59, 0x07, 0x34,
	0x3b, 0x02, 0x47, 0x25, 0xc0, 0x0a, 0x17, 0x6f, 0x88, 0x05, 0x62, 0x78, 0x2c, 0x67, 0x20, 0x62,
	0x31, 0x39, 0xa9, 0x1a, 0xbc, 0x01, 0xc7, 0x03, 0x32, 0x2e, 0xd0, 0x05, 0x99, 0x03, 0x91, 0x01,
	0x4d, 0xae, 0xbd, 0x0f, 0x05, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x0f, 0x0f, 0x20, 0x73, 0x12, 0x01,
	0x49, 0x66, 0x20, 0x79, 0xf1, 0x04, 0xe1, 0x00, 0xd3, 0x04, 0x10, 0x3a, 0x54, 0x02, 0x4c, 0xe3,
	0x1a, 0x4a, 0x11, 0xa9, 0x0c, 0x49, 0x01, 0x72, 0x53, 0x01, 0x24, 0x0a, 0x73, 0xd8, 0x00, 0x0a,
	0x08, 0x21, 0xc3, 0x0c, 0xef, 0x2b, 0x66, 0xe7, 0x5d, 0xff, 0x3c, 0x75, 0x6e, 0xc3, 0x04, 0xe0,
	0x0c, 0x09, 0x0e, 0xa9, 0x00, 0x62, 0x65, 0x93, 0x35, 0x21, 0x04, 0xd0, 0x05, 0x77, 0x2b, 0x24,
	0xb0, 0x38, 0x48, 0x29, 0x18, 0x29, 0xba, 0x11, 0x20, 0xa6, 0x02, 0x28, 0x07, 0x2d, 0xc1, 0x2a,
	0xa8, 0x16, 0x67, 0x82, 0x3d, 0xb0, 0x20, 0x30, 0x33, 0x28, 0x0a, 0x68, 0x65, 0x0a, 0x16, 0x47,
	0x04, 0x60, 0xb0, 0x09, 0x6a, 0x1f, 0xfd, 0x09, 0x69, 0x6e, 0x76, 0x6f, 0x70, 0x16, 0x29, 0x2c,
	0xc9, 0x00, 0xca, 0x05, 0x17, 0x0c, 0x3f, 0x07, 0x30, 0x8b, 0x06, 0x20, 0x20, 0xe4, 0x22, 0x3a,
	0xc1, 0x08, 0x20, 0x61, 0x29, 0xd4, 0x0c, 0x7f, 0x31, 0x57, 0x28, 0x50, 0x7a, 0x05, 0xbb, 0x02,
	0x6b, 0xd8, 0x16, 0x10, 0x33, 0x6f, 0x58, 0x14, 0x61, 0x41, 0x24, 0x65, 0xa3, 0x7f, 0xe6, 0x5d,
	0x66, 0x98, 0x14, 0x74, 0x90, 0x07, 0x39, 0x02, 0xb0, 0x01, 0x75, 0xc0, 0x46, 0x53, 0x1d, 0x20,
	0x0a, 0x89, 0x03, 0x65, 0x76, 0xf9, 0x05, 0x7f, 0x33, 0x64, 0x6f, 0xd8, 0x07, 0x81, 0x1c, 0x22,
	0x09, 0x42, 0x2b, 0xf9, 0x01, 0x4f, 0x0a, 0x06, 0x8a, 0x06, 0xff, 0x08, 0x73, 0xa8, 0x18, 0x6c,
	0x20, 0x6f, 0x60, 0x3f, 0xe1, 0x42, 0x86, 0x83, 0xe5, 0xeb, 0xab, 0x1e, 0x60, 0x00, 0x00, 0x04,
	0x6d, 0x60, 0x47, 0x20, 0xe8, 0x08, 0xb8, 0x00, 0xc0, 0x06, 0x22, 0x2a, 0x89, 0x07, 0x69, 0x74,
	0xa8, 0x49, 0x75, 0x68, 0x44, 0x50, 0x32, 0x72, 0x65, 0x6d, 0x61, 0x69, 0xa0, 0x13, 0x79, 0x1d,
	0x18, 0x11, 0x66, 0x75, 0x6c, 0x2c, 0x30, 0x03, 0xf2, 0x07, 0x62, 0x3f, 0x5c, 0x32, 0xd7, 0xf7,
	0x07, 0xd0, 0xa6, 0x12, 0x2c, 0x03, 0x2d, 0x6e, 0xd9, 0x4b, 0xdc, 0x09, 0x7f, 0x43, 0x6f, 0x66,
	0x19, 0x02, 0xcf, 0x09, 0x22, 0x20, 0x61, 0x53, 0x07, 0x62, 0x6c, 0x58, 0x08, 0x6f, 0xeb, 0x09,
	0x21, 0x0c, 0x2a, 0x14, 0x33, 0x2e, 0x20, 0x4f, 0x43, 0x21, 0x99, 0x22, 0xc1, 0x4f, 0x74, 0x49,
	0xc2, 0x15, 0x00, 0x06, 0xcd, 0xff, 0x40, 0x34, 0x72, 0x69, 0x00, 0x03, 0x32, 0x1e, 0x4c, 0xa3,
	0x14, 0x20, 0x48, 0x65, 0x88, 0x2e, 0x72, 0x20, 0x46, 0x69, 0x6c, 0x65, 0x4b, 0x16, 0x61, 0x25,
	0x6f, 0x23, 0x09, 0x08, 0x29, 0x05, 0x2f, 0x0b, 0x15, 0x29, 0x10, 0x77, 0x4c, 0x78, 0x00, 0xef,
	0x02, 0x51, 0x0a, 0x61, 0x88, 0x47, 0xba, 0x02, 0x66, 0xb8, 0x02, 0x99, 0x8f, 0x6f, 0xfe, 0x23,
	0x05, 0x21, 0x53, 0xd4, 0x09, 0x81, 0x07, 0xfc, 0x03, 0xc8, 0x34, 0xb7, 0x1e, 0x73, 0x75, 0xe0,
	0x33, 0x03, 0x04, 0x0a, 0x02, 0x04, 0xf4, 0x09, 0x4a, 0x4f, 0xe0, 0x01, 0xe2, 0x19, 0x63, 0x68,
	0x6f, 0x70, 0x08, 0x2f, 0x12, 0x15, 0xb0, 0x10, 0xdb, 0x02, 0xbf, 0x04, 0x64, 0x0a, 0xc6, 0x04,
	0x04, 0x40, 0x6c, 0x69, 0x40, 0x57, 0x8b, 0x23, 0x5e, 0x8b, 0x89, 0x01, 0x6f, 0x20, 0x6e, 0xf8,
	0x17, 0x72, 0x80, 0x06, 0x98, 0x0b, 0x61, 0x48, 0x28, 0x65, 0x40, 0x01, 0xc8, 0x0f, 0x32, 0x1b,
	0xb8, 0x57, 0x75, 0x63, 0x74, 0x80, 0x13, 0x0a, 0x6c, 0x61, 0x88, 0x03, 0x58, 0x0f, 0x81, 0x10,
	0x61, 0x63, 0x63, 0x90, 0x4c, 0x6f, 0x29, 0x01, 0x01, 0x2c, 0xe0, 0x98, 0x7d, 0xa2, 0xb0, 0x36,
	0x6c, 0xd0, 0x05, 0x63, 0x72, 0x6f, 0x80, 0x00, 0x69, 0x6e, 0x60, 0x3c, 0x70, 0x09, 0x34, 0x13,
	0x83, 0x01, 0x30, 0x28, 0x70, 0x28, 0x32, 0x68, 0x55, 0x28, 0x74, 0xf0, 0x19, 0xa0, 0x01, 0x66,
	0x65, 0x77, 0x68, 0x06, 0x51, 0x01, 0xe1, 0x1a, 0x20, 0x6c, 0x65, 0x6e, 0x67, 0x7d, 0xbe, 0x38,
	0x37, 0x74, 0x68, 0xf0, 0x1a, 0x09, 0x18, 0x64, 0xd8, 0x1e, 0x30, 0x1d, 0x15, 0x09, 0x66, 0x6f,
	0x89, 0x59, 0xd0, 0x0d, 0x46, 0x1a, 0x47, 0x69, 0x76, 0x22, 0x42, 0x6d, 0xf0, 0x01, 0xc0, 0x17,
	0x70, 0x06, 0x28, 0x08, 0x63, 0x12, 0x65, 0x61, 0xb0, 0x09, 0x6f, 0x1c, 0x22, 0x1f, 0x0e, 0x02,
	0x0c, 0x3c, 0x18, 0x4c, 0xc4, 0x0f, 0xfb, 0x5f, 0xfe, 0xff, 0x70, 0x08, 0xd2, 0x54, 0x51, 0x37,
	0x19, 0x1a, 0x4c, 0x1c, 0xdf, 0x0c, 0x51, 0xa2, 0x00, 0x31, 0x17, 0x89, 0x4b, 0x19, 0x38, 0xe8,
	0x01, 0x95, 0x2b, 0xff, 0x4f, 0xca, 0x11, 0x59, 0x17, 0x41, 0x63, 0xf8, 0x44, 0x70, 0x79, 0x33,
	0x1f, 0x04, 0x46, 0x2a, 0x05, 0x87, 0x21, 0x74, 0x18, 0xe4, 0x03, 0x5f, 0x62, 0x10, 0x59, 0x02,
	0x75, 0x62, 0xca, 0x02, 0x34, 0x01, 0x2c, 0xdf, 0x31, 0xd6, 0x3f, 0x99, 0xf9, 0x4b, 0x15, 0x7f,
	0x30, 0x47, 0x6f, 0x35, 0xbf, 0x11, 0x2f, 0x01, 0x6b, 0x11, 0x0a, 0x74, 0x80, 0x23, 0xa9, 0x33,
	0x67, 0x65, 0xd1, 0x28, 0x08, 0x42, 0x66, 0x66, 0x29, 0x30, 0x76, 0x65, 0xa0, 0x21, 0x50, 0x0c,
	0x61, 0x11, 0x88, 0x3d, 0x00, 0x68, 0x10, 0x06, 0x6f, 0x2d, 0xf4, 0x05, 0x0a, 0x9f, 0x42, 0x46,
	0x4c, 0xb4, 0x09, 0x78, 0x04, 0x74, 0xff, 0x3f, 0xf8, 0xfb, 0x70, 0x20, 0xdb, 0x0a, 0xc1, 0x00,
	0xbf, 0x04, 0x69, 0x07, 0x72, 0x51, 0x22, 0x40, 0x07, 0xe8, 0x0f, 0xc0, 0x00, 0x20, 0x14, 0xf8,
	0x1c, 0xf9, 0x3b, 0x64, 0x65, 0x62, 0x75, 0x67, 0xba, 0x69, 0x32, 0x18, 0x1f, 0x31, 0xf5, 0xf0,
	0x16, 0x31, 0x11, 0xda, 0x4b, 0x00, 0x05, 0x92, 0x0f, 0x08, 0x21, 0x11, 0x03, 0x5f, 0x11, 0x25,
	0x07, 0x05, 0x24, 0xe9, 0x08, 0x21, 0x02, 0x7e, 0xd8, 0xf3, 0xf1, 0x9f, 0x06, 0x6f, 0x11, 0x4f,
	0x4b, 0x2f, 0x04, 0x7f, 0x11, 0x8f, 0x23, 0x20, 0x63, 0x29, 0x08, 0x78, 0x7f, 0x4a, 0x9a, 0x05,
	0xa0, 0x76, 0x98, 0x1c, 0x79, 0x73, 0xd2, 0x02, 0x23, 0x7a, 0xe3, 0x08, 0x18, 0x5e, 0x75, 0x49,
	0x0c, 0x01, 0x02, 0x65, 0x78, 0x65, 0x63, 0x40, 0x49, 0x37, 0x4a, 0x40, 0xa1, 0x11, 0x61, 0x4b,
	0x97, 0x01, 0xc6, 0x4b, 0x4c, 0xfc, 0x47, 0x0e, 0x9f, 0x25, 0x08, 0x6d, 0x6f, 0x03, 0x02, 0xa0,
	0x00, 0x38, 0x08, 0xc4, 0x02, 0x70, 0x32, 0x73, 0x20, 0x77, 0x65, 0x68, 0x21, 0xd1, 0x3b, 0x03,
	0x3f, 0x65, 0x6e, 0xf0, 0x01, 0x64, 0x69, 0x72, 0x91, 0x13, 0xbc, 0x49, 0xc8, 0x09, 0x68, 0x02,
	0xa1, 0x2e, 0xec, 0x09, 0x49, 0x7b, 0xe7, 0x07, 0x5f, 0x07, 0xcf, 0x07, 0x64, 0x29, 0x0f, 0xff,
	0x7f, 0x1e, 0x20, 0x44, 0x6f, 0x58, 0x54, 0xce, 0x32, 0xcf, 0x10, 0xf5, 0x01, 0x00, 0x30, 0x29,
	0x7c, 0x46, 0x02, 0x01, 0x07, 0x5d, 0x03, 0xdf, 0x35, 0xf1, 0x46, 0x1a, 0xe1, 0x03, 0x4d, 0x02,
	0x76, 0x3e, 0xab, 0x04, 0x19, 0x0e, 0x2f, 0x57, 0x03, 0xf1, 0x11, 0x98, 0x46, 0x88, 0x32, 0x05,
	0x02, 0x73, 0x75, 0x69, 0x74, 0x5a, 0x36, 0xa0, 0x00, 0x2b, 0x02, 0xb7, 0x1d, 0x22, 0x88, 0xff,
	0x3f, 0xff, 0x7a, 0x0d, 0xd3, 0x84, 0x73, 0x3d, 0x0c, 0x09, 0xed, 0x01, 0xe0, 0x09, 0xfb, 0x0e,
	0xc9, 0x2a, 0x72, 0x65, 0x69, 0x68, 0x32, 0x01, 0xbf, 0x03, 0x3c, 0x12, 0xe5, 0x44, 0xcf, 0x67,
	0x41, 0x2d, 0x02, 0x89, 0x01, 0xaf, 0x5d, 0x21, 0x0c, 0x9c, 0x6b, 0xd7, 0x01, 0x32, 0x67, 0x12,
	0x25, 0x44, 0x2d, 0x02, 0x6d, 0x61, 0x6e, 0xe8, 0x7a, 0x20, 0x73, 0x70, 0x91, 0x65, 0xf8, 0x37,
	0x65, 0x63, 0x6b, 0x01, 0xaf, 0x52, 0x61, 0x36, 0x27, 0x0e, 0xb1, 0x11, 0xb3, 0x25, 0x7c, 0x13,
	0x01, 0x00, 0x07, 0x0c, 0x0a, 0xa3, 0x0e, 0x01, 0x00, 0x31, 0x29, 0x20, 0x55, 0xc9, 0x1a, 0x97,
	0x09, 0x73, 0x68, 0x30, 0x1b, 0x64, 0x38, 0x10, 0xd3, 0x13, 0x6d, 0x65, 0xa1, 0x8b, 0x69, 0x73,
	0x6d, 0xea, 0x02, 0x7e, 0x4e, 0xee, 0xfb, 0xcd, 0x70, 0xf2, 0x07, 0x37, 0x05, 0x01, 0x44, 0x15,
	0xb8, 0x3b, 0x41, 0x4f, 0x02, 0xd7, 0x01, 0x40, 0xb8, 0x12, 0xd9, 0x11, 0xc2, 0x0b, 0x28, 0xd1,
	0x4d, 0x41, 0x52, 0x58, 0x00, 0x72, 0x75, 0x60, 0x07, 0x69, 0x6d, 0x36, 0x02, 0xc7, 0x1c, 0xee,
	0x17, 0x6c, 0x72, 0xb0, 0x3f, 0xd1, 0x62, 0xe0, 0x17, 0xa0, 0x23, 0x94, 0x68, 0xa9, 0x0d, 0x27,
	0x3f, 0xfd, 0xaf, 0x95, 0x79, 0x1b, 0x6d, 0x70, 0x50, 0x92, 0x72, 0x1d, 0x02, 0x73, 0x32, 0x61,
	0xab, 0x0f, 0x28, 0x68, 0x20, 0x77, 0x0f, 0x4c, 0xd1, 0xf1, 0x0b, 0x48, 0x00, 0x48, 0x2c, 0xff,
	0x0d, 0x25, 0x02, 0x0f, 0x04, 0x05, 0xc2, 0x05, 0xba, 0x55, 0x9c, 0x7b, 0x2d, 0x0a, 0x23, 0x74,
	0x69, 0x31, 0x07, 0x5d, 0x08, 0x6c, 0x0f, 0x15, 0x02, 0x55, 0x6d, 0x8a, 0x8d, 0xf8, 0x30, 0x67,
	0x06, 0x20, 0x65, 0x29, 0x20, 0x50, 0xab, 0x42, 0xf8, 0x49, 0x73, 0x74, 0x10, 0x3f, 0x3b, 0x12,
	0x49, 0x6e, 0xb9, 0x15, 0x5a, 0x00, 0x9b, 0x67, 0x6f, 0x6e, 0xe8, 0x04, 0x94, 0x2c, 0x77, 0x6f,
	0x75, 0x6c, 0xe8, 0x70, 0xd8, 0x02, 0xda, 0x82, 0x39, 0x02, 0x28, 0x5d, 0x72, 0x65, 0x71, 0x7f,
	0xf3, 0xff, 0x7b, 0x75, 0x00, 0x1f, 0x5a, 0x43, 0x4c, 0x45, 0xbb, 0x2e, 0x69, 0x5f, 0x02, 0x7c,
	0x17, 0x4f, 0x11, 0x76, 0x09, 0x02, 0x64, 0x11, 0x03, 0x09, 0x6a, 0x03, 0xdb, 0x20, 0xe0, 0x24,
	0x60, 0x42, 0xe1, 0x2b, 0x58, 0x07, 0x7f, 0x02, 0xe3, 0x1c, 0x6e, 0x65, 0x49, 0x45, 0x8a, 0x08,
	0x6f, 0xf0, 0x00, 0x3a, 0x06, 0x3a, 0x02, 0xc3, 0x26, 0xb7, 0x16, 0x43, 0x5f, 0x80, 0xe9, 0x01,
	0x7f, 0x18, 0xcf, 0xff, 0xaf, 0x29, 0x24, 0xef, 0x83, 0x8d, 0x1b, 0xd1, 0x12, 0x9e, 0x1b, 0xfc,
	0x25, 0xc9, 0x01, 0xcf, 0x1b, 0x1f, 0x0d, 0x27, 0x0c, 0xef, 0x0b, 0xe0, 0x28, 0x49, 0x8a, 0x1c,
	0x71, 0x0a, 0x12, 0x8f, 0xa3, 0x70, 0x34, 0x64, 0x30, 0xd3, 0x1f, 0x67, 0x0c, 0x20, 0x6d, 0x75,
	0x73, 0x88, 0x34, 0x4d, 0x32, 0x11, 0x02, 0x71, 0x01, 0xaf, 0x26, 0xff, 0x04, 0x41, 0x08, 0x4f,
	0x25, 0x00, 0xff, 0xd7, 0xff, 0x8d, 0x03, 0x08, 0x64, 0x65, 0x2e, 0xa5, 0x6e, 0x6f, 0x04, 0x63,
	0x31, 0x53, 0x4d, 0xa2, 0x03, 0x9d, 0x0e, 0xf7, 0x04, 0x09, 0x02, 0x0f, 0x05, 0xf2, 0x34, 0x40,
	0x0f, 0x21, 0x13, 0x11, 0x02, 0x27, 0x21, 0xc3, 0xef, 0x20, 0x29, 0x91, 0x15, 0x35, 0xef, 0x48,
	0x31, 0x3b, 0x18, 0xb0, 0x31, 0x0f, 0x49, 0x78, 0x37, 0xa8, 0x07, 0x45, 0x21, 0x9c, 0x67, 0xd9,
	0x32, 0x12, 0x12, 0x79, 0xb1, 0xfb, 0xff, 0xff, 0xff, 0x44, 0x93, 0x2f, 0x87, 0x32, 0x00, 0xa9,
	0x7b, 0x01, 0xa1, 0x88, 0x5a, 0x05, 0x39, 0x00, 0x0a, 0x2e, 0xc9, 0x96, 0x78, 0x1a, 0x85, 0x02,
	0x15, 0x4a, 0x8b, 0x0f, 0x43, 0x73, 0xdc, 0x00, 0x65, 0x72, 0x67, 0x03, 0xc9, 0x4a, 0x87, 0x0b,
	0x51, 0xdc, 0x5a, 0xc4, 0x00, 0x9f, 0x41, 0x37, 0xad, 0x20, 0x21, 0x01, 0x1f, 0x61, 0x11, 0x24,
	0xac, 0x07, 0x45, 0x04, 0x97, 0x4f, 0xf9, 0x0a, 0x55, 0x61, 0x4c, 0x1d, 0xff, 0xef, 0xd7, 0xfb,
	0x1f, 0x5b, 0x08, 0x9f, 0x44, 0x74, 0x17, 0x03, 0xa4, 0x16, 0xef, 0x27, 0x12, 0x73, 0xd0, 0x61,
	0xf7, 0x09, 0x39, 0x02, 0xc4, 0x27, 0x4c, 0xa3, 0x01, 0x2c, 0xc0, 0x04, 0x46, 0x02, 0x03, 0x02,
	0xf0, 0x02, 0x3f, 0x09, 0x13, 0xa7, 0x0c, 0x2c, 0x01, 0x02, 0x43, 0x07, 0x70, 0x01, 0x07, 0x3c,
	0x7d, 0x57, 0x4a, 0x77, 0x4f, 0xbf, 0x02, 0x3f, 0x06, 0x62, 0x0c, 0x5f, 0x76, 0x00, 0x29, 0x02,
	0x7f, 0xa3, 0xd7, 0xa8, 0x1a, 0xff, 0x81, 0xff, 0x9e, 0x03, 0x0c, 0x65, 0x78, 0x58, 0x12, 0xf3,
	0x1f, 0x78, 0x81, 0x79, 0x7c, 0x6f, 0x18, 0x6f, 0xe3, 0x3f, 0x02, 0x0a, 0xed, 0x09, 0x09, 0x01,
	0xaf, 0x07, 0x61, 0x18, 0x7f, 0x09, 0x07, 0xe2, 0x05, 0x36, 0x2e, 0x20, 0x52, 0x65, 0x76, 0xa0,
	0x29, 0x8f, 0x8a, 0x45, 0x01, 0x59, 0x18, 0x87, 0xc0, 0xef, 0x04, 0x02, 0x02, 0x81, 0x75, 0xe7,
	0xc7, 0xeb, 0x17, 0xf8, 0x8f, 0x5f, 0x9c, 0x99, 0x01, 0x73, 0x68, 0xa1, 0x5b, 0x32, 0x03, 0xfc,
	0x99, 0x6e, 0x65, 0x77, 0x95, 0x24, 0x73, 0x79, 0xad, 0x8f, 0x03, 0x2f, 0x0c, 0x1c, 0x98, 0x48,
	0x38, 0x62, 0x2c, 0x38, 0x00, 0x2e, 0x20, 0x53, 0x69, 0x14, 0x68, 0x02, 0xbd, 0x87, 0x50, 0x4f,
	0x49, 0x36, 0x31, 0x8d, 0x58, 0x73, 0x69, 0xab, 0xa0, 0x19, 0x73, 0x70, 0x69, 0x6e, 0xef, 0xe5,
	0x7e, 0x72, 0xc8, 0x59, 0x0c, 0x2e, 0x05, 0x39, 0x8c, 0x01, 0x83, 0x32, 0x58, 0x05, 0x0a, 0x50,
	0x29, 0xd8, 0x50, 0x81, 0x01, 0x64, 0x65, 0x20, 0x62, 0x6c, 0x81, 0x01, 0xd8, 0x80, 0x70, 0x01,
	0x39, 0x9d, 0x77, 0x09, 0x0f, 0x48, 0x36, 0x39, 0x10, 0xda, 0x20, 0x63, 0x68, 0xbc, 0x53, 0x1f,
	0x45, 0x99, 0x5e, 0x0d, 0x2b, 0x48, 0x0e, 0x67, 0xf7, 0xbd, 0x8f, 0xf7, 0x78, 0x10, 0x51, 0x1d,
	0x11, 0xce, 0x58, 0x0c, 0x75, 0x00, 0x08, 0x91, 0x0c, 0x0d, 0x01, 0xd0, 0x77, 0x62, 0x65, 0x72,
	0x12, 0x27, 0x57, 0x1f, 0xf0, 0x54, 0x21, 0x19, 0x28, 0x2f, 0x65, 0xf8, 0x01, 0x79, 0x5e, 0x76,
	0x25, 0xfd, 0x1d, 0x20, 0x98, 0x03, 0xf1, 0x66, 0x14, 0x02, 0xbf, 0x2e, 0xf0, 0x1f, 0x0a, 0x11,
	0x22, 0xd1, 0x5c, 0x08, 0x18, 0xc9, 0x78, 0xfb, 0xf7, 0x3f, 0x9f, 0x56, 0xb4, 0x22, 0x0a, 0xca,
	0x86, 0x39, 0x03, 0x88, 0x35, 0x78, 0x4f, 0x41, 0x04, 0x68, 0x61, 0xa8, 0x16, 0xa1, 0x02, 0xfc,
	0x2b, 0x10, 0x03, 0x8e, 0x1d, 0xba, 0x00, 0xa3, 0x18, 0x88, 0x0e, 0x58, 0x81, 0x06, 0xd0, 0x65,
	0xa8, 0x17, 0xc0, 0x02, 0x7a, 0x04, 0x29, 0x17, 0xfb, 0x0f, 0x0f, 0x34, 0x72, 0xe2, 0x00, 0x17,
	0x04, 0x0a, 0x4f, 0x01, 0xe0, 0x04, 0xbd, 0xed, 0xff, 0xfc, 0xf7, 0xbf, 0x12, 0xc5, 0x09, 0xbe,
	0x43, 0xc3, 0x09, 0x0a, 0xc7, 0x09, 0x02, 0x3f, 0x94, 0x0a, 0x0a, 0x01, 0x75, 0xef, 0x0b, 0x84,
	0x37, 0x17, 0x57, 0xcf, 0xff, 0x00, 0x92, 0x33, 0x51, 0x77, 0x68, 0x6f, 0x79, 0x93, 0xc9, 0x05,
	0x5e, 0x06, 0x27, 0x02, 0x0e, 0x61, 0x99, 0xe8, 0x95, 0x0f, 0x07, 0xbf, 0x10, 0xa1, 0x12, 0x27,
	0x07, 0xef, 0x10, 0xff, 0x05, 0x00, 0x15, 0x78, 0x38, 0x05, 0x68, 0x91, 0x64, 0xc8, 0x00, 0x3e,
	0xbe, 0x9f, 0xe7, 0xe8, 0xbb, 0x30, 0x21, 0x6a, 0x0c, 0x66, 0x75, 0x71, 0x8a, 0xb5, 0x05, 0x1f,
	0x1f, 0x11, 0x31, 0x57, 0x6c, 0x6c, 0xe2, 0x10, 0x18, 0x24, 0x83, 0x0e, 0x19, 0x03, 0x80, 0x52,
	0x62, 0x06, 0x63, 0x58, 0x8d, 0x20, 0x0e, 0x4a, 0xa6, 0xa1, 0x0e, 0x10, 0x8d, 0x70, 0x74, 0x61,
	0xe1, 0x6a, 0x14, 0x0f, 0x45, 0x09, 0x58, 0x32, 0x51, 0x62, 0x61, 0xff, 0x1f, 0xff, 0x91, 0xfa,
	0x28, 0x61, 0x75, 0x30, 0xb0, 0x72, 0x69, 0x7a, 0x2b, 0x21, 0x49, 0x3b, 0xc9, 0x06, 0xd9, 0xe7,
	0x0b, 0x0b, 0x3a, 0x03, 0xcd, 0x01, 0xf1, 0x00, 0x2f, 0x19, 0x01, 0x2e, 0x0a, 0x0a, 0x03, 0x64,
	0x65, 0x74, 0x88, 0x61, 0x69, 0x6c, 0x01, 0x03, 0x61, 0x64, 0x64, 0xe0, 0x02, 0x3e, 0x73, 0x02,
	0x0b, 0x10, 0x1e, 0x90, 0x6c, 0x71, 0x20, 0xb2, 0x41, 0x63, 0x65, 0xe4, 0x72, 0x6e, 0xa3, 0x3e,
	0x45, 0x61, 0x40, 0x08, 0x15, 0x56, 0x90, 0x1c, 0x46, 0x67, 0xf0, 0x20, 0xa1, 0x3a, 0x64, 0x69,
	0x73, 0xf1, 0xa5, 0x75, 0x07, 0x00, 0x10, 0x21, 0x19, 0x15, 0x02, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0xbe, 0x72, 0x22, 0x4e, 0xa9, 0x3e, 0xe0, 0xa9, 0x41, 0x32, 0x50, 0x5e, 0x65, 0xf0, 0x03, 0xee,
	0x64, 0x80, 0x21, 0xe6, 0x4a, 0xf5, 0x3b, 0x20, 0x30, 0x07, 0x90, 0x09, 0x25, 0x04, 0xef, 0x18,
	0x79, 0x3f, 0x14, 0x3f, 0x14, 0x32, 0x14, 0x22, 0xc0, 0x0b, 0x11, 0x30, 0xd0, 0x52, 0xe3, 0x40,
	0x02, 0xe4, 0x03, 0x22, 0x0a, 0x61, 0x21, 0x41, 0x71, 0x06, 0x10, 0x6b, 0xf3, 0xf0, 0x9e, 0x81,
	0x08, 0x68, 0x61, 0x50, 0x2d, 0x41, 0x05, 0xf4, 0x57, 0x20, 0x06, 0xd7, 0x16, 0x3b, 0x48, 0x31,
	0x10, 0x1d, 0x0a, 0xd0, 0x10, 0x64, 0xf0, 0x33, 0xe1, 0x17, 0xfe, 0x65, 0x50, 0x2f, 0x80, 0x05,
	0xf2, 0x08, 0x51, 0x2e, 0xf3, 0x1f, 0x19, 0x68, 0xc2, 0x01, 0xfd, 0x2e, 0x08, 0x0a, 0x97, 0x02,
	0xd2, 0x47, 0x7f, 0x25, 0x75, 0x25, 0x85, 0x13, 0x97, 0x8f, 0xe5, 0x82, 0x13, 0x0a, 0x89, 0x13,
	0x64, 0x6f, 0xb0, 0x0c, 0x11, 0x4d, 0x13, 0x14, 0xf7, 0x30, 0x02, 0xdc, 0x17, 0x6f, 0x2e, 0x0a,
	0x0f, 0x13, 0xb3, 0x4f, 0x22, 0x67, 0xa0, 0x2c, 0x7d, 0xc0, 0x4c, 0x6f, 0x41, 0xa0, 0x90, 0x0b,
	0xdc, 0x74, 0x4f, 0x04, 0x5d, 0x17, 0x65, 0xff, 0x10, 0x03, 0xb8, 0x10, 0x1f, 0x0e, 0x1b, 0x0e,
	0x41, 0x25, 0x4f, 0x0e, 0xdf, 0x21, 0xdc, 0x21, 0x55, 0x00, 0x2a, 0x78, 0x70, 0x0a, 0x61, 0x01,
	0x2c, 0x63, 0x00, 0x63, 0x0a, 0xc3, 0x60, 0x42, 0xd2, 0x18, 0x66, 0x75, 0x74, 0x75, 0x10, 0x06,
	0x36, 0x32, 0xcf, 0xdf, 0x22, 0x7f, 0x0b, 0x72, 0x0b, 0x60, 0xae, 0x6c, 0x6c, 0xc2, 0x21, 0x30,
	0x48, 0xcf, 0x03, 0x1d, 0x31, 0x06, 0x00, 0xa5, 0xc2, 0x0c, 0x63, 0x20, 0x80, 0x77, 0x70, 0xa4,
	0x03, 0xf2, 0xa6, 0x40, 0x1d, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x57, 0xc1, 0xd5, 0x24, 0x1e,
	0x47, 0x31, 0x0a, 0xa1, 0xc4, 0x61, 0xf2, 0x51, 0x61, 0x80, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x53, 0x42, 0xff, 0x91, 0x76, 0x91, 0x0d, 0x90, 0x27, 0x14, 0x16, 0x72, 0x06, 0x95, 0x03,
	0xe1, 0x01, 0x58, 0x32, 0x01, 0xa0, 0x11 };

uint8_t fwnt_test_lzxpress_huffman_compressed_byte_stream[ 2917 ] = {
	0x00, 0x00, 0x00, 0x00, 0xa0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x05, 0x07, 0x00, 0xb0, 0x88, 0x00, 0xb7, 0x97, 0x99, 0x99, 0xb9, 0xba, 0xb0, 0x0a, 0x0b, 0x0b,
	0x80, 0x8b, 0x8a, 0x99, 0x9b, 0x0b, 0xa7, 0xb9, 0x09, 0x89, 0x9a, 0xbb, 0xb0, 0x00, 0x00, 0x00,
	0x60, 0x67, 0x56, 0x76, 0x57, 0x9b, 0x66, 0x56, 0xb7, 0x65, 0x66, 0x78, 0x89, 0x0b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x87, 0x09, 0x0a, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x66, 0x98, 0x99, 0x90, 0xba, 0xbb, 0x0b, 0xb0,
	0x66, 0x87, 0x88, 0xa9, 0x9b, 0xa9, 0x00, 0x9a, 0x76, 0x86, 0x99, 0x89, 0xa9, 0x9a, 0xaa, 0x99,
	0x66, 0x77, 0x87, 0x9b, 0x98, 0xb9, 0x9b, 0x8b, 0x65, 0x77, 0x87, 0xa8, 0xab, 0xb9, 0xb9, 0x70,
	0x65, 0x77, 0x89, 0xaa, 0x99, 0x99, 0x0a, 0x9b, 0x66, 0x87, 0x88, 0xa0, 0xb9, 0xa0, 0xba, 0x8b,
	0x70, 0xb9, 0xb9, 0x9b, 0xab, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xbd, 0xf4, 0x00, 0x20, 0xdd, 0x1b, 0x08, 0xff, 0x71, 0x13, 0xf1, 0xb1, 0xb8, 0xf1, 0xde, 0x20,
	0x6f, 0xe3, 0xb8, 0xf1, 0x93, 0x38, 0xc0, 0x41, 0x7d, 0xe1, 0xbb, 0xd9, 0x50, 0xec, 0x93, 0x7e,
	0x7f, 0x1b, 0x8c, 0x8f, 0x25, 0x73, 0x1f, 0xfd, 0x24, 0x84, 0x02, 0x43, 0x58, 0x1b, 0x54, 0x60,
	0xa9, 0xfd, 0xdc, 0x7d, 0xa0, 0x15, 0xf6, 0x37, 0x08, 0x7d, 0x3b, 0xd9, 0xbf, 0xe0, 0x38, 0x8e,
	0x62, 0x49, 0x8e, 0x3e, 0x05, 0xe0, 0x82, 0xc5, 0xc2, 0xe4, 0xc3, 0x37, 0x28, 0x08, 0x84, 0x8e,
	0x41, 0x97, 0x34, 0x79, 0xa4, 0x0d, 0x02, 0xd8, 0xe0, 0x13, 0x55, 0x67, 0xd7, 0xc1, 0xd2, 0x55,
	0xbe, 0x80, 0x09, 0x74, 0xfb, 0x5e, 0x17, 0xa9, 0x8f, 0xdb, 0xb6, 0xb2, 0x24, 0x06, 0x53, 0xfb,
	0x49, 0xb8, 0x6f, 0x31, 0x70, 0x02, 0xb2, 0x91, 0x4c, 0xa8, 0xb6, 0x05, 0x96, 0x91, 0x10, 0x2e,
	0x41, 0x51, 0xb8, 0xe3, 0x02, 0x0d, 0x02, 0x03, 0xbc, 0x44, 0xd5, 0x89, 0x08, 0xc8, 0x65, 0xcc,
	0x29, 0x10, 0x2e, 0xc9, 0x32, 0xa0, 0xcd, 0x56, 0xa6, 0x2b, 0x88, 0x01, 0x1c, 0x05, 0xa4, 0x33,
	0xe8, 0xc4, 0xa4, 0x55, 0x80, 0x20, 0x58, 0x68, 0x44, 0xa0, 0x30, 0x5e, 0x55, 0x19, 0x58, 0x10,
	0x80, 0x7a, 0xa0, 0xc4, 0xb3, 0xf0, 0xac, 0x77, 0x09, 0x54, 0x1f, 0x80, 0x6b, 0xd3, 0xf4, 0x20,
	0x1d, 0x30, 0xa3, 0x60, 0xe7, 0xd7, 0x03, 0x6d, 0x6b, 0xf6, 0xa8, 0x85, 0x0a, 0xb9, 0x86, 0x56,
	0x40, 0x24, 0x58, 0xf4, 0x06, 0x84, 0x2a, 0xa6, 0x87, 0x03, 0x0e, 0x9b, 0x13, 0x13, 0x80, 0x64,
	0x73, 0xa8, 0x12, 0x94, 0x0c, 0x43, 0x46, 0x74, 0xd7, 0x53, 0x13, 0xd6, 0x5d, 0x3c, 0xeb, 0x01,
	0xad, 0x88, 0xaa, 0xf0, 0xaa, 0xc3, 0x59, 0x9a, 0xf3, 0x73, 0xdd, 0xf7, 0x9c, 0x3b, 0x15, 0x59,
	0x35, 0x59, 0x60, 0x34, 0x8a, 0x0d, 0x53, 0x8e, 0x57, 0x9d, 0xff, 0x97, 0x93, 0xd1, 0x03, 0x39,
	0xcc, 0xd6, 0x97, 0x59, 0x1b, 0xea, 0xc3, 0x5b, 0xed, 0xa1, 0x2c, 0x5b, 0x76, 0x40, 0xb2, 0xbc,
	0x0d, 0x62, 0xc0, 0x17, 0x73, 0x85, 0xea, 0x2b, 0x21, 0x1a, 0x9e, 0x32, 0x60, 0x11, 0xbf, 0x30,
	0x60, 0x31, 0xb3, 0x12, 0xa0, 0x4f, 0x04, 0xca, 0xc5, 0x67, 0xac, 0xd4, 0x9b, 0x10, 0xa0, 0x3a,
	0x29, 0x07, 0xa6, 0xbb, 0x3e, 0xe1, 0x1a, 0x03, 0x69, 0xa7, 0xcb, 0x86, 0xbb, 0x7b, 0x04, 0x94,
	0x4b, 0xde, 0xf5, 0xde, 0x04, 0x1d, 0x82, 0x5e, 0x02, 0x0e, 0x2b, 0x91, 0x05, 0x64, 0xd7, 0x45,
	0x93, 0x87, 0x38, 0x27, 0x93, 0x41, 0x9c, 0xac, 0xef, 0x63, 0xb6, 0xe9, 0xb0, 0x9c, 0x0c, 0x4f,
	0x30, 0xd5, 0xe3, 0x49, 0x74, 0x25, 0xf4, 0x38, 0xcb, 0xca, 0x6d, 0x68, 0x4a, 0xae, 0x7a, 0x06,
	0x98, 0xea, 0x23, 0x42, 0x42, 0x00, 0xca, 0x23, 0x03, 0x62, 0x63, 0x49, 0x8d, 0x6b, 0xc2, 0x89,
	0x3f, 0xcf, 0xc1, 0x08, 0x58, 0x57, 0xc0, 0x4b, 0xda, 0x54, 0xc4, 0xbd, 0x12, 0x4a, 0xac, 0x70,
	0x84, 0xb9, 0x7a, 0x9c, 0x39, 0xca, 0xb6, 0x50, 0xe0, 0x18, 0xfe, 0x28, 0x6b, 0xaa, 0xd5, 0xc2,
	0xdc, 0xc8, 0x7e, 0x1e, 0x89, 0x41, 0x80, 0x83, 0x44, 0x12, 0xc8, 0x44, 0x21, 0x17, 0xeb, 0x19,
	0xfd, 0x91, 0x56, 0xa8, 0x94, 0x0a, 0x09, 0x88, 0x1a, 0x94, 0x67, 0x13, 0x52, 0x4e, 0x62, 0x09,
	0x3e, 0x50, 0xa7, 0x51, 0xfb, 0x75, 0x98, 0x32, 0x7c, 0x4f, 0xae, 0x62, 0x28, 0x09, 0x72, 0xb5,
	0x9e, 0x8b, 0x92, 0x1e, 0xe1, 0xe9, 0xc3, 0xe7, 0xb7, 0xe3, 0xd0, 0x84, 0xa8, 0x34, 0xa4, 0x4a,
	0x59, 0x44, 0x83, 0x33, 0x27, 0x16, 0x36, 0x3f, 0xa8, 0x3f, 0x5d, 0xfe, 0xee, 0x02, 0xf0, 0x7f,
	0xed, 0x4a, 0xd7, 0x12, 0xcf, 0x00, 0xce, 0xfc, 0x61, 0x11, 0x4e, 0x0e, 0xcb, 0x10, 0x8d, 0x2b,
	0xb2, 0xbe, 0x95, 0x98, 0xe6, 0xe1, 0x77, 0x4c, 0xce, 0x65, 0x97, 0x90, 0xcf, 0xa1, 0x1b, 0x86,
	0x7f, 0x8b, 0x45, 0x9e, 0x83, 0xc4, 0x9e, 0x09, 0x51, 0x4d, 0xb0, 0x05, 0x29, 0xf7, 0x65, 0x07,
	0xb9, 0xe6, 0x53, 0x86, 0x2b, 0xff, 0x4f, 0x6a, 0xa8, 0xdb, 0x37, 0x7a, 0x03, 0x43, 0x58, 0xd3,
	0x41, 0xc1, 0x74, 0x7a, 0xa5, 0xf5, 0x9a, 0x4a, 0xa7, 0xe8, 0x3b, 0xe0, 0x9c, 0xc5, 0xa9, 0xa7,
	0xa4, 0xb9, 0x59, 0xaf, 0xaa, 0xd5, 0xeb, 0x14, 0x32, 0x8a, 0x2b, 0x10, 0x87, 0x51, 0xeb, 0x4e,
	0x71, 0x1c, 0x44, 0xb0, 0x02, 0x0b, 0xe0, 0x4a, 0x40, 0x79, 0x01, 0x5b, 0x9e, 0x6b, 0x5b, 0xfb,
	0x1d, 0x97, 0xe9, 0xb1, 0x3e, 0x02, 0x60, 0xd9, 0x11, 0x0f, 0xd8, 0x04, 0x44, 0xcb, 0x55, 0x23,
	0x2c, 0xb9, 0x08, 0x42, 0xa2, 0xc6, 0xd6, 0x60, 0x5f, 0xce, 0xc7, 0xa5, 0xca, 0xdc, 0xf4, 0x12,
	0x84, 0xb8, 0x9f, 0x35, 0x85, 0x9e, 0x27, 0xda, 0x96, 0xed, 0x75, 0x1a, 0x8b, 0x93, 0x20, 0x69,
	0xee, 0x4e, 0xb4, 0x0b, 0x2d, 0x9b, 0xec, 0x61, 0xb5, 0x96, 0x50, 0x09, 0xeb, 0x04, 0x9d, 0x37,
	0x8e, 0x80, 0xce, 0xac, 0x76, 0xcd, 0xa9, 0x2b, 0xc2, 0x74, 0x3b, 0x87, 0x0e, 0x05, 0xf2, 0x2a,
	0x03, 0xad, 0xec, 0x76, 0xcc, 0xb7, 0xcc, 0x8f, 0xa9, 0x8a, 0xf8, 0xe6, 0x7b, 0x97, 0x4c, 0x09,
	0x69, 0x0e, 0x1a, 0xea, 0x3c, 0x18, 0xab, 0x49, 0x5c, 0x7c, 0x89, 0x4a, 0x98, 0xc8, 0xb3, 0x93,
	0x79, 0x42, 0xf5, 0x52, 0x18, 0x08, 0x8e, 0xda, 0x40, 0xb5, 0x35, 0x10, 0x57, 0x8f, 0xea, 0x83,
	0x48, 0xe1, 0x51, 0xf9, 0xdc, 0xb1, 0xe1, 0x1f, 0xf6, 0xb6, 0x5a, 0x49, 0x3e, 0x65, 0x92, 0x95,
	0x2d, 0x16, 0x4d, 0xba, 0xe9, 0x1a, 0xd6, 0x03, 0x4c, 0xdc, 0x37, 0x06, 0x00, 0x11, 0xac, 0xd1,
	0x61, 0x10, 0x1d, 0xbf, 0xbc, 0xdc, 0xe2, 0x77, 0x38, 0x6e, 0x72, 0x13, 0xf8, 0xdb, 0xc1, 0xc6,
	0x10, 0x50, 0x95, 0xc0, 0x09, 0xc8, 0x1e, 0xaa, 0xef, 0x31, 0x66, 0x93, 0x0c, 0xbc, 0xad, 0x40,
	0x0a, 0x98, 0x85, 0xcd, 0x66, 0x57, 0x30, 0xef, 0x94, 0x8f, 0xb2, 0xa9, 0x1b, 0xe2, 0xa7, 0xac,
	0x90, 0x19, 0x09, 0x9e, 0x64, 0xd1, 0xd5, 0xf0, 0x58, 0xb9, 0x73, 0xe8, 0x98, 0xb9, 0x04, 0xb7,
	0xeb, 0x6a, 0x34, 0xb0, 0x7e, 0x12, 0xd1, 0xec, 0x42, 0x2d, 0x71, 0x3d, 0x96, 0x40, 0xf2, 0xaa,
	0xc9, 0x2b, 0x7f, 0xcd, 0x73, 0x43, 0x9b, 0x2e, 0xcd, 0xaa, 0x6d, 0x91, 0xed, 0x12, 0x54, 0x28,
	0xcd, 0x95, 0x9c, 0x45, 0xd8, 0x9e, 0x5a, 0x60, 0x1c, 0xbc, 0x8a, 0x81, 0xcf, 0x49, 0x7e, 0x73,
	0x85, 0xbf, 0xcc, 0x06, 0x3b, 0x53, 0x16, 0x0d, 0x4e, 0xce, 0xea, 0x57, 0xa8, 0xf8, 0x5d, 0xf3,
	0x96, 0xe6, 0x62, 0x8c, 0x4a, 0x59, 0x92, 0x03, 0x1c, 0xae, 0x9a, 0x81, 0x17, 0x89, 0xa1, 0x2b,
	0x59, 0x7d, 0x5a, 0xc4, 0xde, 0xb9, 0xc0, 0x77, 0xa6, 0xa8, 0xd1, 0xcb, 0x06, 0x40, 0x0b, 0xe6,
	0x4b, 0x57, 0xe2, 0x65, 0x20, 0xe1, 0x67, 0xca, 0xcb, 0x9d, 0xa7, 0xe0, 0x76, 0x34, 0xf4, 0xd2,
	0x67, 0x0b, 0x30, 0x17, 0xde, 0x48, 0x7d, 0x40, 0x06, 0x1d, 0x7e, 0xbf, 0x89, 0x61, 0x0c, 0xa1,
	0xf2, 0x30, 0x6f, 0x63, 0xcc, 0x56, 0x86, 0xa6, 0xe1, 0x95, 0x31, 0x7c, 0x18, 0x48, 0x44, 0x2a,
	0x52, 0x77, 0x51, 0xb8, 0x79, 0x37, 0x43, 0x31, 0x62, 0x6b, 0xb3, 0xfa, 0x56, 0x99, 0x2b, 0x22,
	0x07, 0x0f, 0xac, 0x70, 0x9a, 0x6e, 0x44, 0x87, 0xfc, 0x58, 0x23, 0xea, 0x96, 0xe0, 0xd2, 0xb4,
	0x1d, 0xa9, 0xa7, 0x08, 0x76, 0x2c, 0x16, 0x30, 0x59, 0xdf, 0x0c, 0x81, 0x6c, 0xd7, 0x76, 0x8d,
	0x5b, 0x02, 0x5d, 0x63, 0xa4, 0x0f, 0xb4, 0x53, 0x8f, 0x6c, 0x87, 0x51, 0xdd, 0xf2, 0x6a, 0xf1,
	0x12, 0x66, 0x93, 0x11, 0x23, 0x92, 0xc6, 0x15, 0xc8, 0x11, 0x0f, 0xb0, 0x4e, 0x0a, 0xec, 0x49,
	0x24, 0xe5, 0x84, 0x3b, 0xb7, 0xe7, 0xdf, 0x7f, 0x68, 0x2a, 0xd5, 0xbc, 0xcb, 0xab, 0xd0, 0x7c,
	0x21, 0x79, 0xb0, 0x1c, 0xb4, 0x93, 0x06, 0x05, 0x76, 0x82, 0x80, 0x4e, 0x7e, 0x7e, 0xc9, 0xb9,
	0x18, 0xbe, 0xe7, 0x3a, 0x42, 0xd0, 0x43, 0xd9, 0xa6, 0x6e, 0xf0, 0x03, 0x0a, 0x5e, 0x15, 0x62,
	0x3f, 0x24, 0x04, 0x3b, 0xca, 0xbe, 0xd8, 0xe5, 0x13, 0x24, 0xd9, 0x70, 0xcd, 0xe3, 0x95, 0xb4,
	0xde, 0x07, 0x9d, 0x09, 0x03, 0x22, 0x24, 0x78, 0x69, 0xc3, 0x11, 0x95, 0xe0, 0x5b, 0xa0, 0x1b,
	0xaa, 0x02, 0xf9, 0x9b, 0x42, 0xb3, 0xf2, 0x06, 0xfa, 0x18, 0xfc, 0x61, 0x38, 0x1e, 0xc7, 0xf8,
	0x46, 0x95, 0x6d, 0x12, 0xf4, 0x8c, 0xc3, 0xae, 0x3b, 0xd1, 0xc7, 0xab, 0x00, 0xa2, 0xd7, 0xd4,
	0xae, 0x77, 0x06, 0xb3, 0x73, 0x9f, 0x9c, 0xc0, 0x1b, 0xf0, 0xf7, 0x07, 0x53, 0xcf, 0xb3, 0x3d,
	0x42, 0x3d, 0xdf, 0x80, 0xee, 0x0f, 0x8a, 0x91, 0xcc, 0x17, 0xa8, 0x73, 0x13, 0x61, 0x66, 0xba,
	0x00, 0x76, 0x62, 0x0a, 0x74, 0x8d, 0x21, 0xb5, 0x52, 0x81, 0x08, 0xc0, 0x17, 0xed, 0x0f, 0xdd,
	0x14, 0x32, 0x52, 0x16, 0xd5, 0xff, 0x3c, 0x9b, 0xe1, 0x6b, 0x17, 0x84, 0xc4, 0x29, 0xcf, 0xe4,
	0x27, 0x6f, 0x21, 0xfb, 0x9e, 0x08, 0x11, 0x82, 0x31, 0x99, 0x68, 0xb4, 0x13, 0x98, 0xe9, 0x5a,
	0xed, 0xba, 0x0e, 0x02, 0x89, 0x98, 0x71, 0x53, 0x97, 0xaf, 0x33, 0xdb, 0x62, 0xf2, 0x1e, 0x64,
	0xa4, 0x89, 0xd5, 0x68, 0x12, 0x76, 0x9f, 0xe5, 0x54, 0xb3, 0x49, 0x83, 0xcd, 0xd9, 0x1a, 0x2e,
	0x13, 0xe8, 0xb3, 0x0a, 0xa0, 0xd7, 0xfc, 0x5a, 0x24, 0x30, 0xdc, 0x4b, 0x9f, 0x2e, 0x8d, 0x44,
	0xc8, 0x21, 0x9f, 0xcc, 0xd5, 0xbb, 0xef, 0xa4, 0x91, 0x45, 0x22, 0x7c, 0xcf, 0xa8, 0xf9, 0xca,
	0x7b, 0x76, 0xd6, 0xe0, 0xa1, 0x89, 0xf3, 0x3d, 0x8f, 0x7f, 0xd9, 0x1d, 0xad, 0xc4, 0x6e, 0x03,
	0x36, 0x11, 0xcb, 0xc7, 0xf7, 0xe1, 0xdc, 0xd4, 0x5c, 0x57, 0x4b, 0x34, 0xad, 0x78, 0xce, 0x29,
	0xc2, 0x42, 0x90, 0xe7, 0x45, 0xb9, 0x33, 0x82, 0x65, 0xed, 0xf8, 0xce, 0xf8, 0xc1, 0xd6, 0x92,
	0x50, 0x47, 0x31, 0xbb, 0x8c, 0x10, 0x51, 0x50, 0x70, 0x8a, 0x42, 0xf8, 0x9b, 0x3c, 0x18, 0xc4,
	0x87, 0xdb, 0xfa, 0xe6, 0xc5, 0xd9, 0x38, 0x2f, 0x86, 0x73, 0xc4, 0x6c, 0x8d, 0xfa, 0xe2, 0x6e,
	0x7b, 0x60, 0xe5, 0xf1, 0x57, 0xa5, 0x84, 0xf8, 0x61, 0x3f, 0x0e, 0x2e, 0xd5, 0x1e, 0x09, 0xe5,
	0x2c, 0x38, 0xcc, 0x3b, 0xc5, 0x0b, 0x4f, 0x49, 0xa3, 0x42, 0x18, 0x28, 0x49, 0x6c, 0xa0, 0x98,
	0x80, 0x7e, 0x35, 0x11, 0x2e, 0xbb, 0x69, 0xe8, 0x28, 0xb0, 0x0b, 0x0d, 0xfc, 0x45, 0x77, 0xdf,
	0xf9, 0x2a, 0xe8, 0xb0, 0x4d, 0xe9, 0x6e, 0xcc, 0x05, 0xd7, 0x07, 0xca, 0x5c, 0xa9, 0x9e, 0xbb,
	0x8a, 0x10, 0x89, 0xee, 0x96, 0xff, 0x97, 0xc9, 0xa9, 0xa5, 0x50, 0x45, 0xd0, 0x22, 0xc0, 0xcc,
	0x19, 0xbf, 0x4f, 0x2c, 0x4e, 0xfe, 0xc1, 0x90, 0x68, 0xf8, 0xad, 0xf7, 0x44, 0xe3, 0xcb, 0x6b,
	0xa8, 0x98, 0x79, 0x72, 0x22, 0x82, 0x3b, 0xaa, 0xce, 0x2c, 0x07, 0x18, 0x17, 0x9c, 0xa9, 0xde,
	0x5d, 0x70, 0x0d, 0xd5, 0x52, 0x60, 0x70, 0x30, 0x04, 0x2a, 0xe0, 0xe3, 0x45, 0x5b, 0xe6, 0x41,
	0x00, 0xed, 0x91, 0xe5, 0x52, 0x56, 0x32, 0xde, 0xa8, 0x45, 0xbf, 0x3b, 0xae, 0xc4, 0x1b, 0x08,
	0x62, 0x01, 0xa7, 0x10, 0x0f, 0x46, 0x28, 0x7e, 0x4a, 0x8f, 0x72, 0xd6, 0x08, 0xdb, 0x42, 0x67,
	0xfb, 0xd7, 0x5a, 0x0a, 0xb4, 0xf3, 0xa0, 0xa6, 0x01, 0x84, 0xaf, 0xb2, 0x66, 0x3d, 0x69, 0x52,
	0x60, 0x82, 0x09, 0xb7, 0xe8, 0xdf, 0xbb, 0x55, 0x08, 0xe8, 0x67, 0x90, 0x88, 0xf6, 0x9c, 0xc3,
	0x09, 0x4d, 0xe7, 0x13, 0x9d, 0x60, 0xab, 0x4e, 0xfa, 0xd7, 0xd5, 0xf0, 0xfb, 0x0e, 0x47, 0x7a,
	0x1e, 0x0c, 0xe3, 0xa8, 0x9f, 0x51, 0xb5, 0x24, 0x0d, 0xdd, 0x76, 0x71, 0x7b, 0xf8, 0x43, 0x03,
	0x3b, 0x2c, 0x87, 0x4e, 0x5e, 0xbf, 0x0a, 0xd2, 0x6a, 0xf7, 0x5c, 0xab, 0x38, 0x37, 0x1a, 0xf6,
	0xb2, 0xb4, 0x8d, 0xa1, 0xb9, 0x0c, 0xc6, 0x1f, 0x0d, 0x35, 0x67, 0x29, 0xb3, 0x02, 0x5e, 0x02,
	0x99, 0xed, 0x73, 0x4d, 0xf8, 0x06, 0xf5, 0xf6, 0x3f, 0xac, 0x4d, 0xe0, 0xeb, 0xde, 0x11, 0xec,
	0xfc, 0x72, 0xed, 0xf9, 0x08, 0x7e, 0xa2, 0x95, 0x4a, 0x06, 0x96, 0x1d, 0x77, 0x7e, 0xc9, 0x16,
	0x22, 0x1b, 0xc9, 0x77, 0xb3, 0x3e, 0x6a, 0x86, 0x43, 0x5f, 0x82, 0xb6, 0x62, 0x17, 0x7e, 0xba,
	0xf7, 0xbd, 0xbb, 0x09, 0x17, 0x22, 0x65, 0x38, 0x56, 0x0f, 0xbc, 0x3e, 0xa8, 0x05, 0x0e, 0x85,
	0xbc, 0x4b, 0x5b, 0x89, 0xed, 0xd3, 0xc2, 0xe2, 0xbc, 0x37, 0xdb, 0x5b, 0x71, 0x38, 0xe0, 0x74,
	0xea, 0x6b, 0x02, 0x77, 0xf1, 0x60, 0x18, 0x43, 0xe1, 0xec, 0x5a, 0xad, 0x19, 0xb6, 0x40, 0x4a,
	0x74, 0xb4, 0x08, 0x50, 0x7b, 0x05, 0x38, 0x4b, 0xd4, 0x51, 0x29, 0x9c, 0xed, 0xf7, 0x34, 0xa2,
	0xfe, 0x6a, 0x7b, 0x6f, 0x93, 0x9e, 0x18, 0x5c, 0xd9, 0x94, 0xcd, 0x08, 0xb1, 0xb3, 0xf2, 0x14,
	0xce, 0xee, 0x86, 0x93, 0x44, 0x84, 0xc6, 0xdd, 0x61, 0x53, 0xa2, 0x3f, 0x9a, 0xcc, 0xf6, 0xbf,
	0xea, 0x21, 0x93, 0x79, 0xbf, 0xd9, 0x22, 0xa6, 0x5f, 0x60, 0x1d, 0xb1, 0x4a, 0xf5, 0x6d, 0xb8,
	0xa1, 0x45, 0x29, 0xf6, 0x87, 0x84, 0x73, 0xfc, 0x5a, 0xaf, 0x27, 0x84, 0xed, 0x3a, 0x60, 0x90,
	0x97, 0x40, 0xc1, 0xc6, 0xff, 0x62, 0x46, 0xf0, 0xb4, 0x85, 0x33, 0x05, 0x01, 0xf8, 0xe6, 0x3c,
	0xb8, 0xfa, 0xee, 0xd8, 0x5e, 0x9f, 0xc4, 0xe8, 0xaa, 0xb8, 0xd1, 0xe7, 0xb1, 0x0c, 0x9c, 0xdd,
	0xcd, 0x1e, 0xf2, 0xab, 0x90, 0x8d, 0x86, 0x03, 0x06, 0x0e, 0x56, 0xb8, 0xa0, 0x8c, 0xb9, 0x2c,
	0x3b, 0xbe, 0x8d, 0x44, 0xb0, 0xf2, 0x3d, 0xae, 0xaf, 0x89, 0x06, 0x3d, 0xa7, 0xab, 0xcc, 0xbb,
	0x21, 0x9d, 0x9c, 0xb0, 0x79, 0x78, 0x3c, 0xb7, 0xb8, 0xa0, 0x11, 0xe1, 0x62, 0xba, 0xf2, 0x07,
	0x5f, 0xb0, 0xf0, 0x0d, 0xb0, 0xd9, 0xaf, 0x2a, 0x02, 0x3b, 0xcc, 0xf6, 0xf0, 0xb6, 0xe2, 0xfe,
	0x02, 0xa7, 0x2d, 0xb6, 0x43, 0xae, 0xeb, 0x52, 0xe1, 0xc0, 0xd8, 0x89, 0x6c, 0xc2, 0xeb, 0x4b,
	0x3d, 0xbb, 0x2d, 0xd4, 0x55, 0x67, 0x82, 0x0c, 0xb0, 0xaa, 0xe9, 0x90, 0xd2, 0xfb, 0x11, 0x2a,
	0xd9, 0x78, 0x35, 0xee, 0x28, 0xfe, 0x77, 0x96, 0x24, 0x5e, 0xdc, 0xda, 0xcb, 0x2a, 0x52, 0x4b,
	0x09, 0xe5, 0x56, 0x6f, 0xc7, 0xe9, 0xad, 0xbc, 0xbd, 0x5c, 0x1b, 0x3d, 0x14, 0xe5, 0xe9, 0xc2,
	0x20, 0x59, 0xdf, 0x40, 0xc9, 0x14, 0x9f, 0x3d, 0x86, 0x2b, 0x7c, 0x47, 0xbb, 0x6b, 0x6f, 0xa7,
	0xf7, 0x05, 0x1a, 0x06, 0x58, 0x18, 0x96, 0xd4, 0x94, 0xb4, 0x6d, 0xe0, 0xc6, 0x3f, 0x40, 0x6b,
	0x0b, 0xfa, 0x13, 0xa8, 0xa7, 0xb8, 0xe2, 0x21, 0x0a, 0xb3, 0x99, 0x7d, 0x75, 0xdb, 0xf1, 0x73,
	0x8d, 0x53, 0x57, 0x1d, 0x5d, 0x84, 0x4f, 0x81, 0xfb, 0xc8, 0x7b, 0x00, 0xb6, 0x8c, 0x3f, 0x70,
	0x22, 0x1a, 0x08, 0x3f, 0xe3, 0x4b, 0xb0, 0x07, 0x04, 0x59, 0xe1, 0x8f, 0xfd, 0x1e, 0x21, 0x08,
	0xb5, 0x6f, 0x34, 0x39, 0x74, 0x24, 0xd9, 0xbc, 0x46, 0xed, 0x1d, 0x14, 0xac, 0x4f, 0xec, 0xa5,
	0x48, 0x24, 0xcb, 0x0c, 0x3c, 0xe6, 0x61, 0x9f, 0x26, 0x39, 0xa8, 0xd4, 0x8e, 0x60, 0xaa, 0x57,
	0x11, 0x71, 0x96, 0xd7, 0xc5, 0x01, 0x0b, 0x16, 0x6d, 0x9c, 0xa1, 0xc9, 0x8e, 0xaf, 0x43, 0xaf,
	0xe5, 0x7d, 0x9a, 0xd9, 0x9c, 0xbc, 0xc9, 0x64, 0xfb, 0x5a, 0x2b, 0x3b, 0x4e, 0x73, 0x0d, 0x9f,
	0xd9, 0x1a, 0xa4, 0xd6, 0x79, 0xa2, 0x9d, 0x98, 0xff, 0x11, 0x49, 0xd1, 0x07, 0xd2, 0xed, 0xb4,
	0x13, 0xce, 0x7c, 0x01, 0x85, 0xd9, 0xf5, 0x76, 0x4d, 0x5b, 0xe8, 0x93, 0x0f, 0x9e, 0x12, 0x76,
	0xec, 0xbe, 0xda, 0xf9, 0x03, 0xe1, 0x68, 0x91, 0xde, 0x84, 0xfb, 0x42, 0x57, 0x25, 0xd6, 0xba,
	0xa5, 0x9a, 0x67, 0x60, 0x4e, 0xbf, 0x2d, 0x28, 0xda, 0x95, 0xd2, 0xe0, 0x96, 0xfa, 0x39, 0x7f,
	0x59, 0x9b, 0x46, 0xf8, 0x66, 0x1f, 0x78, 0x52, 0xf6, 0x8f, 0xf6, 0x5d, 0x7b, 0x09, 0x48, 0xeb,
	0x1b, 0xad, 0xec, 0xf3, 0x06, 0xc7, 0x6b, 0x6d, 0x7d, 0x80, 0xb7, 0x08, 0x01, 0xf2, 0x83, 0x2d,
	0x93, 0xe9, 0x7f, 0x6d, 0x60, 0x85, 0x58, 0x85, 0xf4, 0xfd, 0x7b, 0x4d, 0x70, 0x43, 0x5c, 0xea,
	0x42, 0x86, 0x76, 0xfd, 0x1b, 0x1e, 0x0c, 0xe9, 0x7b, 0x07, 0xcc, 0x39, 0x04, 0x4d, 0x06, 0xe2,
	0x7c, 0xcb, 0xa5, 0x30, 0x4c, 0x44, 0xcf, 0xd4, 0x08, 0x0b, 0x4d, 0x06, 0xe8, 0x63, 0xdb, 0x8f,
	0x06, 0xe6, 0x4f, 0xb5, 0xa8, 0x1b, 0x09, 0x49, 0xad, 0x91, 0xdd, 0xd0, 0x80, 0x0d, 0x15, 0x62,
	0x2d, 0x6c, 0x4d, 0x61, 0x0b, 0xcb, 0xd0, 0x60, 0xcc, 0x13, 0xc2, 0x86, 0xb1, 0xae, 0x61, 0xbc,
	0x18, 0x30, 0xa3, 0xf0, 0x3b, 0x9b, 0x87, 0xfe, 0x67, 0xc4, 0x2b, 0xae, 0x00, 0x2b, 0xc7, 0xd3,
	0x30, 0x9b, 0x71, 0x2b, 0xab, 0x66, 0x11, 0x51, 0x67, 0x23, 0xe7, 0x5d, 0x5b, 0x0b, 0xe5, 0x21,
	0xf4, 0x4a, 0xea, 0xa2, 0x8c, 0xc3, 0xc6, 0x95, 0x1a, 0x87, 0x21, 0x8a, 0x22, 0x8e, 0xd4, 0xa6,
	0x45, 0x4f, 0x5f, 0x16, 0xea, 0x80, 0x41, 0x29, 0x6b, 0xc4, 0x10, 0x2a, 0xd0, 0x45, 0x00, 0x71,
	0xcc, 0x93, 0x38, 0x50, 0x3d, 0xd2, 0xd3, 0x4c, 0xca, 0xe0, 0x50, 0x9e, 0x3a, 0x84, 0x13, 0xbc,
	0xfc, 0x86, 0x0f, 0x63, 0xc1, 0x80, 0xcb, 0x27, 0x7b, 0x14, 0x70, 0xee, 0x74, 0x49, 0x82, 0xe3,
	0xc7, 0xea, 0x8a, 0x24, 0x19, 0x7e, 0x9e, 0x29, 0xb6, 0x60, 0x8f, 0x04, 0xe4, 0x43, 0xf5, 0x2b,
	0x00, 0x38, 0x49, 0x6f, 0xfe, 0x26, 0x6c, 0x68, 0x35, 0x97, 0x34, 0x4d, 0x52, 0x49, 0x18, 0xb2,
	0x39, 0xa4, 0xc0, 0x5f, 0xe3, 0xa2, 0xf9, 0x1d, 0xe5, 0x0d, 0xe5, 0x28, 0xa7, 0x65, 0x35, 0xf0,
	0x19, 0x26, 0xaa, 0xe5, 0x81, 0x38, 0x6b, 0x79, 0xaf, 0x6e, 0x80, 0x5d, 0x3d, 0x22, 0x97, 0x45,
	0x2d, 0xd2, 0x5f, 0xff, 0x3b, 0x08, 0xd0, 0xf6, 0x4a, 0x97, 0x6d, 0x42, 0x88, 0xb4, 0xe6, 0xd0,
	0x00, 0x01, 0x55, 0x3d, 0xed, 0x03, 0xeb, 0x98, 0x3b, 0xa3, 0xab, 0xc2, 0xf5, 0x89, 0xc6, 0x08,
	0xa4, 0xce, 0xc1, 0x76, 0xdd, 0xc9, 0x9f, 0x93, 0x44, 0x39, 0x42, 0x56, 0x50, 0x93, 0x80, 0xf4,
	0x3b, 0x57, 0xe7, 0xb8, 0x4f, 0xf4, 0x00, 0x01, 0x5c, 0x07, 0xf7, 0x97, 0x01, 0x5d, 0x27, 0xe0,
	0xae, 0x0a, 0x73, 0xba, 0x02, 0x3a, 0x32, 0xe0, 0x15, 0x69, 0xd2, 0x75, 0x06, 0x42, 0xf1, 0xeb,
	0x55, 0x0e, 0xb8, 0xe5, 0x2a, 0x1e, 0x03, 0x0c, 0x88, 0x87, 0x83, 0xea, 0x60, 0xe1, 0x68, 0xa0,
	0xe3, 0xc4, 0xf5, 0x04, 0x92, 0xa3, 0x00, 0x63, 0xf4, 0xa7, 0xdc, 0x9b, 0x48, 0xf2, 0x18, 0xd3,
	0xb9, 0xc8, 0x4e, 0xc4, 0x74, 0x7d, 0x25, 0x24, 0x17, 0x28, 0x8d, 0x35, 0xbd, 0x1b, 0x00, 0x8d,
	0x79, 0x5f, 0x24, 0x0f, 0x4e, 0xa1, 0xea, 0x93, 0x81, 0x92, 0xcf, 0xd8, 0xae, 0xd1, 0xe3, 0x34,
	0x29, 0x24, 0x99, 0x3e, 0x4b, 0x40, 0xea, 0x0b, 0x7b, 0x19, 0xd0, 0xf9, 0x05, 0x04, 0xaf, 0x6d,
	0xd1, 0x6d, 0x55, 0xf5, 0x14, 0x8a, 0x61, 0x1c, 0xa5, 0x65, 0xbd, 0xf5, 0x7f, 0x4c, 0x93, 0xef,
	0x38, 0x00, 0xce, 0x00, 0x00 };

/* Tests the libfwnt_lzxpress_decompress function
 * Returns 1 if successful or 0 if not
 */
int fwnt_test_lzxpress_decompress(
     void )
{
	uint8_t uncompressed_data[ 8192 ];

	libcerror_error_t *error      = NULL;
	size_t uncompressed_data_size = 7640;
	int result                    = 0;

	result = libfwnt_lzxpress_decompress(
	          fwnt_test_lzxpress_compressed_byte_stream,
	          3575,
	          uncompressed_data,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_FPRINT_ERROR( error )

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "uncompressed_data_size",
	 uncompressed_data_size,
	 7640 );

	/* Test error cases
	 */
	result = libfwnt_lzxpress_decompress(
	          NULL,
	          3575,
	          uncompressed_data,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	result = libfwnt_lzxpress_decompress(
	          fwnt_test_lzxpress_compressed_byte_stream,
	          (size_t) SSIZE_MAX + 1,
	          uncompressed_data,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	result = libfwnt_lzxpress_decompress(
	          fwnt_test_lzxpress_compressed_byte_stream,
	          3575,
	          NULL,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	result = libfwnt_lzxpress_decompress(
	          fwnt_test_lzxpress_compressed_byte_stream,
	          3575,
	          uncompressed_data,
	          NULL,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	return( 0 );
}

/* Tests the libfwnt_lzxpress_huffman_decompress function
 * Returns 1 if successful or 0 if not
 */
int fwnt_test_lzxpress_huffman_decompress(
     void )
{
	uint8_t uncompressed_data[ 8192 ];

	libcerror_error_t *error      = NULL;
	size_t uncompressed_data_size = 7640;
	int result                    = 0;

	result = libfwnt_lzxpress_huffman_decompress(
	          fwnt_test_lzxpress_huffman_compressed_byte_stream,
	          2917,
	          uncompressed_data,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_FPRINT_ERROR( error )

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "uncompressed_data_size",
	 uncompressed_data_size,
	 7640 );

	/* Test error cases
	 */
	result = libfwnt_lzxpress_huffman_decompress(
	          NULL,
	          2917,
	          uncompressed_data,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	result = libfwnt_lzxpress_huffman_decompress(
	          fwnt_test_lzxpress_huffman_compressed_byte_stream,
	          (size_t) SSIZE_MAX + 1,
	          uncompressed_data,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	result = libfwnt_lzxpress_huffman_decompress(
	          fwnt_test_lzxpress_huffman_compressed_byte_stream,
	          2917,
	          NULL,
	          &uncompressed_data_size,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	result = libfwnt_lzxpress_huffman_decompress(
	          fwnt_test_lzxpress_huffman_compressed_byte_stream,
	          2917,
	          uncompressed_data,
	          NULL,
	          &error );

	FWNT_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

        FWNT_TEST_ASSERT_IS_NOT_NULL(
         "error",
         error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	return( 0 );
}

/* The main program
 */
#if defined( LIBCSTRING_HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc FWNT_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] FWNT_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc FWNT_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] FWNT_TEST_ATTRIBUTE_UNUSED )
#endif
{
	FWNT_TEST_UNREFERENCED_PARAMETER( argc )
	FWNT_TEST_UNREFERENCED_PARAMETER( argv )

#define FWNT_TEST_LZXPRESS
#if defined( HAVE_DEBUG_OUTPUT ) && defined( FWNT_TEST_LZXPRESS )
	libcnotify_verbose_set(
	 1 );
	libcnotify_stream_set(
	 stderr,
	 NULL );
#endif

	/* TODO add tests for libfwnt_lzxpress_compress */

	FWNT_TEST_RUN(
	 "libfwnt_lzxpress_decompress",
	 fwnt_test_lzxpress_decompress );

	FWNT_TEST_RUN(
	 "libfwnt_lzxpress_huffman_decompress",
	 fwnt_test_lzxpress_huffman_decompress );

	/* TODO add tests for libfwnt_lzxpress_huffman_stream_decompress */

	return( EXIT_SUCCESS );

on_error:
	return( EXIT_FAILURE );
}

