//
//  libavg - Media Playback Engine. 
//  Copyright (C) 2003-2011 Ulrich von Zadow
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  Current versions can be found at www.libavg.de
//

#ifndef _PBO_H_
#define _PBO_H_

#include "../api.h"
#include "TextureMover.h"

#include "Bitmap.h"
#include "OGLHelper.h"
#include "GLTexture.h"

#include "../base/Point.h"

#include <boost/shared_ptr.hpp>

namespace avg {

class AVG_API PBO: public TextureMover {
public:
    PBO(const IntPoint& size, PixelFormat pf, unsigned usage);
    virtual ~PBO();

    void activate();

    void moveBmpToTexture(BitmapPtr pBmp, GLTexture& tex);
    virtual BitmapPtr moveTextureToBmp(GLTexture& tex, int mipmapLevel=0);

    BitmapPtr lock();
    void unlock();
    void moveToTexture(GLTexture& tex);
    void moveTextureToPBO(GLTexture& tex, int mipmapLevel=0);
    BitmapPtr movePBOToBmp() const;

    bool isReadPBO() const;

private:
    unsigned getTarget() const;

    unsigned m_Usage;
    unsigned m_PBOID;
    IntPoint m_ActiveSize;
    int m_BufferStride;
};

typedef boost::shared_ptr<PBO> PBOPtr;

}

#endif
 

