# This file is generated by Lemonldap::NG::Manager::Build. Don't modify it by hand
package Lemonldap::NG::Manager::Attributes;

our $VERSION = '1.9.5';

sub types {
    return {
        'authParamsText' => {
            'test' => sub {
                1;
              }
        },
        'blackWhiteList' => {
            'test' => sub {
                1;
              }
        },
        'bool' => {
            'msgFail' => '__notABoolean__',
            'test'    => qr/^[01]$/
        },
        'boolOrExpr' => {
            'msgFail' => '__notAValidPerlExpression__',
            'test'    => sub {
                my ( $val, $conf ) = @_;
                my $s = '';
                my (@cf) = (
                    'encode_base64', 'checkLogonHours',
                    'date',          'checkDate',
                    'basic',         'unicode2iso',
                    'iso2unicode',   'groupMatch',
                    'encrypt'
                );
                push @cf, defined $conf->{'customFunctions'}
                  ? map( {
                        my $f = $_;
                          $f =~ s/\w+:://g;
                          $f, $_;
                    } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                  : ();
                foreach my $f (@cf) {
                    $s = "sub $f {1} $s";
                }
                eval "$s $val";
                return $@ ? ( 1, "__badExpression__: $@" ) : 1;
              }
        },
        'catAndAppList' => {
            'test' => sub {
                1;
              }
        },
        'file' => {
            'test' => sub {
                1;
              }
        },
        'hostname' => {
            'form'    => 'text',
            'msgFail' => '__badHostname__',
            'test' =>
qr/^(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))?$/
        },
        'int' => {
            'msgFail' => '__notAnInteger__',
            'test'    => qr/^\-?\d+$/
        },
        'keyText' => {
            'keyTest' => qr/^[a-zA-Z0-9_]+$/,
            'msgFail' => '__badValue__',
            'test'    => qr/^.*$/
        },
        'keyTextContainer' => {
            'keyMsgFail' => '__badKeyName__',
            'keyTest'    => qr/^\w[\w\.\-]*$/,
            'msgFail'    => '__emptyValueNotAllowed__',
            'test'       => qr/./
        },
        'lmAttrOrMacro' => {
            'form' => 'text',
            'test' => sub {
                my ( $val, $conf ) = @_;
                return 1
                  if defined $conf->{'macros'}{$val} or $val eq '_timezone';
                foreach $_ ( keys %$conf ) {
                    return 1
                      if $_ =~ /exportedvars$/i and defined $conf->{$_}{$val};
                }
                return 1, "__unknownAttrOrMacro__: $val";
              }
        },
        'longtext' => {
            'test' => sub {
                1;
              }
        },
        'menuApp' => {
            'test' => sub {
                1;
              }
        },
        'menuCat' => {
            'test' => sub {
                1;
              }
        },
        'oidcmetadatajson' => {
            'test' => sub {
                1;
              }
        },
        'oidcmetadatajwks' => {
            'test' => sub {
                1;
              }
        },
        'oidcOPMetaDataNode' => {
            'test' => sub {
                1;
              }
        },
        'oidcRPMetaDataNode' => {
            'test' => sub {
                1;
              }
        },
        'password' => {
            'msgFail' => '__malformedValue__',
            'test'    => sub {
                1;
              }
        },
        'pcre' => {
            'form' => 'text',
            'test' => sub {
                eval {
                    do {
                        qr/$_[0]/;
                      }
                };
                return $@ ? ( 0, "__badRegexp__: $@" ) : 1;
              }
        },
        'PerlModule' => {
            'form'    => 'text',
            'msgFail' => '__badPerlPackageName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9]*(?:::[a-zA-Z][a-zA-Z0-9]*)*$/
        },
        'portalskin' => {
            'test' => sub {
                1;
              }
        },
        'portalskinbackground' => {
            'test' => sub {
                1;
              }
        },
        'post' => {
            'test' => sub {
                1;
              }
        },
        'RSAPrivateKey' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+(?:RSA\s+)?PRIVATE\s+KEY\s*\-+\r?\n)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+(?:RSA\s+)PRIVATE\s+KEY\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
              }
        },
        'RSAPublicKey' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+PUBLIC\s+KEY\s*\-+\r?\n)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+PUBLIC\s+KEY\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
              }
        },
        'RSAPublicKeyOrCertificate' => {
            'test' => sub {
                return $_[0] =~
m[^(?:(?:\-+\s*BEGIN\s+(?:PUBLIC\s+KEY|CERTIFICATE)\s*\-+\r?\n)?[a-zA-Z0-9/\+\r\n]+={0,2}(?:\r?\n\-+\s*END\s+(?:PUBLIC\s+KEY|CERTIFICATE)\s*\-+)?[\r\n]*)?$]s
                  ? 1
                  : ( 1, '__badPemEncoding__' );
              }
        },
        'rule' => {
            'test' => sub {
                1;
              }
        },
        'samlAssertion' => {
            'test' => sub {
                1;
              }
        },
        'samlAttribute' => {
            'test' => sub {
                1;
              }
        },
        'samlIDPMetaDataNode' => {
            'test' => sub {
                1;
              }
        },
        'samlService' => {
            'test' => sub {
                1;
              }
        },
        'samlSPMetaDataNode' => {
            'test' => sub {
                1;
              }
        },
        'select' => {
            'test' => sub {
                my $test =
                  grep( { $_ eq $_[0]; }
                    map( { $_->{'k'}; } @{ $_[2]{'select'}; } ) );
                return $test
                  ? 1
                  : ( 0, "Invalid value '$_[0]' for this select" );
              }
        },
        'subContainer' => {
            'keyTest' => qr/\w/,
            'test'    => sub {
                1;
              }
        },
        'text' => {
            'msgFail' => '__malformedValue__',
            'test'    => sub {
                1;
              }
        },
        'trool' => {
            'msgFail' => '__authorizedValues__: -1, 0, 1',
            'test'    => qr/^(?:-1|0|1)$/
        },
        'url' => {
            'form'    => 'text',
            'msgFail' => '__badUrl__',
            'test' =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/
        }
    };
}

sub attributes {
    return {
        'activeTimer' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'ADPwdExpireWarning' => {
            'default' => 0,
            'type'    => 'int'
        },
        'ADPwdMaxAge' => {
            'default' => 0,
            'type'    => 'int'
        },
        'apacheAuthnLevel' => {
            'default' => 4,
            'type'    => 'int'
        },
        'applicationList' => {
            'default' => {
                'default' => {
                    'catname' => 'Default category',
                    'type'    => 'category'
                }
            },
            'keyTest' => qr/\w/,
            'type'    => 'catAndAppList'
        },
        'authChoiceModules' => {
            'keyMsgFail' => '__badChoiceKey__',
            'keyTest'    => qr/^(\d*)?[a-zA-Z0-9_]+$/,
            'select'     => [
                [
                    {
                        'k' => 'Apache',
                        'v' => 'Apache'
                    },
                    {
                        'k' => 'AD',
                        'v' => 'Active Directory'
                    },
                    {
                        'k' => 'BrowserID',
                        'v' => 'BrowserID (Mozilla Persona)'
                    },
                    {
                        'k' => 'CAS',
                        'v' => 'Central Authentication Service (CAS)'
                    },
                    {
                        'k' => 'DBI',
                        'v' => 'Database (DBI)'
                    },
                    {
                        'k' => 'Demo',
                        'v' => 'Demo'
                    },
                    {
                        'k' => 'Facebook',
                        'v' => 'Facebook'
                    },
                    {
                        'k' => 'Google',
                        'v' => 'Google'
                    },
                    {
                        'k' => 'LDAP',
                        'v' => 'LDAP'
                    },
                    {
                        'k' => 'Null',
                        'v' => 'None'
                    },
                    {
                        'k' => 'OpenID',
                        'v' => 'OpenID'
                    },
                    {
                        'k' => 'OpenIDConnect',
                        'v' => 'OpenID Connect'
                    },
                    {
                        'k' => 'Proxy',
                        'v' => 'Proxy'
                    },
                    {
                        'k' => 'Radius',
                        'v' => 'Radius'
                    },
                    {
                        'k' => 'Remote',
                        'v' => 'Remote'
                    },
                    {
                        'k' => 'SAML',
                        'v' => 'SAML v2'
                    },
                    {
                        'k' => 'Slave',
                        'v' => 'Slave'
                    },
                    {
                        'k' => 'SSL',
                        'v' => 'SSL'
                    },
                    {
                        'k' => 'Twitter',
                        'v' => 'Twitter'
                    },
                    {
                        'k' => 'WebID',
                        'v' => 'WebID'
                    },
                    {
                        'k' => 'Yubikey',
                        'v' => 'Yubikey'
                    }
                ],
                [
                    {
                        'k' => 'AD',
                        'v' => 'Active Directory'
                    },
                    {
                        'k' => 'DBI',
                        'v' => 'Database (DBI)'
                    },
                    {
                        'k' => 'Demo',
                        'v' => 'Demo'
                    },
                    {
                        'k' => 'Facebook',
                        'v' => 'Facebook'
                    },
                    {
                        'k' => 'Google',
                        'v' => 'Google'
                    },
                    {
                        'k' => 'LDAP',
                        'v' => 'LDAP'
                    },
                    {
                        'k' => 'Null',
                        'v' => 'None'
                    },
                    {
                        'k' => 'OpenID',
                        'v' => 'OpenID'
                    },
                    {
                        'k' => 'OpenIDConnect',
                        'v' => 'OpenID Connect'
                    },
                    {
                        'k' => 'Proxy',
                        'v' => 'Proxy'
                    },
                    {
                        'k' => 'Remote',
                        'v' => 'Remote'
                    },
                    {
                        'k' => 'SAML',
                        'v' => 'SAML v2'
                    },
                    {
                        'k' => 'Slave',
                        'v' => 'Slave'
                    },
                    {
                        'k' => 'WebID',
                        'v' => 'WebID'
                    }
                ],
                [
                    {
                        'k' => 'AD',
                        'v' => 'Active Directory'
                    },
                    {
                        'k' => 'DBI',
                        'v' => 'Database (DBI)'
                    },
                    {
                        'k' => 'Demo',
                        'v' => 'Demo'
                    },
                    {
                        'k' => 'LDAP',
                        'v' => 'LDAP'
                    },
                    {
                        'k' => 'Null',
                        'v' => 'None'
                    }
                ]
            ],
            'test' => sub {
                1;
            },
            'type' => 'authChoiceContainer'
        },
        'authChoiceParam' => {
            'default' => 'lmAuth',
            'type'    => 'text'
        },
        'authentication' => {
            'default' => 'Demo',
            'select'  => [
                {
                    'k' => 'Apache',
                    'v' => 'Apache'
                },
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'BrowserID',
                    'v' => 'BrowserID (Mozilla Persona)'
                },
                {
                    'k' => 'Choice',
                    'v' => 'authChoice'
                },
                {
                    'k' => 'CAS',
                    'v' => 'Central Authentication Service (CAS)'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'Facebook',
                    'v' => 'Facebook'
                },
                {
                    'k' => 'Google',
                    'v' => 'Google'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'Multi',
                    'v' => 'Multiple'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'OpenID',
                    'v' => 'OpenID'
                },
                {
                    'k' => 'OpenIDConnect',
                    'v' => 'OpenID Connect'
                },
                {
                    'k' => 'Proxy',
                    'v' => 'Proxy'
                },
                {
                    'k' => 'Radius',
                    'v' => 'Radius'
                },
                {
                    'k' => 'Remote',
                    'v' => 'Remote'
                },
                {
                    'k' => 'SAML',
                    'v' => 'SAML v2'
                },
                {
                    'k' => 'Slave',
                    'v' => 'Slave'
                },
                {
                    'k' => 'SSL',
                    'v' => 'SSL'
                },
                {
                    'k' => 'Twitter',
                    'v' => 'Twitter'
                },
                {
                    'k' => 'WebID',
                    'v' => 'WebID'
                },
                {
                    'k' => 'Yubikey',
                    'v' => 'Yubikey'
                }
            ],
            'type' => 'select'
        },
        'AuthLDAPFilter' => {
            'type' => 'text'
        },
        'browserIdAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'browserIdAutoLogin' => {
            'type' => 'bool'
        },
        'browserIdBackgroundColor' => {
            'type' => 'text'
        },
        'browserIdSiteLogo' => {
            'type' => 'text'
        },
        'browserIdSiteName' => {
            'type' => 'text'
        },
        'browserIdVerificationURL' => {
            'type' => 'text'
        },
        'captcha_login_enabled' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'captcha_mail_enabled' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'captcha_register_enabled' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'captcha_size' => {
            'default' => 6,
            'type'    => 'int'
        },
        'captchaStorage' => {
            'default' => 'Apache::Session::File',
            'type'    => 'PerlModule'
        },
        'captchaStorageOptions' => {
            'default' => {
                'Directory' => '/var/lib/lemonldap-ng/captcha/'
            },
            'type' => 'keyTextContainer'
        },
        'CAS_authnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'CAS_CAFile' => {
            'type' => 'text'
        },
        'CAS_gateway' => {
            'type' => 'bool'
        },
        'CAS_pgtFile' => {
            'default' => '/tmp/pgt.txt',
            'type'    => 'text'
        },
        'CAS_proxiedServices' => {
            'keyMsgFail' => '__badCasProxyId__',
            'keyTest'    => qr/^\w+$/,
            'type'       => 'keyTextContainer'
        },
        'CAS_renew' => {
            'type' => 'bool'
        },
        'CAS_url' => {
            'msgFail' => '__badUrl__',
            'test' =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'casAccessControlPolicy' => {
            'default' => 'none',
            'select'  => [
                {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'error',
                    'v' => 'Display error on portal'
                },
                {
                    'k' => 'faketicket',
                    'v' => 'Send a fake service ticket'
                }
            ],
            'type' => 'select'
        },
        'casAttr' => {
            'type' => 'text'
        },
        'casAttributes' => {
            'type' => 'keyTextContainer'
        },
        'casStorage' => {
            'type' => 'PerlModule'
        },
        'casStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'cda' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'cfgAuthor' => {
            'type' => 'text'
        },
        'cfgAuthorIP' => {
            'type' => 'text'
        },
        'cfgDate' => {
            'type' => 'int'
        },
        'cfgLog' => {
            'type' => 'longtext'
        },
        'cfgNum' => {
            'default' => 0,
            'type'    => 'int'
        },
        'checkXSS' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'confirmFormMethod' => {
            'default' => 'post',
            'select'  => [
                {
                    'k' => 'get',
                    'v' => 'GET'
                },
                {
                    'k' => 'post',
                    'v' => 'POST'
                }
            ],
            'type' => 'select'
        },
        'cookieExpiration' => {
            'type' => 'text'
        },
        'cookieName' => {
            'default' => 'lemonldap',
            'msgFail' => '__badCookieName__',
            'test'    => qr/^[a-zA-Z][a-zA-Z0-9_-]*$/,
            'type'    => 'text'
        },
        'customFunctions' => {
            'msgFail' => '__badCustomFuncName__',
            'test'    => qr/^(?:\w+(?:::\w+)*(?:\s+\w+(?:::\w+)*)*)?$/,
            'type'    => 'text'
        },
        'dbiAuthChain' => {
            'type' => 'text'
        },
        'dbiAuthLoginCol' => {
            'type' => 'text'
        },
        'dbiAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'dbiAuthPassword' => {
            'type' => 'password'
        },
        'dbiAuthPasswordCol' => {
            'type' => 'text'
        },
        'dbiAuthPasswordHash' => {
            'type' => 'text'
        },
        'dbiAuthTable' => {
            'type' => 'text'
        },
        'dbiAuthUser' => {
            'type' => 'text'
        },
        'dbiExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'dbiPasswordMailCol' => {
            'type' => 'text'
        },
        'dbiUserChain' => {
            'type' => 'text'
        },
        'dbiUserPassword' => {
            'type' => 'password'
        },
        'dbiUserTable' => {
            'type' => 'text'
        },
        'dbiUserUser' => {
            'type' => 'text'
        },
        'demoExportedVars' => {
            'default' => {
                'cn'   => 'cn',
                'mail' => 'mail',
                'uid'  => 'uid'
            },
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'domain' => {
            'default' => 'example.com',
            'msgFail' => '__badDomainName__',
            'test' =>
qr/^(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?))?/,
            'type' => 'text'
        },
        'exportedAttr' => {
            'type' => 'text'
        },
        'exportedHeaders' => {
            'keyMsgFail' => '__badHostname__',
            'keyTest' =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'test' => {
                'keyMsgFail' => '__badHeaderName__',
                'keyTest'    => qr/^(?=[^\-])[\w\-]+(?<=[^-])$/,
                'test'       => sub {
                    my ( $val, $conf ) = @_;
                    my $s = $val;
                    my (@cf) = (
                        'encode_base64', 'checkLogonHours',
                        'date',          'checkDate',
                        'basic',         'unicode2iso',
                        'iso2unicode',   'groupMatch',
                        'encrypt'
                    );
                    push @cf, defined $conf->{'customFunctions'}
                      ? map( {
                            my $f = $_;
                              $f =~ s/\w+:://g;
                              $f, $_;
                        } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                      : ();
                    foreach my $f (@cf) {
                        $s = "sub $f {1} $s";
                    }
                    eval $s;
                    return $@ ? ( 1, "__badExpression__: $@" ) : 1;
                  }
            },
            'type' => 'keyTextContainer'
        },
        'exportedVars' => {
            'default' => {
                'UA' => 'HTTP_USER_AGENT'
            },
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[_a-zA-Z][a-zA-Z0-9_]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[_a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'facebookAppId' => {
            'type' => 'text'
        },
        'facebookAppSecret' => {
            'type' => 'text'
        },
        'facebookAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'facebookExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'failedLoginNumber' => {
            'default' => 5,
            'type'    => 'int'
        },
        'globalStorage' => {
            'default' => 'Apache::Session::File',
            'type'    => 'PerlModule'
        },
        'globalStorageOptions' => {
            'default' => {
                'Directory' => '/var/lib/lemonldap-ng/sessions/',
                'generateModule' =>
                  'Lemonldap::NG::Common::Apache::Session::Generate::SHA256',
                'LockDirectory' => '/var/lib/lemonldap-ng/sessions/lock/'
            },
            'type' => 'keyTextContainer'
        },
        'googleAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'googleExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'grantSessionRules' => {
            'keyTest' => sub {
                my ( $val, $conf ) = @_;
                my $s = '';
                my (@cf) = (
                    'encode_base64', 'checkLogonHours',
                    'date',          'checkDate',
                    'basic',         'unicode2iso',
                    'iso2unicode',   'groupMatch',
                    'encrypt'
                );
                push @cf, defined $conf->{'customFunctions'}
                  ? map( {
                        my $f = $_;
                          $f =~ s/\w+:://g;
                          $f, $_;
                    } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                  : ();
                foreach my $f (@cf) {
                    $s = "sub $f {1} $s";
                }
                eval "$s $val";
                return $@ ? ( 1, "__badExpression__: $@" ) : 1;
            },
            'test' => sub {
                1;
            },
            'type' => 'grantContainer'
        },
        'groups' => {
            'default' => {},
            'test'    => sub {
                my ( $val, $conf ) = @_;
                my $s = '';
                my (@cf) = (
                    'encode_base64', 'checkLogonHours',
                    'date',          'checkDate',
                    'basic',         'unicode2iso',
                    'iso2unicode',   'groupMatch',
                    'encrypt'
                );
                push @cf, defined $conf->{'customFunctions'}
                  ? map( {
                        my $f = $_;
                          $f =~ s/\w+:://g;
                          $f, $_;
                    } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                  : ();
                foreach my $f (@cf) {
                    $s = "sub $f {1} $s";
                }
                eval "$s $val";
                return $@ ? ( 1, "__badExpression__: $@" ) : 1;
            },
            'type' => 'keyTextContainer'
        },
        'hiddenAttributes' => {
            'default' => '_password',
            'type'    => 'text'
        },
        'hideOldPassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'httpOnly' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'https' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'infoFormMethod' => {
            'default' => 'get',
            'select'  => [
                {
                    'k' => 'get',
                    'v' => 'GET'
                },
                {
                    'k' => 'post',
                    'v' => 'POST'
                }
            ],
            'type' => 'select'
        },
        'issuerDBCASActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBCASPath' => {
            'default' => '^/cas/',
            'type'    => 'pcre'
        },
        'issuerDBCASRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBGetActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBGetParameters' => {
            'default'    => {},
            'keyMsgFail' => '__badHostname__',
            'keyTest' =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'test' => {
                'keyMsgFail' => '__badKeyName__',
                'keyTest'    => qr/^(?=[^\-])[\w\-]+(?<=[^-])$/,
                'test'       => sub {
                    my ( $val, $conf ) = @_;
                    return 1
                      if defined $conf->{'macros'}{$val} or $val eq '_timezone';
                    foreach $_ ( keys %$conf ) {
                        return 1
                          if $_ =~ /exportedvars$/i
                          and defined $conf->{$_}{$val};
                    }
                    return 1, "__unknownAttrOrMacro__: $val";
                  }
            },
            'type' => 'doubleHash'
        },
        'issuerDBGetPath' => {
            'default' => '^/get/',
            'type'    => 'text'
        },
        'issuerDBGetRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBOpenIDActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBOpenIDConnectActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBOpenIDConnectPath' => {
            'default' => '^/oauth2/',
            'type'    => 'text'
        },
        'issuerDBOpenIDConnectRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBOpenIDPath' => {
            'default' => '^/openidserver/',
            'type'    => 'pcre'
        },
        'issuerDBOpenIDRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'issuerDBSAMLActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'issuerDBSAMLPath' => {
            'default' => '^/saml/',
            'type'    => 'pcre'
        },
        'issuerDBSAMLRule' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'jsRedirect' => {
            'default' => 0,
            'type'    => 'boolOrExpr'
        },
        'key' => {
            'type' => 'password'
        },
        'ldapAllowResetExpiredPassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'ldapBase' => {
            'default' => 'dc=example,dc=com',
            'msgFail' => '__badValue__',
            'test'    => qr/^(?:\w+=.*|)$/,
            'type'    => 'text'
        },
        'ldapChangePasswordAsUser' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapExportedVars' => {
            'default' => {
                'cn'   => 'cn',
                'mail' => 'mail',
                'uid'  => 'uid'
            },
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'LDAPFilter' => {
            'type' => 'text'
        },
        'ldapGroupAttributeName' => {
            'default' => 'member',
            'type'    => 'text'
        },
        'ldapGroupAttributeNameGroup' => {
            'default' => 'dn',
            'type'    => 'text'
        },
        'ldapGroupAttributeNameSearch' => {
            'default' => 'cn',
            'type'    => 'text'
        },
        'ldapGroupAttributeNameUser' => {
            'default' => 'dn',
            'type'    => 'text'
        },
        'ldapGroupBase' => {
            'type' => 'text'
        },
        'ldapGroupObjectClass' => {
            'default' => 'groupOfNames',
            'type'    => 'text'
        },
        'ldapGroupRecursive' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapPasswordResetAttribute' => {
            'default' => 'pwdReset',
            'type'    => 'text'
        },
        'ldapPasswordResetAttributeValue' => {
            'default' => 'TRUE',
            'type'    => 'text'
        },
        'ldapPort' => {
            'default' => 389,
            'type'    => 'int'
        },
        'ldapPpolicyControl' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapPwdEnc' => {
            'default' => 'utf-8',
            'msgFail' => '__badEncoding__',
            'test'    => qr/^[a-zA-Z0-9_][a-zA-Z0-9_\-]*[a-zA-Z0-9_]$/,
            'type'    => 'text'
        },
        'ldapRaw' => {
            'type' => 'text'
        },
        'ldapSearchDeref' => {
            'default' => 'find',
            'select'  => [
                {
                    'k' => 'never',
                    'v' => 'never'
                },
                {
                    'k' => 'search',
                    'v' => 'search'
                },
                {
                    'k' => 'find',
                    'v' => 'find'
                },
                {
                    'k' => 'always',
                    'v' => 'always'
                }
            ],
            'type' => 'select'
        },
        'ldapServer' => {
            'default' => 'ldap://localhost',
            'test'    => sub {
                my $l = shift();
                my @s = split( /[\s,]+/, $l, 0 );
                foreach my $s (@s) {
                    return 0, qq[__badLdapUri__: "$s"]
                      unless $s =~
m[^(?:ldapi://[^/]*/?|\w[\w\-\.]*(?::\d{1,5})?|ldap(?:s|\+tls)?://\w[\w\-\.]*(?::\d{1,5})?/?.*)$]o;
                }
                return 1;
            },
            'type' => 'text'
        },
        'ldapSetPassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'ldapTimeout' => {
            'default' => 120,
            'type'    => 'int'
        },
        'ldapUsePasswordResetAttribute' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'ldapVersion' => {
            'default' => 3,
            'type'    => 'int'
        },
        'localSessionStorage' => {
            'default' => 'Cache::FileCache',
            'type'    => 'PerlModule'
        },
        'localSessionStorageOptions' => {
            'default' => {
                'cache_depth'        => 3,
                'cache_root'         => '/tmp',
                'default_expires_in' => 600,
                'directory_umask'    => '007',
                'namespace'          => 'lemonldap-ng-sessions'
            },
            'type' => 'keyTextContainer'
        },
        'locationRules' => {
            'default' => {
                'default' => 'deny'
            },
            'keyMsgFail' => '__badHostname__',
            'keyTest' =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'test' => {
                'keyMsgFail' => '__badRegexp__',
                'keyTest'    => sub {
                    eval {
                        do {
                            qr/$_[0]/;
                          }
                    };
                    return $@ ? 0 : 1;
                },
                'msgFail' => '__badExpression__',
                'test'    => sub {
                    my ( $val, $conf ) = @_;
                    my $s = $val;
                    if ( $s =~ s/^logout(?:_(?:sso|app(?:_sso)?))?\s*// ) {
                        return $s =~ m[^(?:https?://.*)?$]
                          ? 1
                          : ( 0, '__badUrl__' );
                    }
                    $s =~ s/\b(accept|deny|unprotect|skip)\b/1/g;
                    my (@cf) = (
                        'encode_base64', 'checkLogonHours',
                        'date',          'checkDate',
                        'basic',         'unicode2iso',
                        'iso2unicode',   'groupMatch',
                        'encrypt'
                    );
                    push @cf, defined $conf->{'customFunctions'}
                      ? map( {
                            my $f = $_;
                              $f =~ s/\w+:://g;
                              $f, $_;
                        } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                      : ();
                    foreach my $f (@cf) {
                        $s = "sub $f {1} $s";
                    }
                    eval $s;
                    return $@ ? ( 1, "__badExpression__: $@" ) : 1;
                  }
            },
            'type' => 'ruleContainer'
        },
        'loginHistoryEnabled' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'logoutServices' => {
            'default' => {},
            'type'    => 'keyTextContainer'
        },
        'macros' => {
            'default'    => {},
            'keyMsgFail' => '__badMacroName__',
            'keyTest'    => qr/^[_a-zA-Z][a-zA-Z0-9_]*$/,
            'test'       => sub {
                my ( $val, $conf ) = @_;
                my $s = '';
                my (@cf) = (
                    'encode_base64', 'checkLogonHours',
                    'date',          'checkDate',
                    'basic',         'unicode2iso',
                    'iso2unicode',   'groupMatch',
                    'encrypt'
                );
                push @cf, defined $conf->{'customFunctions'}
                  ? map( {
                        my $f = $_;
                          $f =~ s/\w+:://g;
                          $f, $_;
                    } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                  : ();
                foreach my $f (@cf) {
                    $s = "sub $f {1} $s";
                }
                eval "$s $val";
                return $@ ? ( 1, "__badExpression__: $@" ) : 1;
            },
            'type' => 'keyTextContainer'
        },
        'mailBody' => {
            'type' => 'longtext'
        },
        'mailCharset' => {
            'default' => 'utf-8',
            'type'    => 'text'
        },
        'mailConfirmBody' => {
            'type' => 'longtext'
        },
        'mailConfirmSubject' => {
            'default' => '[LemonLDAP::NG] Password reset confirmation',
            'type'    => 'text'
        },
        'mailFrom' => {
            'default' => 'noreply@example.com',
            'type'    => 'text'
        },
        'mailLDAPFilter' => {
            'type' => 'text'
        },
        'mailOnPasswordChange' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'mailReplyTo' => {
            'type' => 'text'
        },
        'mailSessionKey' => {
            'default' => 'mail',
            'type'    => 'text'
        },
        'mailSubject' => {
            'default' => '[LemonLDAP::NG] Your new password',
            'type'    => 'text'
        },
        'mailTimeout' => {
            'default' => 0,
            'type'    => 'int'
        },
        'mailUrl' => {
            'default' => 'http://auth.example.com/mail.pl',
            'type'    => 'url'
        },
        'maintenance' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'managerDn' => {
            'default' => '',
            'msgFail' => '__badValue__',
            'test'    => qr/^(?:\w+=.*)?$/,
            'type'    => 'text'
        },
        'managerPassword' => {
            'default' => '',
            'msgFail' => '__badValue__',
            'test'    => qr/^\S*$/,
            'type'    => 'password'
        },
        'multiAuthStack' => {
            'type' => 'authParamsText'
        },
        'multiUserDBStack' => {
            'type' => 'authParamsText'
        },
        'multiValuesSeparator' => {
            'default' => '; ',
            'type'    => 'authParamsText'
        },
        'noAjaxHook' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notification' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'notificationStorage' => {
            'default' => 'File',
            'type'    => 'PerlModule'
        },
        'notificationStorageOptions' => {
            'default' => {
                'dirName' => '/var/lib/lemonldap-ng/notifications'
            },
            'type' => 'keyTextContainer'
        },
        'notificationWildcard' => {
            'default' => 'allusers',
            'type'    => 'text'
        },
        'notificationXSLTfile' => {
            'type' => 'text'
        },
        'notifyDeleted' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'notifyOther' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'nullAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'oidcAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'oidcOPMetaDataExportedVars' => {
            'default' => {
                'cn'   => 'name',
                'mail' => 'email',
                'sn'   => 'family_name',
                'uid'  => 'sub'
            },
            'type' => 'keyTextContainer'
        },
        'oidcOPMetaDataJSON' => {
            'type' => 'file'
        },
        'oidcOPMetaDataJWKS' => {
            'type' => 'file'
        },
        'oidcOPMetaDataNodes' => {
            'type' => 'oidcOPMetaDataNodeContainer'
        },
        'oidcOPMetaDataOptions' => {
            'type' => 'subContainer'
        },
        'oidcOPMetaDataOptionsAcrValues' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsCheckJWTSignature' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'oidcOPMetaDataOptionsClientID' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsClientSecret' => {
            'type' => 'password'
        },
        'oidcOPMetaDataOptionsConfigurationURI' => {
            'type' => 'url'
        },
        'oidcOPMetaDataOptionsDisplay' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'page',
                    'v' => 'page'
                },
                {
                    'k' => 'popup',
                    'v' => 'popup'
                },
                {
                    'k' => 'touch',
                    'v' => 'touch'
                },
                {
                    'k' => 'wap',
                    'v' => 'wap'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsIcon' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsIDTokenMaxAge' => {
            'default' => 30,
            'type'    => 'int'
        },
        'oidcOPMetaDataOptionsJWKSTimeout' => {
            'default' => 0,
            'type'    => 'int'
        },
        'oidcOPMetaDataOptionsMaxAge' => {
            'default' => 0,
            'type'    => 'int'
        },
        'oidcOPMetaDataOptionsPrompt' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsScope' => {
            'default' => 'openid profile',
            'type'    => 'text'
        },
        'oidcOPMetaDataOptionsTokenEndpointAuthMethod' => {
            'default' => 'client_secret_post',
            'select'  => [
                {
                    'k' => 'client_secret_post',
                    'v' => 'client_secret_post'
                },
                {
                    'k' => 'client_secret_basic',
                    'v' => 'client_secret_basic'
                }
            ],
            'type' => 'select'
        },
        'oidcOPMetaDataOptionsUiLocales' => {
            'type' => 'text'
        },
        'oidcOPMetaDataOptionsUseNonce' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'oidcRPCallbackGetParam' => {
            'default' => 'openidconnectcallback',
            'type'    => 'text'
        },
        'oidcRPMetaDataExportedVars' => {
            'default' => {
                'email'       => 'mail',
                'family_name' => 'sn',
                'name'        => 'cn'
            },
            'type' => 'keyTextContainer'
        },
        'oidcRPMetaDataNodes' => {
            'type' => 'oidcRPMetaDataNodeContainer'
        },
        'oidcRPMetaDataOptions' => {
            'type' => 'subContainer'
        },
        'oidcRPMetaDataOptionsAccessTokenExpiration' => {
            'default' => 3600,
            'type'    => 'int'
        },
        'oidcRPMetaDataOptionsClientID' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsClientSecret' => {
            'type' => 'password'
        },
        'oidcRPMetaDataOptionsDisplayName' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsExtraClaims' => {
            'type' => 'keyTextContainer'
        },
        'oidcRPMetaDataOptionsIcon' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsIDTokenExpiration' => {
            'default' => 3600,
            'type'    => 'int'
        },
        'oidcRPMetaDataOptionsIDTokenSignAlg' => {
            'default' => 'HS512',
            'select'  => [
                {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'HS256',
                    'v' => 'HS256'
                },
                {
                    'k' => 'HS384',
                    'v' => 'HS384'
                },
                {
                    'k' => 'HS512',
                    'v' => 'HS512'
                },
                {
                    'k' => 'RS256',
                    'v' => 'RS256'
                },
                {
                    'k' => 'RS384',
                    'v' => 'RS384'
                },
                {
                    'k' => 'RS512',
                    'v' => 'RS512'
                }
            ],
            'type' => 'select'
        },
        'oidcRPMetaDataOptionsRedirectUris' => {
            'type' => 'text'
        },
        'oidcRPMetaDataOptionsUserIDAttr' => {
            'type' => 'text'
        },
        'oidcRPStateTimeout' => {
            'default' => 600,
            'type'    => 'int'
        },
        'oidcServiceAllowAuthorizationCodeFlow' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'oidcServiceAllowDynamicRegistration' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceAllowHybridFlow' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceAllowImplicitFlow' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'oidcServiceKeyIdSig' => {
            'type' => 'text'
        },
        'oidcServiceMetaDataAuthnContext' => {
            'default' => {
                'loa-1' => 1,
                'loa-2' => 2,
                'loa-3' => 3,
                'loa-4' => 4,
                'loa-5' => 5
            },
            'keyTest' => qr/\w/,
            'type'    => 'keyTextContainer'
        },
        'oidcServiceMetaDataAuthorizeURI' => {
            'default' => 'authorize',
            'type'    => 'text'
        },
        'oidcServiceMetaDataCheckSessionURI' => {
            'default' => 'checksession',
            'type'    => 'text'
        },
        'oidcServiceMetaDataEndSessionURI' => {
            'default' => 'logout',
            'type'    => 'text'
        },
        'oidcServiceMetaDataIssuer' => {
            'default' => 'http://auth.example.com',
            'type'    => 'text'
        },
        'oidcServiceMetaDataJWKSURI' => {
            'default' => 'jwks',
            'type'    => 'text'
        },
        'oidcServiceMetaDataRegistrationURI' => {
            'default' => 'register',
            'type'    => 'text'
        },
        'oidcServiceMetaDataTokenURI' => {
            'default' => 'token',
            'type'    => 'text'
        },
        'oidcServiceMetaDataUserInfoURI' => {
            'default' => 'userinfo',
            'type'    => 'text'
        },
        'oidcServicePrivateKeySig' => {
            'type' => 'RSAPrivateKey'
        },
        'oidcServicePublicKeySig' => {
            'type' => 'RSAPublicKey'
        },
        'oidcStorage' => {
            'type' => 'PerlModule'
        },
        'oidcStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'openIdAttr' => {
            'type' => 'text'
        },
        'openIdAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'openIdExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'openIdIDPList' => {
            'default' => '0;',
            'type'    => 'blackWhiteList'
        },
        'openIdIssuerSecret' => {
            'type' => 'text'
        },
        'openIdSecret' => {
            'type' => 'text'
        },
        'openIdSPList' => {
            'default' => '0;',
            'type'    => 'blackWhiteList'
        },
        'openIdSreg_country' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_dob' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_email' => {
            'default' => 'mail',
            'type'    => 'lmAttrOrMacro'
        },
        'openIdSreg_fullname' => {
            'default' => 'cn',
            'type'    => 'lmAttrOrMacro'
        },
        'openIdSreg_gender' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_language' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_nickname' => {
            'default' => 'uid',
            'type'    => 'lmAttrOrMacro'
        },
        'openIdSreg_postcode' => {
            'type' => 'lmAttrOrMacro'
        },
        'openIdSreg_timezone' => {
            'default' => '_timezone',
            'type'    => 'lmAttrOrMacro'
        },
        'passwordDB' => {
            'default' => 'Demo',
            'select'  => [
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'Choice',
                    'v' => 'authChoice'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                }
            ],
            'type' => 'select'
        },
        'persistentStorage' => {
            'type' => 'PerlModule'
        },
        'persistentStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'port' => {
            'type' => 'int'
        },
        'portal' => {
            'default' => 'http://auth.example.com/',
            'type'    => 'url'
        },
        'portalAntiFrame' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalCheckLogins' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalDisplayAppslist' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalDisplayChangePassword' => {
            'default' => '$_auth =~ /^(LDAP|DBI|Demo)$/',
            'type'    => 'boolOrExpr'
        },
        'portalDisplayLoginHistory' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalDisplayLogout' => {
            'default' => 1,
            'type'    => 'boolOrExpr'
        },
        'portalDisplayRegister' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalDisplayResetPassword' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalForceAuthn' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalForceAuthnInterval' => {
            'default' => 5,
            'type'    => 'int'
        },
        'portalOpenLinkInNewWindow' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'portalPingInterval' => {
            'default' => 60000,
            'type'    => 'int'
        },
        'portalRequireOldPassword' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'portalSkin' => {
            'default' => 'bootstrap',
            'select'  => [
                {
                    'k' => 'bootstrap',
                    'v' => 'Bootstrap'
                },
                {
                    'k' => 'pastel',
                    'v' => 'Pastel'
                },
                {
                    'k' => 'impact',
                    'v' => 'Impact'
                },
                {
                    'k' => 'dark',
                    'v' => 'Dark'
                }
            ],
            'type' => 'portalskin'
        },
        'portalSkinBackground' => {
            'select' => [
                {
                    'k' => '',
                    'v' => 'None'
                },
                {
                    'k' => '1280px-Anse_Source_d\'Argent_2-La_Digue.jpg',
                    'v' => 'Anse'
                },
                {
                    'k' =>
'1280px-Autumn-clear-water-waterfall-landscape_-_Virginia_-_ForestWander.jpg',
                    'v' => 'Waterfall'
                },
                {
                    'k' => '1280px-BrockenSnowedTrees.jpg',
                    'v' => 'Snowed Trees'
                },
                {
                    'k' =>
                      '1280px-Cedar_Breaks_National_Monument_partially.jpg',
                    'v' => 'National Monument'
                },
                {
                    'k' => '1280px-Parry_Peak_from_Winter_Park.jpg',
                    'v' => 'Winter'
                },
                {
                    'k' => 'Aletschgletscher_mit_Pinus_cembra1.jpg',
                    'v' => 'Pinus'
                }
            ],
            'type' => 'portalskinbackground'
        },
        'portalSkinRules' => {
            'keyMsgFail' => '__badSkinRule__',
            'keyTest'    => sub {
                my ( $val, $conf ) = @_;
                my $s = '';
                my (@cf) = (
                    'encode_base64', 'checkLogonHours',
                    'date',          'checkDate',
                    'basic',         'unicode2iso',
                    'iso2unicode',   'groupMatch',
                    'encrypt'
                );
                push @cf, defined $conf->{'customFunctions'}
                  ? map( {
                        my $f = $_;
                          $f =~ s/\w+:://g;
                          $f, $_;
                    } split( /\s+/, $conf->{'customFunctions'}, 0 ) )
                  : ();
                foreach my $f (@cf) {
                    $s = "sub $f {1} $s";
                }
                eval "$s $val";
                return $@ ? ( 1, "__badExpression__: $@" ) : 1;
            },
            'msgFail' => '__badValue__',
            'test'    => qr/^\w+$/,
            'type'    => 'keyTextContainer'
        },
        'portalUserAttr' => {
            'default' => '_user',
            'type'    => 'text'
        },
        'post' => {
            'keyMsgFail' => '__badHostname__',
            'keyTest' =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'test' => sub {
                1;
            },
            'type' => 'postContainer'
        },
        'protection' => {
            'default' => 'none',
            'msgFail' => '__authorizedValues__: none authenticate manager',
            'test'    => qr/^(?:none|authenticate|manager|)$/,
            'type'    => 'text'
        },
        'radiusAuthnLevel' => {
            'default' => 3,
            'type'    => 'int'
        },
        'radiusSecret' => {
            'type' => 'text'
        },
        'radiusServer' => {
            'type' => 'text'
        },
        'randomPasswordRegexp' => {
            'default' => '[A-Z]{3}[a-z]{5}.\\d{2}',
            'type'    => 'pcre'
        },
        'redirectFormMethod' => {
            'default' => 'get',
            'select'  => [
                {
                    'k' => 'get',
                    'v' => 'GET'
                },
                {
                    'k' => 'post',
                    'v' => 'POST'
                }
            ],
            'type' => 'select'
        },
        'registerConfirmSubject' => {
            'default' => '[LemonLDAP::NG] Account register confirmation',
            'type'    => 'text'
        },
        'registerDB' => {
            'default' => 'Demo',
            'select'  => [
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                }
            ],
            'type' => 'select'
        },
        'registerDoneSubject' => {
            'default' => '[LemonLDAP::NG] Your new account',
            'type'    => 'text'
        },
        'registerTimeout' => {
            'default' => 0,
            'type'    => 'int'
        },
        'registerUrl' => {
            'default' => 'http://auth.example.com/register.pl',
            'type'    => 'text'
        },
        'reloadUrls' => {
            'keyTest' =>
qr/^(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+))(?::\d+)?$/,
            'msgFail' => '__badUrl__',
            'test' =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'keyTextContainer'
        },
        'remoteCookieName' => {
            'type' => 'text'
        },
        'remoteGlobalStorage' => {
            'default' => 'Lemonldap::NG::Common::Apache::Session::SOAP',
            'type'    => 'PerlModule'
        },
        'remoteGlobalStorageOptions' => {
            'default' => {
                'ns' =>
                  'http://auth.example.com/Lemonldap/NG/Common/CGI/SOAPService',
                'proxy' => 'http://auth.example.com/index.pl/sessions'
            },
            'type' => 'keyTextContainer'
        },
        'remotePortal' => {
            'type' => 'text'
        },
        'samlAttributeAuthorityDescriptorAttributeServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/AA/SOAP;',
            'type' => 'samlService'
        },
        'samlAuthnContextMapKerberos' => {
            'default' => 4,
            'type'    => 'int'
        },
        'samlAuthnContextMapPassword' => {
            'default' => 2,
            'type'    => 'int'
        },
        'samlAuthnContextMapPasswordProtectedTransport' => {
            'default' => 3,
            'type'    => 'int'
        },
        'samlAuthnContextMapTLSClient' => {
            'default' => 5,
            'type'    => 'int'
        },
        'samlCommonDomainCookieActivation' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlCommonDomainCookieDomain' => {
            'msgFail' => '__badDomainName__',
            'test' =>
qr/^(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)$/,
            'type' => 'text'
        },
        'samlCommonDomainCookieReader' => {
            'msgFail' => '__badUrl__',
            'test' =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'samlCommonDomainCookieWriter' => {
            'msgFail' => '__badUrl__',
            'test' =>
qr/(?:(?:https?):\/\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)))(?::(?:(?:[0-9]*)))?(?:\/(?:(?:(?:(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*)(?:\/(?:(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)(?:;(?:(?:[a-zA-Z0-9\-_.!~*'():@&=+\$,]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*))*))*))(?:[?](?:(?:(?:[;\/?:@&=+\$,a-zA-Z0-9\-_.!~*'()]+|(?:%[a-fA-F0-9][a-fA-F0-9]))*)))?))?)/,
            'type' => 'text'
        },
        'samlEntityID' => {
            'default' => '#PORTAL#/saml/metadata',
            'type'    => 'text'
        },
        'samlIDPMetaDataExportedAttributes' => {
            'default'    => {},
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/\w/,
            'type'       => 'samlAttributeContainer'
        },
        'samlIDPMetaDataNodes' => {
            'type' => 'samlIDPMetaDataNodeContainer'
        },
        'samlIDPMetaDataOptions' => {
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'type'       => 'keyTextContainer'
        },
        'samlIDPMetaDataOptionsAdaptSessionUtime' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsAllowLoginFromIDP' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsAllowProxiedAuthn' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckConditions' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckSLOMessageSignature' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsCheckSSOMessageSignature' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsEncryptionMode' => {
            'default' => 'none',
            'select'  => [
                {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'nameid',
                    'v' => 'Name ID'
                },
                {
                    'k' => 'assertion',
                    'v' => 'Assertion'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsForceAuthn' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsForceUTF8' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsIsPassive' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlIDPMetaDataOptionsNameIDFormat' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'unspecified',
                    'v' => 'Unspecified'
                },
                {
                    'k' => 'email',
                    'v' => 'Email'
                },
                {
                    'k' => 'x509',
                    'v' => 'X509 certificate'
                },
                {
                    'k' => 'windows',
                    'v' => 'Windows'
                },
                {
                    'k' => 'kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'entity',
                    'v' => 'Entity'
                },
                {
                    'k' => 'persistent',
                    'v' => 'Persistent'
                },
                {
                    'k' => 'transient',
                    'v' => 'Transient'
                },
                {
                    'k' => 'encrypted',
                    'v' => 'Encrypted'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsRequestedAuthnContext' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'password-protected-transport',
                    'v' => 'Password protected transport'
                },
                {
                    'k' => 'password',
                    'v' => 'Password'
                },
                {
                    'k' => 'tls-client',
                    'v' => 'TLS client certificate'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsSignSLOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlIDPMetaDataOptionsSignSSOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlIDPMetaDataOptionsSLOBinding' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'http-post',
                    'v' => 'POST'
                },
                {
                    'k' => 'http-redirect',
                    'v' => 'Redirect'
                },
                {
                    'k' => 'http-soap',
                    'v' => 'SOAP'
                },
                {
                    'k' => 'artifact-get',
                    'v' => 'Artifact GET'
                },
                {
                    'k' => 'artifact-post',
                    'v' => 'Artifact POST'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataOptionsSSOBinding' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'http-post',
                    'v' => 'POST'
                },
                {
                    'k' => 'http-redirect',
                    'v' => 'Redirect'
                },
                {
                    'k' => 'http-soap',
                    'v' => 'SOAP'
                },
                {
                    'k' => 'artifact-get',
                    'v' => 'Artifact GET'
                },
                {
                    'k' => 'artifact-post',
                    'v' => 'Artifact POST'
                }
            ],
            'type' => 'select'
        },
        'samlIDPMetaDataXML' => {
            'type' => 'file'
        },
        'samlIdPResolveCookie' => {
            'default' => 'lemonldapidp',
            'type'    => 'text'
        },
        'samlIDPSSODescriptorArtifactResolutionServiceArtifact' => {
            'default' =>
'1;0;urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/artifact',
            'type' => 'samlAssertion'
        },
        'samlIDPSSODescriptorSingleLogoutServiceHTTPPost' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/singleLogout;#PORTAL#/saml/singleLogoutReturn',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleLogoutServiceHTTPRedirect' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect;#PORTAL#/saml/singleLogout;#PORTAL#/saml/singleLogoutReturn',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleLogoutServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/singleLogoutSOAP;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceHTTPArtifact' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact;#PORTAL#/saml/singleSignOnArtifact;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceHTTPPost' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/singleSignOn;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceHTTPRedirect' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect;#PORTAL#/saml/singleSignOn;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorSingleSignOnServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/singleSignOnSOAP;',
            'type' => 'samlService'
        },
        'samlIDPSSODescriptorWantAuthnRequestsSigned' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlMetadataForceUTF8' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlNameIDFormatMapEmail' => {
            'default' => 'mail',
            'type'    => 'text'
        },
        'samlNameIDFormatMapKerberos' => {
            'default' => 'uid',
            'type'    => 'text'
        },
        'samlNameIDFormatMapWindows' => {
            'default' => 'uid',
            'type'    => 'text'
        },
        'samlNameIDFormatMapX509' => {
            'default' => 'mail',
            'type'    => 'text'
        },
        'samlOrganizationDisplayName' => {
            'default' => 'Example',
            'type'    => 'text'
        },
        'samlOrganizationName' => {
            'default' => 'Example',
            'type'    => 'text'
        },
        'samlOrganizationURL' => {
            'default' => 'http://www.example.com',
            'type'    => 'text'
        },
        'samlRelayStateTimeout' => {
            'default' => 600,
            'type'    => 'int'
        },
        'samlServicePrivateKeyEnc' => {
            'default' => '',
            'type'    => 'RSAPrivateKey'
        },
        'samlServicePrivateKeyEncPwd' => {
            'type' => 'password'
        },
        'samlServicePrivateKeySig' => {
            'default' => '',
            'type'    => 'RSAPrivateKey'
        },
        'samlServicePrivateKeySigPwd' => {
            'default' => '',
            'type'    => 'password'
        },
        'samlServicePublicKeyEnc' => {
            'default' => '',
            'type'    => 'RSAPublicKeyOrCertificate'
        },
        'samlServicePublicKeySig' => {
            'default' => '',
            'type'    => 'RSAPublicKeyOrCertificate'
        },
        'samlServiceUseCertificateInResponse' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataExportedAttributes' => {
            'default'    => {},
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/\w/,
            'type'       => 'samlAttributeContainer'
        },
        'samlSPMetaDataNodes' => {
            'type' => 'samlSPMetaDataNodeContainer'
        },
        'samlSPMetaDataOptions' => {
            'keyMsgFail' => '__badMetadataName__',
            'keyTest'    => qr/^[a-zA-Z](?:[a-zA-Z0-9_\-\.]*\w)?$/,
            'type'       => 'keyTextContainer'
        },
        'samlSPMetaDataOptionsCheckSLOMessageSignature' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsCheckSSOMessageSignature' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsEnableIDPInitiatedURL' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsEncryptionMode' => {
            'default' => 'none',
            'select'  => [
                {
                    'k' => 'none',
                    'v' => 'None'
                },
                {
                    'k' => 'nameid',
                    'v' => 'Name ID'
                },
                {
                    'k' => 'assertion',
                    'v' => 'Assertion'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsForceUTF8' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsNameIDFormat' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'unspecified',
                    'v' => 'Unspecified'
                },
                {
                    'k' => 'email',
                    'v' => 'Email'
                },
                {
                    'k' => 'x509',
                    'v' => 'X509 certificate'
                },
                {
                    'k' => 'windows',
                    'v' => 'Windows'
                },
                {
                    'k' => 'kerberos',
                    'v' => 'Kerberos'
                },
                {
                    'k' => 'entity',
                    'v' => 'Entity'
                },
                {
                    'k' => 'persistent',
                    'v' => 'Persistent'
                },
                {
                    'k' => 'transient',
                    'v' => 'Transient'
                },
                {
                    'k' => 'encrypted',
                    'v' => 'Encrypted'
                }
            ],
            'type' => 'select'
        },
        'samlSPMetaDataOptionsNameIDSessionKey' => {
            'type' => 'text'
        },
        'samlSPMetaDataOptionsNotOnOrAfterTimeout' => {
            'default' => 72000,
            'type'    => 'int'
        },
        'samlSPMetaDataOptionsOneTimeUse' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'samlSPMetaDataOptionsSessionNotOnOrAfterTimeout' => {
            'default' => 72000,
            'type'    => 'int'
        },
        'samlSPMetaDataOptionsSignSLOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlSPMetaDataOptionsSignSSOMessage' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'samlSPMetaDataXML' => {
            'type' => 'file'
        },
        'samlSPSSODescriptorArtifactResolutionServiceArtifact' => {
            'default' =>
'1;0;urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/artifact',
            'type' => 'samlAssertion'
        },
        'samlSPSSODescriptorAssertionConsumerServiceHTTPArtifact' => {
            'default' =>
'1;0;urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact;#PORTAL#/saml/proxySingleSignOnArtifact',
            'type' => 'samlAssertion'
        },
        'samlSPSSODescriptorAssertionConsumerServiceHTTPPost' => {
            'default' =>
'0;1;urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/proxySingleSignOnPost',
            'type' => 'samlAssertion'
        },
        'samlSPSSODescriptorAuthnRequestsSigned' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlSPSSODescriptorSingleLogoutServiceHTTPPost' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST;#PORTAL#/saml/proxySingleLogout;#PORTAL#/saml/proxySingleLogoutReturn',
            'type' => 'samlService'
        },
        'samlSPSSODescriptorSingleLogoutServiceHTTPRedirect' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect;#PORTAL#/saml/proxySingleLogout;#PORTAL#/saml/proxySingleLogoutReturn',
            'type' => 'samlService'
        },
        'samlSPSSODescriptorSingleLogoutServiceSOAP' => {
            'default' =>
'urn:oasis:names:tc:SAML:2.0:bindings:SOAP;#PORTAL#/saml/proxySingleLogoutSOAP;',
            'type' => 'samlService'
        },
        'samlSPSSODescriptorWantAssertionsSigned' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'samlStorage' => {
            'type' => 'PerlModule'
        },
        'samlStorageOptions' => {
            'type' => 'keyTextContainer'
        },
        'samlUseQueryStringSpecific' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'securedCookie' => {
            'default' => 0,
            'select'  => [
                {
                    'k' => 0,
                    'v' => 'unsecuredCookie'
                },
                {
                    'k' => 1,
                    'v' => 'securedCookie'
                },
                {
                    'k' => 2,
                    'v' => 'doubleCookie'
                },
                {
                    'k' => 3,
                    'v' => 'doubleCookieForSingleSession'
                }
            ],
            'type' => 'select'
        },
        'secureTokenAllowOnError' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'secureTokenAttribute' => {
            'default' => 'uid',
            'type'    => 'text'
        },
        'secureTokenExpiration' => {
            'default' => 60,
            'type'    => 'int'
        },
        'secureTokenHeader' => {
            'default' => 'Auth-Token',
            'type'    => 'text'
        },
        'secureTokenMemcachedServers' => {
            'default' => '127.0.0.1:11211',
            'type'    => 'text'
        },
        'secureTokenUrls' => {
            'default' => '.*',
            'type'    => 'pcre'
        },
        'sessionDataToRemember' => {
            'keyMsgFail' => '__invalidSessionData__',
            'keyTest'    => qr/^[_a-zA-Z][a-zA-Z0-9_]*$/,
            'type'       => 'keyTextContainer'
        },
        'singleIP' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'singleSession' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'singleSessionUserByIP' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'singleUserByIP' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'slaveAuthnLevel' => {
            'default' => 2,
            'type'    => 'int'
        },
        'slaveExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'slaveHeaderContent' => {
            'type' => 'text'
        },
        'slaveHeaderName' => {
            'type' => 'text'
        },
        'slaveMasterIP' => {
            'msgFail' => '__badIPv4Address__',
            'test'    => qr/^((?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)\s*)*$/,
            'type'    => 'text'
        },
        'slaveUserHeader' => {
            'type' => 'text'
        },
        'SMTPAuthPass' => {
            'type' => 'password'
        },
        'SMTPAuthUser' => {
            'type' => 'text'
        },
        'SMTPServer' => {
            'default' => '',
            'test' =>
qr/^(?:(?:(?:(?:(?:(?:[a-zA-Z0-9][-a-zA-Z0-9]*)?[a-zA-Z0-9])[.])*(?:[a-zA-Z][-a-zA-Z0-9]*[a-zA-Z0-9]|[a-zA-Z])[.]?)|(?:[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+))(?::\d+)?)?$/,
            'type' => 'text'
        },
        'Soap' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'soapAuthService' => {
            'type' => 'text'
        },
        'soapSessionService' => {
            'type' => 'text'
        },
        'SSLAuthnLevel' => {
            'default' => 5,
            'type'    => 'int'
        },
        'SSLVar' => {
            'type' => 'text'
        },
        'staticPrefix' => {
            'type' => 'text'
        },
        'storePassword' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'successLoginNumber' => {
            'default' => 5,
            'type'    => 'int'
        },
        'sympaMailKey' => {
            'type' => 'text'
        },
        'sympaSecret' => {
            'type' => 'text'
        },
        'syslog' => {
            'default' => '',
            'msgFail' =>
              '__authorizedValues__: auth, authpriv, daemon, local0-7, user',
            'test' => qr/^(?:auth|authpriv|daemon|local\d|user)?$/,
            'type' => 'text'
        },
        'timeout' => {
            'default' => 72000,
            'test'    => sub {
                $_[0] > 0;
            },
            'type' => 'int'
        },
        'timeoutActivity' => {
            'default' => 0,
            'test'    => sub {
                $_[0] >= 0;
            },
            'type' => 'int'
        },
        'trustedDomains' => {
            'type' => 'text'
        },
        'trustedProxies' => {
            'default' => '',
            'type'    => 'text'
        },
        'twitterAppName' => {
            'type' => 'text'
        },
        'twitterAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'twitterKey' => {
            'type' => 'text'
        },
        'twitterSecret' => {
            'type' => 'text'
        },
        'userControl' => {
            'default' => '^[\\w\\.\\-@]+$',
            'type'    => 'pcre'
        },
        'userDB' => {
            'default' => 'Demo',
            'select'  => [
                {
                    'k' => 'AD',
                    'v' => 'Active Directory'
                },
                {
                    'k' => 'DBI',
                    'v' => 'Database (DBI)'
                },
                {
                    'k' => 'Choice',
                    'v' => 'authChoice'
                },
                {
                    'k' => 'Demo',
                    'v' => 'Demonstration'
                },
                {
                    'k' => 'Facebook',
                    'v' => 'Facebook'
                },
                {
                    'k' => 'Google',
                    'v' => 'Google'
                },
                {
                    'k' => 'LDAP',
                    'v' => 'LDAP'
                },
                {
                    'k' => 'Multi',
                    'v' => 'Multiple'
                },
                {
                    'k' => 'Null',
                    'v' => 'None'
                },
                {
                    'k' => 'OpenID',
                    'v' => 'OpenID'
                },
                {
                    'k' => 'OpenIDConnect',
                    'v' => 'OpenID Connect'
                },
                {
                    'k' => 'Proxy',
                    'v' => 'Proxy'
                },
                {
                    'k' => 'Remote',
                    'v' => 'Remote'
                },
                {
                    'k' => 'SAML',
                    'v' => 'SAML v2'
                },
                {
                    'k' => 'Slave',
                    'v' => 'Slave'
                },
                {
                    'k' => 'WebID',
                    'v' => 'WebID'
                }
            ],
            'type' => 'select'
        },
        'useRedirectOnError' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'useRedirectOnForbidden' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'userPivot' => {
            'type' => 'text'
        },
        'useSafeJail' => {
            'default' => 1,
            'type'    => 'bool'
        },
        'vhostAliases' => {
            'type' => 'text'
        },
        'vhostHttps' => {
            'default' => -1,
            'type'    => 'trool'
        },
        'vhostMaintenance' => {
            'default' => 0,
            'type'    => 'bool'
        },
        'vhostOptions' => {
            'type' => 'subContainer'
        },
        'vhostPort' => {
            'default' => -1,
            'type'    => 'int'
        },
        'virtualHosts' => {
            'type' => 'virtualHostContainer'
        },
        'webIDAuthnLevel' => {
            'default' => 1,
            'type'    => 'int'
        },
        'webIDExportedVars' => {
            'default'    => {},
            'keyMsgFail' => '__badVariableName__',
            'keyTest'    => qr/^!?[a-zA-Z][a-zA-Z0-9_-]*$/,
            'msgFail'    => '__badValue__',
            'test'       => qr/^[a-zA-Z][a-zA-Z0-9_:\-]*$/,
            'type'       => 'keyTextContainer'
        },
        'webIDWhitelist' => {
            'type' => 'text'
        },
        'whatToTrace' => {
            'default' => 'uid',
            'type'    => 'lmAttrOrMacro'
        },
        'yubikeyAuthnLevel' => {
            'default' => 3,
            'type'    => 'int'
        },
        'yubikeyClientID' => {
            'type' => 'text'
        },
        'yubikeyPublicIDSize' => {
            'default' => 12,
            'type'    => 'int'
        },
        'yubikeySecretKey' => {
            'type' => 'text'
        },
        'zimbraAccountKey' => {
            'type' => 'text'
        },
        'zimbraBy' => {
            'default' => '',
            'select'  => [
                {
                    'k' => '',
                    'v' => ''
                },
                {
                    'k' => 'name',
                    'v' => 'User name'
                },
                {
                    'k' => 'id',
                    'v' => 'User id'
                },
                {
                    'k' => 'foreignPrincipal',
                    'v' => 'Foreign principal'
                }
            ],
            'type' => 'select'
        },
        'zimbraPreAuthKey' => {
            'type' => 'text'
        },
        'zimbraSsoUrl' => {
            'type' => 'text'
        },
        'zimbraUrl' => {
            'type' => 'text'
        }
    };
}

