/*
 *  Copyright 1994-2016 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BINIOU_PICTFADER_H
#define __BINIOU_PICTFADER_H

#include "picture_8bits.h"
#include "fader.h"
#include "event.h"
#include "shuffler.h"


typedef struct PictFader_s {
  u_char     on;
  Picture8_t *cur;
  Picture8_t *dst;
  Fader_t    *fader;
  Shuffler_t *shf;
} PictFader_t;


PictFader_t *PictFader_new(const u_short);
void PictFader_delete(PictFader_t *);

void PictFader_set(PictFader_t *);

void PictFader_prev(PictFader_t *);
void PictFader_next(PictFader_t *);
void PictFader_random(PictFader_t *);

void PictFader_init(PictFader_t *);
void PictFader_run(PictFader_t *);

int PictFader_event(PictFader_t *, const Event_t *);

int PictFader_ring(const PictFader_t *);

#endif /* __BINIOU_PICTFADER_H */
