/***
* Author: Juergen Heinemann http://www.hjcms.de, (C) 2007-2008
* Copyright: See COPYING file that comes with this distribution
**/

#include "settingspageone.h"
#include "settings.h"

#include <cstdlib>

/* QtCore */
#include <QtCore/QDebug>
#include <QtCore/QDir>
#include <QtCore/QString>
#include <QtCore/QStringList>

/* QtGui */
#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>

/* KDE */
#include <KDE/KLocale>
#include <KDE/KLineEdit>
#include <KDE/KCompletion>

SettingsItem::SettingsItem ( QWidget *parent )
    : QGroupBox ( parent )
{
  setFlat ( true );
  setContentsMargins ( 2, 5, 2, 2 );
  setMinimumHeight ( 50 );

  QVBoxLayout *layout = new QVBoxLayout ( this );
  layout->setContentsMargins ( 0, 4, 0, 0 );

  label = new QLabel ( this );
  layout->addWidget ( label );

  m_KLineEdit = new KLineEdit ( "lineEdit", this );
// TODO
//   m_KCompletion = m_KLineEdit->completionObject();
//   m_KLineEdit->setCompletionObject ( m_KCompletion );
//   m_KLineEdit->setCompletionMode ( KGlobalSettings::CompletionShell );
  layout->addWidget ( m_KLineEdit );

  setLayout ( layout );
}

void SettingsItem::setText ( const QString &txt )
{
  label->setText ( txt );
}

void SettingsItem::setValue ( const QVariant &val )
{
  QString str = val.toString();
  m_KLineEdit->setText ( str );
}

const QVariant SettingsItem::value()
{
  return QVariant ( m_KLineEdit->text() );
}

/** SettingsPageOne */
SettingsPageOne::SettingsPageOne ( QWidget *parent )
    : QWidget ( parent )
{
  setObjectName ( "SettingsPageOne" );
  setContentsMargins ( 2, 5, 2, 2 );
  setMinimumWidth ( 350 );
  setMinimumHeight ( 350 );

  topLayout = new QVBoxLayout ( this );
  topLayout->setSpacing ( 2 );
  topLayout->addWidget ( new QLabel ( i18n ( "Application Settings" ), this ) );

  startMinimized = new QCheckBox ( i18n ( "Start qx11grab Minimized" ), this );
  startMinimized->setObjectName ( "startMinimized" );
  topLayout->addWidget ( startMinimized );

  setDefaults();

  topLayout->addStretch ( 1 );
  setLayout ( topLayout );
}

const QMap<QString,QVariant> SettingsPageOne::getDefaults ()
{
  QMap<QString,QVariant> map;
  map.insert ( "ff_path", "/usr/bin/ffmpeg" );
  map.insert ( "tempdir", QDir::tempPath() );
  map.insert ( "outputName", "kx11grab-XXXXXX.avi" );
  map.insert ( "ff_oss", "" );
  return map;
}

const QString SettingsPageOne::getDescription ( const QString &key )
{
  QMap<QString,QString> map;
  map.insert ( "ff_path", i18n ( "Full path to ffmpeg Binary" ) );
  map.insert ( "tempdir", i18n ( "Default tmp Directory" ) );
  map.insert ( "outputName", i18n ( "Default output file name XXXXXX will replaced with curent Timestamp." ) );
  map.insert ( "ff_oss", i18n ( "Audio Device" ) );

  if ( map.contains ( key ) )
    return map[key];
  else
    return QString::null;
}

void SettingsPageOne::setDefaults()
{
  QMapIterator<QString,QVariant> it ( getDefaults() );
  while ( it.hasNext() )
  {
    it.next();
    SettingsItem *item = new SettingsItem ( this );
    item->setObjectName ( it.key() );
    item->setText ( getDescription ( it.key() ) );
    item->setValue ( it.value() );
    topLayout->addWidget ( item );
  }
}

void SettingsPageOne::saveOptions ( Settings *cfg )
{
  QMap<QString,QVariant> map;
  foreach ( QCheckBox *box, findChildren<QCheckBox*>() )
  {
    if ( ! box->objectName().isEmpty() )
    {
      cfg->setValue ( box->objectName(), box->isChecked() );
      map.insert ( box->objectName(), box->isChecked() );
    }
  }

  foreach ( SettingsItem *item, findChildren<SettingsItem*>() )
  {
    if ( ! item->objectName().isEmpty() )
    {
      cfg->setValue ( item->objectName(), item->value() );
      map.insert ( item->objectName(), item->value() );
    }
  }
  cfg->setValue ( "kx11grab/options", map );
}

void SettingsPageOne::setOptions ( const QMap<QString,QVariant> &map )
{
  if ( map.contains ( "startMinimized" ) )
    startMinimized->setChecked ( map["startMinimized"].toBool() );

  QMapIterator<QString,QVariant> it ( map );
  while ( it.hasNext() )
  {
    it.next();

    if ( it.key().isEmpty() )
      continue;

    SettingsItem *item = findChild<SettingsItem*> ( it.key() );
    if ( item && it.value().type() == QVariant::String )
      item->setValue ( it.value() );
  }
}

SettingsPageOne::~SettingsPageOne()
{
}


