/***
* Author: Juergen Heinemann http://www.hjcms.de, (C) 2007-2008
* Copyright: See COPYING file that comes with this distribution
**/

#ifndef QX11GRABMAIN_H
#define QX11GRABMAIN_H

#include <QtCore/QVariant>
#include <QtGui/QGridLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QWidget>
#include <QtGui/QCheckBox>

/* KDE */
#include <KDE/KApplication>
#include <KDE/KMainWindow>
#include <KDE/KLocale>
#include <KDE/KIconLoader>
#include <KDE/KAction>
#include <KDE/KLineEdit>
#include <KDE/KIntSpinBox>
#include <KDE/KStatusBar>
#include <KDE/KIcon>

class ScreenComboBox;
class Settings;

class QX11GrabMain : public KMainWindow
{
    Q_OBJECT
    Q_CLASSINFO ( "Author", "Juergen Heinemann (Undefined)" )
    Q_CLASSINFO ( "URL", "http://qx11grab.hjcms.de" )

  private:
    QWidget *centralwidget;
    QVBoxLayout *verticalLayout;
    QGridLayout *gridLayout;
    QLabel *label, *label_2, *label_3, *label_4, *label_6, *label_7;
    void addWinActionMenu();

  protected:
    KAction *actionQuit,
    *actionMinimize,
    *actionApplication,
    *actionStartRecord,
    *actionStopRecord,
    *actionGrabbing,
    *actionKillRecord;

    KIntSpinBox *setWidthBox,
    *setHeightBox,
    *setDepthBox,
    *setYBox,
    *setXBox;

    ScreenComboBox *screenComboBox;
    Settings* m_Settings;

    KLineEdit *setModeName;
    QCheckBox *showRubberband;
    KStatusBar *statusbar;

    const KIcon getIcon ( const QString &name, const KIconLoader::Group &group = KIconLoader::NoGroup );

  public:
    QX11GrabMain ( Settings *settings = 0 );
    ~QX11GrabMain();
};

#endif // QX11GRABMAIN_H
