<?xml version = '1.0' encoding = 'utf-8' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- template for converts qt TS files to gettext -->
<xsl:output version="1.0" 
  method="text" 
  encoding="utf-8" 
  indent="yes"
  media-type="text/plain"
/>

<xsl:variable name="newline">
<xsl:text>
</xsl:text>
</xsl:variable>

<xsl:template match="message" mode="msgr">
  <xsl:value-of select="$newline" />
  <xsl:text>#: </xsl:text>
  <xsl:value-of select="location/@filename" />
  <xsl:value-of select="$newline" />
  <xsl:text>msgid "</xsl:text>
  <xsl:value-of select="source" />
  <xsl:text>"</xsl:text>
  <xsl:value-of select="$newline" />
  <xsl:text>msgstr "</xsl:text>
  <xsl:value-of select="translation" />
  <xsl:text>"</xsl:text>
  <xsl:value-of select="$newline" />
</xsl:template>

<xsl:template match="TS">
<xsl:text>
# SOME DESCRIPTIVE TITLE.
# Copyright (C) YEAR GPLv2/LGPL
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR &lt;EMAIL@ADDRESS&gt;, YEAR.
#
#, fuzzy
msgid ""
msgstr ""
"Project-Id-Version: PACKAGE VERSION\n"
"Report-Msgid-Bugs-To: nospam (AT) hjcms (DOT) de\n"
"POT-Creation-Date: 2008-11-24 12:42+0100\n"
"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\n"
"Last-Translator: FULL NAME &lt;EMAIL@ADDRESS&gt;\n"
"Language-Team: LANGUAGE &lt;LL@li.org&gt;\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=CHARSET\n"
"Content-Transfer-Encoding: 8bit\n"
</xsl:text>
<xsl:apply-templates select="context/message" mode="msgr" />
</xsl:template>

</xsl:stylesheet>

