/*
   * alphatrack.h
   * alphatrack callback interface
   * based on transport.c by arthur@artcmusic.com
*/

#ifndef __ALPHATRACK_H__
#define __ALPHATRACK_H__

#include <pthread.h>
#include <usb.h>

#define ALPHATRACK_VENDORID  0x165b
#define ALPHATRACK_PRODUCTID 0xFAD1

#define ALPHATRACK_READ_ENDPOINT  0x81
#define ALPHATRACK_WRITE_ENDPOINT 0x02

#define MAXLED 23

enum {
	ALPHATRACK_LED_EQ = 0,
	ALPHATRACK_LED_RIGHT,
	ALPHATRACK_LED_F2,
	ALPHATRACK_LED_SEND,
	ALPHATRACK_LED_LEFT,
	ALPHATRACK_LED_F1,
	ALPHATRACK_LED_PAN,
	ALPHATRACK_LED_EMPTY,
	ALPHATRACK_LED_EMPTY2,
	ALPHATRACK_LED_SHIFT,
	ALPHATRACK_LED_MUTE,
	ALPHATRACK_LED_SOLO,
	ALPHATRACK_LED_REC,
	ALPHATRACK_LED_READ,
	ALPHATRACK_LED_WRITE,
	ALPHATRACK_LED_ANY,
	ALPHATRACK_LED_AUTO,
	ALPHATRACK_LED_F4,
	ALPHATRACK_LED_PUNCH,
	ALPHATRACK_LED_FLIP,	
	ALPHATRACK_LED_PLUGIN,
	ALPHATRACK_LED_F3,
	ALPHATRACK_LED_LOOP
};

/*			read-bytes:         2 3 4 5   */
#define ALPHATRACK_BUTTON_REW           0x0000000001LL
#define ALPHATRACK_BUTTON_RECORD	0x0000000002LL
#define ALPHATRACK_BUTTON_FFWD		0x0000000004LL
#define ALPHATRACK_BUTTON_PLAY		0x0000000008LL
#define ALPHATRACK_BUTTON_STOP		0x0000000010LL
#define ALPHATRACK_BUTTON_SHIFT		0x0000000020LL
#define ALPHATRACK_BUTTON_FLIP		0x0000000040LL
#define ALPHATRACK_BUTTON_TRACKL	0x0000000080LL
#define ALPHATRACK_BUTTON_LOOP		0x0000000100LL
#define ALPHATRACK_BUTTON_TRACKR	0x0000000200LL
#define ALPHATRACK_BUTTON_MUTE		0x0000000400LL
#define ALPHATRACK_BUTTON_F4		0x0000000800LL
#define ALPHATRACK_BUTTON_F1		0x0000001000LL
#define ALPHATRACK_BUTTON_F3		0x0000002000LL
#define ALPHATRACK_BUTTON_F2		0x0000004000LL
#define ALPHATRACK_BUTTON_SOLO		0x0000008000LL
#define ALPHATRACK_BUTTON_AUTO		0x0000010000LL
#define ALPHATRACK_BUTTON_PAN		0x0000020000LL
#define ALPHATRACK_BUTTON_PLUGIN	0x0000040000LL
#define ALPHATRACK_BUTTON_SEND		0x0000080000LL
#define ALPHATRACK_BUTTON_REC		0x0000100000LL
#define ALPHATRACK_BUTTON_ENCODER_R	0x0000200000LL
#define ALPHATRACK_BUTTON_EQ		0x0000400000LL
#define ALPHATRACK_BUTTON_ENCODER_M	0x0000800000LL
#define ALPHATRACK_BUTTON_ENCODER_L	0x0001000000LL
#define ALPHATRACK_CONTACT_TOUCHSTRIP_1	0x0002000000LL
#define ALPHATRACK_CONTACT_TOUCHSTRIP_2 0x0004000000LL
#define ALPHATRACK_CONTACT_ENCODER_L	0x0008000000LL
#define ALPHATRACK_CONTACT_ENCODER_M	0x0010000000LL
#define ALPHATRACK_CONTACT_ENCODER_R	0x0020000000LL
#define ALPHATRACK_CONTACT_FADER	0x0040000000LL
#define ALPHATRACK_BUTTON_FOOTSW	0x0080000000LL

/* for fader, encoders and touchstrip, 
 * any unique value to signal position-changes */
#define ALPHATRACK_POS_FADER		0x1000000000LL
#define ALPHATRACK_POS_TOUCHSTRIP	0x2000000000LL
#define ALPHATRACK_DELTA_ENCODER_L	0x0100000000LL
#define ALPHATRACK_DELTA_ENCODER_M	0x0200000000LL
#define ALPHATRACK_DELTA_ENCODER_R	0x0400000000LL

#define ALPHATRACK_STATUS_OFFLINE 0xff /* makes sense for tranzport only */
#define ALPHATRACK_STATUS_ONLINE  0x01 /* makes sense for tranzport only */

typedef struct _alphatrack_event {
        uint64_t        mask;
        uint64_t        states;
	int             leds[MAXLED];
        int             touchpos;
        int             faderpos;
        int             encoderdelta_l;
        int             encoderdelta_m;
        int             encoderdelta_r;
} alphatrack_event_t;

typedef struct _alphatrack {
	struct 		usb_device *dev;
        usb_dev_handle 	*udev;
	pthread_t       pollthread;
	pthread_mutex_t alphatrackmutex;
	void		(*callbackfunc)(alphatrack_event_t *ev, void *ptr);
	void		*callbackptr;
	uint8_t 	status;
	uint64_t 	buttons;
	uint64_t 	buttondiff;
	int		touchstate;
	int		touchpos;
	int		faderpos;
	int		faderpos_dirty;
	int		encoderdelta_l;
	int		encoderdelta_m;
	int		encoderdelta_r;
	int 		polltimeout;	
	char* 		lcd;
	int 		lcd_dirty[10];
	int 		lcd_ptr;
	int 		leds[MAXLED];
	int 		led_dirty[MAXLED];
	int 		led_ptr;
	int		quit;
} alphatrack_t;

alphatrack_t 	*alphatrack_new();
void 		alphatrack_close(alphatrack_t *z);
void 		alphatrack_set_event_callback(alphatrack_t *z, 
			void (*callback)(alphatrack_event_t *ev, void *ptr) ,
			void *ptr);
uint8_t 	alphatrack_get_status(alphatrack_t *z);
int 		alphatrack_clear_lcd (alphatrack_t *z);
int 		alphatrack_write_lcd (alphatrack_t *z, const char* txt, int x, int y);
int		alphatrack_set_led(alphatrack_t *z, uint8_t led,int status);
int		alphatrack_get_led(alphatrack_t *z, uint8_t led);
void		alphatrack_clear_leds(alphatrack_t *z);
int 		alphatrack_set_faderpos(alphatrack_t *z, int faderpos);

#endif /* end ifndef ALPHATRACK.H */
