/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <fstream>
#include <sstream>
#include <QApplication>
#include <QTranslator>
#include <QString>
#include "widgetoptions.h"
#include "widgetprincipal.h"
#include "widgetoperation.h"
#include "tirage.h"
#include "jeu.h"

void main_graphique(int argc, char **argv );		//interface graphique avec Qt
void main_aide();		//renvoie les options disponibles pour la ligne de commande
void main_compte();		//permet de rsoudre un compte en ligne de commande
void main_erreur();		//message lorsque l'on rentre un paramtre inexistant
void main_renard();		//easter egg
void main_stats();		//lance une tude statistique globale sur l'ensemble des tirages

#ifdef TEST
void main_test();		//fonction servant  raliser des tests lors de la programmation
void main_test_stats();		//fonction de test pour statistiques limites
#endif

plaque demande_plaque();	//fonction pour l'entre d'une plaque en ligne de commande
compte demande_compte();	//fonction pour l'entre du compte en ligne de commande

int main( int argc, char **argv ) {
	//init des plaques autorises (rgle du jeu)
	//note : ce bloc d'init n'est pas trs bien plac
	tirage r;
	for(int i=1; i<=10; i++) {
		r.tab[i]=2;
	}
	r.tab[25]=1;
	r.tab[50]=1;
	r.tab[75]=1;
	r.tab[100]=1;
	r.utiliser_comme_ref();

	//appel d'une des fonctions principales en fonctions des arguments
	string s;
	switch(argc) {
	  case 2 : s=(string) argv[1];
		if     (s=="-h" || s=="--help")		{main_aide();}
		else if(s=="-c" || s=="--compte")	{main_compte();}
		else if(s=="-s" || s=="--stats")	{main_stats();}
		else if(s=="-r" || s=="--renard")	{main_renard();}
		#ifdef TEST
		 else if(s=="-t" || s=="--test")	{main_test();}
		 else if(s=="-ts" || s=="--test-stats")	{main_test_stats();}
		#endif
		#ifdef MACX
		 else if (s.substr(0,4)=="-psn"){
			main_graphique(argc, argv);
		 }
		#endif	
		else					{main_erreur();}
		break;
	  case 1 :
		main_graphique(argc, argv);
		break;
	  default : main_erreur();
	}
	
	return EXIT_SUCCESS;
}


//interface graphique avec Qt
void main_graphique(int argc, char **argv ) {
	int fin=WidgetOptions::NVE_LANGUE;
	while(fin==WidgetOptions::NVE_LANGUE) {
		QApplication a( argc, argv );
		
		//mise ou remise  zro de pointeurs pour les pixmap
		WidgetOperation::nettoyagePixmap();
		
		//lecture du fichier d'options si existant
		WidgetOptions::lireFichier();
		
		//installation de la langue
		QTranslator translator;
		QString fichier_langue=QString(":/kitsune_")+WidgetOptions::langue;
		translator.load(fichier_langue);
		a.installTranslator(&translator);
		
		//choix du style de l'application
		a.setStyle( "plastique" );
		Principal *hm = new Principal();
		hm->show();
		
		fin=a.exec();
	}
}


//renvoie les options disponibles pour la ligne de commande
void main_aide() {
	cout << "Liste des options disponibles pour le programme Kitsune :" << endl << endl
	     << "rien           :" << "  " << "lance l'interface graphique du programme." << endl
	     << "-c ou --compte :" << "  " << "rsout un problme particulier en ligne de commande." << endl
	     << "-h ou --help   :" << "  " << "affiche une liste des paramtres disponibles." << endl
	     << "-r ou --renard :" << "  " << "?" << endl
	     << "-s ou --stats  :" << "  " << "lance une srie de calculs statistiques." << endl;
	#ifdef TEST
	cout << "-t ou --test   :" << "  " << "fonction de test" << endl
	     << "-ts ou --test-stats :" << "test des statistiques" << endl;
	#endif
}

//message lorsque l'on rentre un paramtre inexistant
void main_erreur(){
	cout << "Paramtre inexistant." << endl
	     << "Utiliser l'option \"-h\" ou \"--help\" pour avoir une liste des paramtres disponibles." << endl;
}

//permet de rsoudre un compte en ligne de commande
void main_compte(){
	plaque pl;
	compte compte_init;

	string erreur_tirage="Erreur : tirage non valide, il ne faut pas plus de deux plaques de chaque type entre 1 et 10, et pas plus d'une plaque de chaque type pour 25, 50, 75, 100.";
	
	string noms[6]={"Premire plaque  : ", "Deuxime plaque  : ", "Troisime plaque : ",
			"Quatrime plaque : ", "Cinquime plaque : ", "Sixime plaque   : "};
	tirage t;
	
	for(int i=0; i<6; i++) {
		cout<< noms[i];
		pl=demande_plaque();
		t.tab[pl]++;
	}

	if(!t.est_valable()) { 
		cout << erreur_tirage << endl; 
		return;
	}
	
	cout<<"         compte  : ";
	compte_init=demande_compte();
	
	jeu J;
	J.init(t,compte_init,compte_init);
	J.etude_tirage();
	cout << endl;
	cout << J.afficheBase().toStdString();
}

//fonction pour l'entre d'une plaque en ligne de commande
plaque demande_plaque(){
	string erreur_plaque="         Erreur  : plaques possibles : 1 - 10, 25, 50, 75, 100.";
	
	int i; plaque pl;
	string s;

	while(true) {
		getline(cin,s);
		istringstream istr(s);
		if(istr>>i) { 
			if ( (i>=1 && i<=10) || i==25 || i==50 || i==75|| i==100) {
				pl=i;
				return pl;
			}
		}
		
		//message erreur et nouvelle demande de plaque
		cout<< erreur_plaque << endl << "         plaque  : ";
	}
}

//fonction pour l'entre du compte en ligne de commande
compte demande_compte(){
	string erreur_compte="         Erreur  : rentrer un nombre entier entre 100 et 999.";
	
	int i; compte resultat;
	string s;
	
	while(true) {
		getline(cin,s);
		istringstream istr(s);
		if(istr>>i) { 
			if (i<=999 && i>=100) {
				resultat=i;
				return resultat;
			}
		}
		
		//message erreur et nouvelle demande du compte
		cout<< erreur_compte << endl << "         compte  : ";
	}
}

//easter egg
void main_renard(){
	cout << "    _   _" << endl
	     << "   | \\_/ |" << endl
	     << "   /     \\     /^^^/" << endl
	     << "  /_.^ ^._\\   /^^^|" << endl
	     << "     \\o/      |   |" << endl
	     << "    /   \\_    |   /" << endl
	     << "    \\     \\_  /  /" << endl
	     << "     | | /  \\/ _/" << endl
	     << "    _|_|_\\ _/_/" << endl;
}

//lance une tude statistique globale sur l'ensemble des tirages
void main_stats(){
//test pour dterminer si on a le droit de crer un fichier
	ofstream f_nb_solutions( "nb_solutions.txt" );
	if ( !f_nb_solutions )
	{
	cerr << "Erreur : impossible de crer un fichier dans ce rpertoire.\n";
	return;
	}
	f_nb_solutions.close();
//pour lancer l'tude statistique globale sur les 13243 tirages
	//le calcul est plus rapide sans la canonisation
	calcul::cano1_actif=false;
	calcul::cano2_actif=false;
	calcul::cano3_actif=false;
	#ifdef TEST		//activer ici les fonctions que l'on veut vrifier totalement
	calcul::cano1_actif=true;
	calcul::cano2_actif=true;
	calcul::cano3_actif=true;
	#endif
	set<tirage> st=tous_les_tirages();
	etude_globale E;
	E.grosse_etude(st);
}

#ifdef TEST
//fonction temporaire servant  raliser des tests lors de la programmation
void main_test(){
	calcul Calc=(calcul(6)*calcul(5)*calcul(2)/calcul(4))+calcul(4);
	//calcul Calc=(calcul(5)+calcul(1))*calcul(6)*calcul(4)*calcul(3)*calcul(2);
	list<compte> fugo=Calc.liste_sous_comptes();
	list<compte>::iterator gougou;
	for(gougou=fugo.begin();gougou!=fugo.end();gougou++){
		cout << *gougou << "\t" ;
	}
	cout << endl;
	cout << Calc.liste_plaques() << endl;
}

//tude limite  un petit nombre de tirages (pour les tests)
void main_test_stats(){
	// modifier pour vrifier l'influence des fonctions de canonisation
	calcul::cano1_actif=true;
	calcul::cano2_actif=true;
	calcul::cano3_actif=true;
	
	tirage t1;
	t1.tab[1]=1; t1.tab[2]=1; t1.tab[3]=2; t1.tab[100]=1; t1.tab[75]=1;
	
	tirage t2;
	t2.tab[1]=1; t2.tab[2]=1; t2.tab[3]=1; t2.tab[4]=1; t2.tab[5]=1; t2.tab[100]=1;
	
	tirage t3;
	t3.tab[1]=2; t3.tab[2]=2; t3.tab[3]=2;
	
	set<tirage> st;
	st.insert(t1);
	st.insert(t2);
	st.insert(t3);
	
	etude_globale E;
	E.grosse_etude(st);
}
#endif

