# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class ThreadTabWidget < Qt::TabWidget
  def initialize(parent)
    super(parent)

    @view_list = []
    add_view
  end

  def add_view
    view = ThreadView.new(self)
    @view_list.push(view)
    addTab(view, "Tab")
  end

  def show_thread(dat_url)
    @view_list.each {|view|
      if view.dat_url == dat_url || view.dat_url == nil then
        view.show_thread(dat_url)
        setTabText(indexOf(view), Util.truncate_str(view.thread_name, 20))
        setTabToolTip(indexOf(view), view.thread_name)
        setCurrentWidget(view)
        return
      end
    }

    view = ThreadView.new(self)
    @view_list.push(view)
    view.show_thread(dat_url)
    addTab(view, Util.truncate_str(view.thread_name, 20))
    setTabToolTip(indexOf(view), view.thread_name)
    setCurrentWidget(view)
  end

  def remove_view(view)
    add_view if @view_list.size == 1

    @view_list.delete(view)
    removeTab(indexOf(view))
  end

  def copy
    currentWidget.copy
  end
end
