/*
    Copyright 2008,2009
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with JSXGraph.  If not, see <http://www.gnu.org/licenses/>.
*/
    var JXG={};(function(){var a,b;JXG.countDrawings=0;JXG.countTime=0;JXG.require=function(d){};JXG.rendererFiles=[];JXG.rendererFiles.svg="SVGRenderer";JXG.rendererFiles.vml="VMLRenderer";JXG.baseFiles=null;JXG.requirePath="";for(a=0;a<document.getElementsByTagName("script").length;a++){b=document.getElementsByTagName("script")[a];if(b.src&&b.src.match(/loadjsxgraphInOneFile\.js(\?.*)?$/)){JXG.requirePath=b.src.replace(/loadjsxgraphInOneFile\.js(\?.*)?$/,"")}}JXG.serverBase=JXG.requirePath+"server/"})();JXG.Math=new Object();JXG.Math.eps=0.000001;JXG.Math.Vector=function(b){var a;this.length=0;if((typeof b!=undefined)&&(b!=null)){for(a=0;a<b.length;a++){this.push(b[a])}}};JXG.Math.Vector.prototype=new Array();JXG.Math.Vector.prototype.n=function(){return this.length};JXG.Math.Vector.prototype.exchange=function(d,b){var a=this[d];this[d]=this[b];this[b]=a};JXG.Math.Matrix=function(k){var g=0,h=false,e,d,a,b;this.length=0;if((typeof k!=undefined)&&(k!=null)){a=k.length;for(e=0;e<a;e++){b=k[e].length;this.push(new Array());if(h){if(g!=b){this.length=0;throw new JXG.DimensionMismatchException("Your array contains arrays with different lengths.")}}for(d=0;d<b;d++){this[e].push(k[e][d])}g=b;h=true}}};JXG.Math.Matrix.prototype=new Array();JXG.Math.Matrix.prototype.m=function(){return this.length};JXG.Math.Matrix.prototype.n=function(){if(this.length>0){return this[0].length}else{return 0}};JXG.Math.Matrix.prototype.exchangeRows=function(d,b){var a=this[d];this[d]=this[b];this[b]=a};JXG.DimensionMismatchException=function(a){if((typeof a!=undefined)&&(a!=null)){this.message=a}else{this.message=null}};JXG.DimensionMismatchException.prototype.what=function(){var a="Matrix has incorrect dimensions";if(this.message!=null){return a+": "+this.message+"."}else{return a+"."}};JXG.SingularMatrixException=function(a){if((typeof a!=undefined)&&(a!=null)){this.message=a}else{this.message=null}};JXG.SingularMatrixException.prototype.what=function(){var a="Matrix is singular";if(this.message!=null){return a+": "+this.message+"."}else{return a+"."}};JXG.Math.matVecMult=function(l,g){var a=l.length,o=g.length,e=[],d,h,b;for(d=0;d<a;d++){h=0;for(b=0;b<o;b++){h+=l[d][b]*g[b]}e[d]=h}return e};JXG.Math.matMatMult=function(b,a){var e=b.length,d=a[0].length,p=a.length,o=[],l,h,q,g;for(l=0;l<e;l++){o[l]=[]}for(l=0;l<e;l++){for(h=0;h<d;h++){q=0;for(g=0;g<p;g++){q+=b[l][g]*a[g][h]}o[l][h]=q}}return o};JXG.Math.Matrix.transpose=function(h){var d=[],e,b,a,g;a=h.length;g=(h.length>0)?h[0].length:0;for(e=0;e<g;e++){d.push([]);for(b=0;b<a;b++){d[e].push(h[b][e])}}return d};JXG.memoizer=function(b){var a,d;if(b.memo){return b.memo}a={};d=Array.prototype.join;return(b.memo=function(){var e=d.call(arguments);return(typeof a[e]!="undefined")?a[e]:a[e]=b.apply(this,arguments)})};JXG.Math.factorial=JXG.memoizer(function(a){if(a<0){return NaN}if(a==0||a==1){return 1}return a*arguments.callee(a-1)});JXG.Math.binomial=JXG.memoizer(function(g,d){var a,e;if(d>g||d<0){return 0}if(d==0||d==g){return 1}a=1;for(e=0;e<d;e++){a*=(g-e);a/=(e+1)}return a});JXG.Math.round=function(a,e){var d,b;d=a-Math.ceil(a);b=d.toString();if(d<0){b=b.substr(0,e+3)}else{b=b.substr(0,e+2)}d=parseFloat(b);t=parseInt(a.toString());return t+d};JXG.Math.Numerics={};JXG.Math.Numerics.INT_TRAPEZ=1;JXG.Math.Numerics.INT_SIMPSON=2;JXG.Math.Numerics.INT_MILNE=3;JXG.Math.Numerics.number_of_nodes=28;JXG.Math.Numerics.integration_type=JXG.INT_MILNE;JXG.Math.Numerics.backwardSolve=function(k,e){var d=e,a,l,h,g;if(k.m){a=k.m();l=k.n()}else{a=k.length;l=(k.length>0)?k[0].length:0}for(h=a-1;h>=0;h--){for(g=l-1;g>h;g--){d[h]-=k[h][g]*d[g]}d[h]/=k[h][h]}return d};JXG.Math.Numerics.Gauss=function(a,o){var q=JXG.Math.eps,d,h,g,e,l,p,m;if(a.n){d=a.n()}else{d=(a.length>0)?a[0].length:0}l=new JXG.Math.Vector();for(h=0;h<d;h++){l.push(h)}for(g=0;g<d;g++){for(h=d-1;h>g;h--){if(Math.abs(a[h][g])>JXG.Math.eps){if(Math.abs(a[g][g])<JXG.Math.eps){a.exchangeRows(h,g);o.exchange(h,g);l.exchange(h,g)}else{a[h][g]/=a[g][g];o[h]-=a[h][g]*o[g];for(e=g+1;e<d;e++){a[h][e]-=a[h][g]*a[g][e]}}}if(Math.abs(a[g][g])<JXG.Math.eps){throw new SingularMatrixException()}}}return JXG.Math.Numerics.backwardSolve(a,o)};JXG.Math.Numerics.QR=function(d,a){};JXG.Math.Numerics.NewtonCotes=function(e,h){var b=0,a=(e[1]-e[0])/this.number_of_nodes,k,g,d;switch(this.integration_type){case JXG.INT_TRAPEZ:b=(h(e[0])+h(e[1]))*0.5;k=e[0];for(g=0;g<this.number_of_nodes-1;g++){k+=a;b+=h(k)}b*=a;break;case JXG.INT_SIMPSON:if(this.number_of_nodes%2>0){throw"Error: INT_SIMPSON requires JXG.Math.Numerics.number_of_nodes dividable by 2."}d=this.number_of_nodes/2;b=h(e[0])+h(e[1]);k=e[0];for(g=0;g<d-1;g++){k+=2*a;b+=2*h(k)}k=e[0]-a;for(g=0;g<d;g++){k+=2*a;b+=4*h(k)}b*=a/3;break;default:if(this.number_of_nodes%4>0){throw"Error in INT_MILNE: JXG.Math.Numerics.number_of_nodes must be a multiple of 4"}d=this.number_of_nodes*0.25;b=7*(h(e[0])+h(e[1]));k=e[0];for(g=0;g<d-1;g++){k+=4*a;b+=14*h(k)}k=e[0]-3*a;for(g=0;g<d;g++){k+=4*a;b+=32*(h(k)+h(k+2*a))}k=e[0]-2*a;for(g=0;g<d;g++){k+=4*a;b+=12*h(k)}b*=2*a/45}return b};JXG.Math.Numerics.splineDef=function(o,m){var a=o.length,d,g,h,k,b,e=new Array(),s=[],p=[],q;if(o.length!=m.length){throw"Error in JXG.Math.Numerics.splineDef: Input vector dimensions do not match."}for(g=0;g<a;g++){d={X:o[g],Y:m[g]};e.push(d)}e.sort(function(u,l){return u.X-l.X});for(g=0;g<a;g++){o[g]=e[g].X;m[g]=e[g].Y}for(g=0;g<a-1;g++){s.push(o[g+1]-o[g])}for(g=0;g<a-2;g++){p.push(6*(m[g+2]-m[g+1])/(s[g+1])-6*(m[g+1]-m[g])/(s[g]))}h=new Array();k=new Array();h.push(2*(s[0]+s[1]));k.push(p[0]);for(g=0;g<a-3;g++){b=s[g+1]/h[g];h.push(2*(s[g+1]+s[g+2])-b*s[g+1]);k.push(p[g+1]-b*k[g])}q=new Array();q[a-3]=k[a-3]/h[a-3];for(g=a-4;g>=0;g--){q[g]=(k[g]-(s[g+1]*q[g+1]))/h[g]}for(g=a-3;g>=0;g--){q[g+1]=q[g]}q[0]=0;q[a-1]=0;return q};JXG.Math.Numerics.splineEval=function(g,A,w,C){var h=A.length,m=1,k=false,B,p,o,z,u,s,q,e;if(h!=w.length){throw"Error in JXG.Math.Numerics.splineEval: Defining vector dimensions do not match."}if(JXG.isArray(g)){m=g.length;k=true}else{g=[g]}B=new Array();for(p=0;p<m;p++){if((g[p]<A[0])||(A[p]>A[h-1])){return"NaN"}o;for(o=1;o<h;o++){if(g[p]<=A[o]){break}}o--;z=w[o];u=(w[o+1]-w[o])/(A[o+1]-A[o])-(A[o+1]-A[o])/6*(C[o+1]+2*C[o]);s=C[o]/2;q=(C[o+1]-C[o])/(6*(A[o+1]-A[o]));e=g[p]-A[o];B.push(z+(u+(s+q*e)*e)*e)}if(k){return B}else{return B[0]}};JXG.Math.Numerics.generatePolynomialTerm=function(a,h,b,d){var g="",e;for(e=h;e>=0;e--){g+="("+a[e].toPrecision(d)+")";if(e>1){g+="*"+b+"<sup>"+e+"</sup> + "}else{if(e==1){g+="*"+b+" + "}}}return g};JXG.Math.Numerics.lagrangePolynomial=function(e){var a=[];var d="";var b=function(u,g){var l,h,p,q,w,m=0,o=0;p=e.length;if(!g){for(l=0;l<p;l++){a[l]=1;q=e[l].X();for(h=0;h<p;h++){if(h!=l){a[l]*=(q-e[h].X())}}a[l]=1/a[l]}M=[];for(j=0;j<p;j++){M.push([1])}}for(l=0;l<p;l++){q=e[l].X();if(u==q){return e[l].Y()}else{w=a[l]/(u-q);o+=w;m+=w*e[l].Y()}}return m/o};b.getTerm=function(){return d};return b};JXG.Math.Numerics.neville=function(e){var a=[];var d=function(u,g){var k,p,q,w,z=JXG.Math.binomial,o=e.length,h=o-1,l=0,m=0;if(!g){w=1;for(k=0;k<o;k++){a[k]=z(h,k)*w;w*=(-1)}}p=u;for(k=0;k<o;k++){if(p==0){return e[k].X()}else{w=a[k]/p;p--;l+=e[k].X()*w;m+=w}}return l/m};var b=function(u,g){var k,p,q,w,z=JXG.Math.binomial,o=e.length,h=o-1,l=0,m=0;if(!g){w=1;for(k=0;k<o;k++){a[k]=z(h,k)*w;w*=(-1)}}p=u;for(k=0;k<o;k++){if(p==0){return e[k].Y()}else{w=a[k]/p;p--;l+=e[k].Y()*w;m+=w}}return l/m};return[d,b,0,function(){return e.length-1}]};JXG.Math.Numerics.regressionPolynomial=function(g,o,m){var a=[],h=0,b,l,k,d,e="";if(JXG.isPoint(g)&&typeof g.Value=="function"){b=function(){return g.Value()}}else{if(JXG.isFunction(g)){b=g}else{if(JXG.isNumber(g)){b=function(){return g}}else{throw ("JSXGraph error: Can't create regressionPolynomial from degree of type'"+(typeof g)+"'.")}}}if(arguments.length==3&&JXG.isArray(o)&&JXG.isArray(m)){d=0}else{if(arguments.length==2&&JXG.isArray(o)&&JXG.isPoint(o[0])){d=1}else{throw ("JSXGraph error: Can't create regressionPolynomial. Wrong parameters.")}}var p=function(H,q){var z,w,E,C,G,u,F,I,D,A=o.length;D=Math.floor(b());if(!q){if(d==1){l=[];k=[];for(z=0;z<A;z++){l[z]=o[z].X();k[z]=o[z].Y()}}if(d==0){l=[];k=[];for(z=0;z<A;z++){if(JXG.isFunction(o[z])){l.push(o[z]())}else{l.push(o[z])}if(JXG.isFunction(m[z])){k.push(m[z]())}else{k.push(m[z])}}}E=[];for(w=0;w<A;w++){E.push([1])}for(z=1;z<=D;z++){for(w=0;w<A;w++){E[w][z]=E[w][z-1]*l[w]}}G=k;C=JXG.Math.Matrix.transpose(E);u=JXG.Math.matMatMult(C,E);F=JXG.Math.matVecMult(C,G);a=JXG.Math.Numerics.Gauss(u,F);e=JXG.Math.Numerics.generatePolynomialTerm(a,D,"x",3)}I=a[D];for(z=D-1;z>=0;z--){I=(I*H+a[z])}return I};p.getTerm=function(){return e};return p};JXG.Math.Numerics.bezier=function(b){var a=0;return[function(e,d){var k=Math.floor(e)*3,h=e%1,g=1-h;if(!d){a=Math.floor(b.length/3)}if(e<0){return b[0].X()}if(e>=a){return b[b.length-1].X()}if(isNaN(e)){return NaN}return g*g*(g*b[k].X()+3*h*b[k+1].X())+(3*g*b[k+2].X()+h*b[k+3].X())*h*h},function(e,d){var k=Math.floor(e)*3,h=e%1,g=1-h;if(!d){a=Math.floor(b.length/3)}if(e<0){return b[0].Y()}if(e>=a){return b[b.length-1].Y()}if(isNaN(e)){return NaN}return g*g*(g*b[k].Y()+3*h*b[k+1].Y())+(3*g*b[k+2].Y()+h*b[k+3].Y())*h*h},0,function(){return Math.floor(b.length/3)}]};JXG.Math.Numerics.D=function(d,e){var b=0.00001,a=1/(b*2);if(arguments.length==1||(arguments.length>1&&typeof arguments[1]=="undefined")){return function(g,h){return(d(g+b,h)-d(g-b,h))*a}}else{return function(g,h){return(d.apply(e,[g+b,h])-d.apply(e,[g-b,h]))*a}}};JXG.Math.Numerics.I=function(a,b){return JXG.Math.Numerics.NewtonCotes(a,b)};JXG.Math.Numerics.newton=function(g,a,k){var b=0,d=0.000001,e=g.apply(k,[a]),l;while(b<50&&Math.abs(e)>d){l=this.D(g,k)(a);if(Math.abs(l)>d){a-=e/l}else{a+=(Math.random()*0.2-1)}e=g.apply(k,[a]);b++}return a};JXG.Math.Numerics.root=function(b,a,d){return this.newton(b,a,d)};JXG.Math.Numerics.cosh=function(a){return(Math.exp(a)+Math.exp(-a))*0.5};JXG.Math.Numerics.sinh=function(a){return(Math.exp(a)-Math.exp(-a))*0.5};JXG.Math.Numerics.riemann=function(m,g,o,d,h){var e,w,l,u,k,s,p,b,a,q;e=[];w=[];k=0;s=d;g=Math.floor(g);e[k]=s;w[k]=0;if(g>0){u=(h-d)/g;a=u*0.01;for(l=0;l<g;l++){if(o=="right"){p=m(s+u)}else{if(o=="middle"){p=m(s+u*0.5)}else{if((o=="left")||(o=="trapezodial")){p=m(s)}else{if(o=="lower"){p=m(s);for(b=s+a;b<=s+u;b+=a){q=m(b);if(q<p){p=q}}}else{p=m(s);for(b=s+a;b<=s+u;b+=a){q=m(b);if(q>p){p=q}}}}}}k++;e[k]=s;w[k]=p;k++;s+=u;if(o=="trapezodial"){p=m(s)}e[k]=s;w[k]=p;k++;e[k]=s;w[k]=0}}return[e,w]};JXG.Math.Numerics.riemannsum=function(k,e,m,d,g){var l,h,s,q,o,b,a,p;l=0;q=d;e=Math.floor(e);if(e>0){s=(g-d)/e;a=s*0.01;for(h=0;h<e;h++){if(m=="right"){o=k(q+s)}else{if(m=="middle"){o=k(q+s*0.5)}else{if(m=="trapezodial"){o=0.5*(k(q+s)+k(q))}else{if(m=="left"){o=k(q)}else{if(m=="lower"){o=k(q);for(b=q+a;b<=q+s;b+=a){p=k(b);if(p<o){o=p}}}else{o=k(q);for(b=q+a;b<=q+s;b+=a){p=k(b);if(p>o){o=p}}}}}}}l+=s*o;q+=s}}return l};JXG.Math.Numerics.Butcher=function(){this.s=0;this.A=[];this.b=[];this.c=[]};JXG.Math.Numerics.predefinedButcher={};JXG.Math.Numerics.predefinedButcher.RK4={s:4,A:[[0,0,0,0],[0.5,0,0,0],[0,0.5,0,0],[0,0,1,0]],b:[1/6,1/3,1/3,1/6],c:[0,0.5,0.5,1]};JXG.Math.Numerics.predefinedButcher.Heun={s:2,A:[[0,0],[1,0]],b:[0.5,0.5],c:[0,1]};JXG.Math.Numerics.predefinedButcher.Euler={s:1,A:[[0]],b:[1],c:[0]};JXG.Math.Numerics.rungeKutta=function(d,H,o,g,G){var p=[],m=[],F=(o[1]-o[0])/g,u=o[0],J,E,D,B,A,C=H.length,w=d.s,b=1000,a=g/b,q=[],z=0;for(J=0;J<C;J++){p[J]=H[J]}for(E=0;E<g;E++){q[z]=[];for(J=0;J<C;J++){q[z][J]=p[J]}z++;B=[];for(D=0;D<w;D++){for(J=0;J<C;J++){m[J]=0}for(A=0;A<D;A++){for(J=0;J<C;J++){m[J]+=(d.A[D][A])*F*B[A][J]}}for(J=0;J<C;J++){m[J]+=p[J]}B.push(G(u+d.c[D]*F,m))}for(J=0;J<C;J++){m[J]=0}for(A=0;A<w;A++){for(J=0;J<C;J++){m[J]+=d.b[A]*B[A][J]}}for(J=0;J<C;J++){p[J]=p[J]+F*m[J]}u+=F}return q};JXG.MathStatistics=function(){};JXG.MathStatistics.prototype.sum=function(b){var e,a,d=0;for(e=0,a=b.length;e<a;e++){d+=b[e]}return d};JXG.MathStatistics.prototype.prod=function(b){var e,a,d=1;for(e=0,a=b.length;e<a;e++){d*=b[e]}return d};JXG.MathStatistics.prototype.mean=function(a){if(a.length>0){return this.sum(a)/a.length}else{return 0}};JXG.MathStatistics.prototype.median=function(b){var d,a;if(b.length>0){d=b.clone();d.sort(function(g,e){return g-e});a=d.length;if(a%2==1){return d[parseInt(a*0.5)]}else{return(d[a*0.5-1]+d[a*0.5])*0.5}}else{return 0}};JXG.MathStatistics.prototype.variance=function(d){var b,g,e,a;if(d.length>1){b=this.mean(d);g=0;for(e=0,a=d.length;e<a;e++){g+=(d[e]-b)*(d[e]-b)}return g/(d.length-1)}else{return 0}};JXG.MathStatistics.prototype.sd=function(a){return Math.sqrt(this.variance(a))};JXG.MathStatistics.prototype.weightedMean=function(a,b){if(a.length!=b.length){return}if(a.length>0){return this.mean(this.multiply(a,b))}else{return 0}};JXG.MathStatistics.prototype.max=function(b){var e,d,a;if(b.length==0){return NaN}e=b[0];for(d=1,a=b.length;d<a;d++){e=(b[d]>e)?(b[d]):e}return e};JXG.MathStatistics.prototype.min=function(b){var e,d,a;if(b.length==0){return NaN}e=b[0];for(d=1,a=b.length;d<a;d++){e=(b[d]<e)?(b[d]):e}return e};JXG.MathStatistics.prototype.range=function(a){return[this.min(a),this.max(a)]};JXG.MathStatistics.prototype.diff=function(a){return a};JXG.MathStatistics.prototype.min=function(b){var e,d,a;if(b.length==0){return NaN}e=b[0];for(d=1,a=b.length;d<a;d++){e=(b[d]<e)?(b[d]):e}return e};JXG.MathStatistics.prototype.abs=function(b){var e,a,d=[];if(typeof JXG.isArray(arr1)){for(e=0,a=b.length;e<a;e++){d[e]=Math.abs(b[e])}}else{if(typeof b=="number"){return Math.abs(b)}else{d=null}}return d};JXG.MathStatistics.prototype.add=function(d,b){var g,a,e=[];if(typeof JXG.isArray(d)&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]+b}}else{if(typeof d=="number"&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d+b[g]}}else{if(typeof JXG.isArray(d)&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]+b[g]}}else{if(typeof d=="number"&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d+b}}else{e=null}}}}return e};JXG.MathStatistics.prototype.divide=function(d,b){var g,a,e=[];if(typeof JXG.isArray(d)&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]/b}}else{if(typeof d=="number"&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d/b[g]}}else{if(typeof JXG.isArray(d)&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]/b[g]}}else{if(typeof d=="number"&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d/b}}else{e=null}}}}return e};JXG.MathStatistics.prototype.mod=function(d,b){var g,a,e=[];if(typeof JXG.isArray(d)&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]%b}}else{if(typeof d=="number"&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d%b[g]}}else{if(typeof JXG.isArray(d)&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]%b[g]}}else{if(typeof d=="number"&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d%b}}else{e=null}}}}return e};JXG.MathStatistics.prototype.multiply=function(d,b){var g,a,e=[];if(typeof JXG.isArray(d)&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]*b}}else{if(typeof d=="number"&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d*b[g]}}else{if(typeof JXG.isArray(d)&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]*b[g]}}else{if(typeof d=="number"&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d*b}}else{e=null}}}}return e};JXG.MathStatistics.prototype.subtract=function(d,b){var g,a,e=[];if(typeof JXG.isArray(d)&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]-b}}else{if(typeof d=="number"&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d-b[g]}}else{if(typeof JXG.isArray(d)&&typeof JXG.isArray(b)){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d[g]-b[g]}}else{if(typeof d=="number"&&typeof b=="number"){for(g=0,a=Math.min(d.length,b.length);g<a;g++){e[g]=d-b}}else{e=null}}}}return e};JXG.Math.Symbolic={};JXG.Math.Symbolic.generateSymbolicCoordinatesPartial=function(o,g,e,b){function a(k){if(b=="underscore"){return""+e+"_{"+k+"}"}else{if(b=="brace"){return""+e+"["+k+"]"}else{return""+e+""+k}}}var l=g.ancestors;var h=0;var m;for(var p in l){m=0;if(JXG.isPoint(l[p])){for(var d in l[p].ancestors){m++}if(m==0){l[p].symbolic.x=g.ancestors[p].coords.usrCoords[1];l[p].symbolic.y=g.ancestors[p].coords.usrCoords[2]}else{h++;g.ancestors[p].symbolic.x=a(h);h++;g.ancestors[p].symbolic.y=a(h)}}}if(JXG.isPoint(g)){g.symbolic.x="x";g.symbolic.y="y"}return h};JXG.Math.Symbolic.clearSymbolicCoordinates=function(b){for(var a in b.objects){if(JXG.isPoint(b.objects[a])){b.objects[a].symbolic.x="";b.objects[a].symbolic.y=""}}};JXG.Math.Symbolic.generatePolynomials=function(m,e,g){if(g){this.generateSymbolicCoordinatesPartial(m,e,"u","brace")}var h=e.ancestors;h[e.id]=e;var l;var a=[];var p=[];for(var o in h){l=0;a=[];if(JXG.isPoint(h[o])){for(var b in h[o].ancestors){l++}if(l>0){a=h[o].generatePolynomial();for(var d=0;d<a.length;d++){p.push(a[d])}}}}if(g){this.clearSymbolicCoordinates(m)}return p};JXG.Math.Symbolic.geometricLocusByGroebnerBase=function(g,k,m){var h=this.generateSymbolicCoordinatesPartial(g,k,"u","brace");var a=this.generatePolynomials(g,k);var d=a.join(",");var b=new JXG.Coords(JXG.COORDS_BY_USR,[0,0],g);var e=new JXG.Coords(JXG.COORDS_BY_USR,[g.canvasWidth,g.canvasHeight],g);var l=JXG.serverBase+"jxggroebner.py?number="+h+"&polynomials="+JXG.Util.Base64.encode(d)+"&xs="+b.usrCoords[1]+"&xe="+e.usrCoords[1]+"&ys="+e.usrCoords[2]+"&ye="+b.usrCoords[2];this.cbp=function(B){var z=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(B))).unzip();z=z.toString().replace(/,geonext\.gxt/g,"").replace(/\s/g,"");var o=z.split("-----");z=o[0];var q=z.split(";");var u;var A=[];var w=[];for(var p=0;p<q.length;p++){u=q[p].split(",");A[p]=u[0];w[p]=u[1]}var s=g.createElement("curve",[A,w],{strokeColor:"green",strokeWidth:"2px"});this.rendNode=s.rendNode;m(o[1].split(";"))};this.cb=JXG.bind(this.cbp,this);JXG.FileReader.parseFileContent(l,this.cb,"raw");this.clearSymbolicCoordinates(g)};JXG.Complex=function(a,b){this.isComplex=true;if(typeof a=="undefined"){a=0}if(typeof b=="undefined"){b=0}if(a.isComplex){b=a.imaginary;a=a.real}this.real=a;this.imaginary=b;this.absval=0;this.angle=0};JXG.Complex.prototype.toString=function(){return""+this.real+" + "+this.imaginary+"i"};JXG.Complex.prototype.add=function(a){if(typeof a=="number"){this.real+=a}else{this.real+=a.real;this.imaginary+=a.imaginary}};JXG.Complex.prototype.sub=function(a){if(typeof a=="number"){this.real-=a}else{this.real-=a.real;this.imaginary-=a.imaginary}};JXG.Complex.prototype.mult=function(a){if(typeof a=="number"){this.real*=a;this.imaginary*=a}else{this.real=this.real*a.real-this.imaginary*a.imaginary;this.imaginary=this.real*a.imaginary+this.imaginary*a.real}};JXG.Complex.prototype.div=function(b){var a;if(typeof b=="number"){if(Math.abs(b)<Math.eps){this.real=Infinity;this.imaginary=Infinity;return}this.real/=b;this.imaginary/=b}else{if((Math.abs(b.real)<Math.eps)&&(Math.abs(b.imaginary)<Math.eps)){this.real=Infinity;this.imaginary=Infinity;return}a=b.real*b.real+b.imaginary*b.imaginary;this.real=(this.real*b.real+this.imaginary*b.imaginary)/a;this.imaginary=(this.imaginary*b.real-this.real*b.imaginary)/a}};JXG.C={};JXG.C.add=function(b,a){var d=new JXG.Complex(b);d.add(a);return d};JXG.C.sub=function(b,a){var d=new JXG.Complex(b);d.sub(a);return d};JXG.C.mult=function(b,a){var d=new JXG.Complex(b);d.mult(a);return d};JXG.C.div=function(b,a){var d=new JXG.Complex(b);d.div(a);return d};JXG.AbstractRenderer=function(){this.vOffsetText=8;this.enhancedRendering=true};JXG.AbstractRenderer.prototype.drawPoint=function(a){var b,d=a.visProp.face;if(d=="cross"||d=="x"){b=this.createPrimitive("path",a.id);this.appendChildPrimitive(b,"points");this.appendNodesToElement(a,"path")}else{if(d=="circle"||d=="o"){b=this.createPrimitive("circle",a.id);this.appendChildPrimitive(b,"points");this.appendNodesToElement(a,"circle")}else{if(d=="square"||d=="[]"){b=this.createPrimitive("rect",a.id);this.appendChildPrimitive(b,"points");this.appendNodesToElement(a,"rect")}else{if(d=="plus"||d=="+"){b=this.createPrimitive("path",a.id);this.appendChildPrimitive(b,"points");this.appendNodesToElement(a,"path")}}}}a.rendNode=b;this.setObjectStrokeWidth(a,a.visProp.strokeWidth);this.setObjectStrokeColor(a,a.visProp.strokeColor,a.visProp.strokeOpacity);this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillOpacity);this.updatePoint(a)};JXG.AbstractRenderer.prototype.updatePoint=function(b){var a=b.visProp.size,d=b.visProp.face;if(isNaN(b.coords.scrCoords[2])||isNaN(b.coords.scrCoords[1])){return}if(this.enhancedRendering){if(!b.visProp.draft){this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity)}else{this.setDraft(b)}}if(d=="cross"||d=="x"){this.updatePathPrimitive(b.rendNode,this.updatePathStringPoint(b,a,"x"),b.board)}else{if(d=="circle"||d=="o"){this.updateCirclePrimitive(b.rendNode,b.coords.scrCoords[1],b.coords.scrCoords[2],a+1)}else{if(d=="square"||d=="[]"){this.updateRectPrimitive(b.rendNode,b.coords.scrCoords[1]-a,b.coords.scrCoords[2]-a,a*2,a*2)}else{if(d=="plus"||d=="+"){this.updatePathPrimitive(b.rendNode,this.updatePathStringPoint(b,a,"+"),b.board)}}}}this.setShadow(b)};JXG.AbstractRenderer.prototype.changePointStyle=function(a){var b=this.getElementById(a.id);if(b!=null){this.remove(b)}this.drawPoint(a);if(!a.visProp.visible){this.hide(a)}if(a.visProp.draft){this.setDraft(a)}};JXG.AbstractRenderer.prototype.drawLine=function(a){var b=this.createPrimitive("line",a.id);this.appendChildPrimitive(b,"lines");this.appendNodesToElement(a,"lines");this.updateLine(a)};JXG.AbstractRenderer.prototype.updateLine=function(b){var q=new JXG.Coords(JXG.COORDS_BY_USER,b.point1.coords.usrCoords,b.board),p=new JXG.Coords(JXG.COORDS_BY_USER,b.point2.coords.usrCoords,b.board),a,s,h,g,o,e,l,k,d;this.calcStraight(b,q,p);this.updateLinePrimitive(b.rendNode,q.scrCoords[1],q.scrCoords[2],p.scrCoords[1],p.scrCoords[2]);if(b.image!=null){a=q.scrCoords[1];s=q.scrCoords[2];h=p.scrCoords[1];g=p.scrCoords[2];o;e=(h-a>0)?1:-1;if(Math.abs(h-a)>1e-7){o=Math.atan((g-s)/(h-a))+((e<0)?Math.PI:0)}else{o=((g-s>0)?0.5:-0.5)*Math.PI}l=250;k=256;d=[[1,0,0],[l*(1-Math.cos(o))+k*Math.sin(o),Math.cos(o),-Math.sin(o)],[k*(1-Math.cos(o))-l*Math.sin(o),Math.sin(o),Math.cos(o)]];b.imageTransformMatrix=d}this.makeArrows(b);if(this.enhancedRendering){if(!b.visProp.draft){this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setDashStyle(b,b.visProp);this.setShadow(b)}else{this.setDraft(b)}}};JXG.AbstractRenderer.prototype.calcStraight=function(g,u,p){var d,a,m,k,w,e,q,o,B,l,h,A,z;q=g.board.algebra;w=g.visProp.straightFirst;e=g.visProp.straightLast;if(Math.abs(u.scrCoords[0])<q.eps){w=true}if(Math.abs(p.scrCoords[0])<q.eps){e=true}if(!w&&!e){return}o=[];o[0]=g.stdform[0]-g.stdform[1]*g.board.origin.scrCoords[1]/g.board.stretchX+g.stdform[2]*g.board.origin.scrCoords[2]/g.board.stretchY;o[1]=g.stdform[1]/g.board.stretchX;o[2]=g.stdform[2]/(-g.board.stretchY);if(isNaN(o[0]+o[1]+o[2])){return}B=[];B[0]=q.crossProduct(o,[0,0,1]);B[1]=q.crossProduct(o,[0,1,0]);B[2]=q.crossProduct(o,[-g.board.canvasHeight,0,1]);B[3]=q.crossProduct(o,[-g.board.canvasWidth,1,0]);for(l=0;l<4;l++){if(Math.abs(B[l][0])>q.eps){for(h=2;h>0;h--){B[l][h]/=B[l][0]}B[l][0]=1}}d=false;a=false;if(!w&&u.scrCoords[1]>=0&&u.scrCoords[1]<=g.board.canvasWidth&&u.scrCoords[2]>=0&&u.scrCoords[2]<=g.board.canvasHeight){d=true}if(!e&&p.scrCoords[1]>=0&&p.scrCoords[1]<=g.board.canvasWidth&&p.scrCoords[2]>=0&&p.scrCoords[2]<=g.board.canvasHeight){a=true}if(Math.abs(B[1][0])<q.eps){m=B[0];k=B[2]}else{if(Math.abs(B[0][0])<q.eps){m=B[1];k=B[3]}else{if(B[1][2]<0){m=B[0];if(B[3][2]>g.board.canvasHeight){k=B[2]}else{k=B[3]}}else{if(B[1][2]>g.board.canvasHeight){m=B[2];if(B[3][2]<0){k=B[0]}else{k=B[3]}}else{m=B[1];if(B[3][2]<0){k=B[0]}else{if(B[3][2]>g.board.canvasHeight){k=B[2]}else{k=B[3]}}}}}}m=new JXG.Coords(JXG.COORDS_BY_SCREEN,m.slice(1),g.board);k=new JXG.Coords(JXG.COORDS_BY_SCREEN,k.slice(1),g.board);if(!d){if(!a){if(this.isSameDirection(u,p,m)){if(!this.isSameDirection(u,p,k)){z=m;A=k}else{if(g.board.algebra.affineDistance(p.usrCoords,m.usrCoords)<g.board.algebra.affineDistance(p.usrCoords,k.usrCoords)){A=m;z=k}else{z=m;A=k}}}else{if(this.isSameDirection(u,p,k)){A=m;z=k}else{if(g.board.algebra.affineDistance(p.usrCoords,m.usrCoords)<g.board.algebra.affineDistance(p.usrCoords,k.usrCoords)){z=m;A=k}else{A=m;z=k}}}}else{if(this.isSameDirection(p,u,m)){A=m}else{A=k}}}else{if(!a){if(this.isSameDirection(u,p,m)){z=m}else{z=k}}}if(A){u.setCoordinates(JXG.COORDS_BY_USER,A.usrCoords.slice(1))}if(z){p.setCoordinates(JXG.COORDS_BY_USER,z.usrCoords.slice(1))}};JXG.AbstractRenderer.prototype.isSameDirection=function(k,e,d){var b,a,h,g;b=e.usrCoords[1]-k.usrCoords[1];a=e.usrCoords[2]-k.usrCoords[2];h=d.usrCoords[1]-k.usrCoords[1];g=d.usrCoords[2]-k.usrCoords[2];if(Math.abs(b)<JXG.Math.eps){b=0}if(Math.abs(a)<JXG.Math.eps){a=0}if(Math.abs(h)<JXG.Math.eps){h=0}if(Math.abs(g)<JXG.Math.eps){g=0}if(b>=0&&h>=0){if((a>=0&&g>=0)||(a<=0&&g<=0)){return true}}else{if(b<=0&&h<=0){if((a>=0&&g>=0)||(a<=0&&g<=0)){return true}}}return false};JXG.AbstractRenderer.prototype.updateTicks=function(b,e,a,g,d){};JXG.AbstractRenderer.prototype.removeTicks=function(a){var b=this.getElementById(a.id+"_ticks");this.remove(b)};JXG.AbstractRenderer.prototype.drawArrow=function(a){var b=this.createPrimitive("line",a.id);this.setObjectStrokeWidth(a,a.visProp.strokeWidth);this.setObjectStrokeColor(a,a.visProp.strokeColor,a.visProp.strokeOpacity);this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillOpacity);this.setDashStyle(a,a.visProp);this.makeArrow(b,a);this.appendChildPrimitive(b,"lines");this.appendNodesToElement(a,"lines");this.updateArrow(a)};JXG.AbstractRenderer.prototype.updateArrow=function(a){if(this.enhancedRendering){if(!a.visProp.draft){this.setObjectStrokeWidth(a,a.visProp.strokeWidth);this.setObjectStrokeColor(a,a.visProp.strokeColor,a.visProp.strokeOpacity);this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillOpacity);this.setShadow(a);this.setDashStyle(a,a.visProp)}else{this.setDraft(a)}}this.updateLinePrimitive(a.rendNode,a.point1.coords.scrCoords[1],a.point1.coords.scrCoords[2],a.point2.coords.scrCoords[1],a.point2.coords.scrCoords[2])};JXG.AbstractRenderer.prototype.drawCurve=function(a){var b=this.createPrimitive("path",a.id);this.appendChildPrimitive(b,"curves");this.appendNodesToElement(a,"path");this.setObjectStrokeWidth(a,a.visProp.strokeWidth);this.setObjectStrokeColor(a,a.visProp.strokeColor,a.visProp.strokeOpacity);this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillOpacity);this.setDashStyle(a,a.visProp);this.updateCurve(a)};JXG.AbstractRenderer.prototype.updateCurve=function(a){if(this.enhancedRendering){if(!a.visProp.draft){this.setObjectStrokeWidth(a,a.visProp.strokeWidth);this.setObjectStrokeColor(a,a.visProp.strokeColor,a.visProp.strokeOpacity);this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillOpacity);this.setDashStyle(a,a.visProp);this.setShadow(a)}else{this.setDraft(a)}}this.updatePathPrimitive(a.rendNode,this.updatePathStringPrimitive(a),a.board)};JXG.AbstractRenderer.prototype.drawCircle=function(a){var b=this.createPrimitive("ellipse",a.id);this.appendChildPrimitive(b,"circles");this.appendNodesToElement(a,"ellipse");this.updateCircle(a)};JXG.AbstractRenderer.prototype.updateCircle=function(b){if(this.enhancedRendering){if(!b.visProp.draft){this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity);this.setDashStyle(b,b.visProp);this.setShadow(b)}else{this.setDraft(b)}}var a=b.getRadius();if(a>0&&!isNaN(b.midpoint.coords.scrCoords[1]+b.midpoint.coords.scrCoords[2])){this.updateEllipsePrimitive(b.rendNode,b.midpoint.coords.scrCoords[1],b.midpoint.coords.scrCoords[2],(a*b.board.stretchX),(a*b.board.stretchY))}};JXG.AbstractRenderer.prototype.drawPolygon=function(a){var b=this.createPrimitive("polygon",a.id);a.visProp.fillOpacity=0.3;this.appendChildPrimitive(b,"polygone");this.appendNodesToElement(a,"polygon");this.updatePolygon(a)};JXG.AbstractRenderer.prototype.updatePolygon=function(a){if(this.enhancedRendering){if(!a.visProp.draft){this.setObjectStrokeWidth(a,a.visProp.strokeWidth);this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillOpacity);this.setShadow(a)}else{this.setDraft(a)}}this.updatePolygonePrimitive(a.rendNode,a)};JXG.AbstractRenderer.prototype.drawArc=function(a){};JXG.AbstractRenderer.prototype.updateArc=function(a){};JXG.AbstractRenderer.prototype.drawText=function(a){var b=this.container.ownerDocument.createElement("div");b.setAttribute("id",a.id);b.style.position="absolute";b.style.fontSize=a.board.fontSize+"px";b.style.color=a.visProp.strokeColor;b.className="JXGtext";b.style.zIndex="10";this.container.appendChild(b);a.rendNode=b;a.htmlStr="";this.updateText(a)};JXG.AbstractRenderer.prototype.updateText=function(a){if(a.visProp.visible==false){return}if(isNaN(a.coords.scrCoords[1]+a.coords.scrCoords[2])){return}this.updateTextStyle(a);a.rendNode.style.left=(a.coords.scrCoords[1])+"px";a.rendNode.style.top=(a.coords.scrCoords[2]-this.vOffsetText)+"px";a.updateText();if(a.htmlStr!=a.plaintextStr){a.rendNode.innerHTML=a.plaintextStr;a.htmlStr=a.plaintextStr}};JXG.AbstractRenderer.prototype.updateTextStyle=function(b){var a;if(b.visProp.fontSize){if(typeof b.visProp.fontSize=="function"){a=b.visProp.fontSize();b.rendNode.style.fontSize=(a>0?a:0)}else{b.rendNode.style.fontSize=(b.visProp.fontSize)}}};JXG.AbstractRenderer.prototype.drawAngle=function(a){};JXG.AbstractRenderer.prototype.updateAngle=function(a){};JXG.AbstractRenderer.prototype.drawImage=function(a){};JXG.AbstractRenderer.prototype.updateImage=function(a){this.updateRectPrimitive(a.rendNode,a.coords.scrCoords[1],a.coords.scrCoords[2]-a.size[1],a.size[0],a.size[1]);if(a.parent!=null){this.transformImageParent(a,a.parent.imageTransformMatrix)}else{this.transformImageParent(a)}this.transformImage(a,a.transformations)};JXG.AbstractRenderer.prototype.drawGrid=function(g){var C=g.gridX,A=g.gridY,w=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],g),h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[g.canvasWidth,g.canvasHeight],g),D=Math.ceil(w.usrCoords[1]),z=0,B,a,s,u,p,o,q,m,b,d,e;g.hasGrid=true;for(B=0;B<=C+1;B++){if(D-B/C<w.usrCoords[1]){z=B-1;break}}D=Math.floor(h.usrCoords[1]);a=0;for(B=0;B<=C+1;B++){if(D+B/C>h.usrCoords[1]){a=B-1;break}}D=Math.ceil(h.usrCoords[2]);u=0;for(B=0;B<=A+1;B++){if(D-B/A<h.usrCoords[2]){u=B-1;break}}D=Math.floor(w.usrCoords[2]);s=0;for(B=0;B<=A+1;B++){if(D+B/A>w.usrCoords[2]){s=B-1;break}}p=Math.round((1/C)*g.stretchX);o=Math.round((1/A)*g.stretchY);q=new JXG.Coords(JXG.COORDS_BY_USER,[Math.ceil(w.usrCoords[1])-z/C,Math.floor(w.usrCoords[2])+s/A],g);m=new JXG.Coords(JXG.COORDS_BY_USER,[Math.floor(h.usrCoords[1])+a/C,Math.ceil(h.usrCoords[2])-u/A],g);b=this.drawVerticalGrid(q,m,p,g);this.appendChildPrimitive(b,"grid");if(!g.snapToGrid){d=new Object();d.rendNode=b;d.elementClass=JXG.OBJECT_CLASS_LINE;d.id="gridx";this.setObjectStrokeColor(d,g.gridColor,g.gridOpacity)}else{d=new Object();d.rendNode=b;d.elementClass=JXG.OBJECT_CLASS_LINE;d.id="gridx";this.setObjectStrokeColor(d,"#FF8080",0.5)}this.setPropertyPrimitive(b,"stroke-width","0.4px");if(g.gridDash){this.setGridDash("gridx")}b=this.drawHorizontalGrid(q,m,o,g);this.appendChildPrimitive(b,"grid");if(!g.snapToGrid){d=new Object();d.rendNode=b;d.elementClass=JXG.OBJECT_CLASS_LINE;d.id="gridy";this.setObjectStrokeColor(d,g.gridColor,g.gridOpacity)}else{d=new Object();d.rendNode=b;d.elementClass=JXG.OBJECT_CLASS_LINE;d.id="gridy";this.setObjectStrokeColor(d,"#FF8080",0.5)}this.setPropertyPrimitive(b,"stroke-width","0.4px");if(g.gridDash){this.setGridDash("gridy")}};JXG.AbstractRenderer.prototype.removeGrid=function(a){};JXG.AbstractRenderer.prototype.hide=function(a){};JXG.AbstractRenderer.prototype.show=function(a){};JXG.AbstractRenderer.prototype.setObjectStrokeWidth=function(b,a){};JXG.AbstractRenderer.prototype.setObjectStrokeColor=function(d,a,b){};JXG.AbstractRenderer.prototype.setObjectFillColor=function(d,a,b){};JXG.AbstractRenderer.prototype.setDraft=function(b){if(!b.visProp.draft){return}var a=b.board.options.elements.draft.color,d=b.board.options.elements.draft.opacity;if(b.type==JXG.OBJECTT_TYPE_POLYGON){this.setObjectFillColor(b,a,d)}else{if(b.elementClass==JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(b,a,d)}else{this.setObjectFillColor(b,"none",0)}this.setObjectStrokeColor(b,a,d);this.setObjectStrokeWidth(b,b.board.options.elements.draft.strokeWidth)}};JXG.AbstractRenderer.prototype.removeDraft=function(a){if(a.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillColorOpacity)}else{if(a.type==JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(a,a.visProp.fillColor,a.visProp.fillColorOpacity)}this.setObjectStrokeColor(a,a.visProp.strokeColor,a.visProp.strokeColorOpacity);this.setObjectStrokeWidth(a,a.visProp.strokeWidth)}};JXG.AbstractRenderer.prototype.highlight=function(b){var a;if(b.visProp.draft==false){if(b.type==JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(b,b.visProp.highlightStrokeColor,b.visProp.highlightStrokeOpacity);this.setObjectFillColor(b,b.visProp.highlightStrokeColor,b.visProp.highlightStrokeOpacity)}else{if(b.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(b,b.visProp.highlightFillColor,b.visProp.highlightFillOpacity);for(a=0;a<b.borders.length;a++){this.setObjectStrokeColor(b.borders[a],b.borders[a].visProp.highlightStrokeColor,b.visProp.highlightStrokeOpacity)}}else{this.setObjectStrokeColor(b,b.visProp.highlightStrokeColor,b.visProp.highlightStrokeOpacity);this.setObjectFillColor(b,b.visProp.highlightFillColor,b.visProp.highlightFillOpacity)}}}};JXG.AbstractRenderer.prototype.noHighlight=function(b){var a;if(b.visProp.draft==false){if(b.type==JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity)}else{if(b.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity);for(a=0;a<b.borders.length;a++){this.setObjectStrokeColor(b.borders[a],b.borders[a].visProp.strokeColor,b.visProp.strokeOpacity)}}else{this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity)}}}};JXG.AbstractRenderer.prototype.remove=function(a){};JXG.AbstractRenderer.prototype.suspendRedraw=function(){};JXG.AbstractRenderer.prototype.unsuspendRedraw=function(){};JXG.AbstractRenderer.prototype.drawZoomBar=function(k){var m,d,h,g,b,o,l,a,e;m=this.container.ownerDocument;d=m.createElement("div");d.className="JXGtext";d.style.color="#aaaaaa";d.style.backgroundColor="#f5f5f5";d.style.padding="2px";d.style.position="absolute";d.style.fontSize="10px";d.style.cursor="pointer";d.style.zIndex="100";this.container.appendChild(d);d.style.right="5px";d.style.bottom="5px";h=m.createElement("span");d.appendChild(h);h.innerHTML="&nbsp;&ndash;&nbsp;";JXG.addEvent(h,"click",k.zoomOut,k);g=m.createElement("span");d.appendChild(g);g.innerHTML="&nbsp;o&nbsp;";JXG.addEvent(g,"click",k.zoom100,k);b=m.createElement("span");d.appendChild(b);b.innerHTML="&nbsp;+&nbsp;";JXG.addEvent(b,"click",k.zoomIn,k);o=m.createElement("span");d.appendChild(o);o.innerHTML="&nbsp;&larr;&nbsp;";JXG.addEvent(o,"click",k.clickLeftArrow,k);l=m.createElement("span");d.appendChild(l);l.innerHTML="&nbsp;&uarr;&nbsp;";JXG.addEvent(l,"click",k.clickUpArrow,k);a=m.createElement("span");d.appendChild(a);a.innerHTML="&nbsp;&darr;&nbsp;";JXG.addEvent(a,"click",k.clickDownArrow,k);e=m.createElement("span");d.appendChild(e);e.innerHTML="&nbsp;&rarr;&nbsp;";JXG.addEvent(e,"click",k.clickRightArrow,k)};JXG.AbstractRenderer.prototype.getElementById=function(a){return document.getElementById(a)};JXG.AbstractRenderer.prototype.findSplit=function(A,l,h){var p=0,m=l,o,g,B,z,w,e,u,b,q,s,a;if(h-l<2){return[-1,0]}B=A[l].scrCoords;z=A[h].scrCoords;if(isNaN(B[1]+B[2]+z[1]+z[2])){return[NaN,h]}for(g=l+1;g<h;g++){w=A[g].scrCoords;e=w[1]-B[1];u=w[2]-B[2];b=z[1]-B[1];q=z[2]-B[2];s=b*b+q*q;if(s>=JXG.Math.eps){a=(e*b+u*q)/s;o=e*e+u*u-a*(e*b+u*q)}else{a=0;o=e*e+u*u}if(a<0){o=e*e+u*u}else{if(a>1){e=w[1]-z[1];u=w[2]-z[2];o=e*e+u*u}}if(o>p){p=o;m=g}}return[Math.sqrt(p),m]};JXG.AbstractRenderer.prototype.RDP=function(h,g,e,b,d){var a=this.findSplit(h,g,e);if(a[0]>b){this.RDP(h,g,a[1],b,d);this.RDP(h,a[1],e,b,d)}else{d.push(h[e])}};JXG.AbstractRenderer.prototype.RamenDouglasPeuker=function(h,b){var e=[],g,d,a;a=h.length;g=0;while(g<a&&isNaN(h[g].scrCoords[1]+h[g].scrCoords[2])){g++}d=a-1;while(d>g&&isNaN(h[d].scrCoords[1]+h[d].scrCoords[2])){d--}if(g>d||g==a){return[]}e[0]=h[g];this.RDP(h,g,d,b,e);return e};JXG.AbstractRenderer.prototype.setShadow=function(a){};JXG.AbstractRenderer.prototype.updatePathStringPoint=function(d,a,b){};JXG.FileReader=new function(){this.parseFileContent=function(a,b,g){this.request=false;var d;try{this.request=new XMLHttpRequest();if(g.toLowerCase()=="raw"){this.request.overrideMimeType("text/plain; charset=iso-8859-1")}else{this.request.overrideMimeType("text/xml; charset=iso-8859-1")}}catch(d){try{this.request=new ActiveXObject("Msxml2.XMLHTTP")}catch(d){try{this.request=new ActiveXObject("Microsoft.XMLHTTP")}catch(d){this.request=false}}}if(!this.request){alert("AJAX not activated!");return}this.request.open("GET",a,true);if(g.toLowerCase()=="raw"){this.cbp=function(){var e=this.request;if(e.readyState==4){b(e.responseText)}}}else{this.cbp=function(){var e=this.request;if(e.readyState==4){this.parseString(e.responseText,b,g,a)}}}this.cb=JXG.bind(this.cbp,this);this.request.onreadystatechange=this.cb;this.request.send(null)};this.cleanWhitespace=function(a){var b=a.firstChild;while(b!=null){if(b.nodeType==3&&!/\S/.test(b.nodeValue)){a.removeChild(b)}else{if(b.nodeType==1){this.cleanWhitespace(b)}}b=b.nextSibling}};this.stringToXMLTree=function(b){if(typeof DOMParser=="undefined"){DOMParser=function(){};DOMParser.prototype.parseFromString=function(g,h){if(typeof ActiveXObject!="undefined"){var e=new ActiveXObject("MSXML.DomDocument");e.loadXML(g);return e}}}var d=new DOMParser();var a=d.parseFromString(b,"text/xml");this.cleanWhitespace(a);return a};this.parseString=function(e,d,g,b){if(g.toLowerCase()=="geonext"){e=JXG.GeonextReader.prepareString(e)}if(g.toLowerCase()=="geogebra"){e=JXG.GeogebraReader.prepareString(e)}if(g.toLowerCase()=="intergeo"){e=JXG.IntergeoReader.prepareString(e)}d.xmlString=e;var a=this.stringToXMLTree(e);this.readElements(a,d,g)};this.readElements=function(a,b,d){if(d.toLowerCase()=="geonext"){b.suspendUpdate();if(a.getElementsByTagName("GEONEXT").length!=0){JXG.GeonextReader.readGeonext(a,b)}b.unsuspendUpdate()}else{if(a.getElementsByTagName("geogebra").length!=0){JXG.GeogebraReader.readGeogebra(a,b)}else{if(d.toLowerCase()=="intergeo"){JXG.IntergeoReader.readIntergeo(a,b)}}}b.afterLoad()}};JXG.GeonextReader=new function(){this.changeOriginIds=function(a,b){if((b=="gOOe0")||(b=="gXOe0")||(b=="gYOe0")||(b=="gXLe0")||(b=="gYLe0")){return a.id+b}else{return b}};this.colorProperties=function(b,a){b.colorStroke=a.getElementsByTagName("color")[0].getElementsByTagName("stroke")[0].firstChild.data;b.highlightStrokeColor=a.getElementsByTagName("color")[0].getElementsByTagName("lighting")[0].firstChild.data;b.colorFill=a.getElementsByTagName("color")[0].getElementsByTagName("fill")[0].firstChild.data;b.colorLabel=a.getElementsByTagName("color")[0].getElementsByTagName("label")[0].firstChild.data;b.colorDraft=a.getElementsByTagName("color")[0].getElementsByTagName("draft")[0].firstChild.data;return b};this.firstLevelProperties=function(g,d){var a=d.childNodes,e,b;for(e=0;e<a.length;e++){if(a[e].firstChild!=null&&a[e].nodeName!="data"&&a[e].nodeName!="straight"){b=a[e].nodeName;g[b]=a[e].firstChild.data}}return g};this.boardProperties=function(b,a){return b};this.defProperties=function(b,a){if(a.nodeType==3||a.nodeType==8){return null}b.ident=a.nodeName;if(b.ident=="text"||b.ident=="intersection"||b.ident=="composition"){b.name=""}else{b.name=a.getElementsByTagName("name")[0].firstChild.data}b.id=a.getElementsByTagName("id")[0].firstChild.data;return b};this.visualProperties=function(b,a){b.visible=a.getElementsByTagName("visible")[0].firstChild.data;b.trace=a.getElementsByTagName("trace")[0].firstChild.data;return b};this.readNodes=function(k,e,b,g){var a=e.getElementsByTagName(b)[0].childNodes,d,h;for(h=0;h<a.length;h++){if(a[h].firstChild!=null){if(g!=null){d=g+JXG.capitalize(a[h].nodeName)}else{d=a[h].nodeName}k[d]=a[h].firstChild.data}}return k};this.subtreeToString=function(a){try{return(new XMLSerializer()).serializeToString(a)}catch(b){return a.xml}return null};this.readImage=function(d){var b="",a=d;if(a!=null){b=a.data;while(a.nextSibling!=null){a=a.nextSibling;b+=a.data}}return b};this.parseImage=function(m,l,a,q,p,s,k,e){var A,z,u,d,o,g,b;if(l==null){return null}if(l.getElementsByTagName("src")[0]!=null){A="src"}else{if(l.getElementsByTagName("image")[0]!=null){A="image"}else{return null}}b=this.readImage(l.getElementsByTagName(A)[0].firstChild);if(b!=""){if(A=="src"){q=l.getElementsByTagName("x")[0].firstChild.data;p=l.getElementsByTagName("y")[0].firstChild.data;s=l.getElementsByTagName("width")[0].firstChild.data;k=l.getElementsByTagName("height")[0].firstChild.data}else{g=document.createElement("img");g.setAttribute("id","tmpimg");g.style.display="none";document.getElementsByTagName("body")[0].appendChild(g);g.setAttribute("src","data:image/png;base64,"+b);z=g.width;u=g.height;z=(z==0)?3:z;u=(u==0)?3:u;p-=u*s/z*0.5;k=u*s/z;document.getElementsByTagName("body")[0].removeChild(g)}if(e!=null){d=e.id+"_image"}else{d=false}o=new JXG.Image(m,b,[q,p],[s,k],a,d,false,e);return o}};this.readConditions=function(h,g){var b,d,k,a;g.conditions="";if(h!=null){for(b=0;b<h.getElementsByTagName("data").length;b++){d;k;a=h.getElementsByTagName("data")[b];d=JXG.GeonextReader.subtreeToString(a);g.conditions+=d}}};this.printDebugMessage=function(a,e,d,b){};this.readGeonext=function(u,o){var q={},w,B,A,m,C,z,b,h,e,d,a,k,g,p,l;boardData=u.getElementsByTagName("board")[0];q.ident="board";q.id=boardData.getElementsByTagName("id")[0].firstChild.data;q.width=boardData.getElementsByTagName("width")[0].firstChild.data;q.height=boardData.getElementsByTagName("height")[0].firstChild.data;h=boardData.getElementsByTagName("fontsize")[0];q.fontSize=(h!=null)?document.body.style.fontSize=h.firstChild.data:document.body.style.fontSize;q.modus=boardData.getElementsByTagName("modus")[0].firstChild.data;h=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("origin")[0];q.originX=h.getElementsByTagName("x")[0].firstChild.data;q.originY=h.getElementsByTagName("y")[0].firstChild.data;h=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("zoom")[0];q.zoomX=h.getElementsByTagName("x")[0].firstChild.data;q.zoomY=h.getElementsByTagName("y")[0].firstChild.data;h=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("unit")[0];q.unitX=h.getElementsByTagName("x")[0].firstChild.data;q.unitY=h.getElementsByTagName("y")[0].firstChild.data;h=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("viewport")[0];q.viewportTop=h.getElementsByTagName("top")[0].firstChild.data;q.viewportLeft=h.getElementsByTagName("left")[0].firstChild.data;q.viewportBottom=h.getElementsByTagName("bottom")[0].firstChild.data;q.viewportRight=h.getElementsByTagName("right")[0].firstChild.data;this.readConditions(boardData.getElementsByTagName("conditions")[0],q);o.origin={};o.origin.usrCoords=[1,0,0];o.origin.scrCoords=[1,1*q.originX,1*q.originY];o.zoomX=1*q.zoomX;o.zoomY=1*q.zoomY;o.unitX=1*q.unitX;o.unitY=1*q.unitY;o.stretchX=o.zoomX*o.unitX;o.stretchY=o.zoomY*o.unitY;if(1*q.fontSize!=0){o.fontSize=1*q.fontSize}else{o.fontSize=12}o.geonextCompatibilityMode=true;delete (JXG.JSXGraph.boards[o.id]);o.id=q.id;JXG.JSXGraph.boards[o.id]=o;o.initGeonextBoard();o.renderer.enhancedRendering=true;JXG.GeonextReader.parseImage(o,boardData.getElementsByTagName("file")[0],"images");w=(boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("snap")[0].firstChild.data=="true")?o.snapToGrid=true:null;B=(boardData.getElementsByTagName("grid")[1].getElementsByTagName("x")[0].firstChild.data)?o.gridX=boardData.getElementsByTagName("grid")[1].getElementsByTagName("x")[0].firstChild.data*1:null;A=(boardData.getElementsByTagName("grid")[1].getElementsByTagName("y")[0].firstChild.data)?o.gridY=boardData.getElementsByTagName("grid")[1].getElementsByTagName("y")[0].firstChild.data*1:null;o.calculateSnapSizes();m=boardData.getElementsByTagName("grid")[1].getElementsByTagName("dash")[0].firstChild.data;o.gridDash=o.algebra.str2Bool(m);C=boardData.getElementsByTagName("grid")[1].getElementsByTagName("color")[0].firstChild.data;if(C.length=="9"&&C.substr(0,1)=="#"){z=C.substr(7,2);z=parseInt(z.toUpperCase(),16)/255;C=C.substr(0,7)}else{z="1"}o.gridColor=C;o.gridOpacity=z;b=(boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("grid")[0].firstChild.data=="true")?o.renderer.drawGrid(o):null;if(boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("coord")[0].firstChild.data=="true"){e=o.createElement("axis",[[0,0],[1,0]]);e.setProperty("strokeColor:"+e.visProp.strokeColor,"strokeWidth:"+e.visProp.strokeWidth,"fillColor:none","highlightStrokeColor:"+e.visProp.highlightStrokeColor,"highlightFillColor:none","visible:true");d=o.createElement("axis",[[0,0],[0,1]]);d.setProperty("strokeColor:"+d.visProp.strokeColor,"strokeWidth:"+d.visProp.strokeWidth,"fillColor:none","highlightStrokeColor:"+d.visProp.highlightStrokeColor,"highlightFillColor:none","visible:true")}a=boardData.getElementsByTagName("background")[0].getElementsByTagName("color")[0].firstChild.data;k=1;if(a.length=="9"&&a.substr(0,1)=="#"){k=a.substr(7,2);a=a.substr(0,7)}o.containerObj.style.backgroundColor=a;g=u.getElementsByTagName("elements")[0].childNodes;for(p=0;p<g.length;p++){(function(W){var ad,af={},aa,S,Q,U,ae,aj,I,G,ak,N=[],al=[],ag=[],ai=[],H=[],E=[],ac=[],ab=[],R=[],V=[],P=[],D,K,T,F,Z,X,L,J,O,Y;l=g[W];af=JXG.GeonextReader.defProperties(af,l);if(af==null){return}switch(l.nodeName.toLowerCase()){case"point":af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af.fixed=l.getElementsByTagName("fix")[0].firstChild.data;JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"points");try{Y=new JXG.Point(o,[1*af.x,1*af.y],af.id,af.name,true);Y.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorStroke,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.highlightStrokeColor,"labelColor:"+af.colorLabel,"visible:"+af.visible,"fixed:"+af.fixed,"draft:"+af.draft);Y.setStyle(1*af.style);Y.traced=(af.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK")}catch(ah){alert(ah)}break;case"line":af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af=JXG.GeonextReader.readNodes(af,l,"straight","straight");af.first=JXG.GeonextReader.changeOriginIds(o,af.first);af.last=JXG.GeonextReader.changeOriginIds(o,af.last);aa=new JXG.Line(o,af.first,af.last,af.id,af.name);S=aa.point1.coords.usrCoords[1];Q=aa.point1.coords.usrCoords[2];U=aa.point1.coords.distance(JXG.COORDS_BY_USER,aa.point2.coords);ae=0;aa.image=JXG.GeonextReader.parseImage(o,l,"lines",S,Q,U,ae,aa);af.straightFirst=(af.straightFirst=="false")?false:true;af.straightLast=(af.straightLast=="false")?false:true;aa.setStraight(af.straightFirst,af.straightLast);aa.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorFill,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.colorFill,"labelColor:"+af.colorLabel,"visible:"+af.visible,"dash:"+af.dash,"draft:"+af.draft);aa.traced=(af.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"circle":af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af.midpoint=l.getElementsByTagName("data")[0].getElementsByTagName("midpoint")[0].firstChild.data;JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"circles");if(l.getElementsByTagName("data")[0].getElementsByTagName("radius").length>0){af.radiuspoint=l.getElementsByTagName("data")[0].getElementsByTagName("radius")[0].firstChild.data;af.radius=null;af.method="twoPoints"}else{if(l.getElementsByTagName("data")[0].getElementsByTagName("radiusvalue").length>0){af.radiuspoint=null;af.radius=l.getElementsByTagName("data")[0].getElementsByTagName("radiusvalue")[0].firstChild.data;af.radiusnum=l.getElementsByTagName("data")[0].getElementsByTagName("radiusnum")[0].firstChild.data;af.method="pointRadius"}}if(af.method=="twoPoints"){if(o.objects[af.radiuspoint].type==JXG.OBJECT_TYPE_LINE){af.method="pointLine";af.radiuspoint=JXG.GeonextReader.changeOriginIds(o,af.radiuspoint)}else{if(o.objects[af.radiuspoint].type==JXG.OBJECT_TYPE_CIRCLE){af.method="pointCircle"}}}if(af.method=="pointRadius"){af.midpoint=JXG.GeonextReader.changeOriginIds(o,af.midpoint);aj=new JXG.Circle(o,af.method,af.midpoint,af.radius,af.id,af.name)}else{af.midpoint=JXG.GeonextReader.changeOriginIds(o,af.midpoint);aj=new JXG.Circle(o,af.method,af.midpoint,af.radiuspoint,af.id,af.name)}aj.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorFill,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.colorFill,"visible:"+af.visible,"labelColor:"+af.colorLabel,"dash:"+af.dash,"draft:"+af.draft);aj.traced=(af.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"slider":af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af.fixed=l.getElementsByTagName("fix")[0].firstChild.data;af=JXG.GeonextReader.readNodes(af,l,"animate","animate");JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"points");try{Y=new JXG.Point(o,[1*af.x,1*af.y],af.id,af.name,true);af.parent=JXG.GeonextReader.changeOriginIds(o,af.parent);Y.makeGlider(af.parent);Y.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorStroke,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.highlightStrokeColor,"visible:"+af.visible,"fixed:"+af.fixed,"labelColor:"+af.colorLabel,"draft:"+af.draft);Y.onPolygon=o.algebra.str2Bool(af.onpolygon);Y.traced=(af.trace=="false")?false:true;Y.setStyle(1*af.style);JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK")}catch(ah){}break;case"cas":af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af.fixed=l.getElementsByTagName("fix")[0].firstChild.data;af=JXG.GeonextReader.readNodes(af,l,"data");JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"points");Y=new JXG.Point(o,[1*af.xval,1*af.yval],af.id,af.name,true);Y.addConstraint([af.x,af.y]);Y.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorStroke,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.highlightStrokeColor,"visible:"+af.visible,"fixed:"+af.fixed,"labelColor:"+af.colorLabel,"draft:"+af.draft);Y.traced=(af.trace=="false")?false:true;Y.setStyle(1*af.style);JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"intersection":af=JXG.GeonextReader.readNodes(af,l,"data");h=l.getElementsByTagName("first")[1];af.outputFirstId=h.getElementsByTagName("id")[0].firstChild.data;af.outputFirstName=h.getElementsByTagName("name")[0].firstChild.data;af.outputFirstVisible=h.getElementsByTagName("visible")[0].firstChild.data;af.outputFirstTrace=h.getElementsByTagName("trace")[0].firstChild.data;af.outputFirstFixed=h.getElementsByTagName("fix")[0].firstChild.data;af.outputFirstStyle=h.getElementsByTagName("style")[0].firstChild.data;af.outputFirstStrokewidth=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("first")[1].getElementsByTagName("color")[0];af.outputFirstColorStroke=h.getElementsByTagName("stroke")[0].firstChild.data;af.outputFirstHighlightStrokeColor=h.getElementsByTagName("lighting")[0].firstChild.data;af.outputFirstColorFill=h.getElementsByTagName("fill")[0].firstChild.data;af.outputFirstColorLabel=h.getElementsByTagName("label")[0].firstChild.data;af.outputFirstColorDraft=h.getElementsByTagName("draft")[0].firstChild.data;af.first=JXG.GeonextReader.changeOriginIds(o,af.first);af.last=JXG.GeonextReader.changeOriginIds(o,af.last);if((((o.objects[af.first]).type==(o.objects[af.last]).type)&&((o.objects[af.first]).type==JXG.OBJECT_TYPE_LINE||(o.objects[af.first]).type==JXG.OBJECT_TYPE_ARROW))||(((o.objects[af.first]).type==JXG.OBJECT_TYPE_LINE)&&((o.objects[af.last]).type==JXG.OBJECT_TYPE_ARROW))||(((o.objects[af.last]).type==JXG.OBJECT_TYPE_LINE)&&((o.objects[af.first]).type==JXG.OBJECT_TYPE_ARROW))){inter=new JXG.Intersection(o,af.id,o.objects[af.first],o.objects[af.last],af.outputFirstId,"",af.outputFirstName,"");if(af.outputFirstVisible=="false"){inter.hideElement()}inter.p.setProperty("strokeColor:"+af.outputFirstColorStroke,"strokeWidth:"+af.outputFirstStrokewidth,"fillColor:"+af.outputFirstColorStroke,"highlightStrokeColor:"+af.outputFirstHighlightStrokeColor,"highlightFillColor:"+af.outputFirstHighlightStrokeColor,"visible:"+af.outputFirstVisible,"labelColor:"+af.outputFirstColorLabel,"draft:"+af.draft);inter.p.setStyle(1*af.outputFirstStyle);inter.p.traced=(af.outputFirstTrace=="false")?false:true}else{h=l.getElementsByTagName("last")[1];af.outputLastId=h.getElementsByTagName("id")[0].firstChild.data;af.outputLastName=h.getElementsByTagName("name")[0].firstChild.data;af.outputLastVisible=h.getElementsByTagName("visible")[0].firstChild.data;af.outputLastTrace=h.getElementsByTagName("trace")[0].firstChild.data;af.outputLastFixed=h.getElementsByTagName("fix")[0].firstChild.data;af.outputLastStyle=h.getElementsByTagName("style")[0].firstChild.data;af.outputLastStrokewidth=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("last")[1].getElementsByTagName("color")[0];af.outputLastColorStroke=h.getElementsByTagName("stroke")[0].firstChild.data;af.outputLastHighlightStrokeColor=h.getElementsByTagName("lighting")[0].firstChild.data;af.outputLastColorFill=h.getElementsByTagName("fill")[0].firstChild.data;af.outputLastColorLabel=h.getElementsByTagName("label")[0].firstChild.data;af.outputLastColorDraft=h.getElementsByTagName("draft")[0].firstChild.data;inter=new JXG.Intersection(o,af.id,o.objects[af.first],o.objects[af.last],af.outputFirstId,af.outputLastId,af.outputFirstName,af.outputLastName);inter.p1.setProperty("strokeColor:"+af.outputFirstColorStroke,"strokeWidth:"+af.outputFirstStrokewidth,"fillColor:"+af.outputFirstColorStroke,"highlightStrokeColor:"+af.outputFirstHighlightStrokeColor,"highlightFillColor:"+af.outputFirstHighlightStrokeColor,"visible:"+af.outputFirstVisible,"labelColor:"+af.outputFirstColorLabel,"draft:"+af.draft);inter.p1.setStyle(1*af.outputFirstStyle);inter.p1.traced=(af.outputFirstTrace=="false")?false:true;inter.p2.setProperty("strokeColor:"+af.outputLastColorStroke,"strokeWidth:"+af.outputLastStrokewidth,"fillColor:"+af.outputLastColorStroke,"highlightStrokeColor:"+af.outputLastHighlightStrokeColor,"highlightFillColor:"+af.outputLastHighlightStrokeColor,"visible:"+af.outputLastVisible,"labelColor:"+af.outputLastColorLabel,"draft:"+af.draft);inter.p2.setStyle(1*af.outputLastStyle);inter.p2.traced=(af.outputLastTrace=="false")?false:true;if(af.outputFirstVisible=="false"){if(af.outputLastVisible=="false"){inter.hideElement()}else{inter.p1.hideElement()}}else{if(af.outputLastVisible=="false"){inter.p2.hideElement()}}}JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"composition":af=JXG.GeonextReader.readNodes(af,l,"data");af=JXG.GeonextReader.firstLevelProperties(af,l);switch(af.type){case"210070":af.typeName="ARROW_PARALLEL";break;case"210080":af.typeName="BISECTOR";break;case"210090":af.typeName="CIRCUMCIRCLE";break;case"210100":af.typeName="CIRCUMCIRCLE_CENTER";break;case"210110":af.typeName="MIDPOINT";break;case"210120":af.typeName="MIRROR_LINE";break;case"210125":af.typeName="MIRROR_POINT";break;case"210130":af.typeName="NORMAL";break;case"210140":af.typeName="PARALLEL";break;case"210150":af.typeName="PARALLELOGRAM_POINT";break;case"210160":af.typeName="PERPENDICULAR";break;case"210170":af.typeName="PERPENDICULAR_POINT";break;case"210180":af.typeName="ROTATION";break;case"210190":af.typeName="SECTOR";break}af.defEl=[];I=0;h=l.getElementsByTagName("data")[0].getElementsByTagName("input");for(ad=0;ad<h.length;ad++){af.defEl[ad]=h[ad].firstChild.data;I=ad+1}h=l.getElementsByTagName("output")[0];af.outputId=h.getElementsByTagName("id")[0].firstChild.data;af.outputName=h.getElementsByTagName("name")[0].firstChild.data;af.outputVisible=h.getElementsByTagName("visible")[0].firstChild.data;af.outputTrace=h.getElementsByTagName("trace")[0].firstChild.data;af=JXG.GeonextReader.readNodes(af,l,"output","output");af.outputName=h.getElementsByTagName("name")[0].firstChild.data;af.outputDash=h.getElementsByTagName("dash")[0].firstChild.data;af.outputDraft=h.getElementsByTagName("draft")[0].firstChild.data;af.outputStrokewidth=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("output")[0].getElementsByTagName("color")[0];af.outputColorStroke=h.getElementsByTagName("stroke")[0].firstChild.data;af.outputHighlightStrokeColor=h.getElementsByTagName("lighting")[0].firstChild.data;af.outputColorFill=h.getElementsByTagName("fill")[0].firstChild.data;af.outputColorLabel=h.getElementsByTagName("label")[0].firstChild.data;af.outputColorDraft=h.getElementsByTagName("draft")[0].firstChild.data;af.defEl[0]=JXG.GeonextReader.changeOriginIds(o,af.defEl[0]);af.defEl[1]=JXG.GeonextReader.changeOriginIds(o,af.defEl[1]);af.defEl[2]=JXG.GeonextReader.changeOriginIds(o,af.defEl[2]);if(af.typeName=="MIDPOINT"){if(I==2){o.createElement("midpoint",[af.defEl[0],af.defEl[1]],{name:af.outputName,id:af.outputId})}else{if(I==1){o.createElement("midpoint",[af.defEl[0]],{name:af.outputName,id:af.outputId})}}}else{if(af.typeName=="NORMAL"){o.addNormal(af.defEl[1],af.defEl[0],af.outputId,af.outputName)}else{if(af.typeName=="PARALLEL"){o.addParallel(af.defEl[1],af.defEl[0],af.outputId,af.outputName)}else{if(af.typeName=="CIRCUMCIRCLE"){G=l.getElementsByTagName("output")[1].getElementsByTagName("id")[0].firstChild.data;ak=l.getElementsByTagName("output")[1].getElementsByTagName("name")[0].firstChild.data;o.addCircumcenter(af.defEl[0],af.defEl[1],af.defEl[2],af.outputId,af.outputName,G,ak)}else{if(af.typeName=="CIRCUMCIRCLE_CENTER"){o.addCircumcenterMidpoint(af.defEl[0],af.defEl[1],af.defEl[2],af.outputId,af.outputName)}else{if(af.typeName=="BISECTOR"){o.addAngleBisector(af.defEl[0],af.defEl[1],af.defEl[2],af.outputId,af.outputName)}else{if(af.typeName=="MIRROR_LINE"){o.addReflection(af.defEl[1],af.defEl[0],af.outputId,af.outputName)}else{if(af.typeName=="MIRROR_POINT"){o.addRotation(af.defEl[0],af.defEl[1],Math.PI,af.outputId,af.outputName)}else{if(af.typeName=="PARALLELOGRAM_POINT"){if(af.defEl.length==2){o.addParallelPoint(JXG.getReference(af.defEl[0]).point1,JXG.getReference(af.defEl[0]).point2,af.defEl[1],af.outputId,af.outputName)}else{o.addParallelPoint(af.defEl[0],af.defEl[1],af.defEl[2],af.outputId,af.outputName)}}else{if(af.typeName=="SECTOR"){JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"sectors");for(ad=0;ad<l.getElementsByTagName("output").length;ad++){h=l.getElementsByTagName("output")[ad];N[ad]=h.getElementsByTagName("id")[0].firstChild.data;N[ad]=JXG.GeonextReader.changeOriginIds(o,N[ad]);al[ad]=h.getElementsByTagName("name")[0];ag[ad]=h.getElementsByTagName("visible")[0].firstChild.data;ai[ad]=h.getElementsByTagName("trace")[0].firstChild.data;H[ad]=h.getElementsByTagName("dash")[0].firstChild.data;E[ad]=h.getElementsByTagName("draft")[0].firstChild.data;ac[ad]=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("output")[ad].getElementsByTagName("color")[0];ab[ad]=h.getElementsByTagName("stroke")[0].firstChild.data;R[ad]=h.getElementsByTagName("lighting")[0].firstChild.data;V[ad]=h.getElementsByTagName("fill")[0].firstChild.data;P[ad]=h.getElementsByTagName("label")[0].firstChild.data}D=new JXG.Sector(o,af.defEl[0],af.defEl[1],af.defEl[2],[N[0],N[1],N[2],N[3]],[al[0].firstChild.data,al[1].firstChild.data,al[2].firstChild.data,al[3].firstChild.data],af.id);K=N[0];o.objects[K].setProperty("strokeColor:"+ab[0],"strokeWidth:"+ac[0],"fillColor:"+V[0],"highlightStrokeColor:"+R[0],"highlightFillColor:"+V[0],"visible:"+ag[0],"dash:"+H[0],"draft:"+E[0]);o.objects[K].traced=(ai[0]=="false")?false:true;af.firstArrow=l.getElementsByTagName("output")[0].getElementsByTagName("firstarrow")[0].firstChild.data;af.lastArrow=l.getElementsByTagName("output")[0].getElementsByTagName("lastarrow")[0].firstChild.data;af.firstArrow=(af.firstArrow=="false")?false:true;af.lastArrow=(af.lastArrow=="false")?false:true;o.objects[K].setArrow(af.firstArrow,af.lastArrow);T=N[1];af.fixed=l.getElementsByTagName("output")[1].getElementsByTagName("fix")[0].firstChild.data;o.objects[T].setProperty("strokeColor:"+ab[1],"strokeWidth:"+ac[1],"fillColor:"+ab[1],"highlightStrokeColor:"+R[1],"highlightFillColor:"+R[1],"visible:"+ag[1],"fixed:"+af.fixed,"labelColor:"+P[1],"draft:"+E[1]);af.style=l.getElementsByTagName("output")[1].getElementsByTagName("style")[0].firstChild.data;o.objects[T].setStyle(1*af.style);o.objects[T].traced=(ai[1]=="false")?false:true;F=N[2];h=l.getElementsByTagName("output")[2].getElementsByTagName("straight")[0];af.straightFirst=h.getElementsByTagName("first")[0].firstChild.data;af.straightLast=h.getElementsByTagName("last")[0].firstChild.data;af.straightFirst=(af.straightFirst=="false")?false:true;af.straightLast=(af.straightLast=="false")?false:true;o.objects[F].setStraight(af.straightFirst,af.straightLast);o.objects[F].setProperty("strokeColor:"+ab[2],"strokeWidth:"+ac[2],"fillColor:"+V[2],"highlightStrokeColor:"+R[2],"highlightFillColor:"+V[2],"visible:"+ag[2],"dash:"+H[2],"draft:"+E[2]);o.objects[F].traced=(ai[2]=="false")?false:true;Z=N[3];h=l.getElementsByTagName("output")[3].getElementsByTagName("straight")[0];af.straightFirst=h.getElementsByTagName("first")[0].firstChild.data;af.straightLast=h.getElementsByTagName("last")[0].firstChild.data;af.straightFirst=(af.straightFirst=="false")?false:true;af.straightLast=(af.straightLast=="false")?false:true;o.objects[Z].setStraight(af.straightFirst,af.straightLast);o.objects[Z].setProperty("strokeColor:"+ab[3],"strokeWidth:"+ac[3],"fillColor:"+V[3],"highlightStrokeColor:"+R[3],"highlightFillColor:"+V[3],"visible:"+ag[3],"dash:"+H[3],"draft:"+E[3]);o.objects[Z].traced=(ai[3]=="false")?false:true}else{if(af.typeName=="PERPENDICULAR"){for(ad=0;ad<l.getElementsByTagName("output").length;ad++){h=l.getElementsByTagName("output")[ad];N[ad]=h.getElementsByTagName("id")[0].firstChild.data;N[ad]=JXG.GeonextReader.changeOriginIds(o,N[ad]);al[ad]=h.getElementsByTagName("name")[0];ag[ad]=h.getElementsByTagName("visible")[0].firstChild.data;ai[ad]=h.getElementsByTagName("trace")[0].firstChild.data;H[ad]=h.getElementsByTagName("dash")[0].firstChild.data;E[ad]=h.getElementsByTagName("draft")[0].firstChild.data;ac[ad]=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("output")[ad].getElementsByTagName("color")[0];ab[ad]=h.getElementsByTagName("stroke")[0].firstChild.data;R[ad]=h.getElementsByTagName("lighting")[0].firstChild.data;V[ad]=h.getElementsByTagName("fill")[0].firstChild.data;P[ad]=h.getElementsByTagName("label")[0].firstChild.data}af.outputFixed=l.getElementsByTagName("output")[0].getElementsByTagName("fix")[0].firstChild.data;af.outputStyle=l.getElementsByTagName("output")[0].getElementsByTagName("style")[0].firstChild.data;o.createElement("perpendicular",[af.defEl[1],af.defEl[0]],{name:[al[1].firstChild.data,al[0].firstChild.data],id:[N[1],N[0]]});X=N[0];o.objects[X].setProperty("strokeColor:"+ab[0],"strokeWidth:"+ac[0],"fillColor:"+ab[0],"highlightStrokeColor:"+R[0],"highlightFillColor:"+R[0],"visible:"+ag[0],"fixed:"+af.outputFixed,"labelColor:"+P[0],"draft:"+E[0]);o.objects[X].setStyle(1*af.outputStyle);o.objects[X].traced=(ai[0]=="false")?false:true;L=N[1];o.objects[L].setProperty("strokeColor:"+ab[1],"strokeWidth:"+ac[1],"fillColor:"+V[1],"highlightStrokeColor:"+R[1],"highlightFillColor:"+V[1],"visible:"+ag[1],"dash:"+H[1],"draft:"+E[1]);o.objects[L].traced=(ai[1]=="false")?false:true}else{if(af.typeName=="ARROW_PARALLEL"){for(ad=0;ad<l.getElementsByTagName("output").length;ad++){h=l.getElementsByTagName("output")[ad];N[ad]=h.getElementsByTagName("id")[0].firstChild.data;N[ad]=JXG.GeonextReader.changeOriginIds(o,N[ad]);al[ad]=h.getElementsByTagName("name")[0];ag[ad]=h.getElementsByTagName("visible")[0].firstChild.data;ai[ad]=h.getElementsByTagName("trace")[0].firstChild.data;H[ad]=h.getElementsByTagName("dash")[0].firstChild.data;E[ad]=h.getElementsByTagName("draft")[0].firstChild.data;ac[ad]=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("output")[ad].getElementsByTagName("color")[0];ab[ad]=h.getElementsByTagName("stroke")[0].firstChild.data;R[ad]=h.getElementsByTagName("lighting")[0].firstChild.data;V[ad]=h.getElementsByTagName("fill")[0].firstChild.data;P[ad]=h.getElementsByTagName("label")[0].firstChild.data}af.outputFixed=l.getElementsByTagName("output")[1].getElementsByTagName("fix")[0].firstChild.data;af.outputStyle=l.getElementsByTagName("output")[1].getElementsByTagName("style")[0].firstChild.data;o.addArrowParallel(af.defEl[1],af.defEl[0],N[0],N[1],al[0].firstChild.data,al[1].firstChild.data);J=N[0];o.objects[J].setProperty("strokeColor:"+ab[0],"strokeWidth:"+ac[0],"fillColor:"+V[0],"highlightStrokeColor:"+R[0],"highlightFillColor:"+V[0],"visible:"+ag[0],"dash:"+H[0],"draft:"+E[0]);o.objects[J].traced=(ai[0]=="false")?false:true;X=N[1];o.objects[X].setProperty("strokeColor:"+ab[1],"strokeWidth:"+ac[1],"fillColor:"+ab[1],"highlightStrokeColor:"+R[1],"highlightFillColor:"+R[1],"visible:"+ag[1],"fixed:"+af.outputFixed,"labelColor:"+P[1],"draft:"+E[1]);o.objects[X].setStyle(1*af.outputStyle);o.objects[X].traced=(ai[1]=="false")?false:true}else{if(af.typeName=="PERPENDICULAR_POINT"){o.addPerpendicularPoint(af.defEl[1],af.defEl[0],af.outputId,af.outputName)}else{throw ("GEONExT-Element "+af.typeName+" not yet implemented")}}}}}}}}}}}}}if(af.typeName=="MIDPOINT"||af.typeName=="MIRROR_LINE"||af.typeName=="CIRCUMCIRCLE_CENTER"||af.typeName=="PERPENDICULAR_POINT"||af.typeName=="MIRROR_POINT"||af.typeName=="PARALLELOGRAM_POINT"){af.outputFixed=l.getElementsByTagName("output")[0].getElementsByTagName("fix")[0].firstChild.data;af.outputStyle=l.getElementsByTagName("output")[0].getElementsByTagName("style")[0].firstChild.data;o.objects[af.outputId].setProperty("strokeColor:"+af.outputColorStroke,"strokeWidth:"+af.outputStrokewidth,"fillColor:"+af.outputColorStroke,"highlightStrokeColor:"+af.outputHighlightStrokeColor,"highlightFillColor:"+af.outputHighlightStrokeColor,"visible:"+af.outputVisible,"fixed:"+af.outputFixed,"labelColor:"+af.outputColorLabel,"draft:"+af.outputDraft);o.objects[af.outputId].setStyle(1*af.outputStyle);o.objects[af.outputId].traced=(af.outputTrace=="false")?false:true}else{if(af.typeName=="BISECTOR"||af.typeName=="NORMAL"||af.typeName=="PARALLEL"){h=l.getElementsByTagName("output")[0].getElementsByTagName("straight")[0];af.straightFirst=h.getElementsByTagName("first")[0].firstChild.data;af.straightLast=h.getElementsByTagName("last")[0].firstChild.data;af.straightFirst=(af.straightFirst=="false")?false:true;af.straightLast=(af.straightLast=="false")?false:true;o.objects[af.outputId].setStraight(af.straightFirst,af.straightLast);o.objects[af.outputId].setProperty("strokeColor:"+af.outputColorStroke,"strokeWidth:"+af.outputStrokewidth,"fillColor:"+af.outputColorFill,"highlightStrokeColor:"+af.outputHighlightStrokeColor,"highlightFillColor:"+af.outputColorFill,"visible:"+af.outputVisible,"dash:"+af.outputDash,"draft:"+af.outputDraft);o.objects[af.outputId].traced=(af.outputTrace=="false")?false:true}else{if(af.typeName=="CIRCUMCIRCLE"){for(ad=0;ad<l.getElementsByTagName("output").length;ad++){h=l.getElementsByTagName("output")[ad];N[ad]=h.getElementsByTagName("id")[0].firstChild.data;N[ad]=JXG.GeonextReader.changeOriginIds(o,N[ad]);al[ad]=h.getElementsByTagName("name")[0];ag[ad]=h.getElementsByTagName("visible")[0].firstChild.data;ai[ad]=h.getElementsByTagName("trace")[0].firstChild.data;H[ad]=h.getElementsByTagName("dash")[0].firstChild.data;E[ad]=h.getElementsByTagName("draft")[0].firstChild.data;ac[ad]=h.getElementsByTagName("strokewidth")[0].firstChild.data;h=l.getElementsByTagName("output")[ad].getElementsByTagName("color")[0];ab[ad]=h.getElementsByTagName("stroke")[0].firstChild.data;R[ad]=h.getElementsByTagName("lighting")[0].firstChild.data;V[ad]=h.getElementsByTagName("fill")[0].firstChild.data;P[ad]=h.getElementsByTagName("label")[0].firstChild.data}af.outputFixed=l.getElementsByTagName("output")[0].getElementsByTagName("fix")[0].firstChild.data;af.outputStyle=l.getElementsByTagName("output")[0].getElementsByTagName("style")[0].firstChild.data;X=N[0];o.objects[X].setProperty("strokeColor:"+ab[0],"strokeWidth:"+ac[0],"fillColor:"+ab[0],"highlightStrokeColor:"+R[0],"highlightFillColor:"+R[0],"visible:"+ag[0],"fixed:"+af.outputFixed,"labelColor:"+P[0],"draft:"+E[0]);o.objects[X].setStyle(1*af.outputStyle);o.objects[X].traced=(ai[0]=="false")?false:true;O=N[1];o.objects[O].setProperty("strokeColor:"+ab[1],"strokeWidth:"+ac[1],"fillColor:"+V[1],"highlightStrokeColor:"+R[1],"highlightFillColor:"+V[1],"visible:"+ag[1],"dash:"+H[1],"draft:"+E[1]);o.objects[O].traced=(ai[1]=="false")?false:true}}}JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"polygon":af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af.dataVertex=[];for(ad=0;ad<l.getElementsByTagName("data")[0].getElementsByTagName("vertex").length;ad++){af.dataVertex[ad]=l.getElementsByTagName("data")[0].getElementsByTagName("vertex")[ad].firstChild.data;af.dataVertex[ad]=JXG.GeonextReader.changeOriginIds(o,af.dataVertex[ad])}af.border=[];for(ad=0;ad<l.getElementsByTagName("border").length;ad++){af.border[ad]={};h=l.getElementsByTagName("border")[ad];af.border[ad].id=h.getElementsByTagName("id")[0].firstChild.data;af.border[ad].name=h.getElementsByTagName("name")[0].firstChild.data;af.border[ad].straightFirst=h.getElementsByTagName("straight")[0].getElementsByTagName("first")[0].firstChild.data;af.border[ad].straightLast=h.getElementsByTagName("straight")[0].getElementsByTagName("last")[0].firstChild.data;af.border[ad].straightFirst=(af.border[ad].straightFirst=="false")?false:true;af.border[ad].straightLast=(af.border[ad].straightLast=="false")?false:true;af.border[ad].strokewidth=h.getElementsByTagName("strokewidth")[0].firstChild.data;af.border[ad].dash=h.getElementsByTagName("dash")[0].firstChild.data;af.border[ad].visible=h.getElementsByTagName("visible")[0].firstChild.data;af.border[ad].draft=h.getElementsByTagName("draft")[0].firstChild.data;af.border[ad].trace=h.getElementsByTagName("trace")[0].firstChild.data;h=l.getElementsByTagName("border")[ad].getElementsByTagName("color")[0];af.border[ad].colorStroke=h.getElementsByTagName("stroke")[0].firstChild.data;af.border[ad].highlightStrokeColor=h.getElementsByTagName("lighting")[0].firstChild.data;af.border[ad].colorFill=h.getElementsByTagName("fill")[0].firstChild.data;af.border[ad].colorLabel=h.getElementsByTagName("label")[0].firstChild.data;af.border[ad].colorDraft=h.getElementsByTagName("draft")[0].firstChild.data}JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"polygone");Y=new JXG.Polygon(o,af.dataVertex,af.border,af.id,af.name,true,true,true);Y.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorFill,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.colorFill,"labelColor:"+af.colorLabel,"draft:"+af.draft,"trace:"+af.trace,"visible:true");if(!af.visible){Y.setProperty("fillColor:none","highlightFillColor:none")}for(ad=0;ad<Y.borders.length;ad++){Y.borders[ad].setStraight(af.border[ad].straightFirst,af.border[ad].straightLast);Y.borders[ad].setProperty("strokeColor:"+af.border[ad].colorStroke,"strokeWidth:"+af.border[ad].strokewidth,"fillColor:"+af.border[ad].colorFill,"highlightStrokeColor:"+af.border[ad].highlightStrokeColor,"highlightFillColor:"+af.border[ad].colorFill,"visible:"+af.border[ad].visible,"dash:"+af.border[ad].dash,"labelColor:"+af.border[ad].colorLabel,"draft:"+af.border[ad].draft,"trace:"+af.border[ad].trace)}JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"graph":af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af.funct=l.getElementsByTagName("data")[0].getElementsByTagName("function")[0].firstChild.data;JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"graphs");aj=new JXG.Curve(o,["x","x",af.funct],af.id,af.name);JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");aj.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:none","highlightStrokeColor:"+af.highlightStrokeColor);break;case"arrow":af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af=JXG.GeonextReader.readNodes(af,l,"straight","straight");af=JXG.GeonextReader.visualProperties(af,l);af.first=JXG.GeonextReader.changeOriginIds(o,af.first);af.last=JXG.GeonextReader.changeOriginIds(o,af.last);aa=new JXG.Line(o,af.first,af.last,af.id,af.name);aa.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorFill,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.colorFill,"labelColor:"+af.colorLabel,"visible:"+af.visible,"dash:"+af.dash,"draft:"+af.draft);aa.setStraight(false,false);aa.setArrow(false,true);aa.traced=(af.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",aa,l.nodeName,"OK");break;case"arc":af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af.firstArrow=l.getElementsByTagName("firstarrow")[0].firstChild.data;af.lastArrow=l.getElementsByTagName("lastarrow")[0].firstChild.data;JXG.GeonextReader.parseImage(o,l.getElementsByTagName("image")[0],"arcs");af.midpoint=JXG.GeonextReader.changeOriginIds(o,af.midpoint);af.angle=JXG.GeonextReader.changeOriginIds(o,af.angle);af.radius=JXG.GeonextReader.changeOriginIds(o,af.radius);aj=new JXG.Arc(o,af.midpoint,af.radius,af.angle,af.id,af.name);aj.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorFill,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.colorFill,"labelColor:"+af.colorLabel,"visible:"+af.visible,"dash:"+af.dash,"draft:"+af.draft);aj.traced=(af.trace=="false")?false:true;af.firstArrow=(af.firstArrow=="false")?false:true;af.lastArrow=(af.lastArrow=="false")?false:true;aj.setArrow(af.firstArrow,af.lastArrow);JXG.GeonextReader.printDebugMessage("debug",aj,l.nodeName,"OK");break;case"angle":af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af.txt=l.getElementsByTagName("text")[0].firstChild.data;aj=new JXG.Angle(o,af.first,af.middle,af.last,af.radius,af.txt,af.id,af.name);aj.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:"+af.colorFill,"highlightStrokeColor:"+af.highlightStrokeColor,"highlightFillColor:"+af.colorFill,"labelColor:"+af.colorLabel,"visible:"+af.visible,"dash:"+af.dash);JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"text":if(af.id.match(/oldVersion/)){break}af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.visualProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af=JXG.GeonextReader.readNodes(af,l,"data");af.mpStr=JXG.GeonextReader.subtreeToString(l.getElementsByTagName("data")[0].getElementsByTagName("mp")[0]);af.mpStr=af.mpStr.replace(/<\/?mp>/g,"");try{if(l.getElementsByTagName("data")[0].getElementsByTagName("parent")[0].firstChild){af.parent=l.getElementsByTagName("data")[0].getElementsByTagName("parent")[0].firstChild.data}}catch(ah){}af.condition=l.getElementsByTagName("condition")[0].firstChild.data;af.content=l.getElementsByTagName("content")[0].firstChild.data;af.fix=l.getElementsByTagName("fix")[0].firstChild.data;af.autodigits=l.getElementsByTagName("digits")[0].firstChild.data;af.parent=JXG.GeonextReader.changeOriginIds(o,af.parent);aj=new JXG.Text(o,af.mpStr,af.parent,[af.x,af.y],af.id,af.name,af.autodigits,false);aj.setProperty("labelColor:"+af.colorLabel,"visible:"+af.visible);break;case"parametercurve":af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af.functionx=l.getElementsByTagName("functionx")[0].firstChild.data;af.functiony=l.getElementsByTagName("functiony")[0].firstChild.data;af.min=l.getElementsByTagName("min")[0].firstChild.data;af.max=l.getElementsByTagName("max")[0].firstChild.data;aj=new JXG.Curve(o,["t",af.functionx,af.functiony,af.min,af.max],af.id,af.name);aj.setProperty("strokeColor:"+af.colorStroke,"strokeWidth:"+af.strokewidth,"fillColor:none","highlightStrokeColor:"+af.highlightStrokeColor);JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;case"tracecurve":af.tracepoint=l.getElementsByTagName("tracepoint")[0].firstChild.data;af.traceslider=l.getElementsByTagName("traceslider")[0].firstChild.data;JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"<b>ERR</b>");break;case"group":af=JXG.GeonextReader.boardProperties(af,l);af=JXG.GeonextReader.colorProperties(af,l);af=JXG.GeonextReader.firstLevelProperties(af,l);af.members=[];for(ad=0;ad<l.getElementsByTagName("data")[0].getElementsByTagName("member").length;ad++){af.members[ad]=l.getElementsByTagName("data")[0].getElementsByTagName("member")[ad].firstChild.data;af.members[ad]=JXG.GeonextReader.changeOriginIds(o,af.members[ad])}aj=new JXG.Group(o,af.id,af.name,af.members);JXG.GeonextReader.printDebugMessage("debug",af,l.nodeName,"OK");break;default:if(l.nodeName!="#text"){}}delete (af)})(p)}o.addConditions(q.conditions)};this.decodeString=function(b){var a;if(b.indexOf("<GEONEXT>")<0){a=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(b))).unzip();if(a==""){return b}else{return a}}else{return b}};this.prepareString=function(a){if(a.indexOf("GEONEXT")<0){a=(JXG.GeonextReader.decodeString(a))[0][0]}a=JXG.GeonextReader.fixXML(a);return a};this.fixXML=function(g){var a=["active","angle","animate","animated","arc","area","arrow","author","autodigits","axis","back","background","board","border","bottom","buttonsize","cas","circle","color","comment","composition","condition","conditions","content","continuous","control","coord","coordinates","cross","cs","dash","data","description","digits","direction","draft","editable","elements","event","file","fill","first","firstarrow","fix","fontsize","free","full","function","functionx","functiony","GEONEXT","graph","grid","group","height","id","image","info","information","input","intersection","item","jsf","label","last","lastarrow","left","lefttoolbar","lighting","line","loop","max","maximized","member","middle","midpoint","min","modifier","modus","mp","mpx","multi","name","onpolygon","order","origin","output","overline","parametercurve","parent","point","pointsnap","polygon","position","radius","radiusnum","radiusvalue","right","section","selectedlefttoolbar","showconstruction","showcoord","showinfo","showunit","showx","showy","size","slider","snap","speed","src","start","stop","straight","stroke","strokewidth","style","term","text","top","trace","tracecurve","type","unit","value","VERSION","vertex","viewport","visible","width","wot","x","xooy","xval","y","yval","zoom"],d=a.join("|"),b="&lt;(/?("+d+"))&gt;",e=new RegExp(b,"g");g=JXG.escapeHTML(g);g=g.replace(e,"<$1>");g=g.replace(/(<content>.*)<arc>(.*<\/content>)/g,"$1&lt;arc&gt;$2");g=g.replace(/(<mp>.*)<arc>(.*<\/mpx>)/g,"$1&lt;arc&gt;$2");g=g.replace(/(<mpx>.*)<arc>(.*<\/mpx>)/g,"$1&lt;arc&gt;$2");return g}};JXG.GeogebraReader=new function(){this.ggbParse=function(board,tree,registeredElements,element,exp){if(element){JXG.GeogebraReader.debug("Zu aktualisierendes Element: "+registeredElements[element].name+"("+registeredElements[element].id+")");var p=JXG.getReference(board,registeredElements[element].id)}var _dbg_withtrace=false;var _dbg_string=new String();function __dbg_print(text){_dbg_string+=text+"\n"}function __lex(info){var state=0;var match=-1;var match_pos=0;var start=0;var pos=info.offset+1;do{pos--;state=0;match=-2;start=pos;if(info.src.length<=start){return 17}do{switch(state){case 0:if(info.src.charCodeAt(pos)==9||info.src.charCodeAt(pos)==32){state=1}else{if(info.src.charCodeAt(pos)==40){state=2}else{if(info.src.charCodeAt(pos)==41){state=3}else{if(info.src.charCodeAt(pos)==42){state=4}else{if(info.src.charCodeAt(pos)==43){state=5}else{if(info.src.charCodeAt(pos)==44){state=6}else{if(info.src.charCodeAt(pos)==45){state=7}else{if(info.src.charCodeAt(pos)==47){state=8}else{if((info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)){state=9}else{if((info.src.charCodeAt(pos)>=65&&info.src.charCodeAt(pos)<=90)||(info.src.charCodeAt(pos)>=97&&info.src.charCodeAt(pos)<=122)){state=10}else{if(info.src.charCodeAt(pos)==94){state=11}else{if(info.src.charCodeAt(pos)==34){state=15}else{if(info.src.charCodeAt(pos)==38){state=16}else{if(info.src.charCodeAt(pos)==46){state=17}else{state=-1}}}}}}}}}}}}}}break;case 1:state=-1;match=1;match_pos=pos;break;case 2:state=-1;match=2;match_pos=pos;break;case 3:state=-1;match=3;match_pos=pos;break;case 4:state=-1;match=12;match_pos=pos;break;case 5:state=-1;match=9;match_pos=pos;break;case 6:state=-1;match=10;match_pos=pos;break;case 7:state=-1;match=11;match_pos=pos;break;case 8:state=-1;match=13;match_pos=pos;break;case 9:if((info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)){state=9}else{if(info.src.charCodeAt(pos)==46){state=13}else{state=-1}}match=4;match_pos=pos;break;case 10:if((info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)||(info.src.charCodeAt(pos)>=65&&info.src.charCodeAt(pos)<=90)||(info.src.charCodeAt(pos)>=97&&info.src.charCodeAt(pos)<=122)){state=10}else{if(info.src.charCodeAt(pos)==95){state=19}else{state=-1}}match=7;match_pos=pos;break;case 11:state=-1;match=14;match_pos=pos;break;case 12:state=-1;match=8;match_pos=pos;break;case 13:if((info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)){state=13}else{state=-1}match=5;match_pos=pos;break;case 14:state=-1;match=6;match_pos=pos;break;case 15:if(info.src.charCodeAt(pos)==34){state=12}else{if(info.src.charCodeAt(pos)==32||info.src.charCodeAt(pos)==46||(info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)||(info.src.charCodeAt(pos)>=65&&info.src.charCodeAt(pos)<=90)||(info.src.charCodeAt(pos)>=97&&info.src.charCodeAt(pos)<=122)){state=15}else{state=-1}}break;case 16:if((info.src.charCodeAt(pos)>=65&&info.src.charCodeAt(pos)<=90)||(info.src.charCodeAt(pos)>=97&&info.src.charCodeAt(pos)<=122)){state=18}else{state=-1}break;case 17:if((info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)){state=13}else{state=-1}break;case 18:if(info.src.charCodeAt(pos)==59){state=14}else{if((info.src.charCodeAt(pos)>=65&&info.src.charCodeAt(pos)<=90)||(info.src.charCodeAt(pos)>=97&&info.src.charCodeAt(pos)<=122)){state=18}else{state=-1}}break;case 19:if((info.src.charCodeAt(pos)>=48&&info.src.charCodeAt(pos)<=57)||(info.src.charCodeAt(pos)>=65&&info.src.charCodeAt(pos)<=90)||(info.src.charCodeAt(pos)>=97&&info.src.charCodeAt(pos)<=122)){state=10}else{if(info.src.charCodeAt(pos)==95){state=19}else{state=-1}}break}pos++}while(state>-1)}while(1>-1&&match==1);if(match>-1){info.att=info.src.substr(start,match_pos-start);info.offset=match_pos;switch(match){case 4:info.att=parseInt(info.att);break;case 5:info.att=function(){return parseFloat(info.att)};break;case 6:info.att=String(info.att);break;case 7:JXG.GeogebraReader.debug("Geparstes Element/Variable: "+info.att);if(typeof registeredElements[info.att]=="undefined"||registeredElements[info.att]==""){var input=JXG.GeogebraReader.getElement(tree,info.att);registeredElements[info.att]=JXG.GeogebraReader.writeElement(registeredElements,tree,board,input);JXG.GeogebraReader.debug("regged: "+info.att+" (id: "+registeredElements[info.att].id+")")}break;case 8:info.att=String(info.att);break}}else{info.att=new String();match=-1}return match}function __parse(src,err_off,err_la){var sstack=new Array();var vstack=new Array();var err_cnt=0;var act;var go;var la;var rval;var parseinfo=new Function("","var offset; var src; var att;");var info=new parseinfo();var pop_tab=new Array(new Array(0,1),new Array(16,1),new Array(15,3),new Array(15,3),new Array(15,3),new Array(15,3),new Array(15,3),new Array(15,3),new Array(15,2),new Array(15,3),new Array(15,1),new Array(15,3),new Array(15,1),new Array(15,1),new Array(15,1),new Array(15,1));var act_tab=new Array(new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(17,0),new Array(14,10,13,11,12,12,11,13,9,14,10,15,17,-1),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(17,-10,10,-10,9,-10,11,-10,12,-10,13,-10,14,-10,3,-10),new Array(9,18,17,-15,10,-15,11,-15,12,-15,13,-15,14,-15,3,-15),new Array(17,-12,10,-12,9,-12,11,-12,12,-12,13,-12,14,-12,3,-12),new Array(17,-13,10,-13,9,-13,11,-13,12,-13,13,-13,14,-13,3,-13),new Array(17,-14,10,-14,9,-14,11,-14,12,-14,13,-14,14,-14,3,-14),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(14,10,13,-8,12,-8,11,-8,9,-8,10,-8,17,-8,3,-8),new Array(14,10,13,11,12,12,11,13,9,14,10,15,3,25),new Array(11,3,2,4,7,5,8,6,4,7,5,8,6,9),new Array(14,-7,13,-7,12,-7,11,-7,9,-7,10,-7,17,-7,3,-7),new Array(14,10,13,-6,12,-6,11,-6,9,-6,10,-6,17,-6,3,-6),new Array(14,10,13,-5,12,-5,11,-5,9,-5,10,-5,17,-5,3,-5),new Array(14,10,13,11,12,12,11,-4,9,-4,10,-4,17,-4,3,-4),new Array(14,10,13,11,12,12,11,-3,9,-3,10,-3,17,-3,3,-3),new Array(14,10,13,11,12,12,11,-2,9,-2,10,-2,17,-2,3,-2),new Array(17,-9,10,-9,9,-9,11,-9,12,-9,13,-9,14,-9,3,-9),new Array(14,10,13,11,12,12,11,-11,9,-11,10,-11,17,-11,3,-11));var goto_tab=new Array(new Array(16,1,15,2),new Array(),new Array(),new Array(15,16),new Array(15,17),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(15,19),new Array(15,20),new Array(15,21),new Array(15,22),new Array(15,23),new Array(15,24),new Array(),new Array(),new Array(15,26),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array());var labels=new Array("p'","WHITESPACE","(",")","INT","FLOAT","HTML","VAR","STRING","+",",","-","*","/","^","e","p","$");info.offset=0;info.src=src;info.att=new String();if(!err_off){err_off=new Array()}if(!err_la){err_la=new Array()}sstack.push(0);vstack.push(0);la=__lex(info);while(true){act=28;for(var i=0;i<act_tab[sstack[sstack.length-1]].length;i+=2){if(act_tab[sstack[sstack.length-1]][i]==la){act=act_tab[sstack[sstack.length-1]][i+1];break}}if(_dbg_withtrace&&sstack.length>0){__dbg_print("\nState "+sstack[sstack.length-1]+"\n\tLookahead: "+labels[la]+' ("'+info.att+'")\n\tAction: '+act+'\n\tSource: "'+info.src.substr(info.offset,30)+((info.offset+30<info.src.length)?"...":"")+'"\n\tStack: '+sstack.join()+"\n\tValue stack: "+vstack.join()+"\n")}if(act==28){if(_dbg_withtrace){__dbg_print("Error detected: There is no reduce or shift on the symbol "+labels[la])}err_cnt++;err_off.push(info.offset-info.att.length);err_la.push(new Array());for(var i=0;i<act_tab[sstack[sstack.length-1]].length;i+=2){err_la[err_la.length-1].push(labels[act_tab[sstack[sstack.length-1]][i]])}var rsstack=new Array();var rvstack=new Array();for(var i=0;i<sstack.length;i++){rsstack[i]=sstack[i];rvstack[i]=vstack[i]}while(act==28&&la!=17){if(_dbg_withtrace){__dbg_print("\tError recovery\nCurrent lookahead: "+labels[la]+" ("+info.att+")\nAction: "+act+"\n\n")}if(la==-1){info.offset++}while(act==28&&sstack.length>0){sstack.pop();vstack.pop();if(sstack.length==0){break}act=28;for(var i=0;i<act_tab[sstack[sstack.length-1]].length;i+=2){if(act_tab[sstack[sstack.length-1]][i]==la){act=act_tab[sstack[sstack.length-1]][i+1];break}}}if(act!=28){break}for(var i=0;i<rsstack.length;i++){sstack.push(rsstack[i]);vstack.push(rvstack[i])}la=__lex(info)}if(act==28){if(_dbg_withtrace){__dbg_print("\tError recovery failed, terminating parse process...")}break}if(_dbg_withtrace){__dbg_print("\tError recovery succeeded, continuing")}}if(act>0){if(_dbg_withtrace){__dbg_print("Shifting symbol: "+labels[la]+" ("+info.att+")")}sstack.push(act);vstack.push(info.att);la=__lex(info);if(_dbg_withtrace){__dbg_print("\tNew lookahead symbol: "+labels[la]+" ("+info.att+")")}}else{act*=-1;if(_dbg_withtrace){__dbg_print("Reducing by producution: "+act)}rval=void (0);if(_dbg_withtrace){__dbg_print("\tPerforming semantic action...")}switch(act){case 0:rval=vstack[vstack.length-1];break;case 1:JXG.GeogebraReader.debug("<b style='color:red'>Fehler:</b> "+vstack[vstack.length-1]);break;case 2:var s1=(typeof vstack[vstack.length-3]==="string")?JXG.getReference(board,registeredElements[vstack[vstack.length-3]].id):vstack[vstack.length-3];var s2=(typeof vstack[vstack.length-1]==="string")?JXG.getReference(board,registeredElements[vstack[vstack.length-1]].id):vstack[vstack.length-1];if(typeof s2==="function"){p.addConstraint([s1,function(){return s2(s1.Value())}])}else{p.addConstraint([s1,s2])}break;case 3:rval=(JXG.isNumber(vstack[vstack.length-3]))?vstack[vstack.length-3]:parseInt(vstack[vstack.length-3])+(JXG.isNumber(vstack[vstack.length-3]))?vstack[vstack.length-1]:parseInt(vstack[vstack.length-1]);break;case 4:rval=vstack[vstack.length-3]-vstack[vstack.length-1];break;case 5:rval=vstack[vstack.length-3]*vstack[vstack.length-1];break;case 6:rval=vstack[vstack.length-3]/vstack[vstack.length-1];break;case 7:var s11=(typeof vstack[vstack.length-3]==="string")?JXG.getReference(board,registeredElements[vstack[vstack.length-3]].id):vstack[vstack.length-3];var s21=(typeof vstack[vstack.length-1]==="string")?JXG.getReference(board,registeredElements[vstack[vstack.length-1]].id):vstack[vstack.length-1];rval=function(x){return Math.pow(x,s21)};break;case 8:rval=vstack[vstack.length-1]*-1;break;case 9:rval=vstack[vstack.length-2];break;case 10:rval=vstack[vstack.length-1];break;case 11:rval=vstack[vstack.length-3];break;case 12:rval=vstack[vstack.length-1];break;case 13:rval=vstack[vstack.length-1];break;case 14:rval=vstack[vstack.length-1];break;case 15:rval=vstack[vstack.length-1];break}if(_dbg_withtrace){__dbg_print("\tPopping "+pop_tab[act][1]+" off the stack...")}for(var i=0;i<pop_tab[act][1];i++){sstack.pop();vstack.pop()}go=-1;for(var i=0;i<goto_tab[sstack[sstack.length-1]].length;i+=2){if(goto_tab[sstack[sstack.length-1]][i]==pop_tab[act][0]){go=goto_tab[sstack[sstack.length-1]][i+1];break}}if(act==0){break}if(_dbg_withtrace){__dbg_print("\tPushing non-terminal "+labels[pop_tab[act][0]])}sstack.push(go);vstack.push(rval)}if(_dbg_withtrace){JXG.GeogebraReader.debug(_dbg_string);_dbg_string=new String()}}if(_dbg_withtrace){__dbg_print("\nParse complete.");JXG.GeogebraReader.debug(_dbg_string)}return err_cnt}var error_offsets=new Array();var error_lookaheads=new Array();var error_count=0;var str=exp;if((error_count=__parse(str,error_offsets,error_lookaheads))>0){var errstr=new String();for(var i=0;i<error_count;i++){errstr+="Parse error in line "+(str.substr(0,error_offsets[i]).match(/\n/g)?str.substr(0,error_offsets[i]).match(/\n/g).length:1)+' near "'+str.substr(error_offsets[i])+'", expecting "'+error_lookaheads[i].join()+'"\n'}JXG.GeogebraReader.debug(errstr)}};this.debug=function(s){$("debug").innerHTML+=s+"<br/>"};this.colorProperties=function(Data,attr){var a=(Data.getElementsByTagName("objColor")[0].attributes.alpha)?1*Data.getElementsByTagName("objColor")[0].attributes.alpha.value:0;var r=(Data.getElementsByTagName("objColor")[0].attributes.r)?(1*Data.getElementsByTagName("objColor")[0].attributes.r.value).toString(16):0;var g=(Data.getElementsByTagName("objColor")[0].attributes.g)?(1*Data.getElementsByTagName("objColor")[0].attributes.g.value).toString(16):0;var b=(Data.getElementsByTagName("objColor")[0].attributes.b)?(1*Data.getElementsByTagName("objColor")[0].attributes.b.value).toString(16):0;if(r.length==1){r="0"+r}if(g.length==1){g="0"+g}if(b.length==1){b="0"+b}attr.fillColor="#"+r+g+b;attr.strokeColor=attr.fillColor;attr.fillOpacity=a;return attr};this.boardProperties=function(gxtEl,Data,attr){return attr};this.coordinates=function(gxtEl,Data){gxtEl.x=(Data.getElementsByTagName("coords")[0])?parseFloat(Data.getElementsByTagName("coords")[0].attributes.x.value):(Data.getElementsByTagName("startPoint")[0])?parseFloat(Data.getElementsByTagName("startPoint")[0].attributes.x.value):false;gxtEl.y=(Data.getElementsByTagName("coords")[0])?parseFloat(Data.getElementsByTagName("coords")[0].attributes.y.value):(Data.getElementsByTagName("startPoint")[0])?parseFloat(Data.getElementsByTagName("startPoint")[0].attributes.y.value):false;gxtEl.z=(Data.getElementsByTagName("coords")[0])?parseFloat(Data.getElementsByTagName("coords")[0].attributes.z.value):(Data.getElementsByTagName("startPoint")[0])?parseFloat(Data.getElementsByTagName("startPoint")[0].attributes.z.value):false;return gxtEl};this.visualProperties=function(Data,attr){(Data.getElementsByTagName("show")[0].attributes.object)?attr.visible=Data.getElementsByTagName("show")[0].attributes.object.value:false;(Data.getElementsByTagName("show")[0].attributes.label)?attr.visibleLabel=Data.getElementsByTagName("show")[0].attributes.label.value:false;(Data.getElementsByTagName("pointSize")[0])?attr.style=Data.getElementsByTagName("pointSize")[0].attributes.val.value:false;(Data.getElementsByTagName("labelOffset")[0])?attr.labelX=1*Data.getElementsByTagName("labelOffset")[0].attributes.x.value:false;(Data.getElementsByTagName("labelOffset")[0])?attr.labelY=1*Data.getElementsByTagName("labelOffset")[0].attributes.y.value:false;(Data.getElementsByTagName("trace")[0])?attr.trace=Data.getElementsByTagName("trace")[0].attributes.val.value:false;(Data.getElementsByTagName("fix")[0])?attr.fixed=Data.getElementsByTagName("fix")[0].attributes.val.value:false;return attr};this.getElement=function(tree,name,expr){expr=expr||false;for(var i=0;i<tree.getElementsByTagName("construction").length;i++){if(expr==false){for(var j=0;j<tree.getElementsByTagName("construction")[i].getElementsByTagName("element").length;j++){var Data=tree.getElementsByTagName("construction")[i].getElementsByTagName("element")[j];if(name==Data.attributes.label.value){return Data}}}else{for(var j=0;j<tree.getElementsByTagName("construction")[i].getElementsByTagName("expression").length;j++){var Data=tree.getElementsByTagName("construction")[i].getElementsByTagName("expression")[j];if(name==Data.attributes.label.value){return Data}}}}};this.functionParse=function(exp){JXG.GeogebraReader.debug("* in: "+exp);var s=exp.split(" ");var o="";for(var i=0;i<s.length;i++){if(s.length!=i+1){if(s[i].search(/\)$/)>-1||s[i].search(/[0-9]+$/)>-1||s[i].search(/[a-zA-Z]+(\_*[a-zA-Z0-9]+)*$/)>-1){if(s[i+1].search(/^\(/)>-1||s[i].search(/^[0-9]+/)>-1||s[i+1].search(/^[a-zA-Z]+(\_*[a-zA-Z0-9]+)*/)>-1){s[i]=s[i]+"*"}}}o+=s[i]}if(o.match(/[a-zA-Z0-9]+\([a-zA-Z0-9]+[a-zA-Z0-9,\ ]*\)[\ ]*[=][\ ]*[a-zA-Z0-9\+\-\*\/]+/)){var input=o.split("(")[1].split(")")[0];var vars=input.split(", ");var output=[];for(var i=0;i<vars.length;i++){output.push("__"+vars[i])}var expr=o.split("=")[1];for(var i=0;i<vars.length;i++){expr=expr.replace(eval("/"+vars[i]+"/g"),"__"+vars[i])}expr=(expr.match(/sin/))?expr.replace(/sin/,"Math.sin"):expr;output.push("return "+expr+";");JXG.GeogebraReader.debug("* out: "+output.toString());return output}else{return o}};this.writeBoard=function(tree,board,registeredElements){var boardData=tree.getElementsByTagName("euclidianView")[0];board.origin={};board.origin.usrCoords=[1,0,0];board.origin.scrCoords=[1,1*boardData.getElementsByTagName("coordSystem")[0].attributes.xZero.value,1*boardData.getElementsByTagName("coordSystem")[0].attributes.yZero.value];board.unitX=(boardData.getElementsByTagName("coordSystem")[0].attributes.scale)?1*boardData.getElementsByTagName("coordSystem")[0].attributes.scale.value:1;board.unitY=(boardData.getElementsByTagName("coordSystem")[0].attributes.yscale)?1*boardData.getElementsByTagName("coordSystem")[0].attributes.yscale.value:1;board.stretchX=board.zoomX*board.unitX;board.stretchY=board.zoomY*board.unitY;board.fontSize=1*tree.getElementsByTagName("gui")[0].getElementsByTagName("font")[0].attributes.size.value;JXG.JSXGraph.boards[board.id]=board;board.renderer.enhancedRendering=true;var snap=(boardData.getElementsByTagName("evSettings")[0].attributes.pointCapturing.value=="true")?board.snapToGrid=true:null;var grid=(boardData.getElementsByTagName("evSettings")[0].attributes.grid.value=="true")?board.renderer.drawGrid(board):null;if(boardData.getElementsByTagName("evSettings")[0].attributes.axes&&boardData.getElementsByTagName("evSettings")[0].attributes.axes.value=="true"){registeredElements.xAxis=board.createElement("axis",[[0,0],[1,0]],{strokeColor:"black"});registeredElements.yAxis=board.createElement("axis",[[0,0],[0,1]],{strokeColor:"black"})}return registeredElements};this.writeElement=function(registeredElements,tree,board,output,input,cmd){element=(typeof output==="object"&&typeof output.attributes==="undefined")?output[0]:output;var gxtEl={};gxtEl.type=(element.attributes.type&&typeof cmd==="undefined")?element.attributes.type.value.toLowerCase():cmd;gxtEl.label=element.attributes.label.value;var attr={};attr.name=gxtEl.label;JXG.GeogebraReader.debug("<br><b>Konstruiere</b> "+gxtEl.label+"("+gxtEl.type+"):");switch(gxtEl.type){case"point":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{p=board.createElement("point",[gxtEl.x,gxtEl.y],attr);$("debug").innerHTML+="* <b>Point ("+p.id+"):</b> "+attr.name+"("+gxtEl.x+", "+gxtEl.y+")<br>\n";return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Point "+attr.name+"<br>\n";return false}break;case"segment":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Segment:</b> ("+attr.name+") First: "+input[0].name+", Last: "+input[1].name+"<br>\n";attr.straightFirst=false;attr.straightLast=false;l=board.createElement("line",input,attr);return l}catch(e){$("debug").innerHTML+="* <b>Err:</b> Segment "+attr.name+" First: "+input[0].name+", Last: "+input[1].name+"<br>\n";return false}break;case"line":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);if(JXG.getReference(board,input[1].id).type==1330925652){var type="line"}else{if(JXG.getReference(board,input[1].id).type==1330924622){var type="parallel"}}try{$("debug").innerHTML+="* <b>Line:</b> ("+attr.name+") First: "+input[0].id+", Last: "+input[1].id+"<br>\n";l=board.createElement(type,input,attr);return l}catch(e){$("debug").innerHTML+="* <b>Err:</b> Line "+attr.label+"<br>\n";return false}break;case"orthogonalline":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Orthogonalline:</b> First: "+input[0].id+", Last: "+input[1].id+"<br>\n";l=board.createElement("normal",[input[0],input[1]],attr);return l}catch(e){$("debug").innerHTML+="* <b>Err:</b> Orthogonalline "+attr.label+"<br>\n";return false}break;case"polygon":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);var corner;for(var i=0;i<input.length;i++){if(JXG.isNumber(parseInt(input[i]))){corner=parseInt(input[i])}}JXG.GeogebraReader.debug("Ecken: "+corner);try{$("debug").innerHTML+="* <b>Polygon:</b> First: "+input[0].name+", Second: "+input[1].name+", Third: "+input[2].name+"<br>\n";var borders=[];var length=output.length;if(JXG.isNumber(corner)&&corner>0){length-=(corner-2)}for(var i=1;i<length;i++){borders[i-1]={};borders[i-1].id="";borders[i-1].name=output[i].attributes.label.value;JXG.GeogebraReader.debug("border["+typeof borders[i-1]+"]: "+borders[i-1].name)}attr.borders=borders;var points=[];for(var i=0;i<input.length;i++){if(typeof input[i]==="object"){points.push(input[i]);JXG.GeogebraReader.debug("input-queue: added "+input[i].name)}}for(var i=(output.length-corner+2);i<output.length;i++){var el=output[i].attributes.label.value;if(typeof registeredElements[el]=="undefined"||registeredElements[el]==""){registeredElements[el]=JXG.GeogebraReader.writeElement(registeredElements,tree,board,output[i])}points.push(registeredElements[el])}l=board.createElement("polygon",points,attr);return l}catch(e){$("debug").innerHTML+="* <b>Err:</b> Polygon "+attr.name+"<br>\n";return false}break;case"intersect":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Intersection:</b> First: "+input[0].name+", Second: "+input[1].name+"<br>\n";l=board.createElement("intersection",[input[0],input[1],0],attr);return l}catch(e){$("debug").innerHTML+="* <b>Err:</b> Intersection "+attr.name+"<br>\n";return false}break;case"distance":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Distance:</b> First: "+input[0].name+", Second: "+input[1].name+"<br>\n";m=board.createElement("midpoint",input,{visible:"false"});t=board.createElement("text",[function(){return m.X()},function(){return m.Y()},function(){return"<span style='text-decoration: overline'>"+input[0].name+input[1].name+"</span> = "+JXG.getReference(board,input[0].id).Dist(JXG.getReference(board,input[1].id))}]);return t}catch(e){$("debug").innerHTML+="* <b>Err:</b> Intersection "+attr.name+"<br>\n";return false}break;case"vector":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Vector:</b> First: "+input[0].name+", Second: "+input[1].name+"<br>\n";v=board.createElement("arrow",input,attr);return v}catch(e){$("debug").innerHTML+="* <b>Err:</b> Intersection "+attr.name+"<br>\n";return false}break;case"rotate":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Rotate:</b> First: "+input[0].name+", Second: "+input[1]+"<br>\n";attr.type="rotate";var d=parseInt(input[1]);r=board.createElement("transform",[d,input[2]],{type:"rotate"});p=board.createElement("point",[input[0],r],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Rotate "+attr.name+"<br>\n";return false}break;case"dilate":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Dilate:</b> First: "+input[0].name+", Second: "+input[1]+"<br>\n";attr.type="rotate";var d=parseInt(input[1]);d1=board.createElement("transform",[d,d],{type:"scale"});d2=board.createElement("transform",[function(){return(1-d)*input[2].X()},function(){return(1-d)*input[2].Y()}],{type:"translate"});p=board.createElement("point",[input[0],[d1,d2]],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Dilate "+attr.name+"<br>\n";return false}break;case"translate":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{t=board.createElement("transform",[function(){return input[1].point2.X()-input[1].point1.X()},function(){return input[1].point2.Y()-input[1].point1.Y()}],{type:"translate"});p=board.createElement("point",[input[0],t],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Translate "+attr.name+"<br>\n";return false}break;case"mirror":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);if(JXG.getReference(board,input[1].id).type==1330925652){var type="mirrorpoint"}else{if(JXG.getReference(board,input[1].id).type==1330924622){var type="reflection"}}try{$("debug").innerHTML+="* <b>Mirror:</b> First: "+input[0].name+", Second: "+input[1].name+"<br>\n";m=board.createElement(type,[input[1],input[0]],attr);return m}catch(e){$("debug").innerHTML+="* <b>Err:</b> Mirror "+attr.name+"<br>\n";return false}break;case"circle":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Circle:</b> First: "+input[0].name+", Second: "+input[1]+"<br>\n";c=board.createElement("circle",input,attr);return c}catch(e){$("debug").innerHTML+="* <b>Err:</b> Circle "+attr.name+"<br>\n";return false}break;case"circlearc":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>CircleArc:</b> First: "+input[0].name+", Second: "+input[1].name+"<br>\n";c=board.createElement("arc",input,attr);return c}catch(e){$("debug").innerHTML+="* <b>Err:</b> CircleArc "+attr.name+"<br>\n";return false}break;case"circlesector":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>CircleSector:</b> First: "+input[0].name+", Second: "+input[1].name+"<br>\n";c=board.createElement("sector",input,attr);return c}catch(e){$("debug").innerHTML+="* <b>Err:</b> CircleSector "+attr.name+"<br>\n";return false}break;case"linebisector":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>LineBiSector (Mittelsenkrechte):</b> First: "+input[0].name+"<br>\n";attr.straightFirst=true;attr.straightLast=true;m=board.createElement("midpoint",input,{visible:"false"});if(JXG.getReference(board,input[0].id).type==1330925652&&JXG.getReference(board,input[1].id).type==1330925652){l=board.createElement("line",input,{visible:"false"});p=board.createElement("perpendicular",[m,l],attr)}else{p=board.createElement("perpendicular",[m,input[0]],attr)}return p[0]}catch(e){$("debug").innerHTML+="* <b>Err:</b> LineBiSector (Mittelsenkrechte) "+attr.name+"<br>\n";return false}break;case"ray":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Strahl:</b> First: "+input[0].name+"<br>\n";attr.straightFirst=true;attr.straightLast=false;p=board.createElement("line",[input[1],input[0]],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Strahl "+attr.name+"<br>\n";return false}break;case"tangent":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Tangente:</b> First: "+input[0].name+", Sec.: "+input[1].name+"<br>\n";var m=function(circ){return[[circ.midpoint.X()*circ.midpoint.X()+circ.midpoint.Y()*circ.midpoint.Y()-circ.getRadius()*circ.getRadius(),-circ.midpoint.X(),-circ.midpoint.Y()],[-circ.midpoint.X(),1,0],[-circ.midpoint.Y(),0,1]]};var t=board.createElement("line",[function(){return JXG.Math.matVecMult(m(input[1]),input[0].coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(m(input[1]),input[0].coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(m(input[1]),input[0].coords.usrCoords)[2]}],{visible:false});var i1=board.createElement("intersection",[input[1],t,0],{visible:false});var i2=board.createElement("intersection",[input[1],t,1],{visible:false});var t1=board.createElement("line",[input[0],i1]);var t2=board.createElement("line",[input[0],i2])}catch(e){$("debug").innerHTML+="* <b>Err:</b> Tangente "+attr.name+"<br>\n";return false}break;case"circumcirclearc":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>CircumcircleArc:</b> First: "+input[0].name+"<br>\n";p=board.createElement("circumcircle",input,attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> CircumcircleArc "+attr.name+"<br>\n";return false}break;case"circumcirclesector":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>CircumcircleSector:</b> First: "+input[0].name+"<br>\n";p=board.createElement("sector",[input[0],input[2],input[1]],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> CircumcircleSector "+attr.name+"<br>\n";return false}break;case"semicircle":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Semicircle:</b> First: "+input[0].name+"<br>\n";m=board.createElement("midpoint",input,{visible:"false"});p=board.createElement("sector",[m,input[0],input[1]],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Semicircle "+attr.name+"<br>\n";return false}break;case"angle":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Angle:</b> First: "+input[0].name+"<br>\n";p=board.createElement("angle",input,attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Angle "+attr.name+"<br>\n";return false}break;case"angularbisector":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Angularbisector:</b> First: "+input[0].name+"<br>\n";p=board.createElement("bisector",input,attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Angularbisector "+attr.name+"<br>\n";return false}break;case"numeric":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);attr=JXG.GeogebraReader.visualProperties(element,attr);if(element.getElementsByTagName("slider").length==1){var sx=parseFloat(element.getElementsByTagName("slider")[0].attributes.x.value);var sy=parseFloat(element.getElementsByTagName("slider")[0].attributes.y.value);var tmp=new JXG.Coords(JXG.COORDS_BY_SCREEN,[sx,sy],board);sx=tmp.usrCoords[1];sy=tmp.usrCoords[2];if(element.getElementsByTagName("slider")[0].attributes.horizontal.value=="true"){var len=parseFloat(element.getElementsByTagName("slider")[0].attributes.width.value)/(board.unitX*board.zoomX);var ex=sx+len;var ey=sy}else{var len=parseFloat(element.getElementsByTagName("slider")[0].attributes.width.value)/(board.unitX*board.zoomX);var ex=sx;var ey=sy+len}var sip=parseFloat(element.getElementsByTagName("value")[0].attributes.val.value);var smin=parseFloat(element.getElementsByTagName("slider")[0].attributes.min.value);var smax=parseFloat(element.getElementsByTagName("slider")[0].attributes.max.value);(element.getElementsByTagName("animation")[0])?attr.snapWidth=parseFloat(element.getElementsByTagName("animation")[0].attributes.step.value):false;try{$("debug").innerHTML+="* <b>Numeric:</b> First: "+attr.name+"<br>\n";n=board.createElement("slider",[[sx,sy],[ex,ey],[smin,sip,smax]],attr);"__x","__y","return Math.sin(__x);";return n}catch(e){$("debug").innerHTML+="* <b>Err:</b> Numeric "+attr.name+"<br>\n";return false}}break;case"midpoint":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{p=board.createElement("midpoint",input,attr);$("debug").innerHTML+="* <b>Midpoint ("+p.id+"):</b> "+attr.name+"("+gxtEl.x+", "+gxtEl.y+")<br>\n";return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Midpoint "+attr.name+"<br>\n";return false}break;case"center":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{p=board.createElement("point",[function(){return JXG.getReference(board,input[0].id).midpoint.X()},function(){return JXG.getReference(board,input[0].id).midpoint.Y()}],attr);$("debug").innerHTML+="* <b>Center ("+p.id+"):</b> "+attr.name+"("+gxtEl.x+", "+gxtEl.y+")<br>\n";return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Center "+attr.name+"<br>\n";return false}break;case"function":var func=JXG.GeogebraReader.getElement(tree,attr.name,true);func=JXG.GeogebraReader.functionParse(func.attributes.exp.value);try{var l=func.length-1;if(l==1){f=board.createElement("functiongraph",[Function(func[0],func[1])])}else{if(l==2){f=board.createElement("functiongraph",[Function(func[0],func[1],func[2])])}else{if(l==3){f=board.createElement("functiongraph",[Function(func[0],func[1],func[2],func[3])])}else{if(l==4){f=board.createElement("functiongraph",[Function(func[0],func[1],func[2],func[3],func[4])])}}}}$("debug").innerHTML+="Functiongraph "+attr.name+"("+func[0]+", ...) = "+func[l]+"<br/>\n";return f}catch(e){$("debug").innerHTML+="* <b>Err:</b> Functiongraph "+attr.name+"<br>\n";return false}break;case"polar":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Polar:</b> First: "+input[0].name+", Sec.: "+input[1].name+"<br>\n";var m=function(circ){return[[circ.midpoint.X()*circ.midpoint.X()+circ.midpoint.Y()*circ.midpoint.Y()-circ.getRadius()*circ.getRadius(),-circ.midpoint.X(),-circ.midpoint.Y()],[-circ.midpoint.X(),1,0],[-circ.midpoint.Y(),0,1]]};var p=board.createElement("line",[function(){return JXG.Math.matVecMult(m(input[1]),input[0].coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(m(input[1]),input[0].coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(m(input[1]),input[0].coords.usrCoords)[2]}],attr);return p}catch(e){$("debug").innerHTML+="* <b>Err:</b> Polar "+attr.name+"<br>\n";return false}break;case"slope":attr=JXG.GeogebraReader.boardProperties(gxtEl,element,attr);attr=JXG.GeogebraReader.colorProperties(element,attr);gxtEl=JXG.GeogebraReader.coordinates(gxtEl,element);attr=JXG.GeogebraReader.visualProperties(element,attr);try{$("debug").innerHTML+="* <b>Slope:</b> First: "+input[0].name+"<br>\n";var l1=board.createElement("segment",[input[0].point1,[(1+input[0].point1.X()),input[0].point1.Y()]],{visible:false});var l2=board.createElement("normal",[l1,l1.point2],{visible:false});var i=board.createElement("intersection",[input[0],l2,0],{visible:false});var m=board.createElement("midpoint",[l1.point2,i],{visible:false});var slope=function(){return i.Y()-l1.point1.Y()};var t=board.createElement("text",[function(){return m.X()},function(){return m.Y()},function(){return"m = "+slope()}]);return m}catch(e){$("debug").innerHTML+="* <b>Err:</b> Slope "+attr.name+"<br>\n";return false}break;default:return false;break}};this.readGeogebra=function(tree,board){var registeredElements=[];var el,Data,i;var els=[];registeredElements=JXG.GeogebraReader.writeBoard(tree,board,registeredElements);var constructions=tree.getElementsByTagName("construction");for(var t=0;t<constructions.length;t++){var cmds=constructions[t].getElementsByTagName("command");for(var s=0;s<cmds.length;s++){Data=cmds[s];var input=[];for(i=0;i<Data.getElementsByTagName("input")[0].attributes.length;i++){el=Data.getElementsByTagName("input")[0].attributes[i].value;if(el.match(/°/)||!el.match(/\D/)||el.match(/Circle/)){input[i]=el}else{if(typeof registeredElements[el]=="undefined"||registeredElements[el]==""){var elnode=JXG.GeogebraReader.getElement(tree,el);registeredElements[el]=JXG.GeogebraReader.writeElement(registeredElements,tree,board,elnode);$("debug").innerHTML+="regged: "+registeredElements[el]+"<br/>"}input[i]=registeredElements[el]}}var output=[],elname=Data.getElementsByTagName("output")[0].attributes[0].value;for(i=0;i<Data.getElementsByTagName("output")[0].attributes.length;i++){el=Data.getElementsByTagName("output")[0].attributes[i].value;output[i]=JXG.GeogebraReader.getElement(tree,el)}if(typeof registeredElements[elname]=="undefined"||registeredElements[elname]==""){registeredElements[elname]=JXG.GeogebraReader.writeElement(registeredElements,tree,board,output,input,Data.attributes.name.value.toLowerCase());$("debug").innerHTML+="regged: "+registeredElements[elname].id+"<br/>";if(registeredElements[elname].borders){for(var i=0;i<registeredElements[elname].borders.length;i++){registeredElements[registeredElements[elname].borders[i].name]=registeredElements[elname].borders[i];$("debug").innerHTML+=i+") regged: "+registeredElements[elname].borders[i].name+"("+registeredElements[registeredElements[elname].borders[i].name].id+")<br/>"}}}}var elements=constructions[t].getElementsByTagName("element");for(var s=0;s<elements.length;s++){var Data=elements[s];var el=Data.attributes.label.value;if(typeof registeredElements[el]=="undefined"||registeredElements[el]==""){JXG.GeogebraReader.debug("Betrachte Rest: "+el);registeredElements[el]=JXG.GeogebraReader.writeElement(registeredElements,tree,board,Data);if(expr=JXG.GeogebraReader.getElement(tree,el,true)){var type=Data.attributes.type.value;switch(type){case"text":case"function":break;default:JXG.GeogebraReader.ggbParse(board,tree,registeredElements,el,expr.attributes.exp.value);break}}}}}board.fullUpdate()};this.prepareString=function(fileStr){if(fileStr.indexOf("<")!=0){bA=[];for(i=0;i<fileStr.length;i++){bA[i]=JXG.Util.asciiCharCodeAt(fileStr,i)}fileStr=(new JXG.Util.Unzip(bA)).unzipFile("geogebra.xml")}return fileStr}};JXG.IntergeoReader=new function(){this.board=null;this.objects={};this.readIntergeo=function(a,b){this.board=b;this.board.origin={};this.board.origin.usrCoords=[1,0,0];this.board.origin.scrCoords=[1,400,300];this.board.unitX=30;this.board.unitY=30;this.board.stretchX=this.board.zoomX*this.board.unitX;this.board.stretchY=this.board.zoomY*this.board.unitY;this.readElements(a.getElementsByTagName("elements"));this.board.fullUpdate();this.readConstraints(a.getElementsByTagName("constraints"));this.board.fullUpdate()};this.readElements=function(a){var b;for(var b=0;b<a[0].childNodes.length;b++){(function(d){var e;e=a[0].childNodes[d];if(e.nodeType>1){return}if(e.nodeName=="point"){JXG.IntergeoReader.addPoint(e)}else{if(e.nodeName=="line"){JXG.IntergeoReader.storeLine(e)}else{if(e.nodeName=="line_segment"){JXG.IntergeoReader.storeLine(e)}else{if(e.nodeName=="circle"){JXG.IntergeoReader.storeCircle(e)}else{document.getElementById("debug").innerHTML+="Not implemented: "+e.nodeName+" "+e.getAttribute("id")+"<br>"}}}}})(b)}};this.addPoint=function(d){var k=0,g=0,e=0,b,a=d.childNodes[k],m=[],h={strokeColor:"red",fillColor:"red",withLabel:true},o=[];while(a.nodeType>1){k++;a=d.childNodes[k]}h.name=d.getAttribute("id");if(a.nodeName=="homogeneous_coordinates"){for(g=0;g<a.childNodes.length;g++){if(a.childNodes[g].nodeType==1){if(a.childNodes[g].nodeName=="double"){m.push(a.childNodes[g].firstChild.data)}else{if(a.childNodes[g].nodeName=="complex"){for(e=0;e<a.childNodes[g].childNodes.length;e++){if(a.childNodes[g].childNodes[e].nodeName=="double"){m.push(a.childNodes[g].childNodes[e].firstChild.data)}}}else{document.getElementById("debug").innerHTML+="Not implemented: "+a.childNodes[g].nodeName+"<br>";return}}}}for(g=0;g<m.length;g++){m[g]=parseFloat(m[g])}if(m.length==3){o=[m[2],m[0],m[1]]}else{if(m.length==6&&Math.abs(m[1])<1e-10&&Math.abs(m[3])<1e-10&&Math.abs(m[5])<1e-10){o=[m[4],m[0],m[2]]}else{document.getElementById("debug").innerHTML+="type not supported, yet <br>";return}}}else{if(a.nodeName=="euclidean_coordinates"){for(g=0;g<a.childNodes.length;g++){if(a.childNodes[g].nodeType==1){m.push(a.childNodes[g].firstChild.data)}}for(g=0;g<m.length;g++){m[g]=parseFloat(m[g])}o=[m[0],m[1]]}else{if(a.nodeName=="polar_coordinates"){for(g=0;g<a.childNodes.length;g++){if(a.childNodes[g].nodeType==1){m.push(a.childNodes[g].firstChild.data)}}for(g=0;g<m.length;g++){m[g]=parseFloat(m[g])}o=[m[0]*Math.cos(m[1]),m[0]*Math.sin(m[1])]}else{document.getElementById("debug").innerHTML+="This coordinate type is not yet implemented: "+a.nodeName+"<br>";return}}}b=this.board.createElement("point",o,h);this.objects[d.getAttribute("id")]=b};this.storeLine=function(d){var b,e,g,a;this.objects[d.getAttribute("id")]={id:d.getAttribute("id"),coords:null};b=0;e=d.childNodes[b];while(e.nodeType>1){b++;e=d.childNodes[b]}if(e.nodeName=="homogeneous_coordinates"){g=[];for(a=0;a<e.childNodes.length;a++){if(e.childNodes[a].nodeType==1){if(e.childNodes[a].nodeName=="double"){g.push(parseFloat(e.childNodes[a].firstChild.data))}else{}}}this.objects[d.getAttribute("id")].coords=g}};this.addLine=function(e){var a,d=this.objects[e].coords,b;for(a=0;a<d.length;a++){d[a]=parseFloat(d[a])}b=this.board.createElement("line",[d[2],d[0],d[1]],{name:e,strokeColor:"black",withLabel:true});this.objects[e]=b};this.storeCircle=function(d){var b,a,e,g;this.objects[d.getAttribute("id")]={id:d.getAttribute("id"),coords:null};b=0;e=d.childNodes[b];while(e.nodeType>1){b++;e=d.childNodes[b]}if(e.nodeName=="matrix"){g=[];for(a=0;a<e.childNodes.length;a++){if(e.childNodes[a].nodeType==1){if(e.childNodes[a].nodeName=="double"){g.push(parseFloat(e.childNodes[a].firstChild.data))}else{}}}this.objects[d.getAttribute("id")].coords=g}};this.readConstraints=function(a){var b,d;this.board.options.point.strokeColor="blue";this.board.options.point.fillColor="blue";for(b=0;b<a[0].childNodes.length;b++){(function(e){var g;g=a[0].childNodes[e];if(g.nodeType>1){return}if(g.nodeName=="line_through_two_points"){JXG.IntergeoReader.addLineThroughTwoPoints(g)}else{if(g.nodeName=="line_through_point"){JXG.IntergeoReader.addLineThroughPoint(g)}else{if(g.nodeName=="line_parallel_to_line_through_point"){JXG.IntergeoReader.addLineParallelToLineThroughPoint(g)}else{if(g.nodeName=="line_perpendicular_to_line_through_point"){JXG.IntergeoReader.addLinePerpendicularToLineThroughPoint(g)}else{if(g.nodeName=="line_segment_by_points"){JXG.IntergeoReader.addLineSegmentByTwoPoints(g)}else{if(g.nodeName=="endpoints_of_line_segment"){JXG.IntergeoReader.addEndpointsOfLineSegment(g)}else{if(g.nodeName=="free_point"){}else{if(g.nodeName=="free_line"){JXG.IntergeoReader.addFreeLine(g)}else{if(g.nodeName=="point_on_line"){JXG.IntergeoReader.addPointOnLine(g)}else{if(g.nodeName=="point_on_line_segment"){JXG.IntergeoReader.addPointOnLine(g)}else{if(g.nodeName=="point_on_circle"){JXG.IntergeoReader.addPointOnCircle(g)}else{if(g.nodeName=="angular_bisector_of_three_points"){JXG.IntergeoReader.addAngularBisectorOfThreePoints(g)}else{if(g.nodeName=="angular_bisectors_of_two_lines"){JXG.IntergeoReader.addAngularBisectorsOfTwoLines(g)}else{if(g.nodeName=="midpoint_of_two_points"){JXG.IntergeoReader.addMidpointOfTwoPoints(g)}else{if(g.nodeName=="midpoint"){JXG.IntergeoReader.addMidpointOfTwoPoints(g)}else{if(g.nodeName=="midpoint_of_line_segment"){JXG.IntergeoReader.addMidpointOfLineSegment(g)}else{if(g.nodeName=="point_intersection_of_two_lines"){JXG.IntergeoReader.addPointIntersectionOfTwoLines(g)}else{if(g.nodeName=="locus_defined_by_point"){JXG.IntergeoReader.addLocusDefinedByPoint(g)}else{if(g.nodeName=="locus_defined_by_point_on_line"){JXG.IntergeoReader.addLocusDefinedByPointOnLine(g)}else{if(g.nodeName=="locus_defined_by_point_on_line_segment"){JXG.IntergeoReader.addLocusDefinedByPointOnLine(g)}else{if(g.nodeName=="locus_defined_by_line_through_point"){JXG.IntergeoReader.addLocusDefinedByLineThroughPoint(g)}else{if(g.nodeName=="locus_defined_by_point_on_circle"){JXG.IntergeoReader.addLocusDefinedByPointOnCircle(g)}else{if(g.nodeName=="circle_by_three_points"){JXG.IntergeoReader.addCircleByThreePoints(g)}else{if(g.nodeName=="circle_by_center_and_point"){JXG.IntergeoReader.addCircleByCenterAndPoint(g)}else{if(g.nodeName=="center_of_circle"){JXG.IntergeoReader.addCenterOfCircle(g)}else{if(g.nodeName=="intersection_points_of_two_circles"){JXG.IntergeoReader.addIntersectionPointsOfTwoCircles(g)}else{if(g.nodeName=="intersection_points_of_circle_and_line"){JXG.IntergeoReader.addIntersectionPointsOfCircleAndLine(g)}else{if(g.nodeName=="other_intersection_point_of_two_circles"){JXG.IntergeoReader.addOtherIntersectionPointOfTwoCircles(g)}else{if(g.nodeName=="other_intersection_point_of_circle_and_line"){JXG.IntergeoReader.addOtherIntersectionPointOfCircleAndLine(g)}else{if(g.nodeName=="circle_tangent_lines_by_point"){JXG.IntergeoReader.addCircleTangentLinesByPoint(g)}else{d=JXG.IntergeoReader.readParams(g);$("debug").innerHTML+="readConstraints: not implemented: "+g.nodeName+": "+d[0]+"<br>"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}})(b)}};this.setAttributes=function(a){a.setProperty({strokecolor:this.board.options.point.strokeColor,fillColor:this.board.options.point.fillColor})};this.readParams=function(b){var d=[],a;for(a=0;a<b.childNodes.length;a++){if(b.childNodes[a].nodeType==1){d.push(b.childNodes[a].firstChild.data)}}return d};this.addLineThroughTwoPoints=function(b){var d=JXG.IntergeoReader.readParams(b),a=this.board.createElement("line",[this.objects[d[1]],this.objects[d[2]]],{name:d[0],withLabel:true});this.objects[d[0]]=a};this.addLineThroughPoint=function(d){var g=JXG.IntergeoReader.readParams(d),a,h=this.objects[g[0]].coords,e=this.objects[g[1]],b;for(a=0;a<h.length;a++){h[a]=parseFloat(h[a])}b=this.board.createElement("line",[function(){return h[2]-h[0]*e.X()-h[1]*e.Y()-h[2]*e.Z()},h[0],h[1]],{name:g[0],strokeColor:"black",withLabel:true});this.objects[g[0]]=b};this.addLineParallelToLineThroughPoint=function(b){var d=JXG.IntergeoReader.readParams(b),a=this.board.createElement("parallel",[this.objects[d[1]].id,this.objects[d[2]].id],{name:d[0],withLabel:true});this.objects[d[0]]=a};this.addLinePerpendicularToLineThroughPoint=function(b){var d=JXG.IntergeoReader.readParams(b),a=this.board.createElement("perpendicular",[this.objects[d[1]].id,this.objects[d[2]].id],{name:d[0],withLabel:true});a[0].setProperty("straightFirst:true","straightLast:true");a[1].setProperty("visible:false");this.objects[d[0]]=a[0]};this.addLineSegmentByTwoPoints=function(b){var d=JXG.IntergeoReader.readParams(b),a=this.board.createElement("line",[this.objects[d[1]],this.objects[d[2]]],{name:d[0],straightFirst:false,straightLast:false,strokeColor:"black",withLabel:true});this.objects[d[0]]=a};this.addEndpointsOfLineSegment=function(b){var d=JXG.IntergeoReader.readParams(b),a=this.objects[d[2]];this.objects[d[0]].addConstraint([function(){return a.point1.Z()},function(){return a.point1.X()},function(){return a.point1.Y()}]);this.objects[d[1]].addConstraint([function(){return a.point2.Z()},function(){return a.point2.X()},function(){return a.point2.Y()}]);this.setAttributes(this.objects[d[0]]);this.setAttributes(this.objects[d[1]])};this.addPointIntersectionOfTwoLines=function(a){var b=JXG.IntergeoReader.readParams(a);this.objects[b[0]].addConstraint([this.board.intersectionFunc(this.objects[b[1]],this.objects[b[2]],0)]);this.setAttributes(this.objects[b[0]])};this.addFreeLine=function(g){var h=JXG.IntergeoReader.readParams(g),e=this.objects[h[0]].coords[0],d=this.objects[h[0]].coords[1],k=this.objects[h[0]].coords[2];el=this.board.createElement("line",[k,e,d],{name:h[0],id:h[0],withLabel:true});this.objects[h[0]]=el};this.addPointOnLine=function(b){var e=JXG.IntergeoReader.readParams(b),d=JXG.getReference(this.board,e[0]),a=JXG.getReference(this.board,e[1]);d.makeGlider(a)};this.addPointOnCircle=function(a){var d=JXG.IntergeoReader.readParams(a),b=JXG.getReference(this.board,d[0]),e=JXG.getReference(this.board,d[1]);b.makeGlider(e)};this.addAngularBisectorOfThreePoints=function(b){var d=JXG.IntergeoReader.readParams(b),a=this.board.createElement("bisector",[d[1],d[2],d[3]],{name:d[0],id:d[0],withLabel:true});a.setProperty({straightFirst:false,straightLast:true,strokeColor:"#000000"});this.objects[d[0]]=a};this.addMidpointOfTwoPoints=function(a){var e=JXG.IntergeoReader.readParams(a),g=JXG.getReference(this.board,e[0]),d=JXG.getReference(this.board,e[1]),b=JXG.getReference(this.board,e[2]);g.addConstraint([function(){return 0.5*(d.Z()+b.Z())},function(){return 0.5*(d.X()+b.X())},function(){return 0.5*(d.Y()+b.Y())},]);this.setAttributes(g)};this.addMidpointOfLineSegment=function(b){var d=JXG.IntergeoReader.readParams(b),e=JXG.getReference(this.board,d[0]),a=JXG.getReference(this.board,d[1]);e.addConstraint([function(){return 0.5*(a.point1.Z()+a.point2.Z())},function(){return 0.5*(a.point1.X()+a.point2.X())},function(){return 0.5*(a.point1.Y()+a.point2.Y())},]);this.setAttributes(e)};this.addAngularBisectorsOfTwoLines=function(d){var e=JXG.IntergeoReader.readParams(d),b=this.objects[e[2]],a=this.objects[e[3]];this.board.createElement("bisectorlines",[b,a],{name:[e[0],e[1]],id:[e[0],e[1]],straightFirst:true,straightLast:true,strokeColor:"#ff0000",withLabel:true})};this.addLocusDefinedByPoint=function(b){var d=JXG.IntergeoReader.readParams(b),a=JXG.getReference(this.board,d[1]);a.setProperty({trace:true});this.objects[d[1]]=a;this.setAttributes(a)};this.addLocusDefinedByPointOnLine=function(b){var d=JXG.IntergeoReader.readParams(b),a=JXG.getReference(this.board,d[1]);a.setProperty({trace:true});this.objects[d[1]]=a;this.setAttributes(a)};this.addLocusDefinedByLineThroughPoint=function(b){var d=JXG.IntergeoReader.readParams(b),a=JXG.getReference(this.board,d[1]);a.setProperty({trace:true});this.objects[d[1]]=a;this.setAttributes(a)};this.addLocusDefinedByPointOnCircle=function(b){var d=JXG.IntergeoReader.readParams(b),a=JXG.getReference(this.board,d[1]);a.setProperty({trace:true});this.objects[d[1]]=a;this.setAttributes(a)};this.addCircleByThreePoints=function(d){var g=JXG.IntergeoReader.readParams(d),e=[],b,a;for(b=0;b<3;b++){e[b]=JXG.getReference(this.board,g[b+1])}a=this.board.createElement("circumcircle",e,{name:["",g[0]],id:["",g[0]],withLabel:true});a[0].setProperty({visible:false});a[1].setProperty({withLabel:true})};this.addCircleByCenterAndPoint=function(a){var b=JXG.IntergeoReader.readParams(a);this.board.createElement("circle",[this.objects[b[1]],this.objects[b[2]]],{name:b[0],id:b[0],withLabel:true})};this.addCenterOfCircle=function(b){var d=JXG.IntergeoReader.readParams(b),a=JXG.getReference(this.board,d[0]),e=JXG.getReference(this.board,d[1]);a.addConstraint([function(){return e.midpoint.X()},function(){return e.midpoint.Y()}])};this.addIntersectionPointsOfTwoCircles=function(d){var h=JXG.IntergeoReader.readParams(d),b=JXG.getReference(this.board,h[2]),a=JXG.getReference(this.board,h[3]),g=this.objects[h[0]],e=this.objects[h[1]];g.addConstraint([this.board.intersection(b,a,0)]);e.addConstraint([this.board.intersection(b,a,1)]);this.setAttributes(g);this.setAttributes(e)};this.addIntersectionPointsOfCircleAndLine=function(d){var h=JXG.IntergeoReader.readParams(d),b=JXG.getReference(this.board,h[2]),a=JXG.getReference(this.board,h[3]),g=this.objects[h[0]],e=this.objects[h[1]];g.addConstraint([this.board.intersection(b,a,0)]);e.addConstraint([this.board.intersection(b,a,1)]);this.setAttributes(g);this.setAttributes(e)};this.addOtherIntersectionPointOfTwoCircles=function(d){var h=JXG.IntergeoReader.readParams(d),b=JXG.getReference(this.board,h[2]),a=JXG.getReference(this.board,h[3]),g=this.objects[h[1]],e=this.objects[h[0]];e.addConstraint([this.board.otherIntersection(b,a,g)]);this.setAttributes(e)};this.addOtherIntersectionPointOfCircleAndLine=function(a){this.addOtherIntersectionPointOfTwoCircles(a)};this.addCircleTangentLinesByPoint=function(e){var d=JXG.IntergeoReader.readParams(e),q=JXG.getReference(this.board,d[2]),b=JXG.getReference(this.board,d[3]),g,a,k,h,o,l;a=this.board.createElement("line",[function(){return JXG.Math.matVecMult(q.quadraticform,b.coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(q.quadraticform,b.coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(q.quadraticform,b.coords.usrCoords)[2]}],{visible:false});k=this.board.createElement("intersection",[q,a,0],{visible:false});h=this.board.createElement("intersection",[q,a,1],{visible:false});o=this.board.createElement("tangent",[k,q]);l=this.board.createElement("tangent",[h,q]);this.objects[d[0]]=o;this.objects[d[1]]=l};this.prepareString=function(b){var d=[],a;if(b.indexOf("<")!=0){for(a=0;a<b.length;a++){d[a]=JXG.Util.asciiCharCodeAt(b,a)}b=(new JXG.Util.Unzip(d)).unzipFile("construction/intergeo.xml")}return b}};JXG.Board=function(a,h,b,p,o,m,l,k,d,e,g){this.BOARD_MODE_NONE=0;this.BOARD_MODE_DRAG=1;this.BOARD_MODE_CONSTRUCT=16;this.BOARD_MODE_MOVE_ORIGIN=2;this.BOARD_QUALITY_LOW=1;this.BOARD_QUALITY_HIGH=2;this.CONSTRUCTION_TYPE_POINT=1129599060;this.CONSTRUCTION_TYPE_CIRCLE=1129595724;this.CONSTRUCTION_TYPE_LINE=1129598030;this.CONSTRUCTION_TYPE_GLIDER=1129596740;this.CONSTRUCTION_TYPE_MIDPOINT=1129598288;this.CONSTRUCTION_TYPE_PERPENDICULAR=1129599044;this.CONSTRUCTION_TYPE_PARALLEL=1129599052;this.CONSTRUCTION_TYPE_INTERSECTION=1129597267;this.container=a;this.containerObj=document.getElementById(this.container);if(this.containerObj==null){throw ("\nJSXGraph error: HTML container element '"+(box)+"' not found.")}this.renderer=h;this.options=new JXG.Options();this.dimension=2;this.origin={};this.origin.usrCoords=[1,0,0];this.origin.scrCoords=[1,p[0],p[1]];this.zoomX=o;this.zoomY=m;this.unitX=l;this.unitY=k;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.canvasWidth=d;this.canvasHeight=e;this.fontSize=this.options.fontSize;this.algebra=new JXG.Algebra(this);this.mathStatistics=new JXG.MathStatistics();if((b!="")&&(b!=null)&&(typeof document.getElementById(b)!="undefined")){this.id=b}else{this.id=this.generateId()}this.hooks=[];this.dependentBoards=[];this.objects={};this.animationObjects={};this.highlightedObjects={};this.numObjects=0;this.elementsByName={};this.mode=this.BOARD_MODE_NONE;this.updateQuality=this.BOARD_QUALITY_HIGH;this.isSuspendedRedraw=false;this.snapToGrid=this.options.grid.snapToGrid;this.gridX=this.options.grid.gridX;this.gridY=this.options.grid.gridY;this.gridColor=this.options.grid.gridColor;this.gridOpacity=this.options.grid.gridOpacity;this.gridDash=this.options.grid.gridDash;this.snapSizeX=this.options.grid.snapSizeX;this.snapSizeY=this.options.grid.snapSizeY;this.calculateSnapSizes();this.hasGrid=this.options.grid.hasGrid;this.drag_dx=0;this.drag_dy=0;this.drag_obj=null;this.xmlString="";if((g!=null&&g)||(g==null&&this.options.showCopyright)){this.renderer.displayCopyright(JXG.JSXGraph.licenseText,this.options.fontSize)}this.needsFullUpdate=false;this.reducedUpdate=false;this.geonextCompatibilityMode=false;JXG.addEvent(document,"mousedown",this.mouseDownListener,this);JXG.addEvent(this.containerObj,"mousemove",this.mouseMoveListener,this)};JXG.Board.prototype.generateName=function(d){if(d.type==JXG.OBJECT_TYPE_TICKS){return}var l;if(d.elementClass==JXG.OBJECT_CLASS_POINT){l=["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]}else{l=["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]}var g=3;var b="";var o="";var m="";if(d.elementClass==JXG.OBJECT_CLASS_POINT||d.elementClass==JXG.OBJECT_CLASS_LINE){}else{if(d.type==JXG.OBJECT_TYPE_POLYGON){b="P_{";m="}"}else{if(d.type==JXG.OBJECT_TYPE_CIRCLE){b="k_{";m="}"}else{if(d.type==JXG.OBJECT_TYPE_ANGLE){b="W_{";m="}"}else{b="s_{";m="}"}}}}var p=[];var a="";var k="";var h=0;var e=0;for(h=0;h<g;h++){p[h]=0}while(p[g-1]<l.length){for(p[0]=1;p[0]<l.length;p[0]++){a=b;for(h=g;h>0;h--){a+=l[p[h-1]]}if(this.elementsByName[a+m]==null){return a+m}}p[0]=l.length;for(h=1;h<g;h++){if(p[h-1]==l.length){p[h-1]=1;p[h]++}}}return""};JXG.Board.prototype.generateId=function(){var a=1;while(JXG.JSXGraph.boards["gxtBoard"+a]!=null){a=Math.round(Math.random()*33)}return("gxtBoard"+a)};JXG.Board.prototype.setId=function(e,d){var b=this.numObjects,a=e.id;this.numObjects++;if((a=="")||(a==null)){a=this.id+d+b}e.id=a;this.objects[a]=e;if(e.hasLabel){e.label.content.id=a+"Label";this.addText(e.label.content)}return a};JXG.Board.prototype.getRelativeMouseCoordinates=function(b){var d=this.containerObj,a=JXG.getOffset(d),e;e=parseInt(JXG.getStyle(d,"borderLeftWidth"));if(isNaN(e)){e=0}a[0]+=0;e=parseInt(JXG.getStyle(d,"borderTopWidth"));if(isNaN(e)){e=0}a[1]+=e;e=parseInt(JXG.getStyle(d,"paddingLeft"));if(isNaN(e)){e=0}a[0]+=0;e=parseInt(JXG.getStyle(d,"paddingTop"));if(isNaN(e)){e=0}a[1]+=e;return a};JXG.Board.prototype.clickLeftArrow=function(a){this.origin.scrCoords[1]+=this.canvasWidth*0.1;this.moveOrigin();return this};JXG.Board.prototype.clickRightArrow=function(a){this.origin.scrCoords[1]-=this.canvasWidth*0.1;this.moveOrigin();return this};JXG.Board.prototype.clickUpArrow=function(a){this.origin.scrCoords[2]+=this.canvasHeight*0.1;this.moveOrigin();return this};JXG.Board.prototype.clickDownArrow=function(a){this.origin.scrCoords[2]-=this.canvasHeight*0.1;this.moveOrigin();return this};JXG.Board.prototype.mouseUpListener=function(a){this.updateQuality=this.BOARD_QUALITY_HIGH;JXG.removeEvent(document,"mouseup",this.mouseUpListener,this);if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.moveOrigin()}else{this.update()}this.mode=this.BOARD_MODE_NONE;this.drag_obj=null};JXG.Board.prototype.mouseDownListener=function(h){var e,k,g,a,d,b;g=this.getRelativeMouseCoordinates(h);a=JXG.getPosition(h);d=a[0]-g[0];b=a[1]-g[1];if(h.shiftKey){this.drag_dx=d-this.origin.scrCoords[1];this.drag_dy=b-this.origin.scrCoords[2];this.mode=this.BOARD_MODE_MOVE_ORIGIN;JXG.addEvent(document,"mouseup",this.mouseUpListener,this);return}if(this.mode==this.BOARD_MODE_CONSTRUCT){return}this.mode=this.BOARD_MODE_DRAG;if(this.mode==this.BOARD_MODE_DRAG){for(e in this.objects){k=this.objects[e];if((k.hasPoint!=undefined)&&((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER))&&(k.visProp.visible)&&(!k.fixed)&&(k.hasPoint(d,b))){this.drag_obj=this.objects[e];if((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER)){break}}}}if(this.drag_obj==null){this.mode=this.BOARD_MODE_NONE;return}this.dragObjCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,b],this);JXG.addEvent(document,"mouseup",this.mouseUpListener,this)};JXG.Board.prototype.mouseMoveListener=function(h){var b,d,k,a,m,l,e;k=this.getRelativeMouseCoordinates(h);a=JXG.getPosition(h);x=a[0]-k[0];y=a[1]-k[1];this.updateQuality=this.BOARD_QUALITY_LOW;this.dehighlightAll(x,y);if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.origin.scrCoords[1]=x-this.drag_dx;this.origin.scrCoords[2]=y-this.drag_dy;this.moveOrigin()}else{if(this.mode==this.BOARD_MODE_DRAG){e=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(x,y),this);if(this.drag_obj.type==JXG.OBJECT_TYPE_POINT||this.drag_obj.type==JXG.OBJECT_TYPE_LINE||this.drag_obj.type==JXG.OBJECT_TYPE_CIRCLE||this.drag_obj.type==JXG.OBJECT_TYPE_CURVE){if((this.geonextCompatibilityMode&&this.drag_obj.type==JXG.OBJECT_TYPE_POINT)||this.drag_obj.group.length!=0){this.drag_obj.setPositionDirectly(JXG.COORDS_BY_USER,e.usrCoords[1],e.usrCoords[2])}else{this.drag_obj.setPositionByTransform(JXG.COORDS_BY_USER,e.usrCoords[1]-this.dragObjCoords.usrCoords[1],e.usrCoords[2]-this.dragObjCoords.usrCoords[2]);this.dragObjCoords=e}this.update(this.drag_obj)}else{if(this.drag_obj.type==JXG.OBJECT_TYPE_GLIDER){var g=this.drag_obj.coords;this.drag_obj.setPositionDirectly(JXG.COORDS_BY_USER,e.usrCoords[1],e.usrCoords[2]);if(this.drag_obj.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){this.drag_obj.coords=this.algebra.projectPointToCircle(this.drag_obj,this.drag_obj.slideObject)}else{if(this.drag_obj.slideObject.type==JXG.OBJECT_TYPE_LINE){this.drag_obj.coords=this.algebra.projectPointToLine(this.drag_obj,this.drag_obj.slideObject)}}if(this.drag_obj.group.length!=0){this.drag_obj.group[this.drag_obj.group.length-1].dX=this.drag_obj.coords.scrCoords[1]-g.scrCoords[1];this.drag_obj.group[this.drag_obj.group.length-1].dY=this.drag_obj.coords.scrCoords[2]-g.scrCoords[2];this.drag_obj.group[this.drag_obj.group.length-1].update(this)}else{this.update(this.drag_obj)}}}this.updateInfobox(this.drag_obj)}else{for(b in this.objects){d=this.objects[b];if(d.hasPoint!=undefined&&d.visProp.visible==true&&d.hasPoint(x,y)){this.updateInfobox(d);if(this.highlightedObjects[b]==null){d.highlight();this.highlightedObjects[b]=d}}}}}this.updateQuality=this.BOARD_QUALITY_HIGH};JXG.Board.prototype.updateInfobox=function(b){var a,g,d,e;if((b.elementClass==JXG.OBJECT_CLASS_POINT)&&b.showInfobox){d=b.coords.usrCoords[1]*1;e=b.coords.usrCoords[2]*1;this.infobox.setCoords(d+this.infobox.distanceX/(this.stretchX),e+this.infobox.distanceY/(this.stretchY));a=Math.abs(d);if(a>0.1){a=d.toFixed(2)}else{if(a>=0.01){a=d.toFixed(4)}else{if(a>=0.0001){a=d.toFixed(6)}else{a=d}}}g=Math.abs(e);if(g>0.1){g=e.toFixed(2)}else{if(g>=0.01){g=e.toFixed(4)}else{if(g>=0.0001){g=e.toFixed(6)}else{g=e}}}this.highlightInfobox(a,g,b);this.renderer.show(this.infobox);this.renderer.updateText(this.infobox)}return this};JXG.Board.prototype.highlightInfobox=function(a,d,b){this.infobox.setText('<span style="color:#bbbbbb;">('+a+", "+d+")</span>");return this};JXG.Board.prototype.dehighlightAll=function(a,e){var b,d;for(b in this.highlightedObjects){d=this.highlightedObjects[b];if((d.hasPoint==undefined)||(!d.hasPoint(a,e))||(d.visProp.visible==false)){d.noHighlight();delete (this.highlightedObjects[b])}}return this};JXG.Board.prototype.getScrCoordsOfMouse=function(a,d){if(this.snapToGrid){var b=new JXG.Coords(JXG.COORDS_BY_SCREEN,[a,d],this);b.setCoordinates(JXG.COORDS_BY_USER,[Math.round((b.usrCoords[1])*this.snapSizeX)/this.snapSizeX,Math.round((b.usrCoords[2])*this.snapSizeY)/this.snapSizeY]);return[b.scrCoords[1],b.scrCoords[2]]}else{return[a,d]}};JXG.Board.prototype.getUsrCoordsOfMouse=function(g){var d=this.getRelativeMouseCoordinates(g);var b=JXG.getPosition(g);var a=b[0]-d[0];var h=b[1]-d[1];var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[a,h],this);if(this.snapToGrid){e.setCoordinates(JXG.COORDS_BY_USER,[Math.round((e.usrCoords[1])*this.snapSizeX)/this.snapSizeX,Math.round((e.usrCoords[2])*this.snapSizeY)/this.snapSizeY])}return[e.usrCoords[1],e.usrCoords[2]]};JXG.Board.prototype.getAllUnderMouse=function(b){var a=this.getAllObjectsUnderMouse(b);a.push(this.getUsrCoordsOfMouse(b));return a};JXG.Board.prototype.getAllObjectsUnderMouse=function(k){var h=this.getRelativeMouseCoordinates(k);var a=JXG.getPosition(k);var d=a[0]-h[0];var b=a[1]-h[1];var e=[];for(var g in this.objects){if(this.objects[g].visProp.visible&&this.objects[g].hasPoint(d,b)){e.push(this.objects[g])}}return e};JXG.Board.prototype.setBoardMode=function(a){this.mode=a;return this};JXG.Board.prototype.moveOrigin=function(){for(var a in this.objects){if((this.objects[a].elementClass==JXG.OBJECT_CLASS_POINT)||(this.objects[a].type==JXG.OBJECT_TYPE_CURVE)||(this.objects[a].type==JXG.OBJECT_TYPE_AXIS)||(this.objects[a].type==JXG.OBJECT_TYPE_TEXT)){if((this.objects[a].type!=JXG.OBJECT_TYPE_CURVE)&&(this.objects[a].type!=JXG.OBJECT_TYPE_AXIS)){this.objects[a].coords.usr2screen()}}}this.clearTraces();this.fullUpdate();if(this.hasGrid){this.renderer.removeGrid(this);this.renderer.drawGrid(this)}return this};JXG.Board.prototype.finalizeAdding=function(a){if(a.hasLabel){this.renderer.drawText(a.label.content)}if(!a.visProp.visible){this.renderer.hide(a)}if(a.hasLabel&&!a.label.content.visProp.visible){this.renderer.hide(a.label.content)}};JXG.Board.prototype.addPoint=function(a){var b=this.setId(a,"P");this.renderer.drawPoint(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addLine=function(a){var b=this.setId(a,"L");this.renderer.drawLine(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addCircle=function(a){var b=this.setId(a,"C");this.renderer.drawCircle(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addPolygon=function(a){var b=this.setId(a,"Py");this.renderer.drawPolygon(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addArc=function(a){var b=this.setId(a,"Ac");this.renderer.drawArc(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addSector=function(a){return this.setId(a,"Sc")};JXG.Board.prototype.addAngle=function(a){var b=this.setId(a,"Ag");this.renderer.drawAngle(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addCurve=function(a){var b=this.setId(a,"G");this.renderer.drawCurve(a);this.finalizeAdding(a);return b};JXG.Board.prototype.addChart=function(a){return this.setId(a,"Chart")};JXG.Board.prototype.addMidpoint=function(k,h,l,b){var e=JXG.getReference(this,k);var d=JXG.getReference(this,h);var a=this.algebra.midpoint(e,d).usrCoords.slice(1);var g=new JXG.Point(this,a,l,b,true);g.fixed=true;e.addChild(g);d.addChild(g);g.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.midpoint(e,d);this.label.content.update();if(this.traced){this.cloneToBackground(true)}}};return g};JXG.Board.prototype.addReflection=function(e,d,l,h){var g=JXG.getReference(this,d);var b=JXG.getReference(this,e);var a=this.algebra.reflection(b,g).usrCoords.slice(1);var k=new JXG.Point(this,a,l,h,true);k.fixed=true;g.addChild(k);b.addChild(k);k.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.reflection(b,g);this.label.content.update();if(this.traced){this.cloneToBackground(true)}}};return k};JXG.Board.prototype.addRotation=function(a,m,l,e,b){var g=JXG.getReference(this,m);var k=JXG.getReference(this,a);var h=this.algebra.rotation(k,g,l).usrCoords.slice(1);var d=new JXG.Point(this,h,e,b,true);d.fixed=true;g.addChild(d);k.addChild(d);d.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.rotation(k,g,l);this.label.content.update();this.needsUpdate=false;if(this.traced){this.cloneToBackground(true)}}};return d};JXG.Board.prototype.addParallel=function(e,d,b,a){var o=JXG.getReference(this,d);var q=JXG.getReference(this,e);var g=this.numObjects;g++;if((b=="")||(b==null)){b=this.id+"L"+g}var k=this.algebra.parallel(q.point1,q.point2,o).usrCoords.slice(1);var m=new JXG.Point(this,k,b+"P2",a+"P2",false);m.fixed=true;o.addChild(m);var h=new JXG.Line(this,o.id,m.id,b,a);h.update=function(){if(this.needsUpdate){this.point2.coords=this.board.algebra.parallel(q.point1,q.point2,o);this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return h};JXG.Board.prototype.addArrowParallel=function(o,b,s,g,h,k){var u=JXG.getReference(this,b);var q=JXG.getReference(this,o);var d=this.numObjects;d++;if((s=="")||(s==null)){s=this.id+"A"+d}d++;if((g=="")||(g==null)){g=this.id+"P"+d}var l=this.algebra.parallel(q.point1,q.point2,u).usrCoords.slice(1);var m=new JXG.Point(this,l,g,k,true);m.fixed=true;u.addChild(m);q.addChild(m);var e=new JXG.Line(this,u.id,m.id,s,h);e.setStraight(false,false);e.setArrow(false,true);e.update=function(){if(this.needsUpdate){this.point2.coords=this.board.algebra.parallel(q.point1,q.point2,u);this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};m.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.parallel(q.point1,q.point2,u);if(this.label.content.visProp.visible){this.label.content.update()}if(this.traced){this.cloneToBackground(true)}}};return[e,m]};JXG.Board.prototype.addParallelPoint=function(k,h,g,l,b){var a=this.numObjects+1;if((l=="")||(l==null)){l=this.id+"P"+a}k=JXG.getReference(this,k);h=JXG.getReference(this,h);g=JXG.getReference(this,g);var e=this.algebra.parallel(k,h,g).usrCoords.slice(1);var d=new JXG.Point(this,e,l,b,true);d.fixed=true;k.addChild(d);g.addChild(d);if(k.type==JXG.OBJECT_TYPE_POINT){h.addChild(d)}d.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.parallel(k,h,g);this.label.content.update();if(this.traced){this.cloneToBackground(true)}}};return d};JXG.Board.prototype.addArrow=function(d){var b=this.numObjects,a;this.numObjects++;a=d.id;if((a=="")||(a==null)){a=this.id+"A"+b}this.objects[a]=d;d.id=a;this.renderer.drawArrow(d);return a};JXG.Board.prototype.addNormal=function(g,d,b,a){var q=JXG.getReference(this,d);var s=JXG.getReference(this,g);var h=this.numObjects;h++;if((b=="")||(b==null)){b=this.id+"L"+h}var o=this.algebra.perpendicular(s,q);var k=o[0].usrCoords.slice(1);var m=new JXG.Point(this,k,b+"P2","",false);m.fixed=true;q.addChild(m);s.addChild(m);var e;if(o[1]){e=new JXG.Line(this,m.id,q.id,b,a)}else{e=new JXG.Line(this,q.id,m.id,b,a)}e.changed=o[1];e.update=function(){if(this.needsUpdate){var p=this.board.algebra.perpendicular(s,q);m.coords=p[0];if(this.changed!=p[1]){var l=this.point1;this.point1=this.point2;this.point2=l}this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return e};JXG.Board.prototype.addPerpendicular=function(e,a,o,g,k,d){var h,q,m,s,b;a=JXG.getReference(this,a);e=JXG.getReference(this,e);h=this.numObjects+1;if((o=="")||(o==null)){o=this.id+"L"+h}h++;if((k=="")||(k==null)){k=this.id+"P"+h}q=this.algebra.perpendicular(e,a);m=q[0].usrCoords.slice(1);s=new JXG.Point(this,m,k,d,true);s.fixed=true;a.addChild(s);e.addChild(s);if(q[1]){b=new JXG.Line(this,s.id,a.id,o,g)}else{b=new JXG.Line(this,a.id,s.id,o,g)}b.setStraight(false,false);b.changed=q[1];b.update=function(){var p,l;if(this.needsUpdate){p=this.board.algebra.perpendicular(e,a);point2.coords=p[0];if(this.changed!=p[1]){l=this.point1;this.point1=this.point2;this.point2=l}this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return[b,s]};JXG.Board.prototype.addPerpendicularPoint=function(a,h,e,k){var b,d,g;h=JXG.getReference(this,h);a=JXG.getReference(this,a);b=this.numObjects+1;if((e=="")||(e==null)){e=this.id+"P"+b}d=this.algebra.perpendicular(a,h)[0].usrCoords.slice(1);g=new JXG.Point(this,d,e,k,true);g.fixed=true;h.addChild(g);a.addChild(g);g.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.perpendicular(a,h)[0];this.label.content.update();if(this.traced){this.cloneToBackground(true)}}};return g};JXG.Board.prototype.addCircumcenter=function(o,h,g,k,m,e,a){var s=JXG.getReference(this,o),q=JXG.getReference(this,h),p=JXG.getReference(this,g),d=this.algebra.circumcenterMidpoint(s,q,p),l=new JXG.Point(this,d.usrCoords.slice(1),k,m,true),b;l.fixed=true;s.addChild(l);q.addChild(l);p.addChild(l);b=new JXG.Circle(this,"pointRadius",l.id,function(){return this.midpoint.coords.distance(JXG.COORDS_BY_USER,s.coords)},e,a);s.addChild(b);q.addChild(b);p.addChild(b);l.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.circumcenterMidpoint(s,q,p);if(this.label.content.visProp.visible){this.label.content.update()}if(this.traced){this.cloneToBackground(true)}}};b.update=function(){if(this.needsUpdate){this.updateRadius();this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return[l,b]};JXG.Board.prototype.addCircumcenterMidpoint=function(h,d,b,e,g){var m=JXG.getReference(this,h);var l=JXG.getReference(this,d);var k=JXG.getReference(this,b);var a=this.algebra.circumcenterMidpoint(m,l,k).usrCoords.slice(1);var o=new JXG.Point(this,a,e,g,true);o.fixed=true;m.addChild(o);l.addChild(o);k.addChild(o);o.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.circumcenterMidpoint(m,l,k);if(this.label.content.visProp.visible){this.label.content.update()}if(this.traced){this.cloneToBackground(true)}}};return o};JXG.Board.prototype.addIntersection=function(d){var b=this.numObjects;this.numObjects++;var a=d.id;if((a=="")||(a==null)){a=this.id+"I"+b}this.objects[a]=d;d.id=a;d.intersect1.addChild(d);d.intersect2.addChild(d);return a};JXG.Board.prototype.addAngleBisector=function(q,p,o,b,a){var l=JXG.getReference(this,q);var h=JXG.getReference(this,p);var e=JXG.getReference(this,o);var d=this.numObjects;d++;if((b=="")||(b==null)){b=this.id+"L"+d}var k=this.algebra.angleBisector(l,h,e).usrCoords.slice(1);var m=new JXG.Point(this,k,b+"P2","",false);m.fixed=true;l.addChild(m);h.addChild(m);e.addChild(m);var g=new JXG.Line(this,p,m.id,b,a);g.setStraight(false,true);g.update=function(){if(this.needsUpdate){this.point2.coords=this.board.algebra.angleBisector(l,h,e);this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return g};JXG.Board.prototype.addText=function(d){var b=this.numObjects;this.numObjects++;var a=d.id;if((a=="")||(a==null)){a=this.id+"T"+b}this.objects[a]=d;d.id=a;if(!d.isLabel){this.renderer.drawText(d);if(!d.visProp.visible){this.renderer.hide(d)}}return a};JXG.Board.prototype.addConditions=function(p){var o=null;var b="var el,x,y,c;\n";var l=p.indexOf("<data>");var k=p.indexOf("</data>");if(l<0){return}while(l>=0){var h=p.slice(l+6,k);var g=h.indexOf("=");var e=h.slice(0,g);var s=h.slice(g+1);g=e.indexOf(".");var a=e.slice(0,g);var d=this.elementsByName[JXG.unescapeHTML(a)];var q=e.slice(g+1).replace(/\s+/g,"").toLowerCase();s=this.algebra.geonext2JS(s);s=s.replace(/this\.board\./g,"this.");if(typeof this.elementsByName[a]=="undefined"){alert("debug conditions: |"+a+"| undefined")}b+='el = this.objects["'+d.id+'"];\n';switch(q){case"x":b+="y=el.coords.usrCoords[2];\n";b+="el.setPositionDirectly(JXG.COORDS_BY_USER,"+(s)+",y);\n";b+="el.update();\n";break;case"y":b+="x=el.coords.usrCoords[1];\n";b+="el.coords=new JXG.Coords(JXG.COORDS_BY_USER,[x,"+(s)+"],this);\n";break;case"visible":b+="c="+(s)+";\n";b+="if (c) {el.showElement();} else {el.hideElement();}\n";break;case"position":b+="el.position = "+(s)+";\n";b+="el.update();\n";break;case"stroke":b+="el.strokeColor = "+(s)+";\n";break;case"strokewidth":b+="el.strokeWidth = "+(s)+";\n";break;case"label":break;default:alert("property '"+q+"' in conditions not implemented:"+s);break}p=p.slice(k+7);l=p.indexOf("<data>");k=p.indexOf("</data>")}b+="this.prepareUpdate();\n";b+="this.updateElements();\n";b+="return true;\n";this.updateConditions=new Function(b);this.updateConditions()};JXG.Board.prototype.updateConditions=function(){return false};JXG.Board.prototype.addImage=function(d){var b=this.numObjects;this.numObjects++;var a=d.id;if((a=="")||(a==null)){a=this.id+"Im"+b}this.objects[a]=d;this.elementsByName[d.name]=d;d.id=a;this.renderer.drawImage(d);if(!d.visProp.visible){this.renderer.hide(d)}return a};JXG.Board.prototype.addIntegral=function(g,k,a,s,q){var b={},e=0,m=0,u,w,h,l,o,z,d;if(!JXG.isArray(a)||(a.length!=5)){a=["","","","",""]}if(!JXG.isArray(s)||(s.length!=5)){s=["","","","",""]}if((typeof q!="undefined")&&(q!=null)){b=q}b.name=s[0];b.id=a[0];if(g[0]>k.points[0].usrCoords[1]){e=g[0]}else{e=k.points[0].usrCoords[1]}if(g[1]<k.points[k.points.length-1].usrCoords[1]){m=g[1]}else{m=k.points[k.points.length-1].usrCoords[1]}u=this.createElement("glider",[e,k.yterm(e),k],b);b.name=s[1];b.id=a[1];b.visible=false;w=this.createElement("point",[function(){return u.X()},0],b);u.addChild(w);b.name=s[2];b.id=a[2];b.visible=true;h=this.createElement("glider",[m,k.yterm(m),k],b);b.name=s[3];b.id=a[3];b.visible=false;l=this.createElement("point",[function(){return h.X()},0],b);h.addChild(l);o=JXG.Math.Numerics.I([e,m],k.yterm);z=this.createElement("text",[function(){return h.X()+0.2},function(){return h.Y()-0.8},function(){var p=JXG.Math.Numerics.I([w.X(),l.X()],k.yterm);return"&int; = "+(p).toFixed(4)}],{labelColor:q.labelColor});b={};if((typeof q!="undefined")&&(q!=null)){b=q}b.name=s[4];b.id=a[4];b.visible=true;b.fillColor=b.fillColor||this.options.polygon.fillColor;b.highlightFillColor=b.highlightFillColor||this.options.polygon.highlightFillColor;b.fillOpacity=b.fillOpacity||this.options.polygon.fillOpacity;b.highlightFillOpacity=b.highlightFillOpacity||this.options.polygon.highlightFillOpacity;b.strokeWidth=0;b.strokeOpacity=0;d=this.createElement("curve",[[0],[0]],b);d.updateDataArray=function(){var p=[w.coords.usrCoords[1],u.coords.usrCoords[1]],B=[w.coords.usrCoords[2],u.coords.usrCoords[2]],A;for(A=0;A<k.numberPoints;A++){if((w.X()<=k.points[A].usrCoords[1])&&(k.points[A].usrCoords[1]<=l.X())){p.push(k.points[A].usrCoords[1]);B.push(k.points[A].usrCoords[2])}}p.push(h.coords.usrCoords[1]);B.push(h.coords.usrCoords[2]);p.push(l.coords.usrCoords[1]);B.push(l.coords.usrCoords[2]);p.push(w.coords.usrCoords[1]);B.push(w.coords.usrCoords[2]);this.dataX=p;this.dataY=B};u.addChild(d);h.addChild(d);u.addChild(z);h.addChild(z);return d};JXG.Board.prototype.calculateSnapSizes=function(){var d=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this),b=new JXG.Coords(JXG.COORDS_BY_USER,[1/this.gridX,1/this.gridY],this),a=d.scrCoords[1]-b.scrCoords[1],e=d.scrCoords[2]-b.scrCoords[2];this.snapSizeX=this.gridX;while(Math.abs(a)>25){this.snapSizeX*=2;a/=2}this.snapSizeY=this.gridY;while(Math.abs(e)>25){this.snapSizeY*=2;e/=2}return this};JXG.Board.prototype.applyZoom=function(){var a;for(a in this.objects){if((this.objects[a].elementClass==JXG.OBJECT_CLASS_POINT)||(this.objects[a].type==JXG.OBJECT_TYPE_CURVE)||(this.objects[a].type==JXG.OBJECT_TYPE_AXIS)||(this.objects[a].type==JXG.OBJECT_TYPE_TEXT)){if((this.objects[a].type!=JXG.OBJECT_TYPE_CURVE)&&(this.objects[a].type!=JXG.OBJECT_TYPE_AXIS)){this.objects[a].coords.usr2screen()}}}this.calculateSnapSizes();this.clearTraces();this.fullUpdate();if(this.hasGrid){this.renderer.removeGrid(this);this.renderer.drawGrid(this)}return this};JXG.Board.prototype.zoomIn=function(){this.zoomX*=this.options.zoom.factor;this.zoomY*=this.options.zoom.factor;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.zoomOut=function(){this.zoomX/=this.options.zoom.factor;this.zoomY/=this.options.zoom.factor;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.zoom100=function(){this.zoomX=1;this.zoomY=1;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.zoomAllPoints=function(){var p,l,e,k,b,h,m,w,u,s,q,o,g,d,a,z;p=this.zoomX/this.zoomY;l=0;e=0;k=0;b=0;for(h in this.objects){if((this.objects[h].elementClass==JXG.OBJECT_CLASS_POINT)&&this.objects[h].visProp.visible){if(this.objects[h].coords.usrCoords[1]<l){l=this.objects[h].coords.usrCoords[1]}else{if(this.objects[h].coords.usrCoords[1]>e){e=this.objects[h].coords.usrCoords[1]}}if(this.objects[h].coords.usrCoords[2]>b){b=this.objects[h].coords.usrCoords[2]}else{if(this.objects[h].coords.usrCoords[2]<k){k=this.objects[h].coords.usrCoords[2]}}}}m=50;w=m/(this.unitX*this.zoomX);u=m/(this.unitY*this.zoomY);s=e-l+2*w;q=b-k+2*u;o=Math.min(this.canvasWidth/(this.unitX*s),this.canvasHeight/(this.unitY*q));d=o;g=o*p;a=-(l-w)*this.unitX*g;z=(b+u)*this.unitY*d;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[a,z],this);this.zoomX=g;this.zoomY=d;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.removeObject=function(a){var d,b;if(JXG.isArray(a)){for(b=0;b<a.length;b++){this.removeObject(a[b])}}a=JXG.getReference(this,a);if(a==undefined){return this}try{for(d in a.childElements){a.childElements[d].board.removeObject(a.childElements[d])}for(d in this.objects){if(typeof this.objects[d].childElements!="undefined"){delete (this.objects[d].childElements[a.id])}}delete (this.objects[a.id]);delete (this.elementsByName[a.name]);if(a.remove!=undefined){a.remove()}}catch(g){}return this};JXG.Board.prototype.initGeonextBoard=function(){var g,e,d,b,a;g=new JXG.Point(this,[0,0],this.id+"gOOe0","Ursprung",false);g.fixed=true;e=new JXG.Point(this,[1,0],this.id+"gXOe0","Punkt_1_0",false);e.fixed=true;d=new JXG.Point(this,[0,1],this.id+"gYOe0","Punkt_0_1",false);d.fixed=true;b=new JXG.Line(this,this.id+"gOOe0",this.id+"gXOe0",this.id+"gXLe0","X-Achse");b.hideElement();a=new JXG.Line(this,this.id+"gOOe0",this.id+"gYOe0",this.id+"gYLe0","Y-Achse");a.hideElement();return this};JXG.Board.prototype.initInfobox=function(){this.infobox=new JXG.Text(this,"0,0","",[0,0],this.id+"__infobox",null,null,false);this.infobox.distanceX=-20;this.infobox.distanceY=25;this.renderer.hide(this.infobox);return this};JXG.Board.prototype.resizeContainer=function(a,b){this.canvasWidth=1*a;this.canvasHeight=1*b;this.containerObj.style.width=(this.canvasWidth)+"px";this.containerObj.style.height=(this.canvasHeight)+"px";return this};JXG.Board.prototype.showDependencies=function(){var d,b,g,e,a;b="<p>\n";for(d in this.objects){a=0;for(g in this.objects[d].childElements){a++}if(a>=0){b+="<b>"+this.objects[d].id+":</b> "}for(g in this.objects[d].childElements){b+=this.objects[d].childElements[g].id+"("+this.objects[d].childElements[g].name+"), "}b+="<p>\n"}b+="</p>\n";e=window.open();e.document.open();e.document.write(b);e.document.close();return this};JXG.Board.prototype.showXML=function(){var a=window.open("");a.document.open();a.document.write("<pre>"+JXG.escapeHTML(this.xmlString)+"</pre>");a.document.close();return this};JXG.Board.prototype.prepareUpdate=function(b){var a;for(a in this.objects){this.objects[a].needsUpdate=true}return this};JXG.Board.prototype.updateElements=function(b){var a,e,d=true;b=JXG.getReference(this,b);if(b==null){d=false}for(a in this.objects){e=this.objects[a];if(b!=null&&e.id!=b.id){d=false}if(!(d||this.needsFullUpdate||e.needsRegularUpdate)){continue}if(b==null||e.id!=b.id){e.update(true)}else{e.update(false)}}return this};JXG.Board.prototype.updateRenderer=function(b){var a,d;b=JXG.getReference(this,b);for(a in this.objects){d=this.objects[a];if(!this.needsFullUpdate&&!d.needsRegularUpdate){continue}if(b==null||d.id!=b.id){d.updateRenderer()}else{d.updateRenderer()}}return this};JXG.Board.prototype.addHook=function(a){this.hooks.push(a);a(this);return(this.hooks.length-1)};JXG.Board.prototype.removeHook=function(a){this.hooks[a]=null;return this};JXG.Board.prototype.updateHooks=function(){var a;for(a=0;a<this.hooks.length;a++){if(this.hooks[a]!=null){this.hooks[a](this)}}return this};JXG.Board.prototype.addChild=function(a){this.dependentBoards.push(a);this.update();return this};JXG.Board.prototype.removeChild=function(b){var a;for(a=this.dependentBoards.length-1;a>=0;a--){if(this.dependentBoards[a]==b){this.dependentBoards.splice(a,1)}}return this};JXG.Board.prototype.update=function(d){var b,a,e;if(this.isSuspendedUpdate){return this}this.prepareUpdate(d).updateElements(d).updateConditions();this.renderer.suspendRedraw();this.updateRenderer(d);this.renderer.unsuspendRedraw();this.updateHooks();a=this.dependentBoards.length;for(b=0;b<a;b++){e=this.dependentBoards[b].id;if(JXG.JSXGraph.boards[e]!=this){JXG.JSXGraph.boards[e].updateQuality=this.updateQuality;JXG.JSXGraph.boards[e].prepareUpdate(d).updateElements(d).updateConditions();JXG.JSXGraph.boards[e].renderer.suspendRedraw();JXG.JSXGraph.boards[e].updateRenderer(d);JXG.JSXGraph.boards[e].renderer.unsuspendRedraw();JXG.JSXGraph.boards[e].updateHooks()}}return this};JXG.Board.prototype.fullUpdate=function(){this.needsFullUpdate=true;this.update();this.needsFullUpdate=false;return this};JXG.Board.prototype.createElement=function(b,d,a){var h,e,g;if(b!="turtle"&&(d==null||d.length==0)){return null}if(d==null){d=[]}b=b.toLowerCase();if(a==null){a={}}for(e=0;e<d.length;e++){d[e]=JXG.getReference(this,d[e])}if(JXG.JSXGraph.elements[b]!=null){h=JXG.JSXGraph.elements[b](this,d,a)}else{throw"JXG.createElement: Unknown element type given: "+b}if(h==undefined){return}if(JXG.isArray(a)){a=a[0]}if(h.multipleElements){for(g in h){if(typeof h[g].setProperty!="undefined"){h[g].setProperty(a)}}}else{if(typeof h.setProperty!="undefined"){h.setProperty(a)}}this.update(h);return h};JXG.Board.prototype.create=JXG.Board.prototype.createElement;JXG.Board.prototype.clearTraces=function(){var a;for(a in this.objects){if(this.objects[a].traced){this.objects[a].clearTrace()}}return this};JXG.Board.prototype.beforeLoad=function(){};JXG.Board.prototype.afterLoad=function(){};JXG.Board.prototype.suspendUpdate=function(){this.isSuspendedUpdate=true};JXG.Board.prototype.unsuspendUpdate=function(){this.isSuspendedUpdate=false;this.update()};JXG.Board.prototype.setBoundingBox=function(e,b){if(!JXG.isArray(e)){return}var d,a;a=this.canvasWidth;d=this.canvasHeight;if(b){this.unitX=a/(e[2]-e[0]);this.unitY=d/(-e[3]+e[1]);if(this.unitX>this.unitY){this.unitY=this.unitX}else{this.unitX=this.unitY}}else{this.unitX=a/(e[2]-e[0]);this.unitY=d/(-e[3]+e[1])}this.originX=-this.unitX*e[0];this.originY=this.unitY*e[1];this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.moveOrigin();return this};JXG.Board.prototype.animate=function(){var b=0,a,e,d;for(a in this.animationObjects){if(this.animationObjects[a]==null){continue}b++;e=this.animationObjects[a];d=e.animationPath.pop();if(typeof d=="undefined"){this.animationObjects[a]=null;delete (this.animationObjects[a]);delete (e.animationPath)}else{e.setPositionByTransform(JXG.COORDS_BY_USER,d[0]-e.coords.usrCoords[1],d[1]-e.coords.usrCoords[2])}}if(b==0){window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode)}else{this.update()}};JXG.JSXGraph=new function(g){var h,b,e,a;this.licenseText="JSXGraph v0.77 Copyright (C) see http://jsxgraph.org";this.rendererType="";this.boards={};this.elements={};if((g=="undefined")||(g==null)||(g=="")){h=navigator.appVersion.match(/MSIE (\d\.\d)/);b=(navigator.userAgent.toLowerCase().indexOf("opera")!=-1);if((!h)||(b)){this.rendererType="svg"}else{this.rendererType="vml";function d(k){document.body.scrollLeft;document.body.scrollTop}document.onmousemove=d}}else{this.rendererType=g}a=JXG.rendererFiles[this.rendererType].split(",");for(e=0;e<a.length;e++){(function(k){JXG.require(JXG.requirePath+k+".js")})(a[e])}this.initBoard=function(o,l){var u,H,G,B,z,D,m,k,F,E,C,A,s,p,q;k=JXG.getDimensions(o);if(typeof l=="undefined"){l={}}if(typeof l.boundingbox!="undefined"){F=l.boundingbox;D=parseInt(k.width);m=parseInt(k.height);if(l.keepaspectratio){B=D/(F[2]-F[0]);z=m/(-F[3]+F[1]);if(B>z){z=B}else{B=z}}else{B=D/(F[2]-F[0]);z=m/(-F[3]+F[1])}H=-B*F[0];G=z*F[1]}else{H=((typeof l.originX)=="undefined"?150:l.originX);G=((typeof l.originY)=="undefined"?150:l.originY);B=((typeof l.unitX)=="undefined"?50:l.unitX);z=((typeof l.unitY)=="undefined"?50:l.unitY)}E=((typeof l.zoom)=="undefined"?1:l.zoom);C=E*((typeof l.zoomX)=="undefined"?1:l.zoomX);A=E*((typeof l.zoomY)=="undefined"?1:l.zoomY);if(typeof l.showcopyright!="undefined"){l.showCopyright=l.showcopyright}s=((typeof l.showCopyright)=="undefined"?true:l.showCopyright);if(this.rendererType=="svg"){u=new JXG.SVGRenderer(document.getElementById(o))}else{if(this.rendererType=="vml"){u=new JXG.VMLRenderer(document.getElementById(o))}else{u=new JXG.SilverlightRenderer(document.getElementById(o),k.width,k.height)}}q=new JXG.Board(o,u,"",[H,G],1,1,B,z,k.width,k.height,s);this.boards[q.id]=q;q.initInfobox();if((typeof l.axis!="undefined")&&l.axis){q.defaultAxes={};q.defaultAxes.x=q.createElement("axis",[[0,0],[1,0]],{});q.defaultAxes.y=q.createElement("axis",[[0,0],[0,1]],{})}if((typeof l.grid!="undefined")&&l.grid){q.renderer.drawGrid(q)}if(typeof l.shownavigation!="undefined"){l.showNavigation=l.shownavigation}p=((typeof l.showNavigation)=="undefined"?q.options.showNavigation:l.showNavigation);if(p){q.renderer.drawZoomBar(q)}return q};this.loadBoardFromFile=function(o,k,q){var p,l,m;if(this.rendererType=="svg"){p=new JXG.SVGRenderer(document.getElementById(o))}else{p=new JXG.VMLRenderer(document.getElementById(o))}m=JXG.getDimensions(o);l=new JXG.Board(o,p,"",[150,150],1,1,50,50,m.width,m.height);l.initInfobox();l.beforeLoad();JXG.FileReader.parseFileContent(k,l,q);if(l.options.showNavigation){l.renderer.drawZoomBar(l)}this.boards[l.id]=l;return l};this.loadBoardFromString=function(o,k,q){var p,m,l;if(this.rendererType=="svg"){p=new JXG.SVGRenderer(document.getElementById(o))}else{p=new JXG.VMLRenderer(document.getElementById(o))}m=JXG.getDimensions(o);l=new JXG.Board(o,p,"",[150,150],1,1,50,50,m.width,m.height);l.initInfobox();l.beforeLoad();JXG.FileReader.parseString(k,l,q);if(l.options.showNavigation){l.renderer.drawZoomBar(l)}this.boards[l.id]=l;return l};this.freeBoard=function(l){var k;if(typeof(l)=="string"){l=this.boards[l]}JXG.removeEvent(document,"mousedown",l.mouseDownListener,l);JXG.removeEvent(document,"mouseup",l.mouseUpListener,l);JXG.removeEvent(l.containerObj,"mousemove",l.mouseMoveListener,l);for(k in l.objects){l.removeObject(l.objects[k])}l.containerObj.innerHTML="";for(k in l.objects){delete (l.objects[k])}delete (l.renderer);delete (l.algebra);delete (this.boards[l.id])};this.registerElement=function(k,l){k=k.toLowerCase();this.elements[k]=l;if(JXG.Board.prototype["_"+k]){throw"Can't create wrapper method in JXG.Board because member '_"+k+"' already exists'"}JXG.Board.prototype["_"+k]=function(o,m){return this.createElement(k,o,m)}};this.unregisterElement=function(k){delete (this.elements[k.toLowerCase()]);delete (JXG.Board.prototype["_"+k.toLowerCase()])}};JXG.getReference=function(b,a){if(typeof(a)=="string"){if(b.objects[a]!=null){a=b.objects[a]}else{if(b.elementsByName[a]!=null){a=b.elementsByName[a]}}}return a};JXG.isString=function(a){return typeof a=="string"};JXG.isNumber=function(a){return typeof a=="number"};JXG.isFunction=function(a){return typeof a=="function"};JXG.isArray=function(a){return a!=null&&typeof a=="object"&&"splice" in a&&"join" in a};JXG.isPoint=function(a){if(typeof a=="object"){return(a.elementClass==JXG.OBJECT_CLASS_POINT)}return false};JXG._board=function(b,a){return JXG.JSXGraph.initBoard(b,a)};JXG.createEvalFunction=function(b,g,h){var d=[],a,e;for(a=0;a<h;a++){if(typeof g[a]=="string"){e=b.algebra.geonext2JS(g[a]);e=e.replace(/this\.board\./g,"board.");d[a]=new Function("","return "+(e)+";")}}return function(m){var l=g[m];if(typeof l=="string"){return d[m]()}else{if(typeof l=="function"){return l()}else{if(typeof l=="number"){return l}}}return 0}};JXG.createFunction=function(b,d,e,g){var a;if((g==null||g==true)&&JXG.isString(b)){a=d.algebra.geonext2JS(b);return new Function(e,"return "+a+";")}else{if(JXG.isFunction(b)){return b}else{if(JXG.isNumber(b)){return function(){return b}}else{if(JXG.isString(b)){return function(){return b}}}}}return null};JXG.getDimensions=function(h){var g,l,d,m,k,b,a,e;g=document.getElementById(h);if(g==null){throw ("\nJSXGraph error: HTML container element '"+(h)+"' not found.")}l=g.style.display;if(l!="none"&&l!=null){return{width:g.offsetWidth,height:g.offsetHeight}}d=g.style;m=d.visibility;k=d.position;b=d.display;d.visibility="hidden";d.position="absolute";d.display="block";a=g.clientWidth;e=g.clientHeight;d.display=b;d.position=k;d.visibility=m;return{width:a,height:e}};JXG.addEvent=function(e,d,b,a){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){a["x_internal"+d]=b.bindAsEventListener(a);Event.observe(e,d,a["x_internal"+d])}else{a["x_internal"+d]=function(){return b.apply(a,arguments)};$(e).bind(d,a["x_internal"+d])}};JXG.bind=function(b,a){return function(){return b.apply(a,arguments)}};JXG.removeEvent=function(e,d,b,a){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){Event.stopObserving(e,d,a["x_internal"+d])}else{$(e).unbind(d,a["x_internal"+d])}};JXG.getPosition=function(b){var a=0,d=0,b;if(!b){b=window.event}if(b.pageX||b.pageY){a=b.pageX;d=b.pageY}else{if(b.clientX||b.clientY){a=b.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;d=b.clientY+document.body.scrollTop+document.documentElement.scrollTop}}return[a,d]};JXG.getOffset=function(a){var b;if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){return Element.cumulativeOffset(a)}else{b=$(a).offset();return[b.left,b.top]}};JXG.getStyle=function(b,a){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){return $(b).getStyle(a)}else{if(typeof $(b).attr(a)!="undefined"){return $(b).attr(a)}else{return $(b).css(a)}}};JXG.keys=function(a){var b=[],d;for(d in a){b.push(d)}return b};JXG.escapeHTML=function(a){return a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")};JXG.unescapeHTML=function(a){return a.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")};JXG.toJSON=function(d){switch(typeof d){case"object":if(d){var b=[];if(d instanceof Array){for(var a=0;a<d.length;a++){b.push(JXG.toJSON(d[a]))}return"["+b.join(",")+"]"}else{for(var e in d){b.push('"'+e+'":'+JXG.toJSON(d[e]))}return"{"+b.join(",")+"}"}}else{return"null"}case"string":return'"'+d.replace(/(["'])/g,"\\$1")+'"';case"number":case"boolean":return new String(d)}};JXG.capitalize=function(a){return a.charAt(0).toUpperCase()+a.substring(1).toLowerCase()};JXG.isSilverlightInstalled=function(){var d=false,a,h,b;try{a=null;h=false;if(window.ActiveXObject){try{a=new ActiveXObject("AgControl.AgControl");d=true;a=null}catch(g){h=true}}else{h=true}if(h){b=navigator.plugins["Silverlight Plug-In"];if(b){d=true}}}catch(g){d=false}return d};JXG.OBJECT_TYPE_ARC=1330921795;JXG.OBJECT_TYPE_ARROW=1330921815;JXG.OBJECT_TYPE_AXIS=1330921816;JXG.OBJECT_TYPE_TICKS=1330926680;JXG.OBJECT_TYPE_CIRCLE=1330922316;JXG.OBJECT_TYPE_CURVE=1330923344;JXG.OBJECT_TYPE_GLIDER=1330923340;JXG.OBJECT_TYPE_IMAGE=1330926157;JXG.OBJECT_TYPE_LINE=1330924622;JXG.OBJECT_TYPE_POINT=1330925652;JXG.OBJECT_TYPE_SLIDER=1330926404;JXG.OBJECT_TYPE_CAS=1330922320;JXG.OBJECT_TYPE_POLYGON=1330925657;JXG.OBJECT_TYPE_SECTOR=1330926403;JXG.OBJECT_TYPE_TEXT=1330926661;JXG.OBJECT_TYPE_ANGLE=1330921799;JXG.OBJECT_TYPE_INTERSECTION=1330926158;JXG.OBJECT_TYPE_TURTLE=5198933;JXG.OBJECT_CLASS_POINT=1;JXG.OBJECT_CLASS_LINE=2;JXG.OBJECT_CLASS_CIRCLE=3;JXG.OBJECT_CLASS_CURVE=4;JXG.OBJECT_CLASS_AREA=5;JXG.OBJECT_CLASS_OTHER=6;JXG.GeometryElement=function(){this.board=null;this.id="";this.needsUpdate=true;this.name="";this.visProp={};this.isReal=true;this.visProp.dash=0;this.childElements={};this.hasLabel=false;this.notExistingParents={};this.traced=false;this.traces={};this.numTraces=0;this.transformations=[];this.baseElement=null;this.descendants={};this.ancestors={};this.symbolic={};this.stdform=[1,0,0,0,1,1,0,0];this.quadraticform=[[1,0,0],[0,1,0],[0,0,1]];this.needsRegularUpdate=true};JXG.GeometryElement.prototype.init=function(b,d,a){if(typeof(b)=="string"){b=JXG.JSXGraph.boards[b]}this.board=b;this.id=d;if((a!=null)&&(typeof a!="undefined")){a=a}else{a=this.board.generateName(this)}this.board.elementsByName[a]=this;this.name=a;this.visProp.strokeColor=this.board.options.elements.color.strokeColor;this.visProp.highlightStrokeColor=this.board.options.elements.color.highlightStrokeColor;this.visProp.fillColor=this.board.options.elements.color.fillColor;this.visProp.highlightFillColor=this.board.options.elements.color.highlightFillColor;this.visProp.strokeWidth=this.board.options.elements.strokeWidth;this.visProp.strokeOpacity=this.board.options.elements.color.strokeOpacity;this.visProp.highlightStrokeOpacity=this.board.options.elements.color.highlightStrokeOpacity;this.visProp.fillOpacity=this.board.options.elements.color.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.elements.color.highlightFillOpacity;this.visProp.draft=this.board.options.elements.draft.draft;this.visProp.visible=true;this.visProp.shadow=false;this.visProp.gradient="none";this.visProp.gradientSecondColor="black";this.visProp.gradientAngle="270";this.visProp.gradientSecondOpacity=this.visProp.fillOpacity;this.visProp.gradientPositionX=0.5;this.visProp.gradientPositionY=0.5};JXG.GeometryElement.prototype.addChild=function(d){var b,a;this.childElements[d.id]=d;this.addDescendants(d);d.ancestors[this.id]=this;for(b in this.descendants){this.descendants[b].ancestors[this.id]=this;for(a in this.ancestors){this.descendants[b].ancestors[this.ancestors[a].id]=this.ancestors[a]}}for(b in this.ancestors){for(a in this.descendants){this.ancestors[b].descendants[this.descendants[a].id]=this.descendants[a]}}return this};JXG.GeometryElement.prototype.addDescendants=function(b){var a;this.descendants[b.id]=b;for(a in b.childElements){this.addDescendants(b.childElements[a])}return this};JXG.GeometryElement.prototype.generatePolynomial=function(){return[]};JXG.GeometryElement.prototype.update=function(){if(this.traced){this.cloneToBackground(true)}return this};JXG.GeometryElement.prototype.updateRenderer=function(){};JXG.GeometryElement.prototype.hideElement=function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.label!=null&&this.hasLabel){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}return this};JXG.GeometryElement.prototype.showElement=function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.label!=null&&this.hasLabel&&this.label.hiddenByParent){this.label.hiddenByParent=false;if(this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}return this};JXG.GeometryElement.prototype.setProperty=function(){var h,g,d,b,e,k;for(h=0;h<arguments.length;h++){b=arguments[h];if(typeof b=="string"){k=b.split(":")}else{if(!JXG.isArray(b)){for(g in b){this.setProperty([g,b[g]])}return this}else{k=b}}switch(k[0].replace(/\s+/g).toLowerCase()){case"strokewidth":this.visProp.strokeWidth=k[1];this.board.renderer.setObjectStrokeWidth(this,this.visProp.strokeWidth);break;case"strokecolor":d=k[1];if(d.length=="9"&&d.substr(0,1)=="#"){e=d.substr(7,2);d=d.substr(0,7)}else{e="FF"}this.visProp.strokeColor=d;this.visProp.strokeOpacity=parseInt(e.toUpperCase(),16)/255;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,this.visProp.strokeOpacity);break;case"fillcolor":d=k[1];if(d.length=="9"&&d.substr(0,1)=="#"){e=d.substr(7,2);d=d.substr(0,7)}else{e="FF"}this.visProp.fillColor=d;this.visProp.fillOpacity=parseInt(e.toUpperCase(),16)/255;this.board.renderer.setObjectFillColor(this,this.visProp.fillColor,this.visProp.fillOpacity);break;case"highlightstrokecolor":d=k[1];if(d.length=="9"&&d.substr(0,1)=="#"){e=d.substr(7,2);d=d.substr(0,7)}else{e="FF"}this.visProp.highlightStrokeColor=d;this.visProp.highlightStrokeOpacity=parseInt(e.toUpperCase(),16)/255;break;case"highlightfillcolor":d=k[1];if(d.length=="9"&&d.substr(0,1)=="#"){e=d.substr(7,2);d=d.substr(0,7)}else{e="FF"}this.visProp.highlightFillColor=d;this.visProp.highlightFillOpacity=parseInt(e.toUpperCase(),16)/255;break;case"fillopacity":this.visProp.fillOpacity=k[1];this.board.renderer.setObjectFillColor(this,this.visProp.fillColor,this.visProp.fillOpacity);break;case"strokeopacity":this.visProp.strokeOpacity=k[1];this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,this.visProp.strokeOpacity);break;case"highlightfillopacity":this.visProp.highlightFillOpacity=k[1];break;case"highlightstrokeopacity":this.visProp.highlightStrokeOpacity=k[1];break;case"labelcolor":d=k[1];if(d.length=="9"&&d.substr(0,1)=="#"){e=d.substr(7,2);d=d.substr(0,7)}else{e="FF"}if(e=="00"){if(this.label!=null&&this.hasLabel){this.label.content.hideElement()}}if(this.label!=null&&this.hasLabel){this.label.color=d;this.board.renderer.setObjectStrokeColor(this.label.content,d,e)}if(this.type==JXG.OBJECT_TYPE_TEXT){this.visProp.strokeColor=d;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,1)}break;case"showinfobox":if(k[1]=="false"||k[1]==false){this.showInfobox=false}else{if(k[1]=="true"||k[1]==true){this.showInfobox=true}}break;case"visible":if(k[1]=="false"||k[1]==false){this.visProp.visible=false;this.hideElement()}else{if(k[1]=="true"||k[1]==true){this.visProp.visible=true;this.showElement()}}break;case"dash":this.setDash(k[1]);break;case"trace":if(k[1]=="false"||k[1]==false){this.traced=false}else{if(k[1]=="true"||k[1]==true){this.traced=true}}break;case"style":this.setStyle(1*k[1]);break;case"face":if(this.elementClass==JXG.OBJECT_CLASS_POINT){this.setFace(k[1])}break;case"size":if(this.elementClass==JXG.OBJECT_CLASS_POINT){this.visProp.size=1*k[1];this.board.renderer.updatePoint(this)}break;case"fixed":this.fixed=(k[1]=="false")?false:true;break;case"shadow":if(k[1]=="false"||k[1]==false){this.visProp.shadow=false}else{if(k[1]=="true"||k[1]==true){this.visProp.shadow=true}}this.board.renderer.setShadow(this);break;case"gradient":this.visProp.gradient=k[1];this.board.renderer.setGradient(this);break;case"gradientsecondcolor":d=k[1];if(d.length=="9"&&d.substr(0,1)=="#"){e=d.substr(7,2);d=d.substr(0,7)}else{e="FF"}this.visProp.gradientSecondColor=d;this.visProp.gradientSecondOpacity=parseInt(e.toUpperCase(),16)/255;this.board.renderer.updateGradient(this);break;case"gradientsecondopacity":this.visProp.gradientSecondOpacity=k[1];this.board.renderer.updateGradient(this);break;case"draft":if(k[1]=="false"||k[1]==false){if(this.visProp.draft==true){this.visProp.draft=false;this.board.renderer.removeDraft(this)}}else{if(k[1]=="true"||k[1]==true){this.visProp.draft=true;this.board.renderer.setDraft(this)}}break;case"straightfirst":if(k[1]=="false"||k[1]==false){this.visProp.straightFirst=false}else{if(k[1]=="true"||k[1]==true){this.visProp.straightFirst=true}}this.setStraight(this.visProp.straightFirst,this.visProp.straightLast);break;case"straightlast":if(k[1]=="false"||k[1]==false){this.visProp.straightLast=false}else{if(k[1]=="true"||k[1]==true){this.visProp.straightLast=true}}this.setStraight(this.visProp.straightFirst,this.visProp.straightLast);break;case"firstarrow":if(k[1]=="false"||k[1]==false){this.visProp.firstArrow=false}else{if(k[1]=="true"||k[1]==true){this.visProp.firstArrow=true}}this.setArrow(this.visProp.firstArrow,this.visProp.lastArrow);break;case"lastarrow":if(k[1]=="false"||k[1]==false){this.visProp.lastArrow=false}else{if(k[1]=="true"||k[1]==true){this.visProp.lastArrow=true}}this.setArrow(this.visProp.firstArrow,this.visProp.lastArrow);break;case"curvetype":this.curveType=k[1];break;case"fontsize":this.visProp.fontSize=k[1];break;case"insertticks":if(this.type==JXG.OBJECT_TYPE_TICKS){var a=this.insertTicks;this.insertTicks=true;if(k[1]=="false"||k[1]==false){this.insertTicks=false}if(a!=this.insertTicks){this.calculateTicksCoordinates()}}break;case"drawlabels":if(this.type==JXG.OBJECT_TYPE_TICKS){var a=this.drawLabels;this.drawLabels=true;if(k[1]=="false"||k[1]==false){this.drawLabels=false}if(a!=this.drawLabels){this.calculateTicksCoordinates()}}break;case"drawzero":if(this.type==JXG.OBJECT_TYPE_TICKS){var a=this.drawZero;this.drawZero=true;if(k[1]=="false"||k[1]==false){this.drawZero=false}if(a!=this.drawZero){this.calculateTicksCoordinates()}}break;case"minorticks":if(this.type==JXG.OBJECT_TYPE_TICKS){var a=this.minorTicks;if((k[1]!=null)&&(k[1]>0)){this.minorTicks=k[1]}if(a!=this.minorTicks){this.calculateTicksCoordinates()}}break;case"majortickheight":if(this.type==JXG.OBJECT_TYPE_TICKS){var a=this.majorHeight;if((k[1]!=null)&&(k[1]>0)){this.majorHeight=k[1]}if(a!=this.majorHeight){this.calculateTicksCoordinates()}}break;case"minortickheight":if(this.type==JXG.OBJECT_TYPE_TICKS){var a=this.minorHeight;if((k[1]!=null)&&(k[1]>0)){this.minorHeight=k[1]}if(a!=this.minorHeight){this.calculateTicksCoordinates()}}break;case"snapwidth":if(this.type==JXG.OBJECT_TYPE_GLIDER){this.snapWidth=k[1]}}}return this};JXG.GeometryElement.prototype.setDash=function(a){this.visProp.dash=a;this.board.renderer.setDashStyle(this,this.visProp);return this};JXG.GeometryElement.prototype.prepareUpdate=function(){this.needsUpdate=true;return this};JXG.GeometryElement.prototype.remove=function(){this.board.renderer.remove(document.getElementById(this.id));if(this.hasLabel){this.board.renderer.remove(document.getElementById(this.label.content.id))}return this};JXG.GeometryElement.prototype.getTextAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)};JXG.GeometryElement.prototype.getLabelAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)};JXG.GeometryElement.prototype.setStyle=function(a){return this};JXG.GeometryElement.prototype.setStraight=function(a,b){return this};JXG.GeometryElement.prototype.setArrow=function(b,a){return this};JXG.GeometryElement.prototype.createLabel=function(b,d){var a=false;if(typeof d=="undefined"||d==null){d=[10,10]}this.nameHTML=this.board.algebra.replaceSup(this.board.algebra.replaceSub(this.name));this.label={};if(typeof b=="undefined"||b==true){if(this.board.objects[this.id]==null){this.board.objects[this.id]=this;a=true}this.label.relativeCoords=d;this.label.content=new JXG.Text(this.board,this.nameHTML,this.id,[this.label.relativeCoords[0]/(this.board.stretchX),this.label.relativeCoords[1]/(this.board.stretchY)],this.id+"Label","",null,true);if(a){delete (this.board.objects[this.id])}this.label.color="#000000";if(!this.visProp.visible){this.label.hiddenByParent=true;this.label.content.visProp.visible=false}this.hasLabel=true}return this};JXG.GeometryElement.prototype.addLabelToElement=function(){this.createLabel(true);this.label.content.id=this.id+"Label";this.board.addText(this.label.content);this.board.renderer.drawText(this.label.content);if(!this.label.content.visProp.visible){board.renderer.hide(this.label.content)}return this};JXG.GeometryElement.prototype.highlight=function(){this.board.renderer.highlight(this);return this};JXG.GeometryElement.prototype.noHighlight=function(){this.board.renderer.noHighlight(this);return this};JXG.GeometryElement.prototype.clearTrace=function(){var a;for(a in this.traces){this.board.renderer.remove(this.traces[a])}this.numTraces=0;return this};JXG.GeometryElement.prototype.cloneToBackground=function(a){return this};JXG.GeometryElement.prototype.normalize=function(){this.stdform=this.board.algebra.normalize(this.stdform);return this};JXG.GeometryElement.prototype.toJSON=function(){var b='{"name":'+this.name;b+=', "id":'+this.id;var d=[];for(var a in this.visProp){if(this.visProp[a]!=null){d.push('"'+a+'":'+this.visProp[a])}}b+=', "visProp":{'+d.toString()+"}";b+="}";return b};JXG.COORDS_BY_USER=1;JXG.COORDS_BY_SCREEN=2;JXG.Coords=function(d,b,a){this.board=a;this.usrCoords=[1,0,0];this.scrCoords=[1,0,0];if(d==JXG.COORDS_BY_USER){if(b.length<=2){this.usrCoords[1]=b[0];this.usrCoords[2]=b[1]}else{this.usrCoords[0]=b[0];this.usrCoords[1]=b[1];this.usrCoords[2]=b[2];this.normalizeUsrCoords()}this.usr2screen()}else{this.scrCoords[1]=b[0];this.scrCoords[2]=b[1];this.screen2usr()}};JXG.Coords.prototype.normalizeUsrCoords=function(){var a=0.000001;if(Math.abs(this.usrCoords[0])>a){this.usrCoords[1]/=this.usrCoords[0];this.usrCoords[2]/=this.usrCoords[0];this.usrCoords[0]=1}};JXG.Coords.prototype.usr2screen=function(h){var g=Math.round,a=this.board,e=this.usrCoords,d=this.board.origin.scrCoords;if(h==null||h){this.scrCoords[0]=g(e[0]);this.scrCoords[1]=g(e[0]*d[1]+e[1]*a.stretchX);this.scrCoords[2]=g(e[0]*d[2]-e[2]*a.stretchY)}else{this.scrCoords[0]=e[0];this.scrCoords[1]=e[0]*d[1]+e[1]*a.stretchX;this.scrCoords[2]=e[0]*d[2]-e[2]*a.stretchY}};JXG.Coords.prototype.screen2usr=function(){var e=this.board.origin.scrCoords,d=this.scrCoords,a=this.board;this.usrCoords[0]=1;this.usrCoords[1]=(d[1]-e[1])/a.stretchX;this.usrCoords[2]=(e[2]-d[2])/a.stretchY};JXG.Coords.prototype.distance=function(b,e){var d=0,k,a=this.usrCoords,h=this.scrCoords,g;if(b==JXG.COORDS_BY_USER){k=e.usrCoords;g=a[0]-k[0];d=g*g;g=a[1]-k[1];d+=g*g;g=a[2]-k[2];d+=g*g}else{k=e.scrCoords;g=h[0]-k[0];d=g*g;g=h[1]-k[1];d+=g*g;g=h[2]-k[2];d+=g*g}return Math.sqrt(d)};JXG.Coords.prototype.setCoordinates=function(g,d,b){var a=this.usrCoords,e=this.scrCoords;if(g==JXG.COORDS_BY_USER){if(d.length==2){a[0]=1;a[1]=d[0];a[2]=d[1]}else{a[0]=d[0];a[1]=d[1];a[2]=d[2];this.normalizeUsrCoords()}this.usr2screen(b)}else{e[1]=d[0];e[2]=d[1];this.screen2usr()}};JXG.POINT_STYLE_X_SMALL=0;JXG.POINT_STYLE_X=1;JXG.POINT_STYLE_X_BIG=2;JXG.POINT_STYLE_CIRCLE_TINY=3;JXG.POINT_STYLE_CIRCLE_SMALL=4;JXG.POINT_STYLE_CIRCLE=5;JXG.POINT_STYLE_CIRCLE_BIG=6;JXG.POINT_STYLE_SQUARE_SMALL=7;JXG.POINT_STYLE_SQUARE=8;JXG.POINT_STYLE_SQUARE_BIG=9;JXG.POINT_STYLE_PLUS_SMALL=10;JXG.POINT_STYLE_PLUS=11;JXG.POINT_STYLE_PLUS_BIG=12;JXG.Point=function(e,g,h,b,a,d){this.constructor();this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;this.init(e,h,b);if(g==null){g=[0,0]}this.coords=new JXG.Coords(JXG.COORDS_BY_USER,g,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,g,this.board);this.showInfobox=true;this.label={};this.label.relativeCoords=[10,10];this.nameHTML=this.board.algebra.replaceSup(this.board.algebra.replaceSub(this.name));if(typeof d=="undefined"||d==true){this.board.objects[this.id]=this;this.label.content=new JXG.Text(this.board,this.nameHTML,this.id,[this.label.relativeCoords[0]/this.board.stretchX,this.label.relativeCoords[1]/this.board.stretchY],this.id+"Label","",null,true);delete (this.board.objects[this.id]);this.label.color="#000000";if(!a){this.label.hiddenByParent=true;this.label.content.visProp.visible=false}this.hasLabel=true}else{this.showInfobox=false}this.fixed=false;this.position=null;this.onPolygon=false;this.visProp.style=this.board.options.point.style;this.visProp.face="circle";this.visProp.size=3;this.r=this.board.options.precision.hasPoint;this.visProp.fillColor=this.board.options.point.fillColor;this.visProp.highlightFillColor=this.board.options.point.highlightFillColor;this.visProp.strokeColor=this.board.options.point.strokeColor;this.visProp.highlightStrokeColor=this.board.options.point.highlightStrokeColor;this.visProp.visible=a;this.slideObject=null;this.group=[];this.id=this.board.addPoint(this)};JXG.Point.prototype=new JXG.GeometryElement();JXG.Point.prototype.hasPoint=function(b,e){var a=this.coords.scrCoords,d;d=this.visProp.size;if(d<this.r){d=this.r}return((Math.abs(a[1]-b)<d+2)&&(Math.abs(a[2]-e))<d+2)};JXG.Point.prototype.updateConstraint=function(){return this};JXG.Point.prototype.update=function(g){if(!this.needsUpdate){return}if(typeof g=="undefined"){g=false}if(this.traced){this.cloneToBackground(true)}if(this.type==JXG.OBJECT_TYPE_GLIDER){if(this.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){if(g){this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.X()+Math.cos(this.position),this.slideObject.midpoint.Y()+Math.sin(this.position)]);this.coords=this.board.algebra.projectPointToCircle(this,this.slideObject)}else{this.coords=this.board.algebra.projectPointToCircle(this,this.slideObject);this.position=this.board.algebra.rad([this.slideObject.midpoint.X()+1,this.slideObject.midpoint.Y()],this.slideObject.midpoint,this)}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_LINE){this.coords=this.board.algebra.projectPointToLine(this,this.slideObject);var e=this.slideObject.point1.coords;var l=this.slideObject.point2.coords;if(g){if(Math.abs(e.usrCoords[0])>=JXG.Math.eps&&Math.abs(l.usrCoords[0])>=JXG.Math.eps){this.coords.setCoordinates(JXG.COORDS_BY_USER,[e.usrCoords[1]+this.position*(l.usrCoords[1]-e.usrCoords[1]),e.usrCoords[2]+this.position*(l.usrCoords[2]-e.usrCoords[2])])}}else{var m=1;var s=e.distance(JXG.COORDS_BY_USER,this.coords);var b=e.distance(JXG.COORDS_BY_USER,l);var k=l.distance(JXG.COORDS_BY_USER,this.coords);if(((s>b)||(k>b))&&(s<k)){m=-1}this.position=m*s/b;if(this.snapWidth!=null&&Math.abs(this._smax-this._smin)>=JXG.Math.eps){var u=Math.round(this.Value()/this.snapWidth)*this.snapWidth;this.position=m*(u-this._smin)/(this._smax-this._smin);this.update(true)}}var d=this.slideObject.point1.coords.scrCoords;var q=this.slideObject.point2.coords.scrCoords;var h;if(this.slideObject.getSlope()==0){h=1}else{h=2}var o=this.coords.scrCoords[h];if(!this.slideObject.visProp.straightFirst){if(d[h]<q[h]){if(o<d[h]){this.coords=this.slideObject.point1.coords;this.position=0}}else{if(d[h]>q[h]){if(o>d[h]){this.coords=this.slideObject.point1.coords;this.position=0}}}}if(!this.slideObject.visProp.straightLast){if(d[h]<q[h]){if(o>q[h]){this.coords=this.slideObject.point2.coords;this.position=1}}else{if(d[h]>q[h]){if(o<q[h]){this.coords=this.slideObject.point2.coords;this.position=1}}}}if(this.onPolygon){var w=this.slideObject.point1.coords;var p=this.slideObject.point2.coords;if(Math.abs(this.coords.scrCoords[1]-w.scrCoords[1])<this.r&&Math.abs(this.coords.scrCoords[2]-w.scrCoords[2])<this.r){var a=this.slideObject.parentPolygon;for(var h=0;h<a.borders.length;h++){if(this.slideObject==a.borders[h]){this.slideObject=a.borders[(h-1+a.borders.length)%a.borders.length];break}}}else{if(Math.abs(this.coords.scrCoords[1]-p.scrCoords[1])<this.r&&Math.abs(this.coords.scrCoords[2]-p.scrCoords[2])<this.r){var a=this.slideObject.parentPolygon;for(var h=0;h<a.borders.length;h++){if(this.slideObject==a.borders[h]){this.slideObject=a.borders[(h+1+a.borders.length)%a.borders.length];break}}}}}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_CURVE){this.updateConstraint();this.coords=this.board.algebra.projectPointToCurve(this,this.slideObject)}else{if(this.slideObject.type==JXG.OBJECT_TYPE_TURTLE){this.updateConstraint();this.coords=this.board.algebra.projectPointToTurtle(this,this.slideObject)}}}}}if(this.type==JXG.OBJECT_TYPE_CAS){this.updateConstraint()}this.updateTransform();this.needsUpdate=false;return this};JXG.Point.prototype.updateRenderer=function(){if(this.visProp.visible){var a=this.isReal;this.isReal=(isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]))?false:true;this.isReal=(Math.abs(this.coords.usrCoords[0])>this.board.algebra.eps)?this.isReal:false;if(this.isReal){if(a!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updatePoint(this)}else{if(a!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}return this};JXG.Point.prototype.X=function(){return this.coords.usrCoords[1]};JXG.Point.prototype.Y=function(){return this.coords.usrCoords[2]};JXG.Point.prototype.Z=function(){return this.coords.usrCoords[0]};JXG.Point.prototype.XEval=function(){return this.coords.usrCoords[1]};JXG.Point.prototype.YEval=function(){return this.coords.usrCoords[2]};JXG.Point.prototype.ZEval=function(){return this.coords.usrCoords[0]};JXG.Point.prototype.Dist=function(b){var d,g=b.coords.usrCoords,a=this.coords.usrCoords,e;e=a[0]-g[0];d=e*e;e=a[1]-g[1];d+=e*e;e=a[2]-g[2];d+=e*e;return Math.sqrt(d)};JXG.Point.prototype.setPositionDirectly=function(e,a,d){var b=this.coords;this.coords=new JXG.Coords(e,[a,d],this.board);if(this.group.length!=0){this.group[this.group.length-1].dX=this.coords.scrCoords[1]-b.scrCoords[1];this.group[this.group.length-1].dY=this.coords.scrCoords[2]-b.scrCoords[2];this.group[this.group.length-1].update(this)}else{this.update()}return this};JXG.Point.prototype.setPositionByTransform=function(g,a,e){var d=this.coords;var b=this.board.createElement("transform",[a,e],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(b)}else{this.addTransform(this,b)}if(this.group.length!=0){}else{this.update()}return this};JXG.Point.prototype.setPosition=function(d,a,b){this.setPositionByTransform(d,a,b);return this};JXG.Point.prototype.makeGlider=function(a){this.slideObject=JXG.getReference(this.board,a);this.type=JXG.OBJECT_TYPE_GLIDER;this.snapWidth=null;this.slideObject.addChild(this);if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)}}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)}}}this.needsUpdate=true;this.update();return this};JXG.Point.prototype.addConstraint=function(g){this.type=JXG.OBJECT_TYPE_CAS;var h=this.board.elementsByName;var k=[];var a;for(var e=0;e<g.length;e++){var b=g[e];if(typeof b=="string"){var d=this.board.algebra.geonext2JS(b);k[e]=new Function("","return "+d+";")}else{if(typeof b=="function"){k[e]=b}else{if(typeof b=="number"){k[e]=function(l){return function(){return l}}(b)}else{if(typeof b=="object"&&typeof b.Value=="function"){k[e]=(function(l){return function(){return l.Value()}})(b)}}}}}if(g.length==1){this.updateConstraint=function(){this.coords=k[0]()};if(!this.board.isSuspendedUpdate){this.update()}return this}else{if(g.length==2){this.XEval=k[0];this.YEval=k[1];a="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",a)}else{this.ZEval=k[0];this.XEval=k[1];this.YEval=k[2];a="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",a)}}if(!this.board.isSuspendedUpdate){this.update()}return this};JXG.Point.prototype.updateTransform=function(){if(this.transformations.length==0||this.baseElement==null){return}if(this===this.baseElement){var b=this.transformations[0].apply(this.baseElement,"self")}else{var b=this.transformations[0].apply(this.baseElement)}this.coords.setCoordinates(JXG.COORDS_BY_USER,[b[1],b[2]]);for(var a=1;a<this.transformations.length;a++){b=this.transformations[a].apply(this);this.coords.setCoordinates(JXG.COORDS_BY_USER,[b[1],b[2]])}return this};JXG.Point.prototype.addTransform=function(d,a){if(this.transformations.length==0){this.baseElement=d}var e;if(JXG.isArray(a)){e=a}else{e=[a]}for(var b=0;b<e.length;b++){this.transformations.push(e[b])}return this};JXG.Point.prototype.startAnimation=function(a,b){if((this.type==JXG.OBJECT_TYPE_GLIDER)&&(typeof this.intervalCode=="undefined")){this.intervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].objects['"+this.id+"'].animate("+a+", "+b+")",250);if(typeof this.intervalCount=="undefined"){this.intervalCount=0}}return this};JXG.Point.prototype.stopAnimation=function(){if(typeof this.intervalCode!="undefined"){window.clearInterval(this.intervalCode);delete (this.intervalCode)}return this};JXG.Point.prototype.moveTo=function(k,d){var l=35,m=Math.ceil(d/(l*1)),o=new Array(m+1),b=this.coords.usrCoords[1],a=this.coords.usrCoords[2],g=(k[0]-b),e=(k[1]-a),h;for(h=m;h>=0;h--){o[m-h]=[b+g*Math.sin((h/(m*1))*Math.PI/2),a+e*Math.sin((h/(m*1))*Math.PI/2)]}this.animationPath=o;this.board.animationObjects[this.id]=this;if(typeof this.board.animationIntervalCode=="undefined"){this.board.animationIntervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].animate();",l)}return this};JXG.Point.prototype.visit=function(m,e,b){if(arguments.length==2){b=1}var o=35,p=Math.ceil(e/(o*1)),q=new Array(b*(p+1)),d=this.coords.usrCoords[1],a=this.coords.usrCoords[2],k=(m[0]-d),g=(m[1]-a),l,h;for(h=0;h<b;h++){for(l=p;l>=0;l--){q[h*(p+1)+p-l]=[d+k*Math.pow(Math.sin((l/(p*1))*Math.PI),2),a+g*Math.pow(Math.sin((l/(p*1))*Math.PI),2)]}}this.animationPath=q;this.board.animationObjects[this.id]=this;if(typeof this.board.animationIntervalCode=="undefined"){this.board.animationIntervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].animate();",o)}return this};JXG.Point.prototype.animate=function(p,h){this.intervalCount++;if(this.intervalCount>h){this.intervalCount=0}if(this.slideObject.type==JXG.OBJECT_TYPE_LINE){var b=this.slideObject.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.slideObject.point2.coords);var m=this.slideObject.getSlope();var k;var g;if(m!="INF"){var e=Math.atan(m);k=Math.round((this.intervalCount/h)*b*Math.cos(e));g=Math.round((this.intervalCount/h)*b*Math.sin(e))}else{k=0;g=Math.round((this.intervalCount/h)*b)}var d;var o=1;if(p<0){d=this.slideObject.point2;if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]>0){o=-1}else{if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]==0){if(this.slideObject.point2.coords.scrCoords[2]-this.slideObject.point1.coords.scrCoords[2]>0){o=-1}}}}else{d=this.slideObject.point1;if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]>0){o=-1}else{if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]==0){if(this.slideObject.point1.coords.scrCoords[2]-this.slideObject.point2.coords.scrCoords[2]>0){o=-1}}}}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[d.coords.scrCoords[1]+o*k,d.coords.scrCoords[2]+o*g])}else{if(this.slideObject.type==JXG.OBJECT_TYPE_CURVE){var a;if(p>0){a=Math.round(this.intervalCount/h*this.board.canvasWidth)}else{a=Math.round((h-this.intervalCount)/h*this.board.canvasWidth)}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[a,0]);this.coords=this.board.algebra.projectPointToCurve(this,this.slideObject)}else{if(this.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){var e;if(p<0){e=this.intervalCount/h*2*Math.PI}else{e=(h-this.intervalCount)/h*2*Math.PI}var l=this.slideObject.getRadius();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.coords.usrCoords[1]+l*Math.cos(e),this.slideObject.midpoint.coords.usrCoords[2]+l*Math.sin(e)])}}}this.board.update(this);return this};JXG.Point.prototype.setStyle=function(a){if(a==0||a==1||a==2){this.visProp.face="cross";if(a==0){this.visProp.size=2}else{if(a==1){this.visProp.size=3}else{this.visProp.size=4}}}else{if(a==3||a==4||a==5||a==6){this.visProp.face="circle";if(a==3){this.visProp.size=1}else{if(a==4){this.visProp.size=2}else{if(a==5){this.visProp.size=3}else{this.visProp.size=4}}}}else{if(a==7||a==8||a==9){this.visProp.face="square";if(a==7){this.visProp.size=2}else{if(a==8){this.visProp.size=3}else{this.visProp.size=4}}}else{if(a==10||a==11||a==12){this.visProp.face="plus";if(a==10){this.visProp.size=2}else{if(a==11){this.visProp.size=3}else{this.visProp.size=4}}}}}}this.board.renderer.changePointStyle(this);return this};JXG.Point.prototype.setFace=function(a){a=a.toLowerCase();if(a=="cross"||a=="x"||a=="plus"||a=="+"||a=="circle"||a=="o"||a=="square"||a=="[]"){this.visProp.face=a}else{this.visProp.face="circle"}this.board.renderer.changePointStyle(this);return this};JXG.Point.prototype.remove=function(){if(this.hasLabel){this.board.renderer.remove(document.getElementById(this.label.content.id))}this.board.renderer.remove(document.getElementById(this.id))};JXG.Point.prototype.getTextAnchor=function(){return this.coords};JXG.Point.prototype.getLabelAnchor=function(){return this.coords};JXG.Point.prototype.cloneToBackground=function(a){var b={};b.id=this.id+"T"+this.numTraces;this.numTraces++;b.coords=this.coords;b.visProp=this.visProp;b.elementClass=JXG.OBJECT_CLASS_POINT;this.board.renderer.drawPoint(b);this.traces[b.id]=document.getElementById(b.id);delete b;return this};JXG.createPoint=function(g,b,h){var e;if(h==null){h={}}if(typeof h.withLabel=="undefined"){h.withLabel=true}var a=false;for(var d=0;d<b.length;d++){if(typeof b[d]=="function"||typeof b[d]=="string"){a=true}}if(!a){if((JXG.isNumber(b[0]))&&(JXG.isNumber(b[1]))){e=new JXG.Point(g,b,h.id,h.name,(h.visible==undefined)||g.algebra.str2Bool(h.visible),h.withLabel);if(h.slideObject!=null){e.makeGlider(h.slideObject)}else{e.baseElement=e}}else{if((typeof b[0]=="object")&&(typeof b[1]=="object")){e=new JXG.Point(g,[0,0],h.id,h.name,(h.visible==undefined)||g.algebra.str2Bool(h.visible),h.withLabel);e.addTransform(b[0],b[1])}else{throw ("JSXGraph error: Can't create point with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"'.")}}}else{e=new JXG.Point(g,[0,0],h.id,h.name,(h.visible==undefined)||g.algebra.str2Bool(h.visible),h.withLabel);e.addConstraint(b)}return e};JXG.createGlider=function(d,a,e){var b;if(e==null){e={}}if(typeof e.withLabel=="undefined"){e.withLabel=true}if(a.length==1){b=new JXG.Point(d,[0,0],e.id,e.name,(e.visible==undefined)||d.algebra.str2Bool(e.visible),e.withLabel)}else{b=d.createElement("point",a.slice(0,-1),e)}b.makeGlider(a[a.length-1]);return b};JXG.createIntersectionPoint=function(e,b,a){var d;if(b.length>=3){if(b.length==3){b.push(null)}d=e.createElement("point",[e.intersection(b[0],b[1],b[2],b[3])],a)}b[0].addChild(d);b[1].addChild(d);d.generatePolynomial=function(){var g=b[0].generatePolynomial(d);var h=b[1].generatePolynomial(d);if((g.length==0)||(h.length==0)){return[]}else{return[g[0],h[0]]}};return d};JXG.createOtherIntersectionPoint=function(e,b,a){var d;if(b.length!=3||!JXG.isPoint(b[2])||(b[0].elementClass!=JXG.OBJECT_CLASS_LINE&&b[0].elementClass!=JXG.OBJECT_CLASS_CIRCLE)||(b[1].elementClass!=JXG.OBJECT_CLASS_LINE&&b[1].elementClass!=JXG.OBJECT_CLASS_CIRCLE)){throw ("JSXGraph error: Can't create 'other intersection point' with parent types '"+(typeof b[0])+"',  '"+(typeof b[1])+"'and  '"+(typeof b[2])+"'.")}else{d=e.createElement("point",[e.otherIntersection(b[0],b[1],b[2])],a)}b[0].addChild(d);b[1].addChild(d);d.generatePolynomial=function(){var g=b[0].generatePolynomial(d);var h=b[1].generatePolynomial(d);if((g.length==0)||(h.length==0)){return[]}else{return[g[0],h[0]]}};return d};JXG.JSXGraph.registerElement("point",JXG.createPoint);JXG.JSXGraph.registerElement("glider",JXG.createGlider);JXG.JSXGraph.registerElement("intersection",JXG.createIntersectionPoint);JXG.JSXGraph.registerElement("otherintersection",JXG.createOtherIntersectionPoint);JXG.Line=function(d,g,e,h,a,b){this.constructor();this.type=JXG.OBJECT_TYPE_LINE;this.elementClass=JXG.OBJECT_CLASS_LINE;this.init(d,h,a);this.point1=JXG.getReference(this.board,g);this.point2=JXG.getReference(this.board,e);this.image=null;this.imageTransformMatrix=[[1,0,0],[0,1,0],[0,0,1]];this.r=this.board.options.precision.hasPoint;this.visProp.fillColor=this.board.options.line.fillColor;this.visProp.highlightFillColor=this.board.options.line.highlightFillColor;this.visProp.strokeColor=this.board.options.line.strokeColor;this.visProp.highlightStrokeColor=this.board.options.line.highlightStrokeColor;this.visProp.straightFirst=this.board.options.line.straightFirst;this.visProp.straightLast=this.board.options.line.straightLast;this.visProp.visible=true;this.visProp.firstArrow=this.board.options.line.firstArrow;this.visProp.lastArrow=this.board.options.line.lastArrow;this.ticks=[];this.defaultTicks=null;this.parentPolygon=null;this.createLabel(b);this.id=this.board.addLine(this);this.point1.addChild(this);this.point2.addChild(this);this.update()};JXG.Line.prototype=new JXG.GeometryElement;JXG.Line.prototype.hasPoint=function(l,h){var g=[],p=[1,l,h],m=[],s,d,k,b,o,q,e,a;g[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/this.board.stretchX+this.stdform[2]*this.board.origin.scrCoords[2]/this.board.stretchY;g[1]=this.stdform[1]/this.board.stretchX;g[2]=this.stdform[2]/(-this.board.stretchY);s=this.board.algebra.innerProduct(p,g,3)/this.board.algebra.innerProduct(g,g,3);for(d=0;d<3;d++){m[d]=p[d]-s*g[d]}m[1]/=m[0];m[2]/=m[0];m[0]=1;if((p[0]-m[0])*(p[0]-m[0])+(p[1]-m[1])*(p[1]-m[1])+(p[2]-m[2])*(p[2]-m[2])>this.r*this.r){return false}if(this.visProp.straightFirst&&this.visProp.straightLast){return true}else{b=this.point1.coords.scrCoords;o=this.point2.coords.scrCoords;a=(o[1]-b[1])*(o[1]-b[1])+(o[2]-b[2])*(o[2]-b[2]);q=(m[1]-b[1])*(m[1]-b[1])+(m[2]-b[2])*(m[2]-b[2]);e=(m[1]-o[1])*(m[1]-o[1])+(m[2]-o[2])*(m[2]-o[2]);if((q>a)||(e>a)){if(q<e){if(!this.visProp.straightFirst){return false}}else{if(!this.visProp.straightLast){return false}}}return true}};JXG.Line.prototype.update=function(){var a,b;if(this.constrained){if(typeof this.funps!="undefined"){b=this.funps();this.point1=b[0];this.point2=b[1]}else{this.point1=this.funp1();this.point2=this.funp2()}}if(this.needsUpdate){if(true||!this.board.geonextCompatibilityMode){this.updateStdform()}for(a=0;a<this.ticks.length;a++){if(typeof this.ticks[a]!="undefined"){this.ticks[a].calculateTicksCoordinates()}}}if(this.traced){this.cloneToBackground(true)}};JXG.Line.prototype.updateStdform=function(){var a=this.board.algebra.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=a[0];this.stdform[1]=a[1];this.stdform[2]=a[2];this.stdform[3]=0;this.normalize()};JXG.Line.prototype.updateRenderer=function(){var a;if(this.needsUpdate&&this.visProp.visible){a=this.isReal;this.isReal=(isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2]))?false:true;if(this.isReal){if(a!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateLine(this)}else{if(a!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Line.prototype.generatePolynomial=function(g){var e=this.point1.symbolic.x,d=this.point1.symbolic.y,k=this.point2.symbolic.x,h=this.point2.symbolic.y,b=g.symbolic.x,a=g.symbolic.y;return[["(",d,")*(",b,")-(",d,")*(",k,")+(",a,")*(",k,")-(",e,")*(",a,")+(",e,")*(",h,")-(",b,")*(",h,")"].join("")]};JXG.Line.prototype.getRise=function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[0]/this.stdform[2]}else{return Infinity}};JXG.Line.prototype.getSlope=function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[1]/this.stdform[2]}else{return Infinity}};JXG.Line.prototype.setStraight=function(a,b){this.visProp.straightFirst=a;this.visProp.straightLast=b;this.board.renderer.updateLine(this)};JXG.Line.prototype.setArrow=function(b,a){this.visProp.firstArrow=b;this.visProp.lastArrow=a;this.board.renderer.updateLine(this)};JXG.Line.prototype.getTextAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0.5*(this.point2.X()-this.point1.X()),0.5*(this.point2.Y()-this.point1.Y())],this.board)};JXG.Line.prototype.getLabelAnchor=function(){var g,d,b,e,a;if(!this.visProp.straightFirst&&!this.visProp.straightLast){return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X()-0.5*(this.point2.X()-this.point1.X()),this.point2.Y()-0.5*(this.point2.Y()-this.point1.Y())],this.board)}else{d=new JXG.Coords(JXG.COORDS_BY_USER,this.point1.coords.usrCoords,this.board);b=new JXG.Coords(JXG.COORDS_BY_USER,this.point2.coords.usrCoords,this.board);this.board.renderer.calcStraight(this,d,b);if(this.visProp.straightFirst){g=d}else{g=b}if(this.label.content!=null){e=[0,0];a=this.getSlope();if(g.scrCoords[2]==0){if(a==Infinity){e=[10,-10]}else{if(a>=0){e=[10,-10]}else{e=[-10,-10]}}}else{if(g.scrCoords[2]==this.board.canvasHeight){if(a==Infinity){e=[10,10]}else{if(a>=0){e=[-10,10]}else{e=[10,10]}}}}if(g.scrCoords[1]==0){if(a==Infinity){e=[10,10]}else{if(a>=0){e=[10,-10]}else{e=[10,10]}}}else{if(g.scrCoords[1]==this.board.canvasWidth){if(a==Infinity){e=[-10,10]}else{if(a>=0){e=[-10,10]}else{e=[-10,-10]}}}}this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[e[0]/this.board.stretchX,e[1]/this.board.stretchY],this.board)}return g}};JXG.Line.prototype.cloneToBackground=function(b){var e={},d,a;e.id=this.id+"T"+this.numTraces;this.numTraces++;e.point1=this.point1;e.point2=this.point2;e.stdform=this.stdform;e.board={};e.board.unitX=this.board.unitX;e.board.unitY=this.board.unitY;e.board.zoomX=this.board.zoomX;e.board.zoomY=this.board.zoomY;e.board.stretchX=this.board.stretchX;e.board.stretchY=this.board.stretchY;e.board.origin=this.board.origin;e.board.canvasHeight=this.board.canvasHeight;e.board.canvasWidth=this.board.canvasWidth;e.board.dimension=this.board.dimension;e.board.algebra=this.board.algebra;e.visProp=this.visProp;a=this.getSlope();d=this.getRise();e.getSlope=function(){return a};e.getRise=function(){return d};this.board.renderer.enhancedRendering=true;this.board.renderer.drawLine(e);this.board.renderer.enhancedRendering=false;this.traces[e.id]=document.getElementById(e.id);delete e};JXG.Line.prototype.addTransform=function(a){var d,b;if(JXG.isArray(a)){d=a}else{d=[a]}for(b=0;b<d.length;b++){this.point1.transformations.push(d[b]);this.point2.transformations.push(d[b])}};JXG.Line.prototype.setPosition=function(e,a,d){var b=this.board.createElement("transform",[a,d],{type:"translate"});if(this.point1.transformations.length>0&&this.point1.transformations[this.point1.transformations.length-1].isNumericMatrix){this.point1.transformations[this.point1.transformations.length-1].melt(b)}else{this.point1.addTransform(this.point1,b)}if(this.point2.transformations.length>0&&this.point2.transformations[this.point2.transformations.length-1].isNumericMatrix){this.point2.transformations[this.point2.transformations.length-1].melt(b)}else{this.point2.addTransform(this.point2,b)}};JXG.Line.prototype.X=function(l){var p=this.stdform[1],o=this.stdform[2],m=this.stdform[0],h,g,d,e,k;l*=Math.PI;h=p*Math.cos(l)+o*Math.sin(l);g=m;d=Math.sqrt(h*h+g*g);e=-g/d;k=h/d;if(Math.abs(k)<this.board.algebra.eps){k=1}return e*Math.cos(l)/k};JXG.Line.prototype.Y=function(l){var p=this.stdform[1],o=this.stdform[2],m=this.stdform[0],h,g,d,e,k;l*=Math.PI;h=p*Math.cos(l)+o*Math.sin(l);g=m;d=Math.sqrt(h*h+g*g);e=-g/d;k=h/d;if(Math.abs(k)<this.board.algebra.eps){k=1}return e*Math.sin(l)/k};JXG.Line.prototype.Z=function(k){var g=this.stdform[1],e=this.stdform[2],o=this.stdform[0],d,m,h,l;k*=Math.PI;d=g*Math.cos(k)+e*Math.sin(k);m=o;h=Math.sqrt(d*d+m*m);l=d/h;if(Math.abs(l)>=this.board.algebra.eps){return 1}else{return 0}};JXG.Line.prototype.minX=function(){return 0};JXG.Line.prototype.maxX=function(){return 1};JXG.Line.prototype.addTicks=function(a){if(a.id==""||typeof a.id=="undefined"){a.id=this.id+"_ticks_"+(this.ticks.length+1)}this.board.renderer.drawTicks(a);this.ticks.push(a);this.ticks[this.ticks.length-1].updateRenderer();return a.id};JXG.Line.prototype.removeAllTicks=function(){var a;for(a=this.ticks.length;a>0;a--){this.board.renderer.remove(this.ticks[a-1].rendNode)}this.ticks=new Array()};JXG.Line.prototype.removeTicks=function(d){var b,a;if(this.defaultTicks!=null&&this.defaultTicks==d){this.defaultTicks=null}for(b=this.ticks.length;b>0;b--){if(this.ticks[b-1]==d){this.board.renderer.remove(this.ticks[b-1].rendNode);for(a=0;a<this.ticks[b-1].ticks.length;a++){if(this.ticks[b-1].labels[a]!=null){if(this.ticks[b-1].labels[a].show){this.board.renderer.remove(this.ticks[b-1].labels[a].rendNode)}}}delete (this.ticks[b-1])}}};JXG.createLine=function(h,l,g){var b,o,m,e,k=[];if(g==null){g={}}if(g.withLabel==null||typeof g.withLabel=="undefined"){g.withLabel=false}var d=false;if(l.length==2){if(l[0].length>1){o=h.createElement("point",l[0],{visible:false,fixed:true})}else{if(l[0].elementClass==JXG.OBJECT_CLASS_POINT){o=JXG.getReference(h,l[0])}else{if((typeof l[0]=="function")&&(l[0]().elementClass==JXG.OBJECT_CLASS_POINT)){o=l[0]();d=true}else{throw ("Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.")}}}if(l[1].length>1){m=h.createElement("point",l[1],{visible:false,fixed:true})}else{if(l[1].elementClass==JXG.OBJECT_CLASS_POINT){m=JXG.getReference(h,l[1])}else{if((typeof l[1]=="function")&&(l[1]().elementClass==JXG.OBJECT_CLASS_POINT)){m=l[1]();d=true}else{throw ("Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.")}}}b=new JXG.Line(h,o.id,m.id,g.id,g.name,g.withLabel);if(d){b.constrained=true;b.funp1=l[0];b.funp2=l[1]}}else{if(l.length==3){for(e=0;e<3;e++){if(typeof l[e]=="number"){k[e]=function(p){return function(){return p}}(l[e])}else{if(typeof l[e]=="function"){k[e]=l[e]}else{throw ("Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"' and '"+(typeof l[2])+"'.");return}}}o=h.createElement("point",[function(){return 0},function(){return k[2]()},function(){return -k[1]()}],{visible:false,name:" "});m=h.createElement("point",[function(){return k[2]()*k[2]()+k[1]()*k[1]()},function(){return -k[1]()*k[0]()+k[2]()},function(){return -k[2]()*k[0]()-k[1]()}],{visible:false,name:" "});b=new JXG.Line(h,o.id,m.id,g.id,g.name,g.withLabel)}else{if((l.length==1)&&(typeof l[0]=="function")&&(l[0]().length==2)&&(l[0]()[0].elementClass==JXG.OBJECT_CLASS_POINT)&&(l[0]()[1].elementClass==JXG.OBJECT_CLASS_POINT)){var a=l[0]();b=new JXG.Line(h,a[0].id,a[1].id,g.id,g.name,g.withLabel);b.constrained=true;b.funps=l[0]}else{throw ("Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.")}}}return b};JXG.JSXGraph.registerElement("line",JXG.createLine);JXG.createSegment=function(d,a,e){var b;if(e==null){e=new Object()}if(e.withLabel==null||typeof e.withLabel=="undefined"){e.withLabel=false}e.straightFirst=false;e.straightLast=false;b=d.createElement("line",a,e);return b};JXG.JSXGraph.registerElement("segment",JXG.createSegment);JXG.createArrow=function(e,b,a){var d;if(a==null){a={}}if(a.withLabel==null||typeof a.withLabel=="undefined"){a.withLabel=false}d=e.createElement("line",b,a);d.setStraight(false,false);d.setArrow(false,true);return d};JXG.JSXGraph.registerElement("arrow",JXG.createArrow);JXG.createAxis=function(g,o,b){var l,k,p,h,d,a,e,m;if((JXG.isArray(o[0])||JXG.isPoint(o[0]))&&(JXG.isArray(o[1])||JXG.isPoint(o[1]))){if(JXG.isPoint(o[0])){l=o[0]}else{l=new JXG.Point(g,o[0],"","",false)}if(JXG.isPoint(o[1])){k=o[1]}else{k=new JXG.Point(g,o[1],"","",false)}l.fixed=true;k.fixed=true;if(b==null){b={}}b.lastArrow=true;b.straightFirst=true;b.straightLast=true;if(b.strokeWidth==null){b.strokeWidth=1}if(b.withLabel==null){b.withLabel=false}p=g.createElement("line",[l,k],b);p.needsRegularUpdate=false;if(b.minorTicks=="undefined"||b.minorTicks==null){b.minorTicks=4}if((b.insertTicks=="undefined")||(b.insertTicks==null)){b.insertTicks="true"}if(b.ticksDistance!="undefined"&&b.ticksDistance!=null){h=b.ticksDistance}else{d=new JXG.Coords(JXG.COORDS_BY_USER,[p.point1.coords.usrCoords.slice(1)],g);a=new JXG.Coords(JXG.COORDS_BY_USER,[p.point2.coords.usrCoords.slice(1)],g);g.renderer.calcStraight(p,d,a);e=d.distance(JXG.COORDS_BY_USER,a);h=1}m=g.createElement("ticks",[p,h],b);m.needsRegularUpdate=false;p.defaultTicks=m}else{throw ("Can't create point with parent types '"+(typeof o[0])+"' and '"+(typeof o[1])+"'.")}return p};JXG.JSXGraph.registerElement("axis",JXG.createAxis);JXG.createTangent=function(m,q,e){var a,o,k,l,h,d,b,s,u;if(q.length==1){a=q[0];o=a.slideObject}else{if(q.length==2){if(JXG.isPoint(q[0])){a=q[0];o=q[1]}else{if(JXG.isPoint(q[1])){o=q[0];a=q[1]}else{throw ("Can't create normal with parent types '"+(typeof q[0])+"' and '"+(typeof q[1])+"'.")}}}else{throw ("Can't create normal with parent types '"+(typeof q[0])+"' and '"+(typeof q[1])+"'.")}}if(e==null){e={}}if(e.withLabel==null){e.withLabel=false}if(o.elementClass==JXG.OBJECT_CLASS_LINE){return m.createElement("line",[o.point1,o.point2],e)}else{if(o.elementClass==JXG.OBJECT_CLASS_CURVE){if(o.curveType!="plot"){k=o.X;l=o.Y;return m.createElement("line",[function(){return -a.X()*m.D(l)(a.position)+a.Y()*m.D(k)(a.position)},function(){return m.D(l)(a.position)},function(){return -m.D(k)(a.position)}],e)}else{return m.createElement("line",[function(){h=Math.floor(a.position);if(h==o.numberPoints-1){h--}if(h<0){return 1}return o.Y(h)*o.X(h+1)-o.X(h)*o.Y(h+1)},function(){h=Math.floor(a.position);if(h==o.numberPoints-1){h--}if(h<0){return 0}return o.Y(h+1)-o.Y(h)},function(){h=Math.floor(a.position);if(h==o.numberPoints-1){h--}if(h<0){return 0}return o.X(h)-o.X(h+1)}],e)}}else{if(o.type==JXG.OBJECT_TYPE_TURTLE){return m.createElement("line",[function(){h=Math.floor(a.position);for(d=0;d<o.objects.length;d++){b=o.objects[d];if(b.type==JXG.OBJECT_TYPE_CURVE){if(h<b.numberPoints){break}h-=b.numberPoints}}if(h==b.numberPoints-1){h--}if(h<0){return 1}return b.Y(h)*b.X(h+1)-b.X(h)*b.Y(h+1)},function(){h=Math.floor(a.position);for(d=0;d<o.objects.length;d++){b=o.objects[d];if(b.type==JXG.OBJECT_TYPE_CURVE){if(h<b.numberPoints){break}h-=b.numberPoints}}if(h==b.numberPoints-1){h--}if(h<0){return 0}return b.Y(h+1)-b.Y(h)},function(){h=Math.floor(a.position);for(d=0;d<o.objects.length;d++){b=o.objects[d];if(b.type==JXG.OBJECT_TYPE_CURVE){if(h<b.numberPoints){break}h-=b.numberPoints}}if(h==b.numberPoints-1){h--}if(h<0){return 0}return b.X(h)-b.X(h+1)}],e)}else{if(o.elementClass==JXG.OBJECT_CLASS_CIRCLE){return m.createElement("line",[function(){return JXG.Math.matVecMult(o.quadraticform,a.coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(o.quadraticform,a.coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(o.quadraticform,a.coords.usrCoords)[2]}],e)}}}}};JXG.JSXGraph.registerElement("tangent",JXG.createTangent);JXG.Group=function(g,l,a){var h,e,b,k,d;this.board=g;this.objects={};h=this.board.numObjects;this.board.numObjects++;if((l=="")||(l==null)||(typeof l=="undefined")){this.id=this.board.id+"Group"+h}else{this.id=l}this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;if((a=="")||(a==null)||(typeof a=="undefined")){this.name="group_"+this.board.generateName(this)}else{this.name=a}delete (this.type);if((arguments.length==4)&&(JXG.isArray(arguments[3]))){e=arguments[3]}else{e=[];for(b=3;b<arguments.length;b++){e.push(arguments[b])}}for(b=0;b<e.length;b++){k=JXG.getReference(this.board,e[b]);if((!k.fixed)&&((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER))){if(k.group.length!=0){this.addGroup(k.group[k.group.length-1])}else{this.addPoint(k)}}}for(d in this.objects){this.objects[d].group.push(this)}this.dX=0;this.dY=0};JXG.Group.prototype.ungroup=function(){var a;for(a in this.objects){if(this.objects[a].group[this.objects[a].group.length-1]==this){this.objects[a].group.pop()}delete (this.objects[a])}};JXG.Group.prototype.update=function(a){var d=null,b;for(b in this.objects){d=this.objects[b];if(d.id!=a.id){d.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d.coords.scrCoords[1]+this.dX,d.coords.scrCoords[2]+this.dY],d.board)}}for(b in this.objects){if(this.board.objects[b]!=undefined){this.objects[b].update(false)}else{delete (this.objects[b])}}};JXG.Group.prototype.addPoint=function(a){this.objects[a.id]=a};JXG.Group.prototype.addPoints=function(a){var b;for(b in a){this.objects[b.id]=b}};JXG.Group.prototype.addGroup=function(b){var a;for(a in b.objects){this.addPoint(b.objects[a])}};JXG.createGroup=function(d,b,a){return new JXG.Group(d,a.id,a.name,b)};JXG.JSXGraph.registerElement("group",JXG.createGroup);JXG.Circle=function(g,k,e,b,h,a,d){this.constructor();this.type=JXG.OBJECT_TYPE_CIRCLE;this.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.init(g,h,a);this.method=k;this.midpoint=JXG.getReference(this.board,e);this.midpoint.addChild(this);this.visProp.visible=true;this.visProp.fillColor=this.board.options.circle.fillColor;this.visProp.highlightFillColor=this.board.options.circle.highlightFillColor;this.visProp.strokeColor=this.board.options.circle.strokeColor;this.visProp.highlightStrokeColor=this.board.options.circle.highlightStrokeColor;this.point2=null;this.radius=0;this.line=null;this.circle=null;if(k=="twoPoints"){this.point2=JXG.getReference(g,b);this.point2.addChild(this);this.radius=this.getRadius()}else{if(k=="pointRadius"){this.generateTerm(b);this.updateRadius()}else{if(k=="pointLine"){this.line=JXG.getReference(g,b);this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(k=="pointCircle"){this.circle=JXG.getReference(g,b);this.radius=this.circle.getRadius()}}}}if(d!=null){this.createLabel(d)}if(k=="twoPoints"){this.id=this.board.addCircle(this)}else{if(k=="pointRadius"){this.id=this.board.addCircle(this);this.notifyParents(b)}else{if(k=="pointLine"){this.line.addChild(this);this.id=this.board.addCircle(this)}else{if(k=="pointCircle"){this.circle.addChild(this);this.id=this.board.addCircle(this)}}}}};JXG.Circle.prototype=new JXG.GeometryElement;JXG.Circle.prototype.hasPoint=function(a,k){var b=this.board.options.precision.hasPoint/(this.board.stretchX),e=this.midpoint.coords.usrCoords,g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[a,k],this.board),d=this.getRadius();var h=Math.sqrt((e[1]-g.usrCoords[1])*(e[1]-g.usrCoords[1])+(e[2]-g.usrCoords[2])*(e[2]-g.usrCoords[2]));return(Math.abs(h-d)<b)};JXG.Circle.prototype.generatePolynomial=function(k){var g=this.midpoint.symbolic.x;var e=this.midpoint.symbolic.y;var d=k.symbolic.x;var b=k.symbolic.y;var a=this.generateRadiusSquared();if(a==""){return[]}var h="(("+d+")-("+g+"))^2 + (("+b+")-("+e+"))^2 - ("+a+")";return[h]};JXG.Circle.prototype.generateRadiusSquared=function(){var b="";if(this.method=="twoPoints"){var e=this.midpoint.symbolic.x;var d=this.midpoint.symbolic.y;var h=this.point2.symbolic.x;var g=this.point2.symbolic.y;b="("+h+"-"+e+")^2 + ("+g+"-"+d+")^2"}else{if(this.method=="pointRadius"){if(typeof(this.radius)=="number"){b=""+this.radius*this.radius}}else{if(this.method=="pointLine"){var h=this.line.point1.symbolic.x;var g=this.line.point1.symbolic.y;var a=this.line.point2.symbolic.x;var k=this.line.point2.symbolic.y;b="("+h+"-"+a+")^2 + ("+g+"-"+k+")^2"}else{if(this.method=="pointCircle"){b=this.circle.getRadius()}}}}return b};JXG.Circle.prototype.update=function(){if(this.traced){this.cloneToBackground(true)}if(this.needsUpdate){if(this.method=="pointLine"){this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(this.method=="pointCircle"){this.radius=this.circle.getRadius()}else{if(this.method=="pointRadius"){this.radius=this.updateRadius()}}}if(!this.board.geonextCompatibilityMode){this.updateStdform();this.updateQuadraticform()}}};JXG.Circle.prototype.updateQuadraticform=function(){var a=this.midpoint;this.quadraticform=[[a.X()*a.X()+a.Y()*a.Y()-this.getRadius()*this.getRadius(),-a.X(),-a.Y()],[-a.X(),1,0],[-a.Y(),0,1]]};JXG.Circle.prototype.updateStdform=function(){this.stdform[3]=0.5;this.stdform[4]=this.getRadius();this.stdform[1]=-this.midpoint.coords.usrCoords[1];this.stdform[2]=-this.midpoint.coords.usrCoords[2];this.normalize()};JXG.Circle.prototype.updateRenderer=function(){if(this.needsUpdate&&this.visProp.visible){var a=this.isReal;this.isReal=(isNaN(this.midpoint.coords.usrCoords[1]+this.midpoint.coords.usrCoords[2]+this.getRadius()))?false:true;if(this.isReal){if(a!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateCircle(this)}else{if(a!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Circle.prototype.generateTerm=function(b){if(typeof b=="string"){var d=this.board.elementsByName;var a=this.board.algebra.geonext2JS(b+"");this.updateRadius=new Function("return "+a+";")}else{if(typeof b=="number"){this.updateRadius=function(){return b}}else{this.updateRadius=b}}};JXG.Circle.prototype.notifyParents=function(b){var a=null;var d=this.board.elementsByName;if(typeof b=="string"){this.board.algebra.findDependencies(this,b+"")}};JXG.Circle.prototype.getRadius=function(){if(this.method=="twoPoints"){return(Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))}else{if(this.method=="pointLine"||this.method=="pointCircle"){return this.radius}else{if(this.method=="pointRadius"){return this.updateRadius()}}}};JXG.Circle.prototype.getTextAnchor=function(){return this.midpoint.coords};JXG.Circle.prototype.getLabelAnchor=function(){if(this.method=="twoPoints"){var b=this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1];var a=this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2];return new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+b,this.midpoint.coords.usrCoords[2]+a],this.board)}else{if(this.method=="pointLine"||this.method=="pointCircle"||this.method=="pointRadius"){return new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]-this.getRadius(),this.midpoint.coords.usrCoords[2]],this.board)}}};JXG.Circle.prototype.cloneToBackground=function(a){var d={};d.id=this.id+"T"+this.numTraces;this.numTraces++;d.midpoint={};d.midpoint.coords=this.midpoint.coords;var b=this.getRadius();d.getRadius=function(){return b};d.board={};d.board.unitX=this.board.unitX;d.board.unitY=this.board.unitY;d.board.zoomX=this.board.zoomX;d.board.zoomY=this.board.zoomY;d.board.stretchX=this.board.stretchX;d.board.stretchY=this.board.stretchY;d.visProp=this.visProp;this.board.renderer.drawCircle(d);this.traces[d.id]=document.getElementById(d.id);delete d};JXG.Circle.prototype.addTransform=function(a){var d;if(JXG.isArray(a)){d=a}else{d=[a]}for(var b=0;b<d.length;b++){this.midpoint.transformations.push(d[b]);if(this.method=="twoPoints"){this.point2.transformations.push(d[b])}}};JXG.Circle.prototype.setPosition=function(e,a,d){var b=this.board.createElement("transform",[a,d],{type:"translate"});this.addTransform(b)};JXG.Circle.prototype.X=function(a){a*=2*Math.PI;return this.getRadius()*Math.cos(a)+this.midpoint.coords.usrCoords[1]};JXG.Circle.prototype.Y=function(a){a*=2*Math.PI;return this.getRadius()*Math.sin(a)+this.midpoint.coords.usrCoords[2]};JXG.Circle.prototype.minX=function(){return 0};JXG.Circle.prototype.maxX=function(){return 1};JXG.Circle.prototype.area=function(){var a=this.getRadius()*this.getRadius()*Math.PI;return a};JXG.createCircle=function(e,k,h){var d,g,b;if(h==null){h={}}if(typeof h.withLabel=="undefined"){h.withLabel=false}g=[];for(b=0;b<k.length;b++){if(JXG.isPoint(k[b])){g[b]=k[b]}else{if(k[b].length>1){g[b]=e.createElement("point",k[b],{visible:false,fixed:true})}else{g[b]=k[b]}}}if(k.length==2&&JXG.isPoint(g[0])&&JXG.isPoint(g[1])){d=new JXG.Circle(e,"twoPoints",g[0],g[1],h.id,h.name,h.withLabel)}else{if((JXG.isNumber(g[0])||JXG.isFunction(g[0])||JXG.isString(g[0]))&&JXG.isPoint(g[1])){d=new JXG.Circle(e,"pointRadius",g[1],g[0],h.id,h.name,h.withLabel)}else{if((JXG.isNumber(g[1])||JXG.isFunction(g[1])||JXG.isString(g[1]))&&JXG.isPoint(g[0])){d=new JXG.Circle(e,"pointRadius",g[0],g[1],h.id,h.name,h.withLabel)}else{if((g[0].type==JXG.OBJECT_TYPE_CIRCLE)&&JXG.isPoint(g[1])){d=new JXG.Circle(e,"pointCircle",g[1],g[0],h.id,h.name,h.withLabel)}else{if((g[1].type==JXG.OBJECT_TYPE_CIRCLE)&&JXG.isPoint(g[0])){d=new JXG.Circle(e,"pointCircle",g[0],g[1],h.id,h.name,h.withLabel)}else{if((g[0].type==JXG.OBJECT_TYPE_LINE)&&JXG.isPoint(g[1])){d=new JXG.Circle(e,"pointLine",g[1],g[0],h.id,h.name,h.withLabel)}else{if((g[1].type==JXG.OBJECT_TYPE_LINE)&&JXG.isPoint(g[0])){d=new JXG.Circle(e,"pointLine",g[0],g[1],h.id,h.name,h.withLabel)}else{if(k.length==3&&JXG.isPoint(g[0])&&JXG.isPoint(g[1])&&JXG.isPoint(g[2])){var a=JXG.createCircumcircle(e,g,h);a[0].setProperty({visible:false});return a[1]}else{throw ("Can't create circle with parent types '"+(typeof k[0])+"' and '"+(typeof k[1])+"'.")}}}}}}}}return d};JXG.JSXGraph.registerElement("circle",JXG.createCircle);JXG.Polygon=function(o,p,q,d,b,e,a,k){this.constructor();this.type=JXG.OBJECT_TYPE_POLYGON;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(o,d,b);if((typeof e=="undefined")||(e==null)){e=true}if((typeof k=="undefined")||(k==null)){k=false}this.withLines=e;this.vertices=[];for(var h=0;h<p.length;h++){var m=JXG.getReference(this.board,p[h]);this.vertices[h]=m}if((typeof q=="undefined")||(q==null)){q=[];for(var h=0;h<p.length-1;h++){q[h]={}}}if(this.vertices[this.vertices.length-1]!=this.vertices[0]){this.vertices.push(this.vertices[0]);q.push({})}this.visProp.fillColor=this.board.options.polygon.fillColor;this.visProp.highlightFillColor=this.board.options.polygon.highlightFillColor;this.visProp.fillOpacity=this.board.options.polygon.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.polygon.highlightFillOpacity;var g;this.borders=[];if(e){for(var h=0;h<this.vertices.length-1;h++){g=new JXG.Line(o,this.vertices[h],this.vertices[h+1],q[h].id,q[h].name,k);g.setStraight(false,false);this.borders[h]=g;g.parentPolygon=this}}for(var h=0;h<this.vertices.length-1;h++){var m=JXG.getReference(this.board,this.vertices[h]);m.addChild(this)}this.createLabel(a,[0,0]);this.id=this.board.addPolygon(this)};JXG.Polygon.prototype=new JXG.GeometryElement;JXG.Polygon.prototype.hasPoint=function(a,b){return false};JXG.Polygon.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updatePolygon(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Polygon.prototype.getTextAnchor=function(){var g=0;var e=0;var d=0;var k=0;g=d=this.vertices[0].X();e=k=this.vertices[0].Y();for(var h=0;h<this.vertices.length;h++){if(this.vertices[h].X()<g){g=this.vertices[h].X()}if(this.vertices[h].X()>d){d=this.vertices[h].X()}if(this.vertices[h].Y()>e){e=this.vertices[h].Y()}if(this.vertices[h].Y()<k){k=this.vertices[h].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(g+d)*0.5,(e+k)*0.5],this.board)};JXG.Polygon.prototype.getLabelAnchor=function(){var g=0;var e=0;var d=0;var k=0;g=d=this.vertices[0].X();e=k=this.vertices[0].Y();for(var h=0;h<this.vertices.length;h++){if(this.vertices[h].X()<g){g=this.vertices[h].X()}if(this.vertices[h].X()>d){d=this.vertices[h].X()}if(this.vertices[h].Y()>e){e=this.vertices[h].Y()}if(this.vertices[h].Y()<k){k=this.vertices[h].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(g+d)*0.5,(e+k)*0.5],this.board)};JXG.Polygon.prototype.cloneToBackground=function(a){var b={};b.id=this.id+"T"+this.numTraces;this.numTraces++;b.vertices=this.vertices;b.visProp=this.visProp;this.board.renderer.drawPolygon(b);this.traces[b.id]=$(b.id);delete b};JXG.createPolygon=function(e,a,g){var d;if(typeof g.withLabel=="undefined"){g.withLabel=false}for(var b=0;b<a.length;b++){a[b]=JXG.getReference(e,a[b]);if(!JXG.isPoint(a[b])){throw ("Can't create polygon with parent types other than 'point'.")}}d=new JXG.Polygon(e,a,g.borders,g.id,g.name,g.withLines,g.withLabel,g.lineLabels);return d};JXG.JSXGraph.registerElement("polygon",JXG.createPolygon);JXG.Polygon.prototype.hideElement=function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.withLines){for(var a=0;a<this.borders.length;a++){this.borders[a].hideElement()}}if(this.hasLabel&&this.label!=null){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}};JXG.Polygon.prototype.showElement=function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.withLines){for(var a=0;a<this.borders.length;a++){this.borders[a].showElement()}}};JXG.Polygon.prototype.area=function(){var b=0,a;for(a=0;a<this.vertices.length-1;a++){b+=(this.vertices[a].X()*this.vertices[a+1].Y()-this.vertices[a+1].X()*this.vertices[a].Y())}b/=2;return Math.abs(b)};JXG.Curve=function(e,b,g,a,d){this.constructor();this.points=[];this.type=JXG.OBJECT_TYPE_CURVE;this.elementClass=JXG.OBJECT_CLASS_CURVE;this.init(e,g,a);this.doAdvancedPlot=this.board.options.curve.doAdvancedPlot;this.numberPointsHigh=this.board.options.curve.numberPointsHigh;this.numberPointsLow=this.board.options.curve.numberPointsLow;this.numberPoints=this.numberPointsHigh;this.visProp.strokeWidth=this.board.options.curve.strokeWidth;this.visProp.visible=true;this.dataX=null;this.dataY=null;this.r=this.board.options.precision.hasPoint;this.curveType=null;if(b[0]!=null){this.varname=b[0]}else{this.varname="x"}this.xterm=b[1];this.yterm=b[2];this.generateTerm(this.varname,this.xterm,this.yterm,b[3],b[4]);this.updateCurve();this.createLabel(d);this.id=this.board.addCurve(this);if(typeof this.xterm=="string"){this.notifyParents(this.xterm)}if(typeof this.yterm=="string"){this.notifyParents(this.yterm)}};JXG.Curve.prototype=new JXG.GeometryElement;JXG.Curve.prototype.minX=function(){if(this.curveType=="polar"){return 0}else{var a=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board);return a.usrCoords[1]}};JXG.Curve.prototype.maxX=function(){var a;if(this.curveType=="polar"){return 2*Math.PI}else{a=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.board.canvasWidth,0],this.board);return a.usrCoords[1]}};JXG.Curve.prototype.hasPoint=function(s,q){var u,C=Infinity,K,l,E,D,z,w,A,b,L,B,o,I,k,H,g,m,p,G=this.numberPointsLow,J=(this.maxX()-this.minX())/G,a=this.r/(this.board.unitX*this.board.zoomX),e,F,h=true;a=a*a;e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[s,q],this.board);s=e.usrCoords[1];q=e.usrCoords[2];if(this.curveType=="parameter"||this.curveType=="polar"||this.curveType=="functiongraph"){F=this.transformations.length;for(E=0,u=this.minX();E<G;E++){z=this.X(u,h);w=this.Y(u,h);for(D=0;D<F;D++){l=this.transformations[D];l.update();K=JXG.Math.matVecMult(l.matrix,[1,z,w]);z=K[1];w=K[2]}C=(s-z)*(s-z)+(q-w)*(q-w);if(C<a){return true}u+=J}}else{if(this.curveType=="plot"){F=this.numberPoints;for(E=0;E<F-1;E++){A=this.X(E);b=this.X(E+1);L=this.Y(E);B=this.Y(E+1);H=b-A;g=B-L;I=s-A;k=q-L;p=H*H+g*g;if(p>=JXG.Math.eps){m=I*H+k*g;o=m/p;C=I*I+k*k-o*m}else{o=0;C=I*I+k*k}if(o>=0&&o<=1&&C<a){return true}}return false}}return(C<a)};JXG.Curve.prototype.allocatePoints=function(){var b,a;a=this.numberPoints;if(this.points.length<this.numberPoints){for(b=this.points.length;b<a;b++){this.points[b]=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)}}};JXG.Curve.prototype.update=function(){if(this.needsUpdate){this.updateCurve()}return this};JXG.Curve.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateCurve(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}return this};JXG.Curve.prototype.updateDataArray=function(){return this};JXG.Curve.prototype.updateCurve=function(){var b,d,k,a,h,e,g=false;this.updateDataArray();d=this.minX();k=this.maxX();if(this.dataX!=null){this.numberPoints=this.dataX.length;b=this.numberPoints;this.allocatePoints();for(e=0;e<b;e++){a=e;if(this.dataY!=null){h=e}else{h=this.X(a)}this.points[e].setCoordinates(JXG.COORDS_BY_USER,[this.X(a,g),this.Y(h,g)],false);this.updateTransform(this.points[e]);g=true}}else{if(this.doAdvancedPlot){this.updateParametricCurve(d,k,b)}else{if(this.board.updateQuality==this.board.BOARD_QUALITY_HIGH){this.numberPoints=this.numberPointsHigh}else{this.numberPoints=this.numberPointsLow}b=this.numberPoints;this.allocatePoints();this.updateParametricCurveNaive(d,k,b)}}this.getLabelAnchor();return this};JXG.Curve.prototype.updateParametricCurveNaive=function(d,k,b){var g,e,h=false,a=(k-d)/b;for(g=0;g<b;g++){e=d+g*a;this.points[g].setCoordinates(JXG.COORDS_BY_USER,[this.X(e,h),this.Y(e,h)],false);this.updateTransform(this.points[g]);h=true}return this};JXG.Curve.prototype.updateParametricCurve=function(E,a,A){var w,m,l,d=false,z=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board),k,h,C,b,o,G,F,q,g,u=[],e=[],D=[],B=[],p=false,s=0;if(this.board.updateQuality==this.board.BOARD_QUALITY_LOW){F=12;q=12;g=12}else{F=20;q=2;g=2}B[0]=a-E;for(w=1;w<F;w++){B[w]=B[w-1]*0.5}w=1;u[0]=1;e[0]=0;m=E;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(m,d),this.Y(m,d)],false);d=true;C=z.scrCoords[1];b=z.scrCoords[2];l=m;m=a;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(m,d),this.Y(m,d)],false);k=z.scrCoords[1];h=z.scrCoords[2];D[0]=[k,h];o=1;G=0;this.points=[];this.points[s++]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[C,b],this.board);do{p=this.isDistOK(C,b,k,h,q,g)||this.isSegmentOutside(C,b,k,h);while(G<F&&(!p||G<3)&&!(!this.isSegmentDefined(C,b,k,h)&&G>8)){u[o]=w;e[o]=G;D[o]=[k,h];o++;w=2*w-1;G++;m=E+w*B[G];z.setCoordinates(JXG.COORDS_BY_USER,[this.X(m,d),this.Y(m,d)],false);k=z.scrCoords[1];h=z.scrCoords[2];p=this.isDistOK(C,b,k,h,q,g)||this.isSegmentOutside(C,b,k,h)}this.points[s]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[k,h],this.board);this.updateTransform(this.points[s]);s++;C=k;b=h;l=m;o--;k=D[o][0];h=D[o][1];G=e[o]+1;w=u[o]*2}while(o!=0);this.numberPoints=this.points.length;return this};JXG.Curve.prototype.isSegmentOutside=function(b,e,a,d){if(e<0&&d<0){return true}else{if(e>this.board.canvasHeight&&d>this.board.canvasHeight){return true}else{if(b<0&&a<0){return true}else{if(b>this.board.canvasWidth&&a>this.board.canvasWidth){return true}}}}return false};JXG.Curve.prototype.isDistOK=function(e,h,d,g,b,a){if(isNaN(e+h+d+g)){return false}return(Math.abs(d-e)<a&&Math.abs(g-h)<a)};JXG.Curve.prototype.isSegmentDefined=function(b,e,a,d){if(isNaN(b+e)&&isNaN(a+d)){return false}return true};JXG.Curve.prototype.updateTransform=function(e){var d,g,b,a=this.transformations.length;if(a==0){return e}for(b=0;b<a;b++){d=this.transformations[b];d.update();g=JXG.Math.matVecMult(d.matrix,e.usrCoords);e.setCoordinates(JXG.COORDS_BY_USER,[g[1],g[2]])}return e};JXG.Curve.prototype.addTransform=function(b){var e,d,a;if(JXG.isArray(b)){e=b}else{e=[b]}a=e.length;for(d=0;d<a;d++){this.transformations.push(e[d])}return this};JXG.Curve.prototype.setPosition=function(e,a,d){var b=this.board.createElement("transform",[a,d],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(b)}else{this.addTransform(b)}return this};JXG.Curve.prototype.generateTerm=function(b,h,d,a,k){var g,e;if(JXG.isArray(h)){this.dataX=h;this.X=function(l){return this.dataX[l]};this.curveType="plot";this.numberPoints=this.dataX.length}else{this.X=JXG.createFunction(h,this.board,b);if(JXG.isString(h)){this.curveType="functiongraph"}else{if(JXG.isFunction(h)||JXG.isNumber(h)){this.curveType="parameter"}}}if(JXG.isArray(d)){this.dataY=d;this.Y=function(l){if(JXG.isFunction(this.dataY[l])){return this.dataY[l]()}else{return this.dataY[l]}}}else{this.Y=JXG.createFunction(d,this.board,b)}if(JXG.isFunction(h)&&JXG.isArray(d)){g=JXG.createFunction(d[0],this.board,"");e=JXG.createFunction(d[1],this.board,"");this.X=function(l){return(h)(l)*Math.cos(l)+g()};this.Y=function(l){return(h)(l)*Math.sin(l)+e()};this.curveType="polar"}if(a!=null){this.minX=JXG.createFunction(a,this.board,"")}if(k!=null){this.maxX=JXG.createFunction(k,this.board,"")}};JXG.Curve.prototype.notifyParents=function(a){this.board.algebra.findDependencies(this,a)};JXG.Curve.prototype.getLabelAnchor=function(){var a=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,this.board.canvasHeight*0.5],this.board);a=this.board.algebra.projectCoordsToCurve(a.usrCoords[1],a.usrCoords[2],0,this)[0];return a};JXG.createCurve=function(d,b,a){if(a==null){a={}}if(typeof a.withLabel=="undefined"){a.withLabel=false}return new JXG.Curve(d,["x"].concat(b),a.id,a.name,a.withLabel)};JXG.JSXGraph.registerElement("curve",JXG.createCurve);JXG.createFunctiongraph=function(e,b,a){var d=["x","x"].concat(b);if(a==null){a={}}if(typeof a.withLabel=="undefined"){a.withLabel=false}a.curveType="functiongraph";return new JXG.Curve(e,d,a.id,a.name,a.withLabel)};JXG.JSXGraph.registerElement("functiongraph",JXG.createFunctiongraph);JXG.createSpline=function(d,b,a){var e;if(a==null){a={}}if(typeof a.withLabel=="undefined"){a.withLabel=false}e=function(){var k,g=[],l=[];var h=function(q,p){var o,m;if(!p){g=[];l=[];if(b.length==2&&JXG.isArray(b[0])&&JXG.isArray(b[1])&&b[0].length==b[1].length){for(o=0;o<b[0].length;o++){if(typeof b[0][o]=="function"){g.push(b[0][o]())}else{g.push(b[0][o])}if(typeof b[1][o]=="function"){l.push(b[1][o]())}else{l.push(b[1][o])}}}else{for(o=0;o<b.length;o++){if(JXG.isPoint(b[o])){g.push(b[o].X());l.push(b[o].Y())}else{if(JXG.isArray(b[o])&&b[o].length==2){for(o=0;o<b.length;o++){if(typeof b[o][0]=="function"){g.push(b[o][0]())}else{g.push(b[o][0])}if(typeof b[o][1]=="function"){l.push(b[o][1]())}else{l.push(b[o][1])}}}}}}k=JXG.Math.Numerics.splineDef(g,l)}return JXG.Math.Numerics.splineEval(q,g,l,k)};return h};return new JXG.Curve(d,["x","x",e()],a.id,a.name,a.withLabel)};JXG.JSXGraph.registerElement("spline",JXG.createSpline);JXG.createRiemannsum=function(g,b,a){var l,e,h,d,k;if(a==null){a={}}if(typeof a.withLabel=="undefined"){a.withLabel=false}a.fillOpacity=a.fillOpacity||0.3;a.fillColor=a.fillColor||"#ffff00";a.curveType="plot";h=b[0];l=JXG.createFunction(b[1],g,"");if(l==null){throw"JXG.createRiemannsum: argument '2' n has to be number or function."}e=JXG.createFunction(b[2],g,"",false);if(e==null){throw"JXG.createRiemannsum: argument 3 'type' has to be string or function."}d=["x",[0],[0]].concat(b.slice(3));k=new JXG.Curve(g,d,a.id,a.name,a.withLabel);k.updateDataArray=function(){var m=JXG.Math.Numerics.riemann(h,l(),e(),this.minX(),this.maxX());this.dataX=m[0];this.dataY=m[1]};return k};JXG.JSXGraph.registerElement("riemannsum",JXG.createRiemannsum);JXG.Arc=function(d,h,g,e,k,a,b){this.constructor();this.type=JXG.OBJECT_TYPE_ARC;this.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.init(d,k,a);this.midpoint=JXG.getReference(this.board,h);this.point2=JXG.getReference(this.board,g);this.point3=JXG.getReference(this.board,e);this.r=this.board.options.precision.hasPoint;this.visProp.visible=true;this.visProp.firstArrow=this.board.options.arc.firstArrow;this.visProp.lastArrow=this.board.options.arc.lastArrow;this.visProp.fillColor=this.board.options.arc.fillColor;this.visProp.highlightFillColor=this.board.options.arc.highlightFillColor;this.visProp.strokeColor=this.board.options.arc.strokeColor;this.visProp.highlightStrokeColor=this.board.options.arc.highlightStrokeColor;this.createLabel(b,[0,0]);this.id=this.board.addArc(this);this.midpoint.addChild(this);this.point2.addChild(this);this.point3.addChild(this)};JXG.Arc.prototype=new JXG.GeometryElement;JXG.Arc.prototype.hasPoint=function(m,l){var q=this.r/(this.board.stretchX);var h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[m,l],this.board);var a=this.getRadius();var k=Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-h.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-h.usrCoords[2],2));var o=(Math.abs(k-a)<q);if(o){var b={};b.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1],this.board.origin.usrCoords[2]/(this.board.stretchY)],this.board);var g=this.board.algebra.trueAngle(this.point2,this.midpoint,b);var e=this.board.algebra.trueAngle(this.point3,this.midpoint,b);var s={};s.coords=h;var d=this.board.algebra.trueAngle(s,this.midpoint,b);if(g>=e){if(g<d||d<e){o=false}}else{if(d>g){if(d<e){o=false}}}}return o};JXG.Arc.prototype.hasPointSector=function(m,l){var q=this.r/(this.board.stretchX);var h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[m,l],this.board);var a=this.getRadius();var k=Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-h.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-h.usrCoords[2],2));var o=(k<a);if(o){var b={};b.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1],this.board.origin.usrCoords[2]/(this.board.stretchY)],this.board);var g=this.board.algebra.trueAngle(this.point2,this.midpoint,b);var e=this.board.algebra.trueAngle(this.point3,this.midpoint,b);var s={};s.coords=h;var d=this.board.algebra.trueAngle(s,this.midpoint,b);if(g>=e){if(g<d||d<e){o=false}}else{if(d>g){if(d<e){o=false}}}}return o};JXG.Arc.prototype.getRadius=function(){return(Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))};JXG.Arc.prototype.getTextAnchor=function(){return this.midpoint.coords};JXG.Arc.prototype.getLabelAnchor=function(){var d=this.board.algebra.trueAngle(this.point2,this.midpoint,this.point3);var o=10/(this.board.stretchX);var l=10/(this.board.stretchY);var b=this.point2.coords.usrCoords[1]-this.midpoint.coords.usrCoords[1];var m=this.point2.coords.usrCoords[2]-this.midpoint.coords.usrCoords[2];if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[0/(this.board.stretchX),0/(this.board.stretchY)],this.board)}var h=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+Math.cos(d*Math.PI/(2*180))*b-Math.sin(d*Math.PI/(2*180))*m,this.midpoint.coords.usrCoords[2]+Math.sin(d*Math.PI/(2*180))*b+Math.cos(d*Math.PI/(2*180))*m],this.board);var g=h.usrCoords[1]-this.midpoint.coords.usrCoords[1];var e=h.usrCoords[2]-this.midpoint.coords.usrCoords[2];var a=Math.sqrt(g*g+e*e);g=g*(a+o)/a;e=e*(a+l)/a;var k=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+g,this.midpoint.coords.usrCoords[2]+e],this.board);return k};JXG.Arc.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateArc(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Arc.prototype.setArrow=function(b,a){this.visProp.firstArrow=b;this.visProp.lastArrow=a;this.board.renderer.updateArc(this);if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.createArc=function(e,b,a){var d;if(typeof a.withLabel=="undefined"){a.withLabel=false}if((JXG.isPoint(b[0]))&&(JXG.isPoint(b[1]))&&(JXG.isPoint(b[2]))){d=new JXG.Arc(e,b[0],b[1],b[2],a.id,a.name,a.withLabel)}else{throw ("Can't create Arc with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"' and '"+(typeof b[2])+"'.")}return d};JXG.JSXGraph.registerElement("arc",JXG.createArc);JXG.createSemicircle=function(e,b,a){var d,h,g;if(typeof a.withLabel=="undefined"){a.withLabel=false}if(a.id!=null){g=a.id+"_mp"}if((JXG.isPoint(b[0]))&&(JXG.isPoint(b[1]))){h=e.createElement("midpoint",[b[0],b[1]],{id:g,withLabel:false,visible:false});d=new JXG.Arc(e,h,b[1],b[0],a.id,a.name,a.withLabel)}else{throw ("Can't create Semicircle with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"'.")}return d};JXG.JSXGraph.registerElement("semicircle",JXG.createSemicircle);JXG.createCircumcircleArc=function(g,b,a){var e,k,h,d;if(typeof a.withLabel=="undefined"){a.withLabel=false}if(a.id!=null){h=a.id+"_mp"}if((JXG.isPoint(b[0]))&&(JXG.isPoint(b[1]))&&(JXG.isPoint(b[2]))){k=g.createElement("circumcirclemidpoint",[b[0],b[1],b[2]],{id:h,withLabel:false,visible:false});d=(b[0].coords.usrCoords[1]-b[2].coords.usrCoords[1])*(b[0].coords.usrCoords[2]-b[1].coords.usrCoords[2])-(b[0].coords.usrCoords[2]-b[2].coords.usrCoords[2])*(b[0].coords.usrCoords[1]-b[1].coords.usrCoords[1]);if(d<0){e=new JXG.Arc(g,k,b[0],b[2],a.id,a.name,a.withLabel)}else{e=new JXG.Arc(g,k,b[2],b[0],a.id,a.name,a.withLabel)}e.update=function(){var l;if(this.traced){this.cloneToBackground(true)}l=(b[0].coords.usrCoords[1]-b[2].coords.usrCoords[1])*(b[0].coords.usrCoords[2]-b[1].coords.usrCoords[2])-(b[0].coords.usrCoords[2]-b[2].coords.usrCoords[2])*(b[0].coords.usrCoords[1]-b[1].coords.usrCoords[1]);if(l<0){this.point2=b[0];this.point3=b[2]}else{this.point2=b[2];this.point3=b[0]}}}else{throw ("Can't create Circumcircle Arc with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"' and '"+(typeof b[2])+"'.")}return e};JXG.JSXGraph.registerElement("circumcirclearc",JXG.createCircumcircleArc);JXG.Sector=function(m,z,w,u,b,o,g){this.constructor();this.type=JXG.OBJECT_TYPE_SECTOR;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(m,g,"");if(!JXG.isArray(b)){b=[null,null,null,null]}if(!JXG.isArray(o)){o=[null,null,null,null]}this.point1=JXG.getReference(this.board,z);this.point2=JXG.getReference(this.board,w);this.point3=JXG.getReference(this.board,u);this.r=this.board.options.precision.hasPoint;this.visProp.visible=true;var d={};d.midpoint=this.point1;var l=this.getRadius();d.getRadius=function(){return l};var s=this.board.algebra.projectPointToCircle(this.point3,d);var e=new JXG.Point(m,[s.usrCoords[1],s.usrCoords[2]],b[1],o[1],true);e.fixed=true;this.addChild(e);e.update=function(){var p={};p.midpoint=JXG.getReference(this.board,z);var a=(Math.sqrt(Math.pow(JXG.getReference(this.board,z).coords.usrCoords[1]-JXG.getReference(this.board,w).coords.usrCoords[1],2)+Math.pow(JXG.getReference(this.board,z).coords.usrCoords[2]-JXG.getReference(this.board,w).coords.usrCoords[2],2)));p.getRadius=function(){return a};s=this.board.algebra.projectPointToCircle(JXG.getReference(this.board,u),p);this.coords=s;this.board.renderer.updatePoint(this);if(this.label.content.visProp.visible){this.label.content.update()}};var k=new JXG.Line(m,z,w,b[2],o[2]);var h=new JXG.Line(m,z,e.id,b[3],o[3]);k.setStraight(false,false);h.setStraight(false,false);var q=new JXG.Arc(m,z,w,u,b[0],o[0]);q.visProp.fillColor=this.board.options.sector.fillColor;q.visProp.highlightFillColor=this.board.options.sector.highlightFillColor;q.visProp.fillOpacity=this.board.options.sector.fillOpacity;q.visProp.highlightFillOpacity=this.board.options.sector.highlightFillOpacity;this.point4=e;this.lines=[k,h];this.arc=q;this.id=this.board.addSector(this);this.point1.addChild(this);this.point2.addChild(this);this.point3.addChild(this)};JXG.Sector.prototype=new JXG.GeometryElement;JXG.Sector.prototype.hasPoint=function(a,b){return false};JXG.Sector.prototype.getRadius=function(){return(Math.sqrt(Math.pow(this.point1.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.point1.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))};JXG.Sector.prototype.updateRenderer=function(){};JXG.createSector=function(b,e,d){var a;if((JXG.isPoint(e[0]))&&(JXG.isPoint(e[1]))&&(JXG.isPoint(e[2]))){a=new JXG.Sector(b,e[0],e[1],e[2],d.ids,d.names,d.id)}else{throw ("Can't create sector with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.")}return a};JXG.JSXGraph.registerElement("sector",JXG.createSector);JXG.createCircumcircleSector=function(g,b,a){var e,k,h,d;if(typeof a.withLabel=="undefined"){a.withLabel=false}if(a.id!=null){h=a.id+"_mp"}if((JXG.isPoint(b[0]))&&(JXG.isPoint(b[1]))&&(JXG.isPoint(b[2]))){k=g.createElement("circumcirclemidpoint",[b[0],b[1],b[2]],{id:h,withLabel:false,visible:false});d=(b[0].coords.usrCoords[1]-b[2].coords.usrCoords[1])*(b[0].coords.usrCoords[2]-b[1].coords.usrCoords[2])-(b[0].coords.usrCoords[2]-b[2].coords.usrCoords[2])*(b[0].coords.usrCoords[1]-b[1].coords.usrCoords[1]);if(d<0){e=new JXG.Sector(g,k,b[0],b[2],a.id,a.name,a.withLabel)}else{e=new JXG.Sector(g,k,b[2],b[0],a.id,a.name,a.withLabel)}e.arc.update=function(){var l;if(this.traced){this.cloneToBackground(true)}l=(b[0].coords.usrCoords[1]-b[2].coords.usrCoords[1])*(b[0].coords.usrCoords[2]-b[1].coords.usrCoords[2])-(b[0].coords.usrCoords[2]-b[2].coords.usrCoords[2])*(b[0].coords.usrCoords[1]-b[1].coords.usrCoords[1]);if(l<0){this.point2=b[0];this.point3=b[2]}else{this.point2=b[2];this.point3=b[0]}};e.point4.setProperty({visible:false})}else{throw ("Can't create circumcircle sector with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"' and '"+(typeof b[2])+"'.")}return e};JXG.JSXGraph.registerElement("circumcirclesector",JXG.createCircumcircleSector);JXG.Angle=function(l,e,d,a,k,p,s,B,b){this.constructor();this.type=JXG.OBJECT_TYPE_ANGLE;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(l,s,B);this.point1=JXG.getReference(this.board,e);this.point2=JXG.getReference(this.board,d);this.point3=JXG.getReference(this.board,a);this.radius=this.board.options.angle.radius;if(k!=undefined&&k!=null){this.radius=k}this.visProp.fillColor=this.board.options.angle.fillColor;this.visProp.highlightFillColor=this.board.options.angle.highlightFillColor;this.visProp.fillOpacity=this.board.options.angle.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.angle.highlightFillOpacity;this.visProp.strokeColor=this.board.options.angle.strokeColor;if(p==""){var h=["&alpha;","&beta;","&gamma;","&delta;","&epsilon;","&zeta;","&eta","&theta;","&iota;","&kappa;","&lambda;","&mu;","&nu;","&xi;","&omicron;","&pi;","&rho;","&sigmaf;","&sigma;","&tau;","&upsilon;","&phi;","&chi;","&psi;","&omega;"],z=0,u,m,g,q,w,o;while(z<h.length){u=z;m=h[z];for(g in l.objects){if(l.objects[g].type==JXG.OBJECT_TYPE_ANGLE){if(l.objects[g].text==m){z++;break}}}if(z==u){p=m;z=h.length+1}}if(z==h.length){q="&alpha;_{";w="}";o=false;u=0;while(!o){for(g in l.objects){if(l.objects[g].type==JXG.OBJECT_TYPE_ANGLE){if(l.objects[g].text==(q+u+w)){o=true;break}}}if(o){o=false}else{o=true;p=(q+u+w)}}}}this.text=p;var A=this.name;this.name=this.text;this.createLabel(b);this.name=A;this.id=this.board.addAngle(this);this.point1.addChild(this);this.point2.addChild(this);this.point3.addChild(this)};JXG.Angle.prototype=new JXG.GeometryElement;JXG.Angle.prototype.hasPoint=function(a,b){return false};JXG.Angle.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateAngle(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Angle.prototype.getLabelAnchor=function(){var e=this.board.algebra.trueAngle(this.point1,this.point2,this.point3);var d=this.point1.coords.distance(JXG.COORDS_BY_USER,this.point2.coords);var b=(this.point1.coords.usrCoords[1]-this.point2.coords.usrCoords[1])*(this.radius/2)/d;var a=(this.point1.coords.usrCoords[2]-this.point2.coords.usrCoords[2])*(this.radius/2)/d;var g=new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.coords.usrCoords[1]+Math.cos(e*Math.PI/(2*160))*b-Math.sin(e*Math.PI/(2*160))*a,this.point2.coords.usrCoords[2]+Math.sin(e*Math.PI/(2*160))*b+Math.cos(e*Math.PI/(2*160))*a],this.board);if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[0/(this.board.stretchX),0/(this.board.stretchY)],this.board)}return g};JXG.createAngle=function(e,b,a){var d;if(a.withLabel==null||typeof a.withLabel=="undefined"){a.withLabel=true}if(a.text==null||typeof a.text=="text"){a.text=""}if((JXG.isPoint(b[0]))&&(JXG.isPoint(b[1]))&&(JXG.isPoint(b[2]))){d=new JXG.Angle(e,b[0],b[1],b[2],a.radius,a.text,a.id,a.name,a.withLabel)}else{throw ("Can't create angle with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"' and '"+(typeof b[2])+"'.")}return d};JXG.JSXGraph.registerElement("angle",JXG.createAngle);JXG.Algebra=function(a){this.board=a;this.eps=JXG.Math.eps};JXG.Algebra.prototype.angle=function(g,e,d){var l=[],k=[],h=[],o,m,q,p;if(g.coords==null){l[0]=g[0];l[1]=g[1]}else{l[0]=g.coords.usrCoords[1];l[1]=g.coords.usrCoords[2]}if(e.coords==null){k[0]=e[0];k[1]=e[1]}else{k[0]=e.coords.usrCoords[1];k[1]=e.coords.usrCoords[2]}if(d.coords==null){h[0]=d[0];h[1]=d[1]}else{h[0]=d.coords.usrCoords[1];h[1]=d.coords.usrCoords[2]}o=l[0]-k[0];m=l[1]-k[1];q=h[0]-k[0];p=h[1]-k[1];return Math.atan((o*p-m*q)/(o*q+m*p))};JXG.Algebra.prototype.trueAngle=function(h,g,d){var a,z,u,q,o,m,s,l,k,b,w,e,p=0;if(h.coords==null){a=h[0];z=h[1]}else{a=h.coords.usrCoords[1];z=h.coords.usrCoords[2]}if(g.coords==null){u=g[0];q=g[1]}else{u=g.coords.usrCoords[1];q=g.coords.usrCoords[2]}if(d.coords==null){o=d[0];m=d[1]}else{o=d.coords.usrCoords[1];m=d.coords.usrCoords[2]}e=(o-u)*(a-u)+(m-q)*(z-q);s=(a-u)*(m-q)-(z-q)*(o-u);l=Math.sqrt((a-u)*(a-u)+(z-q)*(z-q));k=Math.sqrt((o-u)*(o-u)+(m-q)*(m-q));b=e/(l*k);if(b>1){b=1}else{if(b<-1){b=-1}}w=Math.acos(b);if((Math.sin(w)*s)<0){p=2*Math.PI-w}else{p=w}p=(p/Math.PI)*180;return p};JXG.Algebra.prototype.rad=function(a,d,b){return this.trueAngle(a,d,b)*Math.PI/180};JXG.Algebra.prototype.angleBisector=function(h,g,b){var e=h.coords.usrCoords,o=g.coords.usrCoords,k=b.coords.usrCoords,q=e[1]-o[1],p=e[2]-o[2],m=Math.sqrt(q*q+p*p),a,s,l;q/=m;p/=m;a=Math.acos(q);if(p<0){a*=-1}if(a<0){a+=2*Math.PI}q=k[1]-o[1];p=k[2]-o[2];m=Math.sqrt(q*q+p*p);q/=m;p/=m;s=Math.acos(q);if(p<0){s*=-1}if(s<0){s+=2*Math.PI}l=(a+s)*0.5;if(a>s){l+=Math.PI}q=Math.cos(l)+o[1];p=Math.sin(l)+o[2];return new JXG.Coords(JXG.COORDS_BY_USER,[q,p],this.board)};JXG.Algebra.prototype.midpoint=function(a,b){return new JXG.Coords(JXG.COORDS_BY_USER,[(a.coords.usrCoords[1]+b.coords.usrCoords[1])/2,(a.coords.usrCoords[2]+b.coords.usrCoords[2])/2],this.board)};JXG.Algebra.prototype.parallel=function(g,b,l){var d=1,h=l.coords.usrCoords,m=g.coords.usrCoords,a=b.coords.usrCoords,k=h[1]+d*(a[1]-m[1]),e=h[2]+d*(a[2]-m[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[k,e],this.board)};JXG.Algebra.prototype.reflection=function(p,l){var e=l.coords.usrCoords,q=p.point1.coords.usrCoords,d=p.point2.coords.usrCoords,b,k,a,g,m,h,o;m=d[1]-q[1];h=d[2]-q[2];b=e[1]-q[1];k=e[2]-q[2];o=(m*k-h*b)/(m*m+h*h);a=e[1]+2*o*h;g=e[2]-2*o*m;return new JXG.Coords(JXG.COORDS_BY_USER,[a,g],this.board)};JXG.Algebra.prototype.rotation=function(a,o,g){var k=o.coords.usrCoords,b=a.coords.usrCoords,e,m,h,p,d,l;e=k[1]-b[1];m=k[2]-b[2];h=Math.cos(g);p=Math.sin(g);d=e*h-m*p+b[1];l=e*p+m*h+b[2];return new JXG.Coords(JXG.COORDS_BY_USER,[d,l],this.board)};JXG.Algebra.prototype.perpendicular=function(s,p){var g=s.point1.coords.usrCoords,e=s.point2.coords.usrCoords,b=p.coords.usrCoords,m,k,l,q,h,d,a,o;if(p==s.point1){m=g[1]+e[2]-g[2];k=g[2]-e[1]+g[1];l=true}else{if(p==s.point2){m=e[1]+g[2]-e[2];k=e[2]-g[1]+e[1];l=false}else{if(((Math.abs(g[1]-e[1])>this.eps)&&(Math.abs(b[2]-(g[2]-e[2])*(b[1]-g[1])/(g[1]-e[1])-g[2])<this.eps))||((Math.abs(g[1]-e[1])<=this.eps)&&(Math.abs(g[1]-b[1])<this.eps))){m=b[1]+e[2]-b[2];k=b[2]-e[1]+b[1];l=true;if(Math.abs(m-b[1])<this.eps&&Math.abs(k-b[2])<this.eps){m=b[1]+g[2]-b[2];k=b[2]-g[1]+b[1];l=false}}else{q=g[2]-e[2];h=g[1]-e[1];d=e[1]*q-e[2]*h;a=b[1]*h+b[2]*q;o=q*q+h*h;if(Math.abs(o)<this.eps){o=this.eps}m=(d*q+a*h)/o;k=(a*q-d*h)/o;l=true}}}return[new JXG.Coords(JXG.COORDS_BY_USER,[m,k],this.board),l]};JXG.Algebra.prototype.circumcenterMidpoint=function(k,g,e){var d=k.coords.usrCoords,b=g.coords.usrCoords,a=e.coords.usrCoords,p,o,m,l,h;p=((d[1]-b[1])*(d[1]+b[1])+(d[2]-b[2])*(d[2]+b[2]))*0.5;o=((b[1]-a[1])*(b[1]+a[1])+(b[2]-a[2])*(b[2]+a[2]))*0.5;m=(d[1]-b[1])*(b[2]-a[2])-(b[1]-a[1])*(d[2]-b[2]);if(Math.abs(m)<this.eps){m=this.eps}l=(p*(b[2]-a[2])-o*(d[2]-b[2]))/m;h=(o*(d[1]-b[1])-p*(b[1]-a[1]))/m;return new JXG.Coords(JXG.COORDS_BY_USER,[l,h],this.board)};JXG.Algebra.prototype.intersectLineLine=function(p,o){var h=p.point1.coords.usrCoords,e=p.point2.coords.usrCoords,b=o.point1.coords.usrCoords,a=o.point2.coords.usrCoords,g,d,m,l,k;g=h[1]*e[2]-h[2]*e[1];d=b[1]*a[2]-b[2]*a[1];m=(e[2]-h[2])*(b[1]-a[1])-(h[1]-e[1])*(a[2]-b[2]);if(Math.abs(m)<this.eps){m=this.eps}l=(g*(b[1]-a[1])-d*(h[1]-e[1]))/m;k=(d*(e[2]-h[2])-g*(a[2]-b[2]))/m;return new JXG.Coords(JXG.COORDS_BY_USER,[l,k],this.board)};JXG.Algebra.prototype.intersectCircleLine=function(o,B){var O=B.point1.coords.usrCoords,L=B.point2.coords.usrCoords,g=o.midpoint.coords.usrCoords,F,a,N,K,D,I,G,p,E,C,m,k,H,z,q,e,A,u,J;F=B.point1.Dist(B.point2);if(F>0){a=o.midpoint.Dist(B.point1);N=o.midpoint.Dist(B.point2);K=((a*a)+(F*F)-(N*N))/(2*F);D=(a*a)-(K*K);D=(D<0)?0:D;I=Math.sqrt(D);G=o.getRadius();p=Math.sqrt((G*G)-I*I);E=L[1]-O[1];C=L[2]-O[2];m=g[1]+(I/F)*C;k=g[2]-(I/F)*E;a=(L[1]*C)-(L[2]*E);N=(m*E)+(k*C);H=(C*C)+(E*E);if(Math.abs(H)<this.eps){H=this.eps}z=((a*C)+(N*E))/H;q=((N*C)-(a*E))/H;e=p/F;A=new JXG.Coords(JXG.COORDS_BY_USER,[z+e*E,q+e*C],this.board);u=new JXG.Coords(JXG.COORDS_BY_USER,[z-e*E,q-e*C],this.board);J=o.midpoint.coords.distance(JXG.COORDS_BY_USER,A);if((G<(J-1))||isNaN(J)){return[0]}else{return[2,A,u]}}};JXG.Algebra.prototype.intersectCircleCircle=function(o,m){var d={},k=o.getRadius(),g=m.getRadius(),e=o.midpoint.coords.usrCoords,b=m.midpoint.coords.usrCoords,u,l,A,z,w,q,p;u=k+g;l=Math.abs(k-g);A=o.midpoint.coords.distance(JXG.COORDS_BY_USER,m.midpoint.coords);if(A>u){return[0]}else{if(A<l){return[0]}else{if(A!=0){d[0]=1;z=b[1]-e[1];w=b[2]-e[2];q=(A*A-g*g+k*k)/(2*A);p=Math.sqrt(k*k-q*q);d[1]=new JXG.Coords(JXG.COORDS_BY_USER,[e[1]+(q/A)*z+(p/A)*w,e[2]+(q/A)*w-(p/A)*z],this.board);d[2]=new JXG.Coords(JXG.COORDS_BY_USER,[e[1]+(q/A)*z-(p/A)*w,e[2]+(q/A)*w+(p/A)*z],this.board)}else{return[0]}return d}}};JXG.Algebra.prototype.projectPointToCircle=function(b,g){var h=b.coords.distance(JXG.COORDS_BY_USER,g.midpoint.coords),e=b.coords.usrCoords,l=g.midpoint.coords.usrCoords,a,k,d;if(Math.abs(h)<this.eps){h=this.eps}d=g.getRadius()/h;a=l[1]+d*(e[1]-l[1]);k=l[2]+d*(e[2]-l[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[a,k],this.board)};JXG.Algebra.prototype.projectPointToLine=function(a,d){var b=this.innerProduct(a.coords.usrCoords,d.stdform,3)/this.innerProduct(d.stdform,d.stdform,3),g,e=[];for(g=0;g<3;g++){e[g]=a.coords.usrCoords[g]-b*d.stdform[g]}return new JXG.Coords(JXG.COORDS_BY_USER,e,this.board)};JXG.Algebra.prototype.projectPointToCurve=function(d,g){var b=d.X(),h=d.Y(),e=d.position||0,a=this.projectCoordsToCurve(b,h,e,g);d.position=a[1];return a[0]};JXG.Algebra.prototype.projectCoordsToCurve=function(p,m,w,e){var u,d,s,b,o,q,g,h,k,a,l=1000000;if(e.curveType=="parameter"||e.curveType=="polar"){w=JXG.Math.Numerics.root(JXG.Math.Numerics.D(function(z){return(p-e.X(z))*(p-e.X(z))+(m-e.Y(z))*(m-e.Y(z))}),w);if(w<e.minX()){w=e.maxX()+w-e.minX()}if(w>e.maxX()){w=e.minX()+w-e.maxX()}u=new JXG.Coords(JXG.COORDS_BY_USER,[e.X(w),e.Y(w)],this.board)}else{if(e.curveType=="plot"){h=l;for(g=0;g<e.numberPoints;g++){d=p-e.X(g);s=m-e.Y(g);k=Math.sqrt(d*d+s*s);if(k<h){h=k;w=g}if(g==e.numberPoints-1){continue}b=e.X(g+1)-e.X(g);o=e.Y(g+1)-e.Y(g);q=b*b+o*o;if(q>=JXG.Math.eps){a=(d*b+s*o)/q;k=Math.sqrt(d*d+s*s-a*(d*b+s*o))}else{a=0;k=Math.sqrt(d*d+s*s)}if(a>=0&&a<=1&&k<h){w=g+a;h=k}}g=Math.floor(w);a=w-g;if(g<e.numberPoints-1){p=a*e.X(g+1)+(1-a)*e.X(g);m=a*e.Y(g+1)+(1-a)*e.Y(g)}else{p=e.X(g);m=e.Y(g)}u=new JXG.Coords(JXG.COORDS_BY_USER,[p,m],this.board)}else{w=p;p=w;m=e.Y(w);u=new JXG.Coords(JXG.COORDS_BY_USER,[p,m],this.board)}}return[e.updateTransform(u),w]};JXG.Algebra.prototype.projectPointToTurtle=function(o,s){var q,u,m,l,d,p=0,h=0,e=1000000,k,a,b,g=s.objects.length;for(d=0;d<g;d++){a=s.objects[d];if(a.type==JXG.OBJECT_TYPE_CURVE){q=this.projectPointToCurve(o,a);k=this.distance(q.usrCoords,o.coords.usrCoords);if(k<e){m=q.usrCoords[1];l=q.usrCoords[2];u=o.position;e=k;b=a;h=p}p+=a.numberPoints}}q=new JXG.Coords(JXG.COORDS_BY_USER,[m,l],this.board);o.position=u+h;return b.updateTransform(q)};JXG.Algebra.prototype.replacePow=function(d){var k,o,l,h,m,e,a,b,g,s,q;g=d.indexOf("^");while(g>=0){b=d.slice(0,g);if(b.charAt(b.length-1)==")"){k=1;o=b.length-2;while(o>=0&&k>0){l=b.charAt(o);if(l==")"){k++}else{if(l=="("){k--}}o--}if(k==0){h="";e=b.substring(0,o+1);a=o;while(a>=0&&e.substr(a,1).match(/(\w+)/)){h=RegExp.$1+h;a--}h+=b.substring(o+1,b.length);h=h.replace(/([\(\)\+\*\%\^\-\/\]\[])/g,"\\$1")}}else{h="\\w+"}s=d.slice(g+1);if(s.match(/^([\w\.]*\()/)){k=1;o=RegExp.$1.length;while(o<s.length&&k>0){l=s.charAt(o);if(l==")"){k--}else{if(l=="("){k++}}o++}if(k==0){m=s.substring(0,o);m=m.replace(/([\(\)\+\*\%\^\-\/\[\]])/g,"\\$1")}}else{m="[\\w\\.]+"}q=new RegExp("("+h+")\\^("+m+")");d=d.replace(q,"this.board.algebra.pow($1,$2)");g=d.indexOf("^")}return d};JXG.Algebra.prototype.replaceIf=function(b){var w="",d,u,g=null,a=null,l=null,e,q,h,m,k,o,p;e=b.indexOf("If(");if(e<0){return b}b=b.replace(/""/g,"0");while(e>=0){d=b.slice(0,e);u=b.slice(e+3);h=1;q=0;m=-1;k=-1;while(q<u.length&&h>0){o=u.charAt(q);if(o==")"){h--}else{if(o=="("){h++}else{if(o==","&&h==1){if(m<0){m=q}else{k=q}}}}q++}p=u.slice(0,q-1);u=u.slice(q);if(m<0){return""}if(k<0){return""}g=p.slice(0,m);a=p.slice(m+1,k);l=p.slice(k+1);g=this.replaceIf(g);a=this.replaceIf(a);l=this.replaceIf(l);w+=d+"(("+g+")?("+a+"):("+l+"))";b=u;g=null;a=null;e=b.indexOf("If(")}w+=u;return w};JXG.Algebra.prototype.replaceSub=function(d){if(d.indexOf){}else{return d}var b=d.indexOf("_{"),a;while(b>=0){d=d.substr(0,b)+d.substr(b).replace(/_\{/,"<sub>");a=d.substr(b).indexOf("}");if(a>=0){d=d.substr(0,a)+d.substr(a).replace(/\}/,"</sub>")}b=d.indexOf("_{")}b=d.indexOf("_");while(b>=0){d=d.substr(0,b)+d.substr(b).replace(/_(.?)/,"<sub>$1</sub>");b=d.indexOf("_")}return d};JXG.Algebra.prototype.replaceSup=function(d){if(d.indexOf){}else{return d}var b=d.indexOf("^{"),a;while(b>=0){d=d.substr(0,b)+d.substr(b).replace(/\^\{/,"<sup>");a=d.substr(b).indexOf("}");if(a>=0){d=d.substr(0,a)+d.substr(a).replace(/\}/,"</sup>")}b=d.indexOf("^{")}b=d.indexOf("^");while(b>=0){d=d.substr(0,b)+d.substr(b).replace(/\^(.?)/,"<sup>$1</sup>");b=d.indexOf("^")}return d};JXG.Algebra.prototype.replaceNameById=function(b){var g=0,a,e,d;g=b.indexOf("X(");while(g>=0){if(g>=0){a=b.indexOf(")",g+2);if(a>=0){e=b.slice(g+2,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+2)+d.id+b.slice(a)}}a=b.indexOf(")",g+2);g=b.indexOf("X(",a)}g=b.indexOf("Y(");while(g>=0){if(g>=0){a=b.indexOf(")",g+2);if(a>=0){e=b.slice(g+2,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+2)+d.id+b.slice(a)}}a=b.indexOf(")",g+2);g=b.indexOf("Y(",a)}g=b.indexOf("L(");while(g>=0){if(g>=0){a=b.indexOf(")",g+2);if(a>=0){e=b.slice(g+2,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+2)+d.id+b.slice(a)}}a=b.indexOf(")",g+2);g=b.indexOf("L(",a)}g=b.indexOf("Dist(");while(g>=0){if(g>=0){a=b.indexOf(",",g+5);if(a>=0){e=b.slice(g+5,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+5)+d.id+b.slice(a)}}a=b.indexOf(",",g+5);g=b.indexOf(",",a);a=b.indexOf(")",g+1);if(a>=0){e=b.slice(g+1,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+1)+d.id+b.slice(a)}a=b.indexOf(")",g+1);g=b.indexOf("Dist(",a)}g=b.indexOf("Deg(");while(g>=0){if(g>=0){a=b.indexOf(",",g+4);if(a>=0){e=b.slice(g+4,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+4)+d.id+b.slice(a)}}a=b.indexOf(",",g+4);g=b.indexOf(",",a);a=b.indexOf(",",g+1);if(a>=0){e=b.slice(g+1,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+1)+d.id+b.slice(a)}a=b.indexOf(",",g+1);g=b.indexOf(",",a);a=b.indexOf(")",g+1);if(a>=0){e=b.slice(g+1,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+1)+d.id+b.slice(a)}a=b.indexOf(")",g+1);g=b.indexOf("Deg(",a)}g=b.indexOf("Rad(");while(g>=0){if(g>=0){a=b.indexOf(",",g+4);if(a>=0){e=b.slice(g+4,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+4)+d.id+b.slice(a)}}a=b.indexOf(",",g+4);g=b.indexOf(",",a);a=b.indexOf(",",g+1);if(a>=0){e=b.slice(g+1,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+1)+d.id+b.slice(a)}a=b.indexOf(",",g+1);g=b.indexOf(",",a);a=b.indexOf(")",g+1);if(a>=0){e=b.slice(g+1,a);e=e.replace(/\\(['"])?/g,"$1");d=this.board.elementsByName[e];b=b.slice(0,g+1)+d.id+b.slice(a)}a=b.indexOf(")",g+1);g=b.indexOf("Rad(",a)}return b};JXG.Algebra.prototype.replaceIdByObj=function(a){var b=/(X|Y|L)\(([\w_]+)\)/g;a=a.replace(b,'this.board.objects["$2"].$1()');b=/(Dist)\(([\w_]+),([\w_]+)\)/g;a=a.replace(b,'this.board.objects["$2"].Dist(this.board.objects["$3"])');b=/(Deg)\(([\w_]+),([ \w\[\w_]+),([\w_]+)\)/g;a=a.replace(b,'this.board.algebra.trueAngle(this.board.objects["$2"],this.board.objects["$3"],this.board.objects["$4"])');b=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g;a=a.replace(b,'this.board.algebra.rad(this.board.objects["$1"],this.board.objects["$2"],this.board.objects["$3"])');return a};JXG.Algebra.prototype.geonext2JS=function(b){var e,d,a,h=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Floor","Log","Max","Min","Pow","Random","Round","Sin","Sqrt","Tan","Trunc"],g=["Math.abs","Math.acos","Math.asin","Math.atan","Math.ceil","Math.cos","Math.exp","Math.floor","Math.log","Math.max","Math.min","Math.pow","Math.random","this.board.round","Math.sin","Math.sqrt","Math.tan","Math.ceil"];b=b.replace(/&lt;/g,"<");b=b.replace(/&gt;/g,">");b=b.replace(/&amp;/g,"&");d=b;d=this.replaceNameById(d);d=this.replaceIf(d);d=this.replacePow(d);d=this.replaceIdByObj(d);for(a=0;a<h.length;a++){e=new RegExp(h[a],"g");d=d.replace(e,g[a])}d=d.replace(/True/g,"true");d=d.replace(/False/g,"false");d=d.replace(/fasle/g,"false");d=d.replace(/Pi/g,"Math.PI");return d};JXG.Algebra.prototype.findDependencies=function(e,b){var g=this.board.elementsByName,d,h,a;for(d in g){if(d!=e.name){if(g[d].type==JXG.OBJECT_TYPE_TEXT){if(!g[d].isLabel){a=d.replace(/\[/g,"\\[");a=a.replace(/\]/g,"\\]");h=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+a+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(b.search(h)>=0){g[d].addChild(e)}}}else{a=d.replace(/\[/g,"\\[");a=a.replace(/\]/g,"\\]");h=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+a+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(b.search(h)>=0){g[d].addChild(e)}}}}};JXG.Algebra.prototype.distance=function(g,e){var d=0,b,a;if(g.length!=e.length){return}a=g.length;for(b=0;b<a;b++){d+=(g[b]-e[b])*(g[b]-e[b])}return Math.sqrt(d)};JXG.Algebra.prototype.affineDistance=function(b,a){var e;if(b.length!=a.length){return}e=this.distance(b,a);if(e>this.eps&&(Math.abs(b[0])<this.eps||Math.abs(a[0])<this.eps)){return Infinity}else{return e}};JXG.Algebra.prototype.str2Bool=function(a){if(a==undefined||a==null){return true}if(typeof a=="boolean"){return a}if(a.toLowerCase()!="true"){return false}else{return true}};JXG.Algebra.prototype.pow=function(e,d){if(e==0||d==0){return 1}if(Math.floor(d)==d){return Math.pow(e,d)}else{if(e>0){return Math.exp(d*Math.log(Math.abs(e)))}else{return NaN}}};JXG.Algebra.prototype.crossProduct=function(b,a){return[b[1]*a[2]-b[2]*a[1],b[2]*a[0]-b[0]*a[2],b[0]*a[1]-b[1]*a[0]]};JXG.Algebra.prototype.innerProduct=function(e,d,k){var g,h=0;if(typeof k=="undefined"){k=e.length}for(g=0;g<k;g++){h+=e[g]*d[g]}return h};JXG.Algebra.prototype.meet=function(e,b,d){var a=this.eps;if(Math.abs(e[3])<a&&Math.abs(b[3])<a){return this.meetLineLine(e,b,d)}else{if(Math.abs(e[3])>=a&&Math.abs(b[3])<a){return this.meetLineCircle(b,e,d)}else{if(Math.abs(e[3])<a&&Math.abs(b[3])>=a){return this.meetLineCircle(e,b,d)}else{return this.meetCircleCircle(e,b,d)}}}};JXG.Algebra.prototype.meetLineLine=function(b,a,d){var e=this.crossProduct(b,a);if(Math.abs(e[0])>this.eps){e[1]/=e[0];e[2]/=e[0];e[0]=1}return new JXG.Coords(JXG.COORDS_BY_USER,e,this.board)};JXG.Algebra.prototype.meetLineCircle=function(m,e,q){var z,w,u,s,o,l,h,g,p,D;if(e[4]<this.eps){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(1,3),this.board)}u=e[0];w=e.slice(1,3);z=e[3];s=m[0];o=m.slice(1,3);l=z;h=(w[0]*o[1]-w[1]*o[0]);g=z*s*s-(w[0]*o[0]+w[1]*o[1])*s+u;p=h*h-4*l*g;if(p>=0){p=Math.sqrt(p);D=[(-h+p)/(2*l),(-h-p)/(2*l)];return((q==0)?new JXG.Coords(JXG.COORDS_BY_USER,[-D[0]*(-o[1])-s*o[0],-D[0]*o[0]-s*o[1]],this.board):new JXG.Coords(JXG.COORDS_BY_USER,[-D[1]*(-o[1])-s*o[0],-D[1]*o[0]-s*o[1]],this.board))}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],this.board)}};JXG.Algebra.prototype.meetCircleCircle=function(d,a,b){var e;if(d[4]<this.eps){if(this.distance(d.slice(1,3),a.slice(1,3))==a[4]){return new JXG.Coords(JXG.COORDS_BY_USER,d.slice(1,3),this.board)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],this.board)}}if(a[4]<this.eps){if(this.distance(a.slice(1,3),d.slice(1,3))==d[4]){return new JXG.Coords(JXG.COORDS_BY_USER,a.slice(1,3),this.board)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],this.board)}}e=[a[3]*d[0]-d[3]*a[0],a[3]*d[1]-d[3]*a[1],a[3]*d[2]-d[3]*a[2],0,1,Infinity,Infinity,Infinity];e=this.normalize(e);return this.meetLineCircle(e,d,b)};JXG.Algebra.prototype.normalize=function(d){var a=2*d[3],e=d[4]/(a),g,b;d[5]=e;d[6]=-d[1]/a;d[7]=-d[2]/a;if(e==Infinity||isNaN(e)){g=Math.sqrt(d[1]*d[1]+d[2]*d[2]);d[0]/=g;d[1]/=g;d[2]/=g;d[3]=0;d[4]=1}else{if(Math.abs(e)>=1){d[0]=(d[6]*d[6]+d[7]*d[7]-e*e)/(2*e);d[1]=-d[6]/e;d[2]=-d[7]/e;d[3]=1/(2*e);d[4]=1}else{b=(e<=0)?(-1):(1);d[0]=b*(d[6]*d[6]+d[7]*d[7]-e*e)*0.5;d[1]=-b*d[6];d[2]=-b*d[7];d[3]=b/2;d[4]=b*e}}return d};JXG.Algebra.prototype.meetCurveCurve=function(w,u,h,m){var o=0,q,p,H,E,C,B,g,A,z,s,G,D,l,k;if(arguments.callee.t1memo){q=arguments.callee.t1memo;p=arguments.callee.t2memo}else{q=h;p=m}if(q>w.maxX()){q=w.maxX()}if(q<w.minX()){q=w.minX()}if(p>u.maxX()){p=u.maxX()}if(p<u.minX()){p=u.minX()}A=w.X(q)-u.X(p);z=w.Y(q)-u.Y(p);s=A*A+z*z;G=w.board.D(w.X,w);D=u.board.D(u.X,u);l=w.board.D(w.Y,w);k=u.board.D(u.Y,u);while(s>JXG.Math.eps&&o<10){H=G(q);E=-D(p);C=l(q);B=-k(p);g=H*B-E*C;q-=(B*A-E*z)/g;p-=(H*z-C*A)/g;A=w.X(q)-u.X(p);z=w.Y(q)-u.Y(p);s=A*A+z*z;o++}arguments.callee.t1memo=q;arguments.callee.t2memo=p;if(Math.abs(q)<Math.abs(p)){return(new JXG.Coords(JXG.COORDS_BY_USER,[w.X(q),w.Y(q)],this.board))}else{return(new JXG.Coords(JXG.COORDS_BY_USER,[u.X(p),u.Y(p)],this.board))}};JXG.Intersection=function(g,b,e,d,k,h,p,o){this.constructor();this.board=g;this.id=b;this.name=this.id;this.visProp={};this.visProp.visible=true;this.show=true;this.real=true;this.notExistingParents={};this.intersect1=JXG.getReference(this.board,e);this.intersect2=JXG.getReference(this.board,d);this.type=JXG.OBJECT_TYPE_INTERSECTION;if(((this.intersect1=="")||(this.intersect1==undefined))&&((this.intersect2=="")||(this.intersect2==undefined))){return}if(((this.intersect1.type==this.intersect2.type)&&(this.intersect1.type==JXG.OBJECT_TYPE_LINE||this.intersect1.type==JXG.OBJECT_TYPE_ARROW))||((this.intersect1.type==JXG.OBJECT_TYPE_LINE)&&(this.intersect2.type==JXG.OBJECT_TYPE_ARROW))||((this.intersect2.type==JXG.OBJECT_TYPE_LINE)&&(this.intersect1.type==JXG.OBJECT_TYPE_ARROW))){var l=this.board.algebra.intersectLineLine(this.intersect1,this.intersect2).usrCoords.slice(1);this.p=new JXG.Point(this.board,l,k,p,true);this.p.fixed=true;this.addChild(this.p);this.real=true;this.update=function(){if(this.needsUpdate){this.p.coords=this.board.algebra.intersectLineLine(this.intersect1,this.intersect2);this.needsUpdate=false}};this.hideElement=function(){this.visProp.visible=false;this.p.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p.showElement()};this.hideChild=function(s){this.notExistingParents[s]=this.board.objects[s];for(var q in this.descendants){if(this.descendants[q].visProp.visible&&this.descendants[q].type!=JXG.OBJECT_TYPE_INTERSECTION){if(this.descendants[q].type!=JXG.OBJECT_TYPE_TEXT){this.descendants[q].hideElement();this.descendants[q].visProp.visible=true}else{if(!this.descendants[q].isLabel){this.descendants[q].hideElement();this.descendants[q].visProp.visible=true}}}this.descendants[q].notExistingParents[s]=this.board.objects[s]}};this.showChild=function(s){for(var q in this.board.objects){delete (this.board.objects[q].notExistingParents[s]);if(this.board.objects[q].visProp.visible&&JXG.keys(this.board.objects[q].notExistingParents).length==0){if(this.board.objects[q].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[q].showElement()}}}}}else{if(((e.type==d.type)&&(e.type==JXG.OBJECT_TYPE_CIRCLE||e.type==JXG.OBJECT_TYPE_ARC))||(e.type==JXG.OBJECT_TYPE_CIRCLE&&d.type==JXG.OBJECT_TYPE_ARC)||(d.type==JXG.OBJECT_TYPE_CIRCLE&&e.type==JXG.OBJECT_TYPE_ARC)){this.p1=new JXG.Point(this.board,[0,0],k,p,false);this.p1.fixed=true;this.p1.label.content.visProp.visible=true;this.p2=new JXG.Point(this.board,[0,0],h,o,false);this.p2.fixed=true;this.p2.label.content.visProp.visible=true;this.addChild(this.p1);this.addChild(this.p2);var m=this.board.algebra.intersectCircleCircle(this.intersect1,this.intersect2);if(m[0]==1){this.p1.coords=m[1];this.p1.showElement();this.p1.updateRenderer();this.p2.coords=m[2];this.p2.showElement();this.p2.updateRenderer();this.real=true}else{this.real=false}this.update=function(){if(!this.needsUpdate){return}var u=this.board.algebra.intersectCircleCircle(this.intersect1,this.intersect2);var s=this.p1.visProp.visible;var q=this.p2.visProp.visible;if(u[0]==0){if(this.real){this.hideChild(this.id);this.p1.visProp.visible=s;this.p2.visProp.visible=q;this.real=false}}else{this.p1.coords=u[1];this.p2.coords=u[2];if(!this.real){this.showChild(this.id);this.real=true}}this.needsUpdate=false};this.hideElement=function(){this.visProp.visible=false;this.p1.hideElement();this.p2.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p1.showElement();this.p2.showElement()};this.hideChild=function(s){this.notExistingParents[s]=this.board.objects[s];for(var q in this.descendants){if(this.descendants[q].visProp.visible&&this.descendants[q].type!=JXG.OBJECT_TYPE_INTERSECTION){if(this.descendants[q].type!=JXG.OBJECT_TYPE_TEXT){this.descendants[q].hideElement();this.descendants[q].visProp.visible=true}else{if(!this.descendants[q].isLabel){this.descendants[q].hideElement();this.descendants[q].visProp.visible=true}}}this.descendants[q].notExistingParents[s]=this.board.objects[s]}};this.showChild=function(q){for(el in this.board.objects){delete (this.board.objects[el].notExistingParents[q]);if(this.board.objects[el].visProp.visible&&JXG.keys(this.board.objects[el].notExistingParents).length==0){if(this.board.objects[el].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[el].showElement()}}}}}else{this.p1=new JXG.Point(this.board,[0,0],k,p,false);this.p1.fixed=true;this.p1.label.content.visProp.visible=true;this.p2=new JXG.Point(this.board,[0,0],h,o,false);this.p2.fixed=true;this.p2.label.content.visProp.visible=true;this.addChild(this.p1);this.addChild(this.p2);if(this.intersect1.type==JXG.OBJECT_TYPE_LINE||this.intersect1.type==JXG.OBJECT_TYPE_ARROW){var a=this.intersect1;this.intersect1=this.intersect2;this.intersect2=a}var m=this.board.algebra.intersectCircleLine(this.intersect1,this.intersect2);if(m[0]==1){this.p1.coords=m[1];this.p1.showElement();this.p1.update()}else{if(m[0]==2){this.p1.coords=m[1];this.p1.showElement();this.p2.coords=m[2];this.p2.showElement();this.p1.updateRenderer();this.p2.updateRenderer();this.real=true}else{this.real=false}}this.update=function(){if(!this.needsUpdate){return}var u=this.board.algebra.intersectCircleLine(this.intersect1,this.intersect2);var s=this.p1.visProp.visible;var q=this.p2.visProp.visible;if(u[0]==0){if(this.real){this.hideChild(this.id);this.p1.visProp.visible=s;this.p2.visProp.visible=q;this.real=false}}else{if(u[0]==2){this.p1.coords=u[1];this.p2.coords=u[2];if(!this.real){this.showChild(this.id);this.real=true}}}this.needsUpdate=false};this.hideElement=function(){this.visProp.visible=false;this.p1.hideElement();this.p2.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p1.showElement();this.p2.showElement()};this.hideChild=function(s){this.notExistingParents[s]=this.board.objects[s];for(var q in this.descendants){if(this.descendants[q].visProp.visible&&this.descendants[q].type!=JXG.OBJECT_TYPE_INTERSECTION){if(this.descendants[q].type!=JXG.OBJECT_TYPE_TEXT){this.descendants[q].hideElement();this.descendants[q].visProp.visible=true}else{if(!this.descendants[q].isLabel){this.descendants[q].hideElement();this.descendants[q].visProp.visible=true}}}this.descendants[q].notExistingParents[s]=this.board.objects[s]}};this.showChild=function(q){for(el in this.board.objects){delete (this.board.objects[el].notExistingParents[q]);if(this.board.objects[el].visProp.visible&&JXG.keys(this.board.objects[el].notExistingParents).length==0){if(this.board.objects[el].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[el].showElement()}}}}}}this.id=this.board.addIntersection(this)};JXG.Intersection.prototype=new JXG.GeometryElement();JXG.Intersection.prototype.update=function(){return};JXG.Intersection.prototype.hasPoint=function(a,b){return false};JXG.Intersection.prototype.hideChild=function(a){};JXG.Intersection.prototype.showChild=function(a){};JXG.Intersection.prototype.remove=function(){if(this.p!=undefined){this.board.removeObject(this.p)}if(this.p1!=undefined){this.board.removeObject(this.p1)}if(this.p2!=undefined){this.board.removeObject(this.p2)}return};JXG.Intersection.prototype.updateRenderer=function(){};JXG.createPerpendicular=function(k,g,h){var e,a,d,o;g[0]=JXG.getReference(k,g[0]);g[1]=JXG.getReference(k,g[1]);if(JXG.isPoint(g[0])&&g[1].elementClass==JXG.OBJECT_CLASS_LINE){d=g[1];a=g[0]}else{if(JXG.isPoint(g[1])&&g[0].elementClass==JXG.OBJECT_CLASS_LINE){d=g[0];a=g[1]}else{throw ("Can't create perpendicular with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.")}}if(!JXG.isArray(h.id)){h.id=["",""]}if(!JXG.isArray(h.name)){h.name=["",""]}var m=k.createElement("point",[function(){return k.algebra.perpendicular(d,a)[0]}],{fixed:true,name:h.name[1],id:h.id[1]});a.addChild(m);d.addChild(m);var b=k.createElement("segment",[function(){return(k.algebra.perpendicular(d,a)[1]?[m,a]:[a,m])}],{name:h.name[0],id:h.id[0]});e=[b,m];o=e[1];o.generatePolynomial=function(){var p=d.point1.symbolic.x;var l=d.point1.symbolic.y;var A=d.point2.symbolic.x;var z=d.point2.symbolic.y;var C=a.symbolic.x;var B=a.symbolic.y;var u=o.symbolic.x;var q=o.symbolic.y;var w="("+l+")*("+u+")-("+l+")*("+A+")+("+q+")*("+A+")-("+p+")*("+q+")+("+p+")*("+z+")-("+u+")*("+z+")";var s="("+B+")*("+l+")-("+B+")*("+z+")-("+q+")*("+l+")+("+q+")*("+z+")+("+C+")*("+p+")-("+C+")*("+A+")-("+u+")*("+p+")+("+u+")*("+A+")";return[w,s]};return e};JXG.createMidpoint=function(h,l,k){var e,d,g;if(l.length==2&&JXG.isPoint(l[0])&&JXG.isPoint(l[1])){e=l[0];d=l[1]}else{if(l.length==1&&l[0].type==JXG.OBJECT_TYPE_LINE){e=l[0].point1;d=l[0].point2}else{throw ("Can't create midpoint.")}}if(k){k.fixed=true}else{k={fixed:true}}g=h.createElement("point",[function(){return(e.coords.usrCoords[1]+d.coords.usrCoords[1])/2},function(){return(e.coords.usrCoords[2]+d.coords.usrCoords[2])/2}],k);e.addChild(g);d.addChild(g);g.generatePolynomial=function(){var m=e.symbolic.x;var b=e.symbolic.y;var p=d.symbolic.x;var o=d.symbolic.y;var s=g.symbolic.x;var q=g.symbolic.y;var a="("+b+")*("+s+")-("+b+")*("+p+")+("+q+")*("+p+")-("+m+")*("+q+")+("+m+")*("+o+")-("+s+")*("+o+")";var u="("+m+")^2 - 2*("+m+")*("+s+")+("+b+")^2-2*("+b+")*("+q+")-("+p+")^2+2*("+p+")*("+s+")-("+o+")^2+2*("+o+")*("+q+")";return[a,u]};return g};JXG.createParallel=function(a,d,b){if(JXG.isPoint(d[0])&&d[1].type==JXG.OBJECT_TYPE_LINE){return a.addParallel(d[1],d[0],b.id,b.name)}else{if(JXG.isPoint(d[1])&&d[0].type==JXG.OBJECT_TYPE_LINE){return a.addParallel(d[0],d[1],b.id,b.name)}else{throw ("Can't create parallel with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}}};JXG.createNormal=function(d,b,a){var k;var l;if(b.length==1){k=b[0];l=k.slideObject}else{if(b.length==2){if(JXG.isPoint(b[0])){k=b[0];l=b[1]}else{if(JXG.isPoint(b[1])){l=b[0];k=b[1]}else{throw ("Can't create normal with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"'.")}}}else{throw ("Can't create normal with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"'.")}}if(l.elementClass==JXG.OBJECT_CLASS_LINE){return d.createElement("line",[function(){return l.stdform[1]*k.Y()-l.stdform[2]*k.X()},function(){return l.stdform[2]*k.Z()},function(){return -l.stdform[1]*k.Z()}],a)}else{if(l.elementClass==JXG.OBJECT_CLASS_CIRCLE){return d.createElement("line",[l.midpoint,k],a)}else{if(l.elementClass==JXG.OBJECT_CLASS_CURVE){if(l.curveType!="plot"){var e=l.X;var h=l.Y;return d.createElement("line",[function(){return -k.X()*d.D(e)(k.position)-k.Y()*d.D(h)(k.position)},function(){return d.D(e)(k.position)},function(){return d.D(h)(k.position)}],a)}else{return d.createElement("line",[function(){var m=Math.floor(k.position);var g=k.position-m;if(m==l.numberPoints-1){m--;g=1}if(m<0){return 1}return(l.Y(m)+g*(l.Y(m+1)-l.Y(m)))*(l.Y(m)-l.Y(m+1))-(l.X(m)+g*(l.X(m+1)-l.X(m)))*(l.X(m+1)-l.X(m))},function(){var g=Math.floor(k.position);if(g==l.numberPoints-1){g--}if(g<0){return 0}return l.X(g+1)-l.X(g)},function(){var g=Math.floor(k.position);if(g==l.numberPoints-1){g--}if(g<0){return 0}return l.Y(g+1)-l.Y(g)}],a)}}else{if(l.type==JXG.OBJECT_TYPE_TURTLE){return d.createElement("line",[function(){var o=Math.floor(k.position);var g=k.position-o;var p,m;for(m=0;m<l.objects.length;m++){p=l.objects[m];if(p.type==JXG.OBJECT_TYPE_CURVE){if(o<p.numberPoints){break}o-=p.numberPoints}}if(o==p.numberPoints-1){o--;g=1}if(o<0){return 1}return(p.Y(o)+g*(p.Y(o+1)-p.Y(o)))*(p.Y(o)-p.Y(o+1))-(p.X(o)+g*(p.X(o+1)-p.X(o)))*(p.X(o+1)-p.X(o))},function(){var m=Math.floor(k.position);var o,g;for(g=0;g<l.objects.length;g++){o=l.objects[g];if(o.type==JXG.OBJECT_TYPE_CURVE){if(m<o.numberPoints){break}m-=o.numberPoints}}if(m==o.numberPoints-1){m--}if(m<0){return 0}return o.X(m+1)-o.X(m)},function(){var m=Math.floor(k.position);var o,g;for(g=0;g<l.objects.length;g++){o=l.objects[g];if(o.type==JXG.OBJECT_TYPE_CURVE){if(m<o.numberPoints){break}m-=o.numberPoints}}if(m==o.numberPoints-1){m--}if(m<0){return 0}return o.Y(m+1)-o.Y(m)}],a)}else{throw ("Can't create normal with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"'.")}}}}};JXG.createBisector=function(a,d,b){if(JXG.isPoint(d[0])&&JXG.isPoint(d[1])&&JXG.isPoint(d[2])){return a.addAngleBisector(d[0],d[1],d[2],b.id,b.name)}else{throw ("Can't create angle bisector with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}};JXG.createAngularBisectorsOfTwoLines=function(h,l,e){var d=JXG.getReference(h,l[0]);var b=JXG.getReference(h,l[1]);var o="";var m="";var k="";var g="";if(e==null){e={}}if(e.id!=null){if(JXG.isArray(e.id)){o=e.id[0];m=e.id[1]}else{o=e.id;m=e.id}}if(e.name!=null){if(JXG.isArray(e.name)){k=e.name[0];g=e.name[1]}else{k=e.name;g=e.name}}e.id=o;e.name=k;var a=h.createElement("line",[function(){var s=Math.sqrt(d.stdform[1]*d.stdform[1]+d.stdform[2]*d.stdform[2]);var q=Math.sqrt(b.stdform[1]*b.stdform[1]+b.stdform[2]*b.stdform[2]);return d.stdform[0]/s-b.stdform[0]/q},function(){var s=Math.sqrt(d.stdform[1]*d.stdform[1]+d.stdform[2]*d.stdform[2]);var q=Math.sqrt(b.stdform[1]*b.stdform[1]+b.stdform[2]*b.stdform[2]);return d.stdform[1]/s-b.stdform[1]/q},function(){var s=Math.sqrt(d.stdform[1]*d.stdform[1]+d.stdform[2]*d.stdform[2]);var q=Math.sqrt(b.stdform[1]*b.stdform[1]+b.stdform[2]*b.stdform[2]);return d.stdform[2]/s-b.stdform[2]/q},],e);e.id=m;e.name=g;var p=h.createElement("line",[function(){var s=Math.sqrt(d.stdform[1]*d.stdform[1]+d.stdform[2]*d.stdform[2]);var q=Math.sqrt(b.stdform[1]*b.stdform[1]+b.stdform[2]*b.stdform[2]);return d.stdform[0]/s+b.stdform[0]/q},function(){var s=Math.sqrt(d.stdform[1]*d.stdform[1]+d.stdform[2]*d.stdform[2]);var q=Math.sqrt(b.stdform[1]*b.stdform[1]+b.stdform[2]*b.stdform[2]);return d.stdform[1]/s+b.stdform[1]/q},function(){var s=Math.sqrt(d.stdform[1]*d.stdform[1]+d.stdform[2]*d.stdform[2]);var q=Math.sqrt(b.stdform[1]*b.stdform[1]+b.stdform[2]*b.stdform[2]);return d.stdform[2]/s+b.stdform[2]/q},],e);return[a,p]};JXG.createArrowParallel=function(a,d,b){if(JXG.isPoint(d[0])&&d[1].type==JXG.OBJECT_TYPE_ARROW){if(!JXG.isArray(b.id)){b.id=["",""]}if(!JXG.isArray(b.name)){b.name=["",""]}return a.addArrowParallel(d[1],d[0],b.id[0],b.name[0],b.id[1],b.name[1])}else{if(JXG.isPoint(d[1])&&d[0].type==JXG.OBJECT_TYPE_ARROW){if(!JXG.isArray(b.id)){b.id=["",""]}if(!JXG.isArray(b.name)){b.name=["",""]}return a.addArrowParallel(d[0],d[1],b.id[0],b.name[0],b.id[1],b.name[1])}else{throw ("Can't create parallel arrow with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}}};JXG.createCircumcircle=function(a,d,b){if(JXG.isPoint(d[0])&&JXG.isPoint(d[1])&&JXG.isPoint(d[2])){if(!JXG.isArray(b.id)){b.id=["",""]}if(!JXG.isArray(b.name)){b.name=["",""]}return a.addCircumcenter(d[0],d[1],d[2],b.id[0],b.name[0],b.id[1],b.name[1])}else{throw ("Can't create circumcircle with parent types '"+(typeof d[0])+"', '"+(typeof d[1])+"' and '"+(typeof d[2])+"'.")}};JXG.createCircumcircleMidpoint=function(a,d,b){if(JXG.isPoint(d[0])&&JXG.isPoint(d[1])&&JXG.isPoint(d[2])){return a.addCircumcenterMidpoint(d[0],d[1],d[2],b.id,b.name)}else{throw ("Can't create circumcircle midpoint with parent types '"+(typeof d[0])+"', '"+(typeof d[1])+"' and '"+(typeof d[2])+"'.")}};JXG.createParallelPoint=function(a,d,b){if(JXG.isPoint(d[0])&&JXG.isPoint(d[1])&&JXG.isPoint(d[2])){return a.addParallelPoint(d[0],d[1],d[2],b.id,b.name)}else{throw ("Can't create parallel point with parent types '"+(typeof d[0])+"', '"+(typeof d[1])+"' and '"+(typeof d[2])+"'.")}};JXG.createReflection=function(a,d,b){if(JXG.isPoint(d[0])&&d[1].type==JXG.OBJECT_TYPE_LINE){return a.addReflection(d[1],d[0],b.id,b.name)}else{if(JXG.isPoint(d[1])&&d[0].type==JXG.OBJECT_TYPE_LINE){return a.addReflection(d[0],d[1],b.id,b.name)}else{throw ("Can't create reflection point with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}}};JXG.createPerpendicularPoint=function(d,h,g){var a,e,b;if(JXG.isPoint(h[0])&&h[1].type==JXG.OBJECT_TYPE_LINE){e=h[0];a=h[1];b=d.addPerpendicularPoint(h[1],h[0],g.id,g.name)}else{if(JXG.isPoint(h[1])&&h[0].type==JXG.OBJECT_TYPE_LINE){e=h[1];a=h[0];b=d.addPerpendicularPoint(h[0],h[1],g.id,g.name)}else{throw ("Can't create perpendicular point with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.")}}b.generatePolynomial=function(){var l=a.point1.symbolic.x;var k=a.point1.symbolic.y;var u=a.point2.symbolic.x;var s=a.point2.symbolic.y;var z=e.symbolic.x;var w=e.symbolic.y;var p=b.symbolic.x;var m=b.symbolic.y;var q=""+k+"*"+p+"-"+k+"*"+u+"+"+m+"*"+u+"-"+l+"*"+m+"+"+l+"*"+s+"-"+p+"*"+s;var o=""+w+"*"+k+"-"+w+"*"+s+"-"+m+"*"+k+"+"+m+"*"+s+"+"+z+"*"+l+"-"+z+"*"+u+"-"+p+"*"+l+"+"+p+"*"+u;return[q,o]};return b};JXG.createMirrorPoint=function(a,d,b){if(JXG.isPoint(d[0])&&JXG.isPoint(d[1])){return a.addRotation(d[0],d[1],Math.PI,b.id,b.name)}else{throw ("Can't create mirror point with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}};JXG.createIntegral=function(a,d,b){if(!JXG.isArray(b.id)||(b.id.length!=5)){b.id=["","","","",""]}if(!JXG.isArray(b.name)||(b.name.length!=5)){b.name=["","","","",""]}if(JXG.isArray(d[0])&&d[1].type==JXG.OBJECT_TYPE_CURVE){return a.addIntegral(d[0],d[1],b.id,b.name,b)}else{if(JXG.isArray(d[1])&&d[0].type==JXG.OBJECT_TYPE_CURVE){return a.addIntegral(d[1],d[0],b.id,b.name,b)}else{throw ("Can't create integral with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}}};JXG.JSXGraph.registerElement("arrowparallel",JXG.createArrowParallel);JXG.JSXGraph.registerElement("bisector",JXG.createBisector);JXG.JSXGraph.registerElement("bisectorlines",JXG.createAngularBisectorsOfTwoLines);JXG.JSXGraph.registerElement("circumcircle",JXG.createCircumcircle);JXG.JSXGraph.registerElement("circumcirclemidpoint",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("integral",JXG.createIntegral);JXG.JSXGraph.registerElement("midpoint",JXG.createMidpoint);JXG.JSXGraph.registerElement("mirrorpoint",JXG.createMirrorPoint);JXG.JSXGraph.registerElement("normal",JXG.createNormal);JXG.JSXGraph.registerElement("parallel",JXG.createParallel);JXG.JSXGraph.registerElement("parallelpoint",JXG.createParallelPoint);JXG.JSXGraph.registerElement("perpendicular",JXG.createPerpendicular);JXG.JSXGraph.registerElement("perpendicularpoint",JXG.createPerpendicularPoint);JXG.JSXGraph.registerElement("reflection",JXG.createReflection);JXG.Text=function(l,p,h,o,d,a,e,m){this.constructor();this.type=JXG.OBJECT_TYPE_TEXT;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.init(l,d,a);this.contentStr=p;this.plaintextStr="";if((typeof m!="undefined")&&(m!=null)){this.isLabel=m}else{this.isLabel=false}this.visProp.strokeColor=this.board.options.text.strokeColor;this.visProp.visible=true;if(e!=null){this.digits=e}else{this.digits=2}if((this.element=this.board.objects[h])){var g;this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[parseFloat(o[0]),parseFloat(o[1])],this.board);if(!this.isLabel){g=this.element.getTextAnchor()}else{g=this.element.getLabelAnchor()}this.element.addChild(this);this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.relativeCoords.usrCoords[1]+g.usrCoords[1],this.relativeCoords.usrCoords[2]+g.usrCoords[2]],this.board)}else{this.X=JXG.createFunction(o[0],this.board,"");this.Y=JXG.createFunction(o[1],this.board,"");this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);var k="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);";this.updateCoords=new Function("",k)}if(typeof this.contentStr=="function"){this.updateText=function(){this.plaintextStr=this.contentStr()}}else{var b;if(typeof this.contentStr=="number"){b=(this.contentStr).toFixed(this.digits)}else{b=this.generateTerm(this.contentStr)}this.updateText=new Function("this.plaintextStr = "+b+";")}if(!this.isLabel){this.id=this.board.addText(this)}if(typeof this.contentStr=="string"){this.notifyParents(this.contentStr)}};JXG.Text.prototype=new JXG.GeometryElement();JXG.Text.prototype.hasPoint=function(a,b){return false};JXG.Text.prototype.setText=function(b){var a;if(typeof b=="number"){a=(b).toFixed(this.digits)}else{a=this.generateTerm(b)}this.updateText=new Function("this.plaintextStr = "+a+";");this.updateText();return this};JXG.Text.prototype.setCoords=function(a,b){this.X=function(){return a};this.Y=function(){return b};this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[a,b],this.board);return this};JXG.Text.prototype.update=function(){if(this.needsUpdate){if(this.relativeCoords){var a;if(!this.isLabel){a=this.element.getTextAnchor()}else{a=this.element.getLabelAnchor()}this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.relativeCoords.usrCoords[1]+a.usrCoords[1],this.relativeCoords.usrCoords[2]+a.usrCoords[2]])}else{this.updateCoords()}this.updateText()}return this};JXG.Text.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateText(this);this.needsUpdate=false}return this};JXG.Text.prototype.generateTerm=function(g){var e=null;var k=this.board.elementsByName;var h='""';g=g.replace(/\r/g,"");g=g.replace(/\n/g,"");g=g.replace(/\"/g,'\\"');g=g.replace(/\'/g,"\\'");g=g.replace(/&amp;arc;/g,"&ang;");g=g.replace(/<arc\s*\/>/g,"&ang;");g=g.replace(/<sqrt\s*\/>/g,"&radic;");var d;d=g.indexOf("<value>");var a=g.indexOf("</value>");if(d>=0){while(d>=0){h+=' + "'+this.board.algebra.replaceSub(this.board.algebra.replaceSup(g.slice(0,d)))+'"';var b=g.slice(d+7,a);var e=this.board.algebra.geonext2JS(b);e=e.replace(/\\"/g,'"');e=e.replace(/\\'/g,"'");if(e.indexOf("toFixed")<0){h+="+("+e+").toFixed("+(this.digits)+")"}else{h+="+("+e+")"}g=g.slice(a+8);d=g.indexOf("<value>");a=g.indexOf("</value>")}}h+=' + "'+this.board.algebra.replaceSub(this.board.algebra.replaceSup(g))+'"';h=h.replace(/<overline>/g,"<span style=text-decoration:overline>");h=h.replace(/<\/overline>/g,"</span>");h=h.replace(/<arrow>/g,"<span style=text-decoration:overline>");h=h.replace(/<\/arrow>/g,"</span>");h=h.replace(/&amp;/g,"&");return h};JXG.Text.prototype.notifyParents=function(d){var b=null;var e=this.board.elementsByName;do{var a=/<value>([\w\s\*\/\^\-\+\(\)\[\],<>=!]+)<\/value>/;b=a.exec(d);if(b!=null){this.board.algebra.findDependencies(this,b[1]);d=d.substr(b.index);d=d.replace(a,"")}}while(b!=null);return this};JXG.createText=function(a,d,b){return new JXG.Text(a,d[d.length-1],null,d,b.id,b.name,b.digits,false)};JXG.JSXGraph.registerElement("text",JXG.createText);JXG.Image=function(g,e,k,b,h,l,a,d){this.type=JXG.OBJECT_TYPE_IMAGE;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.transformations=[];this.init(g,l,a);this.coords=new JXG.Coords(JXG.COORDS_BY_USER,k,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,k,this.board);this.size=[b[0]*g.stretchX,b[1]*g.stretchY];this.imageBase64String=e;this.displayLevel=h;this.parent=d;this.visProp.visible=true;this.id=this.board.addImage(this)};JXG.Image.prototype=new JXG.GeometryElement;JXG.Image.prototype.hasPoint=function(a,b){return false};JXG.Image.prototype.updateRenderer=function(){this.updateTransform();this.board.renderer.updateImage(this)};JXG.Image.prototype.updateTransform=function(){if(this.transformations.length==0){return}for(var a=0;a<this.transformations.length;a++){this.transformations[a].update()}};JXG.Image.prototype.addTransform=function(a){if(JXG.isArray(a)){for(var b=0;b<a.length;b++){this.transformations.push(a[b])}}else{this.transformations.push(a)}};JXG.createImage=function(a,d,b){return new JXG.Image(a,b.imageString,d[0],d[1],"images",false,false,undefined)};JXG.JSXGraph.registerElement("image",JXG.createImage);JXG.createSlider=function(o,B,w){var k,h,C,l,D,p,d,b,A,E,m,g,e,a,z,u,q,s;k=B[0];h=B[1];C=B[2][0];l=B[2][1];D=B[2][2];p=D-C;if(w==null){w={}}if(w.strokeColor==null||typeof w.strokeColor=="undefined"){w.strokeColor="#000000"}if(w.fillColor==null||typeof w.fillColor=="undefined"){w.fillColor="#ffffff"}d=o.createElement("point",k,{visible:false,fixed:true,name:"",withLabel:false});b=o.createElement("point",h,{visible:false,fixed:true,name:"",withLabel:false});A=o.createElement("line",[d,b],{straightFirst:false,straightLast:false,strokewidth:1,name:"",withLabel:false,strokeColor:w.strokeColor});E=2;m=o.createElement("ticks",[A,b.Dist(d)/E],{insertTicks:true,drawLabels:false,drawZero:true});d.needsRegularUpdate=false;b.needsRegularUpdate=false;A.needsRegularUpdate=false;g=k[0]+(h[0]-k[0])*(l-C)/(D-C);e=k[1]+(h[1]-k[1])*(l-C)/(D-C);if(w.snapWidth!=null){s=w.snapWidth}if(w.snapwidth!=null){s=w.snapwidth}a=o.createElement("glider",[g,e,A],{style:6,strokeColor:w.strokeColor,fillColor:w.fillColor,showInfobox:false,name:"",snapWidth:s});z=o.createElement("line",[d,a],{straightFirst:false,straightLast:false,strokewidth:3,strokeColor:w.strokeColor,name:"",withLabel:false});a.Value=function(){return this.position*p+C};a._smax=D;a._smin=C;if(w.name&&w.name!=""){u=w.name+" = "}else{u=""}q=o.createElement("text",[((h[0]-k[0])*0.05+h[0]),((h[1]-k[1])*0.05+h[1]),function(){return u+(a.Value()).toFixed(2)}],{name:""});return a};JXG.JSXGraph.registerElement("slider",JXG.createSlider);JXG.Chart=function(k,o,e){this.constructor();if(o.length==0){return}this.elements=[];var d=e.id||"";var b=e.name||"";this.init(k,d,b);var p,m,g;if(o.length>0&&(typeof o[0]=="number")){m=o;p=[];for(g=0;g<m.length;g++){p[g]=g+1}}else{if(o.length==1){m=o[0];p=[];var h;if(JXG.isFunction(m)){h=m().length}else{h=m.length}for(g=0;g<h;g++){p[g]=g+1}}if(o.length==2){p=o[0];m=o[1]}}if(e==undefined){e={}}var a=e.chartStyle||"line";a=a.replace(/ /g,"");a=a.split(",");var l;for(g=0;g<a.length;g++){switch(a[g]){case"bar":l=this.drawBar(k,[p,m],e);break;case"line":l=this.drawLine(k,[p,m],e);break;case"fit":l=this.drawFit(k,[p,m],e);break;case"spline":l=this.drawSpline(k,[p,m],e);break;case"pie":l=this.drawPie(k,[m],e);break;case"point":l=this.drawPoints(k,[p,m],e);break}this.elements.push(l)}this.id=this.board.addChart(this);return this.elements};JXG.Chart.prototype=new JXG.GeometryElement;JXG.Chart.prototype.drawLine=function(g,e,b){var d=e[0],a=e[1];b.fillColor="none";b.highlightFillColor="none";var h=g.createElement("curve",[d,a],b);this.rendNode=h.rendNode;return h};JXG.Chart.prototype.drawSpline=function(g,d,b){var a=d[0],k=d[1],e;b.fillColor="none";b.highlightFillColor="none";var h=g.createElement("spline",[a,k],b);this.rendNode=h.rendNode;return h};JXG.Chart.prototype.drawFit=function(g,e,d){var a=e[0],l=e[1],h=(((typeof d.degree=="undefined")||(parseInt(d.degree)==NaN)||(parseInt(d.degree)<1))?1:parseInt(d.degree));d.fillColor="none";d.highlightFillColor="none";var b=JXG.Math.Numerics.regressionPolynomial(h,a,l);var k=g.createElement("functiongraph",[b],d);this.rendNode=k.rendNode;return k};JXG.Chart.prototype.drawBar=function(l,o,h){var k,g=[],q=o[0],m=o[1],s,d,B,A,b,a,u,e=[],z;if(h.fillOpacity==undefined){h.fillOpacity=0.6}if(h&&h.width){s=h.width}else{if(q.length<=1){s=1}else{s=q[1]-q[0];for(k=1;k<q.length-1;k++){s=(q[k+1]-q[k]<s)?(q[k+1]-q[k]):s}}s*=0.8}z=h.fillColor;for(k=0;k<q.length;k++){if(JXG.isFunction(q[k])){d=function(){return q[k]()-s*0.5};B=function(){return q[k]()};A=function(){return q[k]()+s*0.5}}else{d=q[k]-s*0.5;B=q[k];A=q[k]+s*0.5}if(JXG.isFunction(m[k])){a=b}else{a=m[k]+0.2}b=m[k];if(h.dir=="horizontal"){e[0]=l.createElement("point",[0,d],{name:"",fixed:true,visible:false});e[1]=l.createElement("point",[b,d],{name:"",fixed:true,visible:false});e[2]=l.createElement("point",[b,A],{name:"",fixed:true,visible:false});e[3]=l.createElement("point",[0,A],{name:"",fixed:true,visible:false});if(h.labels&&h.labels[k]){l.createElement("text",[b,A,h.labels[k]],h)}}else{e[0]=l.createElement("point",[d,0],{name:"",fixed:true,visible:false});e[1]=l.createElement("point",[d,b],{name:"",fixed:true,visible:false});e[2]=l.createElement("point",[A,b],{name:"",fixed:true,visible:false});e[3]=l.createElement("point",[A,0],{name:"",fixed:true,visible:false});if(h.labels&&h.labels[k]){l.createElement("text",[A,b,h.labels[k]],h)}}h.withLines=false;if(typeof z=="undefined"&&z==null){u=h.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];h.fillColor=u[k%u.length]}g[k]=l.createElement("polygon",e,h)}this.rendNode=g[0].rendNode;return g};JXG.Chart.prototype.drawPoints=function(h,d,b){var e;var g=[];b.fixed=true;b.name="";var a=d[0];var k=d[1];for(e=0;e<a.length;e++){g[e]=h.createElement("point",[a[e],k[e]],b)}this.rendNode=g[0].rendNode;return g};JXG.Chart.prototype.drawPie=function(e,D,h){var k=D[0];if(k.length<=0){return}if(typeof k[0]=="function"){return}var C;var z=[];var m=[];var g=[];var o=e.mathStatistics.sum(k);var d=h.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];var G=h.highlightColorArray||["#FF7400"];var A=new Array(k.length);for(C=0;C<k.length;C++){A[C]=""}var q=h.labelArray||A;var b=h.radius||4;var F={};if(typeof h.highlightOnSector=="undefined"){h.highlightOnSector=false}F.name=h.name;F.id=h.id;F.strokeWidth=h.strokeWidth||1;F.strokeColor=h.strokeColor||"none";F.straightFirst=false;F.straightLast=false;F.fillColor=h.fillColor||"#FFFF88";F.fillOpacity=h.fillOpacity||0.6;F.highlightFillColor=h.highlightFillColor||"#FF7400";F.highlightStrokeColor=h.highlightStrokeColor||"#FFFFFF";F.gradient=h.gradient||"none";var w=h.center||[0,0];var B=w[0];var a=w[1];var E=e.createElement("point",[B,a],{name:"",fixed:true,visible:false});z[0]=e.createElement("point",[b+B,0+a],{name:"",fixed:true,visible:false});var H=0;for(C=0;C<k.length;C++){H+=(o!=0)?(2*Math.PI*k[C]/o):0;var l=b*Math.cos(H)+B;var u=b*Math.sin(H)+a;z[C+1]=e.createElement("point",[l,u],{name:"",fixed:true,visible:false,withLabel:false});m[C]=e.createElement("line",[E,z[C]],{strokeColor:F.strokeColor,straightFirst:false,straightLast:false,strokeWidth:F.strokeWidth,strokeOpacity:1,withLabel:false,highlightStrokeColor:F.highlightStrokeColor});F.fillColor=d[C%d.length];F.name=q[C];if(F.name!=""){F.withLabel=true}else{F.withLabel=false}F.labelColor=d[C%d.length];F.highlightfillColor=G[C%G.length];g[C]=e.createElement("arc",[E,z[C],z[C+1]],F);if(h.highlightOnSector){g[C].hasPoint=g[C].hasPointSector}}for(C=0;C<k.length;C++){g[C].additionalLines=[m[C],m[(C+1)%k.length]]}this.rendNode=g[0].rendNode;return{arcs:g,lines:m,points:z,midpoint:E}};JXG.Chart.prototype.updateRenderer=function(){};JXG.Chart.prototype.update=function(){if(this.needsUpdate){this.updateDataArray()}};JXG.Chart.prototype.updateDataArray=function(){};JXG.createChart=function(g,A,h){if((A.length==1)&&(typeof A[0]=="string")){var z=document.getElementById(A[0]),E,e,q,p,d,a,u=[],l,k,D,C,F,m,b,o,B,s;if(typeof z!="undefined"){if(h.withHeader){}else{h.withHeader=true}z=(new JXG.DataSource()).loadFromTable(A[0],h.withHeader,h.withHeader);E=z.data;d=z.columnHeader;e=z.rowHeader;C=h.width;F=h.name;m=h.strokeColor;b=h.fillColor;o=h.highlightStrokeColor;B=h.highlightFillColor;g.suspendUpdate();s=E.length;D=[];if(h.rows&&JXG.isArray(h.rows)){for(q=0;q<s;q++){for(p=0;p<h.rows.length;p++){if((h.rows[p]==q)||(h.withHeaders&&h.rows[p]==e[q])){D.push(E[q]);break}}}}else{D=E}s=D.length;for(q=0;q<s;q++){k=[];if(h.chartStyle&&h.chartStyle.indexOf("bar")!=-1){if(C){l=C}else{l=0.8}k.push(1-l/2+(q+0.5)*l/(1*s));for(p=1;p<D[q].length;p++){k.push(k[p-1]+1)}h.width=l/(1*s)}if(F&&F.length==s){h.name=F[q]}else{if(h.withHeaders){h.name=d[q]}}if(m&&m.length==s){h.strokeColor=m[q]}else{h.strokeColor=JXG.hsv2rgb(((q+1)/(1*s))*360,0.9,0.6)}if(b&&b.length==s){h.fillColor=b[q]}else{h.fillColor=JXG.hsv2rgb(((q+1)/(1*s))*360,0.9,1)}if(o&&o.length==s){h.highlightStrokeColor=o[q]}else{h.highlightStrokeColor=JXG.hsv2rgb(((q+1)/(1*s))*360,0.9,1)}if(B&&B.length==s){h.highlightFillColor=B[q]}else{h.highlightFillColor=JXG.hsv2rgb(((q+1)/(1*s))*360,0.9,0.6)}if(h.chartStyle&&h.chartStyle.indexOf("bar")!=-1){u.push(new JXG.Chart(g,[k,D[q]],h))}else{u.push(new JXG.Chart(g,[D[q]],h))}}g.unsuspendUpdate()}return u}else{return new JXG.Chart(g,A,h)}};JXG.JSXGraph.registerElement("chart",JXG.createChart);JXG.Transformation=function(b,a,d){this.elementClass=JXG.OBJECT_CLASS_OTHER;this.matrix=[[1,0,0],[0,1,0],[0,0,1]];this.board=b;this.isNumericMatrix=false;this.setMatrix(b,a,d)};JXG.Transformation.prototype={};JXG.Transformation.prototype.update=function(){};JXG.Transformation.prototype.setMatrix=function(d,b,e){var a;this.isNumericMatrix=true;for(a=0;a<e.length;a++){if(typeof e[a]!="number"){this.isNumericMatrix=false;break}}if(b=="translate"){this.evalParam=JXG.createEvalFunction(d,e,2);this.update=function(){this.matrix[1][0]=this.evalParam(0);this.matrix[2][0]=this.evalParam(1)}}else{if(b=="scale"){this.evalParam=JXG.createEvalFunction(d,e,2);this.update=function(){this.matrix[1][1]=this.evalParam(0);this.matrix[2][2]=this.evalParam(1)}}else{if(b=="reflect"){if(e.length<4){e[0]=JXG.getReference(d,e[0])}if(e.length==2){e[1]=JXG.getReference(d,e[1])}if(e.length==4){this.evalParam=JXG.createEvalFunction(d,e,4)}this.update=function(){var g,m,h,l,k;if(e.length==1){g=e[0].point2.X()-e[0].point1.X();m=e[0].point2.Y()-e[0].point1.Y();h=e[0].point1.X();l=e[0].point1.Y()}else{if(e.length==2){g=e[1].X()-e[0].X();m=e[1].Y()-e[0].Y();h=e[0].X();l=e[0].Y()}else{if(e.length==4){g=this.evalParam(2)-this.evalParam(0);m=this.evalParam(3)-this.evalParam(1);h=this.evalParam(0);l=this.evalParam(1)}}}k=g*g+m*m;this.matrix[1][1]=(g*g-m*m)/k;this.matrix[1][2]=2*g*m/k;this.matrix[2][1]=2*g*m/k;this.matrix[2][2]=(-g*g+m*m)/k;this.matrix[1][0]=h*(1-this.matrix[1][1])-l*this.matrix[1][2];this.matrix[2][0]=l*(1-this.matrix[2][2])-h*this.matrix[2][1]}}else{if(b=="rotate"){if(e.length==3){this.evalParam=JXG.createEvalFunction(d,e,3)}else{if(e.length<=2){this.evalParam=JXG.createEvalFunction(d,e,1);if(e.length==2){e[1]=JXG.getReference(d,e[1])}}}this.update=function(){var h=this.evalParam(0),g,k;this.matrix[1][1]=Math.cos(h);this.matrix[1][2]=-Math.sin(h);this.matrix[2][1]=Math.sin(h);this.matrix[2][2]=Math.cos(h);if(e.length>1){if(e.length==3){g=this.evalParam(1);k=this.evalParam(2)}else{g=e[1].X();k=e[1].Y()}this.matrix[1][0]=g*(1-Math.cos(h))+k*Math.sin(h);this.matrix[2][0]=k*(1-Math.cos(h))-g*Math.sin(h)}}}else{if(b=="shear"){this.evalParam=JXG.createEvalFunction(d,e,1);this.update=function(){var g=this.evalParam(0);this.matrix[1][1]=Math.tan(g)}}else{if(b=="generic"){this.evalParam=JXG.createEvalFunction(d,e,9);this.update=function(){this.matrix[0][0]=this.evalParam(0);this.matrix[0][1]=this.evalParam(1);this.matrix[0][2]=this.evalParam(2);this.matrix[1][0]=this.evalParam(3);this.matrix[1][1]=this.evalParam(4);this.matrix[1][2]=this.evalParam(5);this.matrix[2][0]=this.evalParam(6);this.matrix[2][1]=this.evalParam(7);this.matrix[2][2]=this.evalParam(8)}}}}}}}};JXG.Transformation.prototype.apply=function(a){this.update();if(arguments[1]!=null){return JXG.Math.matVecMult(this.matrix,a.initialCoords.usrCoords)}else{return JXG.Math.matVecMult(this.matrix,a.coords.usrCoords)}};JXG.Transformation.prototype.applyOnce=function(d){var e,a,b;if(!JXG.isArray(d)){this.update();e=JXG.Math.matVecMult(this.matrix,d.coords.usrCoords);d.coords.setCoordinates(JXG.COORDS_BY_USER,[e[1],e[2]])}else{a=d.length;for(b=0;b<a;b++){this.update();e=JXG.Math.matVecMult(this.matrix,d[b].coords.usrCoords);d[b].coords.setCoordinates(JXG.COORDS_BY_USER,[e[1],e[2]])}}};JXG.Transformation.prototype.bindTo=function(d){var b,a;if(JXG.isArray(d)){a=d.length;for(b=0;b<a;b++){d[b].transformations.push(this)}}else{d.transformations.push(this)}};JXG.Transformation.prototype.setProperty=function(a){};JXG.Transformation.prototype.melt=function(l){var h=[],g,a,e,b,m,d;a=l.matrix.length;e=this.matrix[0].length;for(g=0;g<a;g++){h[g]=[]}this.update();l.update();for(g=0;g<a;g++){for(d=0;d<e;d++){m=0;for(b=0;b<a;b++){m+=l.matrix[g][b]*this.matrix[b][d]}h[g][d]=m}}this.update=function(){var k=this.matrix.length,o=this.matrix[0].length;for(g=0;g<k;g++){for(d=0;d<o;d++){this.matrix[g][d]=h[g][d]}}};return true};JXG.createTransform=function(a,d,b){return new JXG.Transformation(a,b.type,d)};JXG.JSXGraph.registerElement("transform",JXG.createTransform);JXG.Turtle=function(g,e,b){var a,h,d;this.type=JXG.OBJECT_TYPE_TURTLE;this.turtleIsHidden=false;this.board=g;if(b==null){this.attributes={}}else{this.attributes=b}this.attributes.straightFirst=false;this.attributes.straightLast=false;this.attributes.withLabel=false;a=0;h=0;d=90;if(e.length!=0){if(e.length==3){a=e[0];h=e[1];d=e[2]}else{if(e.length==2){if(JXG.isArray(e[0])){a=e[0][0];h=e[0][1];d=e[1]}else{a=e[0];h=e[1]}}else{a=e[0][0];h=e[0][1]}}}this.init(a,h,d);return this};JXG.Turtle.prototype=new JXG.GeometryElement;JXG.Turtle.prototype.init=function(a,e,d){this.arrowLen=20/Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY);this.pos=[a,e];this.isPenDown=true;this.dir=90;this.stack=[];this.objects=[];this.attributes.curveType="plot";this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.turtle=this.board.createElement("point",this.pos,{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle);this.turtle2=this.board.createElement("point",[this.pos[0],this.pos[1]+this.arrowLen],{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle2);var b=this.attributes.strokeWidth||this.attributes.strokewidth||2;this.arrow=this.board.createElement("line",[this.turtle,this.turtle2],{lastArrow:true,strokeColor:"#ff0000",straightFirst:false,straightLast:false,strokeWidth:b,withLabel:false});this.objects.push(this.arrow);this.right(90-d);this.board.update()};JXG.Turtle.prototype.forward=function(a){if(a==0){return}var d=a*Math.cos(this.dir*Math.PI/180);var b=a*Math.sin(this.dir*Math.PI/180);if(!this.turtleIsHidden){var e=this.board.createElement("transform",[d,b],{type:"translate"});e.applyOnce(this.turtle);e.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]+=d;this.pos[1]+=b;if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update();return this};JXG.Turtle.prototype.back=function(a){return this.forward(-a)};JXG.Turtle.prototype.right=function(b){this.dir-=b;this.dir%=360;if(!this.turtleIsHidden){var a=this.board.createElement("transform",[-b*Math.PI/180,this.turtle],{type:"rotate"});a.applyOnce(this.turtle2)}this.board.update();return this};JXG.Turtle.prototype.left=function(a){return this.right(-a)};JXG.Turtle.prototype.penUp=function(){this.isPenDown=false;return this};JXG.Turtle.prototype.penDown=function(){this.isPenDown=true;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.clean=function(){for(var a=0;a<this.objects.length;a++){var b=this.objects[a];if(b.type==JXG.OBJECT_TYPE_CURVE){this.board.removeObject(b.id);this.objects.splice(a,1)}}this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this};JXG.Turtle.prototype.clearScreen=function(){for(var a=0;a<this.objects.length;a++){var b=this.objects[a];this.board.removeObject(b.id)}this.init(0,0,90);return this};JXG.Turtle.prototype.setPos=function(a,d){if(JXG.isArray(a)){this.pos=a}else{this.pos=[a,d]}if(!this.turtleIsHidden){this.turtle.setPositionDirectly(JXG.COORDS_BY_USER,a,d);this.turtle2.setPositionDirectly(JXG.COORDS_BY_USER,a,d+this.arrowLen);var b=this.board.createElement("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"});b.applyOnce(this.turtle2)}this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this};JXG.Turtle.prototype.setPenSize=function(a){this.attributes.strokeWidth=a;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setPenColor=function(a){this.attributes.strokeColor=a;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setHighlightPenColor=function(a){this.attributes.highlightStrokeColor=a;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setProperty=function(){var g;var a;var d,e;var b;for(d=0;d<arguments.length;d++){a=arguments[d];if(typeof a=="string"){g=a.split(":")}else{if(!JXG.isArray(a)){for(var b in a){this.setProperty([b,a[b]])}return this}else{g=a}}this.attributes[g[0]]=g[1]}for(d=0;d<this.objects.length;d++){e=this.objects[d];if(e.type==JXG.OBJECT_TYPE_CURVE){e.setProperty(this.attributes)}}return this};JXG.Turtle.prototype.showTurtle=function(){this.turtleIsHidden=false;this.arrow.setProperty("visible:true");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this};JXG.Turtle.prototype.hideTurtle=function(){this.turtleIsHidden=true;this.arrow.setProperty("visible:false");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this};JXG.Turtle.prototype.home=function(){this.pos=[0,0];this.setPos(this.pos[0],this.pos[1]);return this};JXG.Turtle.prototype.pushTurtle=function(){this.stack.push([this.pos[0],this.pos[1],this.dir]);return this};JXG.Turtle.prototype.popTurtle=function(){var a=this.stack.pop();this.pos[0]=a[0];this.pos[1]=a[1];this.dir=a[2];this.setPos(this.pos[0],this.pos[1]);return this};JXG.Turtle.prototype.lookTo=function(g){if(JXG.isArray(g)){var b=this.pos[0];var a=this.pos[1];var k=g[0];var e=g[1];var d;var h=(k-b>0)?1:-1;if(Math.abs(k-b)>1e-7){d=Math.atan((e-a)/(k-b))+((h<0)?Math.PI:0)}else{d=((e-a>0)?0.5:-0.5)*Math.PI}this.right(this.dir-(d*180/Math.PI))}else{if(JXG.isNumber(g)){this.right(this.dir-(g))}}return this};JXG.Turtle.prototype.moveTo=function(e){if(JXG.isArray(e)){var b=e[0]-this.pos[0];var a=e[1]-this.pos[1];if(!this.turtleIsHidden){var d=this.board.createElement("transform",[b,a],{type:"translate"});d.applyOnce(this.turtle);d.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]=e[0];this.pos[1]=e[1];if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update()}return this};JXG.Turtle.prototype.fd=function(a){return this.forward(a)};JXG.Turtle.prototype.bk=function(a){return this.back(a)};JXG.Turtle.prototype.lt=function(a){return this.left(a)};JXG.Turtle.prototype.rt=function(a){return this.right(a)};JXG.Turtle.prototype.pu=function(){return this.penUp()};JXG.Turtle.prototype.pd=function(){return this.penDown()};JXG.Turtle.prototype.ht=function(){return this.hideTurtle()};JXG.Turtle.prototype.st=function(){return this.showTurtle()};JXG.Turtle.prototype.cs=function(){return this.clearScreen()};JXG.Turtle.prototype.push=function(){return this.pushTurtle()};JXG.Turtle.prototype.pop=function(){return this.popTurtle()};JXG.Turtle.prototype.X=function(a){return this.pos[0]};JXG.Turtle.prototype.Y=function(a){return this.pos[1]};JXG.Turtle.prototype.hasPoint=function(a,e){var b,d;for(b=0;b<this.objects.length;b++){d=this.objects[b];if(d.type==JXG.OBJECT_TYPE_CURVE){if(d.hasPoint(a,e)){return true}}}return false};JXG.createTurtle=function(d,b,a){if(b==null){var b=[]}return new JXG.Turtle(d,b,a)};JXG.JSXGraph.registerElement("turtle",JXG.createTurtle);JXG.RGBColor=function(k){this.ok=false;if(k.charAt(0)=="#"){k=k.substr(1,6)}k=k.replace(/ /g,"");k=k.toLowerCase();var a={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};for(var d in a){if(k==d){k=a[d]}}var l=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(m){return[parseInt(m[1]),parseInt(m[2]),parseInt(m[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(m){return[parseInt(m[1],16),parseInt(m[2],16),parseInt(m[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(m){return[parseInt(m[1]+m[1],16),parseInt(m[2]+m[2],16),parseInt(m[3]+m[3],16)]}}];for(var b=0;b<l.length;b++){var g=l[b].re;var e=l[b].process;var h=g.exec(k);if(h){channels=e(h);this.r=channels[0];this.g=channels[1];this.b=channels[2];this.ok=true}}this.r=(this.r<0||isNaN(this.r))?0:((this.r>255)?255:this.r);this.g=(this.g<0||isNaN(this.g))?0:((this.g>255)?255:this.g);this.b=(this.b<0||isNaN(this.b))?0:((this.b>255)?255:this.b)};JXG.RGBColor.prototype.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"};JXG.RGBColor.prototype.toHex=function(){var e=this.r.toString(16);var d=this.g.toString(16);var a=this.b.toString(16);if(e.length==1){e="0"+e}if(d.length==1){d="0"+d}if(a.length==1){a="0"+a}return"#"+e+d+a};JXG.hsv2rgb=function(o,h,g){var k,s,d,m,l,e,b,a,u;o=((o%360)+360)%360;if(h==0){if(isNaN(o)){k=g;s=g;d=g}else{return"#ffffff"}}else{if(o>=360){e=0}else{e=o}e=e/60;l=Math.floor(e);m=e-l;b=g*(1-h);a=g*(1-(h*m));u=g*(1-(h*(1-m)));switch(l){case 0:k=g;s=u;d=b;break;case 1:k=a;s=g;d=b;break;case 2:k=b;s=g;d=u;break;case 3:k=b;s=a;d=g;break;case 4:k=u;s=b;d=g;break;case 5:k=g;s=b;d=a;break}}k=Math.round(k*255).toString(16);k=(k.length==2)?k:((k.length==1)?"0"+k:"00");s=Math.round(s*255).toString(16);s=(s.length==2)?s:((s.length==1)?"0"+s:"00");d=Math.round(d*255).toString(16);d=(d.length==2)?d:((d.length==1)?"0"+d:"00");return["#",k,s,d].join("")};JXG.Options=function(){this.fontSize=12;this.showCopyright=true;this.showNavigation=true;this.grid=new Object();this.grid.hasGrid=false;this.grid.gridX=2;this.grid.gridY=2;this.grid.gridColor="#C0C0C0";this.grid.gridOpacity="0.5";this.grid.gridDash=true;this.grid.snapToGrid=false;this.grid.snapSizeX=2;this.grid.snapSizeY=2;this.zoom=new Object();this.zoom.factor=1.25;this.elements=new Object();this.elements.color=new Object();this.elements.color.strokeOpacity=1;this.elements.color.highlightStrokeOpacity=1;this.elements.color.fillOpacity=1;this.elements.color.highlightFillOpacity=1;this.elements.color.strokeColor="#0000ff";this.elements.color.highlightStrokeColor="#C3D9FF";this.elements.color.fillColor="none";this.elements.color.highlightFillColor="none";this.elements.strokeWidth="2px";this.elements.draft=new Object();this.elements.draft.draft=false;this.elements.draft.color="#565656";this.elements.draft.opacity=0.8;this.elements.draft.strokeWidth="1px";this.point=new Object();this.point.style=5;this.point.fillColor="#ff0000";this.point.highlightFillColor="#EEEEEE";this.point.strokeColor=this.elements.color.strokeColor;this.point.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.line=new Object();this.line.firstArrow=false;this.line.lastArrow=false;this.line.straightFirst=true;this.line.straightLast=true;this.line.fillColor=this.elements.color.fillColor;this.line.highlightFillColor=this.elements.color.highlightFillColor;this.line.strokeColor="#000000";this.line.highlightStrokeColor="#888888";this.line.ticks=new Object();this.line.ticks.drawLabels=true;this.line.ticks.drawZero=false;this.line.ticks.insertTicks=false;this.line.ticks.minTicksDistance=50;this.line.ticks.maxTicksDistance=300;this.line.ticks.minorHeight=4;this.line.ticks.majorHeight=10;this.line.ticks.minorTicks=4;this.line.ticks.defaultDistance=1;this.circle=new Object();this.circle.fillColor=this.elements.color.fillColor;this.circle.highlightFillColor=this.elements.color.highlightFillColor;this.circle.strokeColor=this.elements.color.strokeColor;this.circle.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.angle=new Object();this.angle.radius=1;this.angle.fillColor="#FF7F00";this.angle.highlightFillColor="#FF7F00";this.angle.strokeColor="#FF7F00";this.angle.fillOpacity=0.3;this.angle.highlightFillOpacity=0.3;this.arc=new Object();this.arc.firstArrow=false;this.arc.lastArrow=false;this.arc.fillColor=this.elements.color.fillColor;this.arc.highlightFillColor=this.elements.color.highlightFillColor;this.arc.strokeColor=this.elements.color.strokeColor;this.arc.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.polygon=new Object();this.polygon.fillColor="#00FF00";this.polygon.highlightFillColor="#00FF00";this.polygon.fillOpacity=0.3;this.polygon.highlightFillOpacity=0.3;this.sector=new Object();this.sector.fillColor="#00FF00";this.sector.highlightFillColor="#00FF00";this.sector.fillOpacity=0.3;this.sector.highlightFillOpacity=0.3;this.text=new Object();this.text.strokeColor="#000000";this.curve=new Object();this.curve.strokeWidth="1px";this.curve.strokeColor=this.elements.color.strokeColor;this.curve.RDPsmoothing=false;this.curve.numberPointsHigh=1600;this.curve.numberPointsLow=400;this.curve.doAdvancedPlot=true;this.precision=new Object();this.precision.hasPoint=4;this.precision.epsilon=0.0001};JXG.Options.prototype.useStandardOptions=function(e){var d=e.hasGrid;e.hasGrid=this.grid.hasGrid;e.gridX=this.grid.gridX;e.gridY=this.grid.gridY;e.gridColor=this.grid.gridColor;e.gridOpacity=this.grid.gridOpacity;e.gridDash=this.grid.gridDash;e.snapToGrid=this.grid.snapToGrid;e.snapSizeX=this.grid.SnapSizeX;e.snapSizeY=this.grid.SnapSizeY;for(var b in e.objects){if(e.objects[b].type==JXG.OBJECT_TYPE_POINT){e.objects[b].visProp.fillColor=this.point.fillColor;e.objects[b].visProp.highlightFillColor=this.point.highlightFillColor;e.objects[b].visProp.strokeColor=this.point.strokeColor;e.objects[b].visProp.highlightStrokeColor=this.point.highlightStrokeColor}else{if(e.objects[b].type==JXG.OBJECT_TYPE_LINE){e.objects[b].visProp.fillColor=this.line.fillColor;e.objects[b].visProp.highlightFillColor=this.line.highlightFillColor;e.objects[b].visProp.strokeColor=this.line.strokeColor;e.objects[b].visProp.highlightStrokeColor=this.line.highlightStrokeColor;for(var a in e.objects[b].ticks){a.majorTicks=this.line.ticks.majorTicks;a.minTicksDistance=this.line.ticks.minTicksDistance;a.minorHeight=this.line.ticks.minorHeight;a.majorHeight=this.line.ticks.majorHeight}}else{if(e.objects[b].type==JXG.OBJECT_TYPE_CIRCLE){e.objects[b].visProp.fillColor=this.circle.fillColor;e.objects[b].visProp.highlightFillColor=this.circle.highlightFillColor;e.objects[b].visProp.strokeColor=this.circle.strokeColor;e.objects[b].visProp.highlightStrokeColor=this.circle.highlightStrokeColor}else{if(e.objects[b].type==JXG.OBJECT_TYPE_ANGLE){e.objects[b].visProp.fillColor=this.angle.fillColor;e.objects[b].visProp.highlightFillColor=this.angle.highlightFillColor;e.objects[b].visProp.strokeColor=this.angle.strokeColor}else{if(e.objects[b].type==JXG.OBJECT_TYPE_ARC){e.objects[b].visProp.fillColor=this.arc.fillColor;e.objects[b].visProp.highlightFillColor=this.arc.highlightFillColor;e.objects[b].visProp.strokeColor=this.arc.strokeColor;e.objects[b].visProp.highlightStrokeColor=this.arc.highlightStrokeColor}else{if(e.objects[b].type==JXG.OBJECT_TYPE_POLYGON){e.objects[b].visProp.fillColor=this.polygon.fillColor;e.objects[b].visProp.highlightFillColor=this.polygon.highlightFillColor;e.objects[b].visProp.fillOpacity=this.polygon.fillOpacity;e.objects[b].visProp.highlightFillOpacity=this.polygon.highlightFillOpacity}else{if(e.objects[b].type==JXG.OBJECT_TYPE_CURVE){e.objects[b].visProp.strokeColor=this.curve.strokeColor}}}}}}}}for(var b in e.objects){if(e.objects[b].type==JXG.OBJECT_TYPE_SECTOR){e.objects[b].arc.visProp.fillColor=this.sector.fillColor;e.objects[b].arc.visProp.highlightFillColor=this.sector.highlightFillColor;e.objects[b].arc.visProp.fillOpacity=this.sector.fillOpacity;e.objects[b].arc.visProp.highlightFillOpacity=this.sector.highlightFillOpacity}}e.needsFullUpdate=true;e.update();e.needsFullUpdate=false;if(d&&e.hasGrid){e.renderer.removeGrid(e);e.renderer.drawGrid(e)}else{if(d&&!e.hasGrid){e.renderer.removeGrid(e)}else{if(!d&&e.hasGrid){e.renderer.drawGrid(e)}}}};JXG.Options.prototype.useBlackWhiteOptions=function(a){this.point.fillColor=this.changeColorToBlackWhite(this.point.fillColor);this.point.highlightFillColor=this.changeColorToBlackWhite(this.point.highlightFillColor);this.point.strokeColor=this.changeColorToBlackWhite(this.point.strokeColor);this.point.highlightStrokeColor=this.changeColorToBlackWhite(this.point.highlightStrokeColor);this.line.fillColor=this.changeColorToBlackWhite(this.line.fillColor);this.line.highlightFillColor=this.changeColorToBlackWhite(this.line.highlightFillColor);this.line.strokeColor=this.changeColorToBlackWhite(this.line.strokeColor);this.line.highlightStrokeColor=this.changeColorToBlackWhite(this.line.highlightStrokeColor);this.circle.fillColor=this.changeColorToBlackWhite(this.circle.fillColor);this.circle.highlightFillColor=this.changeColorToBlackWhite(this.circle.highlightFillColor);this.circle.strokeColor=this.changeColorToBlackWhite(this.circle.strokeColor);this.circle.highlightStrokeColor=this.changeColorToBlackWhite(this.circle.highlightStrokeColor);this.arc.fillColor=this.changeColorToBlackWhite(this.arc.fillColor);this.arc.highlightFillColor=this.changeColorToBlackWhite(this.arc.highlightFillColor);this.arc.strokeColor=this.changeColorToBlackWhite(this.arc.strokeColor);this.arc.highlightStrokeColor=this.changeColorToBlackWhite(this.arc.highlightStrokeColor);this.polygon.fillColor=this.changeColorToBlackWhite(this.polygon.fillColor);this.polygon.highlightFillColor=this.changeColorToBlackWhite(this.polygon.highlightFillColor);this.sector.fillColor=this.changeColorToBlackWhite(this.sector.fillColor);this.sector.highlightFillColor=this.changeColorToBlackWhite(this.sector.highlightFillColor);this.curve.strokeColor=this.changeColorToBlackWhite(this.curve.strokeColor);this.grid.gridColor=this.changeColorToBlackWhite(this.grid.gridColor);this.useStandardOptions(a)};JXG.Options.prototype.changeColorToBlackWhite=function(e){if(e=="none"){return e}var h=new JXG.RGBColor(e);var m=h.r;var l=h.g;var d=h.b;var a=0.3*m+0.59*l+0.11*d;var o="0123456789ABCDEF";var k=o.charAt((a>>4)&15)+o.charAt(a&15);e="#"+k+""+k+""+k;return e};JXG.Options.prototype.loadFromFile=function(b,d,a){this.cbp=function(e){this.parseString(e,d,a)};this.cb=JXG.bind(this.cbp,this);JXG.FileReader.parseFileContent(b,this.cb,"raw")};JXG.Options.prototype.parseString=function(text,applyTo,board){var newOptions="";if(text!=""){newOptions=eval("("+text+")")}else{return}var maxDepth=10;var applyOption=function(base,option,depth){if(depth==10){return}depth++;for(var key in option){if((JXG.isNumber(option[key]))||(JXG.isArray(option[key]))||(JXG.isString(option[key]))||(option[key]==true)||(option[key]==false)){base[key]=option[key]}else{applyOption(base[key],option[key],depth)}}};applyOption(this,newOptions,0);if(applyTo&&typeof board!="undefined"){this.useStandardOptions(board)}};JXG.Board.prototype.angle=function(a,d,b){return this.algebra.angle(a,d,b)};JXG.Board.prototype.rad=function(a,d,b){return this.algebra.rad(a,d,b)};JXG.Board.prototype.distance=function(b,a){return this.algebra.distance(b,a)};JXG.Board.prototype.pow=function(e,d){return this.algebra.pow(e,d)};JXG.Board.prototype.round=function(a,b){return(a).toFixed(b)};JXG.Board.prototype.cosh=function(a){return JXG.Math.Numerics.cosh(a)};JXG.Board.prototype.sinh=function(a){return JXG.Math.Numerics.sinh(a)};JXG.Board.prototype.sgn=function(a){return(a==0?0:a/(Math.abs(a)))};JXG.Board.prototype.D=function(a,b){return JXG.Math.Numerics.D(a,b)};JXG.Board.prototype.I=function(a,b){return JXG.Math.Numerics.I(a,b)};JXG.Board.prototype.root=function(b,a,d){return JXG.Math.Numerics.root(b,a,d)};JXG.Board.prototype.lagrangePolynomial=function(a){return JXG.Math.Numerics.lagrangePolynomial(a)};JXG.Board.prototype.neville=function(a){return JXG.Math.Numerics.neville(a)};JXG.Board.prototype.riemannsum=function(d,g,b,e,a){return JXG.Math.Numerics.riemannsum(d,g,b,e,a)};JXG.Board.prototype.abs=Math.abs;JXG.Board.prototype.acos=Math.acos;JXG.Board.prototype.asin=Math.asin;JXG.Board.prototype.atan=Math.atan;JXG.Board.prototype.ceil=Math.ceil;JXG.Board.prototype.cos=Math.cos;JXG.Board.prototype.exp=Math.exp;JXG.Board.prototype.floor=Math.floor;JXG.Board.prototype.log=Math.log;JXG.Board.prototype.max=Math.max;JXG.Board.prototype.min=Math.min;JXG.Board.prototype.random=Math.random;JXG.Board.prototype.sin=Math.sin;JXG.Board.prototype.sqrt=Math.sqrt;JXG.Board.prototype.tan=Math.tan;JXG.Board.prototype.trunc=Math.ceil;JXG.Board.prototype.factorial=function(a){return JXG.Math.factorial(a)};JXG.Board.prototype.binomial=function(b,a){return JXG.Math.binomial(b,a)};JXG.Point.prototype.setPositionX=function(d,a){var b=(d==JXG.COORDS_BY_USER)?this.coords.usrCoords[2]:this.coords.scrCoords[2];this.setPosition(d,a,b)};JXG.Point.prototype.setPositionY=function(d,b){var a=(d==JXG.COORDS_BY_USER)?this.coords.usrCoords[1]:this.coords.scrCoords[1];this.setPosition(d,a,b)};JXG.Board.prototype.getElement=function(a){return JXG.getReference(this,a)};JXG.Board.prototype.intersectionOptions=["point",[[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_CIRCLE],[JXG.OBJECT_CLASS_CIRCLE,JXG.OBJECT_CLASS_CIRCLE]]];JXG.Board.prototype.intersection=function(e,b,d,a){e=JXG.getReference(this,e);b=JXG.getReference(this,b);if(e.elementClass==JXG.OBJECT_CLASS_CURVE||b.elementClass==JXG.OBJECT_CLASS_CURVE){return function(){return e.board.algebra.meetCurveCurve(e,b,d,a)}}else{return function(){return e.board.algebra.meet(e.stdform,b.stdform,d)}}};JXG.Board.prototype.intersectionFunc=function(e,b,d,a){return this.intersection(e,b,d,a)};JXG.Board.prototype.otherIntersection=function(b,a,d){b=JXG.getReference(this,b);a=JXG.getReference(this,a);return function(){var e=b.board.algebra.meet(b.stdform,a.stdform,0);if(Math.abs(d.X()-e.usrCoords[1])>JXG.Math.eps||Math.abs(d.Y()-e.usrCoords[2])>JXG.Math.eps||Math.abs(d.Z()-e.usrCoords[0])>JXG.Math.eps){return e}else{return b.board.algebra.meet(b.stdform,a.stdform,1)}}};JXG.Board.prototype.pointFunc=function(){return[null]};JXG.Board.prototype.pointOptions=["point",[[JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.lineFunc=function(){return arguments};JXG.Board.prototype.lineOptions=["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.linesegmentFunc=function(){return arguments};JXG.Board.prototype.linesegmentOptions=["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.linesegmentAtts={straightFirst:false,straightLast:false};JXG.Board.prototype.arrowFunc=function(){return arguments};JXG.Board.prototype.arrowOptions=["arrow",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circleFunc=function(){return arguments};JXG.Board.prototype.circleOptions=["circle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_CIRCLE]]];JXG.Board.prototype.arrowparallelOptions=["arrowparallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.arrowparallelFunc=function(){return arguments};JXG.Board.prototype.bisectorOptions=["bisector",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.bisectorFunc=function(){return arguments};JXG.Board.prototype.circumcircleOptions=["circumcircle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circumcircleFunc=function(){return arguments};JXG.Board.prototype.circumcirclemidpointOptions=["circumcirclemidpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circumcirclemidpointFunc=function(){return arguments};JXG.Board.prototype.integralOptions=["integral",[[]]];JXG.Board.prototype.integralFunc=function(){return arguments};JXG.Board.prototype.midpointOptions=["midpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.midpointFunc=function(){return arguments};JXG.Board.prototype.mirrorpointOptions=["mirrorpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.mirrorpointFunc=function(){return arguments};JXG.Board.prototype.normalOptions=["normal",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.normalFunc=function(){return arguments};JXG.Board.prototype.parallelOptions=["parallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.parallelFunc=function(){return arguments};JXG.Board.prototype.parallelpointOptions=["parallelpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.parallelpointFunc=function(){return arguments};JXG.Board.prototype.perpendicularOptions=["perpendicular",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.perpendicularFunc=function(){return arguments};JXG.Board.prototype.perpendicularpointOptions=["perpendicularpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.perpendicularpointFunc=function(){return arguments};JXG.Board.prototype.reflectionOptions=["reflection",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.reflectionFunc=function(){return arguments};JXG.Board.prototype.pstricks={};JXG.Board.prototype.pstricks.givePsTricksToDiv=function(a,b){JXG.PsTricks.givePsTricksToDiv(a,b)};JXG.Ticks=function(a,g,e,h,b,k,d){this.constructor();this.type=JXG.OBJECT_TYPE_TICKS;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.line=a;this.board=this.line.board;this.ticksFunction=null;this.fixedTicks=null;this.equidistant=false;if(JXG.isFunction(g)){this.ticksFunction=g}else{if(JXG.isArray(g)){this.fixedTicks=g}else{if(Math.abs(g)<JXG.Math.eps){g=this.board.options.line.ticks.defaultDistance}this.ticksFunction=function(l){return g};this.equidistant=true}}this.minorTicks=((e==null)||(e==0)?this.board.options.line.ticks.minorTicks:e);if(this.minorTicks<0){this.minorTicks=-this.minorTicks}this.majorHeight=((h==null)||(h==0)?this.board.options.line.ticks.majorHeight:h);if(this.majorHeight<0){this.majorHeight=-this.majorHeight}this.minorHeight=((b==null)||(b==0)?this.board.options.line.ticks.minorHeight:b);if(this.minorHeight<0){this.minorHeight=-this.minorHeight}this.minTicksDistance=this.board.options.line.ticks.minTicksDistance;this.maxTicksDistance=this.board.options.line.ticks.maxTicksDistance;this.insertTicks=this.board.options.line.ticks.insertTicks;this.drawZero=this.board.options.line.ticks.drawZero;this.drawLabels=this.board.options.line.ticks.drawLabels;this.init(this.board,k,d);this.visProp.visible=true;this.visProp.fillColor=this.line.visProp.fillColor;this.visProp.highlightFillColor=this.line.visProp.highlightFillColor;this.visProp.strokeColor=this.line.visProp.strokeColor;this.visProp.highlightStrokeColor=this.line.visProp.highlightStrokeColor;this.visProp.strokeWidth=this.line.visProp.strokeWidth;this.id=this.line.addTicks(this)};JXG.Ticks.prototype=new JXG.GeometryElement;JXG.Ticks.prototype.hasPoint=function(a,b){return false};JXG.Ticks.prototype.makeTicks=function(h,d,L,I){var D=h.usrCoords[1]-d.usrCoords[1];var B=h.usrCoords[2]-d.usrCoords[2];var K=0;var k=Math.sqrt(D*D+B*B);if(k<=JXG.Math.eps){return}var A=h.usrCoords[1];var w=h.usrCoords[2];var J=L/Math.abs(L);K=Math.abs(this.ticksFunction(J));var O=(K*D)/(k);var N=(K*B)/(k);var G=0;if(this.equidistant){var b=O;var E=N;var a=K;var C=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board);var H=new JXG.Coords(JXG.COORDS_BY_USER,[O,N],this.board);G=(H.scrCoords[1]-C.scrCoords[1])*(H.scrCoords[1]-C.scrCoords[1])+(H.scrCoords[2]-C.scrCoords[2])*(H.scrCoords[2]-C.scrCoords[2]);K=Math.pow(10,Math.floor(Math.log(K)/Math.LN10));O=(K*D)/(k);N=(K*B)/(k);while(G>8*this.minTicksDistance*this.minTicksDistance){K/=10;O=(K*D)/(k);N=(K*B)/(k);H=new JXG.Coords(JXG.COORDS_BY_USER,[O,N],this.board);G=(H.scrCoords[1]-C.scrCoords[1])*(H.scrCoords[1]-C.scrCoords[1])+(H.scrCoords[2]-C.scrCoords[2])*(H.scrCoords[2]-C.scrCoords[2])}var F=5;while(G<this.minTicksDistance*this.minTicksDistance){K*=F;if(F==5){F=2}else{F=5}O=(K*D)/(k);N=(K*B)/(k);H=new JXG.Coords(JXG.COORDS_BY_USER,[O,N],this.board);G=(H.scrCoords[1]-C.scrCoords[1])*(H.scrCoords[1]-C.scrCoords[1])+(H.scrCoords[2]-C.scrCoords[2])*(H.scrCoords[2]-C.scrCoords[2])}}var P=L*K;var s=new JXG.Coords(JXG.COORDS_BY_USER,[A,w],this.board);var g=null;var e=null;var p="";var q=null;var o=true;var m=A;var l=w;while(o||(this.board.sgn(O)*(A-I*O)>=this.board.sgn(O)*d.usrCoords[1]&&this.board.sgn(N)*(w-I*N)>=this.board.sgn(N)*d.usrCoords[2])){o=false;A=A-O;w=w-N;g=new JXG.Coords(JXG.COORDS_BY_USER,[A,w],this.board);if(!this.equidistant){G=(s.scrCoords[1]-g.scrCoords[1])*(s.scrCoords[1]-g.scrCoords[1])+(s.scrCoords[2]-g.scrCoords[2])*(s.scrCoords[2]-g.scrCoords[2])}if(this.insertTicks&&this.equidistant&&(G>this.maxTicksDistance*this.maxTicksDistance)){while(G>this.maxTicksDistance*this.maxTicksDistance){O*=0.5;N*=0.5;K*=0.5;A+=O;w+=N;P=P-L*K;g=new JXG.Coords(JXG.COORDS_BY_USER,[A,w],this.board);G=(s.scrCoords[1]-g.scrCoords[1])*(s.scrCoords[1]-g.scrCoords[1])+(s.scrCoords[2]-g.scrCoords[2])*(s.scrCoords[2]-g.scrCoords[2])}}if(this.equidistant){for(var u=1;u<this.minorTicks+1;u++){e=new JXG.Coords(JXG.COORDS_BY_USER,[m-(O*u)/(this.minorTicks+1),l-(N*u)/(this.minorTicks+1)],this.board);e.major=false;this.ticks.push(e);this.labels.push(null)}}if(this.equidistant||(G>this.minTicksDistance*this.minTicksDistance)){g.major=true;this.ticks.push(g);p=P.toString();if(p.length>5){p=P.toPrecision(3).toString()}q=new JXG.Text(this.board,p,null,[g.usrCoords[1],g.usrCoords[2]],this.id+J+"Label",null,null,true);q.distanceX=0;q.distanceY=-10;q.setCoords(g.usrCoords[1]*1+q.distanceX/(this.board.stretchX),g.usrCoords[2]*1+q.distanceY/(this.board.stretchY));if(this.drawLabels){q.visProp.visible=true}else{q.visProp.visible=false}this.labels.push(q);m=A;l=w;s=g}J=J+L*1;if(!this.equidistant){K=Math.abs(this.ticksFunction(J))}P=P+L*K;if(!this.equidistant){O=(K*D)/(k);N=(K*B)/(k)}}};JXG.Ticks.prototype.calculateTicksCoordinates=function(){var D=1;var u=2;var w=D+u;var E=new JXG.Coords(JXG.COORDS_BY_USER,[this.line.point1.coords.usrCoords[1],this.line.point1.coords.usrCoords[2]],this.board);var C=new JXG.Coords(JXG.COORDS_BY_USER,[this.line.point2.coords.usrCoords[1],this.line.point2.coords.usrCoords[2]],this.board);this.board.renderer.calcStraight(this.line,E,C);var b=this.line.point1.coords;if(this.board.renderer.isSameDirection(b,E,C)){if(this.board.renderer.isSameDirection(b,this.line.point2.coords,E)){w=u;if(b.distance(JXG.COORDS_BY_USER,E)>b.distance(JXG.COORDS_BY_USER,C)){C=E}}else{w=D;if(b.distance(JXG.COORDS_BY_USER,E)<b.distance(JXG.COORDS_BY_USER,C)){E=C}}}else{if(this.board.renderer.isSameDirection(b,this.line.point2.coords,E)){var h=E;E=C;C=h}}if(this.ticks!=null){for(var G=0;G<this.ticks.length;G++){if(this.labels[G]!=null){if(this.labels[G].visProp.visible){this.board.renderer.remove(this.labels[G].rendNode)}}}}this.ticks=new Array();this.labels=new Array();var o=null;var l="";var g=null;if(this.ticksFunction!=null){if(this.drawZero){g=new JXG.Coords(JXG.COORDS_BY_USER,[b.usrCoords[1],b.usrCoords[2]],this.board);this.ticks.push(g);o=new JXG.Text(this.board,"0",null,[b.usrCoords[1],b.usrCoords[2]],this.id+"0Label",null,null,true);if(this.drawLabels){o.visProp.visible=true}else{o.visProp.visible=false}this.labels.push(o);this.ticks[0].major=true}if(D==(w&D)){if(this.line.visProp.straightFirst){this.makeTicks(b,E,-1,0)}}if(u==(w&u)){if(this.line.visProp.straightLast){this.makeTicks(b,C,+1,0)}else{this.makeTicks(b,this.line.point2.coords,+1,1)}}}else{if(!this.line.visProp.straightFirst){E=b}var p=b.usrCoords[1]-E.usrCoords[1];var m=b.usrCoords[2]-E.usrCoords[2];var L=Math.sqrt(p*p+m*m);if(!this.line.visProp.straightLast){C=this.line.point2.coords}var k=b.usrCoords[1]-C.usrCoords[1];var q=b.usrCoords[2]-C.usrCoords[2];var d=Math.sqrt(k*k+q*q);var J=0;var I=0;for(var H=0;H<this.fixedTicks.length;H++){if((-L<=this.fixedTicks[H])&&(this.fixedTicks[H]<=d)){if(this.fixedTicks[H]<0){J=Math.abs(p)*this.fixedTicks[H]/L;I=Math.abs(m)*this.fixedTicks[H]/L}else{J=Math.abs(k)*this.fixedTicks[H]/d;I=Math.abs(q)*this.fixedTicks[H]/d}g=new JXG.Coords(JXG.COORDS_BY_USER,[b.usrCoords[1]+J,b.usrCoords[2]+I],this.board);this.ticks.push(g);this.ticks[this.ticks.length-1].major=true;l=this.fixedTicks[H].toString();if(l.length>5){l=this.fixedTicks[H].toFixed(3).toString()}o=new JXG.Text(this.board,l,null,[b.usrCoords[1]+J,b.usrCoords[2]+I],this.id+H+"Label",null,null,true);o.distanceX=0;o.distanceY=-10;o.setCoords(g.usrCoords[1]*1+o.distanceX/(this.board.stretchX),g.usrCoords[2]*1+o.distanceY/(this.board.stretchY));if(this.drawLabels){o.visProp.visible=true}else{o.visProp.visible=false}this.labels.push(o)}}}var A=JXG.Math.eps;var s=-this.line.getSlope();var z=this.majorHeight/2;var e=this.minorHeight/2;var K=0;var a=0;var B=0;var F=0;if(Math.abs(s)<A){K=0;a=z;B=0;F=e}else{if((Math.abs(s)>1/A)||(isNaN(s))){K=z;a=0;B=e;F=0}else{K=z/Math.sqrt(1/(s*s)+1);a=-K/s;B=e/Math.sqrt(1/(s*s)+1);F=-B/s}}this.board.renderer.updateTicks(this,K,a,B,F)};JXG.Ticks.prototype.updateRenderer=function(){if(this.needsUpdate){this.calculateTicksCoordinates();this.needsUpdate=false}};JXG.createTicks=function(e,b,a){var d;if((b[0].elementClass==JXG.OBJECT_CLASS_LINE)&&(JXG.isFunction(b[1])||JXG.isArray(b[1])||JXG.isNumber(b[1]))){d=new JXG.Ticks(b[0],b[1],a.minorTicks,a.majHeight,a.minHeight,a.id,a.name)}else{throw ("Can't create Ticks with parent types '"+(typeof b[0])+"' and '"+(typeof b[1])+"' and '"+(typeof b[2])+"'.")}return d};JXG.JSXGraph.registerElement("ticks",JXG.createTicks);JXG.Util={};JXG.Util.Unzip=function(ab){var s=[],O="",L=false,I,P=0,Y=[],A,l=new Array(32768),ag=0,T=false,ad,Q,af=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255],aj=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],aa=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99],U=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],H=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],u=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],E=ab,b=0,k=0,ak=1,a=0,ai=256,h=[],o;function e(){var am=E.length;a+=8;if(b<am){if(L){document.write(b+": "+E[b]+"<br>")}return E[b++]}else{return -1}}function w(){ak=1}function ae(){var am;a++;am=(ak&1);ak>>=1;if(ak==0){ak=e();am=(ak&1);ak=(ak>>1)|128}return am}function ac(am){var ao=0,an=am;while(an--){ao=(ao<<1)|ae()}if(am){ao=af[ao]>>(8-am)}return ao}function d(){ag=0}function F(am){Q++;l[ag++]=am;s.push(String.fromCharCode(am));if(ag==32768){ag=0}}function q(){this.b0=0;this.b1=0;this.jump=null;this.jumppos=-1}var g=288;var D=new Array(g);var W=new Array(32);var R=0;var ah=null;var z=null;var V=new Array(64);var S=new Array(64);var G=0;var K=new Array(17);K[0]=0;var X;var C;function m(){while(1){if(K[G]>=C){return -1}if(X[K[G]]==G){return K[G]++}K[G]++}}function N(){var an=ah[R];var am;if(L){document.write("<br>len:"+G+" treepos:"+R)}if(G==17){return -1}R++;G++;am=m();if(L){document.write("<br>IsPat "+am)}if(am>=0){an.b0=am;if(L){document.write("<br>b0 "+an.b0)}}else{an.b0=32768;if(L){document.write("<br>b0 "+an.b0)}if(N()){return -1}}am=m();if(am>=0){an.b1=am;if(L){document.write("<br>b1 "+an.b1)}an.jump=null}else{an.b1=32768;if(L){document.write("<br>b1 "+an.b1)}an.jump=ah[R];an.jumppos=R;if(N()){return -1}}G--;return 0}function p(aq,ao,ar,an){var ap;if(L){document.write("currentTree "+aq+" numval "+ao+" lengths "+ar+" show "+an)}ah=aq;R=0;X=ar;C=ao;for(ap=0;ap<17;ap++){K[ap]=0}G=0;if(N()){if(L){alert("invalid huffman tree\n")}return -1}if(L){document.write("<br>Tree: "+ah.length);for(var am=0;am<32;am++){document.write("Places["+am+"].b0="+ah[am].b0+"<br>");document.write("Places["+am+"].b1="+ah[am].b1+"<br>")}}return 0}function J(ap){var an,ao,ar=0,aq=ap[ar],am;while(1){am=ae();if(L){document.write("b="+am)}if(am){if(!(aq.b1&32768)){if(L){document.write("ret1")}return aq.b1}aq=aq.jump;an=ap.length;for(ao=0;ao<an;ao++){if(ap[ao]===aq){ar=ao;break}}}else{if(!(aq.b0&32768)){if(L){document.write("ret2")}return aq.b0}ar++;aq=ap[ar]}}if(L){document.write("ret3")}return -1}function al(){var aq,aD,an,aB,aC;do{aq=ae();an=ac(2);switch(an){case 0:if(L){alert("Stored\n")}break;case 1:if(L){alert("Fixed Huffman codes\n")}break;case 2:if(L){alert("Dynamic Huffman codes\n")}break;case 3:if(L){alert("Reserved block type!!\n")}break;default:if(L){alert("Unexpected value %d!\n",an)}break}if(an==0){var az,am;w();az=e();az|=(e()<<8);am=e();am|=(e()<<8);if(((az^~am)&65535)){document.write("BlockLen checksum mismatch\n")}while(az--){aD=e();F(aD)}}else{if(an==1){var aA;while(1){aA=(af[ac(7)]>>1);if(aA>23){aA=(aA<<1)|ae();if(aA>199){aA-=128;aA=(aA<<1)|ae()}else{aA-=48;if(aA>143){aA=aA+136}}}else{aA+=256}if(aA<256){F(aA)}else{if(aA==256){break}else{var aC,aw;aA-=256+1;aC=ac(aa[aA])+aj[aA];aA=af[ac(5)]>>3;if(H[aA]>8){aw=ac(8);aw|=(ac(H[aA]-8)<<8)}else{aw=ac(H[aA])}aw+=U[aA];for(aA=0;aA<aC;aA++){var aD=l[(ag-aw)&32767];F(aD)}}}}}else{if(an==2){var aA,ax,ao,au,av;var at=new Array(288+32);ao=257+ac(5);au=1+ac(5);av=4+ac(4);for(aA=0;aA<19;aA++){at[aA]=0}for(aA=0;aA<av;aA++){at[u[aA]]=ac(3)}aC=W.length;for(aB=0;aB<aC;aB++){W[aB]=new q()}if(p(W,19,at,0)){d();return 1}if(L){document.write("<br>distanceTree");for(var aE=0;aE<W.length;aE++){document.write("<br>"+W[aE].b0+" "+W[aE].b1+" "+W[aE].jump+" "+W[aE].jumppos)}}ax=ao+au;aB=0;var ap=-1;if(L){document.write("<br>n="+ax+" bits: "+a+"<br>")}while(aB<ax){ap++;aA=J(W);if(L){document.write("<br>"+ap+" i:"+aB+" decode: "+aA+"    bits "+a+"<br>")}if(aA<16){at[aB++]=aA}else{if(aA==16){var ay;aA=3+ac(2);if(aB+aA>ax){d();return 1}ay=aB?at[aB-1]:0;while(aA--){at[aB++]=ay}}else{if(aA==17){aA=3+ac(3)}else{aA=11+ac(7)}if(aB+aA>ax){d();return 1}while(aA--){at[aB++]=0}}}}aC=D.length;for(aB=0;aB<aC;aB++){D[aB]=new q()}if(p(D,ao,at,0)){d();return 1}aC=D.length;for(aB=0;aB<aC;aB++){W[aB]=new q()}var ar=new Array();for(aB=ao;aB<at.length;aB++){ar[aB-ao]=at[aB]}if(p(W,au,ar,0)){d();return 1}if(L){document.write("<br>literalTree")}while(1){aA=J(D);if(aA>=256){var aC,aw;aA-=256;if(aA==0){break}aA--;aC=ac(aa[aA])+aj[aA];aA=J(W);if(H[aA]>8){aw=ac(8);aw|=(ac(H[aA]-8)<<8)}else{aw=ac(H[aA])}aw+=U[aA];while(aC--){var aD=l[(ag-aw)&32767];F(aD)}}else{F(aA)}}}}}}while(!aq);d();w();return 0}JXG.Util.Unzip.prototype.unzipFile=function(am){var an;this.unzip();for(an=0;an<Y.length;an++){if(Y[an][1]==am){return Y[an][0]}}};JXG.Util.Unzip.prototype.unzip=function(){if(L){alert(E)}B();return Y};function B(){if(L){alert("NEXTFILE")}s=[];var aq=[];T=false;aq[0]=e();aq[1]=e();if(L){alert("type: "+aq[0]+" "+aq[1])}if(aq[0]==parseInt("78",16)&&aq[1]==parseInt("da",16)){if(L){alert("GEONExT-GZIP")}al();if(L){alert(s.join(""))}Y[P]=new Array(2);Y[P][0]=s.join("");Y[P][1]="geonext.gxt";P++}if(aq[0]==parseInt("50",16)&&aq[1]==parseInt("4b",16)){T=true;aq[2]=e();aq[3]=e();if(aq[2]==parseInt("3",16)&&aq[3]==parseInt("4",16)){aq[0]=e();aq[1]=e();if(L){alert("ZIP-Version: "+aq[1]+" "+aq[0]/10+"."+aq[0]%10)}I=e();I|=(e()<<8);if(L){alert("gpflags: "+I)}var am=e();am|=(e()<<8);if(L){alert("method: "+am)}e();e();e();e();var ar=e();ar|=(e()<<8);ar|=(e()<<16);ar|=(e()<<24);var ap=e();ap|=(e()<<8);ap|=(e()<<16);ap|=(e()<<24);var av=e();av|=(e()<<8);av|=(e()<<16);av|=(e()<<24);if(L){alert("local CRC: "+ar+"\nlocal Size: "+av+"\nlocal CompSize: "+ap)}var an=e();an|=(e()<<8);var au=e();au|=(e()<<8);if(L){alert("filelen "+an)}ao=0;h=[];while(an--){var at=e();if(at=="/"|at==":"){ao=0}else{if(ao<ai-1){h[ao++]=String.fromCharCode(at)}}}if(L){alert("nameBuf: "+h)}if(!o){o=h}var ao=0;while(ao<au){at=e();ao++}ad=4294967295;Q=0;if(av=0&&fileOut.charAt(o.length-1)=="/"){if(L){alert("skipdir")}}if(am==8){al();if(L){alert(s.join(""))}Y[P]=new Array(2);Y[P][0]=s.join("");Y[P][1]=h.join("");P++}Z()}}}function Z(){var ar,ao=[],ap,an,aq,am,at;if((I&8)){ao[0]=e();ao[1]=e();ao[2]=e();ao[3]=e();if(ao[0]==parseInt("50",16)&&ao[1]==parseInt("4b",16)&&ao[2]==parseInt("07",16)&&ao[3]==parseInt("08",16)){ar=e();ar|=(e()<<8);ar|=(e()<<16);ar|=(e()<<24)}else{ar=ao[0]|(ao[1]<<8)|(ao[2]<<16)|(ao[3]<<24)}ap=e();ap|=(e()<<8);ap|=(e()<<16);ap|=(e()<<24);an=e();an|=(e()<<8);an|=(e()<<16);an|=(e()<<24);if(L){alert("CRC:")}}if(T){B()}ao[0]=e();if(ao[0]!=8){if(L){alert("Unknown compression method!")}return 0}I=e();if(L){if((I&~(parseInt("1f",16)))){alert("Unknown flags set!")}}e();e();e();e();e();aq=e();if((I&4)){ao[0]=e();ao[2]=e();G=ao[0]+256*ao[1];if(L){alert("Extra field size: "+G)}for(am=0;am<G;am++){e()}}if((I&8)){am=0;h=[];while(at=e()){if(at=="7"||at==":"){am=0}if(am<ai-1){h[am++]=at}}if(L){alert("original file name: "+h)}}if((I&16)){while(at=e()){}}if((I&2)){e();e()}al();ar=e();ar|=(e()<<8);ar|=(e()<<16);ar|=(e()<<24);an=e();an|=(e()<<8);an|=(e()<<16);an|=(e()<<24);B()}};JXG.Util.Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(d){var a=[],o,l,h,m,k,g,e,b=0;d=JXG.Util.Base64._utf8_encode(d);while(b<d.length){o=d.charCodeAt(b++);l=d.charCodeAt(b++);h=d.charCodeAt(b++);m=o>>2;k=((o&3)<<4)|(l>>4);g=((l&15)<<2)|(h>>6);e=h&63;if(isNaN(l)){g=e=64}else{if(isNaN(h)){e=64}}a.push([this._keyStr.charAt(m),this._keyStr.charAt(k),this._keyStr.charAt(g),this._keyStr.charAt(e)].join(""))}return a.join("")},decode:function(e,d){var a=[],p,m,k,o,l,h,g,b=0;e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(b<e.length){o=this._keyStr.indexOf(e.charAt(b++));l=this._keyStr.indexOf(e.charAt(b++));h=this._keyStr.indexOf(e.charAt(b++));g=this._keyStr.indexOf(e.charAt(b++));p=(o<<2)|(l>>4);m=((l&15)<<4)|(h>>2);k=((h&3)<<6)|g;a.push(String.fromCharCode(p));if(h!=64){a.push(String.fromCharCode(m))}if(g!=64){a.push(String.fromCharCode(k))}}a=a.join("");if(d){a=JXG.Util.Base64._utf8_decode(a)}return a},_utf8_encode:function(b){b=b.replace(/\r\n/g,"\n");var a="";for(var e=0;e<b.length;e++){var d=b.charCodeAt(e);if(d<128){a+=String.fromCharCode(d)}else{if((d>127)&&(d<2048)){a+=String.fromCharCode((d>>6)|192);a+=String.fromCharCode((d&63)|128)}else{a+=String.fromCharCode((d>>12)|224);a+=String.fromCharCode(((d>>6)&63)|128);a+=String.fromCharCode((d&63)|128)}}}return a},_utf8_decode:function(a){var d=[],g=0,h=0,e=0,b=0;while(g<a.length){h=a.charCodeAt(g);if(h<128){d.push(String.fromCharCode(h));g++}else{if((h>191)&&(h<224)){e=a.charCodeAt(g+1);d.push(String.fromCharCode(((h&31)<<6)|(e&63)));g+=2}else{e=a.charCodeAt(g+1);b=a.charCodeAt(g+2);d.push(String.fromCharCode(((h&15)<<12)|((e&63)<<6)|(b&63)));g+=3}}}return d.join("")},_destrip:function(h,e){var b=[],g,d,a=[];if(e==null){e=76}h.replace(/ /g,"");g=h.length/e;for(d=0;d<g;d++){b[d]=h.substr(d*e,e)}if(g!=h.length/e){b[b.length]=h.substr(g*e,h.length-(g*e))}for(d=0;d<b.length;d++){a.push(b[d])}return a.join("\n")},decodeAsArray:function(b){var e=this.decode(b),a=[],d;for(d=0;d<e.length;d++){a[d]=e.charCodeAt(d)}return a},decodeGEONExT:function(a){return decodeAsArray(destrip(a),false)}};JXG.Util.asciiCharCodeAt=function(b,a){var d=b.charCodeAt(a);if(d>255){switch(d){case 8364:d=128;break;case 8218:d=130;break;case 402:d=131;break;case 8222:d=132;break;case 8230:d=133;break;case 8224:d=134;break;case 8225:d=135;break;case 710:d=136;break;case 8240:d=137;break;case 352:d=138;break;case 8249:d=139;break;case 338:d=140;break;case 381:d=142;break;case 8216:d=145;break;case 8217:d=146;break;case 8220:d=147;break;case 8221:d=148;break;case 8226:d=149;break;case 8211:d=150;break;case 8212:d=151;break;case 732:d=152;break;case 8482:d=153;break;case 353:d=154;break;case 8250:d=155;break;case 339:d=156;break;case 382:d=158;break;case 376:d=159;break;default:break}}return d};JXG.PsTricks=new function(){this.psTricksString=""};JXG.PsTricks.convertBoardToPsTricks=function(b){var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[b.canvasWidth,b.canvasHeight],b);var d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],b);this.psTricksString="\\begin{pspicture*}("+d.usrCoords[1]+","+e.usrCoords[2]+")("+e.usrCoords[1]+","+d.usrCoords[2]+")\n";for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_ARC){if(g.visProp.visible){this.addSector(g)}}}for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_POLYGON){if(g.visProp.visible){this.addPolygon(g)}}}for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_ANGLE){if(g.visProp.visible){this.addAngle(g)}}}for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_CIRCLE){if(g.visProp.visible){this.addCircle(g)}}}for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_ARC){if(g.visProp.visible){this.addArc(g)}}}for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_LINE){if(g.visProp.visible){this.addLine(g)}}}for(var a in b.objects){var g=b.objects[a];if(g.type==JXG.OBJECT_TYPE_POINT){if(g.visProp.visible){this.addPoint(g)}}}this.psTricksString+="\\end{pspicture*}"};JXG.PsTricks.givePsTricksToDiv=function(a,b){this.convertBoardToPsTricks(b);document.getElementById(a).innerHTML=this.psTricksString};JXG.PsTricks.addPoint=function(a){this.psTricksString+="\\psdot";this.psTricksString+="[linecolor="+this.parseColor(a.visProp.strokeColor)+",";this.psTricksString+="dotstyle=";if(a.visProp.face=="cross"){this.psTricksString+="x, dotsize=";if(a.visProp.size==2){this.psTricksString+="2pt 2"}else{if(a.visProp.size==3){this.psTricksString+="5pt 2"}else{if(a.visProp.size>=4){this.psTricksString+="5pt 3"}}}}else{if(a.visProp.face=="circle"){this.psTricksString+="*, dotsize=";if(a.visProp.size==1){this.psTricksString+="2pt 2"}else{if(a.visProp.size==2){this.psTricksString+="4pt 2"}else{if(a.visProp.size==3){this.psTricksString+="6pt 2"}else{if(a.visProp.size>=4){this.psTricksString+="6pt 3"}}}}}else{if(a.visProp.face=="square"){this.psTricksString+="square*, dotsize=";if(a.visProp.size==2){this.psTricksString+="2pt 2"}else{if(a.visProp.size==3){this.psTricksString+="5pt 2"}else{if(a.visProp.size>=4){this.psTricksString+="5pt 3"}}}}else{if(a.visProp.face=="plus"){this.psTricksString+="+, dotsize=";if(a.visProp.size==2){this.psTricksString+="2pt 2"}else{if(a.visProp.size==3){this.psTricksString+="5pt 2"}else{if(a.visProp.size>=4){this.psTricksString+="5pt 3"}}}}}}}this.psTricksString+="]";this.psTricksString+="("+a.coords.usrCoords[1]+","+a.coords.usrCoords[2]+")\n";this.psTricksString+="\\rput("+(a.coords.usrCoords[1]+15/a.board.stretchY)+","+(a.coords.usrCoords[2]+15/a.board.stretchY)+"){\\small $"+a.name+"$}\n"};JXG.PsTricks.addLine=function(d){var b=new JXG.Coords(JXG.COORDS_BY_USER,d.point1.coords.usrCoords,d.board);var a=new JXG.Coords(JXG.COORDS_BY_USER,d.point2.coords.usrCoords,d.board);if(d.visProp.straightFirst||d.visProp.straightLast){d.board.renderer.calcStraight(d,b,a)}this.psTricksString+="\\psline";this.psTricksString+="[linecolor="+this.parseColor(d.visProp.strokeColor)+", linewidth="+d.visProp.strokeWidth+"px";this.psTricksString+="]";if(d.visProp.firstArrow){if(d.visProp.lastArrow){this.psTricksString+="{<->}"}else{this.psTricksString+="{<-}"}}else{if(d.visProp.lastArrow){this.psTricksString+="{->}"}}this.psTricksString+="("+b.usrCoords[1]+","+b.usrCoords[2]+")("+a.usrCoords[1]+","+a.usrCoords[2]+")\n"};JXG.PsTricks.addCircle=function(b){var a=b.getRadius();this.psTricksString+="\\pscircle";this.psTricksString+="[linecolor="+this.parseColor(b.visProp.strokeColor)+", linewidth="+b.visProp.strokeWidth+"px";if(b.visProp.fillColor!="none"&&b.visProp.fillOpacity!=0){this.psTricksString+=", fillstyle=solid, fillcolor="+this.parseColor(b.visProp.fillColor)+", opacity="+JXG.Math.round(b.visProp.fillOpacity,5)}this.psTricksString+="]";this.psTricksString+="("+b.midpoint.coords.usrCoords[1]+","+b.midpoint.coords.usrCoords[2]+"){"+a+"}\n"};JXG.PsTricks.addPolygon=function(b){this.psTricksString+="\\pspolygon";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(b.visProp.fillColor)+", opacity="+JXG.Math.round(b.visProp.fillOpacity,5)+"]";for(var a=0;a<b.vertices.length;a++){this.psTricksString+="("+b.vertices[a].coords.usrCoords[1]+","+b.vertices[a].coords.usrCoords[2]+")"}this.psTricksString+="\n"};JXG.PsTricks.addArc=function(b){var a=b.getRadius();var e={};e.coords=new JXG.Coords(JXG.COORDS_BY_USER,[b.board.canvasWidth/(b.board.stretchY),b.midpoint.coords.usrCoords[2]],b.board);var d=JXG.Math.round(b.board.algebra.trueAngle(e,b.midpoint,b.point2),4);var g=JXG.Math.round(b.board.algebra.trueAngle(e,b.midpoint,b.point3),4);this.psTricksString+="\\psarc";this.psTricksString+="[linecolor="+this.parseColor(b.visProp.strokeColor)+", linewidth="+b.visProp.strokeWidth+"px";this.psTricksString+="]";if(b.visProp.lastArrow){if(b.visProp.firstArrow){this.psTricksString+="{<->}"}else{this.psTricksString+="{<-}"}}else{if(b.visProp.firstArrow){this.psTricksString+="{->}"}}this.psTricksString+="("+b.midpoint.coords.usrCoords[1]+","+b.midpoint.coords.usrCoords[2]+"){"+a+"}{"+d+"}{"+g+"}\n"};JXG.PsTricks.addSector=function(b){var a=b.getRadius();var e={};e.coords=new JXG.Coords(JXG.COORDS_BY_USER,[b.board.canvasWidth/(b.board.stretchY),b.midpoint.coords.usrCoords[2]],b.board);var d=JXG.Math.round(b.board.algebra.trueAngle(e,b.midpoint,b.point2),4);var g=JXG.Math.round(b.board.algebra.trueAngle(e,b.midpoint,b.point3),4);if(b.visProp.fillColor!="none"&&b.visProp.fillOpacity!=0){this.psTricksString+="\\pswedge";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(b.visProp.fillColor)+", opacity="+JXG.Math.round(b.visProp.fillOpacity,5)+"]";this.psTricksString+="("+b.midpoint.coords.usrCoords[1]+","+b.midpoint.coords.usrCoords[2]+"){"+a+"}{"+d+"}{"+g+"}\n"}};JXG.PsTricks.addAngle=function(b){var a=b.radius;var e={};e.coords=new JXG.Coords(JXG.COORDS_BY_USER,[b.board.canvasWidth/(b.board.stretchY),b.point2.coords.usrCoords[2]],b.board);var d=JXG.Math.round(b.board.algebra.trueAngle(e,b.point2,b.point1),4);var g=JXG.Math.round(b.board.algebra.trueAngle(e,b.point2,b.point3),4);if(b.visProp.fillColor!="none"&&b.visProp.fillOpacity!=0){this.psTricksString+="\\pswedge";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(b.visProp.fillColor)+", opacity="+JXG.Math.round(b.visProp.fillOpacity,5)+"]";this.psTricksString+="("+b.point2.coords.usrCoords[1]+","+b.point2.coords.usrCoords[2]+"){"+a+"}{"+d+"}{"+g+"}\n"}this.psTricksString+="\\psarc";this.psTricksString+="[linecolor="+this.parseColor(b.visProp.strokeColor)+", linewidth="+b.visProp.strokeWidth+"px";this.psTricksString+="]";this.psTricksString+="("+b.point2.coords.usrCoords[1]+","+b.point2.coords.usrCoords[2]+"){"+a+"}{"+d+"}{"+g+"}\n"};JXG.PsTricks.parseColor=function(a){var b=new JXG.RGBColor(a);return"{[rgb]{"+b.r/255+","+b.g/255+","+b.b/255+"}}"};JXG.Server=function(){};JXG.Server.modules=function(){};JXG.Server.runningCalls={};JXG.Server.handleError=function(a){alert("error occured, server says: "+a.message)};JXG.Server.callServer=function(action,callback,data,sync){var fileurl,passdata,AJAX,params,id,dataJSONStr,k;if(typeof sync=="undefined"||sync==null){sync=false}params="";for(k in data){params+="&"+escape(k)+"="+escape(data[k])}dataJSONStr=JXG.toJSON(data);do{id=action+Math.floor(Math.random()*4096)}while(typeof this.runningCalls[id]!="undefined");this.runningCalls[id]={action:action};if(typeof data.module!="undefined"){this.runningCalls[id].module=data.module}fileurl=JXG.serverBase+"JXGServer.py";passdata="action="+escape(action)+"&id="+id+"&dataJSON="+escape(JXG.Util.Base64.encode(dataJSONStr));this.cbp=function(d){var str,data,tmp,inject,paramlist,id,i,j;str=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(d))).unzip();if(JXG.isArray(str)&&str.length>0){str=str[0][0]}if(typeof str!="string"){return}data=eval("("+str+")");if(data.type=="error"){this.handleError(data)}else{if(data.type=="response"){id=data.id;for(i=0;i<data.fields.length;i++){tmp=data.fields[i];inject=tmp.namespace+(typeof eval(tmp.namespace)=="object"?".":".prototype.")+tmp.name+" = "+tmp.value;eval(inject)}for(i=0;i<data.handler.length;i++){tmp=data.handler[i];paramlist=[];for(j=0;j<tmp.parameters.length;j++){paramlist[j]='"'+tmp.parameters[j]+'": '+tmp.parameters[j]}inject="if(typeof JXG.Server.modules."+this.runningCalls[id].module+' == "undefined")JXG.Server.modules.'+this.runningCalls[id].module+" = {};";inject+="JXG.Server.modules."+this.runningCalls[id].module+"."+tmp.name+"_cb = "+tmp.callback+";";inject+="JXG.Server.modules."+this.runningCalls[id].module+"."+tmp.name+" = function ("+tmp.parameters.join(",")+', __JXGSERVER_CB__) {if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.'+this.runningCalls[id].module+"."+tmp.name+"_cb;var __JXGSERVER_PAR__ = {"+paramlist.join(",")+', "module": "'+this.runningCalls[id].module+'", "handler": "'+tmp.name+'" };JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__);};';eval(inject)}delete this.runningCalls[id];callback(data.data)}}};this.cb=JXG.bind(this.cbp,this);if(window.XMLHttpRequest){AJAX=new XMLHttpRequest();AJAX.overrideMimeType("text/plain; charset=iso-8859-1")}else{AJAX=new ActiveXObject("Microsoft.XMLHTTP")}if(AJAX){AJAX.open("POST",fileurl,!sync);AJAX.setRequestHeader("Content-type","application/x-www-form-urlencoded");if(!sync){AJAX.onreadystatechange=(function(cb){return function(){switch(AJAX.readyState){case 4:if(AJAX.status!=200){alert("Fehler:"+AJAX.status)}else{cb(AJAX.responseText)}break;default:return false;break}}})(this.cb)}AJAX.send(passdata);if(sync){this.cb(AJAX.responseText)}}else{return false}};JXG.Server.loadModule_cb=function(b){var a;for(a=0;a<b.length;a++){alert(b[a].name+": "+b[a].value)}};JXG.Server.loadModule=function(a){JXG.Server.callServer("load",JXG.Server.loadModule_cb,{module:a},true)};JXG.DataSource=function(){this.data=[];this.columnHeaders=[];this.rowHeaders=[];return this};JXG.DataSource.prototype.loadFromArray=function(g,h,e){var d,b,a;if(typeof h=="undefined"){h=false}if(typeof e=="undefined"){e=false}if(JXG.isArray(h)){this.columnHeader=h;h=false}if(JXG.isArray(e)){this.rowHeader=e;e=false}this.data=[];if(h){this.columnHeader=[]}if(e){this.rowHeader=[]}if(typeof g!="undefined"){this.data=new Array(g.length);for(d=0;d<g.length;d++){this.data[d]=new Array(g[d].length);for(b=0;b<g[d].length;b++){a=g[d][b];if(""+parseFloat(a)==a){this.data[d][b]=parseFloat(a)}else{if(a!="-"){this.data[d][b]=a}else{this.data[d][b]=NaN}}}}if(h){this.columnHeader=this.data[0].slice(1);this.data=this.data.slice(1)}if(e){this.rowHeader=new Array();for(d=0;d<this.data.length;d++){this.rowHeader.push(this.data[d][0]);this.data[d]=this.data[d].slice(1)}}}return this};JXG.DataSource.prototype.loadFromTable=function(l,d,h){var m,g,e,b,k,a;if(typeof d=="undefined"){d=false}if(typeof h=="undefined"){h=false}if(JXG.isArray(d)){this.columnHeader=d;d=false}if(JXG.isArray(h)){this.rowHeader=h;h=false}this.data=[];if(d){this.columnHeader=[]}if(h){this.rowHeader=[]}l=document.getElementById(l);if(typeof l!="undefined"){m=l.getElementsByTagName("tr");this.data=new Array(m.length);for(g=0;g<m.length;g++){b=m[g].getElementsByTagName("td");this.data[g]=new Array(b.length);for(e=0;e<b.length;e++){k=b[e].innerHTML;if(""+parseFloat(k)==k){this.data[g][e]=parseFloat(k)}else{if(k!="-"){this.data[g][e]=k}else{this.data[g][e]=NaN}}}}if(d){this.columnHeader=this.data[0].slice(1);this.data=this.data.slice(1)}if(h){this.rowHeader=new Array();for(g=0;g<this.data.length;g++){this.rowHeader.push(this.data[g][0]);this.data[g]=this.data[g].slice(1)}}}return this};JXG.DataSource.prototype.addColumn=function(a,d,b){};JXG.DataSource.prototype.addRow=function(a,d,b){};JXG.DataSource.prototype.getColumn=function(b){var a=new Array(this.data.length),d;if(typeof b=="string"){for(d=0;d<this.columnHeader.length;d++){if(b==this.columnHeader[d]){b=d;break}}}for(d=0;d<this.data.length;d++){if(this.data[d].length>b){a[d]=this.data[d][b]}}return a};JXG.DataSource.prototype.getRow=function(d){var a,b;if(typeof d=="string"){for(b=0;b<this.rowHeader.length;b++){if(d==this.rowHeader[b]){d=b;break}}}a=new Array(this.data[d].length);for(b=0;b<this.data[d].length;b++){a[b]=this.data[d][b]}return a};JXG.SVGRenderer=function(a){this.constructor();this.svgRoot=null;this.suspendHandle=null;this.svgNamespace="http://www.w3.org/2000/svg";this.xlinkNamespace="http://www.w3.org/1999/xlink";this.container=a;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position==""){this.container.style.position="relative"}this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg");this.container.appendChild(this.svgRoot);this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs");this.svgRoot.appendChild(this.defs);this.filter=this.container.ownerDocument.createElementNS(this.svgNamespace,"filter");this.filter.setAttributeNS(null,"id","f1");this.filter.setAttributeNS(null,"width","300%");this.filter.setAttributeNS(null,"height","300%");this.feOffset=this.container.ownerDocument.createElementNS(this.svgNamespace,"feOffset");this.feOffset.setAttributeNS(null,"result","offOut");this.feOffset.setAttributeNS(null,"in","SourceAlpha");this.feOffset.setAttributeNS(null,"dx","5");this.feOffset.setAttributeNS(null,"dy","5");this.filter.appendChild(this.feOffset);this.feGaussianBlur=this.container.ownerDocument.createElementNS(this.svgNamespace,"feGaussianBlur");this.feGaussianBlur.setAttributeNS(null,"result","blurOut");this.feGaussianBlur.setAttributeNS(null,"in","offOut");this.feGaussianBlur.setAttributeNS(null,"stdDeviation","3");this.filter.appendChild(this.feGaussianBlur);this.feBlend=this.container.ownerDocument.createElementNS(this.svgNamespace,"feBlend");this.feBlend.setAttributeNS(null,"in","SourceGraphic");this.feBlend.setAttributeNS(null,"in2","blurOut");this.feBlend.setAttributeNS(null,"mode","normal");this.filter.appendChild(this.feBlend);this.defs.appendChild(this.filter);this.images=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.images);this.grid=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.grid);this.angles=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.angles);this.sectors=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.sectors);this.polygone=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.polygone);this.curves=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.curves);this.circles=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.circles);this.lines=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.lines);this.arcs=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.arcs);this.points=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.points);this.dashArray=["2, 2","5, 5","10, 10","20, 20","20, 10, 10, 10","20, 5, 10, 5"]};JXG.SVGRenderer.prototype=new JXG.AbstractRenderer;JXG.SVGRenderer.prototype.setShadow=function(a){if(a.rendNode!=null){if(a.visProp.shadow){a.rendNode.setAttributeNS(null,"filter","url(#f1)")}else{a.rendNode.removeAttributeNS(null,"filter")}}};JXG.SVGRenderer.prototype.setGradient=function(d){var p=d.rendNode,e,h;if(d.type==JXG.OBJECT_TYPE_ARC||d.type==JXG.OBJECT_TYPE_ANGLE){p=d.rendNode2}if(typeof d.visProp.fillOpacity=="function"){h=d.visProp.fillOpacity()}else{h=d.visProp.fillOpacity}h=(h>0)?h:0;if(typeof d.visProp.fillColor=="function"){e=d.visProp.fillColor()}else{e=d.visProp.fillColor}if(d.visProp.gradient=="linear"){var g=this.createPrimitive("linearGradient",d.id+"_gradient");var b="0%";var a="100%";var l="0%";var k="0%";g.setAttributeNS(null,"x1",b);g.setAttributeNS(null,"x2",a);g.setAttributeNS(null,"y1",l);g.setAttributeNS(null,"y2",k);var o=this.createPrimitive("stop",d.id+"_gradient1");o.setAttributeNS(null,"offset","0%");o.setAttributeNS(null,"style","stop-color:"+e+";stop-opacity:"+h);var m=this.createPrimitive("stop",d.id+"_gradient2");m.setAttributeNS(null,"offset","100%");m.setAttributeNS(null,"style","stop-color:"+d.visProp.gradientSecondColor+";stop-opacity:"+d.visProp.gradientSecondOpacity);g.appendChild(o);g.appendChild(m);this.defs.appendChild(g);p.setAttributeNS(null,"style","fill:url(#"+d.id+"_gradient)");d.gradNode1=o;d.gradNode2=m}else{if(d.visProp.gradient=="radial"){var g=this.createPrimitive("radialGradient",d.id+"_gradient");g.setAttributeNS(null,"cx","50%");g.setAttributeNS(null,"cy","50%");g.setAttributeNS(null,"r","50%");g.setAttributeNS(null,"fx",d.visProp.gradientPositionX*100+"%");g.setAttributeNS(null,"fy",d.visProp.gradientPositionY*100+"%");var o=this.createPrimitive("stop",d.id+"_gradient1");o.setAttributeNS(null,"offset","0%");o.setAttributeNS(null,"style","stop-color:"+d.visProp.gradientSecondColor+";stop-opacity:"+d.visProp.gradientSecondOpacity);var m=this.createPrimitive("stop",d.id+"_gradient2");m.setAttributeNS(null,"offset","100%");m.setAttributeNS(null,"style","stop-color:"+e+";stop-opacity:"+h);g.appendChild(o);g.appendChild(m);this.defs.appendChild(g);p.setAttributeNS(null,"style","fill:url(#"+d.id+"_gradient)");d.gradNode1=o;d.gradNode2=m}else{p.removeAttributeNS(null,"style")}}};JXG.SVGRenderer.prototype.updateGradient=function(e){var b=e.gradNode1,a=e.gradNode2,d,g;if(b==null||a==0){return}if(typeof e.visProp.fillOpacity=="function"){g=e.visProp.fillOpacity()}else{g=e.visProp.fillOpacity}g=(g>0)?g:0;if(typeof e.visProp.fillColor=="function"){d=e.visProp.fillColor()}else{d=e.visProp.fillColor}if(e.visProp.gradient=="linear"){b.setAttributeNS(null,"style","stop-color:"+d+";stop-opacity:"+g);a.setAttributeNS(null,"style","stop-color:"+e.visProp.gradientSecondColor+";stop-opacity:"+e.visProp.gradientSecondOpacity)}else{if(e.visProp.gradient=="radial"){b.setAttributeNS(null,"style","stop-color:"+e.visProp.gradientSecondColor+";stop-opacity:"+e.visProp.gradientSecondOpacity);a.setAttributeNS(null,"style","stop-color:"+d+";stop-opacity:"+g)}}};JXG.SVGRenderer.prototype.displayCopyright=function(d,e){var b=this.createPrimitive("text","licenseText"),a;b.setAttributeNS(null,"x","20");b.setAttributeNS(null,"y",2+e);b.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+e+"px; fill:#356AA0;  opacity:0.3;");a=document.createTextNode(d);b.appendChild(a);this.appendChildPrimitive(b,"images")};JXG.SVGRenderer.prototype.drawTicks=function(a){var b=this.createPrimitive("path",a.id);b.setAttributeNS(null,"shape-rendering","crispEdges");this.appendChildPrimitive(b,"lines");this.appendNodesToElement(a,"path")};JXG.SVGRenderer.prototype.updateTicks=function(e,g,a,k,b){var h="",l,o,d,m=e.ticks.length;for(l=0;l<m;l++){o=e.ticks[l].scrCoords;if(e.ticks[l].major){if(e.labels[l].visProp.visible){this.drawText(e.labels[l])}h+="M "+(o[1]+g)+" "+(o[2]-a)+" L "+(o[1]-g)+" "+(o[2]+a)+" "}else{h+="M "+(o[1]+k)+" "+(o[2]-b)+" L "+(o[1]-k)+" "+(o[2]+b)+" "}}d=document.getElementById(e.id);if(d==null){d=this.createPrimitive("path",e.id);d.setAttributeNS(null,"shape-rendering","crispEdges");this.appendChildPrimitive(d,"lines");this.appendNodesToElement(e,"path")}d.setAttributeNS(null,"stroke",e.visProp.strokeColor);d.setAttributeNS(null,"stroke-opacity",e.visProp.strokeOpacity);d.setAttributeNS(null,"stroke-width",e.visProp.strokeWidth);this.updatePathPrimitive(d,h,e.board)};JXG.SVGRenderer.prototype.drawArc=function(b){var d=this.createPrimitive("path",b.id),k,e,a,l,g,h,o,m;b.rendNode=d;k=b.getRadius();e=b.board.algebra.trueAngle(b.point2,b.midpoint,b.point3);a={};a.midpoint=b.midpoint;a.getRadius=function(){return k};l=b.board.algebra.projectPointToCircle(b.point3,a);g="M "+b.point2.coords.scrCoords[1]+" "+b.point2.coords.scrCoords[2]+" A ";g+=Math.round(k*b.board.stretchX)+" "+Math.round(k*b.board.stretchY)+" 0 ";if(e>=180){g+="1 "}else{g+="0 "}g+="0 ";g+=l.scrCoords[1]+" "+l.scrCoords[2];this.updatePathPrimitive(d,g,b.board);if(b.visProp.strokeColor!=null){d.setAttributeNS(null,"stroke",b.visProp.strokeColor)}if(b.visProp.strokeOpacity!=null){d.setAttributeNS(null,"stroke-opacity",b.visProp.strokeOpacity)}if(b.visProp.strokeWidth!=null){d.setAttributeNS(null,"stroke-width",b.visProp.strokeWidth)}d.setAttributeNS(null,"fill","none");this.setDashStyle(b,b.visProp);this.setShadow(b);if(b.visProp.firstArrow){o=this.createArrowHead(b,"Start");this.defs.appendChild(o);b.rendNodeTriangleStart=o;d.setAttributeNS(null,"marker-end","url(#"+b.id+"TriangleStart)")}if(b.visProp.lastArrow){o=this.createArrowHead(b,"End");this.defs.appendChild(o);b.rendNodeTriangleEnd=o;d.setAttributeNS(null,"marker-start","url(#"+b.id+"TriangleEnd)")}m=this.createPrimitive("path",b.id+"sector");b.rendNode2=m;h="M "+b.midpoint.coords.scrCoords[1]+" "+b.midpoint.coords.scrCoords[2];h+=" L "+b.point2.coords.scrCoords[1]+" "+b.point2.coords.scrCoords[2]+" A ";h+=Math.round(k*b.board.stretchX)+" "+Math.round(k*b.board.stretchY)+" 0 ";if(e>=180){h+="1 "}else{h+="0 "}h+="0 ";h+=l.scrCoords[1]+" "+l.scrCoords[2];h+=" L "+b.midpoint.coords.scrCoords[1]+" "+b.midpoint.coords.scrCoords[2]+" z";this.updatePathPrimitive(m,h,b.board);if(b.visProp.fillColor!=null){m.setAttributeNS(null,"fill",b.visProp.fillColor)}if(b.visProp.fillOpacity!=null){m.setAttributeNS(null,"fill-opacity",b.visProp.fillOpacity)}m.setAttributeNS(null,"stroke","none");this.setGradient(b);this.arcs.appendChild(d);this.sectors.appendChild(m);if(b.visProp.draft){this.setDraft(b)}if(!b.visProp.visible){b.hideElement()}};JXG.SVGRenderer.prototype.updateArc=function(a){var b;this.remove(a.rendNode);this.remove(a.rendNode2);b=a.rendNodeTriangleStart;if(b!=null){this.remove(b)}b=a.rendNodeTriangleEnd;if(b!=null){this.remove(b)}this.drawArc(a);return};JXG.SVGRenderer.prototype.drawAngle=function(g){var l=g.board.algebra.trueAngle(g.point1,g.point2,g.point3),k,e,b,h,a,d;k={};k.midpoint=g.point2;k.getRadius=function(){return g.radius};e=g.board.algebra.projectPointToCircle(g.point1,k);b=g.board.algebra.projectPointToCircle(g.point3,k);h=this.createPrimitive("path",g.id+"_1");d="M "+g.point2.coords.scrCoords[1]+" "+g.point2.coords.scrCoords[2];d+=" L "+e.scrCoords[1]+" "+e.scrCoords[2]+" A ";d+=Math.round(g.radius*g.board.stretchX)+" "+Math.round(g.radius*g.board.stretchY)+" 0 ";if(l>=180){d+="1 "}else{d+="0 "}d+="0 ";d+=b.scrCoords[1]+" "+b.scrCoords[2];d+=" L "+g.point2.coords.scrCoords[1]+" "+g.point2.coords.scrCoords[2]+" z";h.setAttributeNS(null,"d",d);h.setAttributeNS(null,"fill",g.visProp.fillColor);h.setAttributeNS(null,"fill-opacity",g.visProp.fillOpacity);h.setAttributeNS(null,"stroke","none");a=this.createPrimitive("path",g.id+"_2");d="M "+e.scrCoords[1]+" "+e.scrCoords[2]+" A ";d+=Math.round(g.radius*g.board.stretchX)+" "+Math.round(g.radius*g.board.stretchY)+" 0 ";if(l>=180){d+="1 "}else{d+="0 "}d+="0 ";d+=b.scrCoords[1]+" "+b.scrCoords[2];a.setAttributeNS(null,"d",d);a.setAttributeNS(null,"id",g.id+"_2");a.setAttributeNS(null,"fill","none");a.setAttributeNS(null,"stroke",g.visProp.strokeColor);a.setAttributeNS(null,"stroke-opacity",g.visProp.strokeOpacity);this.appendChildPrimitive(h,"angles");g.rendNode=h;this.setShadow(g);this.appendChildPrimitive(a,"angles");g.rendNode2=a;this.setObjectStrokeWidth(g,g.visProp.strokeWidth)};JXG.SVGRenderer.prototype.updateAngle=function(a){this.remove(a.rendNode);this.remove(a.rendNode2);this.drawAngle(a);if(!a.visProp.visible){a.hideElement()}return};JXG.SVGRenderer.prototype.drawImage=function(b){var a="data:image/png;base64,"+b.imageBase64String,d=this.createPrimitive("image",b.id);d.setAttributeNS(this.xlinkNamespace,"xlink:href",a);this.appendChildPrimitive(d,b.displayLevel);b.rendNode=d;this.updateImage(b)};JXG.SVGRenderer.prototype.transformImage=function(b,a){var d=b.rendNode,e=d.getAttributeNS(null,"transform");e+=" "+this.joinTransforms(b,a);d.setAttributeNS(null,"transform",e)};JXG.SVGRenderer.prototype.joinTransforms=function(g,d){var h="",b,e,a=d.length;for(b=0;b<a;b++){e=d[b].matrix[1][1]+","+d[b].matrix[2][1]+","+d[b].matrix[1][2]+","+d[b].matrix[2][2]+","+d[b].matrix[1][0]+","+d[b].matrix[2][0];h+="matrix("+e+") "}return h};JXG.SVGRenderer.prototype.transformImageParent=function(d,a){var b,e;if(a!=null){b=a[1][1]+","+a[2][1]+","+a[1][2]+","+a[2][2]+","+a[1][0]+","+a[2][0];e="matrix("+b+")"}else{e=""}d.rendNode.setAttributeNS(null,"transform",e)};JXG.SVGRenderer.prototype.removeGrid=function(a){var b=this.grid;a.hasGrid=false;while(b.childNodes.length>0){b.removeChild(b.firstChild)}};JXG.SVGRenderer.prototype.setObjectStrokeColor=function(d,a,b){var h,g,e;if(b==undefined){b=1}if(typeof b=="function"){g=b()}else{g=b}g=(g>0)?g:0;if(typeof a=="function"){h=a()}else{h=a}e=d.rendNode;if(d.type==JXG.OBJECT_TYPE_TEXT){e.style.color=h}else{e.setAttributeNS(null,"stroke",h);e.setAttributeNS(null,"stroke-opacity",g)}if(d.type==JXG.OBJECT_TYPE_ARROW){d.rendNodeTriangle.setAttributeNS(null,"stroke",h);d.rendNodeTriangle.setAttributeNS(null,"stroke-opacity",g);d.rendNodeTriangle.setAttributeNS(null,"fill",h);d.rendNodeTriangle.setAttributeNS(null,"fill-opacity",g)}if(d.type==JXG.OBJECT_TYPE_ARC){if(d.visProp.firstArrow){d.rendNodeTriangleStart.setAttributeNS(null,"stroke",h);d.rendNodeTriangleStart.setAttributeNS(null,"stroke-opacity",g);d.rendNodeTriangleStart.setAttributeNS(null,"fill",h);d.rendNodeTriangleStart.setAttributeNS(null,"fill-opacity",g)}if(d.visProp.lastArrow){d.rendNodeTriangleEnd.setAttributeNS(null,"stroke",h);d.rendNodeTriangleEnd.setAttributeNS(null,"stroke-opacity",g);d.rendNodeTriangleEnd.setAttributeNS(null,"fill",h);d.rendNodeTriangleEnd.setAttributeNS(null,"fill-opacity",g)}}else{if(d.type==JXG.OBJECT_TYPE_LINE){if(d.visProp.firstArrow){d.rendNodeTriangleStart.setAttributeNS(null,"stroke",h);d.rendNodeTriangleStart.setAttributeNS(null,"stroke-opacity",g);d.rendNodeTriangleStart.setAttributeNS(null,"fill",h);d.rendNodeTriangleStart.setAttributeNS(null,"fill-opacity",g)}if(d.visProp.lastArrow){d.rendNodeTriangleEnd.setAttributeNS(null,"stroke",h);d.rendNodeTriangleEnd.setAttributeNS(null,"stroke-opacity",g);d.rendNodeTriangleEnd.setAttributeNS(null,"fill",h);d.rendNodeTriangleEnd.setAttributeNS(null,"fill-opacity",g)}}}};JXG.SVGRenderer.prototype.setObjectFillColor=function(d,a,b){var h,g,e;if(b==undefined){b=1}if(typeof b=="function"){g=b()}else{g=b}g=(g>0)?g:0;if(typeof a=="function"){h=a()}else{h=a}if(d.type==JXG.OBJECT_TYPE_ARC||d.type==JXG.OBJECT_TYPE_ANGLE){e=d.rendNode2;e.setAttributeNS(null,"fill",h);e.setAttributeNS(null,"fill-opacity",g)}else{e=d.rendNode;e.setAttributeNS(null,"fill",h);e.setAttributeNS(null,"fill-opacity",g)}if(d.visProp.gradient!=null){this.updateGradient(d)}};JXG.SVGRenderer.prototype.setObjectStrokeWidth=function(d,b){var a,e;if(typeof b=="function"){a=b()}else{a=b}if(d.elementClass!=JXG.OBJECT_CLASS_POINT){e;if(d.type==JXG.OBJECT_TYPE_ANGLE){e=d.rendNode2}else{e=d.rendNode}this.setPropertyPrimitive(e,"stroked","true");if(a!=null){this.setPropertyPrimitive(e,"stroke-width",a)}}else{e=d.rendNode;this.setPropertyPrimitive(e,"stroked","true");if(a!=null){this.setPropertyPrimitive(e,"stroke-width",a)}}};JXG.SVGRenderer.prototype.hide=function(a){var b;if(a==null){return}if(a.type==JXG.OBJECT_TYPE_ARC){b=a.rendNode;b.setAttributeNS(null,"display","none");b.style.visibility="hidden";b=a.rendNode2;b.setAttributeNS(null,"display","none");b.style.visibility="hidden"}else{if(a.type==JXG.OBJECT_TYPE_ANGLE){b=a.rendNode;b.setAttributeNS(null,"display","none");b.style.visibility="hidden";b=a.rendNode2;b.setAttributeNS(null,"display","none");b.style.visibility="hidden"}else{b=a.rendNode;b.setAttributeNS(null,"display","none");b.style.visibility="hidden"}}};JXG.SVGRenderer.prototype.show=function(a){var b;if(a.type==JXG.OBJECT_TYPE_ARC){b=a.rendNode;b.setAttributeNS(null,"display","inline");b.style.visibility="inherit";b=a.rendNode2;b.setAttributeNS(null,"display","inline");b.style.visibility="inherit"}else{if(a.type==JXG.OBJECT_TYPE_ANGLE){b=a.rendNode;b.setAttributeNS(null,"display","inline");b.style.visibility="inherit";b=a.rendNode2;b.setAttributeNS(null,"display","inline");b.style.visibility="inherit"}else{b=a.rendNode;b.setAttributeNS(null,"display","inline");b.style.visibility="inherit"}}};JXG.SVGRenderer.prototype.remove=function(a){if(a!=null&&a.parentNode!=null){a.parentNode.removeChild(a)}};JXG.SVGRenderer.prototype.suspendRedraw=function(){if(true){this.suspendHandle=this.svgRoot.suspendRedraw(10000)}};JXG.SVGRenderer.prototype.unsuspendRedraw=function(){if(true){this.svgRoot.unsuspendRedraw(this.suspendHandle);this.svgRoot.forceRedraw()}};JXG.SVGRenderer.prototype.setDashStyle=function(b,a){var e=b.visProp.dash,d=b.rendNode;if(b.visProp.dash>0){d.setAttributeNS(null,"stroke-dasharray",this.dashArray[e-1])}else{if(d.hasAttributeNS(null,"stroke-dasharray")){d.removeAttributeNS(null,"stroke-dasharray")}}};JXG.SVGRenderer.prototype.setGridDash=function(b){var a=document.getElementById(b);this.setPropertyPrimitive(a,"stroke-dasharray","5, 5")};JXG.SVGRenderer.prototype.createPrimitive=function(a,d){var b=this.container.ownerDocument.createElementNS(this.svgNamespace,a);b.setAttributeNS(null,"id",d);b.style.position="absolute";if(a=="path"){b.setAttributeNS(null,"stroke-linecap","butt");b.setAttributeNS(null,"stroke-linejoin","round")}return b};JXG.SVGRenderer.prototype.createArrowHead=function(d,g){var e=d.id+"Triangle",b,a;if(g!=null){e+=g}b=this.createPrimitive("marker",e);b.setAttributeNS(null,"viewBox","0 0 10 6");b.setAttributeNS(null,"refY","3");b.setAttributeNS(null,"markerUnits","strokeWidth");b.setAttributeNS(null,"markerHeight","6");b.setAttributeNS(null,"markerWidth","6");b.setAttributeNS(null,"orient","auto");b.setAttributeNS(null,"stroke",d.visProp.strokeColor);b.setAttributeNS(null,"stroke-opacity",d.visProp.strokeOpacity);b.setAttributeNS(null,"fill",d.visProp.strokeColor);b.setAttributeNS(null,"fill-opacity",d.visProp.strokeOpacity);a=this.container.ownerDocument.createElementNS(this.svgNamespace,"path");if(g=="End"){b.setAttributeNS(null,"refX","0");a.setAttributeNS(null,"d","M 0 3 L 10 6 L 10 0 z")}else{b.setAttributeNS(null,"refX","10");a.setAttributeNS(null,"d","M 0 0 L 10 3 L 0 6 z")}b.appendChild(a);return b};JXG.SVGRenderer.prototype.makeArrow=function(d,b,e){var a=this.createArrowHead(b,e);this.defs.appendChild(a);d.setAttributeNS(null,"marker-end","url(#"+b.id+"Triangle)");b.rendNodeTriangle=a};JXG.SVGRenderer.prototype.makeArrows=function(b){var a;if(b.visProp.firstArrow){a=b.rendNodeTriangleStart;if(a==null){a=this.createArrowHead(b,"End");this.defs.appendChild(a);b.rendNodeTriangleStart=a;b.rendNode.setAttributeNS(null,"marker-start","url(#"+b.id+"TriangleEnd)")}}else{a=b.rendNodeTriangleStart;if(a!=null){this.remove(a)}}if(b.visProp.lastArrow){a=b.rendNodeTriangleEnd;if(a==null){a=this.createArrowHead(b,"Start");this.defs.appendChild(a);b.rendNodeTriangleEnd=a;b.rendNode.setAttributeNS(null,"marker-end","url(#"+b.id+"TriangleStart)")}}else{a=b.rendNodeTriangleEnd;if(a!=null){this.remove(a)}}};JXG.SVGRenderer.prototype.updateLinePrimitive=function(g,b,a,e,d){g.setAttributeNS(null,"x1",b);g.setAttributeNS(null,"y1",a);g.setAttributeNS(null,"x2",e);g.setAttributeNS(null,"y2",d)};JXG.SVGRenderer.prototype.updateCirclePrimitive=function(d,a,e,b){d.setAttributeNS(null,"cx",(a));d.setAttributeNS(null,"cy",(e));d.setAttributeNS(null,"r",(b))};JXG.SVGRenderer.prototype.updateEllipsePrimitive=function(b,a,g,e,d){b.setAttributeNS(null,"cx",(a));b.setAttributeNS(null,"cy",(g));b.setAttributeNS(null,"rx",(e));b.setAttributeNS(null,"ry",(d))};JXG.SVGRenderer.prototype.updateRectPrimitive=function(e,a,g,b,d){e.setAttributeNS(null,"x",(a));e.setAttributeNS(null,"y",(g));e.setAttributeNS(null,"width",(b));e.setAttributeNS(null,"height",(d))};JXG.SVGRenderer.prototype.updatePathPrimitive=function(b,d,a){b.setAttributeNS(null,"d",d)};JXG.SVGRenderer.prototype.updatePathStringPrimitive=function(a){var d=" M ",e=" L ",b=d,o=5000,h="",g,l,m=(a.curveType!="plot"),k;if(a.numberPoints<=0){return""}if(m&&a.board.options.curve.RDPsmoothing){a.points=this.RamenDouglasPeuker(a.points,0.5)}k=Math.min(a.points.length,a.numberPoints);for(g=0;g<k;g++){l=a.points[g].scrCoords;if(isNaN(l[1])||isNaN(l[2])){b=d}else{if(l[1]>o){l[1]=o}else{if(l[1]<-o){l[1]=-o}}if(l[2]>o){l[2]=o}else{if(l[2]<-o){l[2]=-o}}h+=[b,l[1]," ",l[2]].join("");b=e}}return h};JXG.SVGRenderer.prototype.updatePathStringPoint=function(e,a,d){var b="";if(d=="x"){b="M "+(e.coords.scrCoords[1]-a)+" "+(e.coords.scrCoords[2]-a)+" L "+(e.coords.scrCoords[1]+a)+" "+(e.coords.scrCoords[2]+a)+" M "+(e.coords.scrCoords[1]+a)+" "+(e.coords.scrCoords[2]-a)+" L "+(e.coords.scrCoords[1]-a)+" "+(e.coords.scrCoords[2]+a)}else{if(d=="+"){b="M "+(e.coords.scrCoords[1]-a)+" "+(e.coords.scrCoords[2])+" L "+(e.coords.scrCoords[1]+a)+" "+(e.coords.scrCoords[2])+" M "+(e.coords.scrCoords[1])+" "+(e.coords.scrCoords[2]-a)+" L "+(e.coords.scrCoords[1])+" "+(e.coords.scrCoords[2]+a)}}return b};JXG.SVGRenderer.prototype.updatePolygonePrimitive=function(g,d){var h="",e,b,a=d.vertices.length;g.setAttributeNS(null,"stroke","none");for(b=0;b<a-1;b++){e=d.vertices[b].coords.scrCoords;h=h+e[1]+","+e[2];if(b<a-2){h+=" "}}g.setAttributeNS(null,"points",h)};JXG.SVGRenderer.prototype.appendChildPrimitive=function(a,b){switch(b){case"images":this.images.appendChild(a);break;case"grid":this.grid.appendChild(a);break;case"angles":this.angles.appendChild(a);break;case"sectors":this.sectors.appendChild(a);break;case"polygone":this.polygone.appendChild(a);break;case"curves":this.curves.appendChild(a);break;case"circles":this.circles.appendChild(a);break;case"lines":this.lines.appendChild(a);break;case"arcs":this.arcs.appendChild(a);break;case"points":this.points.appendChild(a);break}};JXG.SVGRenderer.prototype.setPropertyPrimitive=function(b,a,d){if(a=="stroked"){return}b.setAttributeNS(null,a,d)};JXG.SVGRenderer.prototype.drawVerticalGrid=function(e,b,h,d){var g=this.createPrimitive("path","gridx"),a="";while(e.scrCoords[1]<b.scrCoords[1]+h-1){a+=" M "+e.scrCoords[1]+" "+0+" L "+e.scrCoords[1]+" "+d.canvasHeight+" ";e.setCoordinates(JXG.COORDS_BY_SCREEN,[e.scrCoords[1]+h,e.scrCoords[2]])}this.updatePathPrimitive(g,a,d);return g};JXG.SVGRenderer.prototype.drawHorizontalGrid=function(e,b,h,d){var g=this.createPrimitive("path","gridy"),a="";while(e.scrCoords[2]<=b.scrCoords[2]+h-1){a+=" M "+0+" "+e.scrCoords[2]+" L "+d.canvasWidth+" "+e.scrCoords[2]+" ";e.setCoordinates(JXG.COORDS_BY_SCREEN,[e.scrCoords[1],e.scrCoords[2]+h])}this.updatePathPrimitive(g,a,d);return g};JXG.SVGRenderer.prototype.appendNodesToElement=function(a,b){a.rendNode=document.getElementById(a.id)};JXG.VMLRenderer=function(a){this.constructor();this.container=a;this.container.style.overflow="hidden";this.container.onselectstart=function(){return false};this.resolution=10;a.ownerDocument.namespaces.add("v","urn:schemas-microsoft-com:vml");a.ownerDocument.createStyleSheet().addRule("v\\:*","behavior: url(#default#VML);");this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]};JXG.VMLRenderer.prototype=new JXG.AbstractRenderer;JXG.VMLRenderer.prototype.setShadow=function(a){var b=a.rendNodeShadow;if(!b){return}if(a.visProp.shadow){b.setAttribute("On","True");b.setAttribute("Offset","3pt,3pt");b.setAttribute("Opacity","60%");b.setAttribute("Color","#aaaaaa")}else{b.setAttribute("On","False")}};JXG.VMLRenderer.prototype.setGradient=function(b){var a=b.rendNodeFill;if(b.type==JXG.OBJECT_TYPE_ARC||b.type==JXG.OBJECT_TYPE_ANGLE){a=b.rendNode2Fill}if(b.visProp.gradient=="linear"){a.setAttribute("type","gradient");a.setAttribute("color2",b.visProp.gradientSecondColor);a.setAttribute("opacity2",b.visProp.gradientSecondOpacity);a.setAttribute("angle",b.visProp.gradientAngle)}else{if(b.visProp.gradient=="radial"){a.setAttribute("type","gradientradial");a.setAttribute("color2",b.visProp.gradientSecondColor);a.setAttribute("opacity2",b.visProp.gradientSecondOpacity);a.setAttribute("focusposition",b.visProp.gradientPositionX*100+"%,"+b.visProp.gradientPositionY*100+"%");a.setAttribute("focussize","0,0")}else{a.setAttribute("type","solid")}}};JXG.VMLRenderer.prototype.updateGradient=function(a){};JXG.VMLRenderer.prototype.addShadowToGroup=function(a,d){var b,e;if(a=="lines"){for(b in d.objects){e=d.objects[b];if(e.elementClass==JXG.OBJECT_CLASS_LINE){this.addShadowToElement(e)}}}else{if(a=="points"){for(b in d.objects){e=d.objects[b];if(e.elementClass==JXG.OBJECT_CLASS_POINT){this.addShadowToElement(e)}}}else{if(a=="circles"){for(b in d.objects){e=d.objects[b];if(e.elementClass==JXG.OBJECT_CLASS_CIRCLE){this.addShadowToElement(e)}}}}}d.fullUpdate()};JXG.VMLRenderer.prototype.displayCopyright=function(d,e){var b,a;b=this.container.ownerDocument.createElement("v:textbox");b.style.position="absolute";b.setAttribute("id","licenseText");b.style.left=20;b.style.top=(2);b.style.fontSize=(e);b.style.color="#356AA0";b.style.fontFamily="Arial,Helvetica,sans-serif";b.setAttribute("opacity","30%");b.style.filter="alpha(opacity = 30)";a=document.createTextNode(d);b.appendChild(a);this.appendChildPrimitive(b,"images")};JXG.VMLRenderer.prototype.drawTicks=function(b){var a=this.createPrimitive("path",b.id);this.appendChildPrimitive(a,"lines");this.appendNodesToElement(b,"path")};JXG.VMLRenderer.prototype.updateTicks=function(e,g,a,h,d){var b=[],k,l,m,o;l=e.ticks.length;for(k=0;k<l;k++){m=e.ticks[k];if(m.major){if(e.labels[k].visProp.visible){this.drawText(e.labels[k])}b.push(" m "+Math.round(this.resolution*(m.scrCoords[1]+g))+", "+Math.round(this.resolution*(m.scrCoords[2]-a))+" l "+Math.round(this.resolution*(m.scrCoords[1]-g))+", "+Math.round(this.resolution*(m.scrCoords[2]+a))+" ")}else{b.push(" m "+Math.round(this.resolution*(m.scrCoords[1]+h))+", "+Math.round(this.resolution*(m.scrCoords[2]-d))+" l "+Math.round(this.resolution*(m.scrCoords[1]-h))+", "+Math.round(this.resolution*(m.scrCoords[2]+d))+" ")}}o=document.getElementById(e.id);if(o==null){o=this.createPrimitive("path",e.id);this.appendChildPrimitive(o,"lines");this.appendNodesToElement(e,"path")}o.setAttribute("stroked","true");o.setAttribute("strokecolor",e.visProp.strokeColor,1);o.setAttribute("strokeweight",e.visProp.strokeWidth);this.updatePathPrimitive(o,b,e.board)};JXG.VMLRenderer.prototype.drawArcLine=function(a,k,h,g,p,l,b){var d=this.container.ownerDocument.createElement("v:arc");d.setAttribute("id",a);var o=this.container.ownerDocument.createElement("v:fill");o.setAttribute("id",a+"_fill");var m=this.container.ownerDocument.createElement("v:stroke");m.setAttribute("id",a+"_stroke");var e=this.container.ownerDocument.createElement("v:shadow");e.setAttribute("id",a+"_shadow");d.appendChild(o);d.appendChild(m);d.appendChild(e);b.rendNode=d;b.rendNodeFill=o;b.rendNodeStroke=m;b.rendNodeShadow=e;d.style.position="absolute";d.setAttribute("filled","false");d.style.left=(p.coords.scrCoords[1]-Math.round(k*l.stretchX))+"px";d.style.top=(p.coords.scrCoords[2]-Math.round(k*l.stretchY))+"px";d.style.width=(Math.round(k*l.stretchX)*2)+"px";d.style.height=(Math.round(k*l.stretchY)*2)+"px";d.setAttribute("startangle",h);d.setAttribute("endangle",g);return d};JXG.VMLRenderer.prototype.drawArcFill=function(a,g,w,m,k,h,e){var s,q,o,l,b;a=a+"sector";var u=this.container.ownerDocument.createElement("v:fill");u.setAttribute("id",a+"_fill");var p=this.container.ownerDocument.createElement("v:stroke");p.setAttribute("id",a+"_stroke");var d=this.container.ownerDocument.createElement("v:shadow");d.setAttribute("id",a+"_shadow");pathNode=this.container.ownerDocument.createElement("v:path");pathNode.setAttribute("id",a+"_path");s=this.container.ownerDocument.createElement("v:shape");s.appendChild(u);s.appendChild(p);s.appendChild(d);s.appendChild(pathNode);s.setAttribute("id",a);s.style.position="absolute";e.rendNode2=s;e.rendNode2Fill=u;e.rendNode2Stroke=p;e.rendNode2Shadow=d;e.rendNode2Path=pathNode;s.setAttribute("stroked","false");q=Math.round(g*h.stretchX);o=Math.round(g*h.stretchY);s.style.width=q;s.style.height=o;s.setAttribute("coordsize",q+","+o);b="m "+w.coords.scrCoords[1]+","+w.coords.scrCoords[2]+" l ";b+=m.coords.scrCoords[1]+","+m.coords.scrCoords[2]+" at ";b+=(w.coords.scrCoords[1]-q)+","+(w.coords.scrCoords[2]-o)+",";b+=(w.coords.scrCoords[1]+q)+","+(w.coords.scrCoords[2]+o);b+=" "+m.coords.scrCoords[1]+","+m.coords.scrCoords[2];b+=", "+k.coords.scrCoords[1]+","+k.coords.scrCoords[2]+" l ";b+=w.coords.scrCoords[1]+","+w.coords.scrCoords[2]+" x e";pathNode.setAttribute("v",b);return s};JXG.VMLRenderer.prototype.drawArc=function(b){var k,a={},h,g,e,d,m,l={};k=b.getRadius();a.coords=new JXG.Coords(JXG.COORDS_BY_USER,[b.midpoint.coords.usrCoords[1],b.board.origin.scrCoords[2]/b.board.stretchY],b.board);g=b.board.algebra.trueAngle(b.point2,b.midpoint,a);h=b.board.algebra.trueAngle(b.point3,b.midpoint,a);if(g<h){h-=360}e=this.drawArcLine(b.id,k,h,g,b.midpoint,b.board,b);d=b.rendNodeStroke;if(b.visProp.lastArrow){d.setAttribute("endarrow","block");d.setAttribute("endarrowlength","long")}if(b.visProp.firstArrow){d.setAttribute("startarrow","block");d.setAttribute("startarrowlength","long")}this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setDashStyle(b,b.visProp);this.setShadow(b);l.coords=b.board.algebra.projectPointToCircle(b.point3,b);m=this.drawArcFill(b.id,k,b.midpoint,b.point2,l,b.board,b);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity);this.setGradient(b);this.appendChildPrimitive(e,"lines");this.appendChildPrimitive(m,"angles");if(b.visProp.draft){this.setDraft(b)}};JXG.AbstractRenderer.prototype.updateArc=function(a){this.remove(a.rendNode);this.remove(a.rendNode2);this.drawArc(a);return};JXG.VMLRenderer.prototype.drawAngle=function(e){var a={},u,s,b={},l,k,g,h,d,q={},m={},o;a.midpoint=e.point2;a.getRadius=function(){return e.radius};u=e.board.algebra.projectPointToCircle(e.point1,a);s=e.board.algebra.projectPointToCircle(e.point3,a);b.coords=new JXG.Coords(JXG.COORDS_BY_USER,[e.point2.coords.usrCoords[1],e.board.origin.scrCoords[2]/(e.board.stretchY)],e.board);k=e.board.algebra.trueAngle(e.point1,e.point2,b);l=e.board.algebra.trueAngle(e.point3,e.point2,b);if(k<l){l-=360}g=this.drawArcLine(e.id,e.radius,l,k,e.point2,e.board,e);this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setObjectStrokeWidth(e,e.visProp.strokeWidth);h=e.visProp.dash;d=e.rendNodeStroke;d.setAttribute("dashstyle",this.dashArray[h]);this.setShadow(e);q.coords=u;m.coords=s;o=this.drawArcFill(e.id,e.radius,e.point2,q,m,e.board,e);this.setObjectFillColor(e,e.visProp.fillColor,e.visProp.fillOpacity);this.appendChildPrimitive(g,"lines");this.appendChildPrimitive(o,"angles");if(e.visProp.draft){this.setDraft(e)}if(!e.visProp.visible){e.hideElement(e)}};JXG.VMLRenderer.prototype.updateAngle=function(a){this.remove(a.rendNode);this.remove(a.rendNode2);this.drawAngle(a);return};JXG.VMLRenderer.prototype.drawImage=function(b){var d,a;a="data:image/png;base64,"+b.imageBase64String;d=this.container.ownerDocument.createElement("img");d.style.position="absolute";d.setAttribute("id",b.id);d.setAttribute("src",a);this.container.appendChild(d);this.appendChildPrimitive(d,b.displayLevel);d.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand')";b.rendNode=d;this.updateImage(b)};JXG.VMLRenderer.prototype.transformImage=function(d,b){var e=d.rendNode,a;a=this.joinTransforms(d,b);e.style.left=(d.coords.scrCoords[1]+a[1][0])+"px";e.style.top=(d.coords.scrCoords[2]-d.size[1]+a[2][0])+"px";e.filters.item(0).M11=a[1][1];e.filters.item(0).M12=a[1][2];e.filters.item(0).M21=a[2][1];e.filters.item(0).M22=a[2][2]};JXG.VMLRenderer.prototype.joinTransforms=function(g,e){var b=[[1,0,0],[0,1,0],[0,0,1]],d,a=e.length;for(d=0;d<a;d++){b=JXG.Math.matMatMult(e[d].matrix,b)}return b};JXG.VMLRenderer.prototype.transformImageParent=function(b,a){};JXG.VMLRenderer.prototype.removeGrid=function(a){var b=document.getElementById("gridx");this.remove(b);b=document.getElementById("gridy");this.remove(b);a.hasGrid=false};JXG.VMLRenderer.prototype.hide=function(a){var b=a.rendNode;b.style.visibility="hidden";if(a.type==JXG.OBJECT_TYPE_ARC||a.type==JXG.OBJECT_TYPE_ANGLE){b=a.rendNode2;b.style.visibility="hidden"}};JXG.VMLRenderer.prototype.show=function(a){var b=a.rendNode;b.style.visibility="inherit";if(a.type==JXG.OBJECT_TYPE_ARC||a.type==JXG.OBJECT_TYPE_ANGLE){b=a.rendNode2;b.style.visibility="inherit"}};JXG.VMLRenderer.prototype.setDashStyle=function(b,a){var d;if(a.dash>=0){d=b.rendNodeStroke;d.setAttribute("dashstyle",this.dashArray[a.dash])}};JXG.VMLRenderer.prototype.setObjectStrokeColor=function(e,a,b){var k,h,g,d;if(typeof b=="function"){h=b()}else{h=b}h=(h>0)?h:0;if(typeof a=="function"){k=a()}else{k=a}if(e.type==JXG.OBJECT_TYPE_TEXT){e.rendNode.style.color=k}else{g=e.rendNode;g.setAttribute("stroked","true");g.setAttribute("strokecolor",k);if(e.id=="gridx"){d=document.getElementById("gridx_stroke")}else{if(e.id=="gridy"){d=document.getElementById("gridy_stroke")}else{d=e.rendNodeStroke}}if(h!=undefined){d.setAttribute("opacity",(h*100)+"%")}}};JXG.VMLRenderer.prototype.setObjectFillColor=function(d,a,b){var g,e;if(typeof b=="function"){e=b()}else{e=b}e=(e>0)?e:0;if(typeof a=="function"){g=a()}else{g=a}if(d.type==JXG.OBJECT_TYPE_ARC||d.type==JXG.OBJECT_TYPE_ANGLE){if(g=="none"){d.rendNode2.setAttribute("filled","false")}else{d.rendNode2.setAttribute("filled","true");d.rendNode2.setAttribute("fillcolor",g);if(e!=undefined){d.rendNode2Fill.setAttribute("opacity",(e*100)+"%")}}}else{if(g=="none"){d.rendNode.setAttribute("filled","false")}else{d.rendNode.setAttribute("filled","true");d.rendNode.setAttribute("fillcolor",g);if(e!=undefined&&d.rendNodeFill){d.rendNodeFill.setAttribute("opacity",(e*100)+"%")}}}};JXG.VMLRenderer.prototype.remove=function(a){if(a!=null){a.removeNode(true)}};JXG.VMLRenderer.prototype.suspendRedraw=function(){this.container.style.display="none"};JXG.VMLRenderer.prototype.unsuspendRedraw=function(){this.container.style.display=""};JXG.VMLRenderer.prototype.setAttributes=function(e,d,k,b){var h,a,g;len=d.length;for(a=0;a<len;a++){g=d[a];if(b[g]!=null){if(typeof b[g]=="function"){h=b[g]();h=(h>0)?h:0}else{h=b[g]}e.setAttribute(k[a],h)}}};JXG.VMLRenderer.prototype.setGridDash=function(b,a){var a=document.getElementById(b+"_stroke");a.setAttribute("dashstyle","Dash")};JXG.VMLRenderer.prototype.setObjectStrokeWidth=function(d,b){var a,e;if(typeof b=="function"){a=b()}else{a=b}if(d.elementClass!=JXG.OBJECT_CLASS_POINT){e=d.rendNode;this.setPropertyPrimitive(e,"stroked","true");if(a!=null){this.setPropertyPrimitive(e,"stroke-width",a)}}else{e=d.rendNode;this.setPropertyPrimitive(e,"stroked","true");if(a!=null){this.setPropertyPrimitive(e,"stroke-width",a)}}};JXG.VMLRenderer.prototype.createPrimitive=function(b,k){var d,a,h,g,e;a=this.container.ownerDocument.createElement("v:fill");a.setAttribute("id",k+"_fill");h=this.container.ownerDocument.createElement("v:stroke");h.setAttribute("id",k+"_stroke");g=this.container.ownerDocument.createElement("v:shadow");g.setAttribute("id",k+"_shadow");if(b=="circle"||b=="ellipse"){d=this.container.ownerDocument.createElement("v:oval");d.appendChild(a);d.appendChild(h);d.appendChild(g)}else{if(b=="polygon"||b=="path"||b=="shape"){d=this.container.ownerDocument.createElement("v:shape");d.appendChild(a);d.appendChild(h);d.appendChild(g);e=this.container.ownerDocument.createElement("v:path");e.setAttribute("id",k+"_path");d.appendChild(e)}else{d=this.container.ownerDocument.createElement("v:"+b);d.appendChild(a);d.appendChild(h);d.appendChild(g)}}d.style.position="absolute";d.setAttribute("id",k);return d};JXG.VMLRenderer.prototype.appendNodesToElement=function(a,b){if(b=="shape"||b=="path"||b=="polygon"){a.rendNodePath=document.getElementById(a.id+"_path")}a.rendNodeFill=document.getElementById(a.id+"_fill");a.rendNodeStroke=document.getElementById(a.id+"_stroke");a.rendNodeShadow=document.getElementById(a.id+"_shadow");a.rendNode=document.getElementById(a.id)};JXG.VMLRenderer.prototype.makeArrow=function(d,b,e){var a=b.rendNodeStroke;a.setAttribute("endarrow","block");a.setAttribute("endarrowlength","long")};JXG.VMLRenderer.prototype.makeArrows=function(b){var a;if(b.visProp.firstArrow){a=b.rendNodeStroke;a.setAttribute("startarrow","block");a.setAttribute("startarrowlength","long")}else{a=b.rendNodeStroke;if(a!=null){a.setAttribute("startarrow","none")}}if(b.visProp.lastArrow){a=b.rendNodeStroke;a.setAttribute("id",b.id+"stroke");a.setAttribute("endarrow","block");a.setAttribute("endarrowlength","long")}else{a=b.rendNodeStroke;if(a!=null){a.setAttribute("endarrow","none")}}};JXG.VMLRenderer.prototype.updateLinePrimitive=function(g,b,a,e,d){g.setAttribute("from",[b,a].join(","));g.setAttribute("to",[e,d].join(","))};JXG.VMLRenderer.prototype.updateCirclePrimitive=function(d,a,e,b){d.style.left=(a-b)+"px";d.style.top=(e-b)+"px";d.style.width=(b*2)+"px";d.style.height=(b*2)+"px"};JXG.VMLRenderer.prototype.updateRectPrimitive=function(e,a,g,b,d){e.style.left=(a)+"px";e.style.top=(g)+"px";e.style.width=(b)+"px";e.style.height=(d)+"px"};JXG.VMLRenderer.prototype.updateEllipsePrimitive=function(b,a,g,e,d){b.style.left=(a-e)+"px";b.style.top=(g-d)+"px";b.style.width=(e*2)+"px";b.style.height=(d*2)+"px"};JXG.VMLRenderer.prototype.updatePathPrimitive=function(d,e,b){var a=b.canvasWidth,g=b.canvasHeight;d.style.width=a;d.style.height=g;d.setAttribute("coordsize",[(this.resolution*a),(this.resolution*g)].join(","));d.setAttribute("path",e.join(""))};JXG.VMLRenderer.prototype.updatePathStringPrimitive=function(b){var l=[],k,o,a=this.resolution,h=Math.round,e=" m ",g=" l ",d=e,p=(b.curveType!="plot"),m=Math.min(b.numberPoints,8192);if(b.numberPoints<=0){return""}if(p&&b.board.options.curve.RDPsmoothing){b.points=this.RamenDouglasPeuker(b.points,1)}m=Math.min(m,b.points.length);for(k=0;k<m;k++){o=b.points[k].scrCoords;if(isNaN(o[1])||isNaN(o[2])){d=e}else{if(o[1]>20000){o[1]=20000}else{if(o[1]<-20000){o[1]=-20000}}if(o[2]>20000){o[2]=20000}else{if(o[2]<-20000){o[2]=-20000}}l.push([d,h(a*o[1]),", ",h(a*o[2])].join(""));d=g}}l.push(" e");return l};JXG.VMLRenderer.prototype.updatePathStringPoint=function(e,a,d){var b=[],h=e.coords.scrCoords,g=this.resolution;if(d=="x"){b.push(["m ",(g*(h[1]-a)),", ",(g*(h[2]-a))," l ",(g*(h[1]+a)),", ",(g*(h[2]+a))," m ",(g*(h[1]+a)),", ",(g*(h[2]-a))," l ",(g*(h[1]-a)),", ",(g*(h[2]+a))].join(""))}else{if(d=="+"){b.push(["m ",(g*(h[1]-a)),", ",(g*(h[2]))," l ",(g*(h[1]+a)),", ",(g*(h[2]))," m ",(g*(h[1])),", ",(g*(h[2]-a))," l ",(g*(h[1])),", ",(g*(h[2]+a))].join(""))}}return b};JXG.VMLRenderer.prototype.updatePolygonePrimitive=function(g,d){var h=d.vertices[0].coords.scrCoords[1],b=d.vertices[0].coords.scrCoords[1],e=d.vertices[0].coords.scrCoords[2],a=d.vertices[0].coords.scrCoords[2],k,m=d.vertices.length,o,q,p,l=[];g.setAttribute("stroked","false");for(k=1;k<m-1;k++){o=d.vertices[k].coords.scrCoords;if(o[1]<h){h=o[1]}if(o[1]>b){b=o[1]}if(o[2]<e){e=o[2]}if(o[2]>a){a=o[2]}}q=Math.round(b-h);p=Math.round(a-e);g.style.width=q;g.style.height=p;g.setAttribute("coordsize",q+","+p);o=d.vertices[0].coords.scrCoords;l.push(["m ",o[1],",",o[2]," l "].join(""));for(k=1;k<m-1;k++){o=d.vertices[k].coords.scrCoords;l.push(o[1]+","+o[2]);if(k<m-2){l.push(", ")}}l.push(" x e");g.setAttribute("path",l.join(""))};JXG.VMLRenderer.prototype.appendChildPrimitive=function(a,b){switch(b){case"images":a.style.zIndex="1";break;case"grid":a.style.zIndex="1";break;case"angles":a.style.zIndex="2";break;case"sectors":a.style.zIndex="2";break;case"polygone":a.style.zIndex="2";break;case"curves":a.style.zIndex="4";break;case"circles":a.style.zIndex="4";break;case"lines":a.style.zIndex="4";break;case"arcs":a.style.zIndex="4";break;case"points":a.style.zIndex="5";break}this.container.appendChild(a)};JXG.VMLRenderer.prototype.setPropertyPrimitive=function(g,e,h){var d="",a,b;switch(e){case"stroke":d="strokecolor";break;case"stroke-width":d="strokeweight";break;case"stroke-dasharray":d="dashstyle";break}if(d!=""){b;if(typeof h=="function"){b=h()}else{b=h}g.setAttribute(d,b)}};JXG.VMLRenderer.prototype.drawVerticalGrid=function(e,b,h,d){var g=this.createPrimitive("path","gridx"),a=[];while(e.scrCoords[1]<b.scrCoords[1]+h-1){a.push(" m "+(this.resolution*e.scrCoords[1])+", "+0+" l "+(this.resolution*e.scrCoords[1])+", "+(this.resolution*d.canvasHeight)+" ");e.setCoordinates(JXG.COORDS_BY_SCREEN,[e.scrCoords[1]+h,e.scrCoords[2]])}this.updatePathPrimitive(g,a,d);return g};JXG.VMLRenderer.prototype.drawHorizontalGrid=function(e,b,h,d){var g=this.createPrimitive("path","gridy"),a=[];while(e.scrCoords[2]<=b.scrCoords[2]+h-1){a.push(" m "+0+", "+(this.resolution*e.scrCoords[2])+" l "+(this.resolution*d.canvasWidth)+", "+(this.resolution*e.scrCoords[2])+" ");e.setCoordinates(JXG.COORDS_BY_SCREEN,[e.scrCoords[1],e.scrCoords[2]+h])}this.updatePathPrimitive(g,a,d);return g};