/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.validation.ValidationMetadata;

public class InputTextTag
extends InputTagSupport
implements BodyTag {
    private Object value;
    private String maxlength;

    public InputTextTag() {
        this.getAttributes().put("type", "text");
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public String getMaxlength() {
        return this.maxlength;
    }

    protected String getEffectiveMaxlength() throws StripesJspException {
        if (this.getMaxlength() == null) {
            ValidationMetadata validation = this.getValidationMetadata();
            if (validation != null && validation.maxlength() != null) {
                return validation.maxlength().toString();
            }
            return null;
        }
        return this.getMaxlength();
    }

    public int doStartInputTag() throws JspException {
        return 2;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndInputTag() throws JspException {
        Object value = this.getSingleOverrideValue();
        if (value != null) {
            this.getAttributes().put("value", this.format(value));
        }
        this.set("maxlength", this.getEffectiveMaxlength());
        this.writeSingletonTag(this.getPageContext().getOut(), "input");
        this.getAttributes().remove("value");
        return 6;
    }
}

